/*
 * Decompiled with CFR 0.152.
 */
package SonicGolf;

import Coral.crlCanvas;
import SonicGolf.cBall;
import SonicGolf.cCanvas;
import SonicGolf.cCourse;
import SonicGolf.cFP;
import SonicGolf.cObjects;
import SonicGolf.cSprite;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

final class cPlayer {
    public static final byte MAX_PLAYERS = 3;
    public static final byte SWING_TOP_FRAME = 5;
    public static final byte SWING_HIT_FRAME = 1;
    private static final int BORED_TIMEOUT = 5000;
    private static final int POWER_SPARKLES = 5;
    public static final byte CHAR_SONIC = 0;
    public static final byte CHAR_TAILS = 1;
    public static final byte CHAR_KNUCKLES = 2;
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;
    private static int _mCnvsWidth;
    private static int _mCnvsHeight;
    public byte mMinShotPower;
    public byte mShotPower;
    public byte mShotPowerIncs;
    public int mMaxShotPower;
    public byte mSpin;
    public boolean mFacingLeft;
    public int mFPX;
    public int mFPY;
    public int mFPY0;
    public byte[] mShots = new byte[9];
    public int mTotParScore;
    public byte mShotNumber;
    public boolean mHoleFinished;
    public int mRingsThisHole;
    public int mRings;
    public int mRingsPickedUp;
    public byte mBalls;
    public byte mCharacter;
    public static long mBoredTimeout;
    public static boolean mBored;
    public int mPointsScore;
    public int mHoleParScore;
    public int mParBonus;
    public int mRingBonus;
    public int mBallsBonus;
    public int mBirdsFreed;
    public byte mRingsThisShot;
    public byte mMostRingsShot;
    public int mTotalDrives;
    public int mCurrentDrive;
    public int mLongestDrive;
    public int mAverageDrive;
    public int mTotalPutts;
    public int mCurrentPutt;
    public int mLongestPutt;
    public int mPuttSuccess;
    public int mFairwaysHit;
    public byte mChipIns;
    public byte mHolesInOne;
    public boolean mGameOver;
    private Image _mImgSwingL;
    private Image _mImgJoyR;
    private Image _mImgBoredR;
    private Image _mImgEyesR;
    private Image _mImgTailR;
    public cSprite mSprTail;
    public cSprite mSprSwing;
    public cSprite mSprJoy;
    public cSprite mSprBored;
    public cSprite[] mSprPowerSparkle = new cSprite[5];
    private Image _mImgSwingR;
    private Image _mImgJoyL;
    private Image _mImgBoredL;
    private Image _mImgEyesL;
    private Image _mImgTailL;
    public static final byte[] mFrame2to2;
    public static final byte[] mFrameIronBack;
    public static final byte[] mFrameIronFore;
    public static final byte[] mFrame0to2;
    public static final byte[] mFrame0to4;
    public static final byte[] mFrame3to3;
    public static final byte[] mFrame4to6;
    public static final byte[] mFrame4to9;
    public static final byte[] mFrame6to7;
    public static final byte[] mFrameResetSwing;
    public static final byte[] mFrameKnucklesJoy;
    public static final byte[] mFrameTailsBored;

    public cPlayer(int n, int n2) {
        _mCnvsWidth = n;
        _mCnvsHeight = n2;
        this.resetInfo();
    }

    public void init(int n) {
        this.resetInfo();
        switch (n) {
            case 0: {
                this._mImgSwingR = crlCanvas.gResourceManager.getImageByID(586384976539876L);
                this._mImgJoyL = crlCanvas.gResourceManager.getImageByID(570344609627637L);
                this._mImgBoredL = crlCanvas.gResourceManager.getImageByID(564328038324887L);
                this._mImgEyesL = crlCanvas.gResourceManager.getImageByID(568889374281534L);
                this._mImgSwingL = crlCanvas.gResourceManager.getImageByID(578051221432396L);
                this.mSprSwing = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 39, 42, 6);
                this._mImgJoyR = crlCanvas.gResourceManager.getImageByID(574188723810324L);
                this.mSprJoy = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 33, 55, 5);
                this.mSprJoy.setAnimProps(0, cObjects.mFrmStatic0, cObjects.mFrmStatic1.length, 90);
                this.mSprJoy.setAnimProps(1, cObjects.mFrmStatic1, cObjects.mFrmStatic2.length, 90);
                this.mSprJoy.setAnimProps(2, cObjects.mFrmStatic2, cObjects.mFrmStatic3.length, 90);
                this.mSprJoy.setAnimProps(3, cObjects.mFrmStatic0, cObjects.mFrmStatic0.length, 90);
                this.mSprJoy.setAnimProps(4, cObjects.mFrmStatic0, cObjects.mFrmStatic0.length, 90);
                this._mImgBoredR = crlCanvas.gResourceManager.getImageByID(566609060148133L);
                this.mSprBored = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 32, 39, 2);
                this.mSprBored.setAnimProps(0, cObjects.mFrm0to1, cObjects.mFrm0to1.length, 180);
                this.mSprBored.setAnimProps(1, cObjects.mFrmStatic1, cObjects.mFrmStatic1.length, 250);
                this._mImgEyesR = crlCanvas.gResourceManager.getImageByID(569568195423432L);
                this.mMinShotPower = (byte)18;
                this.mShotPower = (byte)18;
                this.mShotPowerIncs = (byte)13;
                this.mSpin = (byte)6;
                break;
            }
            case 1: {
                this._mImgSwingR = crlCanvas.gResourceManager.getImageByID(684973874660447L);
                this._mImgJoyL = crlCanvas.gResourceManager.getImageByID(672071837386438L);
                this._mImgBoredL = crlCanvas.gResourceManager.getImageByID(665543219477985L);
                this._mImgEyesL = crlCanvas.gResourceManager.getImageByID(670729397664157L);
                this._mImgTailL = crlCanvas.gResourceManager.getImageByID(691519981687586L);
                this._mImgSwingL = crlCanvas.gResourceManager.getImageByID(678361864642175L);
                this.mSprSwing = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 32, 35, 6);
                this._mImgJoyR = crlCanvas.gResourceManager.getImageByID(675210914390563L);
                this.mSprJoy = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 27, 31, 2);
                this.mSprJoy.setAnimProps(0, mFrame0to2, mFrame0to2.length, 250);
                this.mSprJoy.setAnimProps(1, cObjects.mFrmStatic2, cObjects.mFrmStatic2.length, 250);
                this._mImgBoredR = crlCanvas.gResourceManager.getImageByID(668136261601965L);
                this.mSprBored = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 22, 31, 1);
                this.mSprBored.setAnimProps(0, mFrameTailsBored, mFrameTailsBored.length, 250);
                this._mImgEyesR = crlCanvas.gResourceManager.getImageByID(671378858899385L);
                this._mImgTailR = crlCanvas.gResourceManager.getImageByID(694168254633750L);
                this.mSprTail = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 20, 23, 1);
                this.mSprTail.setAnimProps(0, mFrame0to4, mFrame0to4.length, 180);
                this.mSprTail.playAnim(0, true, true);
                this.mMinShotPower = (byte)13;
                this.mShotPower = (byte)13;
                this.mShotPowerIncs = (byte)15;
                this.mSpin = (byte)5;
                break;
            }
            case 2: {
                this._mImgSwingR = crlCanvas.gResourceManager.getImageByID(723309255822658L);
                this._mImgJoyL = crlCanvas.gResourceManager.getImageByID(705526354801194L);
                this._mImgBoredL = crlCanvas.gResourceManager.getImageByID(696815262806155L);
                this._mImgEyesL = crlCanvas.gResourceManager.getImageByID(703911319762468L);
                this._mImgSwingL = crlCanvas.gResourceManager.getImageByID(714590183075457L);
                this.mSprSwing = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 45, 45, 6);
                this._mImgJoyR = crlCanvas.gResourceManager.getImageByID(710035256352427L);
                this.mSprJoy = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 32, 39, 2);
                this.mSprJoy.setAnimProps(0, mFrameKnucklesJoy, mFrameKnucklesJoy.length, 180);
                this.mSprJoy.setAnimProps(1, cObjects.mFrmStatic2, cObjects.mFrmStatic2.length, 90);
                this._mImgBoredR = crlCanvas.gResourceManager.getImageByID(700301031415771L);
                this.mSprBored = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 28, 39, 2);
                this.mSprBored.setAnimProps(0, cObjects.mFrm0to3, cObjects.mFrm0to3.length, 210);
                this.mSprBored.setAnimProps(1, mFrame3to3, mFrame3to3.length, 180);
                this._mImgEyesR = crlCanvas.gResourceManager.getImageByID(704657746431210L);
                this.mMinShotPower = (byte)22;
                this.mShotPower = (byte)22;
                this.mShotPowerIncs = (byte)11;
                this.mSpin = (byte)4;
            }
        }
        this.mMaxShotPower = 30 + this.mMinShotPower + this.mShotPowerIncs * this.mShotPower;
        this.mSprSwing.setAnimProps(0, mFrameIronBack, mFrameIronBack.length, 90);
        this.mSprSwing.setAnimProps(1, mFrameIronFore, mFrameIronFore.length, 70);
        this.mSprSwing.setAnimProps(2, cObjects.mFrm1to0, cObjects.mFrm1to0.length, 90);
        this.mSprSwing.setAnimProps(3, mFrame0to2, mFrame0to2.length, 70);
        this.mSprSwing.setAnimProps(4, mFrameResetSwing, mFrameResetSwing.length, 75);
        this.mSprSwing.setAnimProps(5, mFrame2to2, mFrame2to2.length, 75);
        int n2 = 5;
        while (--n2 >= 0) {
            this.mSprPowerSparkle[n2] = new cSprite(_mCnvsWidth, _mCnvsHeight, 0, 0, 8, 8, 1);
            this.mSprPowerSparkle[n2].setAnimProps(0, cObjects.mFrm4to8, cObjects.mFrm4to8.length, 150);
        }
    }

    public void initShot(int n, int n2) {
        this.mFPX = n;
        this.mFPY = n2;
        this.mRingsThisShot = 0;
        this.mCurrentDrive = 0;
        this.mHoleFinished = false;
        this.resetBoredom();
    }

    public void initHoleComplete(int n, int n2) {
        this.mHoleFinished = true;
        this.setParScore(n, n2);
        this.setShotCompleteStats();
        this.setHoleCompleteStats();
    }

    private void setHoleCompleteStats() {
        if (this.mShotNumber == 1) {
            ++cCanvas.mTotHolesInOne;
            this.mHolesInOne = (byte)(this.mHolesInOne + 1);
        }
        if (!cBall.mPutting) {
            ++cCanvas.mTotChipIns;
            this.mChipIns = (byte)(this.mChipIns + 1);
        }
        ++this.mBirdsFreed;
        ++cCanvas.mTotBirdsFreed;
    }

    public void setShotCompleteStats() {
        if (cBall.mPutting) {
            this.mCurrentPutt = Math.abs(cFP.toInt(cBall.mFPX - cBall.mReplayFPX));
            this.mPuttSuccess = cBall.mHoled ? (this.mPuttSuccess * this.mTotalPutts + 100) / ++this.mTotalPutts : this.mPuttSuccess * this.mTotalPutts / ++this.mTotalPutts;
        } else {
            int n;
            int n2 = this.mFairwaysHit = cBall.mFairwayHit ? (this.mFairwaysHit * this.mTotalDrives + 100) / (this.mTotalDrives + 1) : this.mFairwaysHit * this.mTotalDrives / ++this.mTotalDrives;
            if (cBall.mFairwayHit) {
                this.mCurrentDrive = Math.abs(cFP.toInt(cBall.mFPX - cBall.mReplayFPX));
                n = (this.mAverageDrive * this.mTotalDrives + this.mCurrentDrive) / ++this.mTotalDrives;
            } else {
                n = this.mAverageDrive;
            }
            this.mAverageDrive = n;
        }
        this.mMostRingsShot = this.mRingsThisShot > this.mMostRingsShot ? this.mRingsThisShot : this.mMostRingsShot;
        cCanvas.mBestRingsShot = this.mRingsThisShot > cCanvas.mBestRingsShot ? this.mRingsThisShot : cCanvas.mBestRingsShot;
        this.mLongestDrive = this.mCurrentDrive > this.mLongestDrive ? this.mCurrentDrive : this.mLongestDrive;
        cCanvas.mBestLongestDrive = this.mCurrentDrive > cCanvas.mBestLongestDrive ? this.mCurrentDrive : cCanvas.mBestLongestDrive;
        this.mLongestPutt = this.mCurrentPutt > this.mLongestPutt ? this.mCurrentPutt : this.mLongestPutt;
        cCanvas.mBestLongestPutt = this.mCurrentPutt > cCanvas.mBestLongestPutt ? this.mCurrentPutt : cCanvas.mBestLongestPutt;
    }

    public void setParScore(int n, int n2) {
        this.mShots[n] = this.mShotNumber;
        this.mTotParScore += this.mShotNumber - n2;
        if (this.mTotParScore <= -100) {
            this.mTotParScore = -99;
        } else if (this.mTotParScore >= 100) {
            this.mTotParScore = 99;
        }
    }

    private void resetInfo() {
        int n = 9;
        while (--n >= 0) {
            this.mShots[n] = 0;
        }
        this.mTotParScore = 0;
        this.mPointsScore = 0;
        this.mRingsThisHole = 0;
        this.mRings = 0;
        this.mRingsPickedUp = 0;
        this.mShotNumber = 1;
        this.mParBonus = 0;
        this.mRingBonus = 0;
        this.mBallsBonus = 0;
        this.mBirdsFreed = 0;
        this.mMostRingsShot = 0;
        this.mTotalDrives = 0;
        this.mLongestDrive = 0;
        this.mAverageDrive = 0;
        this.mLongestPutt = 0;
        this.mPuttSuccess = 0;
        this.mFairwaysHit = 0;
        this.mChipIns = 0;
        this.mHolesInOne = 0;
        this.mTotalPutts = 0;
        this.mBalls = (byte)9;
        this.mGameOver = false;
    }

    public int checkProgress(boolean bl) {
        int n = 0;
        int n2 = this.mRings - this.mRingsThisHole;
        int n3 = 0;
        while (this.mRings - this.mRingsThisHole < n) {
            n -= 50;
            ++n3;
            n2 += 50;
        }
        if (cObjects.mSprExtraBallBox != null && cObjects.mSprExtraBallBox.getCurrAnim() == 1) {
            ++n3;
        }
        if (bl) {
            this.mRingsPickedUp -= this.mRingsThisHole;
            this.mRings = n2;
            this.mBalls = (byte)(this.mBalls - n3);
        }
        return n3;
    }

    public void pickupRings(int n) {
        this.mRingsThisHole += n;
        this.mRings += n;
        this.mRingsThisShot = (byte)(this.mRingsThisShot + n);
        this.mRingsPickedUp += n;
        if (this.mRings >= 50) {
            this.mBalls = (byte)(this.mBalls + 1);
            this.mRings -= 50;
        }
    }

    public boolean clockScore(boolean bl) {
        boolean bl2 = true;
        if (bl) {
            this.mPointsScore += this.mParBonus > 0 ? this.mParBonus : 0;
            this.mPointsScore += this.mRingBonus > 0 ? this.mRingBonus : 0;
            this.mPointsScore += this.mBallsBonus > 0 ? this.mBallsBonus : 0;
            this.mBallsBonus = 0;
            this.mParBonus = 0;
            this.mRingBonus = 0;
        } else if (this.mParBonus > 0) {
            this.mParBonus -= 1000;
            this.mPointsScore += 1000;
            bl2 = false;
        } else if (this.mRingBonus > 0) {
            this.mRingBonus -= 250;
            this.mPointsScore += 250;
            bl2 = false;
        } else if (this.mBallsBonus > 0) {
            this.mBallsBonus -= 100;
            this.mPointsScore += 100;
            bl2 = false;
        }
        return bl2;
    }

    public void update() {
        if (cCanvas.mGameLoopState == 2 || cCanvas.mGameLoopState == 3) {
            this.checkPlayerBoredom();
        }
        if (cCanvas.mGameLoopState != 9 && cCanvas.mGameLoopState != 10 && this.mSprSwing != null) {
            this.mSprSwing.updateAnim();
        } else if (this.mSprJoy != null) {
            this.mSprJoy.updateAnim();
        }
        if (this.mSprBored != null) {
            this.mSprBored.updateAnim();
        }
        if (this.mCharacter == 1 && this.mSprTail != null) {
            this.mSprTail.updateAnim();
        }
        int n = 5;
        while (--n >= 0) {
            if (!this.mSprPowerSparkle[n].mVisible) continue;
            this.mSprPowerSparkle[n].updateAnim();
            if (this.mSprPowerSparkle[n].getCurrFrame() == this.mSprPowerSparkle[n].getEndFrame(0)) {
                this.mSprPowerSparkle[n].mVisible = false;
                continue;
            }
            if (n >= 4 || this.mSprPowerSparkle[n + 1].mVisible) continue;
            this.mSprPowerSparkle[n + 1].playAnim(0, true, true);
            this.mSprPowerSparkle[n + 1].mVisible = true;
        }
    }

    public void render(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4 = 1;
        boolean bl = false;
        int n5 = this.mSprSwing.mFrameWidth;
        int n6 = this.mSprSwing.mFrameHeight;
        int n7 = cFP.toInt(this.mFPX + cCourse.mFPX);
        int n8 = cFP.toInt(this.mFPY + cCourse.mFPY);
        if (cBall.mFPAngle > 368640) {
            bl = true;
            n5 -= 8 * n4;
        } else {
            n5 += 8 * n4;
        }
        if (this.mCharacter == 1) {
            n3 = bl ? -3 * n4 : -25 * n4;
            n2 = 0;
            if (cCanvas.mPowerUp) {
                if (this.mSprSwing.getCurrFrame() == 3) {
                    n3 += bl ? 2 * n4 : -2 * n4;
                    n2 = -1 * n4;
                } else if (this.mSprSwing.getCurrFrame() == 4) {
                    n3 += bl ? 4 * n4 : -4 * n4;
                    n2 = -2 * n4;
                } else if (this.mSprSwing.getCurrFrame() == 5) {
                    n3 -= bl ? 2 * n4 : -2 * n4;
                    n2 = -1 * n4;
                }
            } else if (mBored || this.mSprBored.getCurrAnim() == 1) {
                n3 += bl ? 2 * n4 : -2 * n4;
            }
            if (bl) {
                this.mSprTail.render(graphics, this._mImgTailL, n7 - (n5 >> 1) + 20 + n3, n8 - n6 + 10 + n2, !bl ? (byte)1 : 0);
            } else {
                this.mSprTail.render(graphics, this._mImgTailR, n7 - (n5 >> 1) + 20 + n3, n8 - n6 + 10 + n2, !bl ? (byte)1 : 0);
            }
        }
        if (mBored || this.mSprBored.getCurrAnim() == 1) {
            n3 = n7 - (this.mSprBored.mFrameWidth >> 1);
            if (this.mCharacter == 1) {
                n3 += bl ? 6 * n4 : -6 * n4;
            }
            if (this.mCharacter != 0 && this.mSprSwing.getCurrAnim() == 5) {
                if (bl) {
                    this.mSprSwing.render(graphics, this._mImgSwingL, n7 - (n5 >> 1), n8 - n6 - 1, bl ? (byte)1 : 0);
                } else {
                    this.mSprSwing.render(graphics, this._mImgSwingR, n7 - (n5 >> 1), n8 - n6 - 1, bl ? (byte)1 : 0);
                }
                this.mSprSwing.playAnim(0, false, false);
            } else {
                if (!bl) {
                    this.mSprBored.render(graphics, this._mImgBoredR, n3, n8 - this.mSprBored.mFrameHeight - 1, !bl ? (byte)1 : 0);
                } else {
                    this.mSprBored.render(graphics, this._mImgBoredL, n3, n8 - this.mSprBored.mFrameHeight - 1, !bl ? (byte)1 : 0);
                }
                if (this.mCharacter != 2) {
                    this.mSprBored.playAnim(0, true, true);
                }
                return;
            }
        }
        if (cCanvas.mGameLoopState != 9 && cCanvas.mGameLoopState != 10 && cCanvas.mGameLoopState != 12 || this.mSprJoy.getCurrAnim() == 3) {
            if (bl) {
                this.mSprSwing.render(graphics, this._mImgSwingL, n7 - (n5 >> 1), n8 - n6 - 1, bl ? (byte)1 : 0);
            } else {
                this.mSprSwing.render(graphics, this._mImgSwingR, n7 - (n5 >> 1), n8 - n6 - 1, bl ? (byte)1 : 0);
            }
            if (!cCanvas.mPowerUp && this.mSprSwing.getCurrFrame() == 1) {
                n3 = 13;
                n2 = 7;
                n = 13;
                int n9 = 13;
                int n10 = 10;
                if (this.mCharacter == 1) {
                    n3 = 10;
                    n = 11;
                    n9 = 11;
                    n10 = 9;
                } else if (this.mCharacter == 2) {
                    n3 = 15;
                    n2 = 6;
                    n = 15;
                    n9 = 15;
                    n10 = 10;
                }
                if (cCanvas.mFrameCount % 28 == 19 || cCanvas.mFrameCount % 28 == 0) {
                    cCanvas.renderImage(graphics, this._mImgEyesR, 0, 0, n3, n2, n7 - (n5 >> 1) + (bl ? n9 : n), n8 - n6 + n10);
                } else if (cCanvas.mFrameCount % 28 >= 20) {
                    if (bl) {
                        cCanvas.renderImage(graphics, this._mImgEyesL, 0, 0, n3, n2, n7 - (n5 >> 1) + n9, n8 - n6 + n10);
                    } else {
                        cCanvas.renderImage(graphics, this._mImgEyesR, n3, 0, n3, n2, n7 - (n5 >> 1) + n, n8 - n6 + n10);
                    }
                }
            }
        } else if (cCanvas.mPlayer[cCanvas.mCurrPlayerID].mShotNumber - cCourse.mPar[cCanvas.mCurrHoleID - 1] <= 0) {
            if (this.mCharacter == 0) {
                if (this.mSprJoy.getCurrAnim() == 4 && cObjects.mSprHoleFlag.getCurrAnim() != 0) {
                    if (cCanvas.mFrameCount % 4 == 0) {
                        this.mSprJoy.restartAnim(0, false, false);
                    }
                } else if (this.mSprJoy.getCurrAnim() == 0) {
                    this.mFPY = this.mFPY >= this.mFPY0 - cFP.FP_12 * n4 ? (this.mFPY -= cFP.FP_6 * n4) : (this.mFPY -= 16384 * n4);
                    if (this.mFPY < this.mFPY0 - cFP.FP_16 * n4) {
                        this.mSprJoy.restartAnim(1, false, false);
                    }
                } else if (this.mSprJoy.getCurrAnim() == 1) {
                    this.mFPY = this.mFPY >= this.mFPY0 - cFP.FP_12 * n4 ? (this.mFPY += cFP.FP_6 * n4) : (this.mFPY += 16384 * n4);
                    if (this.mFPY >= this.mFPY0) {
                        this.mFPY = this.mFPY0;
                        this.mSprJoy.restartAnim(2, false, false);
                    }
                }
            } else if (this.mSprJoy.getCurrFrame() == this.mSprJoy.getEndFrame(0)) {
                this.mSprJoy.playAnim(1, false, true);
            } else {
                this.mSprJoy.playAnim(0, true, true);
            }
            n6 = this.mSprJoy.mFrameHeight;
            if (!bl) {
                this.mSprJoy.render(graphics, this._mImgJoyR, n7 - (this.mSprJoy.mFrameWidth >> 1), n8 - n6 - 1, !bl ? (byte)1 : 0);
            } else {
                this.mSprJoy.render(graphics, this._mImgJoyL, n7 - (this.mSprJoy.mFrameWidth >> 1), n8 - n6 - 1, !bl ? (byte)1 : 0);
            }
        } else {
            n3 = n7 - (this.mSprBored.mFrameWidth >> 1);
            if (this.mCharacter == 1) {
                n3 += bl ? 6 * n4 : -6 * n4;
            }
            this.mSprBored.restartAnim(0, true, false);
            if (this.mCharacter == 2) {
                if (bl) {
                    this.mSprSwing.render(graphics, this._mImgSwingL, n7 - (n5 >> 1), n8 - n6 - 1, bl ? (byte)1 : 0);
                } else {
                    this.mSprSwing.render(graphics, this._mImgSwingR, n7 - (n5 >> 1), n8 - n6 - 1, bl ? (byte)1 : 0);
                }
            } else {
                this.mSprBored.render(graphics, this._mImgBoredR, n3, n8 - this.mSprBored.mFrameHeight - 1 * n4, !bl ? (byte)1 : 0);
            }
        }
        Image image = crlCanvas.gResourceManager.getImageByID(644171744088952L);
        n = 5;
        while (--n >= 0) {
            if (!this.mSprPowerSparkle[n].mVisible) continue;
            n3 = bl ? 1 : -1;
            switch (n) {
                case 0: {
                    this.mSprPowerSparkle[n].render(graphics, image, n7 + 20 * n3 * n4, n8 + 15 * n4 - n6);
                    break;
                }
                case 1: {
                    this.mSprPowerSparkle[n].render(graphics, image, n7 + 17 * n3 * n4, n8 + 28 * n4 - n6);
                    break;
                }
                case 2: {
                    this.mSprPowerSparkle[n].render(graphics, image, n7, n8 + 30 - n6);
                    break;
                }
                case 3: {
                    this.mSprPowerSparkle[n].render(graphics, image, n7 - 17 * n3 * n4, n8 + 28 * n4 - n6);
                    break;
                }
                case 4: {
                    this.mSprPowerSparkle[n].render(graphics, image, n7 - 20 * n3 * n4, n8 + 15 * n4 - n6);
                }
            }
        }
    }

    public void resetBoredom() {
        mBoredTimeout = System.currentTimeMillis() + 5000L;
        if (mBored) {
            if (this.mCharacter == 0) {
                this.mSprBored.playAnim(1, false, true);
            } else {
                this.mSprBored.playAnim(0, true, true);
            }
            mBored = false;
        }
    }

    private void checkPlayerBoredom() {
        if (this.mSprSwing.getCurrFrame() == 1) {
            if (System.currentTimeMillis() > mBoredTimeout) {
                if (!mBored) {
                    if (this.mCharacter == 0) {
                        this.mSprBored.playAnim(1, false, true);
                    } else if (this.mCharacter == 2) {
                        this.mSprBored.restartAnim(0, true, false);
                    } else {
                        this.mSprSwing.playAnim(5, false, false);
                    }
                    mBored = true;
                } else if (this.mSprBored.getCurrAnim() == 1 && this.mCharacter != 2) {
                    if (this.mCharacter == 1) {
                        this.mSprBored.restartAnim(0, true, true);
                    } else {
                        this.mSprBored.playAnim(0, true, true);
                    }
                }
            }
        } else {
            this.resetBoredom();
        }
    }

    public void close() {
        this.mSprSwing = null;
        this._mImgSwingL = null;
        this._mImgJoyR = null;
        this.mSprJoy = null;
        this._mImgBoredR = null;
        this._mImgEyesR = null;
        this._mImgTailR = null;
        this._mImgSwingR = null;
        this._mImgJoyL = null;
        this._mImgBoredL = null;
        this._mImgEyesL = null;
        this._mImgTailL = null;
    }

    static {
        mFrame2to2 = new byte[]{2, 2};
        mFrameIronBack = new byte[]{1, 0, 6, 5};
        mFrameIronFore = new byte[]{6, 0, 1, 2, 3, 4};
        mFrame0to2 = new byte[]{0, 1, 2};
        mFrame0to4 = new byte[]{0, 1, 2, 3, 4};
        mFrame3to3 = new byte[]{3, 3};
        mFrame4to6 = new byte[]{4, 5, 6};
        mFrame4to9 = new byte[]{4, 5, 6, 7, 8, 9};
        mFrame6to7 = new byte[]{6, 7};
        mFrameResetSwing = new byte[]{6, 0, 1};
        mFrameKnucklesJoy = new byte[]{1, 0, 1, 2};
        mFrameTailsBored = new byte[]{0, 1, 2, 3, 2, 3, 2, 1, 0};
    }
}

