/*
 * Decompiled with CFR 0.152.
 */
package SonicGolf;

import Coral.Util.crlBinArray;
import Coral.crlCanvas;
import SonicGolf.cBall;
import SonicGolf.cCanvas;
import SonicGolf.cFP;
import SonicGolf.cObjects;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

final class cCourse {
    static final int MBOOSTER_MAX_INSTANCES = 1;
    public static final byte MAX_COURSES = 3;
    public static final byte MAX_HOLES = 9;
    public static final byte MAX_SHOTS_ALLOWED = 5;
    private static final byte MAX_PAN_MARKERS = 9;
    public static final byte HOLE_RADIUS = 4;
    public static final byte TILE_SIZE = 16;
    public static final byte TILE_SIZE_RBS = 4;
    public static final byte CENTRE_X_MARGIN = 20;
    public static final byte CENTRE_BOT_MARGIN = 60;
    public static final byte CENTRE_TOP_MARGIN = 80;
    private static final byte EXTRA_TOP_ROWS = 7;
    private static final byte EXTRA_BOTTOM_ROWS = 4;
    public static final byte TILE_EMPTY = 0;
    public static final byte TILE_BLOCK = 1;
    public static final byte TILE_ROLL_RIGHT_1_1 = 2;
    public static final byte TILE_ROLL_LEFT_1_1 = 3;
    public static final byte TILE_WATER = 4;
    public static final byte TILE_BUNKER = 5;
    public static final byte TILE_HOLE = 6;
    public static final byte TILE_GREEN = 7;
    public static final byte TILE_ROLL_LEFT_1_2 = 8;
    public static final byte TILE_ROLL_LEFT_2_2 = 9;
    public static final byte TILE_ROLL_RIGHT_1_2 = 10;
    public static final byte TILE_ROLL_RIGHT_2_2 = 11;
    public static final byte TILE_ROLL_LEFT_1_3 = 12;
    public static final byte TILE_ROLL_LEFT_2_3 = 13;
    public static final byte TILE_ROLL_LEFT_3_3 = 14;
    public static final byte TILE_ROLL_RIGHT_1_3 = 15;
    public static final byte TILE_ROLL_RIGHT_2_3 = 16;
    public static final byte TILE_ROLL_RIGHT_3_3 = 17;
    public static final byte TILE_CEIL_LEFT_SLOPE = 18;
    public static final byte TILE_CEIL_RIGHT_SLOPE = 19;
    public static final byte TILE_ROLL_LEFT_STEEP_1 = 20;
    public static final byte TILE_ROLL_LEFT_STEEP_2 = 21;
    public static final byte TILE_ROLL_RIGHT_STEEP_1 = 22;
    public static final byte TILE_ROLL_RIGHT_STEEP_2 = 23;
    public static final byte TILE_SPIKES = 24;
    public static final byte TILE_BREAKABLE = 25;
    public static final byte TILE_BRIDGE = 26;
    public static final byte GREEN_HILL = 0;
    public static final byte MARBLE = 1;
    public static final byte SPRING_YARD = 2;
    private static cCanvas _mCanvas;
    public static int mScrWidth;
    public static int mScrHeight;
    public static int mFPX;
    public static int mFPY;
    public static int mFPDX;
    public static int mFPDY;
    public static int mTotRows;
    public static int mTotCols;
    private static int _mStartRow;
    private static int _mStartCol;
    private static byte _mVisibleRows;
    private static byte _mVisibleCols;
    private static byte _mTotColsInImage;
    public static int mWidth;
    public static int mHeight;
    private static int _mFPXLeftEnd;
    private static int _mFPYTopEnd;
    private static int _mFPXLeft;
    private static int _mFPXRight;
    private static int _mFPYTop;
    private static int _mFPYBottom;
    public static byte[][] mTiles;
    public static byte[][] mCollisionInfo;
    public static int mBallStartFPX;
    public static int mBallStartFPY;
    public static int mFPHoleX;
    public static int mFPHoleY;
    public static byte[] mPar;
    public static cObjects.cMarker[] mPanMarkers;
    private static Image _mImgTiles;
    private static byte _mCourseID;
    private static int _mCloudMover;
    private static final int[] _mZoneBGColTable;
    private static final byte[][] _mRates;
    private static final byte[][][][] _mZoneSets;
    private static Image _mImgPTiles;

    cCourse() {
    }

    public static void open(cCanvas cCanvas2) {
        _mCanvas = cCanvas2;
        mScrHeight = _mCanvas.getHeight();
        mScrWidth = _mCanvas.getWidth();
        _mVisibleRows = (byte)(mScrHeight / 16 + 2);
        _mVisibleCols = (byte)(mScrWidth / 16 + 2);
        _mFPXLeft = cFP.toFP(20);
        _mFPXRight = cFP.toFP(mScrWidth - 20);
        _mFPYTop = cFP.toFP(80);
        _mFPYBottom = cFP.toFP(mScrHeight - 60);
    }

    public static void loadGraphics(int n) {
        switch (n) {
            case 0: {
                _mImgTiles = crlCanvas.gResourceManager.getImageByID(149893289259349L);
                break;
            }
            case 1: {
                _mImgTiles = crlCanvas.gResourceManager.getImageByID(221758786739014L);
                break;
            }
            case 2: {
                _mImgTiles = crlCanvas.gResourceManager.getImageByID(312211025991761L);
            }
        }
        _mTotColsInImage = (byte)64;
    }

    private static void replaceBGTile(int n, int n2) {
        if (cCanvas.mCurrCourseID == 2 && (mTiles[n][n2 - 1] == 76 || mTiles[n - 1][n2] == 76)) {
            cCourse.mTiles[n][n2] = 76;
        }
    }

    public static void removeBrokenBlocks() {
        int n;
        int n2 = cFP.toInt(cBall.mFPY) / 16;
        if (mCollisionInfo[n2][n = cFP.toInt(cBall.mFPX) / 16] == 25) {
            int n3 = n;
            do {
                int n4 = n2;
                while (mCollisionInfo[n4][n3] == 25) {
                    cCourse.mCollisionInfo[n4][n3] = 0;
                    cCourse.mTiles[n4--][n3] = 0;
                }
            } while (mCollisionInfo[n2][n3 += cBall.mReplayFPX >= cBall.mFPX ? 1 : -1] == 25);
        }
    }

    public static void loadMap(crlBinArray crlBinArray2) {
        int n = 7;
        int n2 = 4;
        if (cCanvas.mCurrCourseID == 2) {
            n = 0;
            n2 = 0;
        }
        try {
            int n3;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(crlBinArray2.getArray(), crlBinArray2.getOffset(), crlBinArray2.getLength());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            mTotRows = dataInputStream.readByte();
            mTotCols = dataInputStream.readByte();
            mTotRows = mTotRows < 0 ? mTotRows + 256 + n + n2 : mTotRows + n + n2;
            mTotCols = mTotCols < 0 ? mTotCols + 256 : mTotCols;
            mTiles = new byte[mTotRows][mTotCols];
            mCollisionInfo = new byte[mTotRows][mTotCols];
            byte by = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            mPanMarkers = new cObjects.cMarker[9];
            int n15 = 9;
            while (--n15 >= 0) {
                cCourse.mPanMarkers[n15] = new cObjects.cMarker();
                cCourse.mPanMarkers[n15].mActive = false;
            }
            n15 = 0;
            int n16 = 0;
            cCourse.mTiles[n15][n16] = by = dataInputStream.readByte();
            cCourse.mCollisionInfo[n15][n16] = 1;
            byte by2 = mCollisionInfo[n15][n16++];
            byte by3 = by;
            boolean bl = true;
            cObjects.mSprRobotnik.mVisible = false;
            block49: while (bl) {
                by = dataInputStream.readByte();
                if (by < 0) {
                    for (n3 = 0; n3 < 128 + by; ++n3) {
                        int n17;
                        cCourse.mTiles[n15][n16] = by3;
                        cCourse.mCollisionInfo[n15][n16] = by2;
                        if (by3 == 108) {
                            cObjects.mSprRings[n4].mX = n16 * 16;
                            cObjects.mSprRings[n4].mY = n15 * 16;
                            if (!cCanvas.mLoadingGame) {
                                cObjects.mSprRings[n4].mVisible = true;
                            }
                            ++n4;
                            cCourse.replaceBGTile(n15, n16);
                        }
                        if (++n16 < mTotCols) continue;
                        n16 = 0;
                        if (n15 == 0) {
                            while (++n15 <= n) {
                                for (n17 = 0; n17 < mTotCols; ++n17) {
                                    cCourse.mTiles[n15][n17] = mTiles[0][n17];
                                    cCourse.mCollisionInfo[n15][n17] = mCollisionInfo[0][n17];
                                }
                            }
                            continue;
                        }
                        if (++n15 < mTotRows - n2) continue;
                        while (n15 < mTotRows) {
                            for (n17 = 0; n17 < mTotCols; ++n17) {
                                cCourse.mTiles[n15][n17] = mTiles[mTotRows - n2 - 1][n17];
                                cCourse.mCollisionInfo[n15][n17] = mCollisionInfo[mTotRows - n2 - 1][n17];
                            }
                            ++n15;
                        }
                        bl = false;
                        continue block49;
                    }
                    continue;
                }
                cCourse.mTiles[n15][n16] = by;
                cCourse.mCollisionInfo[n15][n16] = 0;
                switch (by) {
                    case 110: {
                        if (cCanvas.mDifficulty != 0) {
                            cObjects.mSprEnemies[n12].mX = n16 * 16;
                            cObjects.mSprEnemies[n12].mY = n15 * 16;
                            if (!cCanvas.mLoadingGame) {
                                cObjects.mSprEnemies[n12].mVisible = true;
                            }
                            if (cCanvas.mCurrCourseID == 0) {
                                cObjects.mSprEnemies[n12].mX -= 8;
                                cCourse.mTiles[n15][n16] = 1;
                                cCourse.mCollisionInfo[n15][n16] = 4;
                                int n18 = n12;
                                int n19 = n12;
                                n12 = (byte)(n12 + 1);
                                cObjects.mFishY[n18] = cObjects.mSprEnemies[n19].mY;
                                break;
                            }
                            if (cCanvas.mCurrCourseID == 1) {
                                cObjects.mSprEnemies[n12].mX -= 10;
                                cObjects.mEnemyY[n12] = cObjects.mSprEnemies[n12].mY;
                            } else {
                                cObjects.mEnemyY[n12] = 0;
                            }
                            int n20 = n12;
                            int n21 = n12;
                            n12 = (byte)(n12 + 1);
                            cObjects.mEnemyX[n20] = cObjects.mSprEnemies[n21].mX;
                            cCourse.replaceBGTile(n15, n16);
                            break;
                        }
                        if (cCanvas.mCurrCourseID == 0) {
                            cCourse.mTiles[n15][n16] = 1;
                            cCourse.mCollisionInfo[n15][n16] = 4;
                            break;
                        }
                        cCourse.replaceBGTile(n15, n16);
                        break;
                    }
                    case 1: 
                    case 96: 
                    case 98: {
                        cCourse.mCollisionInfo[n15][n16] = 4;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        cCourse.mCollisionInfo[n15][n16] = 5;
                        break;
                    }
                    case 111: {
                        cObjects.mSprSprings[n6].mX = n16 * 16;
                        cObjects.mSprSprings[n6].mY = n15 * 16;
                        int n22 = n6;
                        n6 = (byte)(n6 + 1);
                        cObjects.mSprSprings[n22].mVisible = true;
                        cCourse.mCollisionInfo[n15][n16] = 1;
                        if (cCanvas.mCurrCourseID == 2) {
                            cCourse.mTiles[n15][n16] = 9;
                            break;
                        }
                        cCourse.mTiles[n15][n16] = 6;
                        break;
                    }
                    case 6: 
                    case 8: {
                        if (cCanvas.mCurrCourseID == 2) {
                            cCourse.mCollisionInfo[n15][n16] = 7;
                            break;
                        }
                    }
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: 
                    case 16: 
                    case 17: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 30: 
                    case 36: 
                    case 37: 
                    case 40: {
                        cCourse.mCollisionInfo[n15][n16] = 1;
                        break;
                    }
                    case 22: 
                    case 24: 
                    case 39: {
                        if (cCanvas.mCurrCourseID == 1) break;
                    }
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 90: 
                    case 91: {
                        cCourse.mCollisionInfo[n15][n16] = 1;
                        break;
                    }
                    case 23: {
                        if (cCanvas.mCurrCourseID == 1) break;
                        cCourse.mCollisionInfo[n15][n16] = 18;
                        break;
                    }
                    case 38: {
                        if (cCanvas.mCurrCourseID == 1) break;
                        cCourse.mCollisionInfo[n15][n16] = 19;
                        break;
                    }
                    case 113: {
                        cObjects.mSprSprings45R[n14].mX = n16 * 16 - 11;
                        cObjects.mSprSprings45R[n14].mY = n15 * 16;
                        int n23 = n14;
                        n14 = (byte)(n14 + 1);
                        cObjects.mSprSprings45R[n23].mVisible = true;
                        cCourse.mTiles[n15][n16] = cCanvas.mCurrCourseID == 2 && (mTiles[n15][n16 - 1] == 76 || mTiles[n15 - 1][n16] == 76) ? 15 : 25;
                    }
                    case 25: {
                        cCourse.mCollisionInfo[n15][n16] = 2;
                        break;
                    }
                    case 112: {
                        cObjects.mSprSprings45L[n13].mX = n16 * 16 - 10;
                        cObjects.mSprSprings45L[n13].mY = n15 * 16;
                        int n24 = n13;
                        n13 = (byte)(n13 + 1);
                        cObjects.mSprSprings45L[n24].mVisible = true;
                        cCourse.mTiles[n15][n16] = cCanvas.mCurrCourseID == 2 && (mTiles[n15][n16 - 1] == 76 || mTiles[n15 - 1][n16] == 76) ? 14 : 21;
                    }
                    case 21: {
                        cCourse.mCollisionInfo[n15][n16] = 3;
                        break;
                    }
                    case 7: {
                        cCourse.mCollisionInfo[n15][n16] = 7;
                        break;
                    }
                    case 5: {
                        cCourse.mCollisionInfo[n15][n16] = 6;
                        mFPHoleX = n16 * cFP.toFP(16) + cFP.toFP(8);
                        mFPHoleY = n15 * cFP.toFP(16) + cFP.toFP(2);
                        cObjects.mSprHoleFlag.mX = cFP.toInt(mFPHoleX) - 24;
                        cObjects.mSprHoleFlag.mY = cFP.toInt(mFPHoleY) - 52 - 2;
                        break;
                    }
                    case 28: {
                        cCourse.mCollisionInfo[n15][n16] = 8;
                        break;
                    }
                    case 29: {
                        cCourse.mCollisionInfo[n15][n16] = 9;
                        break;
                    }
                    case 31: {
                        cCourse.mCollisionInfo[n15][n16] = 11;
                        break;
                    }
                    case 32: {
                        cCourse.mCollisionInfo[n15][n16] = 10;
                        break;
                    }
                    case 33: {
                        if (cCanvas.mCurrCourseID == 2) {
                            cCourse.mCollisionInfo[n15][n16] = 18;
                            break;
                        }
                        cCourse.mCollisionInfo[n15][n16] = 12;
                        break;
                    }
                    case 34: {
                        if (cCanvas.mCurrCourseID == 2) {
                            cCourse.mCollisionInfo[n15][n16] = 18;
                            break;
                        }
                        cCourse.mCollisionInfo[n15][n16] = 13;
                        break;
                    }
                    case 35: {
                        if (cCanvas.mCurrCourseID == 2) {
                            cCourse.mCollisionInfo[n15][n16] = 1;
                            break;
                        }
                        cCourse.mCollisionInfo[n15][n16] = 14;
                        break;
                    }
                    case 41: {
                        if (cCanvas.mCurrCourseID == 2) {
                            cCourse.mCollisionInfo[n15][n16] = 19;
                            break;
                        }
                        cCourse.mCollisionInfo[n15][n16] = 17;
                        break;
                    }
                    case 42: {
                        if (cCanvas.mCurrCourseID == 2) {
                            cCourse.mCollisionInfo[n15][n16] = 19;
                            break;
                        }
                        cCourse.mCollisionInfo[n15][n16] = 16;
                        break;
                    }
                    case 43: {
                        if (cCanvas.mCurrCourseID == 2) {
                            cCourse.mCollisionInfo[n15][n16] = 1;
                            break;
                        }
                        cCourse.mCollisionInfo[n15][n16] = 15;
                        break;
                    }
                    case 14: {
                        if (cCanvas.mCurrCourseID == 1) {
                            cCourse.mCollisionInfo[n15][n16] = 1;
                            break;
                        }
                        if (cCanvas.mCurrCourseID == 2) {
                            cCourse.mCollisionInfo[n15][n16] = 3;
                            break;
                        }
                        cCourse.mCollisionInfo[n15][n16] = 21;
                        break;
                    }
                    case 18: {
                        if (cCanvas.mCurrCourseID == 1) {
                            cCourse.mCollisionInfo[n15][n16] = 1;
                            break;
                        }
                        cCourse.mCollisionInfo[n15][n16] = 20;
                        break;
                    }
                    case 15: {
                        if (cCanvas.mCurrCourseID == 1) {
                            cCourse.mCollisionInfo[n15][n16] = 1;
                            break;
                        }
                        if (cCanvas.mCurrCourseID == 2) {
                            cCourse.mCollisionInfo[n15][n16] = 2;
                            break;
                        }
                        cCourse.mCollisionInfo[n15][n16] = 23;
                        break;
                    }
                    case 20: {
                        if (cCanvas.mCurrCourseID == 1) {
                            cCourse.mCollisionInfo[n15][n16] = 0;
                            break;
                        }
                        cCourse.mCollisionInfo[n15][n16] = 22;
                        break;
                    }
                    case 94: {
                        if (cCanvas.mCurrCourseID == 0) {
                            cCourse.mCollisionInfo[n15][n16] = 26;
                            break;
                        }
                    }
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 92: 
                    case 93: 
                    case 95: {
                        if (cCanvas.mCurrCourseID != 2) break;
                        cCourse.mCollisionInfo[n15][n16] = 1;
                        break;
                    }
                    case 99: 
                    case 100: {
                        cCourse.mCollisionInfo[n15][n16] = 24;
                        break;
                    }
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: {
                        cCourse.mCollisionInfo[n15][n16] = 25;
                        break;
                    }
                    case 106: {
                        cObjects.mWaterMarker[n10].mX = n16 * 16 + 8;
                        cObjects.mWaterMarker[n10].mY = (n15 + 2) * 16 - 2;
                        int n25 = n10;
                        n10 = (byte)(n10 + 1);
                        cObjects.mWaterMarker[n25].mActive = true;
                        cCourse.replaceBGTile(n15, n16);
                        break;
                    }
                    case 107: {
                        cObjects.mSpikeMarker[n11].mX = n16 * 16 + 8;
                        cObjects.mSpikeMarker[n11].mY = (n15 + 1) * 16 - 2;
                        int n26 = n11;
                        n11 = (byte)(n11 + 1);
                        cObjects.mSpikeMarker[n26].mActive = true;
                        cCourse.replaceBGTile(n15, n16);
                        break;
                    }
                    case 108: {
                        cObjects.mSprRings[n4].mX = n16 * 16;
                        cObjects.mSprRings[n4].mY = n15 * 16;
                        if (!cCanvas.mLoadingGame) {
                            cObjects.mSprRings[n4].mVisible = true;
                        }
                        ++n4;
                        cCourse.replaceBGTile(n15, n16);
                        break;
                    }
                    case 109: {
                        mBallStartFPX = n16 * cFP.toFP(16) + cFP.toFP(8);
                        mBallStartFPY = (n15 + 1) * cFP.toFP(16) - cFP.toFP(3);
                        cCourse.replaceBGTile(n15, n16);
                        break;
                    }
                    case 114: {
                        cObjects.mSprRingBoxes[n5].mX = n16 * 16 - 4;
                        cObjects.mSprRingBoxes[n5].mY = (n15 + 1) * 16 - 6;
                        if (cCanvas.mLoadingGame && !cObjects.mSprRingBoxes[n5].mVisible) {
                            cObjects.mSprRingBoxes[n5].mY += 11;
                            cObjects.mSprRingBoxes[n5].mFrameHeight = 11;
                            cObjects.mSprRingBoxes[n5].playAnim(1, true, false);
                        }
                        int n27 = n5;
                        n5 = (byte)(n5 + 1);
                        cObjects.mSprRingBoxes[n27].mVisible = true;
                        cCourse.replaceBGTile(n15, n16);
                        break;
                    }
                    case 115: {
                        if (cCanvas.mCurrHoleID == 9) {
                            cObjects.mSprRobotnik.mX = n16 * 16;
                            cObjects.mSprRobotnik.mY = n15 * 16;
                            cObjects.mRobotnikMinY = (n15 + 2) * 16;
                            cObjects.mRobotnikMaxY = (n15 - 3) * 16 - 8;
                            cObjects.mSprRobotnik.mVisible = true;
                            break;
                        }
                        if (cCanvas.mDifficulty != 0) {
                            if (cCanvas.mCurrCourseID == 2) {
                                cObjects.mBlockSpikeMove[n8] = 0;
                                cObjects.mBlockSpikeX[n8] = n16 * 16;
                                int n28 = n8;
                                n8 = (byte)(n8 + 1);
                                cObjects.mBlockSpikeY[n28] = n15 * 16;
                                cCourse.replaceBGTile(n15, n16);
                                break;
                            }
                            if (cCanvas.mCurrCourseID != 1) break;
                            cObjects.mBlockSpikeMove[n8] = 0;
                            cObjects.mBlockSpikeX[n8] = n16 * 16;
                            int n29 = n8;
                            n8 = (byte)(n8 + 1);
                            cObjects.mBlockSpikeY[n29] = n15 * 16;
                            break;
                        }
                        cCourse.replaceBGTile(n15, n16);
                        break;
                    }
                    case 116: {
                        if (cCanvas.mCurrCourseID == 2) {
                            cObjects.mBobinX[n7] = n16 * 16;
                            int n30 = n7;
                            n7 = (byte)(n7 + 1);
                            cObjects.mBobinY[n30] = n15 * 16;
                            cCourse.mCollisionInfo[n15][n16] = 0;
                            cCourse.replaceBGTile(n15, n16);
                            break;
                        }
                        cCourse.mCollisionInfo[n15][n16] = 1;
                        break;
                    }
                    case 117: {
                        cObjects.mAimMarker[n9].mActive = true;
                        cObjects.mAimMarker[n9].mX = n16 * 16 + 8;
                        int n31 = n9;
                        n9 = (byte)(n9 + 1);
                        cObjects.mAimMarker[n31].mY = n15 * 16 + 8;
                        cCourse.replaceBGTile(n15, n16);
                        break;
                    }
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: {
                        cCourse.mPanMarkers[Math.abs((int)by) - 118].mActive = true;
                        cCourse.mPanMarkers[Math.abs((int)by) - 118].mX = n16 * 16;
                        cCourse.mPanMarkers[Math.abs((int)by) - 118].mY = (n15 + 2) * 16;
                        cCourse.mTiles[n15][n16] = 0;
                        cCourse.replaceBGTile(n15, n16);
                        break;
                    }
                    case 127: {
                        cObjects.mSprExtraBallBox.mX = n16 * 16 - 4;
                        if (!cCanvas.mLoadingGame) {
                            cObjects.mSprExtraBallBox.mY = (n15 + 1) * 16 - 6;
                        }
                        if (cCanvas.mLoadingGame && !cObjects.mSprExtraBallBox.mVisible) {
                            cObjects.mSprExtraBallBox.mY += 11;
                            cObjects.mSprExtraBallBox.mFrameHeight = 11;
                            cObjects.mSprExtraBallBox.playAnim(1, true, false);
                        }
                        cObjects.mSprExtraBallBox.mVisible = true;
                        cCourse.replaceBGTile(n15, n16);
                    }
                }
                by2 = mCollisionInfo[n15][n16];
                by3 = by;
                if (++n16 < mTotCols) continue;
                n16 = 0;
                if (n15 == 0) {
                    while (++n15 <= n) {
                        for (n3 = 0; n3 < mTotCols; ++n3) {
                            cCourse.mTiles[n15][n3] = mTiles[0][n3];
                            cCourse.mCollisionInfo[n15][n3] = mCollisionInfo[0][n3];
                        }
                    }
                    continue;
                }
                if (++n15 < mTotRows - n2) continue;
                while (n15 < mTotRows) {
                    for (n3 = 0; n3 < mTotCols; ++n3) {
                        cCourse.mTiles[n15][n3] = mTiles[mTotRows - n2 - 1][n3];
                        cCourse.mCollisionInfo[n15][n3] = mCollisionInfo[mTotRows - n2 - 1][n3];
                    }
                    ++n15;
                }
                bl = false;
                break;
            }
            mWidth = mTotCols * 16;
            mHeight = mTotRows * 16;
            _mFPXLeftEnd = cFP.toFP(mScrWidth - mWidth + 16);
            _mFPYTopEnd = cFP.toFP(mScrHeight - mHeight + 16);
            mFPDY = 0;
            mFPDX = 0;
            mFPY = 0;
            mFPX = 0;
            dataInputStream.close();
            dataInputStream = null;
            for (n3 = n9; n3 < 2; ++n3) {
                cObjects.mAimMarker[n3].mActive = false;
            }
            for (n3 = n10; n3 < 8; ++n3) {
                cObjects.mWaterMarker[n3].mActive = false;
            }
            for (n3 = n11; n3 < 8; ++n3) {
                cObjects.mSpikeMarker[n3].mActive = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void updateViewPoint() {
        _mStartCol = Math.abs(cFP.toInt(mFPX) / 16);
        _mStartRow = Math.abs(cFP.toInt(mFPY) / 16);
    }

    public static void moveViewPoint() {
        if ((mFPX += mFPDX) > 0) {
            mFPX = 0;
        } else if (mFPX < cFP.toFP(mScrWidth - mWidth + 1)) {
            mFPX = cFP.toFP(mScrWidth - mWidth + 1);
        }
        if ((mFPY += mFPDY) > 0) {
            mFPY = 0;
        } else if (mFPY < cFP.toFP(mScrHeight - mHeight + 1)) {
            mFPY = cFP.toFP(mScrHeight - mHeight + 1);
        }
        cCourse.updateViewPoint();
    }

    public static boolean alignPlayer(int n, int n2, byte by) {
        boolean bl = false;
        int n3 = n;
        int n4 = 1;
        if (by == 1) {
            if ((n3 -= cFP.toFP(mScrWidth - 40 * n4) - cFP.toFP(mScrWidth - 20 * n4 - n2)) < _mFPXLeftEnd) {
                n3 = _mFPXLeftEnd;
            }
            if ((mFPX -= cFP.toFP(10 * n4)) <= n3) {
                mFPX = n3;
                bl = true;
            }
        } else {
            if ((n3 += cFP.toFP(mScrWidth - 40 * n4) - cFP.toFP(n2 - 20 * n4)) > 0) {
                n3 = 0;
            }
            if ((mFPX += cFP.toFP(10 * n4)) >= n3) {
                mFPX = n3;
                bl = true;
            }
        }
        cCourse.updateViewPoint();
        return bl;
    }

    public static void centreViewPoint(int n, int n2, int n3, byte by, byte by2) {
        int n4;
        if (by == 1) {
            n4 = 0;
            n4 = n3 == -1 ? cFP.toFP(mScrWidth >> 1) : (n3 <= 368640 ? cFP.toFP(20) : cFP.toFP(mScrWidth - 20));
            if ((mFPX -= mFPX + n - n4) < _mFPXLeftEnd) {
                mFPX = _mFPXLeftEnd;
            } else if (mFPX > 0) {
                mFPX = 0;
            }
        } else if (mFPX + n > _mFPXRight && (mFPX -= mFPX + n - _mFPXRight) < _mFPXLeftEnd) {
            mFPX = _mFPXLeftEnd;
        } else if (mFPX + n < _mFPXLeft && (mFPX += _mFPXLeft - (n + mFPX)) > 0) {
            mFPX = 0;
        }
        if (by2 == 1) {
            n4 = cFP.toFP(mScrHeight - 60);
            if ((mFPY -= mFPY + n2 - n4) < _mFPYTopEnd) {
                mFPY = _mFPYTopEnd;
            } else if (mFPY > 0) {
                mFPY = 0;
            }
        } else if (mFPY + n2 > _mFPYBottom) {
            mFPY = -n2 + _mFPYBottom;
            if (mFPY < _mFPYTopEnd) {
                mFPY = _mFPYTopEnd;
            }
        } else if (mFPY + n2 < _mFPYTop && (mFPY = _mFPYTop - n2) > 0) {
            mFPY = 0;
        }
        cCourse.updateViewPoint();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void render(Graphics graphics) {
        int n = cFP.toInt(mFPX);
        int n2 = cFP.toInt(mFPY);
        int n3 = _mStartRow + _mVisibleRows > mTotRows ? mTotRows : _mStartRow + _mVisibleRows;
        int n4 = _mStartCol + _mVisibleCols > mTotCols ? mTotCols : _mStartCol + _mVisibleCols;
        int n5 = n + (_mStartCol << 4);
        int n6 = _mStartCol;
        while (n6 < n4) {
            int n7 = n2 + (_mStartRow << 4);
            for (int i = _mStartRow; i < n3; n7 += 16, ++i) {
                int n8;
                int n9;
                if (mTiles[i][n6] >= 102 && cCanvas.mFrameCount % 3 == 0) {
                    byte[] byArray = mTiles[i];
                    int n10 = n6;
                    byArray[n10] = (byte)(byArray[n10] + 1);
                    if (byArray[n10] > 105) {
                        cCourse.mTiles[i][n6] = 0;
                        continue;
                    }
                }
                if (mTiles[i][n6] == 1) {
                    switch (cCanvas.mFrameCount % 6) {
                        default: {
                            n9 = mTiles[i][n6] % _mTotColsInImage << 4;
                            n8 = mTiles[i][n6] / _mTotColsInImage << 4;
                            break;
                        }
                        case 2: 
                        case 3: {
                            n9 = 96 % _mTotColsInImage << 4;
                            n8 = 96 / _mTotColsInImage << 4;
                            break;
                        }
                        case 4: 
                        case 5: {
                            n9 = 98 % _mTotColsInImage << 4;
                            n8 = 98 / _mTotColsInImage << 4;
                        }
                    }
                    graphics.setClip(n5, n7, 16, 16);
                    graphics.drawImage(_mImgTiles, n5 - n9, n7 - n8, 4 | 0x10);
                    continue;
                }
                if (mTiles[i][n6] == 11) {
                    switch (cCanvas.mFrameCount % 6) {
                        default: {
                            n9 = mTiles[i][n6] % _mTotColsInImage << 4;
                            n8 = mTiles[i][n6] / _mTotColsInImage << 4;
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            n9 = 97 % _mTotColsInImage << 4;
                            n8 = 97 / _mTotColsInImage << 4;
                        }
                    }
                    graphics.setClip(n5, n7, 16, 16);
                    graphics.drawImage(_mImgTiles, n5 - n9, n7 - n8, 4 | 0x10);
                    continue;
                }
                if (mTiles[i][n6] == 0) continue;
                n9 = mTiles[i][n6] % _mTotColsInImage << 4;
                n8 = mTiles[i][n6] / _mTotColsInImage << 4;
                graphics.setClip(n5, n7, 16, 16);
                graphics.drawImage(_mImgTiles, n5 - n9, n7 - n8, 4 | 0x10);
            }
            n5 += 16;
            ++n6;
        }
        return;
    }

    public static void setPars(int n) {
        switch (n) {
            case 0: {
                mPar = new byte[]{3, 4, 4, 5, 5, 5, 5, 5, 6};
                break;
            }
            case 1: {
                mPar = new byte[]{5, 5, 4, 6, 5, 7, 5, 6, 8};
                break;
            }
            case 2: {
                mPar = new byte[]{4, 5, 6, 7, 5, 5, 7, 6, 8};
            }
        }
    }

    public static void close() {
        _mImgTiles = null;
        _mImgPTiles = null;
    }

    public static void initParallax() {
        _mCourseID = cCanvas.mCurrCourseID;
        cCourse.loadParallaxGraphics(_mCourseID);
    }

    private static void loadParallaxGraphics(int n) {
        switch (n) {
            case 0: {
                _mImgPTiles = crlCanvas.gResourceManager.getImageByID(200103517175959L);
                break;
            }
            case 1: {
                _mImgPTiles = crlCanvas.gResourceManager.getImageByID(288247520694456L);
                break;
            }
            case 2: {
                _mImgPTiles = crlCanvas.gResourceManager.getImageByID(384025058907420L);
            }
        }
    }

    public static void renderParallax(Graphics graphics, int n, int n2) {
        cCourse.renderParallax(graphics, n, n2, _mRates[_mCourseID]);
    }

    private static void renderParallax(Graphics graphics, int n, int n2, byte[] byArray) {
        switch (_mCourseID) {
            case 0: {
                n2 = (n2 >>= 5) > 32 ? 32 : n2;
                break;
            }
            case 1: {
                switch (cCanvas.mCurrHoleID) {
                    case 1: 
                    case 2: {
                        n2 -= 4;
                        break;
                    }
                    case 8: {
                        n2 += 10;
                        break;
                    }
                    case 3: {
                        n2 -= 84;
                        break;
                    }
                    case 5: {
                        n2 -= 36;
                        break;
                    }
                    case 9: {
                        n2 -= 20;
                        break;
                    }
                    case 4: {
                        n2 -= 52;
                        break;
                    }
                    case 6: {
                        n2 -= 116;
                        break;
                    }
                    case 7: {
                        n2 -= 100;
                    }
                }
                break;
            }
            case 2: {
                n2 = (n2 >>= 5) > 32 ? 32 : n2;
            }
        }
        cCourse.renderParallaxSlices(graphics, n, n2, byArray);
    }

    private static void renderParallaxSlices(Graphics graphics, int n, int n2, byte[] byArray) {
        n2 = n2 < 0 ? 0 : -n2;
        int n3 = n2 - 4;
        int n4 = 0;
        byte by = _mCourseID;
        int n5 = _mCloudMover;
        for (int i = 0; i < _mZoneSets[by].length; ++i) {
            do {
                int n6 = _mZoneSets[by][i][0].length << 4;
                int n7 = -(n * byArray[n4] / 100 % n6);
                if (by == 0) {
                    ++n5;
                    n5 %= 8 * n6;
                } else {
                    n5 = 0;
                }
                int n8 = (mScrWidth + (n5 >> 1)) / n6 + 2;
                int n9 = _mZoneSets[by][i].length;
                while (--n9 >= 0) {
                    int n10 = _mZoneSets[by][i][n9].length;
                    while (--n10 >= 0) {
                        byte by2 = _mZoneSets[by][i][n9][n10];
                        int n11 = n8;
                        while (--n11 >= 0) {
                            int n12 = (n10 << 4) + n7 + n6 * n11;
                            int n13 = (n9 << 4) + n3;
                            if (i == 0) {
                                n12 = n9 <= 1 ? (n12 -= n5 >> 1) : (n9 == 2 ? (n12 -= n5 >> 2) : (n12 -= n5 >> 3));
                            }
                            cCanvas.renderImage(graphics, _mImgPTiles, (by2 & 0xF) << 4, by2 >> 4 << 4, 16, 16, n12, n13);
                        }
                    }
                }
                n3 += _mZoneSets[by][i].length * 16;
                if (n4 >= byArray.length - 1) continue;
                ++n4;
            } while (i == _mZoneSets[by].length - 1 && n2 + n3 < mScrHeight);
        }
        _mCloudMover = n5;
    }

    static {
        _mCloudMover = 0;
        _mZoneBGColTable = new int[]{0x2200AA, 4333667, 0x440044};
        _mRates = new byte[][]{{25, 50, 75, 80, 90}, {10, 20, 30, 40, 50, 60, 70, 80}, {5, 10, 15, 20, 25, 30, 35, 40, 50, 60, 70}};
        _mZoneSets = new byte[][][][]{new byte[][][]{new byte[][]{{11, 12, 13, 14, 15, 11, 11, 21, 22, 23, 11, 12, 13, 14, 15, 11}, {11, 16, 17, 18, 19, 20, 11, 11, 11, 11, 11, 16, 17, 18, 19, 20}, {11, 11, 11, 11, 11, 11, 11, 24, 11, 11, 11, 11, 11, 21, 22, 23}, {11, 11, 11, 11, 21, 22, 23, 11, 11, 24, 11, 11, 11, 11, 11, 11}}, new byte[][]{{11, 11, 70, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11}, {71, 71, 72, 70, 11, 11, 73, 70, 73, 11, 11, 71, 70, 73, 11, 11}, {74, 75, 75, 7, 3, 2, 7, 7, 7, 3, 2, 74, 7, 7, 2, 4}}, new byte[][]{{43, 44, 45, 46, 55, 56, 57, 58, 30, 29, 30, 31, 33, 33, 28, 30}, {47, 48, 49, 50, 59, 60, 61, 62, 59, 35, 36, 37, 38, 39, 34, 59}, {51, 52, 53, 54, 63, 64, 65, 66, 54, 52, 42, 42, 40, 41, 63, 66}}, new byte[][]{{68, 67, 68, 25, 25, 69, 69, 69, 25, 25, 67, 67, 1, 25, 68, 25}, {67, 68, 1, 67, 67, 1, 68, 25, 67, 68, 1, 67, 8, 8, 68, 67}, {8, 67, 67, 8, 8, 8, 8, 67, 67, 68, 8, 8, 9, 8, 8, 9}}, new byte[][]{{9, 9, 8, 8, 27, 32, 8, 32, 27, 9, 9, 8, 27, 32, 5, 9}, {5, 5, 27, 32, 9, 9, 9, 27, 32, 32, 5, 5, 32, 32, 27, 32}, {10, 10, 10, 10, 26, 26, 10, 26, 10, 10, 26, 10, 10, 10, 26, 10}}}, new byte[][][]{new byte[][]{{24, 22, 19, 18, 24, 22, 19, 18, 24, 22, 19, 18, 24, 22, 19, 18}}, new byte[][]{{19, 18, 24, 22, 19, 18, 24, 22, 19, 18, 24, 22, 19, 18, 24, 22}}, new byte[][]{{24, 22, 19, 18, 24, 22, 19, 18, 24, 22, 19, 18, 24, 22, 19, 18}}, new byte[][]{{19, 18, 24, 22, 19, 18, 24, 22, 19, 18, 24, 22, 19, 18, 24, 22}}, new byte[][]{{9, 9, 8, 8, 8, 77, 74, 97, 5, 77, 74, 12, 9, 17, 13, 12}}, new byte[][]{{6, 52, 54, 56, 58, 97, 5, 74, 6, 62, 58, 2, 6, 8, 8, 2}, {51, 53, 55, 57, 57, 59, 60, 61, 60, 3, 57, 59, 51, 60, 61, 51}}, new byte[][]{{57, 38, 39, 40, 57, 57, 57, 57, 57, 57, 57, 57, 30, 31, 14, 57}, {21, 41, 42, 43, 27, 15, 23, 28, 27, 28, 21, 33, 32, 33, 46, 26}, {48, 47, 48, 47, 29, 16, 34, 35, 29, 20, 48, 47, 4, 47, 48, 47}, {50, 49, 50, 49, 50, 49, 50, 63, 50, 49, 50, 49, 50, 49, 50, 49}, {47, 48, 47, 48, 47, 48, 47, 48, 47, 48, 47, 48, 47, 48, 47, 48}, {49, 50, 49, 50, 49, 50, 49, 50, 49, 50, 49, 50, 49, 50, 49, 50}, {48, 47, 48, 47, 48, 47, 48, 47, 48, 47, 48, 47, 48, 47, 48, 47}, {50, 49, 50, 49, 50, 49, 50, 49, 50, 49, 50, 49, 50, 49, 50, 49}, {47, 48, 47, 48, 47, 48, 47, 48, 47, 48, 47, 48, 47, 48, 47, 48}}, new byte[][]{{66, 64, 65, 66, 64, 65, 66, 73, 0, 75, 64, 65, 66, 64, 65, 25}, {69, 67, 68, 69, 67, 68, 69, 76, 1, 78, 67, 68, 69, 67, 68, 25}, {72, 70, 93, 94, 94, 95, 72, 79, 45, 44, 70, 71, 72, 70, 71, 25}, {66, 64, 92, 7, 7, 92, 66, 64, 65, 66, 64, 65, 66, 64, 65, 25}, {69, 67, 92, 7, 7, 92, 69, 67, 68, 69, 67, 68, 69, 67, 68, 25}, {72, 70, 92, 7, 7, 92, 72, 70, 71, 72, 70, 71, 72, 70, 71, 25}, {66, 64, 93, 94, 94, 95, 66, 64, 65, 66, 64, 65, 66, 64, 65, 25}, {69, 67, 68, 69, 67, 68, 69, 67, 68, 69, 67, 68, 69, 67, 68, 25}, {72, 70, 71, 72, 70, 71, 72, 70, 71, 72, 70, 71, 72, 70, 71, 25}, {66, 64, 65, 66, 64, 65, 85, 86, 65, 80, 81, 65, 66, 64, 65, 25}, {69, 67, 68, 69, 67, 68, 87, 88, 68, 82, 83, 68, 69, 67, 68, 25}, {72, 70, 71, 72, 70, 71, 87, 88, 71, 82, 83, 71, 72, 70, 71, 25}, {66, 64, 65, 66, 64, 65, 11, 89, 65, 10, 84, 65, 66, 64, 65, 25}, {69, 67, 68, 69, 67, 93, 94, 94, 94, 94, 94, 95, 37, 67, 68, 25}, {72, 70, 71, 72, 70, 96, 90, 91, 96, 90, 91, 96, 36, 70, 71, 25}, {25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25}}}, new byte[][][]{new byte[][]{{0, 0, 55, 50, 54, 33, 0, 16, 0, 51, 52, 53, 54, 55, 50, 54}}, new byte[][]{{33, 34, 35, 36, 0, 55, 50, 54, 33, 0, 55, 16, 51, 52, 53, 54}}, new byte[][]{{51, 52, 53, 54, 34, 16, 0, 51, 52, 53, 54, 33, 45, 47, 16, 33}}, new byte[][]{{0, 0, 55, 50, 53, 54, 0, 0, 0, 51, 52, 54, 33, 0, 55, 16}}, new byte[][]{{0, 0, 45, 47, 16, 0, 55, 16, 45, 47, 16, 0, 51, 52, 54, 33}}, new byte[][]{{0, 33, 0, 0, 0, 55, 16, 0, 55, 16, 45, 47, 16, 0, 0, 0}}, new byte[][]{{0, 0, 55, 0, 0, 33, 0, 0, 0, 0, 0, 33, 0, 0, 0, 0}}, new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 48, 49, 43, 0, 0, 0, 0, 0, 0, 48, 49, 0, 0, 0}, {0, 59, 44, 40, 57, 56, 38, 43, 0, 0, 56, 44, 40, 38, 0, 0}, {56, 30, 40, 40, 37, 30, 40, 57, 58, 59, 39, 40, 40, 40, 57, 58}, {39, 40, 40, 40, 40, 40, 40, 40, 37, 30, 40, 40, 40, 40, 40, 37}, {40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40}}, new byte[][]{{40, 40, 26, 6, 26, 40, 40, 40, 40, 40, 40, 40, 22, 40, 40, 40}, {40, 40, 18, 9, 27, 40, 17, 2, 20, 40, 40, 20, 8, 26, 40, 40}, {26, 20, 9, 19, 1, 12, 3, 3, 27, 8, 7, 29, 9, 27, 28, 20}, {18, 18, 27, 9, 4, 29, 9, 18, 27, 19, 18, 27, 19, 27, 19, 27}, {5, 5, 1, 5, 1, 3, 27, 2, 1, 5, 3, 2, 1, 1, 5, 1}, {1, 1, 1, 1, 1, 5, 1, 1, 1, 1, 5, 1, 1, 1, 1, 1}}, new byte[][]{{10, 11, 13, 14, 10, 11, 13, 14, 10, 11, 13, 14, 10, 11, 13, 14}, {21, 23, 24, 25, 21, 23, 24, 25, 21, 23, 24, 25, 21, 23, 24, 25}, {23, 24, 25, 21, 23, 24, 25, 21, 23, 24, 25, 21, 23, 24, 25, 21}, {24, 25, 21, 23, 24, 25, 21, 23, 24, 25, 21, 23, 24, 25, 21, 23}, {25, 21, 23, 24, 25, 21, 23, 24, 25, 21, 23, 24, 25, 21, 23, 24}}, new byte[][]{{32, 31, 32, 31, 32, 31, 32, 31, 32, 31, 32, 31, 32, 31, 32, 31}, {42, 41, 42, 41, 42, 41, 42, 41, 42, 41, 42, 41, 42, 41, 42, 41}, {42, 41, 42, 41, 42, 41, 42, 41, 42, 41, 42, 41, 42, 41, 42, 41}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15}}}};
    }
}

