/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;

class DDLSound {
    private static MIDlet m_Parent;
    private static boolean m_SoundOn;
    private static int m_numSound;
    private static int m_numMusic;
    private static int m_prevSound;
    private static boolean m_SoundLoaded;
    private static Sound[] m_toneFx;
    private static byte[][] m_soundBuffers;
    private static boolean m_stopSound;
    private static boolean m_readyToPlay;
    private static Player m_soundFx;
    private static String[] m_soundPaths;
    private static int[] m_soundQueue;
    private static int m_soundQueueLength;
    private static final int MAX_SOUNDS_IN_QUEUE = 4;

    public DDLSound(MIDlet mIDlet) {
        m_Parent = mIDlet;
        m_prevSound = -1;
        m_numSound = 0;
        m_numMusic = 0;
        m_SoundOn = true;
        m_SoundLoaded = false;
    }

    public static void setSoundOnOff(boolean bl) {
        m_SoundOn = bl;
    }

    public static boolean soundIsEnabled() {
        return m_SoundOn;
    }

    public static void loadSound(String[] stringArray, int n, String[] stringArray2, int n2) {
        System.out.println("LoadSound ");
        try {
            int n3;
            m_toneFx = new Sound[n + n2];
            m_soundBuffers = new byte[n + n2][];
            m_soundPaths = new String[n + n2];
            m_soundQueue = new int[4];
            for (n3 = 0; n3 < n; ++n3) {
                DDLSound.m_soundBuffers[n3] = DDLSound.readJarByteData("/" + stringArray[n3] + ".bin");
                DDLSound.m_toneFx[n3] = new Sound(m_soundBuffers[n3], 1);
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    DDLSound.m_soundPaths[n + n3] = "/" + stringArray2[n3] + ".mid";
                }
            }
            catch (Exception exception) {
                n2 = 0;
            }
            m_numSound = n;
            m_numMusic = n2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        m_SoundLoaded = true;
    }

    public static boolean musicAvailable() {
        return m_numMusic > 0;
    }

    public static void playSound(int n, boolean bl) {
        System.out.println("playSound " + n);
        if (n >= 0 && n < m_numSound) {
            DDLSound.playIt(n, bl);
        }
    }

    public static boolean isSoundEffectAvailable(int n, boolean bl) {
        return n >= 0 && n < m_numSound;
    }

    public static void playMusic(int n, boolean bl) {
        System.out.println("music " + n);
        if (n >= 0 && n < m_numMusic) {
            DDLSound.playIt(n + m_numSound, bl);
        }
    }

    public static boolean isLoaded() {
        return m_SoundLoaded;
    }

    public static void stopAllSound() {
        m_stopSound = true;
        m_readyToPlay = false;
    }

    public static void stopAndClose() {
        if (m_soundFx != null) {
            try {
                m_soundFx.stop();
                m_soundFx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        m_soundFx = null;
        m_stopSound = false;
        m_readyToPlay = true;
        m_soundQueueLength = 0;
        m_stopSound = true;
        m_readyToPlay = false;
        m_SoundLoaded = false;
    }

    private static void playIt(int n, boolean bl) {
        if (!m_SoundOn) {
            return;
        }
        if (m_soundQueueLength < 4) {
            DDLSound.m_soundQueue[DDLSound.m_soundQueueLength] = n;
            ++m_soundQueueLength;
        }
    }

    private static byte[] readJarByteData(String string) {
        byte[] byArray = null;
        try {
            InputStream inputStream = m_Parent.getClass().getResourceAsStream(string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = inputStream.read();
            while (n >= 0) {
                byteArrayOutputStream.write(n);
                n = inputStream.read();
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public static void playScheduledSound() {
        if (m_stopSound && !m_readyToPlay) {
            if (m_soundFx != null) {
                try {
                    m_soundFx.stop();
                    m_soundFx.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            m_soundFx = null;
            m_stopSound = false;
            m_readyToPlay = true;
            return;
        }
        if (m_soundQueueLength > 0 && m_readyToPlay) {
            int n = m_soundQueue[0];
            if (m_soundQueueLength > 1) {
                for (int i = 1; i < m_soundQueueLength; ++i) {
                    DDLSound.m_soundQueue[i - 1] = m_soundQueue[i];
                }
            }
            --m_soundQueueLength;
            if (n < m_numSound) {
                if (m_toneFx[n] != null) {
                    m_toneFx[n].setGain(150);
                    m_toneFx[n].play(1);
                    m_prevSound = n;
                }
            } else {
                try {
                    m_readyToPlay = false;
                    m_soundFx = Manager.createPlayer((InputStream)m_Parent.getClass().getResourceAsStream(m_soundPaths[n]), (String)"audio/midi");
                    m_soundFx.addPlayerListener((PlayerListener)new StopListener());
                    m_soundFx.prefetch();
                    VolumeControl volumeControl = (VolumeControl)m_soundFx.getControl("VolumeControl");
                    volumeControl.setLevel(50);
                    m_soundFx.start();
                    m_prevSound = n;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void returnFromInterrupt() {
        if (m_soundFx != null && m_soundFx.getState() == 200) {
            try {
                m_soundFx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            m_readyToPlay = true;
            DDLSound.m_soundQueue[0] = m_prevSound;
            m_soundQueueLength = 1;
            m_soundFx = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        m_stopSound = false;
        m_readyToPlay = true;
        m_soundQueueLength = 0;
    }

    public static class StopListener
    implements PlayerListener {
        public void playerUpdate(Player player, String string, Object object) {
            block4: {
                try {
                    if (!string.equals("endOfMedia")) break block4;
                    try {
                        m_soundFx.stop();
                        m_soundFx.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    m_soundFx = null;
                    m_readyToPlay = true;
                    m_stopSound = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

