/*
 * Decompiled with CFR 0.152.
 */
import com.mascotcapsule.micro3d.v3.ActionTable;
import com.mascotcapsule.micro3d.v3.AffineTrans;
import com.mascotcapsule.micro3d.v3.Effect3D;
import com.mascotcapsule.micro3d.v3.Figure;
import com.mascotcapsule.micro3d.v3.FigureLayout;
import com.mascotcapsule.micro3d.v3.Graphics3D;
import com.mascotcapsule.micro3d.v3.Light;
import com.mascotcapsule.micro3d.v3.Texture;
import com.mascotcapsule.micro3d.v3.Vector3D;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class World3D
implements DATA {
    public static Graphics3D _g3d = new Graphics3D();
    public static final int TABLE_GROUP_TRANSFORM_ID = 34;
    public static final int TABLE_MESH_TRANSFORM_ID = 35;
    public final int ID_CAMERA_BALL;
    public final int ID_CAMERA_TABLE;
    public final int ID_CAMERA_LOSE_UL;
    public final int ID_CAMERA_LOSE_L;
    public final int ID_CAMERA_LOSE_DL;
    public final int ID_CAMERA_LOSE_UR;
    public final int ID_CAMERA_LOSE_R;
    public final int ID_CAMERA_LOSE_DR;
    public final int ID_CAMERA_WITHOUT_LOSE;
    public int _iCameraID;
    public final int CAMERA_KICK_ANGLE;
    public final int CAMERA_KICK_ANGLE_CPU;
    public final int CAMERA_REPLAY_ANGLE;
    public int _rotAroundCamReplay;
    public int _rotHeightCamReplay;
    public bGeometry _ball = new bGeometry();
    public Graphics _grActive;
    public static int[] intT = new int[16];
    public final int r;
    public final int R;
    static final int TARGET_LINES_NUMBER = 8;
    public static Figure[] _figBall = new Figure[17];
    public static Figure[] _figBallEnv = new Figure[1];
    public static Figure[] _figBallShadow = new Figure[16];
    public static Figure[] _figTargetBall = new Figure[8];
    public static Figure _figTable;
    public static Figure _figTableFrame;
    public static Figure _figKiy;
    public static ActionTable _actBall;
    public static Texture _texBall;
    public static Texture _texBallEnv;
    public static Texture _texReflection;
    public static Texture _texBallNumber;
    public static Texture _texTable;
    public static FigureLayout[] _layBall;
    public static FigureLayout[] _layBallShadow;
    public static FigureLayout[] _layTargetBall;
    public static FigureLayout _layBallNum;
    public static FigureLayout _layTable;
    public static FigureLayout _layKiy;
    public static FigureLayout _layTarget;
    private static Effect3D _effectBall;
    private static Effect3D _effectTable;
    private static Effect3D _effectTarget;
    public final int TIME_INTERPOL_3D_CAM;
    int rot_z;
    int rot_x;
    public final int UNIT_ANGLE;
    public final int BALL_X;
    public final int BALL_Y;
    public final int BALL_Z;
    public final int SHADOW_Z;
    public final int BALL_NUMBER_Z;
    public final int BALL_WHITE;
    public static final int NO_TEXTURE = 0;
    public final int REPLAY_CAMERA_DISTANCE;
    public final int START_CAMERA_DISTANCE;
    public final int CAMERA_TABLE_DISTANCE;
    public final int CPU_CAMERA_DISTANCE;
    public final int PI_MATH;
    public final int PI_3D;
    public final int TARGET_LINE_SCALE_MIN;
    public final int TARGET_LINE_SCALE_MAX;
    public final int CAMERA_DISTANCE_MIN;
    public final int CAMERA_DISTANCE_MAX;
    public int rotHeight = 45;
    public int rotHeightNew = 0;
    public int rotHeightOld = 0;
    public int rotHeightPrevious = 0;
    public boolean[] isBallRenderingEnabled = new boolean[17];
    public boolean isTargetLineRenderingEnabled = false;
    public final int angleInc;
    public int cameraDistanceOld;
    public int cameraDistance = 120;
    public int cameraDistanceNew;
    public int cameraDistancePrevious;
    public int[] _ballX = new int[17];
    public int[] _ballY = new int[17];
    public int _loseX;
    public int _loseY;
    private final int BALL_R;
    public boolean _bBallContactsWithWall;
    public final int DEF_FPS;
    public long _lFPSTime = System.currentTimeMillis();
    public int _iFPS = 30;
    public String _sFPS = "";
    public int _iFPSCounter = 0;
    private Image imageBallNumbers;
    private Image imageTargetTexture;
    public int _x = 0;
    public int _y;
    public int _z = 1;
    private int _iBallFrame;
    private static final int PERSPECTIVE = 500;
    public static final int ROT_HEIGHT_MIN = 25;
    public static final int ROT_HEIGHT_MAX = 90;
    public static long start_interpolKiy_time;
    public static int _iKiyMoveDir;
    public final int DIR_FORWARD;
    public final int DIR_BACKWARD;
    public static int interpolKiy_time;
    public int rotAroundOld = 0;
    public int rotAround = 0;
    public int rotAroundNew = 0;
    public boolean _bFallingBall;
    int BALLS_COUNT = 2;
    public Image _imgTableBuf;
    public int sc = 0;
    public int lightMode = 128;
    public int[] _iBallPattNum = new int[17];
    public boolean _bChangeCameraAngleWithInterpol;
    public boolean _bKiyMoveInterpol;
    public boolean _bChangeInterpolAround;
    int rotAroundPrev = 0;
    int degPrev = 0;
    int degPrevCPU = 0;
    int speedBack = 0;
    int speedForward;
    int Kdy = 0;
    int KdyOld = 0;
    int CPU_Kiy_dY_counter;
    int cacheDy;
    boolean bcpuKiyBack;
    boolean bcpuKiyForward;
    int angle_cam = 0;
    int distance_cam = 0;
    public final int ANG_90;
    public final int SCALE_ONE;
    public boolean[] isBallWholeType = new boolean[17];
    public int iTargetScaleCoeff = 6;
    final int SCALE_COEFF;
    final int Y_OFFSET_CAMERA_BALL;
    final int Y_OFFSET_CAMERA_REPLAY;
    int CameraX;
    int CameraY;
    int CameraZ;
    int Y_CameraBall;
    int unit_one_trygonom = C._bIsRussian ? 7 : 11;
    final int TARGET_SCALE_COEFF;
    public int SPRITE_SCALE = 1;
    public final int ballNumberW;
    boolean canRenderBallNumbers;
    final int W;
    final int H;
    public boolean _bW3dGraphicsInitialized = false;
    public static AffineTrans _affBall;
    public static AffineTrans _affBallShadow;
    public static AffineTrans _affTargetBall;
    public static AffineTrans _affTable;
    public static AffineTrans _affKiy;
    public static AffineTrans _affTarget;
    public static AffineTrans _affBallNum;
    public static AffineTrans _affRot;
    public static AffineTrans[] _affBallRotation;
    private static int _lightDir;
    private static int _lightAmbi;
    private static int _lightDirTable;
    private static int _lightAmbiTable;
    private static Light _Light;
    private static Light _Light2;
    private static Light _LightTable;
    int[] ballXold = new int[17];
    int[] ballYold = new int[17];
    int ballXold1;
    int ballYold1;
    int replayAngle;
    public int[] _iDeepCounter = new int[17];
    final int X_PocketOffset;
    final int Y_PocketOffset;
    final int pocketCoeff;
    final int POCKET_STEPS_NUM;
    boolean[] bIsBallInPocket = new boolean[16];
    int[] iLoseWithBallNum = new int[16];
    int[] _VertCoords_Target = new int[24];
    int[] pNormalTarget = new int[24];
    int[] _TexCoordsTarget = new int[64];
    int[] _VertCoords_BallNum = new int[48];
    int[] pNormalBallNum = new int[48];
    int[] _TexCoordsBallNum = new int[128];
    final int COMMAND_SPRITES;
    private static final int COMMAND2 = 67123248;
    int[] _ColorsTarget = new int[8];
    int[] _ColorsBallNum = new int[16];
    int angleBallRotX;
    int angleBallRotY;
    Vector3D vRotX = new Vector3D();
    Vector3D vRotY = new Vector3D();
    final Vector3D vX = new Vector3D(4096, 0, 0);
    final Vector3D vY = new Vector3D(0, 4096, 0);
    public final byte[] textures = new byte[]{1, 1, 1, 0, 0, 1, 0, 0};
    public final short[] coords = new short[]{-1000, 0, 25, 0, 0, 25, 0, 0, -25, -1000, 0, -25};

    public World3D() {
        this.ID_CAMERA_BALL = 0;
        this.ID_CAMERA_TABLE = 1;
        this.ID_CAMERA_LOSE_UL = 2;
        this.ID_CAMERA_LOSE_L = 3;
        this.ID_CAMERA_LOSE_DL = 4;
        this.ID_CAMERA_LOSE_UR = 5;
        this.ID_CAMERA_LOSE_R = 6;
        this.ID_CAMERA_LOSE_DR = 7;
        this.ID_CAMERA_WITHOUT_LOSE = 8;
        this.CAMERA_KICK_ANGLE = 70;
        this.CAMERA_KICK_ANGLE_CPU = 70;
        this.CAMERA_REPLAY_ANGLE = 35;
        this.r = 10;
        this.R = 5;
        this.TIME_INTERPOL_3D_CAM = 1000;
        this.UNIT_ANGLE = 10;
        this.BALL_X = 0;
        this.BALL_Y = 1;
        this.BALL_Z = 7;
        this.SHADOW_Z = 2;
        this.BALL_NUMBER_Z = 8;
        this.BALL_WHITE = 0;
        this.REPLAY_CAMERA_DISTANCE = 50;
        this.START_CAMERA_DISTANCE = 130;
        this.CAMERA_TABLE_DISTANCE = 120;
        this.CPU_CAMERA_DISTANCE = 130;
        this.PI_MATH = 3;
        this.PI_3D = 2048;
        this.TARGET_LINE_SCALE_MIN = 10;
        this.TARGET_LINE_SCALE_MAX = 20;
        this.CAMERA_DISTANCE_MIN = 60;
        this.CAMERA_DISTANCE_MAX = 130;
        this.angleInc = 5;
        this.BALL_R = 3;
        this.DEF_FPS = 30;
        this.DIR_FORWARD = 1;
        this.DIR_BACKWARD = -1;
        this.ANG_90 = 1024;
        this.SCALE_ONE = 4096;
        this.SCALE_COEFF = 10;
        this.Y_OFFSET_CAMERA_BALL = 30;
        this.Y_OFFSET_CAMERA_REPLAY = 20;
        this.TARGET_SCALE_COEFF = 1;
        this.ballNumberW = 16;
        this.W = 176;
        this.H = 220;
        this.X_PocketOffset = 3;
        this.Y_PocketOffset = 1;
        this.pocketCoeff = -10;
        this.POCKET_STEPS_NUM = 3;
        this.COMMAND_SPRITES = 83898384;
    }

    public void createBufferTable() {
    }

    void loadBall(int i) {
        try {
            if (_figBall[i] == null) {
                World3D._figBall[i] = new Figure("/ball.mbac");
            }
            if (i < 16 && _figBallShadow[i] == null) {
                World3D._figBallShadow[i] = new Figure("/shadow.mbac");
            }
            if (_texBall == null) {
                _texBall = new Texture("/balls_tex_micro3d copy.bmp", true);
            }
            _figBall[i].setTexture(_texBall);
            if (i < 16) {
                _figBallShadow[i].setTexture(_texBall);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void loadTargetBall(int i) {
        try {
            if (_figTargetBall[i] == null) {
                World3D._figTargetBall[i] = new Figure("/pointer.mbac");
            }
            _figTargetBall[i].setTexture(_texBall);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void loadTable() {
        try {
            _figTable = new Figure("/table.mbac");
            _figTableFrame = new Figure("/frame.mbac");
            _texTable = new Texture("/table&kiy0.bmp", true);
            _figTable.setTexture(_texTable);
            _figTableFrame.setTexture(_texTable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void loadKiy() {
        try {
            _figKiy = new Figure("/kiy.mbac");
            _figKiy.setTexture(_texTable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void updateAnimation() {
    }

    public void setTableColor(int iColor) {
        try {
            _texTable = new Texture("/table&kiy" + iColor + ".bmp", true);
            System.gc();
            _figTable.setTexture(_texTable);
            _figTableFrame.setTexture(_texTable);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void unload() {
    }

    public void setCameraAngleH(int a_fAngle) {
        this.rotHeightPrevious = this.rotHeightOld = this.rotHeight;
        if (!this._bChangeCameraAngleWithInterpol) {
            this.rotHeightPrevious = this.rotHeightOld;
        }
        this.rotHeightNew = a_fAngle;
    }

    public void setCameraDistance(int a_fDist, boolean a_bWithInterpol) {
        if (!this._bChangeCameraAngleWithInterpol) {
            this.cameraDistancePrevious = this.cameraDistance;
        }
        if (this._bChangeCameraAngleWithInterpol = a_bWithInterpol) {
            this.cameraDistancePrevious = this.cameraDistanceOld = this.cameraDistance;
            this.cameraDistanceNew = a_fDist;
        } else {
            this.cameraDistance = a_fDist;
        }
    }

    public void prepareKiyInterpol(int direction, int interpolTime) {
        interpolKiy_time = interpolTime;
        _iKiyMoveDir = direction;
        this._bKiyMoveInterpol = true;
        start_interpolKiy_time = System.currentTimeMillis();
        this.CPU_Kiy_dY_counter = 0;
    }

    public void setCameraAngleAround(int a_fAngle) {
        this.rotAroundOld = this.rotAround;
        this.rotAroundNew = a_fAngle;
        this._bChangeInterpolAround = true;
        this.rotAround = a_fAngle;
        if (this.rotAroundNew == 0 && this.rotAroundOld > 180) {
            this.rotAroundNew = 360;
        }
        if (this.rotAroundNew > 180 && this.rotAroundOld == 0) {
            this.rotAroundOld = 360;
        }
    }

    public int degToUnits(int angDeg) {
        return angDeg * 4096 / 360;
    }

    void rotateTable(int camID, int X_rot, int Y_rot, int Z_rot) {
        AffineTrans aff = new AffineTrans();
        int angleAround = C._bReplaying ? this.replayAngle - this._rotAroundCamReplay : -this.rotAround;
        int angleHeight = C._bReplaying ? this._rotHeightCamReplay : this.rotHeight;
        int offZ = -this.CameraZ;
        aff.setIdentity();
        aff.rotationX(this.degToUnits(90 + angleHeight));
        _affTable.mul(aff);
        aff.setIdentity();
        aff.rotationZ(this.degToUnits(angleAround));
        _affTable.mul(aff);
        aff.setIdentity();
        aff.m03 = -this.CameraX;
        aff.m13 = -this.CameraY;
        aff.m23 = -offZ;
        _affTable.mul(aff);
    }

    void rotateTarget() {
        AffineTrans aff = new AffineTrans();
        aff.setIdentity();
        aff.rotationX(this.degToUnits(90 + this.rotHeight));
        _affTarget.mul(aff);
        aff.setIdentity();
        aff.rotationZ(this.degToUnits(-this.rotAround));
        _affTarget.mul(aff);
    }

    public void setBallsScale() {
        World3D._affBall.m00 = 3072;
        World3D._affBall.m11 = 3072;
        World3D._affBall.m22 = 3072;
    }

    public void setTablesScale() {
        World3D._affTable.m00 = 20480;
        World3D._affTable.m11 = 20480;
        World3D._affTable.m22 = 20480;
    }

    public void setTargetScale() {
        World3D._affTarget.m00 = 409600;
        World3D._affTarget.m11 = 409600;
        World3D._affTarget.m22 = 409600;
    }

    public void setTargetBallScale() {
    }

    public void updateBallLayout(int i) {
        _affBall.setIdentity();
        AffineTrans aff = new AffineTrans();
        aff.setIdentity();
        _affBall.mul(_affTable);
        aff.m03 = this._ballX[i];
        aff.m13 = this._ballY[i];
        aff.m23 = C._instance.game_state != 8 ? this._iDeepCounter[i] * -10 + 7 : this._iDeepCounter[i] * -10 * 15 + 7;
        aff.m00 = (i == 16 ? 13 : 11) * 4096 / 10;
        aff.m11 = (i == 16 ? 13 : 11) * 4096 / 10;
        aff.m22 = (i == 16 ? 13 : 11) * 4096 / 10;
        _affBall.mul(aff);
        this.rotateBall(i);
        _layBall[i].setAffineTrans(_affBall);
    }

    public void updateShadowLayout(int i) {
        _affBallShadow.setIdentity();
        _affBallShadow.mul(_affTable);
        AffineTrans aff = new AffineTrans();
        aff.setIdentity();
        aff.setIdentity();
        aff.m03 = this._ballX[i];
        aff.m13 = this._ballY[i];
        aff.m23 = this._iDeepCounter[i] * -10 + 2;
        aff.m00 = 4505;
        aff.m11 = 4505;
        aff.m22 = 4505;
        _affBallShadow.mul(aff);
        _layBallShadow[i].setAffineTrans(_affBallShadow);
    }

    public void updateTargetBallLayout(int i) {
        _affTargetBall.setIdentity();
        AffineTrans aff = new AffineTrans();
        aff.setIdentity();
        _affTargetBall.mul(_affTable);
        aff.setIdentity();
        aff.m03 = this._ballX[0];
        aff.m13 = this._ballY[0];
        _affTargetBall.mul(aff);
        aff.setIdentity();
        aff.rotationZ(this.degToUnits(C._instance.deg));
        _affTargetBall.mul(aff);
        aff.setIdentity();
        aff.m03 = -this._ballX[0];
        aff.m13 = -this._ballY[0];
        _affTargetBall.mul(aff);
        aff.setIdentity();
        aff.m03 = this._ballX[0];
        aff.m13 = this._ballY[0] + (i + 1) * 12;
        _affTargetBall.mul(aff);
        aff.setIdentity();
        aff.m00 /= this.iTargetScaleCoeff;
        aff.m11 /= this.iTargetScaleCoeff;
        aff.m22 /= this.iTargetScaleCoeff;
        _affTargetBall.mul(aff);
        _layTargetBall[i].setAffineTrans(_affTargetBall);
    }

    public void updateTableLayout() {
        if (C._instance.game_state == 8 || C._instance.game_state == 9) {
            return;
        }
        _affTable.setIdentity();
        int distance = C._bReplaying ? 50 : this.cameraDistance;
        AffineTrans aff = new AffineTrans();
        aff.setIdentity();
        aff.m13 = this.Y_CameraBall * 10;
        aff.m23 = distance * 10;
        _affTable.mul(aff);
        this.setTablesScale();
        this.rotateTable(this._iCameraID, this.CameraX, this.CameraY, this.CameraZ);
        _layTable.setAffineTrans(_affTable);
    }

    int getSinPeriod(int sin, int cos) {
        this.unit_one_trygonom = C._bIsRussian ? 7 : 11;
        int result = 1;
        if (sin >= -(this.unit_one_trygonom + 2) && sin < 0 && cos <= 0) {
            result = 1;
        }
        if (sin >= 0 && sin < this.unit_one_trygonom + 2 && cos <= 0) {
            result = 2;
        }
        if (sin <= this.unit_one_trygonom + 2 && sin > 0 && cos >= 0) {
            result = 3;
        }
        if (sin <= 0 && sin > -(this.unit_one_trygonom + 2) && cos >= 0) {
            result = 4;
        }
        return result;
    }

    int get_CPU_aiming_KiyAngle() {
        int result = 0;
        int sin = (int)C._instance.sn / 20;
        int cos = (int)C._instance.cn / 20;
        int sinPeriod = this.getSinPeriod(sin, cos);
        switch (sinPeriod) {
            case 1: {
                result = 90 - Utils.abs(sin * 90 / this.unit_one_trygonom);
                break;
            }
            case 2: {
                result = 90 + Utils.abs(sin * 90 / this.unit_one_trygonom);
                break;
            }
            case 3: {
                result = 180 + (90 - Utils.abs(sin * 90 / this.unit_one_trygonom));
                break;
            }
            case 4: {
                result = 270 + Utils.abs(sin * 90 / this.unit_one_trygonom);
            }
        }
        return result;
    }

    void rotateKiy() {
        AffineTrans aff = new AffineTrans();
        int ang = C._instance.game_state == -1 || C._instance.game_state == 10 ? this.get_CPU_aiming_KiyAngle() : C._instance.deg;
        aff.setIdentity();
        aff.rotationZ(this.degToUnits(ang));
        _affKiy.mul(aff);
    }

    public void updateKiyLayout() {
        if (C._instance.game_state == 8) {
            return;
        }
        _affKiy.setIdentity();
        _affKiy.mul(_affTable);
        AffineTrans aff = new AffineTrans();
        aff.setIdentity();
        int kiyDx = 0;
        if (this._bKiyMoveInterpol) {
            if (_iKiyMoveDir == -1) {
                if (C._instance.game_state == 3) {
                    this.speedBack = Math.max(0, (C._instance.key_pos_y - C._instance.key_pos_y_def) * 3 / 30);
                }
                kiyDx = this.speedBack;
            }
            if (_iKiyMoveDir == 1) {
                this.speedBack = 0;
                this._bKiyMoveInterpol = false;
                kiyDx = this.speedBack;
            }
        }
        if (C._instance.game_state == 10) {
            kiyDx = this.speedBack = 20;
        }
        if (C._instance.game_state == -1) {
            kiyDx = this.speedBack = 0;
        }
        aff.m03 = this._ballX[0];
        aff.m13 = this._ballY[0];
        _affKiy.mul(aff);
        this.rotateKiy();
        aff.setIdentity();
        aff.m13 = 4 - kiyDx;
        _affKiy.mul(aff);
        _layKiy.setAffineTrans(_affKiy);
    }

    public void updateTargetLayout() {
        _affTarget.setIdentity();
        AffineTrans aff = new AffineTrans();
        aff.setIdentity();
        aff.m23 = this.cameraDistance * 10 * 20;
        _affTarget.mul(aff);
        this.setTargetScale();
        this.rotateTarget();
        _layTarget.setAffineTrans(_affTarget);
    }

    public void updateBallNumLayout() {
        if (C._instance.game_state == 8) {
            return;
        }
        _affBallNum.setIdentity();
        AffineTrans aff = new AffineTrans();
        aff.setIdentity();
        _affBallNum.mul(_affTable);
        aff.m23 = 20;
        _affBallNum.mul(aff);
        _layBallNum.setAffineTrans(_affBallNum);
    }

    void updateRotAround() {
        if (C._instance.game_state != 0 && C._instance.game_state != 4 && C._instance.game_state != 9) {
            this.rotAround = C._instance.deg;
        }
    }

    boolean canRenderKiy3D() {
        int state = C._instance.game_state;
        return (state == 1 || state == 4 || state == 3 || state == 2 || state == 10 || state == -1 || C._instance.start_moving) && !C._bReplaying;
    }

    public void render() {
        try {
            int i;
            this.update_fps();
            this._grActive.setClip(0, 0, 176, 220);
            this._grActive.setColor(0);
            this._grActive.fillRect(0, 0, 176, 220);
            boolean bCPU_Player = C.playing_with_cpu && C.game_player_active == 1 || C._instance.game_state == 10;
            this.updateRotAround();
            if (this._bChangeCameraAngleWithInterpol && !C._bReplaying) {
                if (System.currentTimeMillis() <= C._instance.start_interpol3DCam_time + 1000L) {
                    int t = (int)(System.currentTimeMillis() - C._instance.start_interpol3DCam_time);
                    int T = 1000;
                    if (C._instance.game_state == 1) {
                        this.cameraDistanceNew = 90;
                    }
                    this.angle_cam = this.rotHeightOld + (this.rotHeightNew - this.rotHeightOld) * t / 1000;
                    this.distance_cam = this.cameraDistanceOld + (this.cameraDistanceNew - this.cameraDistanceOld) * t / 1000;
                    this.rotHeight = this.angle_cam;
                    this.cameraDistance = this.distance_cam;
                    if (this._bChangeInterpolAround) {
                        if (this.rotAroundNew > 180 && this.rotAroundOld == 0) {
                            this.rotAroundOld = 360;
                        }
                        this.rotAround = this.rotAroundOld + (this.rotAroundNew - this.rotAroundOld) * t / 1000;
                    }
                } else {
                    this._bChangeInterpolAround = false;
                    this.rotHeight = this.rotHeightNew;
                    this.rotAround = this.rotAroundNew;
                    this.cameraDistance = this.cameraDistanceNew;
                    if (!bCPU_Player) {
                        this.createBufferTable();
                    }
                    this._bChangeCameraAngleWithInterpol = false;
                    if (C._instance.start_moving && C._instance.game_state != 10 && C._instance.game_state != -1) {
                        this.prepareKiyInterpol(1, 100);
                    }
                }
            }
            this.set3DBallsCoords();
            Graphics3D g3d = _g3d;
            g3d.bind(this._grActive);
            this.updateTableLayout();
            if (!this._bFallingBall) {
                g3d.renderFigure(_figTable, 0, 0, _layTable, _effectTable);
                g3d.flush();
                g3d.renderFigure(_figTableFrame, 0, 0, _layTable, _effectTable);
                g3d.flush();
                for (i = 0; i < 16; ++i) {
                    if (!this.isBallRenderingEnabled[i]) continue;
                    this.updateShadowLayout(i);
                    if (this.bIsBallInPocket[i]) continue;
                    g3d.renderFigure(_figBallShadow[i], 0, 0, _layBallShadow[i], _effectBall);
                }
                g3d.flush();
                for (i = 0; i < 16; ++i) {
                    this.updateBallLayout(i);
                    if (this.isBallRenderingEnabled[i]) {
                        g3d.renderFigure(_figBall[i], 0, 0, _layBall[i], _effectBall);
                    }
                    this.updateBallNumSprites(i);
                }
                g3d.flush();
            } else {
                for (i = 0; i < 16; ++i) {
                    this.updateBallLayout(i);
                    if (!this.isBallRenderingEnabled[i] || !this.bIsBallInPocket[i] || C._instance.game_state == 8) continue;
                    g3d.renderFigure(_figBall[i], 0, 0, _layBall[i], _effectBall);
                }
                g3d.renderFigure(_figTable, 0, 0, _layTable, _effectTable);
                g3d.flush();
                g3d.renderFigure(_figTableFrame, 0, 0, _layTable, _effectTable);
                g3d.flush();
                for (i = 0; i < 16; ++i) {
                    if (!this.isBallRenderingEnabled[i]) continue;
                    this.updateShadowLayout(i);
                    if (this.bIsBallInPocket[i] || !C._instance.balls[i].active) continue;
                    g3d.renderFigure(_figBallShadow[i], 0, 0, _layBallShadow[i], _effectBall);
                }
                g3d.flush();
                for (i = 0; i < 16; ++i) {
                    this.updateBallLayout(i);
                    if (!this.isBallRenderingEnabled[i] || this.bIsBallInPocket[i]) continue;
                    g3d.renderFigure(_figBall[i], 0, 0, _layBall[i], _effectBall);
                }
                g3d.flush();
            }
            if (this.isBallRenderingEnabled[16]) {
                this.updateBallLayout(16);
                g3d.renderFigure(_figBall[16], 0, 0, _layBall[16], _effectBall);
            }
            this.updateBallNumLayout();
            if (this.canRenderBallNumbers) {
                g3d.renderPrimitives(_texBallNumber, 0, 0, _layBallNum, _effectBall, 83898384, 16, this._VertCoords_BallNum, this.pNormalBallNum, this._TexCoordsBallNum, this._ColorsTarget);
            }
            g3d.flush();
            for (i = 0; i < 8; ++i) {
                this.updateTargetBallLayout(i);
                if (!this.isTargetLineRenderingEnabled) continue;
                g3d.renderFigure(_figTargetBall[i], 0, 0, _layTargetBall[i], _effectTarget);
            }
            g3d.flush();
            if (this.canRenderKiy3D()) {
                this.updateKiyLayout();
                g3d.renderFigure(_figKiy, 0, 0, _layKiy, _effectBall);
            }
            g3d.flush();
            g3d.release(this._grActive);
            this._grActive.setColor(0xFF0000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setBallNumber(int i) {
        if (C._instance.game_state != 1 && C._instance.game_state != 7 && C._instance.game_state != 6 && C._instance.game_state != 5) {
            this.canRenderBallNumbers = false;
            return;
        }
        int h = 32;
        int y = 0;
        this.canRenderBallNumbers = true;
        switch (C.game_player_active) {
            case 0: {
                if (C._instance.plString1 == 108) {
                    if (i >= 8) break;
                    y = h / 2;
                    break;
                }
                if (C._instance.plString1 == 109) {
                    if (i <= 8) break;
                    y = h / 2;
                    break;
                }
                y = 0;
                break;
            }
            case 1: {
                if (C._instance.plString2 == 108) {
                    if (i >= 8) break;
                    y = h / 2;
                    break;
                }
                if (C._instance.plString2 == 109) {
                    if (i <= 8) break;
                    y = h / 2;
                    break;
                }
                y = 0;
                break;
            }
            default: {
                y = h / 2;
                int k = 0;
                int count = 0;
                int j = 0;
                while (i < 16) {
                    try {
                        if (!C._instance.balls[j].active) break;
                        k = j;
                    }
                    catch (NullPointerException e) {
                        count = j;
                        break;
                    }
                    ++i;
                }
                if (count == 0) {
                    count = 16;
                }
                if (k != count - 1) break;
                y = h / 2;
            }
        }
        if (C.game_type != 11) {
            y = h / 2;
            this.canRenderBallNumbers = true;
        }
        if (C._bIsRussian) {
            y = h / 2;
            this.canRenderBallNumbers = true;
        }
        this._TexCoordsBallNum[i * 8 + 0] = 16;
        this._TexCoordsBallNum[i * 8 + 1] = 16;
        this._TexCoordsBallNum[i * 8 + 2] = 0;
        this._TexCoordsBallNum[i * 8 + 3] = 16 * (i - 1);
        this._TexCoordsBallNum[i * 8 + 4] = y;
        this._TexCoordsBallNum[i * 8 + 5] = 16 * (i - 1) + 16;
        this._TexCoordsBallNum[i * 8 + 6] = y + h / 2;
        this._TexCoordsBallNum[i * 8 + 7] = 0;
    }

    public void resetTable(boolean bCPU) {
        C._instance.deg = 0;
        this.cameraDistance = !bCPU ? 130 : 130;
        this.switchToCamera(0);
    }

    public static void prepareReplay() {
    }

    public void switchToCamera(int a_iCameraID) {
        System.out.println("cameraSwitched to " + a_iCameraID);
        this._iCameraID = a_iCameraID;
        switch (a_iCameraID) {
            case 0: {
                break;
            }
            case 1: {
                this.Y_CameraBall = 0;
                this.CameraX = 0;
                this.CameraY = 0;
                this.CameraZ = 0;
                break;
            }
            default: {
                this.setCameraCoords(a_iCameraID);
            }
        }
    }

    public void update_fps() {
        long lTime = System.currentTimeMillis();
        long lDT = lTime - this._lFPSTime;
        if (lDT > 1000L) {
            this._iFPS = (int)((long)this._iFPSCounter * lDT / 1000L);
            this._iFPS = this._iFPS == 0 ? 1 : this._iFPS;
            this._sFPS = "fps: " + this._iFPS;
            this._iFPSCounter = 1;
            this._lFPSTime = lTime;
        } else {
            ++this._iFPSCounter;
        }
    }

    public void initGraphics() {
        int i;
        if (this._bW3dGraphicsInitialized) {
            return;
        }
        for (i = 0; i < 17; ++i) {
            World3D._affBallRotation[i] = new AffineTrans();
            _affBallRotation[i].setIdentity();
            if (i >= 16) continue;
            World3D._layBallShadow[i] = new FigureLayout(_affBallShadow, 1, 1, 88, 110);
            _layBallShadow[i].setPerspective(1, Short.MAX_VALUE, 500);
        }
        for (i = 0; i < 17; ++i) {
            this.loadBall(i);
            World3D._layBall[i] = new FigureLayout(_affBall, 1, 1, 88, 110);
            _layBall[i].setPerspective(1, Short.MAX_VALUE, 500);
            this._iBallPattNum[i] = 1;
        }
        for (i = 0; i < 8; ++i) {
            this.loadTargetBall(i);
            World3D._layTargetBall[i] = new FigureLayout(_affTargetBall, 1, 1, 88, 110);
            _layTargetBall[i].setPerspective(1, Short.MAX_VALUE, 500);
        }
        _affBall = new AffineTrans();
        _affBall.setIdentity();
        this.loadTable();
        this.loadKiy();
        _affTable = new AffineTrans();
        _affTable.setIdentity();
        _layTable = new FigureLayout(_affTable, 1, 1, 88, 110);
        _layTable.setPerspective(1, Short.MAX_VALUE, 500);
        _affTarget = new AffineTrans();
        _layTarget = new FigureLayout(_affTable, 1, 1, 88, 110);
        _layTarget.setPerspective(1, Short.MAX_VALUE, 500);
        _affBallNum = new AffineTrans();
        _layBallNum = new FigureLayout(_affTable, 1, 1, 88, 110);
        _layBallNum.setPerspective(1, Short.MAX_VALUE, 500);
        _layKiy = new FigureLayout(_affKiy, 1, 1, 88, 110);
        _layKiy.setPerspective(1, Short.MAX_VALUE, 500);
        _affRot.setIdentity();
        _effectBall.setLight(_Light);
        _effectBall.setShadingType(0);
        _effectBall.setSemiTransparentEnabled(true);
        _effectBall.setTransparency(true);
        _effectTable.setLight(_LightTable);
        _effectTable.setShadingType(0);
        _effectTable.setSemiTransparentEnabled(true);
        _effectTable.setTransparency(true);
        _effectTarget.setLight(_Light2);
        _effectTarget.setShadingType(0);
        _effectTarget.setSemiTransparentEnabled(true);
        _effectTarget.setTransparency(true);
        try {
            if (_texBallNumber == null) {
                _texBallNumber = new Texture("/symbols.bmp", true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._bChangeCameraAngleWithInterpol = false;
        this._bW3dGraphicsInitialized = true;
    }

    private int setBrigtness(int a_iColor, int a_iCoefficient) {
        int result = a_iColor / a_iCoefficient;
        return result;
    }

    public void setMaterialColor(int a_iBallNum, int a_iBallType, int a_iColor) {
        switch (a_iBallType) {
            case 0: {
                if (a_iColor == 8) {
                    _figBall[a_iBallNum].setPattern(2);
                    break;
                }
                _figBall[a_iBallNum].setPattern(1 << 8 + (8 - a_iColor));
                break;
            }
            case 1: {
                if (a_iColor == 8) {
                    _figBall[a_iBallNum].setPattern(2);
                    break;
                }
                _figBall[a_iBallNum].setPattern(1 << 1 + a_iColor);
            }
        }
    }

    public int get3DCoord(int a_ix, int a_iX1, int a_iX2, int a_iY1, int a_iY2) {
        return a_iY1 + (a_iY2 - a_iY1) * (a_ix - a_iX1) / (a_iX2 - a_iX1);
    }

    public void updateCameraInterpolData(int a_fCamAngle, int a_iCamDist) {
        C._instance.start_interpol3DCam_time = System.currentTimeMillis();
        this.setCameraDistance(a_iCamDist, true);
        this.setCameraAngleH(a_fCamAngle);
        this._bChangeCameraAngleWithInterpol = true;
    }

    public void setCameraCoords(int a_iLoseNumber) {
        switch (a_iLoseNumber) {
            case 0: {
                this.CameraX = -50;
                this.CameraY = 107;
                this.replayAngle = 135;
                break;
            }
            case 1: {
                this.CameraX = -50;
                this.CameraY = 0;
                this.replayAngle = 90;
                break;
            }
            case 2: {
                this.CameraX = -50;
                this.CameraY = -107;
                this.replayAngle = 45;
                break;
            }
            case 3: {
                this.CameraX = 50;
                this.CameraY = 107;
                this.replayAngle = 225;
                break;
            }
            case 4: {
                this.CameraX = 50;
                this.CameraY = 0;
                this.replayAngle = 270;
                break;
            }
            case 5: {
                this.CameraX = 50;
                this.CameraY = -107;
                this.replayAngle = 315;
            }
        }
    }

    public void set3DBallsCoords() {
        if (C._instance.game_state == 8) {
            return;
        }
        try {
            int i;
            boolean offset;
            int gameState = C._instance.game_state;
            switch (gameState) {
                case 0: 
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 11: {
                    if (gameState == 5) {
                        this.rotAround = 0;
                        C._instance.deg = 0;
                        C._instance.updateSinCos();
                    }
                    this.ballXold[0] = this._ballX[0];
                    this.ballYold[0] = this._ballY[0];
                    this._ballX[0] = this.get3DCoord((int)C._instance.balls[0].x, 640, 11392, -47, 47);
                    this._ballY[0] = this.get3DCoord((int)C._instance.balls[0].y, 640, 21504, 106, -106);
                    if (this.bIsBallInPocket[0]) {
                        this._iDeepCounter[0] = this._iDeepCounter[0] + 1;
                        offset = false;
                        switch (this.iLoseWithBallNum[0]) {
                            case 0: {
                                this._ballX[0] = -50;
                                this._ballY[0] = 107;
                                break;
                            }
                            case 1: {
                                this._ballX[0] = -50;
                                this._ballY[0] = 0;
                                break;
                            }
                            case 2: {
                                this._ballX[0] = -50;
                                this._ballY[0] = -107;
                                break;
                            }
                            case 3: {
                                this._ballX[0] = 50;
                                this._ballY[0] = 107;
                                break;
                            }
                            case 4: {
                                this._ballX[0] = 50;
                                this._ballY[0] = 0;
                                break;
                            }
                            case 5: {
                                this._ballX[0] = 50;
                                this._ballY[0] = -107;
                            }
                        }
                    }
                    if (this._iDeepCounter[0] > 3) {
                        this.bIsBallInPocket[0] = false;
                        this._iDeepCounter[0] = 0;
                    }
                    if (C._instance.balls[0].active) {
                        this._iDeepCounter[0] = 0;
                    }
                    if (gameState == 1 || gameState == 5 || gameState == 4 || gameState == 10 || gameState == -1) {
                        if (this._bChangeCameraAngleWithInterpol && System.currentTimeMillis() <= C._instance.start_interpol3DCam_time + 1000L) {
                            int _t = (int)(System.currentTimeMillis() - C._instance.start_interpol3DCam_time);
                            int T = 1000;
                            if (this._iCameraID == 1) {
                                this.Y_CameraBall = 30 - 30 * _t / 1000;
                                this.CameraX = this._ballX[0] - this._ballX[0] * _t / 1000;
                                this.CameraY = this._ballY[0] - this._ballY[0] * _t / 1000;
                                this.CameraZ = 7 - 7 * _t / 1000;
                            } else {
                                this.Y_CameraBall = 30 * _t / 1000;
                                this.CameraX = this._ballX[0] * _t / 1000;
                                this.CameraY = this._ballY[0] * _t / 1000;
                                this.CameraZ = 7 * _t / 1000;
                            }
                        } else if (this._iCameraID == 1) {
                            this.Y_CameraBall = 0;
                            this.CameraX = 0;
                            this.CameraY = 0;
                            this.CameraZ = 0;
                        } else {
                            this.Y_CameraBall = 30;
                            this.CameraX = this._ballX[0];
                            this.CameraY = this._ballY[0];
                            this.CameraZ = 7;
                        }
                    }
                    this.isTargetLineRenderingEnabled = gameState == 1;
                    for (i = 1; i < 16; ++i) {
                        if (C._instance.balls[i].active) {
                            this.ballXold[i] = this._ballX[i];
                            this.ballYold[i] = this._ballY[i];
                            this._ballX[i] = this.get3DCoord((int)C._instance.balls[i].x, 640, 11392, -47, 47);
                            this._ballY[i] = this.get3DCoord((int)C._instance.balls[i].y, 640, 21504, 106, -106);
                            int n = this._ballX[i];
                            this._ball.getClass();
                            int x = n + -47;
                            int n2 = -this._ballY[i];
                            this._ball.getClass();
                            int y = n2 + 4;
                            this._iDeepCounter[i] = 0;
                            continue;
                        }
                        if (this.bIsBallInPocket[i]) {
                            int n = i;
                            this._iDeepCounter[n] = this._iDeepCounter[n] + 1;
                            boolean offset2 = false;
                            switch (this.iLoseWithBallNum[i]) {
                                case 0: {
                                    this._ballX[i] = -50;
                                    this._ballY[i] = 107;
                                    break;
                                }
                                case 1: {
                                    this._ballX[i] = -50;
                                    this._ballY[i] = 0;
                                    break;
                                }
                                case 2: {
                                    this._ballX[i] = -50;
                                    this._ballY[i] = -107;
                                    break;
                                }
                                case 3: {
                                    this._ballX[i] = 50;
                                    this._ballY[i] = 107;
                                    break;
                                }
                                case 4: {
                                    this._ballX[i] = 50;
                                    this._ballY[i] = 0;
                                    break;
                                }
                                case 5: {
                                    this._ballX[i] = 50;
                                    this._ballY[i] = -107;
                                }
                            }
                        }
                        if (this._iDeepCounter[i] <= 3) continue;
                        this.bIsBallInPocket[i] = false;
                        this._iDeepCounter[i] = 0;
                    }
                    if (this._iCameraID <= 1) break;
                    int camID = this._iCameraID - 2;
                    boolean dY = false;
                    boolean dX = false;
                    this.setCameraCoords(camID);
                    this.Y_CameraBall = 20;
                }
            }
            if (gameState == 7 || C.render_cpu_sel_ball_and_lose && gameState == -1) {
                this._ballX[16] = this.get3DCoord((int)C._instance.balls[C.game_num_sel_ball].x, 640, 11392, -47, 47);
                this._ballY[16] = this.get3DCoord((int)C._instance.balls[C.game_num_sel_ball].y, 640, 21504, 106, -106);
                this.isBallRenderingEnabled[16] = true;
            } else if (gameState == 6 || C.render_cpu_sel_ball_and_lose && gameState == 10) {
                offset = false;
                switch (C.game_num_sel_lose) {
                    case 0: {
                        this._ballX[16] = -50;
                        this._ballY[16] = 107;
                        break;
                    }
                    case 1: {
                        this._ballX[16] = -56;
                        this._ballY[16] = 0;
                        break;
                    }
                    case 2: {
                        this._ballX[16] = -50;
                        this._ballY[16] = -107;
                        break;
                    }
                    case 3: {
                        this._ballX[16] = 50;
                        this._ballY[16] = 107;
                        break;
                    }
                    case 4: {
                        this._ballX[16] = 56;
                        this._ballY[16] = 0;
                        break;
                    }
                    case 5: {
                        this._ballX[16] = 50;
                        this._ballY[16] = -107;
                    }
                }
                this.isBallRenderingEnabled[16] = true;
            } else {
                this.isBallRenderingEnabled[16] = false;
            }
            for (i = 0; i < 16; ++i) {
                this.isBallRenderingEnabled[i] = C._instance.balls[i].active;
                if (i == C.game_num_sel_ball && (gameState == 7 || C.render_cpu_sel_ball_and_lose && gameState == -1)) {
                    this.isBallRenderingEnabled[i] = false;
                }
                if (!C._instance.balls[i].active) {
                    this.isBallRenderingEnabled[i] = this.bIsBallInPocket[i];
                }
                if (C.game_view_num_balls) {
                    if (i != 0) {
                        this.setBallNumber(i);
                    }
                } else {
                    this.canRenderBallNumbers = false;
                }
                if (C._instance.ball0inLoseCount > 5) {
                    int n = C._instance.ball0inLoseCount;
                    C._instance.getClass();
                    if (n < 10 && C._instance.balls[i].lose != -1) {
                        this.isBallRenderingEnabled[i] = false;
                    }
                }
                if (gameState == 5) {
                    // empty if block
                }
                if (!C._instance.balls[i].active) continue;
                this.isBallRenderingEnabled[i] = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void placeBall3DInPocket(int a_iLose, int a_iBallNum) {
        this.iLoseWithBallNum[a_iBallNum] = a_iLose;
        this.bIsBallInPocket[a_iBallNum] = true;
    }

    void updateTargetSprites() {
        long cn1 = C._instance.cn * 21L / (long)C.game_max_speed;
        long sn1 = C._instance.sn * 21L / (long)C.game_max_speed;
        for (int i = 0; i < 8; ++i) {
            int x = (int)C._instance.balls[0].x + (int)((long)((i + 1) * 1 * 3 * 2) * cn1);
            int y = (int)C._instance.balls[0].y + (int)((long)((i + 1) * 1 * 3 * 2) * sn1);
            int cursX = this.get3DCoord(x, 640, 11392, -47, 47);
            int cursY = this.get3DCoord(y, 640, 21504, 106, -106);
            this._VertCoords_Target[i * 3 + 0] = cursX;
            this._VertCoords_Target[i * 3 + 1] = cursY;
            this._VertCoords_Target[i * 3 + 2] = 0;
            this.pNormalTarget[i * 3 + 0] = 4096;
            this.pNormalTarget[i * 3 + 1] = 4096;
            this.pNormalTarget[i * 3 + 2] = 4096;
            this._ColorsTarget[i] = 0xFFFFFF;
        }
        this.updateTargetLayout();
    }

    void updateBallNumSprites(int i) {
        int x = this._ballX[i];
        int y = this._ballY[i];
        if (!(this.isBallRenderingEnabled[i] && C.game_view_num_balls && C._instance.balls[i].active)) {
            x = -1000;
            y = -1000;
        }
        this._VertCoords_BallNum[i * 3 + 0] = x;
        this._VertCoords_BallNum[i * 3 + 1] = y;
        this._VertCoords_BallNum[i * 3 + 2] = 0;
        this.pNormalBallNum[i * 3 + 0] = 4096;
        this.pNormalBallNum[i * 3 + 1] = 4096;
        this.pNormalBallNum[i * 3 + 2] = 4096;
        this._ColorsBallNum[i] = 0xFFFFFF;
    }

    void updateTargetPolygones() {
        int unitW = 30;
        int unitH = 30;
        long cn1 = C._instance.cn * 21L / (long)C.game_max_speed;
        long sn1 = C._instance.sn * 21L / (long)C.game_max_speed;
        for (int i = 0; i < 8; ++i) {
            int x = (int)C._instance.balls[0].x + (int)((long)(i * 1 * 3 * 2) * cn1);
            int y = (int)C._instance.balls[0].y + (int)((long)(i * 1 * 3 * 2) * sn1);
            int cursX = this.get3DCoord(x, 640, 11392, -47, 47);
            int cursY = this.get3DCoord(y, 640, 21504, 106, -106);
            for (int j = 0; j < 4; ++j) {
                switch (j) {
                    case 0: {
                        this._VertCoords_Target[i * 3 + 0 + j] = cursX - 15;
                        this._VertCoords_Target[i * 3 + 1 + j] = cursY + 15;
                        this._VertCoords_Target[i * 3 + 2 + j] = 10;
                        break;
                    }
                    case 1: {
                        this._VertCoords_Target[i * 3 + 0 + j] = cursX + 15;
                        this._VertCoords_Target[i * 3 + 1 + j] = cursY + 15;
                        this._VertCoords_Target[i * 3 + 2 + j] = 10;
                        break;
                    }
                    case 2: {
                        this._VertCoords_Target[i * 3 + 0 + j] = cursX + 15;
                        this._VertCoords_Target[i * 3 + 1 + j] = cursY - 15;
                        this._VertCoords_Target[i * 3 + 2 + j] = 10;
                        break;
                    }
                    case 3: {
                        this._VertCoords_Target[i * 3 + 0 + j] = cursX - 15;
                        this._VertCoords_Target[i * 3 + 1 + j] = cursY - 15;
                        this._VertCoords_Target[i * 3 + 2 + j] = 10;
                    }
                }
                this.pNormalTarget[i * 3 + 0 + j] = 0;
                this.pNormalTarget[i * 3 + 1 + j] = 0;
                this.pNormalTarget[i * 3 + 2 + j] = 0;
            }
            this._ColorsTarget[i] = 0xFFFFFF;
        }
    }

    void initTargetSprites() {
        for (int i = 0; i < 8; ++i) {
            this._TexCoordsTarget[i * 8 + 0] = 40;
            this._TexCoordsTarget[i * 8 + 1] = 40;
            this._TexCoordsTarget[i * 8 + 2] = 2048;
            this._TexCoordsTarget[i * 8 + 3] = 0;
            this._TexCoordsTarget[i * 8 + 4] = 0;
            this._TexCoordsTarget[i * 8 + 5] = 128;
            this._TexCoordsTarget[i * 8 + 6] = 64;
            this._TexCoordsTarget[i * 8 + 7] = 0;
        }
    }

    public boolean isCrossingKiyWithBall(int Index) {
        long sn0 = 0L;
        long cn0 = 0L;
        long cn1 = C._instance.cn * 21L / (long)C.game_max_speed;
        long sn1 = C._instance.sn * 21L / (long)C.game_max_speed;
        for (int i = 1; i < 40; ++i) {
            int x = (int)C._instance.balls[0].x - (int)((long)(i * 1 * 3) * cn1);
            int y = (int)C._instance.balls[0].y - (int)((long)(i * 1 * 3) * sn1);
        }
        return false;
    }

    public void initNewGame() {
        int i;
        this.cacheDy = 0;
        this.bcpuKiyBack = false;
        this.resetTable(false);
        this.rotAround = 0;
        this.rotAroundOld = 0;
        this.rotAroundNew = 0;
        this.Kdy = 0;
        this._bKiyMoveInterpol = false;
        for (i = 0; i < 16; ++i) {
            this.bIsBallInPocket[i] = false;
            this._iDeepCounter[i] = 0;
        }
        for (i = 0; i < 17; ++i) {
            _affBallRotation[i].setIdentity();
        }
    }

    public void updateFallingBallFlag() {
        for (int i = 0; i < 16; ++i) {
            this._bFallingBall = this.bIsBallInPocket[i];
            if (this._bFallingBall) break;
        }
    }

    void rotateBall(int a_iNum) {
        int deltaX = 47 + this._ballX[a_iNum];
        int deltaY = 106 + this._ballY[a_iNum];
        this.angleBallRotY = deltaY * 360 / 30;
        this.angleBallRotX = deltaX * 360 / 30;
        AffineTrans aff = new AffineTrans();
        aff.setIdentity();
        _affBallRotation[a_iNum].setIdentity();
        if (!this.isBallWholeType[a_iNum] && !C._bIsRussian) {
            this.vRotX = _affBallRotation[a_iNum].transform(this.vX);
            this.vRotY = _affBallRotation[a_iNum].transform(this.vY);
            this.vRotX.unit();
            this.vRotY.unit();
            aff.setIdentity();
            aff.rotationV(this.vRotX, -this.degToUnits(this.angleBallRotY));
            _affBallRotation[a_iNum].mul(aff);
            aff.setIdentity();
            aff.rotationV(this.vRotY, this.degToUnits(this.angleBallRotX));
            _affBallRotation[a_iNum].mul(aff);
        } else {
            _affBallRotation[a_iNum].setIdentity();
            AffineTrans affWhole = new AffineTrans();
            affWhole.setIdentity();
            if (a_iNum == 16) {
                affWhole.rotationX(this.degToUnits(-110));
            } else {
                affWhole.rotationX(this.degToUnits(-25));
            }
            _affBallRotation[a_iNum].mul(affWhole);
        }
        _affBall.mul(_affBallRotation[a_iNum]);
    }

    static {
        _layBall = new FigureLayout[17];
        _layBallShadow = new FigureLayout[16];
        _layTargetBall = new FigureLayout[8];
        _layBallNum = new FigureLayout();
        _effectBall = new Effect3D();
        _effectTable = new Effect3D();
        _effectTarget = new Effect3D();
        _iKiyMoveDir = 0;
        _affBallShadow = new AffineTrans();
        _affTargetBall = new AffineTrans();
        _affKiy = new AffineTrans();
        _affBallNum = new AffineTrans();
        _affRot = new AffineTrans();
        _affBallRotation = new AffineTrans[17];
        _lightDir = 4096;
        _lightAmbi = 1024;
        _lightDirTable = 512;
        _lightAmbiTable = 3072;
        _Light = new Light(new Vector3D(0, 0, 4096), _lightDir, _lightAmbi);
        _Light2 = new Light(new Vector3D(0, 4000, 0), _lightDir, _lightAmbi);
        _LightTable = new Light(new Vector3D(0, 0, 4096), _lightDirTable, _lightAmbiTable);
    }
}

