/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class SoundManager {
    private final int MAX_SOUNDS;
    private final int MIN_DURATION;
    private final int MAX_DURATION;
    private final int SOUND_NONE;
    private String[] filenames = new String[10];
    private Player[] players = new Player[10];
    private int playingSoundId = -1;
    private int playSoundId = -1;
    private long oldTime = 0L;
    private long currentTime = 0L;
    private long deltaTime = 0L;
    private boolean soundEnabled = true;
    private int minDuration = 50;

    SoundManager() {
        this.MAX_SOUNDS = 10;
        this.MIN_DURATION = 50;
        this.MAX_DURATION = 60000;
        this.SOUND_NONE = -1;
        for (int i = 0; i < 10; ++i) {
            this.players[i] = null;
        }
    }

    public void setSound(String string, int n) {
        try {
            this.filenames[n] = string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setMinDuration(int n) {
        this.minDuration = n < 50 ? 50 : (n > 60000 ? 60000 : n);
    }

    public void reloadSounds() {
        int n = 0;
        try {
            for (n = 0; n < 10; ++n) {
                if (this.players[n] == null) continue;
                this.players[n].close();
                this.players[n] = null;
            }
            for (n = 0; n < 10; ++n) {
                if (this.filenames[n] == null) continue;
                InputStream inputStream = this.getClass().getResourceAsStream(this.filenames[n]);
                this.players[n] = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
                this.players[n].realize();
                inputStream.close();
            }
        }
        catch (Exception exception) {
            System.out.println("Error loading " + this.filenames[n]);
            exception.printStackTrace();
        }
    }

    public void playSound(int n) {
        this.playSoundId = n;
    }

    public void tickSound() {
        try {
            this.currentTime = System.currentTimeMillis();
            if (this.oldTime > this.currentTime) {
                this.oldTime = this.currentTime;
            }
            if (!this.soundEnabled) {
                return;
            }
            if (this.playSoundId == -1 || this.players[this.playSoundId] == null) {
                return;
            }
            if (this.playingSoundId != -1 && this.playingSoundId == this.playSoundId && (this.playingSoundId == 9 || this.playingSoundId == 6)) {
                return;
            }
            this.deltaTime = this.currentTime - this.oldTime - (long)this.minDuration;
            if (this.deltaTime < 0L) {
                this.deltaTime = 0L;
            }
            if (this.deltaTime >= (long)this.minDuration) {
                for (int i = 0; i < 10; ++i) {
                    int n;
                    if (this.players[i] == null || (n = this.players[i].getState()) != 400 && n != 300) continue;
                    this.players[i].deallocate();
                }
                this.players[this.playSoundId].start();
                this.playingSoundId = this.playSoundId;
                this.playSoundId = -1;
                this.oldTime = this.currentTime;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stopSound() {
        try {
            for (int i = 0; i < 10; ++i) {
                int n;
                if (this.players[i] == null || (n = this.players[i].getState()) != 400 && n != 300) continue;
                this.players[i].deallocate();
            }
            this.playingSoundId = -1;
            this.playSoundId = -1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void cleanup() {
        try {
            for (int i = 0; i < 10; ++i) {
                if (this.players[i] == null) continue;
                this.players[i].close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void enableSound() {
        this.soundEnabled = true;
    }

    public void disableSound() {
        this.soundEnabled = false;
    }

    public boolean isSoundEnabled() {
        return this.soundEnabled;
    }
}

