/*
 * Decompiled with CFR 0.152.
 */
public final class CPlayer
extends Actor {
    public CTeam m_myTeam;
    public CTeam m_opTeam;
    public int m_Number;
    public int m_role;
    public int m_evaluation;
    public int m_successTackleTime;
    public int m_successFeintTime;
    public int m_successPassTime;
    public int m_successSaveTime;
    public int m_goalTime;
    public int m_asistTime;
    public int m_speed;
    public int m_speedWithBall;
    public int m_speedMove;
    public int m_speedFast;
    public int m_speedFastWithBall;
    public int m_reaction;
    public int m_inaccuracy;
    public int m_controlRange;
    public int m_card;
    public int m_showCard;
    public int m_character;
    public byte m_starAbility = 0;
    public int m_court;
    public int m_dirToBall;
    public int m_disToBall;
    public boolean m_beShoved;
    public int m_lastAbilityAtt;
    public int m_lastAbilityDef;
    public int m_lastAbilitySpd;
    public int m_lastAbilityTech;
    public int m_curAbilityAtt;
    public int m_curAbilityDef;
    public int m_curAbilitySpd;
    public int m_curAbilityTech;
    public int m_curAbilityPow;
    public int m_fatigue;
    public int m_abFatigue;
    public int m_timeFatigue;
    public int m_onCourtTime;
    public int m_lastGameMinutes;
    public int m_lastTimeFatigue;
    public int m_roleFatigue;
    public boolean m_destReached;
    public boolean m_destChanged;
    private int m_destRangeRadius;
    public long m_waitEndsTick;
    private long m_inertiaEndsTick;
    public int m_currState;
    public int m_nextState;
    public int m_currDir;
    protected int m_nextDir;
    private int m_param1;
    private int m_param2;
    public int m_param3;
    public int m_idea = -1;
    public int m_ideaParam1;
    public int m_preState;
    public int m_preDir;
    private int m_preParam1;
    private int m_preParam2;
    public boolean m_preFastRun;
    public boolean m_isFastRun;
    public boolean m_fast2Fast;
    public boolean m_isFeint;
    public boolean m_doHumanWallJump;
    private int m_runningTick;
    private int[] m_turnFastDelay = new int[6];
    private static final int[][] TURN_FAST_DELAY = new int[][]{{0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0}, {1, 0, 1, 0, 0, 0}, {1, 1, 1, 0, 0, 0}};
    private long m_foolEndsTick;
    public int m_feint = -1;
    public long m_feintEndsTick = 0L;
    private int m_outBallParam1;
    private int m_outBallParam2;
    private int m_outBallParam3;
    private int m_outBallParam4;
    public static CPlayer s_ballTackledOutBy = null;
    static boolean s_tackleFail;
    public static int s_passPointX;
    public static int s_passPointY;
    public static int s_passPlayerNumber;
    private static int[] SHOOT_MIN_HALF_RANGE;
    public static int s_shootMinY;
    public static int s_shootMaxY;
    public static int s_savePointX;
    public static int s_savePointY;
    public static int s_savePointZ;
    private static int s_saveTick;
    private static int s_saveMin;
    protected static boolean s_GKPickingUpBall;
    public boolean m_isFocus;
    public static CPlayer s_focusPlayer;
    public static int s_radar;
    public static int s_power;
    public static int s_radarPower;
    public static long s_powerDisappearTime;
    private static long s_lastPadTick;
    public static int s_lastPadDir;
    private static int s_lastInputDir;
    public int m_dribbleState = 0;
    public boolean m_fastrun;
    boolean m_steponball;
    public boolean m_withBall;
    public static CPlayer s_ballOwner;
    public static CPlayer s_ballLastOwner;
    public static CPlayer s_ballFastOwner;
    public static CPlayer s_shootPlayer;
    public static CPlayer s_ballLastPlayer;
    public static int s_ctrWithBall;
    public static int s_ctrWithoutBall;
    public static CPlayer s_lastAsistPlayer;
    public boolean m_isBallReceiver;
    public static CPlayer[] s_ballReceiver;
    private int m_ballReceiverState;
    private boolean m_canHead;
    public static CPlayer s_potentialOffsidePlayer;
    public boolean m_mustChangeAction;
    public int m_behavior;
    public static int s_vectorX;
    public static int s_vectorY;
    public int m_gridX;
    public int m_gridY;
    public int m_defaultGridX;
    public int m_defaultGridY;
    public int m_formationGridX;
    public int m_formationGridY;
    public int m_destGridX;
    public int m_destGridY;
    public int m_tacState;
    public int m_coachSetTacState;
    public int m_coachSetDestGridX;
    public int m_coachSetDestGridY;
    public int m_coachSetMarkID;
    public int m_markID;
    public int m_attackGridX;
    public int m_defendGridX;
    public boolean m_startToRunFor12;
    public static CPlayer[] s_oneTwoPlayer;
    public static int[] s_oneTwoStartPointX;
    public static boolean[] s_oneTwoPressed;

    protected final void initProperties() {
        int n = this.m_myTeam.m_ID * 192 + this.m_Number * 12;
        this.m_curAbilitySpd = Device.s_playerData[n + 0];
        this.m_curAbilityTech = Device.s_playerData[n + 1];
        this.m_curAbilityAtt = Device.s_playerData[n + 2];
        this.m_curAbilityDef = Device.s_playerData[n + 3];
        this.m_curAbilityPow = Device.s_playerData[n + 11];
        this.m_character = Device.s_playerData[n + 5];
        this.m_starAbility = (byte)(Device.s_playerData[n + 6] & 0xF);
        this.m_successFeintTime = 0;
        this.m_successPassTime = 0;
        this.m_successSaveTime = 0;
        this.m_successTackleTime = 0;
        this.m_goalTime = 0;
        this.m_asistTime = 0;
        this.m_evaluation = 6;
        Device.playerNameInMatch[this.m_Number] = Device.playerName[0][this.m_Number];
        if (Device.s_playerData[n + 4] == 0) {
            this.updateProperties(1);
        } else if (Device.s_playerData[n + 4] == 2) {
            this.updateProperties(-1);
        } else if (Device.s_playerData[n + 4] == 3) {
            this.updateProperties(-4);
        } else {
            this.updateProperties(0);
        }
        if (this.m_Number != 0 && (Device.s_playerData[n + 6] & 1 << this.m_role - 1) == 0) {
            this.updateProperties(-1);
        }
        if (Device.s_matchDifficult == 5 && this.m_myTeam.m_type == 1) {
            this.updateProperties(4);
            this.m_curAbilityDef = this.m_lastAbilityDef;
        }
        this.m_lastAbilitySpd = this.m_curAbilitySpd;
        this.m_lastAbilityTech = this.m_curAbilityTech;
        this.m_lastAbilityAtt = this.m_curAbilityAtt;
        this.m_lastAbilityDef = this.m_curAbilityDef;
    }

    public final void updateProperties(int n) {
        this.m_lastAbilitySpd = this.m_curAbilitySpd;
        this.m_lastAbilityTech = this.m_curAbilityTech;
        this.m_lastAbilityAtt = this.m_curAbilityAtt;
        this.m_lastAbilityDef = this.m_curAbilityDef;
        this.m_curAbilityAtt -= n;
        this.m_curAbilityDef -= n;
        this.m_curAbilitySpd -= n;
        this.m_curAbilityTech -= n;
        this.m_curAbilityAtt = Device.limit(this.m_curAbilityAtt, 0, 3);
        this.m_curAbilityDef = Device.limit(this.m_curAbilityDef, 0, 3);
        this.m_curAbilitySpd = Device.limit(this.m_curAbilitySpd, 0, 3);
        this.m_curAbilityTech = Device.limit(this.m_curAbilityTech, 0, 3);
        this.m_destRangeRadius = this.m_speed = 1728 + (1 - this.m_curAbilitySpd) * 128;
        this.m_speedWithBall = this.m_speed - 256;
        this.m_speedMove = this.m_Number == 0 ? (Device.s_matchDifficult > 1 ? (this.m_speed << 2) / 5 : (this.m_speed >> 1) / 3) : this.m_speed / 3;
        this.m_speedFast = this.m_speed * 5 >> 2;
        this.m_speedFastWithBall = this.m_speedFast - 256;
        this.m_reaction = 4 + this.m_curAbilityDef * 4;
        if (this.m_Number == 0) {
            this.m_inaccuracy = 4352 - this.m_curAbilityAtt * 384;
            this.m_controlRange = 256 - this.m_curAbilityDef * 256;
            return;
        }
        this.m_inaccuracy = 256 + this.m_curAbilityAtt * 768;
        this.m_controlRange = 3840 + (3 - this.m_curAbilityDef) * 512;
    }

    public final void initFatigue(int n) {
        this.m_fatigue = 0;
        this.m_abFatigue = 0;
        this.m_timeFatigue = 0;
        this.m_lastGameMinutes = 0;
        this.m_onCourtTime = n;
        if (this.m_role == 0) {
            this.m_roleFatigue = 40;
        } else if (this.m_role == 1) {
            this.m_roleFatigue = 50;
        } else if (this.m_role == 2) {
            this.m_roleFatigue = 60;
        } else if (this.m_role == 3) {
            this.m_roleFatigue = 70;
        }
        if ((this.m_starAbility & 0x40) != 0) {
            this.m_roleFatigue = 30;
        }
    }

    public final void updateFatigue(int n) {
        if (Device.s_whichHalf == 3) {
            n += 90;
        }
        if (Device.s_whichHalf == 4) {
            n += 105;
        }
        if (this.m_court == 1) {
            return;
        }
        if (this.m_lastGameMinutes == n) {
            return;
        }
        this.m_lastGameMinutes = n;
        this.m_timeFatigue = (n - this.m_onCourtTime) * this.m_roleFatigue / 90;
        this.m_fatigue = this.m_timeFatigue + this.m_abFatigue;
        if (this.m_lastTimeFatigue != this.m_timeFatigue) {
            this.m_lastTimeFatigue = this.m_timeFatigue;
            if (this.m_fatigue > 100) {
                this.updateProperties(-2);
                return;
            }
            if (this.m_fatigue > 80) {
                this.updateProperties(-1);
            }
        }
    }

    private void addFatigue(int n) {
        if ((this.m_starAbility & 0x40) == 0) {
            this.m_abFatigue += n;
        }
    }

    public final boolean haveCommandFinished() {
        if (this.m_currState == 10) {
            return false;
        }
        return !(this.m_currDir != this.m_nextDir || this.m_nextState != 0 && !this.m_destReached || Device.s_tickCounter < this.m_waitEndsTick || !this.m_actionOver && !this.m_actionCycle || this.m_myTeam.m_commandList[this.m_Number << 4] == 13 && !this.m_withBall);
    }

    public final void stand(boolean bl) {
        if (bl) {
            this.m_currState = 0;
            this.m_nextState = 0;
            this.m_nextDir = this.m_currDir;
            this.m_mustChangeAction = true;
            if (CTeam.s_matchState == 11 || CTeam.s_matchState == 13) {
                this.setBehavior(41);
                this.m_destReached = true;
            } else {
                this.setBehavior(0);
                this.m_destReached = false;
            }
        } else {
            this.m_steponball = !this.m_steponball && this.m_withBall && CTeam.s_matchState == 0 && this.m_currState != 0 && this.m_currDir == this.m_nextDir;
            this.m_nextState = 0;
        }
        this.m_waitEndsTick = 0L;
    }

    public final void wait(int n) {
        if (this.m_currState != 0) {
            this.stand(false);
        }
        this.m_waitEndsTick = Device.s_tickCounter + (long)n;
    }

    private void receiveTurnInertia(int n) {
        this.m_inertiaEndsTick = Device.s_tickCounter + (long)n;
        this.m_currState = 10;
    }

    public final void gkRunTo(int n, int n2) {
        int n3 = CPlayer.dirTo(n - this.m_posX, n2 - this.m_posY);
        int n4 = CPlayer.dirDifference(this.m_currDir, n3);
        int n5 = Device.fastDistance(this.m_posX - n, this.m_posY - n2);
        if (n4 == 0 || this.m_withBall || n5 > 16384) {
            this.m_nextState = 1;
            if (n5 > 1024) {
                this.m_nextDir = n3;
            }
            this.m_param1 = n;
            this.m_param2 = n2;
            int n6 = this.m_param3 = this.m_withBall || n5 < 9216 ? 0 : 8;
            if (CTeam.s_matchState == 11) {
                this.m_param3 = 0;
            }
        } else {
            this.m_nextState = 1;
            this.m_nextDir = this.m_dirToBall;
            this.m_param1 = n;
            this.m_param2 = n2;
            this.m_param3 = n4 == 4 || n4 == 0 ? 2 : 1;
        }
        this.m_destReached = false;
        this.m_destChanged = true;
        this.m_waitEndsTick = 0L;
    }

    public final void runTo(int n, int n2, boolean bl) {
        this.m_runningTick = this.m_currState != 1 && !this.m_isFocus && !this.m_isBallReceiver ? 0 : 3;
        int n3 = CPlayer.dirTo(n - this.m_posX, n2 - this.m_posY);
        int n4 = Device.fastDistance(this.m_posX - n, this.m_posY - n2);
        int n5 = CPlayer.dirDifference(this.m_currDir, n3);
        if (CTeam.s_matchState == 11) {
            this.m_nextState = 1;
            this.m_nextDir = n3;
            this.m_param1 = n;
            this.m_param2 = n2;
            this.m_param3 = 0;
        } else if (n5 >= -1 && n5 <= 1 || this.m_dirToBall != this.m_currDir || this.m_withBall || this.m_isBallReceiver || (n5 == 4 && s_ballOwner == null ? n4 > 10240 : n4 > 24576)) {
            this.m_nextState = 1;
            if (n4 > 512) {
                this.m_nextDir = n3;
            }
            this.m_param1 = n;
            this.m_param2 = n2;
            if (bl || CTeam.s_matchState == 0 && n4 > 51200 && s_oneTwoPlayer[this.m_myTeam.m_ID] != this) {
                this.m_fastrun = true;
                if (this.m_runningTick != 0) {
                    this.m_dribbleState = 1;
                    this.m_param3 = 8;
                } else {
                    this.m_dribbleState = 0;
                    this.m_param3 = 0;
                }
            } else {
                this.m_fastrun = false;
                this.m_dribbleState = 0;
                this.m_param3 = 0;
            }
            if (!this.m_withBall) {
                this.m_dribbleState = 2;
            }
        } else {
            this.m_nextState = 1;
            this.m_param1 = n;
            this.m_param2 = n2;
            this.m_param3 = n5 == 4 ? 2 : 1;
        }
        if (CTeam.s_matchState == 0 || CTeam.s_matchState == 3) {
            this.m_param1 = Device.limit(this.m_param1, -135168, 135168);
            this.m_param2 = Device.limit(this.m_param2, -86016, 86016);
        }
        this.m_destReached = false;
        this.m_destChanged = true;
        this.m_waitEndsTick = 0L;
    }

    private void runOn(int n) {
        int n2 = CPlayer.dirDifference(this.m_currDir, n);
        if (n2 >= -1 && n2 <= 1 || this.m_dirToBall != this.m_currDir || this.m_withBall || this.m_isBallReceiver) {
            this.m_nextDir = n;
            this.m_param3 = this.m_fastrun ? 7 : 3;
        } else {
            this.m_nextDir = this.m_currDir;
            this.m_param1 = n;
            this.m_param3 = n2 == 4 ? 5 : 4;
        }
        this.m_nextState = 1;
        this.m_destReached = false;
        this.m_waitEndsTick = 0L;
    }

    public final void turn(int n) {
        int n2 = this.m_nextDir = n == -1 ? this.m_dirToBall : n;
        if (this.m_myTeam.m_type == 1) {
            this.stand(false);
        }
    }

    public final void directTurn(int n) {
        this.m_preDir = n;
        this.m_preState = -1;
        CPlayer.s_oneTwoPlayer[this.m_myTeam.m_ID] = null;
    }

    public final void pass(int n, int n2, int n3) {
        this.m_nextState = 2;
        this.m_param1 = n;
        this.m_param2 = n2;
        if (s_oneTwoPlayer[this.m_myTeam.m_ID] != null) {
            this.m_param1 = CPlayer.s_oneTwoPlayer[this.m_myTeam.m_ID].m_posX;
            this.m_param2 = CPlayer.s_oneTwoPlayer[this.m_myTeam.m_ID].m_posY;
        }
        if (CTeam.s_matchState == 0 && (this.m_myTeam.convertPos(this.m_param1) >= 0 || s_oneTwoPlayer[this.m_myTeam.m_ID] != null || s_power >= 3 && this.m_myTeam.m_type == 0)) {
            int n4 = 0;
            boolean bl = true;
            if (s_power >= 3 && this.m_myTeam.m_type == 0) {
                n4 = 65536 * (s_power - 3) / 12;
            } else if (s_oneTwoPlayer[this.m_myTeam.m_ID] != null) {
                n4 = 65536 / (Device.random(0, 1) == 0 ? 3 : 4);
            } else if (this.m_character == 4 && Device.random(0, 1) == 0) {
                n4 = 65536 / (Device.random(0, 1) == 0 ? 6 : 8);
            } else {
                int n5 = Device.fastDistance(this.m_param1 - this.m_posX, this.m_param2 - this.m_posY);
                n4 = n5 >> 2;
                if (n4 > 65536 - n5) {
                    n4 = 65536 - n5;
                }
                bl = false;
            }
            if (bl && n4 < 12288) {
                n4 = 12288;
            }
            this.m_param1 += this.m_myTeam.m_leftSide ? n4 : -n4;
        }
        this.m_param3 = n3;
    }

    public final void directPass(int n, int n2) {
        this.m_preState = 2;
        this.m_preParam1 = n;
        this.m_preParam2 = n2;
    }

    public final void longPass(int n, int n2, int n3) {
        this.m_nextState = 3;
        this.m_param1 = n;
        this.m_param2 = n2;
        this.m_param3 = n3;
    }

    public final void shoot(int n) {
        if (Device.s_aiMode == 6) {
            CTeam.s_isTutorialShoot = true;
        }
        if (Device.s_whichHalf == 99) {
            CTeam.s_penaltyEndTime = Device.s_tickCounter + 30L;
            CTeam.s_penaltySuccessful = false;
        }
        if (this.calShootRange()) {
            if (Math.abs(Actor.s_football.m_posX) > 132608) {
                this.m_param1 = this.m_myTeam.m_leftSide ? 136448 : -136448;
            } else {
                int n2 = this.m_param1 = this.m_myTeam.m_leftSide ? 135168 : -135168;
            }
            this.m_param2 = this.m_myTeam.m_type == 0 ? s_shootMinY + (s_shootMaxY - s_shootMinY) * (Device.s_shootCursor - Device.SHOOT_RADAR_X) / 66 : (Device.s_matchDifficult > 1 ? Device.random(s_shootMinY - 2 * this.m_inaccuracy, s_shootMaxY + 2 * this.m_inaccuracy) : Device.random(s_shootMinY - 4 * this.m_inaccuracy, s_shootMaxY + 4 * this.m_inaccuracy));
            int n3 = CPlayer.dirTo(this.m_myTeam.convertPos(135168) - this.m_posX, 0 - this.m_posY);
            int n4 = CPlayer.dirDifference(n3, this.m_currDir);
            int n5 = Device.fastDistance(this.m_posX - this.m_param1, this.m_posY - this.m_param2);
            boolean bl = false;
            if (this.m_isFocus) {
                bl = this.m_preState == 13;
            } else {
                int n6 = this.m_opTeam.m_GK.m_posX;
                int n7 = this.m_opTeam.m_GK.m_posY;
                int n8 = Device.fastDistance(n6 - this.m_posX, n7 - this.m_posY);
                boolean bl2 = bl = Device.random(0, 2) == 0 && Device.isPointBetweenTwoPoints(n6, n7, this.m_posX, this.m_posY, this.m_param1, this.m_param2) && n8 < 16384 && n8 < Device.fastDistance(n6 - this.m_param1, n7 - this.m_param2);
            }
            if (bl) {
                this.m_param3 = s_power < 6 && this.m_opTeam.isPointInMyFBZ(this.m_posX, this.m_posY) ? 0 : n + Device.random(0, this.m_inaccuracy);
                n5 = 25600 + n5 * (s_power - 1) / 11;
                CPlayer.parseVector(n5, this.m_param1 - this.m_posX >> 8, this.m_param2 - this.m_posY >> 8);
                this.m_param1 = this.m_posX + s_vectorX;
                this.m_param2 = this.m_posY + s_vectorY;
                this.m_idea = 4;
                this.m_nextState = 3;
                return;
            }
            CTeam.s_isCurveshoot = false;
            this.m_param3 = s_power < 6 && this.m_opTeam.isPointInMyFBZ(this.m_posX, this.m_posY) ? 0 : n + Device.random(0, this.m_inaccuracy);
            n5 = 51200 - this.m_curAbilityPow * 10240 + n5 * (s_power - 1) / 11;
            if (n4 == 4) {
                n5 = n5 * 40 / 100;
            } else if (n4 == -3 || n4 == 3) {
                n5 = n5 * 60 / 100;
            } else if (n4 == -2 || n4 == 2) {
                n5 = n5 * 80 / 100;
            }
            CPlayer.parseVector(n5, this.m_param1 - this.m_posX >> 8, this.m_param2 - this.m_posY >> 8);
            this.m_param1 = this.m_posX + s_vectorX;
            this.m_param2 = this.m_posY + s_vectorY;
            this.m_nextState = 4;
            return;
        }
        this.m_nextState = 3;
        if (this.m_myTeam.m_leftSide ? this.m_posX <= -49152 : this.m_posX >= 49152) {
            this.selectPassPoint(this.m_myTeam.m_leftSide ? 2 : 6, 3);
        } else {
            int n9 = CPlayer.dirTo(((this.m_myTeam.m_leftSide ? 528 : -528) << 8) - this.m_posX, 0 - this.m_posY);
            this.selectPassPoint(n9, 2);
        }
        this.m_param1 = s_passPointX;
        this.m_param2 = s_passPointY;
        this.m_param3 = 0;
    }

    public final void directShoot() {
        this.m_preState = 4;
    }

    public final void tackle() {
        if (this.m_opTeam.m_GK.m_currState != 8) {
            this.m_nextState = 5;
        }
    }

    public final void slideTackle() {
        if (this.m_opTeam.m_GK.m_currState != 8) {
            this.m_nextState = 6;
        }
    }

    public final void saveball() {
        this.m_nextState = 7;
    }

    public final void tracePlayerBegin(int n) {
        this.m_idea = 0;
        this.m_ideaParam1 = n;
    }

    public final void tracePlayerEnd() {
        this.m_idea = s_ballOwner == null && s_ballFastOwner == null && this.m_isFocus ? 1 : -1;
    }

    public final void emote(int n, int n2, int n3) {
        this.m_nextState = 11;
        this.m_param1 = n;
        this.m_param2 = n2;
        this.m_param3 = n3;
        if (n3 == 1 || n3 == 6 || n3 == 2) {
            int n4 = this.m_currDir;
            if (n3 == 1) {
                this.m_nextDir = n4 = CPlayer.dirTo(this.m_param1 - this.m_posX, this.m_param2 - this.m_posY);
                this.m_destReached = false;
                this.m_destChanged = true;
                this.m_waitEndsTick = 0L;
            }
            if ((n4 & 1) != 0 && n3 != 1) {
                this.m_nextDir = n4 + 1 & 7;
            }
        }
        if (n3 == 18) {
            this.m_nextDir = this.m_currDir;
            this.m_destReached = true;
            this.m_waitEndsTick = Device.s_tickCounter + (long)n2;
        }
    }

    public final void feint(int n) {
        this.m_nextState = 13;
        this.m_param3 = n;
        this.m_destReached = false;
        this.m_destChanged = true;
    }

    public final void updatePlayerAI() {
        if (this.m_court != 0) {
            return;
        }
        if (Device.s_aiMode == 6 && this.m_myTeam.m_ID == 0 && (CTeam.s_newtutorialStep == 40 && !Device.haveKeyHold(2048) || CTeam.s_newtutorialStep == 16 && this != s_focusPlayer && !CTeam.s_canThroughInTutorial || CTeam.s_newtutorialStep == 14 && this != s_focusPlayer && CTeam.s_throughReceiverID == -1)) {
            this.doStand();
            return;
        }
        if (Device.s_aiMode == 6 && CTeam.s_newtutorialStep == 29 && this == CTeam.s_team1.m_players[0] && s_ballOwner != null && this != s_ballOwner && CTeam.s_team0.isInOpForbidden(Actor.s_football.m_posX, Actor.s_football.m_posY)) {
            CTeam.getPointBetweenTwoPoint(60, 135168, 0, Actor.s_football.m_posX, Actor.s_football.m_posY);
            this.runTo(CTeam.s_middlePointX, CTeam.s_middlePointY, false);
        }
        if (this.m_isFocus && CTeam.s_focusTick != Device.s_tickCounter && (Device.s_aiMode != 6 || CTeam.s_newtutorialStep < 33 || CTeam.s_newtutorialStep == 40)) {
            this.updateFocusPlayer();
        }
        if (this.m_doHumanWallJump) {
            int n = CPlayer.dirTo(Actor.s_football.m_posX - this.m_posX, Actor.s_football.m_posY - this.m_posY);
            if (this.m_currDir != n) {
                this.m_currDir = n;
                this.m_nextDir = n;
                this.doStand();
            }
            if (this.m_disToBall < 12800) {
                if (Actor.s_football.m_posZ > 2560) {
                    this.setBehavior(13);
                } else {
                    this.m_coachSetTacState = 0;
                    this.m_myTeam.m_haveNewOrder[this.m_Number] = true;
                }
            }
            if (this.m_behavior == 13 && this.m_actionOver) {
                this.m_coachSetTacState = 0;
                this.m_myTeam.m_haveNewOrder[this.m_Number] = true;
            }
            return;
        }
        if (this.m_withBall) {
            ++s_ctrWithBall;
        } else if (s_ballLastOwner == this) {
            ++s_ctrWithoutBall;
        }
        if (this.m_idea == 0) {
            CPlayer cPlayer = this.m_opTeam.m_players[this.m_ideaParam1];
            int n = Device.fastDistance(cPlayer.m_posX - this.m_posX, cPlayer.m_posY - this.m_posY);
            if (n < 3328) {
                this.m_myTeam.computeTacklePoint(this.m_Number, this.m_ideaParam1);
                this.runTo(CTeam.tacklePointX, CTeam.tacklePointY, false);
            } else {
                CPlayer.parseVector(1280, cPlayer.m_currDir);
                this.runTo(cPlayer.m_posX + s_vectorX, cPlayer.m_posY + s_vectorY, true);
            }
        }
        if (this.m_isFastRun && this.m_withBall && this.m_actionIDNow >= 126 && this.m_actionIDNow <= 129) {
            if (this.m_frameIDNow < this.m_turnFastDelay.length - 1 && this.m_turnFastDelay[this.m_frameIDNow + 1] < 0) {
                this.m_actionOver = true;
            } else if (this.m_actionOver) {
                if (this.m_turnFastDelay[this.m_frameIDNow] > 0) {
                    int n = this.m_frameIDNow--;
                    this.m_turnFastDelay[n] = this.m_turnFastDelay[n] - 1;
                    this.m_actionOver = false;
                }
            } else if (this.m_frameIDNow > 0 && this.m_turnFastDelay[this.m_frameIDNow - 1] > 0) {
                int n = this.m_frameIDNow - 1;
                this.m_turnFastDelay[n] = this.m_turnFastDelay[n] - 1;
                --this.m_frameIDNow;
            }
        }
        switch (this.m_currState) {
            case 0: 
            case 1: {
                if (this.m_actionOver || this.m_actionCycle) {
                    if (this.m_nextState == 7) {
                        this.doSaveBall(false);
                        return;
                    }
                    if (this.canTackle() && (!CTeam.s_isTutorialFeint || Device.s_aiMode != 6)) {
                        if (!(this.m_isFocus || this.m_Number == 0 && this.m_myTeam.isPointInMyFBZ(this.m_posX, this.m_posY) || !CPlayer.dirIn5(this.m_currDir + 4 & 7, CPlayer.s_ballOwner.m_currDir) || Device.random(0, 2) >= 1)) {
                            this.doSlideTackle();
                            return;
                        }
                        this.doTackle();
                        return;
                    }
                    if ((this.m_nextDir & 7) != (this.m_currDir & 7)) {
                        if (this.canPickup()) {
                            this.doPickup();
                            return;
                        }
                        if (this.canTrap()) {
                            this.doTrap();
                            return;
                        }
                        if (s_ballFastOwner == this && this.m_currDir == this.m_dirToBall) break;
                        this.doTurn();
                        return;
                    }
                    switch (this.m_nextState) {
                        case 0: {
                            this.doStand();
                            break;
                        }
                        case 1: {
                            this.doRun();
                            break;
                        }
                        case 2: {
                            this.doOutBall(2, false);
                            break;
                        }
                        case 3: {
                            this.doOutBall(3, false);
                            break;
                        }
                        case 4: {
                            this.doOutBall(4, false);
                            break;
                        }
                        case 5: {
                            this.doTackle();
                            break;
                        }
                        case 6: {
                            this.doSlideTackle();
                            break;
                        }
                        case 8: {
                            this.doStandWithBall();
                            break;
                        }
                        case 11: {
                            this.doEmotion();
                            break;
                        }
                        case 13: {
                            this.doFeint();
                        }
                    }
                    if (this.canPickup()) {
                        this.doPickup();
                        return;
                    }
                    if (!this.canTrap()) break;
                    this.doTrap();
                    return;
                }
                if (CPlayer.isTurnBehavior(this.m_behavior)) {
                    if (this.canPickup()) {
                        this.doPickup();
                        return;
                    }
                    if (!this.canTrap()) break;
                    this.doTrap();
                    return;
                }
                if (this.m_behavior != 29 && this.m_behavior != 30 || !this.m_withBall) break;
                Actor.setBallCarried(this);
                return;
            }
            case 10: {
                if (this.m_behavior >= 2 && this.m_behavior <= 7) {
                    if (this.canPickup()) {
                        this.doPickup();
                    } else if (this.canTrap()) {
                        this.doTrap();
                    }
                    if (!this.m_actionOver) {
                        ++this.m_inertiaEndsTick;
                        return;
                    }
                    this.setBehavior(1);
                    return;
                }
                if (Device.s_tickCounter <= this.m_inertiaEndsTick) {
                    this.doTurnInertia();
                    return;
                }
                this.m_currState = 1;
                return;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.m_actionOver) {
                    if (this.m_behavior == 47) {
                        this.doGetUp();
                        return;
                    }
                    if (this.m_posY > 86016) {
                        this.doStand();
                        this.runTo(this.m_posX, 86016, false);
                        return;
                    }
                    if (this.m_posY < -86016) {
                        this.doStand();
                        this.runTo(this.m_posX, -86016, false);
                        return;
                    }
                    this.doFool(this.m_reaction >> 1);
                    return;
                }
                if (this.m_withBall) {
                    this.sendBallOutAtKeyFrame();
                    return;
                }
                if (this.m_behavior == 15) {
                    if (this.m_frameIDNow >= (this.m_behavior == 15 ? 2 : 1)) {
                        this.updateSpeed();
                    }
                    if (this.m_vX == 0 && this.m_vY == 0) break;
                    this.persistSpecialDirect();
                    return;
                }
                if (this.m_currState != 2 || !s_oneTwoPressed[this.m_myTeam.m_ID]) break;
                CPlayer.s_oneTwoPressed[this.m_myTeam.m_ID] = false;
                if (this.m_Number == 0) break;
                this.setOneTwoPlayer();
                if (this.m_myTeam.m_type != 0) break;
                s_radar = 5;
                s_power = 0;
                return;
            }
            case 7: {
                this.gkSaveBall();
                return;
            }
            case 8: {
                if (!this.m_withBall) {
                    this.stand(false);
                }
                int n = -1;
                if (Device.haveKeyPressed(1)) {
                    n = 1;
                }
                if (Device.haveKeyPressed(16)) {
                    n = 5;
                }
                if (Device.haveKeyPressed(64)) {
                    n = 7;
                }
                if (Device.haveKeyPressed(4)) {
                    n = 3;
                }
                if (CTeam.s_potentialPlayer != null) {
                    if (n != -1 && CTeam.s_potentialPlayer.selectPassPoint(n, 4)) {
                        CTeam.s_potentialPlayer = CTeam.s_team0.m_players[s_passPlayerNumber];
                    }
                    CTeam.s_placementScreenCursorX = CTeam.s_potentialPlayer.m_posX;
                    CTeam.s_placementScreenCursorY = CTeam.s_potentialPlayer.m_posY;
                    Device.pos3DTo2D(CTeam.s_placementScreenCursorX, CTeam.s_placementScreenCursorY, 0);
                    CTeam.s_placementScreenCursorX = Device.s_pos2Dx;
                    CTeam.s_placementScreenCursorY = Device.s_pos2Dy;
                }
                if (this.m_isFocus && s_ctrWithBall > 100) {
                    this.selectPassPoint(this.m_currDir, 3);
                    this.longPass(s_passPointX, s_passPointY, 5120);
                }
                if (!this.m_actionOver) break;
                if (this.m_behavior == 104 || this.m_behavior == 103) {
                    Actor.s_ball_heldbygk = true;
                    s_GKPickingUpBall = false;
                    this.setBehavior(107);
                    return;
                }
                if (this.m_behavior == 107) {
                    this.doStandWithBall();
                    return;
                }
                if (Device.s_aiMode == 0 && this.m_behavior == 108 && CTeam.s_matchState == 0 && !this.m_myTeam.isPointInMyFBZ(this.m_posX, this.m_posY)) {
                    this.doFoul(0);
                    return;
                }
                if (this.m_nextState != 3) break;
                this.m_outBallParam1 = this.m_param1;
                this.m_outBallParam2 = this.m_param2;
                this.m_outBallParam3 = this.m_param3;
                this.doKickOutBall();
                return;
            }
            case 5: {
                if (this.m_actionOver) {
                    this.goodTackleOrGoodDribble();
                    if (s_ballOwner != null) {
                        this.doFool(this.m_reaction + 2);
                        return;
                    }
                    this.doStand();
                    return;
                }
                if (this.m_frameIDNow >= 4) break;
                this.persistTackle();
                return;
            }
            case 6: {
                if (this.m_actionOver) {
                    this.goodTackleOrGoodDribble();
                    if (s_ballOwner != null) {
                        this.doFool(this.m_reaction + 2);
                        return;
                    }
                    this.doStand();
                    return;
                }
                if (this.m_frameIDNow >= 3) break;
                this.persistSlideTackle();
                return;
            }
            case 9: {
                if (this.m_actionOver) {
                    this.m_vY = 0;
                    this.m_vX = 0;
                    if (this.m_behavior == 17) {
                        this.doGetUp();
                        return;
                    }
                    if (this.m_foolEndsTick <= Device.s_tickCounter) {
                        if (this.m_nextState == 5) {
                            this.doTackle();
                            return;
                        }
                        this.doStand();
                        return;
                    }
                    this.setBehavior(0);
                    return;
                }
                this.updateSpeed();
                return;
            }
            case 12: {
                if (!this.m_actionOver || this.m_foolEndsTick > Device.s_tickCounter) break;
                this.doStand();
                return;
            }
            case 11: {
                if (this.m_actionCycle) {
                    if (!this.m_actionOver) break;
                    if (this.m_currDir != this.m_nextDir) {
                        this.doTurn();
                        return;
                    }
                    switch (this.m_nextState) {
                        case 0: {
                            this.doStand();
                            break;
                        }
                        case 1: {
                            this.doRun();
                            break;
                        }
                        case 11: {
                            this.doEmotion();
                        }
                    }
                    return;
                }
                this.updateSpeed();
                if (!this.m_actionOver) break;
                this.doStand();
                return;
            }
            case 13: {
                if (!this.m_actionOver && !this.m_actionCycle) break;
                if (Actor.s_football.m_posX > 135168 || Actor.s_football.m_posX < -135168 || Actor.s_football.m_posY > 86016 || Actor.s_football.m_posY < -86016) {
                    this.m_currState = 0;
                    this.m_nextState = 0;
                    Actor.s_ball_heldbyplayer = false;
                    this.doStand();
                    return;
                }
                if (this.m_nextState == 13) {
                    this.doFeint();
                    return;
                }
                if (this.m_param3 == 3) {
                    this.m_fastrun = true;
                    this.m_dribbleState = 1;
                    this.m_nextDir = this.m_currDir = this.m_currDir + this.m_preDir & 7;
                    this.m_preDir = -1;
                } else if (this.m_param3 == 2) {
                    if (this.m_feintEndsTick > Device.s_tickCounter) {
                        return;
                    }
                    this.m_preDir = -1;
                    this.m_feintEndsTick = 0L;
                } else {
                    this.m_preDir = -1;
                }
                Actor.s_ball_heldbyplayer = false;
                Actor.setBallCarried(this);
                this.m_destReached = true;
                if (this.m_param3 == 3) {
                    CPlayer.parseVector_screen(this.m_speedWithBall, this.m_currDir & 7);
                    Actor.s_football.m_posX += s_vectorX;
                    Actor.s_football.m_posY += s_vectorY;
                }
                if (this.m_param3 == 2) {
                    this.m_currState = 0;
                    this.m_nextState = 0;
                    this.m_steponball = true;
                    this.doStand();
                    return;
                }
                if (s_lastInputDir == -1) {
                    s_lastInputDir = this.m_currDir;
                }
                if (this.m_preState != -1) {
                    this.m_dribbleState = 1;
                }
                if (this.m_param3 == 3) {
                    s_lastInputDir = this.m_currDir;
                    Actor.s_carriedNear = true;
                }
                this.m_param3 = this.m_fastrun ? 7 : 3;
                this.doRun();
            }
        }
    }

    private void updateSpeed() {
        if (this.m_vX != 0) {
            this.m_vX = this.m_vX > 0 && this.m_vX + this.m_aX < 0 || this.m_vX < 0 && this.m_vX + this.m_aX > 0 ? 0 : (this.m_vX += this.m_aX);
        }
        if (this.m_vY != 0) {
            if (this.m_vY > 0 && this.m_vY + this.m_aY < 0 || this.m_vY < 0 && this.m_vY + this.m_aY > 0) {
                this.m_vY = 0;
                return;
            }
            this.m_vY += this.m_aY;
        }
    }

    public final void doStand() {
        this.m_vX = 0;
        this.m_vY = 0;
        this.m_currState = 0;
        this.m_nextState = 0;
        this.m_nextDir = this.m_currDir;
        if (this.m_steponball) {
            this.m_steponball = false;
            this.setBehavior(40);
        } else {
            this.setBehavior(0);
        }
        if (this.m_withBall) {
            Actor.setBallCarried(this);
        }
    }

    private void doRun() {
        int n;
        if (this.m_fastrun && this.m_param3 == 0) {
            ++this.m_runningTick;
        }
        if (this.m_param3 == 0 || this.m_param3 == 1 || this.m_param3 == 2 || this.m_param3 == 8) {
            if (this.m_currState != 1) {
                this.m_destRangeRadius = 512;
            }
            if (Device.fastDistance(this.m_param1 - this.m_posX, this.m_param2 - this.m_posY) <= this.m_destRangeRadius) {
                this.m_destReached = true;
                this.m_posX = this.m_param1;
                this.m_posY = this.m_param2;
            } else {
                boolean bl = this.m_destReached = Math.abs(this.m_param1 - (this.m_posX + this.m_vX)) + Math.abs(this.m_param2 - (this.m_posY + this.m_vY)) > Math.abs(this.m_param1 - this.m_posX) + Math.abs(this.m_param2 - this.m_posY);
            }
            if (this.m_destReached) {
                this.m_runningTick = 0;
                if (this == s_ballFastOwner) {
                    this.m_param3 = 0;
                    this.m_dribbleState = 0;
                    this.m_fastrun = false;
                } else {
                    if (Device.s_aiMode == 6) {
                        this.doStand();
                        return;
                    }
                    if (this.m_tacState == 8 || this.m_tacState == 7 && s_ballOwner != null) {
                        if (this.m_tacState == 8) {
                            this.m_myTeam.getMarkPos(this.m_markID, 1);
                        } else {
                            this.m_myTeam.getMarkPos(CPlayer.s_ballOwner.m_Number, 1);
                        }
                        if (Device.fastDistance(this.m_param1 - CTeam.s_markX, this.m_param2 - CTeam.s_markY) > this.m_destRangeRadius) {
                            this.runTo(CTeam.s_markX, CTeam.s_markY, false);
                            return;
                        }
                        this.doStand();
                        return;
                    }
                    this.doStand();
                    return;
                }
            }
        }
        int n2 = -1;
        switch (this.m_param3) {
            case 0: {
                if (this.m_destChanged && !this.m_beShoved) {
                    if (CTeam.s_matchState == 11 || CTeam.s_matchState == 13) {
                        n2 = 864;
                    } else {
                        int n3 = n2 = this.m_withBall ? this.m_speedWithBall : this.m_speed;
                    }
                    if (n2 == this.m_speedWithBall) {
                        this.m_dribbleState = this.m_curAbilityTech == 3 && this.m_curAbilitySpd == 3 && Device.s_aiMode != 6 ? 1 : 0;
                    }
                    CPlayer.parseVector(n2, this.m_param1 - this.m_posX, this.m_param2 - this.m_posY);
                    this.m_destChanged = false;
                }
                if (this.m_fastrun && this.m_runningTick > 3) {
                    this.m_runningTick = 0;
                    this.m_param3 = 8;
                    this.m_dribbleState = 1;
                    this.m_destChanged = true;
                }
                this.setBehavior(1);
                break;
            }
            case 8: {
                if (this.m_destChanged && !this.m_beShoved) {
                    if (s_ballFastOwner == this || this.m_withBall) {
                        n2 = this.m_fatigue > 100 ? this.m_speedWithBall : this.m_speedFastWithBall;
                    } else {
                        int n4 = n2 = this.m_fatigue > 100 ? this.m_speed : this.m_speedFast;
                    }
                    if (CTeam.s_matchState == 11) {
                        n2 = 1728;
                    }
                    CPlayer.parseVector(n2, this.m_param1 - this.m_posX, this.m_param2 - this.m_posY);
                    this.m_destChanged = false;
                }
                this.setBehavior(32);
                break;
            }
            case 1: 
            case 2: {
                if (this.m_withBall) {
                    this.doStand();
                    this.m_nextDir = this.m_currDir;
                    return;
                }
                if (this.m_destChanged && !this.m_beShoved) {
                    n2 = this.m_Number == 0 && this.m_tacState != 17 ? this.m_speed : this.m_speedMove;
                    CPlayer.parseVector(n2, this.m_param1 - this.m_posX, this.m_param2 - this.m_posY);
                    this.m_destChanged = false;
                }
                if (this.m_param3 == 2) {
                    this.setBehavior(24);
                    break;
                }
                this.setBehavior(23);
                break;
            }
            case 3: {
                n = 0;
                if (s_ballOwner != null) {
                    this.m_myTeam.getMarkPos(CPlayer.s_ballOwner.m_Number, 1);
                    n = CPlayer.dirTo(CTeam.s_markX - this.m_posX, CTeam.s_markY - this.m_posY);
                }
                int n5 = n2 = this.m_withBall ? this.m_speedWithBall : this.m_speed;
                if (s_ballOwner == null && this.m_currDir == this.m_dirToBall) {
                    CPlayer.parseVector(n2, Actor.s_football.m_posX - this.m_posX, Actor.s_football.m_posY - this.m_posY);
                } else if (!(this.m_isFocus && CTeam.s_placementByCPU || s_ballOwner == null || CPlayer.s_ballOwner.m_myTeam.m_ID == this.m_myTeam.m_ID || Math.abs(CPlayer.dirDifference(this.m_currDir, n)) > 1)) {
                    CPlayer.parseVector(n2, CTeam.s_markX - this.m_posX, CTeam.s_markY - this.m_posY);
                    this.m_currDir = n;
                } else {
                    CPlayer.parseVector(n2, this.m_currDir);
                }
                if (this == s_ballFastOwner && this == s_ballLastOwner && !this.m_withBall) {
                    this.setBehavior(this.m_behavior);
                    break;
                }
                if (s_radar == 4 && s_power > 3) {
                    n2 >>= 1;
                }
                this.setBehavior(1);
                break;
            }
            case 4: 
            case 5: {
                if (this.m_withBall) {
                    this.doStand();
                    this.m_nextDir = this.m_currDir;
                    return;
                }
                n2 = this.m_speedMove;
                CPlayer.parseVector(n2, this.m_param1);
                if (this.m_param3 == 5) {
                    this.setBehavior(24);
                    break;
                }
                this.setBehavior(23);
                break;
            }
            case 7: {
                if (s_ballFastOwner == this || this.m_withBall) {
                    n2 = this.m_fatigue > 100 ? this.m_speedWithBall : this.m_speedFastWithBall;
                } else {
                    int n6 = n2 = this.m_fatigue > 100 ? this.m_speed : this.m_speedFast;
                }
                if (s_ballFastOwner != this && this.m_currDir != this.m_dirToBall) {
                    CPlayer.parseVector(n2, this.m_currDir);
                } else {
                    if (this.m_dirToBall != this.m_currDir) {
                        if (CTeam.s_matchState == 9 && Math.abs(this.m_dirToBall - this.m_currDir) == 4) {
                            this.loseBall();
                            this.doStand();
                            return;
                        }
                        this.m_nextDir = this.m_dirToBall;
                        this.doTurn();
                        this.m_dribbleState = 0;
                        this.m_fastrun = false;
                        return;
                    }
                    if (this.m_withBall) {
                        CPlayer.parseVector(n2, this.m_currDir);
                    } else {
                        CPlayer.parseVector(n2, Actor.s_football.m_posX - this.m_posX, Actor.s_football.m_posY - this.m_posY);
                    }
                }
                this.setBehavior(32);
            }
        }
        if (n2 != -1) {
            this.m_destRangeRadius = (n2 >> 1) + 256;
            this.m_vX = s_vectorX;
            this.m_vY = s_vectorY;
            n = Device.screenDistance(this.m_vX, this.m_vY);
            if (n != 0) {
                int n7 = n2 * 365 >> 8;
                this.m_vX = this.m_vX * n7 / n;
                this.m_vY = this.m_vY * n7 / n;
                this.m_destRangeRadius = this.m_destRangeRadius * n7 / n;
            }
        }
        if (!(CTeam.s_matchState == 0 || this.m_currDir == CPlayer.dirTo(this.m_vX, this.m_vY) || this.m_vX == 0 && this.m_vY == 0 || this.m_param3 != 0 && this.m_param3 != 3 && this.m_param3 != 8 && this.m_param3 != 7)) {
            this.m_currDir = CPlayer.dirTo(this.m_vX, this.m_vY);
            this.setBehavior(this.m_behavior);
        }
        this.m_currState = 1;
        this.m_nextState = 1;
        if (this.m_withBall) {
            if (this.m_currState == 1 && this.m_dribbleState == 1) {
                this.doFastDribble();
                return;
            }
            Actor.setBallCarried(this);
        }
    }

    private void doFastDribble() {
        if (this.m_dribbleState == 2) {
            s_ballFastOwner = null;
            Actor.setBallCarried(this);
            return;
        }
        this.loseBall();
        s_ballFastOwner = this;
        Actor.setBallFastCarried(this);
    }

    private void doTurn() {
        boolean bl;
        int n = 4;
        int n2 = CPlayer.dirDifference(this.m_currDir, this.m_nextDir);
        if (n2 != 1 && n2 != -1 || this.m_isBallReceiver) {
            this.m_vX = 0;
            this.m_vY = 0;
        }
        if (!(bl = this.m_withBall && this.m_currState == 1 && !this.m_isFeint && (this.m_fastrun || this.m_isFastRun))) {
            if (n2 == 3) {
                n2 = 2;
            } else if (n2 == -3) {
                n2 = -2;
            }
        }
        if (this.m_isFeint) {
            this.m_isFeint = false;
            if (n2 == 2) {
                n2 = 1;
            } else if (n2 == -2) {
                n2 = -1;
            }
        }
        int n3 = -1;
        switch (n2) {
            case -1: 
            case 1: {
                this.m_mustChangeAction = true;
                n = 1;
                break;
            }
            case 2: {
                if (bl) {
                    n3 = 0;
                    n = 5;
                    this.m_mustChangeAction = true;
                    this.setBehavior(9);
                    break;
                }
                this.m_mustChangeAction = true;
                this.setBehavior(5);
                break;
            }
            case -2: {
                if (bl) {
                    n3 = 0;
                    n = 5;
                    this.m_mustChangeAction = true;
                    this.setBehavior(8);
                    break;
                }
                this.m_mustChangeAction = true;
                this.setBehavior(4);
                break;
            }
            case 3: {
                if (!bl) break;
                n = 6 + (this.m_fast2Fast ? 2 : 0);
                n3 = this.m_fast2Fast ? 3 : 1;
                this.m_mustChangeAction = true;
                this.setBehavior(9);
                break;
            }
            case -3: {
                if (!bl) break;
                n = 6 + (this.m_fast2Fast ? 2 : 0);
                n3 = this.m_fast2Fast ? 3 : 1;
                this.m_mustChangeAction = true;
                this.setBehavior(8);
                break;
            }
            case 4: {
                if (bl) {
                    n3 = this.m_fast2Fast ? 4 : 2;
                    this.m_mustChangeAction = true;
                    this.setBehavior(9);
                    n = 6;
                    break;
                }
                this.m_mustChangeAction = true;
                this.setBehavior(7);
                n = 4;
            }
        }
        if (n3 != -1) {
            System.arraycopy(TURN_FAST_DELAY[n3], 0, this.m_turnFastDelay, 0, 6);
        }
        this.m_currDir = this.m_currDir + n2 & 7;
        if (this.m_withBall) {
            if (!this.m_isFocus && this.m_currDir == this.m_nextDir && this.m_nextState != 1 && this.m_Number != 0) {
                this.receiveTurnInertia(5);
            }
            CPlayer.parseVector(1280, this.m_currDir);
            Actor.setBallTurnTo(this.m_posX + this.m_vX + s_vectorX, this.m_posY + this.m_vY + s_vectorY, n);
        }
    }

    private void doTurnInertia() {
        int n;
        if (this.m_fastrun) {
            n = this.m_withBall ? this.m_speedFastWithBall : this.m_speedFast;
            this.setBehavior(32);
        } else {
            n = this.m_withBall ? this.m_speedWithBall : this.m_speed;
            this.setBehavior(1);
        }
        CPlayer.parseVector_screen(n, this.m_currDir);
        this.m_vX = s_vectorX;
        this.m_vY = s_vectorY;
        if (this.m_withBall) {
            if (this.m_dribbleState != 0) {
                this.doFastDribble();
                return;
            }
            Actor.setBallCarried(this);
        }
    }

    private void doFool(int n) {
        this.m_foolEndsTick = Device.s_tickCounter + (long)n;
        if (this.m_behavior == 16 || this.m_behavior == 17) {
            int n2 = 5;
            if (this == s_ballFastOwner) {
                s_ballFastOwner = null;
            }
            if (this.m_behavior == 17) {
                n2 = 9;
            }
            CPlayer.parseVector_screen(this.m_speed, this.m_currDir);
            this.m_vX = s_vectorX;
            this.m_vY = s_vectorY;
            this.m_aX = -this.m_vX / n2;
            this.m_aY = -this.m_vY / n2;
        } else {
            this.m_vX = 0;
            this.m_vY = 0;
            this.m_aY = 0;
            this.m_aX = 0;
        }
        this.m_currState = 9;
        this.m_nextState = 0;
        this.m_currDir = this.m_dirToBall;
        this.m_nextDir = this.m_dirToBall;
        if (this.m_actionOver) {
            this.setBehavior(0);
        }
    }

    private void doFoul(int n) {
        if (CTeam.s_matchState != 0 || Device.s_aiMode == 2 || Device.s_aiMode == 6) {
            return;
        }
        if (this.m_card + n > 1 && Device.s_playerChanged && Device.s_subs[this.m_Number] >= 11) {
            n = 0;
        }
        if (this.m_myTeam.isPointInMyFBZ(this.m_posX, this.m_posY)) {
            CTeam.setMatchState(8, 1 - this.m_myTeam.m_ID, CTeam.s_leftTeamID == this.m_myTeam.m_ID ? -104192 : 103680, CTeam.s_leftTeamID == this.m_myTeam.m_ID ? 768 : 256);
            CTeam.s_foulPlayer = this;
            this.m_showCard = n;
            this.m_card += n;
            if (n > 0) {
                Device.refreshNameBuff(Device.s_focusName);
            }
        } else {
            CTeam.s_foulPlayer = this;
            this.m_showCard = n;
            this.m_card += n;
            if (n > 0) {
                Device.refreshNameBuff(Device.s_focusName);
            }
            CTeam.setMatchState(7, 1 - this.m_myTeam.m_ID, this.m_posX, this.m_posY);
        }
        Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 4);
        if (n > 0) {
            Device.increaseValueOfStatItem(this.m_myTeam.m_ID, n == 1 ? 6 : 7);
            if (n == 1 && this.m_card > 1) {
                Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 7);
            }
        }
        if (this.m_card > 1) {
            CPlayer.clearFocus();
        }
    }

    private void doEmotion() {
        this.m_currState = 11;
        this.m_vY = 0;
        this.m_vX = 0;
        this.m_vY = 0;
        this.m_aX = 0;
        switch (this.m_param3) {
            case 5: {
                this.setBehavior(37);
                this.m_nextState = 11;
                return;
            }
            case 6: {
                this.setBehavior(38);
                return;
            }
            case 7: {
                this.setBehavior(39);
                return;
            }
            case 18: {
                this.setBehavior(41);
                this.m_actionCycle = true;
                this.m_nextState = 11;
                return;
            }
            case 2: {
                this.setBehavior(33);
                this.m_nextState = 11;
                return;
            }
            case 1: 
            case 20: {
                int n = this.m_param3 == 1 ? 2304 : 864;
                this.m_destRangeRadius = CPlayer.parseVector_screen(n, this.m_param1 - this.m_posX, this.m_param2 - this.m_posY, (n >> 1) + 256);
                this.m_vX = s_vectorX;
                this.m_vY = s_vectorY;
                if (Device.fastDistance(this.m_param1 - this.m_posX, this.m_param2 - this.m_posY) <= this.m_destRangeRadius) {
                    this.m_destReached = true;
                    this.m_posX = this.m_param1;
                    this.m_posY = this.m_param2;
                }
                if (this.m_destReached) {
                    this.doStand();
                    return;
                }
                if (this.m_destChanged && !this.m_beShoved) {
                    this.m_destChanged = false;
                }
                this.m_currDir = this.m_nextDir = CPlayer.dirTo(this.m_param1 - this.m_posX, this.m_param2 - this.m_posY);
                if (this.m_param3 == 1) {
                    this.setBehavior(32);
                } else {
                    this.setBehavior(1);
                }
                this.m_nextState = 11;
                return;
            }
            case 11: {
                Device.s_playerData[this.m_myTeam.m_ID * 192 + this.m_Number * 12 + 4] = 3;
                this.updateProperties(-4);
                switch (this.m_currDir) {
                    case 1: 
                    case 2: {
                        this.m_currDir = 2;
                        this.m_nextDir = 2;
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.m_currDir = 4;
                        this.m_nextDir = 4;
                        break;
                    }
                    case 5: 
                    case 6: {
                        this.m_currDir = 6;
                        this.m_nextDir = 6;
                        break;
                    }
                    case 0: 
                    case 7: {
                        this.m_currDir = 0;
                        this.m_nextDir = 0;
                    }
                }
                int n = Device.random(0, 1);
                int n2 = Device.s_radisRect >> 8 & 0xF;
                Device.s_reporterStr = Device.replaceString((int)((short)(288 + n)), '~', n == 0 ? Device.teamName[n2] : Device.playerName[n2][Device.s_radisRect & 0xFF]);
                this.setBehavior(53);
            }
        }
    }

    private void doGetUp() {
        this.m_currState = 12;
        if (this.m_behavior == 17) {
            this.setBehavior(31);
        }
    }

    private void doFeint() {
        if (Device.s_aiMode == 6 && CTeam.s_isTutorialFeint && this.m_param3 != 3 && CTeam.s_newtutorialStep == 23) {
            return;
        }
        int n = 0;
        switch (this.m_param3) {
            case 2: {
                s_lastInputDir = -1;
                n = this.m_speed >> 1;
                this.m_feintEndsTick = Device.s_tickCounter + 12L;
                CPlayer.parseVector_screen(n, this.m_currDir + this.m_preDir & 7);
                this.m_vX = s_vectorX;
                this.m_vY = s_vectorY;
                this.setBehavior(62);
                break;
            }
            case 3: {
                this.m_currDir &= 7;
                this.m_nextDir = this.m_currDir;
                this.m_preDir = CPlayer.dirIn3(this.m_currDir, 7) ? 1 : -1;
                n = this.m_speedMove;
                CPlayer.parseVector_screen(n, this.m_currDir & 7);
                this.m_vX = s_vectorX;
                this.m_vY = s_vectorY;
                this.setBehavior(63);
            }
        }
        this.m_feint = this.m_param3;
        this.m_currState = 13;
        this.m_nextState = 1;
        Actor.setBallCarried(this);
        Actor.s_ball_heldbyplayer = true;
    }

    public final boolean ballOverMeIn(int n) {
        return Actor.ballOverPointIn(this.m_posX, this.m_posY, n);
    }

    private boolean ballOverMeOn(int n) {
        return Actor.ballOverPointOn(this.m_posX, this.m_posY, n);
    }

    public final boolean canTrap() {
        boolean bl;
        if (CTeam.nWall != 0 && s_ballOwner != null && s_ballOwner != CTeam.s_kickPlayer) {
            CTeam.nWall = 0;
        }
        if (s_ballOwner != null) {
            return false;
        }
        if (s_ctrWithoutBall < 3) {
            if (s_ballLastOwner != null && CPlayer.s_ballLastOwner.m_myTeam.m_ID != this.m_myTeam.m_ID) {
                return false;
            }
            if (s_ballLastOwner == this) {
                return false;
            }
        }
        if (s_ballFastOwner != null && s_ballFastOwner != this && CPlayer.s_ballFastOwner.m_myTeam.m_ID == this.m_myTeam.m_ID) {
            return false;
        }
        if (CTeam.nWall != 0 && Actor.s_ball_state == 9 && Device.random(0, 3) == 0 && this.m_myTeam != CTeam.s_teams[CTeam.s_kickTeamID] && this.m_Number >= 11 - CTeam.nWall) {
            return false;
        }
        if (CTeam.s_matchState != 0) {
            return false;
        }
        if (this.m_isBallReceiver && this.m_disToBall < 10240 || !this.m_isBallReceiver && this.m_disToBall < 20480) {
            if (this.m_disToBall <= 1792 && Actor.s_football.m_posZ <= 6656) {
                return true;
            }
            bl = false;
            if (Actor.s_football.m_posZ <= 6656 || Actor.s_futureBallPosZ[Actor.s_ctrFutureBallFrame] <= 6656) {
                int n;
                int n2;
                boolean bl2 = Actor.ballOverPointOn(this.m_posX, this.m_posY, 0);
                if (!bl2 && Actor.s_ball_state == 0 && CPlayer.s_ballLastOwner.m_myTeam.m_ID == this.m_myTeam.m_ID && Actor.ballOverPointOn(n2 = this.m_posX + this.m_vX, n = this.m_posY + this.m_vY, 0) && Device.isLineSegmentCrossPoint(Actor.s_futureBallPosX[Actor.s_ctrFutureBallFrame], Actor.s_futureBallPosY[Actor.s_ctrFutureBallFrame], this.m_posX, this.m_posY, n2, n, 1280)) {
                    bl2 = true;
                }
                return bl2;
            }
        }
        if (this.m_isBallReceiver && this != s_ballFastOwner && Actor.s_football.m_posZ < 12800) {
            if (this.m_preState == 4 && this.m_Number != 0 && this.m_myTeam.m_specialDirectType != 0 && !Actor.s_ballDestReached && Actor.ballOverPointOn(this.m_myTeam.m_rcvBallGoAndKickX, this.m_myTeam.m_rcvBallGoAndKickY, this.m_myTeam.m_rcvAddedKeyFrame - 1)) {
                this.doDirect();
                return false;
            }
            if (this.m_destReached) {
                bl = false;
                if (this.m_canHead && (Actor.s_ball_state == 1 || Actor.s_ball_state == 10) && this.ballOverMeOn(2)) {
                    this.m_canHead = false;
                    if (Actor.s_futureBallPosZ[Actor.s_ctrFutureBallFrame + 2] > 5120 && Actor.s_futureBallPosZ[Actor.s_ctrFutureBallFrame + 2] < 8192) {
                        bl = true;
                    }
                }
                if (bl && this.m_preState != -1) {
                    this.m_myTeam.m_rcvActionKind = Device.random(0, 5) > 3 && this.m_preState == 4 ? 4 : 0;
                    this.doDirect();
                }
            }
        }
        return false;
    }

    private void doTrap() {
        int n;
        int n2;
        if (s_ballFastOwner != null && CPlayer.s_ballFastOwner.m_myTeam.m_ID != this.m_myTeam.m_ID && Device.fastDistance(CPlayer.s_ballFastOwner.m_posX - this.m_posX, CPlayer.s_ballFastOwner.m_posY - this.m_posY) < 5120) {
            if (Device.random(0, 3) == 0) {
                s_ballFastOwner.setBehavior(16);
                s_ballFastOwner.doFool(5);
            } else {
                s_ballFastOwner.setBehavior(17);
                s_ballFastOwner.doFool(20);
            }
        }
        if (s_ballTackledOutBy != null && CPlayer.s_ballTackledOutBy.m_myTeam.m_ID == this.m_myTeam.m_ID) {
            ++CPlayer.s_ballTackledOutBy.m_successTackleTime;
            Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 9);
        }
        s_ballTackledOutBy = null;
        if (s_ballLastOwner != this && CPlayer.s_ballLastOwner.m_myTeam.m_ID == this.m_myTeam.m_ID && (Actor.s_ball_state == 0 || Actor.s_ball_state == 1 || Actor.s_ball_state == 10)) {
            s_lastAsistPlayer = s_ballLastOwner;
            ++CPlayer.s_ballLastOwner.m_successPassTime;
            Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 8);
            if (this.m_myTeam.m_type == 0 && Device.s_aiMode == 6 && (CTeam.s_newtutorialStep == 7 || CTeam.s_newtutorialStep == 14 && CTeam.s_throughReceiverID == this.m_Number || CTeam.s_newtutorialStep == 9 && CTeam.s_isTutorialLongPassBySharp && Actor.s_ball_state == 10)) {
                CTeam.s_taskFinish = true;
            }
            if (s_oneTwoPlayer[this.m_myTeam.m_ID] != null && s_oneTwoPlayer[this.m_myTeam.m_ID] == this && CPlayer.s_ballLastOwner.m_myTeam.m_type == 0) {
                if (Device.s_aiMode == 6 && CTeam.s_newtutorialStep == 16) {
                    CTeam.s_taskFinish = true;
                }
                Device.s_drawSupport = true;
                Actor.s_support.setAction(17 + Device.selected_language * 18, true);
                this.m_myTeam.addMorale(10);
            } else if ((this.m_myTeam.m_leftSide && CPlayer.s_ballLastOwner.m_posX < this.m_posX && this.m_posX > 0 || !this.m_myTeam.m_leftSide && CPlayer.s_ballLastOwner.m_posX > this.m_posX && this.m_posX < 0) && CTeam.s_matchState == 0) {
                n2 = 1;
                for (n = 0; n < 11; ++n) {
                    if (this.m_opTeam.m_players[n].m_court != 0 || this.m_opTeam.m_players[n].m_disToBall >= 8192) continue;
                    n2 = 0;
                    break;
                }
                if (n2 != 0) {
                    if (CPlayer.s_ballLastOwner.m_myTeam.m_type == 0) {
                        Device.s_drawSupport = true;
                        Actor.s_support.setAction(10 + Device.selected_language * 18, true);
                    }
                    this.m_myTeam.addMorale(20);
                } else {
                    this.m_myTeam.addMorale(10);
                }
            } else {
                this.m_myTeam.addMorale(10);
            }
        }
        n2 = CPlayer.dirTo(Actor.s_football.m_vX, Actor.s_football.m_vY);
        n = this.m_vX == 0 && this.m_vY == 0 ? n2 : CPlayer.dirTo(this.m_vX, this.m_vY);
        int n3 = Math.abs(CPlayer.dirDifference(n, n2));
        if (this.doDirect()) {
            return;
        }
        boolean bl = this.m_preDir != -1 && this.m_preDir != this.m_currDir;
        int n4 = 7;
        if (!this.m_fast2Fast) {
            boolean bl2 = this.m_fast2Fast = this.m_isFastRun && this.m_preFastRun;
        }
        if (this.m_fast2Fast && this.m_preDir != -1) {
            n4 = CPlayer.dirDifference(this.m_currDir, this.m_preDir + 8 & 7);
        }
        if (s_ballFastOwner == this && Math.abs(n4) < 3 && this.m_currState == 1) {
            if (this.m_dribbleState == 1) {
                this.getBall();
                this.doFastDribble();
                return;
            }
            if (this.m_isFocus) {
                this.m_fast2Fast = n4 != 0;
                this.m_fastrun = true;
                this.m_dribbleState = 1;
                if (Math.abs(n4) == 2) {
                    n4 >>= 1;
                }
                this.m_currDir += n4;
                this.m_currDir &= 7;
                this.m_nextDir = this.m_currDir;
                this.m_param3 = 7;
                this.m_destReached = false;
                this.m_waitEndsTick = 0L;
                s_lastInputDir = this.m_currDir;
                this.getBall();
                this.doRun();
                return;
            }
        }
        if (s_ballLastOwner != this && Device.s_aiMode != 6 && s_ctrWithoutBall < (this.m_isBallReceiver ? 3 : 5)) {
            if (n3 < 2 || s_ctrWithoutBall < 1) {
                this.doTrapStyle1();
                return;
            }
            if (bl) {
                this.m_nextDir = this.m_preDir;
                this.doTrapStyle2(this.m_nextDir);
                return;
            }
            this.doTrapStyle2(this.m_currDir);
            return;
        }
        if (this.m_preFastRun) {
            this.m_fastrun = true;
            this.m_dribbleState = 1;
        }
        if (bl) {
            this.m_nextDir = this.m_preDir;
            this.getBall();
            this.doTurn();
            this.m_nextState = 0;
            return;
        }
        if (s_ballLastOwner != this && Actor.s_football.m_posZ > 4096 && Actor.s_ball_state != 4 && Actor.s_ball_state != 5) {
            this.doTrapStyle3High();
            return;
        }
        this.doTrapStyle3Low();
    }

    private void doTrapStyle1() {
        this.setBehavior(16);
        this.getBall();
        this.loseBall();
        Actor.setBallReflect(this);
        this.doFool(5);
    }

    private void doTrapStyle2(int n) {
        if (s_ballLastOwner != this && this.m_myTeam.m_type == 1) {
            this.doStand();
        }
        if (n != this.m_currDir || Device.fastDistance(Actor.s_football.m_vX, Actor.s_football.m_vY) > 1728) {
            if (this.m_behavior != 1 && this.m_behavior != 32) {
                CPlayer.parseVector(2560, n);
                this.setBehavior(29);
            } else {
                CPlayer.parseVector(4608, n);
            }
            this.getBall();
            this.loseBall();
            Actor.s_football.m_posX = this.m_posX;
            Actor.s_football.m_posY = this.m_posY;
            Actor.setBallOutTo(5, this.m_posX + s_vectorX, this.m_posY + s_vectorY, 0, -1, -1);
            return;
        }
        this.getBall();
        Actor.setBallCarried(this);
    }

    private void doTrapStyle3High() {
        this.doStand();
        this.setBehavior(10);
        this.getBall();
        this.loseBall();
        CPlayer.parseVector(2560, this.m_currDir);
        Actor.s_football.m_posX = this.m_posX;
        Actor.s_football.m_posY = this.m_posY;
        Actor.setBallOutTo(5, this.m_posX + s_vectorX, this.m_posY + s_vectorY, 0, -1, -1);
    }

    private void doTrapStyle3Low() {
        int n;
        if (Actor.s_football.m_vX != 0 || Actor.s_football.m_vY != 0) {
            if (Math.abs(CPlayer.dirDifference(this.m_currDir, CPlayer.dirTo(Actor.s_football.m_vX, Actor.s_football.m_vY))) >= 2) {
                if (this.m_disToBall < 1280 && Actor.s_ball_state == 0) {
                    CPlayer.parseVector(1280, this.m_currDir);
                    Actor.s_football.m_posX = this.m_posX + s_vectorX;
                    Actor.s_football.m_posY = this.m_posY + s_vectorY;
                }
                this.setBehavior(29);
                n = 4;
            } else if (this.posBehindMe(Actor.s_football.m_posX, Actor.s_football.m_posY)) {
                this.setBehavior(30);
                n = 4;
            } else {
                n = 2;
            }
        } else {
            n = 2;
        }
        CPlayer.parseVector(1280, this.m_currDir);
        this.getBall();
        Actor.setBallTurnTo(this.m_posX + s_vectorX + this.m_vX * n, this.m_posY + s_vectorY + this.m_vY * n, n);
    }

    private boolean doDirect() {
        int n = this.m_nextState;
        if (this.m_preState == 2) {
            if (this.m_myTeam.m_type == 0) {
                if (this.m_preDir == -1) {
                    this.m_preDir = this.m_currDir;
                }
                if (CTeam.s_potentialPlayer == null) {
                    this.selectPassPoint(this.m_preDir, 0);
                    this.pass(s_passPointX, s_passPointY, s_passPlayerNumber);
                } else {
                    this.pass(CTeam.s_potentialPassPointX, CTeam.s_potentialPassPointY, CTeam.s_potentialPlayer.m_Number);
                    if (Device.fastDistance(CTeam.s_potentialPlayer.m_posX - this.m_param1, CTeam.s_potentialPlayer.m_posY - this.m_param2) <= 1280) {
                        CTeam.s_potentialPlayer.doStand();
                    }
                }
            } else {
                this.pass(this.m_preParam1, this.m_preParam2, -1);
            }
            this.m_nextState = n;
            this.doOutBall(2, true);
            return true;
        }
        if (this.m_preState == 3) {
            if (this.m_myTeam.m_type == 0) {
                if (this.m_preDir == -1) {
                    this.m_preDir = this.m_currDir;
                }
                if (!this.selectPassPoint(this.m_preDir, 2)) {
                    if (this.myPosInAcrossingZone()) {
                        this.selectCenterPassPoint();
                    } else if (!this.m_myTeam.m_leftSide ? this.m_posX >= 49152 : this.m_posX <= -49152) {
                        int n2 = this.m_myTeam.m_leftSide ? 2 : 6;
                        this.selectPassPoint(n2, 2);
                    }
                }
                this.longPass(s_passPointX, s_passPointY, 5120);
            } else {
                this.longPass(this.m_preParam1, this.m_preParam2, 5120);
            }
            this.m_nextState = n;
            this.doOutBall(3, true);
            return true;
        }
        if (this.m_preState == 4) {
            if (s_power < 3) {
                this.shoot(0);
            } else {
                this.shoot(11776 * (s_power - Device.random(0, 3)) / 12);
            }
            if (this.m_nextState == 4) {
                this.m_nextState = n;
                this.doOutBall(4, true);
            } else {
                this.m_nextState = n;
                this.doOutBall(3, true);
            }
            return true;
        }
        return false;
    }

    private void persistSpecialDirect() {
        if (s_ballLastOwner == this || s_ballOwner != null || !this.m_myTeam.m_rcvUseNewPointingSystem) {
            return;
        }
        if (this.m_frameIDNow == (this.m_behavior == 15 ? 2 : 1)) {
            this.getBall();
            this.loseBall();
            if (this.m_currState == 2) {
                if ((this.m_starAbility & 8) != 0) {
                    Actor.s_ballOutPower = 40;
                }
                Actor.setBallOutTo(0, this.m_outBallParam1, this.m_outBallParam2, 0, -1, -1);
                Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 10);
            } else if (this.m_currState == 3) {
                Actor.setBallOutTo(1, this.m_outBallParam1, this.m_outBallParam2, this.m_outBallParam3, -1, -1);
                Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 10);
            } else if (this.m_currState == 4) {
                if (CPlayer.s_ballLastOwner.m_myTeam.m_type == 0) {
                    if (this.m_behavior == 15) {
                        Device.s_drawSupport = true;
                        Actor.s_support.setAction(4, true);
                    } else {
                        Device.s_drawSupport = true;
                        Actor.s_support.setAction(7 + Device.selected_language * 18, true);
                    }
                }
                Actor.s_ballOutPower = this.m_curAbilityPow;
                Actor.setBallOutTo(2, this.m_outBallParam1, this.m_outBallParam2, this.m_outBallParam3, -1, -1);
                Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 0);
                if (this.m_outBallParam2 > -9216 && this.m_outBallParam2 < 9216 && this.m_outBallParam3 < 10240 && (this.m_myTeam.m_leftSide ? this.m_outBallParam1 > this.m_posX : this.m_outBallParam1 < this.m_posX)) {
                    Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 1);
                }
            }
            int n = this.m_behavior == 15 ? 2560 : 5120;
            CPlayer.parseVector(3072, this.m_currDir);
            Actor.s_football.m_posX = this.m_posX + s_vectorX;
            Actor.s_football.m_posY = this.m_posY + s_vectorY;
            Actor.s_football.m_posZ = n;
            this.m_myTeam.m_rcvUseNewPointingSystem = false;
        }
    }

    private void doOutBall(int n, boolean bl) {
        if (!bl) {
            if (!this.m_withBall) {
                this.m_nextState = 0;
                return;
            }
            if (CTeam.s_matchState != 0) {
                if (this.m_disToBall > 1280) {
                    CPlayer.parseVector(this.m_speed, Actor.s_football.m_posX - this.m_posX, Actor.s_football.m_posY - this.m_posY);
                    this.m_vX = s_vectorX;
                    this.m_vY = s_vectorY;
                    this.m_destChanged = false;
                    this.setBehavior(1);
                    return;
                }
                this.m_vX = 0;
                this.m_vY = 0;
                this.m_destChanged = false;
            }
        }
        int n2 = Actor.s_football.m_posZ - Actor.s_football.m_vZ;
        if (Actor.s_ball_heldbyplayer && CTeam.s_kickPlayer == this) {
            this.m_currState = n;
            this.m_outBallParam1 = this.m_param1;
            this.m_outBallParam2 = this.m_param2;
            this.m_outBallParam3 = this.m_param3;
            this.m_currDir = CPlayer.dirTo(this.m_outBallParam1 - this.m_posX, this.m_outBallParam2 - this.m_posY);
            this.setBehavior(46);
        } else if (bl || n2 <= 5120) {
            if (n != 4 || bl || !CPlayer.dirIn3(this.m_currDir, CPlayer.dirTo(this.m_outBallParam1 - this.m_posX, this.m_outBallParam2 - this.m_posY))) {
                this.m_vY = 0;
                this.m_vX = 0;
            }
            this.m_currState = n;
            this.m_outBallParam1 = this.m_param1;
            this.m_outBallParam2 = this.m_param2;
            this.m_outBallParam3 = this.m_param3;
            this.m_outBallParam4 = Actor.s_football.m_posZ;
            if (bl && this.m_myTeam.m_specialDirectType == 1) {
                this.m_nextDir = this.m_currDir;
                if (this.posBehindMe(this.m_outBallParam1, this.m_outBallParam2)) {
                    if (n == 2) {
                        this.selectPassPoint(this.m_currDir, 0);
                        this.pass(s_passPointX, s_passPointY, s_passPlayerNumber);
                    } else {
                        this.selectPassPoint(this.m_currDir, 1);
                        this.longPass(s_passPointX, s_passPointY, 5120);
                    }
                    this.m_outBallParam1 = this.m_param1;
                    this.m_outBallParam2 = this.m_param2;
                    this.m_outBallParam3 = this.m_param3;
                }
                if (Device.fastDistance(this.m_outBallParam1 - this.m_posX, this.m_outBallParam2 - this.m_posY) > 30720) {
                    CPlayer.parseVector(1920, this.m_outBallParam1 - this.m_posX, this.m_outBallParam2 - this.m_posY);
                    this.m_outBallParam1 = this.m_posX + (s_vectorX << 4);
                    this.m_outBallParam2 = this.m_posY + (s_vectorY << 4);
                }
                int n3 = this.m_myTeam.m_rcvBallGoAndKickX;
                int n4 = this.m_myTeam.m_rcvBallGoAndKickY;
                int n5 = n3 - this.m_myTeam.m_rcvGoAndKickX;
                int n6 = n4 - this.m_myTeam.m_rcvGoAndKickY;
                int n7 = Device.fastDistance(n5, n6) / 2;
                this.setBehavior(15);
                if (n7 > this.m_speedFast << 1) {
                    n7 = this.m_speedFast << 1;
                }
                CPlayer.parseVector(n7, n5, n6);
                this.m_vX = s_vectorX;
                this.m_vY = s_vectorY;
                if (CPlayer.dirIn3(CPlayer.dirTo(this.m_vX, this.m_vY), this.m_currDir + 4 & 7)) {
                    CPlayer.parseVector(n7, this.m_currDir);
                    this.m_vX = s_vectorX;
                    this.m_vY = s_vectorY;
                }
                this.m_aX = -this.m_vX / 5;
                this.m_aY = -this.m_vY / 5;
                this.m_myTeam.m_specialDirectType = 0;
            } else if (bl && (Actor.s_ball_state == 1 || Actor.s_ball_state == 10) && (this.m_myTeam.m_rcvUseNewPointingSystem ? this.m_myTeam.m_rcvActionKind == 0 : this.ballOverMeOn(2) && Actor.s_futureBallPosZ[Actor.s_ctrFutureBallFrame + 2 - 2] > 5120)) {
                this.getBall();
                int n8 = this.m_outBallParam1 - this.m_posX;
                int n9 = this.m_outBallParam2 - this.m_posY;
                this.m_nextDir = this.m_currDir = CPlayer.dirTo(n8, n9);
                int n10 = 25600;
                if (n == 2) {
                    n10 = 65536;
                }
                if (Device.fastDistance(n8, n9) > n10) {
                    CPlayer.parseVector(n10 >> 4, n8, n9);
                    this.m_outBallParam1 = this.m_posX + (s_vectorX << 4);
                    this.m_outBallParam2 = this.m_posY + (s_vectorY << 4);
                }
                this.setBehavior(13);
                CPlayer cPlayer = CPlayer.findNearestToBallInTeam(1 - this.m_myTeam.m_ID, false);
                if (cPlayer != null && Device.fastDistance(this.m_posX - cPlayer.m_posX, this.m_posY - cPlayer.m_posY) < 8192) {
                    cPlayer.m_nextDir = cPlayer.m_currDir = -this.m_currDir + Device.random(-1, 1) & 7;
                    cPlayer.m_vX >>= 1;
                    cPlayer.m_vY >>= 1;
                    cPlayer.setBehavior(13);
                }
            } else if (bl && (Actor.s_ball_state == 1 || Actor.s_ball_state == 10) && n == 4 && (this.m_myTeam.m_rcvUseNewPointingSystem ? this.m_myTeam.m_rcvActionKind == 4 : this.ballOverMeOn(2) && Actor.s_futureBallPosZ[Actor.s_ctrFutureBallFrame + 2 - 2] > 7168)) {
                this.getBall();
                int n11 = this.m_outBallParam1 - this.m_posX;
                int n12 = this.m_outBallParam2 - this.m_posY;
                switch (CPlayer.dirTo(-n11, -n12)) {
                    case 1: 
                    case 2: {
                        this.m_currDir = 2;
                        this.m_nextDir = 2;
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.m_currDir = 4;
                        this.m_nextDir = 4;
                        break;
                    }
                    case 5: 
                    case 6: {
                        this.m_currDir = 6;
                        this.m_nextDir = 6;
                        break;
                    }
                    case 0: 
                    case 7: {
                        this.m_currDir = 0;
                        this.m_nextDir = 0;
                    }
                }
                if (Device.fastDistance(n11, n12) > 25600) {
                    CPlayer.parseVector(1600, n11, n12);
                    this.m_outBallParam1 = this.m_posX + (s_vectorX << 4);
                    this.m_outBallParam2 = this.m_posY + (s_vectorY << 4);
                }
                this.setBehavior(47);
                CPlayer cPlayer = CPlayer.findNearestToBallInTeam(1 - this.m_myTeam.m_ID, false);
                if (cPlayer != null && Device.fastDistance(this.m_posX - cPlayer.m_posX, this.m_posY - cPlayer.m_posY) < 8192) {
                    cPlayer.m_nextDir = cPlayer.m_currDir = -this.m_currDir + Device.random(-1, 1) & 7;
                    cPlayer.m_vX >>= 1;
                    cPlayer.m_vY >>= 1;
                    cPlayer.setBehavior(13);
                }
            } else {
                if (bl) {
                    this.getBall();
                }
                switch (CPlayer.dirDifference(this.m_currDir, CPlayer.dirTo(this.m_outBallParam1 - this.m_posX, this.m_outBallParam2 - this.m_posY))) {
                    case -1: 
                    case 0: 
                    case 1: {
                        if (n == 2) {
                            this.setBehavior(11);
                            break;
                        }
                        if (n == 3) {
                            this.setBehavior(12);
                            break;
                        }
                        if (n != 4) break;
                        this.setBehavior(18);
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (n == 2 || n == 3) {
                            this.setBehavior(20);
                        } else if (n == 4) {
                            this.setBehavior(26);
                        }
                        this.m_currDir = this.m_currDir + 2 & 7;
                        break;
                    }
                    case -3: 
                    case -2: {
                        if (n == 2 || n == 3) {
                            this.setBehavior(19);
                        } else if (n == 4) {
                            this.setBehavior(25);
                        }
                        this.m_currDir = this.m_currDir - 2 & 7;
                        break;
                    }
                    case 4: {
                        if (n == 2 || n == 3) {
                            this.setBehavior(22);
                        } else if (n == 4) {
                            this.setBehavior(28);
                        }
                        this.m_currDir = this.m_nextDir;
                    }
                }
            }
        } else {
            CPlayer.parseVector(this.m_speedMove, Actor.s_football.m_vX, Actor.s_football.m_vY);
            this.m_vX = s_vectorX;
            this.m_vY = s_vectorY;
            this.setBehavior(24);
        }
        this.m_nextDir = this.m_currDir;
        if (n == 2 && this.m_outBallParam3 >= 0 && this.m_outBallParam3 < 11 && this.m_myTeam.m_players[this.m_outBallParam3].m_currState == 1 && Device.fastDistance(this.m_myTeam.m_players[this.m_outBallParam3].m_posX - this.m_outBallParam1, this.m_myTeam.m_players[this.m_outBallParam3].m_posY - this.m_outBallParam2) <= 1280) {
            this.m_myTeam.m_players[this.m_outBallParam3].doStand();
        }
    }

    private void sendBallOutAtKeyFrame() {
        int n = 1;
        switch (this.m_behavior) {
            case 18: {
                if (this.m_outBallParam3 > 0) {
                    n = 2;
                    break;
                }
                n = 2;
                break;
            }
            case 12: {
                n = 2;
                break;
            }
            case 13: {
                n = 2;
                break;
            }
            case 47: {
                n = 2;
                break;
            }
            case 22: 
            case 28: {
                n = 2;
                break;
            }
            case 25: 
            case 26: {
                n = 2;
                break;
            }
            case 109: {
                n = 4;
                break;
            }
            case 110: {
                n = 2;
                break;
            }
            case 46: {
                n = 3;
                break;
            }
            case 15: {
                n = 2;
            }
        }
        int n2 = Device.fastDistance(Actor.s_football.m_lastPosX - this.m_posX, Actor.s_football.m_lastPosY - this.m_posY);
        if (this.m_disToBall > n2) {
            if (this.m_currState == 4 && !this.m_myTeam.m_rcvUseNewPointingSystem) {
                CPlayer.parseVector(2048, this.m_currDir);
                if (CTeam.s_matchState == 0) {
                    Actor.s_football.m_posX = this.m_posX + s_vectorX;
                    Actor.s_football.m_posY = this.m_posY + s_vectorY;
                }
            } else {
                Actor.s_football.m_posX = Actor.s_football.m_lastPosX;
                Actor.s_football.m_posY = Actor.s_football.m_lastPosY;
                this.m_disToBall = n2;
                this.m_dirToBall = CPlayer.dirTo(Actor.s_football.m_lastPosX - this.m_posX, Actor.s_football.m_lastPosY - this.m_posY);
            }
        }
        if (this.m_behavior == 13 || this.m_behavior == 47) {
            int n3 = n2 = this.m_behavior == 13 ? 8192 : 7168;
            if (this.m_frameIDNow < n) {
                Actor.s_football.m_posZ = n2 + (this.m_outBallParam4 - n2) * (n + 1 - this.m_frameIDNow - this.m_frameDuration - 1) / (n + 1);
                if (this.m_disToBall < 1280) {
                    CPlayer.parseVector(1280, this.m_currDir);
                    Actor.s_football.m_posX = this.m_posX + s_vectorX;
                    Actor.s_football.m_posY = this.m_posY + s_vectorY;
                }
            } else {
                CPlayer.parseVector(1280, this.m_currDir);
                Actor.s_football.m_posZ = n2;
                Actor.s_football.m_posX = this.m_posX + s_vectorX;
                Actor.s_football.m_posY = this.m_posY + s_vectorY;
            }
        } else if (this.m_disToBall < 1280 && Math.abs(CPlayer.dirDifference(this.m_currDir, this.m_dirToBall)) <= 1) {
            CPlayer.parseVector(1280, this.m_currDir);
            Actor.s_football.m_posX = this.m_posX + s_vectorX;
            Actor.s_football.m_posY = this.m_posY + s_vectorY;
        }
        if (this.m_frameIDNow == n) {
            if (this.m_myTeam.m_type == 0 && this.m_opTeam.m_rcvUseNewPointingSystem) {
                Device.s_drawSupport = true;
                Actor.s_support.setAction(12 + Device.selected_language * 18, true);
            }
            if (CTeam.s_matchState != 0 && CTeam.s_period > 4) {
                CTeam.s_matchState = 0;
                CTeam.s_placementByCPU = false;
            }
            if (Actor.s_ball_heldbyplayer && CTeam.s_kickPlayer == this) {
                this.loseBall();
                Actor.s_ball_heldbyplayer = false;
                Actor.s_football.m_posY = Device.limit(Actor.s_football.m_posY, -86015, 86015);
                Actor.s_football.m_posZ = 7680;
                if (this.m_currState == 3) {
                    Actor.setBallOutTo(0, this.m_outBallParam1, this.m_outBallParam2, 0, -1, -1);
                    Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 10);
                }
            } else if (this.m_behavior == 13) {
                this.loseBall();
                if (this.m_currState == 2 || this.m_currState == 3) {
                    Actor.setBallOutTo(0, this.m_outBallParam1, this.m_outBallParam2, 0, -1, -1);
                    Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 10);
                } else if (this.m_currState == 4) {
                    if (this.m_myTeam.m_type == 0) {
                        Device.s_drawSupport = true;
                        Actor.s_support.setAction(5 + Device.selected_language * 18, true);
                    }
                    Actor.s_ballOutPower = this.m_curAbilityPow;
                    Actor.setBallOutTo(2, this.m_outBallParam1, this.m_outBallParam2, this.m_outBallParam3 + (Actor.s_football.m_posZ >> 2), -1, -1);
                    Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 0);
                    if (this.m_outBallParam2 > -9216 && this.m_outBallParam2 < 9216 && this.m_outBallParam3 < 10240 && (this.m_myTeam.m_leftSide ? this.m_outBallParam1 > this.m_posX : this.m_outBallParam1 < this.m_posX)) {
                        Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 1);
                    }
                }
            } else {
                this.loseBall();
                if (this.m_currState == 2) {
                    if ((this.m_starAbility & 8) != 0) {
                        Actor.s_ballOutPower = 40;
                    }
                    Actor.setBallOutTo(0, this.m_outBallParam1, this.m_outBallParam2, 0, -1, -1);
                    Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 10);
                    if (CPlayer.s_ballLastOwner.m_myTeam.m_type == 0 && s_power >= 3) {
                        Device.s_drawSupport = true;
                        Actor.s_support.setAction(9 + Device.selected_language * 18, true);
                    }
                    int n4 = this.m_myTeam.PosToGrid(this.m_outBallParam1);
                    if (this.m_myTeam.m_type == 1 && this.m_Number != 0 && s_oneTwoPlayer[this.m_myTeam.m_ID] == null && n4 > 0 && n4 < this.m_myTeam.PosToGrid(92160) && n4 > this.m_myTeam.PosToGrid(this.m_posX) && Device.fastDistance(this.m_outBallParam1 - this.m_posX, this.m_outBallParam2 - this.m_posY) < 65536) {
                        CPlayer.s_oneTwoPressed[this.m_myTeam.m_ID] = true;
                    }
                } else if (this.m_currState == 3) {
                    if (this.m_Number == 0) {
                        if (this.m_behavior == 110) {
                            Actor.setBallOutTo(10, this.m_outBallParam1, this.m_outBallParam2, this.m_outBallParam3, -1, -1);
                        } else {
                            Actor.setBallOutTo(1, this.m_outBallParam1, this.m_outBallParam2, this.m_outBallParam3, -1, -1);
                        }
                    } else if (this.m_idea == 4) {
                        this.m_idea = -1;
                        Actor.setBallOutTo(1, this.m_outBallParam1, this.m_outBallParam2, this.m_outBallParam3, -1, -1);
                    } else if (!this.m_myTeam.m_leftSide ? this.m_posX >= 49152 : this.m_posX <= -49152) {
                        Actor.setBallOutTo(1, this.m_outBallParam1, this.m_outBallParam2, this.m_outBallParam3, -1, -1);
                    } else if ((this.m_starAbility & 2) != 0) {
                        if (this.m_myTeam.m_type == 0) {
                            Device.s_drawSupport = true;
                            Actor.s_support.setAction(8 + Device.selected_language * 18, true);
                        }
                        Actor.s_ballOutPower = this.m_curAbilityPow;
                        Actor.setBallOutTo(10, this.m_outBallParam1, this.m_outBallParam2, this.m_outBallParam3, 150, 0);
                    } else {
                        Actor.s_ballOutPower = this.m_curAbilityPow;
                        Actor.setBallOutTo(10, this.m_outBallParam1, this.m_outBallParam2, this.m_outBallParam3, -1, -1);
                    }
                    Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 10);
                } else if (this.m_currState == 4) {
                    this.addFatigue(1);
                    if (CPlayer.s_ballLastOwner.m_myTeam.m_type == 0 && Device.s_whichHalf != 99) {
                        if (this.m_behavior == 47) {
                            Device.s_drawSupport = true;
                            Actor.s_support.setAction(6 + Device.selected_language * 18, true);
                        } else if ((this.m_starAbility & 4) != 0 && s_power >= 6) {
                            Device.s_drawSupport = true;
                            Actor.s_support.setAction(2 + Device.selected_language * 18, true);
                        } else if ((this.m_starAbility & 2) != 0 && this.m_outBallParam3 > 0) {
                            Device.s_drawSupport = true;
                            Actor.s_support.setAction(3 + Device.selected_language * 18, true);
                        } else if (s_power < 6) {
                            Device.s_drawSupport = true;
                            Actor.s_support.setAction(0 + Device.selected_language * 18, true);
                        } else if (this.m_myTeam.m_rcvUseNewPointingSystem) {
                            Device.s_drawSupport = true;
                            Actor.s_support.setAction(4 + Device.selected_language * 18, true);
                        } else {
                            Device.s_drawSupport = true;
                            Actor.s_support.setAction(1 + Device.selected_language * 18, true);
                        }
                    }
                    Actor.s_ballOutPower = this.m_curAbilityPow;
                    if ((this.m_starAbility & 4) != 0 && (this.m_myTeam.m_type == 0 && s_power >= 6 || this.m_myTeam.m_type == 1 && Device.random(0, 1) == 0)) {
                        Actor.setBallOutTo(9, this.m_outBallParam1, this.m_outBallParam2, this.m_outBallParam3, -1, -1);
                    } else if ((this.m_starAbility & 2) != 0 && this.m_outBallParam3 > 0 && Device.random(0, 1) == 0) {
                        Actor.setBallOutTo(2, this.m_outBallParam1, this.m_outBallParam2, this.m_outBallParam3, 150, 0);
                    } else {
                        Actor.setBallOutTo(2, this.m_outBallParam1, this.m_outBallParam2, this.m_outBallParam3, -1, -1);
                    }
                    Device.pos3DTo2D(Actor.s_football.m_posX, Actor.s_football.m_posY, Actor.s_football.m_posZ);
                    Actor.s_sfx.m_screenX = Device.s_pos2Dx;
                    Actor.s_sfx.m_screenY = Device.s_pos2Dy;
                    if (this.m_curAbilityPow == 0) {
                        Device.s_needDrawSfx = true;
                    }
                    Actor.s_sfx.setAction(0, true);
                    Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 0);
                    if (this.m_outBallParam2 > -9216 && this.m_outBallParam2 < 9216 && this.m_outBallParam3 < 10240 && (this.m_myTeam.m_leftSide ? this.m_outBallParam1 > this.m_posX : this.m_outBallParam1 < this.m_posX)) {
                        Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 1);
                    }
                }
            }
            this.m_opTeam.m_rcvUseNewPointingSystem = this.m_myTeam.m_rcvUseNewPointingSystem = !(Actor.s_ball_state != 10 && Actor.s_ball_state != 1 || Actor.s_ballOutDistance < 30720 || this.m_Number == 0 && this.m_myTeam.PosToGrid(Actor.s_football.m_destX) <= -4);
            CTeam.s_rcvUseNewPointingSystemTeamID = this.m_myTeam.m_ID;
            Actor.s_ballOutDistance = 0;
            if (CTeam.s_matchState != 0) {
                Device.s_drawSupport = false;
            }
        }
    }

    private boolean canTackle() {
        if (CTeam.s_matchState == 0 && this.m_myTeam.m_type == 1 && this.m_disToBall < 3328 && s_ballOwner != null && CPlayer.s_ballOwner.m_myTeam.m_ID != this.m_myTeam.m_ID && (CPlayer.s_ballOwner.m_Number != 0 || CPlayer.s_ballOwner.m_currState != 8 && CPlayer.s_ballOwner.m_currState != 7 && CPlayer.s_ballOwner.m_currState != 5) && s_ctrWithBall > Device.getParamByDifficult(7, 6, 5) && !s_ballOwner.posBehindMe(this.m_posX, this.m_posY)) {
            if (Device.s_matchDifficult >= 2 || (this.m_starAbility & 0x20) != 0) {
                return true;
            }
            return CPlayer.dirIn3(this.m_currDir + 4 & 7, CPlayer.s_ballOwner.m_currDir);
        }
        return false;
    }

    public final void doTackle() {
        if (s_ballOwner == null || CPlayer.s_ballOwner.m_myTeam.m_ID == this.m_myTeam.m_ID) {
            this.m_nextState = 0;
            return;
        }
        if (this.m_Number == 0 && this.m_myTeam.isPointInMyFBZ(this.m_posX, this.m_posY)) {
            this.m_nextDir = this.m_currDir = this.m_dirToBall;
            this.doSaveBall(true);
            s_saveMin = -2;
        } else {
            boolean bl = false;
            if (!this.m_isFocus && CPlayer.s_ballOwner.m_feint == 3 && CPlayer.dirIn3(CPlayer.s_ballOwner.m_currDir, this.m_currDir + 4 & 7) || Device.s_aiMode == 6 && CTeam.s_isTutorialFeint) {
                this.m_vX = 0;
                this.m_vY = 0;
                this.setBehavior(64);
                if (Device.s_aiMode == 6) {
                    return;
                }
            }
            if (this.m_currState == 1 && this.m_curAbilityDef - CPlayer.s_ballOwner.m_curAbilityAtt > 0 && this.m_curAbilityPow - CPlayer.s_ballOwner.m_curAbilityPow > 0 && !this.m_myTeam.isPointInMyFBZ(this.m_posX, this.m_posY)) {
                this.setBehavior(16);
            } else {
                this.setBehavior(14);
                CPlayer.parseVector(this.m_speedMove, this.m_dirToBall);
                this.m_vX = s_vectorX;
                this.m_vY = s_vectorY;
                bl = true;
                Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 11);
            }
            this.m_currState = 5;
            if (CPlayer.s_ballOwner.m_currState == 0 || this.m_isFocus) {
                s_tackleFail = false;
            } else {
                int n = 100;
                if (this.m_curAbilityDef - CPlayer.s_ballOwner.m_curAbilityAtt > 0) {
                    n = 100 + (this.m_curAbilityDef - CPlayer.s_ballOwner.m_curAbilityAtt) * 25;
                }
                if (CPlayer.s_ballOwner.m_character == 1 || (CPlayer.s_ballOwner.m_starAbility & 0x10) != 0) {
                    n -= 25;
                }
                if (this.m_myTeam.PosToGrid(CPlayer.s_ballOwner.m_posX) < -8 && Math.abs(this.m_myTeam.PosToGrid(CPlayer.s_ballOwner.m_posY)) < 5) {
                    n += 100;
                }
                boolean bl2 = s_tackleFail = Device.random(0, 99) > n;
            }
            if (!bl) {
                s_tackleFail = true;
            }
            this.addFatigue(1);
        }
        this.persistTackle();
    }

    private void persistTackle() {
        int n;
        boolean bl;
        if (s_ballOwner == null || CPlayer.s_ballOwner.m_myTeam.m_ID == this.m_myTeam.m_ID) {
            this.m_nextState = 0;
            return;
        }
        if (this.m_Number == 0 && this.m_myTeam.isPointInMyFBZ(this.m_posX, this.m_posY)) {
            bl = this.m_disToBall <= 3072;
        } else {
            this.m_currDir = this.m_dirToBall;
            if (((3328 > this.m_controlRange ? this.m_disToBall <= 3328 : this.m_disToBall <= this.m_controlRange) && Actor.s_football.m_posZ <= 6656 ? true : (bl = false)) && s_tackleFail) {
                bl = false;
            }
            if (bl && CTeam.s_newtutorialStep != 37 && Device.fastDistance(this.m_posX - CPlayer.s_ballOwner.m_posX, this.m_posY - CPlayer.s_ballOwner.m_posY) < 3328 && s_ballOwner.posBehindMe(this.m_posX, this.m_posY) && CPlayer.dirIn3(this.m_currDir, CPlayer.s_ballOwner.m_currDir) && (Device.s_matchDifficult > 1 || Device.random(0, 2) == 0)) {
                n = Device.random(0, 9);
                if (this.m_fatigue > 100) {
                    n -= 3;
                } else if (this.m_fatigue > 80) {
                    n -= 2;
                } else if (this.m_fatigue > 60) {
                    --n;
                }
                if (Device.s_weather != 0) {
                    n -= 3;
                }
                if (n < 5 && this.m_myTeam.m_type == 1 || n < 2 && this.m_myTeam.m_type == 0) {
                    bl = false;
                    s_ballOwner.setBehavior(17);
                    CPlayer.s_ballOwner.m_vX = 0;
                    CPlayer.s_ballOwner.m_vY = 0;
                    if (CPlayer.s_ballOwner.m_currState == 0 || CPlayer.s_ballOwner.m_currState == 1) {
                        CTeam.s_injuredPlayer = s_ballOwner;
                        Device.s_radisRect = CTeam.s_injuredPlayer.m_Number;
                        Device.s_radisRect = 0;
                        Device.s_radisRect = CTeam.s_injuredPlayer.m_myTeam.m_ID << 8;
                        Device.s_radisRect += CTeam.s_injuredPlayer.m_Number;
                    } else {
                        CTeam.s_injuredPlayer = null;
                    }
                    n = Device.random(0, 99);
                    if (this.m_myTeam.gkIsLastDefender()) {
                        if (n < 50) {
                            this.doFoul(1);
                        } else {
                            this.doFoul(0);
                        }
                    } else if (n < 25) {
                        this.doFoul(1);
                    } else {
                        this.doFoul(0);
                    }
                }
            }
        }
        if (bl || Device.s_aiMode == 6) {
            int n2 = 0;
            if (Device.s_weather != 0) {
                n2 = 5;
            }
            if (Device.random(0, 9) <= n2) {
                s_ballOwner.setBehavior(17);
                n = 20;
            } else {
                s_ballOwner.setBehavior(16);
                n = 5;
            }
            if (CPlayer.s_ballOwner.m_myTeam.m_type == 1 && CPlayer.s_ballOwner.m_reaction << 1 > n) {
                n = CPlayer.s_ballOwner.m_reaction;
            }
            if (Device.s_matchDifficult == 5) {
                n += 3;
            }
            s_ballOwner.doFool(n);
            s_ballOwner.loseBall();
            if (this.m_currState == 7) {
                this.getBall();
                if (Math.abs(CPlayer.dirDifference(this.m_currDir, CPlayer.s_ballLastOwner.m_currDir)) <= 1 && Device.random(0, 9) < 2) {
                    this.doFoul(0);
                    return;
                }
            } else {
                CPlayer cPlayer = null;
                if (this.m_currDir == (CPlayer.s_ballLastOwner.m_currDir + 4 & 7)) {
                    cPlayer = Device.random(0, 1) == 0 ? s_ballLastOwner : this;
                }
                this.getBall();
                this.loseBall();
                if (cPlayer != null) {
                    Actor.s_football.m_vX = 5184;
                    Actor.s_football.m_vY = 5184;
                    Actor.setBallReflect(cPlayer);
                } else {
                    CPlayer.parseVector(5120, this.m_currDir);
                    Actor.setBallOutTo(5, Actor.s_football.m_posX + s_vectorX, Actor.s_football.m_posY + s_vectorY, 0, -1, -1);
                    Device.keyPressed &= 0xFFFFFEFF;
                    Device.keyCurrent &= 0xFFFFFEFF;
                    Device.keyDblPressed &= 0xFFFFFEFF;
                }
                s_ballTackledOutBy = this;
                if (CTeam.s_matchState == 0) {
                    this.m_idea = 1;
                }
            }
        }
    }

    private void goodTackleOrGoodDribble() {
        if (CTeam.s_matchState == 0 && s_ballOwner == null && CPlayer.s_ballLastOwner.m_Number == this.m_Number) {
            if (this.m_myTeam.m_type == 0) {
                if (this.m_currState == 5) {
                    Device.s_drawSupport = true;
                    Actor.s_support.setAction(13 + Device.selected_language * 18, true);
                } else {
                    Device.s_drawSupport = true;
                    Actor.s_support.setAction(14 + Device.selected_language * 18, true);
                }
            }
            this.m_myTeam.addMorale(20);
            this.m_opTeam.deMorale(10);
        }
    }

    private void doSlideTackle() {
        if (s_ballOwner == null || CPlayer.s_ballOwner.m_myTeam.m_ID == this.m_myTeam.m_ID || this.m_behavior == 15) {
            this.m_nextState = 0;
            return;
        }
        int n = 768;
        if (Device.s_weather != 0) {
            n = 1152;
        }
        CPlayer.parseVector_screen(n, this.m_currDir);
        this.m_vX = s_vectorX;
        this.m_vY = s_vectorY;
        if (this.m_currState == 0) {
            this.m_vX >>= 1;
            this.m_vY >>= 1;
        }
        this.m_aX = -this.m_vX / 20;
        this.m_aY = -this.m_vY / 20;
        this.setBehavior(15);
        Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 11);
        this.addFatigue(1);
        this.persistSlideTackle();
    }

    private void persistSlideTackle() {
        int n;
        this.updateSpeed();
        if (s_ballOwner == null || CPlayer.s_ballOwner.m_myTeam.m_ID == this.m_myTeam.m_ID) {
            this.m_nextState = 0;
            return;
        }
        boolean bl = CPlayer.dirIn3(this.m_dirToBall, this.m_currDir) && this.m_disToBall <= 6400 && Actor.s_football.m_posZ <= 5120;
        if (bl && s_ballOwner.posBehindMe(this.m_posX, this.m_posY) && CPlayer.dirIn3(this.m_currDir, CPlayer.s_ballOwner.m_currDir) && CTeam.s_newtutorialStep != 37 && (Device.s_matchDifficult > 1 || Device.random(0, 2) == 0)) {
            this.setBehavior(90);
            s_ballOwner.setBehavior(17);
            CPlayer.s_ballOwner.m_vX = 0;
            CPlayer.s_ballOwner.m_vY = 0;
            if (CPlayer.s_ballOwner.m_currState == 0 || CPlayer.s_ballOwner.m_currState == 1) {
                CTeam.s_injuredPlayer = s_ballOwner;
                Device.s_radisRect = CTeam.s_injuredPlayer.m_Number;
                Device.s_radisRect = 0;
                Device.s_radisRect = CTeam.s_injuredPlayer.m_myTeam.m_ID << 8;
                Device.s_radisRect += CTeam.s_injuredPlayer.m_Number;
            } else {
                CTeam.s_injuredPlayer = null;
            }
            n = Device.random(0, 99);
            if (this.m_myTeam.gkIsLastDefender()) {
                if (n < 50) {
                    this.doFoul(2);
                } else if (n < 60) {
                    this.doFoul(1);
                } else {
                    this.doFoul(0);
                }
            } else if (n < 30) {
                this.doFoul(2);
            } else if (n < 60) {
                this.doFoul(1);
            } else {
                this.doFoul(0);
            }
            bl = false;
        }
        if (Device.s_aiMode == 6 && CTeam.s_newtutorialStep == 38 && this.m_disToBall <= 12800) {
            bl = true;
        }
        if (bl) {
            this.setBehavior(90);
            if (Device.random(0, 9) < 4) {
                s_ballOwner.setBehavior(17);
                n = 20;
            } else {
                s_ballOwner.setBehavior(16);
                n = 5;
            }
            CPlayer.s_ballOwner.m_vX >>= 1;
            CPlayer.s_ballOwner.m_vY >>= 1;
            CPlayer cPlayer = null;
            if (!s_ballOwner.posBehindMe(this.m_posX, this.m_posY) && Device.random(0, 2) == 0) {
                cPlayer = Device.random(0, 1) == 0 ? s_ballOwner : this;
            }
            if (CPlayer.s_ballOwner.m_myTeam.m_type == 1 && CPlayer.s_ballOwner.m_reaction << 1 > n) {
                n = CPlayer.s_ballOwner.m_reaction;
            }
            s_ballOwner.doFool(n);
            s_ballOwner.loseBall();
            this.getBall();
            this.loseBall();
            if (cPlayer != null) {
                Actor.s_football.m_vX = 5184;
                Actor.s_football.m_vY = 5184;
                Actor.setBallReflect(cPlayer);
            } else {
                CPlayer.parseVector(5120, this.m_currDir);
                Actor.setBallOutTo(5, Actor.s_football.m_posX + s_vectorX + this.m_vX * 6, Actor.s_football.m_posY + s_vectorY + this.m_vY * 6, 0, -1, -1);
            }
            s_ballTackledOutBy = this;
            return;
        }
        if (this.m_actionOver) {
            this.m_nextState = 0;
        }
    }

    public final boolean selectPassPoint(int n, int n2) {
        int n3;
        int n4;
        boolean bl;
        int n5;
        int n6;
        int n7;
        boolean bl2;
        int n8 = 0;
        boolean bl3 = bl2 = n2 == 0 || n2 == 4 || n2 == 9 || n2 == 7;
        if (n2 == 0) {
            n7 = 12288;
            n6 = 65536;
            n5 = 25600;
            bl = true;
        } else if (n2 == 9) {
            n7 = 12288;
            n6 = 122880;
            n5 = 25600;
            bl = false;
        } else if (n2 == 7) {
            n7 = 6144;
            n6 = 32768;
            n5 = 25600;
            bl = false;
        } else if (n2 == 8) {
            n7 = 6144;
            n6 = 131072;
            n5 = 25600;
            bl = false;
        } else if (n2 == 1) {
            n7 = 30720;
            n6 = 122880;
            n5 = 76800;
            bl = false;
        } else if (n2 == 2 || n2 == 5) {
            n7 = 10240 * (s_power - 2);
            n6 = n7 + 30720;
            n5 = n7 + n6 >> 1;
            if (n7 < 30720) {
                n7 = 30720;
            }
            if (n6 > 122880) {
                n6 = 122880;
            }
            bl = false;
        } else {
            if (n2 == 3) {
                CPlayer.parseVector(122880, n);
                s_passPointX = Actor.s_football.m_posX + s_vectorX;
                s_passPointY = Actor.s_football.m_posY + s_vectorY;
                s_passPlayerNumber = -1;
                return false;
            }
            if (n2 == 4) {
                n7 = 6144;
                n6 = CTeam.s_matchState == 3 ? 65536 : 131072;
                n5 = 25600;
                bl = false;
            } else if (n2 == 6) {
                if (this.m_currState == 8) {
                    n7 = 76800;
                    n6 = 102400;
                    n5 = 89600;
                } else {
                    n7 = 61440;
                    n6 = 122880;
                    n5 = 76800;
                }
                bl = false;
            } else {
                return false;
            }
        }
        int n9 = 0;
        int n10 = -1;
        int n11 = 0;
        int n12 = 0;
        for (n4 = 1; n4 < 11; ++n4) {
            if (n4 == this.m_Number || (n2 == 4 || n2 == 6) && (CPlayer.s_ballOwner.m_Number == n4 || n4 == 0)) continue;
            CPlayer cPlayer = this.m_myTeam.m_players[n4];
            if (cPlayer.m_court != 0) continue;
            for (n3 = 0; n3 < 2; ++n3) {
                int n13;
                int n14;
                int n15;
                int n16;
                if (n3 == 0) {
                    n16 = cPlayer.m_posX;
                    n15 = cPlayer.m_posY;
                    if (n2 != 4 && n2 != 6) {
                        n14 = cPlayer.m_dirToBall + 4 & 7;
                        n13 = cPlayer.m_disToBall;
                    } else {
                        n14 = CPlayer.dirTo(n16 - this.m_posX, n15 - this.m_posY);
                        n13 = Device.fastDistance(n16 - this.m_posX, n15 - this.m_posY);
                    }
                    n8 = n13;
                } else {
                    if (!bl || cPlayer.m_tacState != 3 && cPlayer.m_tacState != 2 || cPlayer.m_destX == 0 && cPlayer.m_destY == 0) continue;
                    n16 = cPlayer.m_destX;
                    n15 = cPlayer.m_destY;
                    n14 = CPlayer.dirTo(n16 - Actor.s_football.m_posX, n15 - Actor.s_football.m_posY);
                    n13 = Device.fastDistance(n16 - Actor.s_football.m_posX, n15 - Actor.s_football.m_posY);
                    if (Math.abs(n8 - n13) > 8192) continue;
                }
                if (bl2 && this.m_myTeam.haveEnemyBlockInPass$53c8923f(this, n16, n15) || (n2 != 4 && n2 != 6 ? n14 != n : !CPlayer.dirIn3(n14, n))) continue;
                if (n2 == 5) {
                    n11 = n16;
                    n12 = n15;
                    n10 = n4;
                }
                if (n13 < n7 || n13 > n6) continue;
                if (n2 == 9) {
                    boolean bl4 = true;
                    for (int i = 0; i < 11; ++i) {
                        int n17;
                        CPlayer cPlayer2 = this.m_opTeam.m_players[i];
                        if (cPlayer2.m_court != 0 || (n17 = Device.fastDistance(cPlayer2.m_posX - cPlayer.m_posX, cPlayer2.m_posY - cPlayer.m_posY)) >= 15360) continue;
                        bl4 = false;
                        break;
                    }
                    if (!bl4) continue;
                }
                if (n9 != 0 && n13 >= n9) continue;
                s_passPointX = n16;
                s_passPointY = n15;
                s_passPlayerNumber = n4;
                n9 = n13;
            }
        }
        if (n9 == 0) {
            if (n2 == 5 && n10 != -1) {
                CPlayer.parseVector(n5, n11 - Actor.s_football.m_posX >> 4, n12 - Actor.s_football.m_posY >> 4);
                s_passPointX = Actor.s_football.m_posX + s_vectorX;
                s_passPointY = Actor.s_football.m_posY + s_vectorY;
                s_passPlayerNumber = n10;
                return true;
            }
            CPlayer.parseVector(n5, n);
            s_passPointX = Actor.s_football.m_posX + s_vectorX;
            s_passPointY = Actor.s_football.m_posY + s_vectorY;
            s_passPlayerNumber = -1;
            return false;
        }
        if (this.myPosInAcrossingZone()) {
            n4 = CPlayer.dirTo(this.m_myTeam.convertPos(135168) - s_passPointX, 0 - s_passPointY);
            n3 = n9 >> 3;
            CPlayer.parseVector(n3, n4);
            s_passPointY += s_vectorY;
            if (this.m_myTeam.m_leftSide && (s_passPointX += s_vectorX) > 119296) {
                s_passPointX = 119296;
            } else if (!this.m_myTeam.m_leftSide && s_passPointX < -119296) {
                s_passPointX = -119296;
            }
        }
        return true;
    }

    public final boolean calShootRange() {
        int n = this.m_myTeam.convertPos(this.m_posX);
        int n2 = this.m_myTeam.convertPos(this.m_posY);
        if (n >= 32768) {
            int n3;
            int n4;
            if (this.m_myTeam.convertPos(this.m_opTeam.m_GK.m_posX) < n || n >= 124928 && Math.abs(n2) < 9216) {
                s_shootMinY = -9984;
                s_shootMaxY = 9984;
                return true;
            }
            int n5 = this.m_currDir;
            if (!this.m_myTeam.m_leftSide) {
                n5 = 8 - n5 & 7;
            }
            if (Device.s_matchDifficult == 1 || Device.s_matchDifficult == 0) {
                n4 = Device.s_matchDifficult == 0 ? 1 : 0;
                int[] nArray = new int[]{25, 28, 31, 34, 37};
                n3 = nArray[this.m_curAbilityAtt + 1 - n4];
            } else {
                n3 = SHOOT_MIN_HALF_RANGE[this.m_curAbilityAtt + 1];
                if (CTeam.s_matchState == 0 && (this.m_starAbility & 1) != 0 && this.m_myTeam.isInOpForbidden(this.m_posX, this.m_posY)) {
                    n3 = SHOOT_MIN_HALF_RANGE[0];
                }
            }
            n4 = n3 + (52 - n3) * (135168 - n) / 102400;
            int n6 = 8;
            int n7 = 8;
            if (Device.s_matchDifficult == 1 || Device.s_matchDifficult == 0) {
                n6 = 0;
                n7 = 0;
            }
            if (n5 == 0 || n5 == 4) {
                n4 += n6;
            } else if (n5 == 5 || n5 == 6 || n5 == 7) {
                n4 += n6 << 1;
            }
            if (Device.s_matchDifficult != 1 && Device.s_matchDifficult != 0) {
                n4 += Math.abs(n2) >> 12;
            }
            int n8 = this.m_posY >> 12;
            if (n5 == 0) {
                n8 -= n7 << 1;
            } else if (n5 == 4) {
                n8 += n7 << 1;
            } else if (n5 == 1 || n5 == 7) {
                n8 -= n7;
            } else if (n5 == 3 || n5 == 5) {
                n8 += n7;
            }
            s_shootMinY = (n8 <<= 8) - (n4 <<= 8);
            s_shootMaxY = n8 + n4;
            if (CTeam.s_matchState == 8) {
                if (this.m_myTeam.m_type == 0) {
                    s_shootMinY -= 7680;
                    s_shootMaxY += 7680;
                } else {
                    s_shootMinY = -9984;
                    s_shootMaxY = 9984;
                }
            }
            return true;
        }
        return false;
    }

    public static CPlayer findNearestToBallInTeam(int n, boolean bl) {
        int n2;
        CPlayer cPlayer = null;
        int n3 = 334848;
        if (Device.s_aiMode == 6 && n == 0 && CTeam.s_newtutorialStep == 9 && CTeam.s_newtutorialStep == 9) {
            return CTeam.s_teams[0].m_players[8];
        }
        int n4 = n2 = bl ? 0 : 1;
        while (n2 < 10) {
            CPlayer cPlayer2 = CTeam.s_teams[n].m_players[n2];
            if (cPlayer2.m_court == 0 && cPlayer2.m_disToBall < n3) {
                n3 = cPlayer2.m_disToBall;
                cPlayer = cPlayer2;
            }
            ++n2;
        }
        return cPlayer;
    }

    public static void shoveAll() {
        CPlayer cPlayer;
        if (Device.s_aiMode == 2 || Device.s_aiMode == 6) {
            return;
        }
        if (CTeam.s_matchState != 0) {
            return;
        }
        CPlayer cPlayer2 = null;
        CPlayer cPlayer3 = null;
        if (s_ballOwner == null) {
            CPlayer cPlayer4 = s_ballReceiver[0] == null ? CPlayer.findNearestToBallInTeam(0, true) : s_ballReceiver[0];
            cPlayer = s_ballReceiver[1] == null ? CPlayer.findNearestToBallInTeam(1, true) : s_ballReceiver[1];
            if (s_ballLastOwner == null) {
                cPlayer2 = cPlayer4;
                cPlayer3 = cPlayer;
            } else {
                cPlayer2 = CPlayer.s_ballLastOwner.m_myTeam.m_ID == 0 ? cPlayer : cPlayer4;
                CPlayer cPlayer5 = cPlayer3 = CPlayer.s_ballLastOwner.m_myTeam.m_ID == 0 ? cPlayer4 : cPlayer;
            }
            if (cPlayer2 != null && cPlayer3 != null && cPlayer2.m_speed < cPlayer3.m_speed) {
                CPlayer cPlayer6 = cPlayer3;
                cPlayer3 = cPlayer2;
                cPlayer2 = cPlayer6;
            }
        } else {
            cPlayer2 = s_ballOwner;
            if (CPlayer.s_ballOwner.m_opTeam.m_type == 1) {
                for (int i = 0; i < 11; ++i) {
                    cPlayer = CPlayer.s_ballOwner.m_opTeam.m_players[i];
                    if (cPlayer.m_court != 0 || cPlayer.m_tacState != 7) continue;
                    cPlayer3 = cPlayer;
                    break;
                }
            } else {
                cPlayer3 = s_focusPlayer;
            }
            if (cPlayer3 == null) {
                cPlayer3 = CPlayer.findNearestToBallInTeam(1 - cPlayer2.m_myTeam.m_ID, true);
            }
        }
        if (cPlayer2 != null && cPlayer3 != null) {
            if (cPlayer2.m_currState == 9 || cPlayer2.m_behavior == 15 || cPlayer2.m_behavior == 17 || cPlayer2.m_behavior == 31 || cPlayer3.m_currState == 9 || cPlayer3.m_behavior == 15 || cPlayer3.m_behavior == 17 || cPlayer3.m_behavior == 31 || cPlayer3.m_idea == 0) {
                return;
            }
            if (Device.screenDistance(cPlayer2.m_posX - cPlayer3.m_posX, cPlayer2.m_posY - cPlayer3.m_posY) <= 2048) {
                int n;
                boolean bl = false;
                int n2 = CPlayer.dirTo(cPlayer3.m_posX - cPlayer2.m_posX, cPlayer3.m_posY - cPlayer2.m_posY);
                int n3 = Device.fastDistance(cPlayer3.m_vX, cPlayer3.m_vY);
                if (cPlayer2.posBehindMe(cPlayer3.m_posX, cPlayer3.m_posY)) {
                    n = CPlayer.dirTo(cPlayer2.m_posX - cPlayer3.m_posX, cPlayer2.m_posY - cPlayer3.m_posY);
                    if (CPlayer.dirIn3(cPlayer3.m_currDir, n) && n3 > Device.fastDistance(cPlayer2.m_vX, cPlayer2.m_vY)) {
                        int n4 = cPlayer3.posClockwiseOfMe(cPlayer2.m_posX, cPlayer2.m_posY, cPlayer3.m_currDir) ? n2 + 1 & 7 : n2 - 1 & 7;
                        CPlayer.parseVector(1536, n4);
                        cPlayer3.m_posX = cPlayer2.m_posX + s_vectorX;
                        cPlayer3.m_posY = cPlayer2.m_posY + s_vectorY;
                        cPlayer3.m_destChanged = true;
                        cPlayer3.m_beShoved = true;
                    }
                } else {
                    int n5;
                    int n6 = cPlayer2.m_currDir;
                    if (cPlayer2.posClockwiseOfMe(cPlayer3.m_posX, cPlayer3.m_posY, cPlayer2.m_currDir)) {
                        n = cPlayer2.m_currDir + 1 & 7;
                        if (n2 == cPlayer2.m_currDir) {
                            n6 = cPlayer2.m_currDir - 1 & 7;
                        }
                    } else {
                        n = cPlayer2.m_currDir - 1 & 7;
                        if (n2 == cPlayer2.m_currDir) {
                            n6 = cPlayer2.m_currDir + 1 & 7;
                        }
                    }
                    CPlayer.parseVector(512, n);
                    cPlayer3.m_posX += s_vectorX;
                    cPlayer3.m_posY += s_vectorY;
                    bl = true;
                    if (n2 == cPlayer2.m_currDir) {
                        CPlayer.parseVector(512, n6);
                        cPlayer2.m_posX += s_vectorX;
                        cPlayer2.m_posY += s_vectorY;
                        cPlayer2.m_destChanged = true;
                        cPlayer2.m_beShoved = true;
                    }
                    while ((n5 = Device.fastDistance(cPlayer2.m_posX - cPlayer3.m_posX, cPlayer2.m_posY - cPlayer3.m_posY)) < 1536) {
                        CPlayer.parseVector(512, n);
                        cPlayer3.m_posX += s_vectorX;
                        cPlayer3.m_posY += s_vectorY;
                    }
                }
                if (Device.isLineSegmentCrossPoint(cPlayer3.m_posX, cPlayer3.m_posY, cPlayer2.m_lastPosX, cPlayer2.m_lastPosY, cPlayer2.m_posX, cPlayer2.m_posY, 1536)) {
                    n = cPlayer2.posClockwiseOfMe(cPlayer3.m_posX, cPlayer3.m_posY, cPlayer2.m_currDir) ? cPlayer2.m_currDir + 1 & 7 : cPlayer2.m_currDir - 1 & 7;
                    CPlayer.parseVector(1536, n);
                    cPlayer3.m_posX = cPlayer2.m_posX + s_vectorX;
                    cPlayer3.m_posY = cPlayer2.m_posY + s_vectorY;
                    bl = true;
                }
                if (Device.fastDistance(cPlayer3.m_posX - cPlayer2.m_posX, cPlayer3.m_posY - cPlayer2.m_posY) < 1536) {
                    CPlayer.parseVector(1536, cPlayer3.m_posX - cPlayer2.m_posX, cPlayer3.m_posY - cPlayer2.m_posY);
                    cPlayer3.m_posX = cPlayer2.m_posX + s_vectorX;
                    cPlayer3.m_posY = cPlayer2.m_posY + s_vectorY;
                    bl = true;
                }
                if (bl && (!cPlayer3.m_isFocus || cPlayer3.m_currState != 1 || cPlayer3.m_param3 != 7)) {
                    cPlayer3.m_destChanged = true;
                    cPlayer3.m_beShoved = true;
                    if (cPlayer3.m_currDir != cPlayer3.m_dirToBall) {
                        cPlayer3.m_nextDir = cPlayer3.m_dirToBall;
                    }
                    cPlayer3.doFool(5);
                }
            }
        }
    }

    private void gkSaveBall() {
        if (this.m_behavior >= 100 && this.m_behavior <= 106) {
            if (s_ballOwner == null && s_saveMin >= -1 && this.gkBlockBall()) {
                int n;
                boolean bl;
                int n2 = Device.fastDistance(Actor.s_football.m_vX, Actor.s_football.m_vY);
                boolean bl2 = true;
                boolean bl3 = this.m_behavior >= 100 && this.m_behavior <= 106;
                boolean bl4 = Actor.s_football.m_destY >> 8 > 18 && !this.m_myTeam.m_leftSide || Actor.s_football.m_destY >> 8 < -18 && this.m_myTeam.m_leftSide;
                boolean bl5 = Actor.s_football.m_destY >> 8 > 18 && this.m_myTeam.m_leftSide || Actor.s_football.m_destY >> 8 < -18 && !this.m_myTeam.m_leftSide;
                boolean bl6 = bl = bl5 && (this.m_behavior == 101 || this.m_behavior == 104 || this.m_behavior == 106) || bl4 && (this.m_behavior == 100 || this.m_behavior == 103 || this.m_behavior == 105);
                if ((s_ballLastPlayer == null || CPlayer.s_ballLastPlayer.m_myTeam.m_ID != this.m_myTeam.m_ID) && (bl3 || this.canTrap()) && (n = n2 - this.m_inaccuracy) > 0) {
                    if (bl) {
                        bl2 = false;
                    } else {
                        int n3 = n / 1280;
                        if (n3 > 2) {
                            n3 = 2;
                        }
                        if (Device.random(0, 4) < n3 + 2) {
                            bl2 = false;
                        }
                    }
                }
                if (bl2) {
                    if (this.m_myTeam.m_type == 0) {
                        Device.s_drawSupport = true;
                        Actor.s_support.setAction(15 + Device.selected_language * 18, true);
                    }
                    Actor.s_football.m_posX = this.m_posX;
                    Actor.s_football.m_posY = this.m_posY;
                    if (this.m_behavior == 100 || this.m_behavior == 101) {
                        Actor.s_football.m_posZ = 5120;
                    } else if (this.m_behavior != 105 && this.m_behavior != 106) {
                        Actor.s_football.m_posZ = this.m_posZ;
                    }
                    Actor.s_football.m_vX = this.m_vX;
                    Actor.s_football.m_vY = this.m_vY;
                    Actor.s_football.m_vZ = 0;
                    this.getBall();
                    ++this.m_successSaveTime;
                } else {
                    if (this.m_myTeam.m_type == 0) {
                        Device.s_drawSupport = true;
                        Actor.s_support.setAction(16 + Device.selected_language * 18, true);
                    }
                    Actor.setBallReflect(this);
                    this.getBall();
                    this.loseBall();
                    ++this.m_successSaveTime;
                }
            } else if (s_saveMin < -1 && (this.m_behavior == 103 || this.m_behavior == 104) && this.m_frameIDNow < 4) {
                this.persistTackle();
            }
            ++s_saveTick;
        }
        if (this.m_withBall) {
            Actor.putBallOnGround(Actor.s_football.m_posX, Actor.s_football.m_posY);
            Actor.s_ball_heldbygk = true;
        }
        if ((this.m_behavior == 103 || this.m_behavior == 104) && this.m_frameIDNow == 4 || (this.m_behavior == 101 || this.m_behavior == 100) && this.m_frameIDNow == 7) {
            this.m_vY = 0;
            this.m_vX = 0;
        }
        if (this.m_actionOver) {
            if (this.m_behavior == 100 || this.m_behavior == 101 || this.m_behavior == 105 || this.m_behavior == 106 || this.m_behavior >= 102 && this.m_behavior <= 104) {
                this.m_vX = 0;
                this.m_vY = 0;
                if (this.m_behavior == 103) {
                    this.m_nextDir = this.m_currDir = (this.m_currDir - 1 & 7) / 2 * 2 + 3 & 7;
                } else if (this.m_behavior == 104) {
                    this.m_nextDir = this.m_currDir = (this.m_currDir - 1 & 7) / 2 * 2 + 7 & 7;
                } else if (this.m_behavior == 100 || this.m_behavior == 105) {
                    this.m_currDir = this.m_posX > 0 ? 0 : 2;
                    this.m_nextDir = this.m_currDir;
                } else if (this.m_behavior == 101 || this.m_behavior == 106) {
                    this.m_currDir = this.m_posX > 0 ? 2 : 0;
                    this.m_nextDir = this.m_currDir;
                }
                this.setBehavior(107);
                return;
            }
            if (this.m_behavior == 107) {
                if (this.m_withBall) {
                    this.doStandWithBall();
                    return;
                }
                this.doFool(this.m_reaction >> 2);
                return;
            }
            this.doFool(this.m_reaction >> 1);
        }
    }

    private boolean gkBlockBall() {
        int n;
        int n2;
        int n3;
        int n4;
        if (Device.s_aiMode == 6) {
            return false;
        }
        if (this.m_behavior == 102) {
            n4 = -1792;
            n3 = 1792;
            n2 = 6144;
            n = 0;
        } else if (this.m_behavior == 100 || this.m_behavior == 101) {
            n4 = -1792;
            n3 = 1792;
            n2 = 10752;
            n = 0;
        } else if (this.m_behavior == 103 || this.m_behavior == 104) {
            n4 = -4096;
            n3 = 4096;
            n2 = 6144;
            n = 0;
        } else if (this.m_behavior == 105 || this.m_behavior == 106) {
            n4 = -3072;
            n3 = 3072;
            n2 = 10752;
            n = 6144;
        } else {
            n4 = -1792;
            n3 = 1792;
            n2 = 6144;
            n = 0;
        }
        int n5 = (this.m_starAbility & 0x80) != 0 ? 256 : this.m_controlRange;
        n4 -= n5;
        n3 += n5;
        if (n5 > 0) {
            n2 += n5;
            n -= n5;
        }
        if (n < 0) {
            n = 0;
        }
        if (this.m_myTeam.m_type == 1 && Device.s_matchDifficult > 1) {
            n4 -= 256;
            n3 += 256;
        }
        if (this.m_currDir == 0 || this.m_currDir == 4) {
            return Actor.s_football.faceCollideBall(2, this.m_posY, this.m_posX + n4, this.m_posX + n3, this.m_posZ + n2, this.m_posZ + n);
        }
        return Actor.s_football.faceCollideBall(3, this.m_posX, this.m_posY + n4, this.m_posY + n3, this.m_posZ + n2, this.m_posZ + n);
    }

    private void doSaveBall(boolean bl) {
        if (Device.s_whichHalf == 99 && !CTeam.s_isGKSavingPenalty) {
            return;
        }
        s_saveTick = 0;
        s_saveMin = bl ? -2 : -1;
        this.m_vX = 0;
        this.m_vY = 0;
        this.m_currState = 7;
        int n = s_ballOwner != null ? Actor.s_football.m_posX : s_savePointX;
        int n2 = s_ballOwner != null ? Actor.s_football.m_posY : s_savePointY;
        int n3 = s_ballOwner != null ? Actor.s_football.m_posZ : s_savePointZ;
        int n4 = Device.fastDistance(n - this.m_posX, n2 - this.m_posY);
        int n5 = this.m_dirToBall;
        int n6 = CPlayer.dirDifference(this.m_currDir, CPlayer.dirTo(n - this.m_posX, n2 - this.m_posY));
        if (!bl && n4 < 3072) {
            if (n3 > 6144) {
                if (n6 == 0) {
                    if (this.m_posX > 0) {
                        this.setBehavior(Actor.s_football.m_vY > 0 ? 101 : 100);
                    } else {
                        this.setBehavior(Actor.s_football.m_vY > 0 ? 100 : 101);
                    }
                } else {
                    this.setBehavior(n6 < 0 ? 101 : 100);
                }
            } else if (n4 < 1536) {
                this.setBehavior(102);
            } else {
                this.setBehavior(n6 < 0 ? 104 : 103);
            }
            s_saveMin = 2;
        } else if (bl || n4 < 5120) {
            if (bl) {
                CPlayer.parseVector(256, this.m_currDir);
            } else {
                CPlayer.parseVector(256, n5);
            }
            this.m_vX = s_vectorX;
            this.m_vY = s_vectorY;
            if (n3 > 6144) {
                this.setBehavior(n6 < 0 ? 106 : 105);
                s_saveMin = 4;
            } else {
                this.setBehavior(n6 < 0 ? 104 : 103);
                s_saveMin = 3;
            }
        } else if (n4 < 10240) {
            if (CTeam.s_isGKSavingPenalty) {
                if (CTeam.s_savePenaltyDir == 1) {
                    this.m_vY = 1024;
                } else if (CTeam.s_savePenaltyDir == -1) {
                    this.m_vY = -1024;
                }
                this.m_vX = n > 0 ? -512 : 512;
            } else {
                CPlayer.parseVector(256, n5);
                this.m_vX = s_vectorX;
                this.m_vY = s_vectorY;
            }
            if (n3 > 6144) {
                this.setBehavior(n6 < 0 ? 101 : 100);
            } else {
                this.setBehavior(n6 < 0 ? 104 : 103);
            }
            s_saveMin = 3;
        } else {
            this.setBehavior(n6 < 0 ? 104 : 103);
        }
        CTeam.s_isGKSavingPenalty = false;
    }

    private boolean canPickup() {
        if (this.m_Number != 0 || s_ctrWithoutBall < 3 || CTeam.s_matchState != 0) {
            return false;
        }
        return s_ballOwner == null && (s_ballLastPlayer == null || CPlayer.s_ballLastPlayer.m_myTeam.m_ID != this.m_myTeam.m_ID) && this.m_myTeam.isPointInMyFBZ(this.m_posX, this.m_posY) && this.m_disToBall < 2048 && Math.abs(CPlayer.dirDifference(this.m_dirToBall, this.m_currDir)) < 3 && Actor.s_football.m_posZ < 3072;
    }

    private void doPickup() {
        this.m_vX = 0;
        this.m_vY = 0;
        this.m_nextState = this.m_currState = 8;
        int n = CPlayer.dirDifference(this.m_currDir, this.m_dirToBall);
        this.setBehavior(n < 0 ? 104 : 103);
        Actor.s_football.m_posX = this.m_posX;
        Actor.s_football.m_posY = this.m_posY;
        Actor.s_football.m_posZ = this.m_posZ;
        Actor.s_football.m_vX = this.m_vX;
        Actor.s_football.m_vY = this.m_vY;
        Actor.s_football.m_vZ = this.m_vZ;
        s_GKPickingUpBall = true;
        this.getBall();
    }

    private void doStandWithBall() {
        this.m_vX = 0;
        this.m_vY = 0;
        Actor.putBallOnGround(this.m_posX, this.m_posY);
        Actor.s_football.m_posZ = 8192;
        this.m_nextState = this.m_currState = 8;
        this.m_nextDir = this.m_currDir = this.m_myTeam.m_leftSide ? 2 : 6;
        Actor.s_ball_heldbygk = true;
        this.setBehavior(108);
    }

    private void doKickOutBall() {
        this.m_nextDir = this.m_currDir = this.m_myTeam.m_leftSide ? 2 : 6;
        this.m_currState = 3;
        this.m_nextState = 3;
        int n = Device.fastDistance(this.m_param1 - this.m_posX, this.m_param2 - this.m_posY);
        if (n < 102400) {
            this.setBehavior(110);
            return;
        }
        this.setBehavior(109);
    }

    public static boolean isJustKickOut() {
        return s_ballOwner == null && s_ballLastOwner != null && CPlayer.s_ballLastOwner.m_Number == 0 && (CPlayer.s_ballLastOwner.m_behavior == 109 || CPlayer.s_ballLastOwner.m_behavior == 110) && s_ctrWithoutBall == 0;
    }

    public final void setFocus() {
        if (s_focusPlayer != this) {
            if (s_focusPlayer != null) {
                CPlayer.s_focusPlayer.m_preDir = -1;
                CPlayer.s_focusPlayer.m_preState = -1;
                CPlayer.s_focusPlayer.m_isFocus = false;
                CPlayer.s_focusPlayer.m_fastrun = false;
                CPlayer.s_focusPlayer.m_preFastRun = false;
                s_focusPlayer.stand(false);
            }
            this.m_isFocus = true;
            s_focusPlayer = this;
            this.m_foolEndsTick = 0L;
            if (CTeam.s_matchState == 0 && !this.m_withBall) {
                this.m_idea = 1;
            }
            if (this.m_Number != 0) {
                this.stand(false);
            }
            s_lastInputDir = -1;
            this.m_dribbleState = 0;
            s_radar = 0;
            this.m_idea = -1;
            Device.refreshNameBuff(Device.playerNameInMatch[this.m_Number]);
        }
    }

    public static void clearFocus() {
        if (s_focusPlayer != null) {
            CPlayer.s_focusPlayer.m_preDir = -1;
            CPlayer.s_focusPlayer.m_preState = -1;
            CPlayer.s_focusPlayer.m_preFastRun = false;
            CPlayer.s_focusPlayer.m_isFocus = false;
            s_focusPlayer.stand(false);
            s_focusPlayer = null;
        }
        s_radar = 0;
    }

    private void updateFocusPlayer() {
        if (!(CTeam.s_matchState == 0 && Device.s_whichHalf != 99 || CTeam.s_placementByCPU && CTeam.s_period > 4 && !Device.haveKeyHold(3840))) {
            return;
        }
        if (this.m_Number != 0 && (Actor.s_ball_heldbygk || CTeam.s_matchState == 4)) {
            this.runTo(0, 0, false);
            return;
        }
        if (Device.s_aiMode == 6 && CTeam.s_isTutorialFeint) {
            if ((Device.haveKeyPressed(2048) || Device.haveKeyHold(2048)) && CTeam.s_canPressStarToFeint && !CTeam.s_tutorialFeintBegin) {
                Device.keyCurrent = 2048;
                Device.keyPressed = 2048;
            } else {
                Device.keyCurrent = 0;
                Device.keyPressed = 0;
            }
            if (s_radar != 6) {
                s_radar = 0;
            }
            if (CTeam.s_newtutorialStep == 24 || CTeam.s_newtutorialStep == 26) {
                return;
            }
        }
        if (Device.s_aiMode == 6 && Device.s_tickCounter - CTeam.s_newTutorialCounter < 5L) {
            return;
        }
        if (this.m_idea == 3 && Device.anyKeyPressed()) {
            this.m_idea = -1;
        }
        if (Device.haveKeyDoublePressed(256) && s_oneTwoPlayer[this.m_myTeam.m_ID] == null && !s_oneTwoPressed[this.m_myTeam.m_ID] && this.m_Number != 0 && (Device.s_aiMode != 6 || CTeam.s_newtutorialStep != 7)) {
            CTeam.s_canThroughInTutorial = true;
            CPlayer.s_oneTwoPressed[this.m_myTeam.m_ID] = true;
        }
        if (s_radar == 5) {
            if (Device.haveKeyHold(256) && s_power < 12) {
                s_power = s_power <= 3 ? ++s_power : (s_power += 5);
            } else {
                if (CTeam.s_potentialPlayer == null) {
                    this.selectPassPoint(this.m_nextDir, 0);
                    if (this.m_withBall && this.m_currState != 13) {
                        this.pass(s_passPointX, s_passPointY, s_passPlayerNumber);
                    } else {
                        this.m_preState = 2;
                    }
                } else if (this.m_withBall && this.m_currState != 13) {
                    this.pass(CTeam.s_potentialPassPointX, CTeam.s_potentialPassPointY, CTeam.s_potentialPlayer.m_Number);
                    if (Device.fastDistance(CTeam.s_potentialPlayer.m_posX - this.m_param1, CTeam.s_potentialPlayer.m_posY - this.m_param2) <= 1280) {
                        CTeam.s_potentialPlayer.doStand();
                    }
                } else {
                    this.m_preState = 2;
                }
                s_radar = 0;
                if (s_power >= 3) {
                    s_powerDisappearTime = Device.s_tickCounter + 15L;
                }
            }
        } else if (s_radar == 2) {
            if (Device.haveKeyHold(512) && s_power < 12) {
                if ((s_power += 3) > 12) {
                    s_power = 12;
                }
            } else {
                if (!this.selectPassPoint(this.m_nextDir, 2) && this.myPosInAcrossingZone()) {
                    this.selectCenterPassPoint();
                }
                if (this.m_withBall && this.m_currState != 13) {
                    if (Device.s_aiMode == 6) {
                        CTeam.s_isTutorialLongPassBySharp = true;
                        if (CTeam.s_newtutorialStep == 9 && s_ballOwner != CTeam.s_team0.m_players[8]) {
                            CTeam.getPointBetweenTwoPoint(100, this.m_posX, this.m_posY, CTeam.s_team0.m_players[8].m_posX, CTeam.s_team0.m_players[8].m_posY);
                            this.longPass(CTeam.s_middlePointX, CTeam.s_middlePointY, 5120);
                        } else if ((CTeam.s_newtutorialStep == 19 || CTeam.s_newtutorialStep == 11) && this.myPosInAcrossingZone()) {
                            this.longPass(122368, 0, 5120);
                            CTeam.s_isTutorialHeadShoot = true;
                        } else {
                            this.longPass(s_passPointX, s_passPointY, 5120);
                        }
                    } else {
                        this.longPass(s_passPointX, s_passPointY, 5120);
                    }
                } else {
                    this.m_preState = 3;
                }
                s_radar = 0;
                s_powerDisappearTime = Device.s_tickCounter + 15L;
            }
        } else if (s_radar == 3) {
            if (Device.haveKeyHold(1024) && s_power < 12) {
                if ((s_power += 2) > 12) {
                    s_power = 12;
                }
            } else {
                if (this.m_withBall && this.m_currState != 13) {
                    if (s_power < 3) {
                        this.shoot(0);
                    } else {
                        this.shoot(11776 * (s_power - Device.random(0, 3)) / 12);
                    }
                } else {
                    this.m_preState = 4;
                }
                s_radar = 0;
                s_powerDisappearTime = Device.s_tickCounter + 15L;
            }
        } else if (s_radar == 6) {
            long l = Device.getKeyInterval(2048);
            if (s_power == 2) {
                if (Device.haveKeyReleased(2048)) {
                    s_power = 3;
                } else if (Device.haveKeyHold(2048) && l > 2L) {
                    s_power = 1;
                }
            } else if (s_power == 3) {
                if (Device.haveKeyHold(1024)) {
                    this.m_preState = 13;
                    s_radar = 3;
                    s_power = 1;
                    CTeam.s_isCurveshoot = true;
                } else if (l > 3L) {
                    this.feint(3);
                    s_power = 0;
                    s_radar = 0;
                }
            } else if (Device.haveKeyReleased(2048)) {
                s_power = 0;
                s_radar = 0;
            }
        } else if (!CTeam.s_placementByCPU && Device.haveKeyPressed(3840)) {
            if (this.m_Number == 0 && this.m_currState == 8 && (this.m_behavior == 107 || this.m_behavior == 108)) {
                if (Device.haveKeyPressed(256)) {
                    if (CTeam.s_potentialPlayer != null) {
                        this.longPass(CTeam.s_potentialPlayer.m_posX, CTeam.s_potentialPlayer.m_posY, 5120);
                    } else {
                        this.selectPassPoint(this.m_currDir, 6);
                        this.longPass(s_passPointX, s_passPointY, 5120);
                    }
                } else {
                    this.selectPassPoint(this.m_currDir, 3);
                    this.longPass(s_passPointX, s_passPointY, 5120);
                }
            } else if (this.m_isBallReceiver || this == s_ballFastOwner) {
                if (Device.haveKeyPressed(256)) {
                    if (this.m_myTeam.m_state == 1) {
                        s_radar = 5;
                        s_power = 0;
                    } else {
                        s_power = 6;
                        this.m_preState = 2;
                    }
                } else if (Device.haveKeyPressed(512)) {
                    if (this.m_withBall) {
                        s_radar = 2;
                        s_power = 4;
                    } else if (this.m_myTeam.m_state == 1) {
                        s_power = 6;
                        this.m_preState = 3;
                    } else {
                        this.m_myTeam.setFocusPlayer(true);
                    }
                } else if (Device.haveKeyPressed(1024)) {
                    s_radar = 3;
                    s_power = 4;
                }
            } else if (this.m_withBall) {
                if (this.m_currState == 13 && this.m_param3 == 2) {
                    this.m_actionOver = true;
                    this.m_feintEndsTick = 0L;
                }
                if (Device.haveKeyPressed(256)) {
                    s_radar = 5;
                    s_power = 0;
                } else if (Device.haveKeyPressed(512)) {
                    s_radar = 2;
                    s_power = 4;
                } else if (Device.haveKeyPressed(1024)) {
                    s_radar = 3;
                    s_power = 4;
                } else if (Device.haveKeyPressed(2048)) {
                    s_radar = 6;
                    s_power = 2;
                }
            } else if (s_ballOwner != null && this.m_myTeam != CPlayer.s_ballOwner.m_myTeam || s_ballFastOwner != null && this.m_myTeam != CPlayer.s_ballFastOwner.m_myTeam) {
                if (Device.haveKeyPressed(512)) {
                    this.m_myTeam.setFocusPlayer(true);
                } else if (this.m_opTeam.m_GK.m_currState != 8) {
                    boolean bl = false;
                    if (Device.haveKeyPressed(256)) {
                        if (this.m_disToBall <= 3328 && CTeam.s_newtutorialStep != 40) {
                            bl = true;
                            this.tackle();
                        } else {
                            this.tracePlayerBegin(s_ballOwner != null ? CPlayer.s_ballOwner.m_Number : CPlayer.s_ballFastOwner.m_Number);
                        }
                    } else if (Device.haveKeyPressed(512)) {
                        bl = true;
                        this.slideTackle();
                    } else if (Device.haveKeyPressed(1024)) {
                        bl = true;
                        this.slideTackle();
                    }
                    if (bl && this.m_idea == 0) {
                        this.tracePlayerEnd();
                    }
                }
            } else {
                this.m_idea = 1;
                if (this.m_myTeam.m_state == 1) {
                    if (Device.haveKeyPressed(256)) {
                        this.m_preState = 2;
                        s_power = 6;
                    } else if (Device.haveKeyPressed(512)) {
                        this.m_preState = 3;
                        s_power = 6;
                    } else if (Device.haveKeyPressed(1024)) {
                        this.m_preState = 4;
                        s_power = 6;
                    }
                } else if (Device.haveKeyPressed(512)) {
                    this.m_myTeam.setFocusPlayer(true);
                } else if (Device.haveKeyPressed(1024)) {
                    this.m_preState = 4;
                    s_power = 6;
                }
            }
        }
        if (this.m_nextState == 1 || this.m_nextState == 0) {
            int n;
            int n2 = -1;
            int n3 = -1;
            boolean bl = false;
            int n4 = -1;
            for (n = 0; n < 4; ++n) {
                if (Device.haveKeyReleased(1 << n + 14)) {
                    bl = true;
                    s_lastPadTick = 0L;
                    break;
                }
                if (!Device.haveKeyHold(1 << n + 14)) continue;
                n4 = n * 2 + 1 & 7;
                if (s_lastPadDir == -1 || s_lastPadDir == n4 || this == s_ballFastOwner || Math.abs(CPlayer.dirDifference(s_lastPadDir, n4)) != 1 || Device.s_tickCounter - s_lastPadTick >= 10L) break;
                n4 = -1;
                break;
            }
            if (n4 != -1) {
                n2 = CPlayer.dirDifference(this.m_currDir, n4);
                n3 = n2 == 2 || n2 == -2 ? this.m_currDir + (n2 >> 1) + 8 & 7 : n4;
                if (this.m_withBall && this.m_currState == 1 && Math.abs(n2) > 2) {
                    s_lastPadTick = 0L;
                    s_lastPadDir = -1;
                } else {
                    s_lastPadTick = Device.s_tickCounter;
                    s_lastPadDir = n3;
                }
            } else if (s_lastPadDir != -1 && this != s_ballFastOwner) {
                n3 = s_lastPadDir;
            } else {
                for (n = 0; n <= 7; ++n) {
                    if (Device.haveKeyReleased(1 << n)) {
                        bl = true;
                        s_radar = 4;
                        s_power = 0;
                        break;
                    }
                    if (!Device.haveKeyHold(1 << n)) continue;
                    n3 = n + 1 & 7;
                    if (n3 != (this.m_currDir + this.m_preDir & 7) || this.m_currState != 13 || this.m_param3 != 2 || Device.getKeyInterval(1 << n) >= (long)Device.KEYHOLD_MOVE90_INTERVAL) break;
                    n2 = n3;
                    break;
                }
            }
            if (n3 != -1) {
                if (this.m_dribbleState == 0 || this.m_dribbleState == 2) {
                    this.m_fastrun = false;
                    if (this.m_curAbilityTech == 3 && this.m_curAbilitySpd == 3 && Device.s_aiMode != 6) {
                        this.m_dribbleState = 1;
                    }
                }
                if (Device.haveKeyDoublePressed(1 << (n3 - 1 + 8 & 7)) || n4 != -1 && Device.haveKeyDoublePressed(1 << ((n4 - 1 + 8 & 7) >> 1) + 14)) {
                    if (this == s_ballFastOwner && n3 != this.m_currDir) {
                        this.m_preFastRun = true;
                    }
                    this.m_dribbleState = 1;
                    this.m_fastrun = true;
                }
            }
            if (bl) {
                this.m_dribbleState = 0;
                this.m_fastrun = false;
            }
            if (this.m_idea == 0 && n3 != -1) {
                this.tracePlayerEnd();
            }
            if (this.m_isBallReceiver) {
                this.updateBallReceiver(n3);
                return;
            }
            if (Device.haveKeyHold(256) && !Device.haveKeyPressed(256) && !this.m_withBall) {
                if (this.m_disToBall < 3328 && s_ballOwner != null) {
                    this.m_idea = -1;
                    this.tackle();
                    return;
                }
                if (s_ballOwner == null) {
                    this.runTo(Actor.s_football.m_posX, Actor.s_football.m_posY, true);
                    return;
                }
                this.tracePlayerBegin(CPlayer.s_ballOwner.m_Number);
                return;
            }
            if (Device.haveKeyHold(2048) && !Device.haveKeyPressed(2048) && !this.m_withBall) {
                if (this.m_disToBall < this.m_controlRange && s_ballOwner != null) {
                    if (CTeam.s_newtutorialStep != 40) {
                        this.tackle();
                    }
                } else {
                    this.runTo(Actor.s_football.m_posX, Actor.s_football.m_posY, true);
                }
                if (s_ballOwner != null) {
                    this.m_myTeam.rangedTackle(30720);
                    return;
                }
            } else {
                if (!(this.m_currState != 1 && this.m_currState != 0 || !Device.haveKeyHold(1024) || Device.haveKeyPressed(1024) || this.m_withBall)) {
                    if (this.m_disToBall < 6400 && s_ballOwner != null) {
                        this.m_idea = -1;
                        this.slideTackle();
                        return;
                    }
                    this.runTo(Actor.s_football.m_posX, Actor.s_football.m_posY, true);
                    return;
                }
                if (this.m_idea == 1) {
                    if (s_radar == 4) {
                        this.m_idea = -1;
                        s_power = 0;
                    }
                    if (n3 != -1 && s_ballLastOwner != this && s_ballFastOwner != this && s_ballTackledOutBy != this) {
                        this.m_preDir = -1;
                        this.m_preState = -1;
                        if (s_radar == 4) {
                            s_radar = 0;
                            s_power = 0;
                        }
                        this.runOn(n3);
                        return;
                    }
                    this.runTo(Actor.s_football.m_posX, Actor.s_football.m_posY, true);
                    return;
                }
                if (this.m_idea == 3) {
                    if (this.m_destReached || this.m_disToBall < 3328) {
                        this.tackle();
                        this.m_idea = -1;
                        return;
                    }
                } else {
                    if (n3 != -1) {
                        if (this == s_ballFastOwner) {
                            if (this.m_behavior == 32) {
                                this.m_isFastRun = true;
                            }
                            this.runOn(this.m_currDir);
                            if (n3 != this.m_currDir) {
                                this.m_fastrun = false;
                                this.m_dribbleState = 2;
                                this.m_preDir = n3;
                                this.m_preState = -1;
                                this.m_idea = 1;
                            }
                        } else if (s_ballOwner == null && s_ballFastOwner == null) {
                            if (n3 != -1 && s_ballLastOwner != this && s_ballTackledOutBy != this) {
                                this.m_preDir = -1;
                                this.m_preState = -1;
                                if (s_radar == 4) {
                                    s_radar = 0;
                                    s_power = 0;
                                }
                                this.runOn(n3);
                            } else {
                                this.m_idea = 1;
                                this.directTurn(n3);
                            }
                        } else if (this.m_withBall) {
                            this.m_isFastRun = false;
                            n = CPlayer.dirDifference(this.m_currDir, n3);
                            int n5 = Math.abs(n);
                            if (this.m_currState == 1 && n5 > 1) {
                                if (n5 > 2) {
                                    s_radar = 0;
                                    s_lastInputDir = n3;
                                    this.stand(false);
                                    this.m_dribbleState = 0;
                                    this.m_fastrun = false;
                                    this.m_steponball = true;
                                } else if (n5 == 2 && !CPlayer.isTurnBehavior(this.m_behavior)) {
                                    this.m_preDir = n;
                                    this.m_preState = -1;
                                    this.m_preFastRun = false;
                                    if (s_radar == 4) {
                                        s_radar = 0;
                                        s_power = 0;
                                    }
                                    this.feint(2);
                                }
                            } else if (this.m_currState == 13) {
                                if (this.m_param3 == 2) {
                                    if (n5 == 4) {
                                        this.m_nextDir = this.m_currDir = this.m_currDir + this.m_preDir & 7;
                                        this.m_actionOver = true;
                                        this.feint(2);
                                    } else if (n2 == -1 && n3 == (this.m_currDir + this.m_preDir + 8 & 7)) {
                                        this.m_param3 = this.m_fastrun ? 7 : 3;
                                        this.m_currDir = this.m_dirToBall = n3;
                                        this.m_nextDir = this.m_dirToBall;
                                        this.m_nextState = 1;
                                        this.m_currState = 1;
                                        Actor.s_ball_heldbyplayer = false;
                                        this.doRun();
                                    } else if (s_radar == 4 && (n3 == (this.m_currDir + this.m_preDir + 8 & 7) || n3 == (this.m_currDir - this.m_preDir + 8 & 7))) {
                                        this.m_preDir = n;
                                        this.m_actionOver = true;
                                        this.feint(2);
                                    } else if (this.m_fastrun || n2 == -1) {
                                        this.m_nextState = 1;
                                        this.m_currState = 1;
                                        this.setBehavior(1);
                                        Actor.s_ball_heldbyplayer = false;
                                        this.m_actionOver = true;
                                        this.m_preDir = -1;
                                        this.m_preState = -1;
                                        this.m_preFastRun = false;
                                        if (s_radar == 4) {
                                            s_radar = 0;
                                            s_power = 0;
                                        }
                                        this.m_isFeint = true;
                                        this.runOn(n3);
                                    }
                                } else if (n5 == 1 && this.m_param3 != 3) {
                                    this.m_preFastRun = true;
                                    this.m_currDir = n3;
                                    this.m_dribbleState = 1;
                                    this.m_fastrun = true;
                                    this.runOn(n3);
                                }
                            } else {
                                this.m_preDir = -1;
                                this.m_preState = -1;
                                if (s_radar == 4) {
                                    s_radar = 0;
                                    s_power = 0;
                                }
                                this.runOn(n3);
                            }
                        } else {
                            this.m_preDir = -1;
                            this.m_preState = -1;
                            if (s_radar == 4) {
                                s_radar = 0;
                                s_power = 0;
                            }
                            this.runOn(n3);
                        }
                        s_lastInputDir = n3;
                        return;
                    }
                    if (this.m_currState == 1) {
                        this.m_preDir = -1;
                        this.m_fast2Fast = false;
                        if (this == s_ballFastOwner) {
                            this.runOn(this.m_dirToBall);
                            this.m_fastrun = false;
                            this.m_dribbleState = 2;
                            if (this.m_preState == -1 && !Device.haveKeyHold(3840)) {
                                s_power = 6;
                                return;
                            }
                        } else {
                            if (s_radar == 0) {
                                if (s_lastInputDir == -1 || !this.m_withBall) {
                                    this.stand(false);
                                    this.m_dribbleState = 0;
                                    this.m_fastrun = false;
                                    return;
                                }
                                s_radar = 4;
                                s_power = 0;
                                this.runOn(s_lastInputDir);
                                this.m_fastrun = false;
                                this.m_dribbleState = 2;
                                return;
                            }
                            if (s_radar == 4) {
                                if (s_power < 10) {
                                    ++s_power;
                                    this.runOn(s_lastInputDir);
                                    return;
                                }
                                s_radar = 0;
                                s_lastInputDir = -1;
                                this.stand(false);
                                this.m_dribbleState = 0;
                                this.m_fastrun = false;
                                return;
                            }
                        }
                    } else if (this.m_currState == 0 && !this.m_withBall && !this.m_isBallReceiver && this.m_currDir != this.m_dirToBall) {
                        this.turn(-1);
                    }
                }
            }
        }
    }

    private void selectCenterPassPoint() {
        int n;
        int n2 = CPlayer.dirTo(this.m_myTeam.convertPos(135168) - this.m_posX, 0 - this.m_posY);
        int n3 = n = this.m_posY > 0 ? 0 : 4;
        if (!this.selectPassPoint(n2, 5)) {
            this.selectPassPoint(n, 2);
        }
        if (Device.s_aiMode == 6 && CTeam.s_newtutorialStep == 11) {
            CTeam.s_isTutorialHeadShoot = true;
        }
    }

    public final void getBall() {
        if (!(s_oneTwoPlayer[this.m_myTeam.m_ID] == null || s_oneTwoPlayer[this.m_myTeam.m_ID] != this && this.m_isBallReceiver)) {
            CPlayer.s_oneTwoPressed[this.m_myTeam.m_ID] = false;
            CPlayer.s_oneTwoPlayer[this.m_myTeam.m_ID] = null;
        }
        CTeam.s_throughReceiverID = -1;
        if (s_ballOwner != null) {
            CPlayer.s_ballOwner.m_withBall = false;
            s_ballLastOwner = s_ballOwner;
        }
        this.m_foolEndsTick = 0L;
        this.m_idea = -1;
        if (s_lastAsistPlayer != null && this.m_myTeam.m_ID != CPlayer.s_lastAsistPlayer.m_myTeam.m_ID) {
            s_lastAsistPlayer = null;
        }
        if (Device.s_aiMode == 6 && this.m_preState != 4) {
            CTeam.s_isTutorialShoot = false;
        }
        this.m_withBall = true;
        s_ballOwner = this;
        s_ctrWithBall = 0;
        if (s_ballFastOwner != null) {
            s_ballFastOwner = null;
            s_ctrWithBall = 3;
        }
        if (this.m_myTeam.m_type == 0) {
            this.setFocus();
        }
        CPlayer.clearBallReceivers();
        int n = 334848;
        CPlayer cPlayer = null;
        for (int i = 0; i < 11; ++i) {
            CPlayer cPlayer2 = CTeam.s_team0.m_players[i];
            if (i != 0 && this.m_myTeam.m_type == 1 && cPlayer2.m_court == 0 && (cPlayer == null || cPlayer2.m_disToBall < n)) {
                cPlayer = cPlayer2;
                n = cPlayer2.m_disToBall;
            }
            if (CTeam.s_kickPlayer == this && CTeam.s_matchState != 0) continue;
            cPlayer2.m_preDir = -1;
            cPlayer2.m_preState = -1;
            cPlayer2.m_idea = -1;
            cPlayer2.m_preFastRun = false;
            if (cPlayer2.m_doHumanWallJump) {
                cPlayer2.m_coachSetTacState = 0;
                cPlayer2.m_myTeam.m_haveNewOrder[cPlayer2.m_Number] = true;
                cPlayer2.m_doHumanWallJump = false;
            }
            cPlayer2 = CTeam.s_team1.m_players[i];
            CTeam.s_team1.m_players[i].m_preDir = -1;
            cPlayer2.m_preState = -1;
            cPlayer2.m_idea = -1;
            if (!cPlayer2.m_doHumanWallJump) continue;
            cPlayer2.m_coachSetTacState = 0;
            cPlayer2.m_myTeam.m_haveNewOrder[cPlayer2.m_Number] = true;
            cPlayer2.m_doHumanWallJump = false;
        }
        if (cPlayer != null) {
            cPlayer.setFocus();
        }
        if (s_potentialOffsidePlayer == this) {
            CTeam.s_offsidePlayer = this;
            CTeam.setMatchState(6, 1 - this.m_myTeam.m_ID, this.m_posX, this.m_posY);
            Device.increaseValueOfStatItem(this.m_myTeam.m_ID, 5);
            return;
        }
        s_potentialOffsidePlayer = null;
    }

    public final void loseBall() {
        if (CTeam.s_newtutorialStep == 40 && this.m_myTeam.m_ID == 1 && Device.haveKeyHold(2048)) {
            CTeam.s_taskFinish = true;
        }
        if (s_ballOwner == this) {
            s_lastPadDir = -1;
            if (this.m_Number == 0) {
                Actor.s_ball_heldbygk = false;
                Actor.s_ball_heldbyplayer = false;
            } else {
                Actor.s_ball_heldbyplayer = false;
            }
        }
        if (this.m_Number != 0) {
            s_ballLastPlayer = s_ballOwner;
        }
        this.m_withBall = false;
        s_ballLastOwner = s_ballOwner;
        s_ballOwner = null;
        s_ballFastOwner = null;
        s_ctrWithoutBall = 0;
        s_radar = 0;
    }

    public final void setBallReceiver() {
        if (!this.m_isBallReceiver) {
            if (s_ballReceiver[this.m_myTeam.m_ID] != null) {
                CPlayer.s_ballReceiver[this.m_myTeam.m_ID].m_isBallReceiver = false;
            }
            this.m_isBallReceiver = true;
            this.m_ballReceiverState = 1;
            if (s_ballReceiver[this.m_myTeam.m_ID] != this && CTeam.isPlayerOffside(this)) {
                s_potentialOffsidePlayer = this;
            }
            CPlayer.s_ballReceiver[this.m_myTeam.m_ID] = this;
            this.m_myTeam.m_specialDirectType = 0;
            this.m_dribbleState = 0;
            this.m_fastrun = false;
            this.m_canHead = true;
            if (this.m_myTeam.m_rcvUseNewPointingSystem) {
                int n = Device.random(0, 99);
                n = this.m_myTeam.m_ID == CTeam.s_rcvUseNewPointingSystemTeamID ? (s_ballLastOwner != null && CPlayer.s_ballLastOwner.m_Number == 0 || Device.s_aiMode == 6 && CTeam.s_newtutorialStep == 11 ? 0 : (n < 20 ? 3 : (n < 40 ? 4 : (n < 60 ? 2 : (n < 80 ? 1 : 0))))) : (s_ballLastOwner != null && (CPlayer.s_ballLastOwner.m_Number == 0 || s_ballLastOwner.myPosInAcrossingZone()) ? 0 : 0);
                this.m_myTeam.rcvSelectpoint(n);
                int n2 = CPlayer.dirTo(this.m_myTeam.m_rcvBallGoAndKickX - this.m_posX, this.m_myTeam.m_rcvBallGoAndKickY - this.m_posY);
                if (this.m_myTeam.m_type == 0 && CPlayer.dirDifference(this.m_currDir, n2) != 0) {
                    this.turn(n2);
                }
            }
        }
    }

    public static void clearBallReceivers() {
        if (s_ballReceiver[0] != null) {
            CPlayer.s_ballReceiver[0].m_isBallReceiver = false;
            CPlayer.s_ballReceiver[0].m_ballReceiverState = 0;
            CPlayer.s_ballReceiver[0] = null;
        }
        if (s_ballReceiver[1] != null) {
            CPlayer.s_ballReceiver[1].m_isBallReceiver = false;
            CPlayer.s_ballReceiver[1].m_ballReceiverState = 0;
            CPlayer.s_ballReceiver[1] = null;
        }
    }

    static int getRunFrames(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = (n >> 1) + 256;
        CPlayer.parseVector(n, n4 - n2, n5 - n3);
        int n8 = Device.screenDistance(s_vectorX, s_vectorY);
        if (n8 != 0) {
            int n9 = n * 365 >> 8;
            s_vectorX = s_vectorX * n9 / n8;
            s_vectorY = s_vectorY * n9 / n8;
            n7 = n7 * n9 / n8;
        }
        while (Device.fastDistance(n4 - n2, n5 - n3) > n7) {
            n2 += s_vectorX;
            n3 += s_vectorY;
            ++n6;
        }
        return n6;
    }

    private void updateBallReceiver(int n) {
        if (n != -1) {
            this.directTurn(n);
        }
        if (Device.s_aiMode == 6 && CTeam.s_newtutorialStep >= 33) {
            return;
        }
        switch (this.m_ballReceiverState) {
            case 1: {
                boolean bl = false;
                if (!this.m_myTeam.m_rcvUseNewPointingSystem) {
                    int n2 = Actor.s_football.m_destX;
                    int n3 = Actor.s_football.m_destY;
                    if ((Actor.s_ball_state == 1 || Actor.s_ball_state == 10) && this.m_myTeam.m_state == 1) {
                        this.m_myTeam.rcvSelectpoint(1);
                        n2 = this.m_myTeam.m_rcvGoAndKickX;
                        n3 = this.m_myTeam.m_rcvGoAndKickY;
                    }
                    CPlayer.getRunFrames(this.m_speed, this.m_posX, this.m_posY, Actor.s_football.m_destX, Actor.s_football.m_destY);
                    if (Actor.s_ballDestReached) {
                        if (Actor.s_ball_state != 0) {
                            this.runTo(Actor.s_football.m_destX, Actor.s_football.m_destY, true);
                        } else {
                            this.runTo(Actor.s_football.m_posX, Actor.s_football.m_posY, true);
                        }
                    } else {
                        this.runTo(n2, n3, false);
                    }
                    this.m_ballReceiverState = 2;
                    return;
                }
                int n4 = CPlayer.getRunFrames(this.m_speed, this.m_posX, this.m_posY, this.m_myTeam.m_rcvGoAndKickX, this.m_myTeam.m_rcvGoAndKickY) + this.m_myTeam.m_rcvAddedKeyFrame;
                if (n4 > this.m_myTeam.m_rcvFitFrameOff) {
                    n4 = CPlayer.getRunFrames(this.m_speedFast, this.m_posX, this.m_posY, this.m_myTeam.m_rcvGoAndKickX, this.m_myTeam.m_rcvGoAndKickY) + this.m_myTeam.m_rcvAddedKeyFrame;
                    bl = true;
                }
                if (n4 < this.m_myTeam.m_rcvFitFrameOff) {
                    --this.m_myTeam.m_rcvFitFrameOff;
                    return;
                }
                if (n4 == this.m_myTeam.m_rcvFitFrameOff) {
                    this.runTo(this.m_myTeam.m_rcvGoAndKickX, this.m_myTeam.m_rcvGoAndKickY, bl);
                } else {
                    this.runTo(Device.limit(Actor.s_football.m_destX, -135168, 135168), Device.limit(Actor.s_football.m_destY, -86016, 86016), true);
                    this.m_myTeam.m_rcvUseNewPointingSystem = false;
                    this.m_myTeam.m_specialDirectType = 0;
                }
                this.m_myTeam.m_rcvFitFrameOff = -1;
                this.m_ballReceiverState = 4;
                return;
            }
            case 2: {
                if (this.m_destReached) {
                    if (this.m_currDir != this.m_dirToBall && this.m_nextDir != this.m_dirToBall && !this.ballOverMeIn(4) && !this.canTrap()) {
                        this.turn(-1);
                    }
                    this.m_ballReceiverState = 3;
                    return;
                }
                if (!Actor.s_ballDestReached) break;
                if (Actor.s_ball_state != 0) {
                    this.runTo(Actor.s_football.m_destX, Actor.s_football.m_destY, true);
                    return;
                }
                this.runTo(Actor.s_football.m_posX, Actor.s_football.m_posY, true);
                return;
            }
            case 3: {
                if (!this.m_actionOver && !this.m_actionCycle) break;
                this.m_ballReceiverState = 4;
                return;
            }
            case 4: {
                if (Actor.s_ballDestReached) {
                    if (Actor.s_ball_state != 0 || Actor.s_ball_state == 6) {
                        this.runTo(Actor.s_football.m_destX, Actor.s_football.m_destY, true);
                        return;
                    }
                    this.runTo(Actor.s_football.m_posX, Actor.s_football.m_posY, true);
                    return;
                }
                if (!this.m_isFocus) break;
                if (Actor.s_ball_state == 6) {
                    this.runTo(Actor.s_football.m_posX, Actor.s_football.m_posY, true);
                    return;
                }
                if (Actor.s_ball_state != 0 || n == -1 || !CPlayer.dirIn3(n, this.m_dirToBall)) break;
                this.runTo(Actor.s_football.m_posX, Actor.s_football.m_posY, false);
            }
        }
    }

    private void setBehavior(int n) {
        int n2;
        this.m_behavior = n;
        this.m_actionCycle = this.m_behavior == 0 || this.m_behavior == 1 || this.m_behavior == 23 || this.m_behavior == 24 || this.m_behavior == 33 || this.m_behavior == 34 || this.m_behavior == 37 || this.m_behavior == 39 || this.m_behavior == 62 || this.m_behavior == 32;
        int n3 = 0;
        switch (n) {
            case 0: {
                if (this.m_Number == 0) {
                    n3 = 10;
                    break;
                }
                if (CTeam.s_matchState == 0) {
                    n3 = 0;
                    break;
                }
                if (this.m_myTeam.m_ID != CTeam.s_kickTeamID || this.m_Number != CTeam.s_kickPlayerID || CTeam.s_period < 5) break;
                n3 = CTeam.s_matchState == 3 ? 140 : 135;
                break;
            }
            case 1: 
            case 34: {
                n3 = 64;
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                if (!this.m_withBall) break;
                n3 = 55;
                break;
            }
            case 6: 
            case 7: {
                if (this.m_withBall) {
                    n3 = 59;
                    break;
                }
                n3 = 99;
                break;
            }
            case 8: 
            case 9: {
                n3 = 126;
                break;
            }
            case 29: 
            case 30: {
                if (this.m_curAbilityTech == 0) {
                    n3 = 20;
                    break;
                }
                if (this.m_curAbilityTech == 3) {
                    n3 = 30;
                    break;
                }
                n3 = 25;
                break;
            }
            case 10: {
                if (this.m_curAbilityTech == 0) {
                    n3 = 35;
                    break;
                }
                if (this.m_curAbilityTech == 3) {
                    n3 = 45;
                    break;
                }
                n3 = 40;
                break;
            }
            case 11: {
                if (this.m_myTeam.m_type == 0 && s_power >= 3) {
                    n3 = 156;
                    break;
                }
                if (s_oneTwoPlayer[this.m_myTeam.m_ID] != null && s_oneTwoPlayer[this.m_myTeam.m_ID] != this) {
                    n3 = 156;
                    break;
                }
                n3 = 15;
                break;
            }
            case 12: {
                n3 = 94;
                break;
            }
            case 13: {
                n3 = 74;
                break;
            }
            case 14: {
                n3 = 50;
                break;
            }
            case 15: {
                n3 = 89;
                break;
            }
            case 90: {
                n3 = 84;
                break;
            }
            case 16: {
                n3 = 79;
                break;
            }
            case 46: {
                n3 = 142;
                break;
            }
            case 17: {
                n3 = 121;
                break;
            }
            case 18: {
                if (this.m_outBallParam3 > 0) {
                    n3 = 161;
                    break;
                }
                n3 = 156;
                break;
            }
            case 19: 
            case 20: {
                n3 = 102;
                break;
            }
            case 21: 
            case 22: {
                n3 = 110;
                break;
            }
            case 25: 
            case 26: {
                n3 = 106;
                break;
            }
            case 27: 
            case 28: {
                n3 = 113;
                break;
            }
            case 23: {
                n3 = 10;
                break;
            }
            case 24: {
                n3 = 69;
                break;
            }
            case 31: {
                n3 = 116;
                break;
            }
            case 32: {
                n3 = 130;
                break;
            }
            case 102: {
                n3 = 0;
                break;
            }
            case 107: {
                if (this.m_withBall) {
                    n3 = 5;
                    break;
                }
                n3 = 116;
                break;
            }
            case 103: 
            case 104: {
                n3 = 21;
                break;
            }
            case 108: {
                n3 = 17;
                break;
            }
            case 109: {
                n3 = 19;
                break;
            }
            case 33: {
                n3 = 144;
                break;
            }
            case 110: {
                n3 = 25;
                break;
            }
            case 37: {
                n3 = 146;
                break;
            }
            case 38: {
                n3 = 151;
                break;
            }
            case 39: {
                n3 = 135;
                break;
            }
            case 41: {
                n3 = 182;
                break;
            }
            case 40: {
                n3 = 177;
                break;
            }
            case 47: {
                n3 = 153;
                break;
            }
            case 62: {
                if (this.m_preDir < 0) {
                    n3 = 193;
                    break;
                }
                n3 = 188;
                break;
            }
            case 53: {
                n3 = 166;
                break;
            }
            case 63: {
                n3 = 172;
                break;
            }
            case 64: {
                n3 = 183;
            }
        }
        if (this.m_Number == 0 && this != Actor.s_menuPlayer) {
            ASprite aSprite;
            if (this.m_withBall && (n == 0 || n == 1)) {
                Actor.s_ball_heldbygk = false;
            }
            if (this.m_anim != (aSprite = n > 0 && n < 100 ? ASprite.s_anims[0] : (n == 107 && !this.m_withBall ? ASprite.s_anims[0] : ASprite.s_anims[1]))) {
                this.m_mustChangeAction = true;
                this.m_anim = aSprite;
            }
        }
        boolean bl = (n2 = this.m_currDir - 1 & 7) > 4;
        boolean bl2 = true;
        switch (n) {
            case 0: {
                if (n3 == 140) {
                    if (this.m_posY > 0) {
                        bl = true;
                    } else {
                        bl = false;
                        n3 = 141;
                    }
                    n2 = 0;
                    break;
                }
                if (!bl) break;
                n2 = 8 - n2;
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 39: 
            case 40: 
            case 63: 
            case 90: 
            case 102: 
            case 107: {
                if (!bl) break;
                n2 = 8 - n2;
                break;
            }
            case 13: {
                if (Actor.s_football.m_vY < 0) {
                    if (n2 == 2 || n2 == 6) {
                        n2 = n2 == 2 ? 0 : 8;
                    } else if (n2 == 1 || n2 == 7) {
                        n2 ^= 2;
                    }
                } else if (Actor.s_football.m_vY > 0 && (n2 == 3 || n2 == 5)) {
                    n2 ^= 2;
                }
                if (!bl) break;
                n2 = 8 - n2;
                break;
            }
            case 62: {
                if (!bl) break;
                n3 = this.m_preDir < 0 ? 188 : 193;
                n2 = 8 - n2;
                break;
            }
            case 64: {
                n2 = n2 + 4 & 7;
                bl = n2 > 4;
                if (!bl) break;
                n2 = 8 - n2;
                break;
            }
            case 4: 
            case 9: 
            case 19: 
            case 25: {
                n2 >>= 1;
                bl = false;
                break;
            }
            case 5: 
            case 8: 
            case 20: 
            case 26: {
                n2 = 4 - (n2 >> 1) & 3;
                bl = true;
                break;
            }
            case 6: 
            case 7: 
            case 21: 
            case 22: 
            case 27: 
            case 28: {
                if (bl) {
                    n2 = 8 - n2 >> 1;
                    break;
                }
                n2 >>= 1;
                break;
            }
            case 103: {
                n2 /= 2;
                bl = false;
                break;
            }
            case 104: {
                n2 = 4 - (n2 >> 1) & 3;
                bl = true;
                break;
            }
            case 33: 
            case 38: 
            case 46: {
                boolean bl3 = bl = this.m_currDir > 4 || this.m_currDir == 0;
                if (this.m_currDir > 2 && this.m_currDir < 7) {
                    n2 = 1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 47: {
                boolean bl4 = bl = this.m_currDir > 0 && this.m_currDir < 5;
                if (this.m_currDir > 2 && this.m_currDir < 7) {
                    n2 = 0;
                    break;
                }
                n2 = 1;
                break;
            }
            case 41: {
                n2 = 0;
                bl = false;
                break;
            }
            case 108: 
            case 109: 
            case 110: {
                n2 = 0;
                if (!bl) break;
                ++n3;
                break;
            }
            case 100: 
            case 105: {
                n3 = this.m_posX > 0 ? 16 : 15;
                n2 = 0;
                bl = this.m_posX <= 0;
                break;
            }
            case 101: 
            case 106: {
                n3 = this.m_posX < 0 ? 15 : 16;
                n2 = 0;
                bl = this.m_posX >= 0;
                break;
            }
            default: {
                bl2 = false;
            }
        }
        if (bl2) {
            if (this.m_flipX != bl) {
                this.m_mustChangeAction = true;
            }
            this.m_flipX = bl;
            this.setAction(n3 + n2, this.m_mustChangeAction);
            this.m_mustChangeAction = false;
        }
    }

    private boolean posBehindMe(int n, int n2) {
        n -= this.m_posX;
        n2 -= this.m_posY;
        switch (this.m_currDir) {
            case 0: {
                return n2 > 0;
            }
            case 1: {
                return n2 > n;
            }
            case 2: {
                return n < 0;
            }
            case 3: {
                return n2 < -n;
            }
            case 4: {
                return n2 < 0;
            }
            case 5: {
                return n2 < n;
            }
            case 6: {
                return n > 0;
            }
            case 7: {
                return n2 > -n;
            }
        }
        return false;
    }

    public final boolean posClockwiseOfMe(int n, int n2, int n3) {
        n -= this.m_posX;
        n2 -= this.m_posY;
        switch (n3) {
            case 0: {
                return n > 0;
            }
            case 1: {
                return n2 > -n;
            }
            case 2: {
                return n2 > 0;
            }
            case 3: {
                return n2 > n;
            }
            case 4: {
                return n < 0;
            }
            case 5: {
                return n2 < -n;
            }
            case 6: {
                return n2 < 0;
            }
            case 7: {
                return n2 < n;
            }
        }
        return false;
    }

    public static int dirTo(int n, int n2) {
        if (n == 0) {
            if (n2 > 0) {
                return 4;
            }
            return 0;
        }
        if (n2 == 0) {
            if (n > 0) {
                return 2;
            }
            return 6;
        }
        int n3 = (n2 << 8) / n;
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n3 <= 106) {
            if (n > 0) {
                return 2;
            }
            return 6;
        }
        if (n3 >= 618) {
            if (n2 > 0) {
                return 4;
            }
            return 0;
        }
        if (n > 0) {
            if (n2 > 0) {
                return 3;
            }
            return 1;
        }
        if (n2 > 0) {
            return 5;
        }
        return 7;
    }

    public static int dirDifference(int n, int n2) {
        int n3 = n2 - n;
        if (n3 > 4) {
            return n3 - 7 - 1;
        }
        if (n3 < -3) {
            return n3 + 7 + 1;
        }
        return n3;
    }

    public static boolean dirIn3(int n, int n2) {
        int n3 = n2 - n;
        return n3 < 2 && n3 > -2 || n3 == 7 || n3 == -7;
    }

    private static boolean dirIn5(int n, int n2) {
        int n3 = n2 - n;
        return n3 < 3 && n3 > -3 || n3 > 5 || n3 < -5;
    }

    public static void parseVector(int n, int n2) {
        switch (n2) {
            case 0: {
                s_vectorX = 0;
                s_vectorY = -n;
                return;
            }
            case 1: {
                s_vectorX = n * 362 >> 9;
                s_vectorY = -s_vectorX;
                return;
            }
            case 2: {
                s_vectorX = n;
                s_vectorY = 0;
                return;
            }
            case 3: {
                s_vectorX = s_vectorY = n * 362 >> 9;
                return;
            }
            case 4: {
                s_vectorX = 0;
                s_vectorY = n;
                return;
            }
            case 5: {
                s_vectorY = n * 362 >> 9;
                s_vectorX = -s_vectorY;
                return;
            }
            case 6: {
                s_vectorX = -n;
                s_vectorY = 0;
                return;
            }
            case 7: {
                s_vectorY = s_vectorX = -(n * 362 >> 9);
            }
        }
    }

    public static void parseVector(int n, int n2, int n3) {
        int n4 = Device.fastDistance(n2, n3);
        if (n4 == 0) {
            s_vectorY = 0;
            s_vectorX = 0;
            return;
        }
        s_vectorX = n * n2 / n4;
        s_vectorY = n * n3 / n4;
    }

    private static void parseVector_screen(int n, int n2) {
        CPlayer.parseVector(n, n2);
        int n3 = n * 365 >> 8;
        int n4 = Device.screenDistance(s_vectorX, s_vectorY);
        if (n4 != 0) {
            s_vectorX = s_vectorX * n3 / n4;
            s_vectorY = s_vectorY * n3 / n4;
        }
    }

    public static int parseVector_screen(int n, int n2, int n3, int n4) {
        CPlayer.parseVector(n, n2, n3);
        int n5 = n * 365 >> 8;
        int n6 = Device.screenDistance(s_vectorX, s_vectorY);
        if (n6 != 0) {
            s_vectorX = s_vectorX * n5 / n6;
            s_vectorY = s_vectorY * n5 / n6;
            if (n4 != 0) {
                return n4 * n5 / n6;
            }
        }
        return 0;
    }

    private boolean myPosInAcrossingZone() {
        return (this.m_myTeam.m_leftSide ? this.m_posX >= 49152 : this.m_posX <= -49152) && (this.m_posY >= 22528 || this.m_posY <= -22528);
    }

    private static boolean isTurnBehavior(int n) {
        return n >= 2 && n <= 9;
    }

    private void setOneTwoPlayer() {
        CPlayer.s_oneTwoPlayer[this.m_myTeam.m_ID] = this;
        CPlayer.s_oneTwoStartPointX[this.m_myTeam.m_ID] = this.m_posX;
        this.m_startToRunFor12 = true;
        this.m_nextState = 1;
        this.m_currState = 1;
        this.m_actionOver = true;
        this.m_nextDir = this.m_myTeam.convertDir(2);
        this.m_currDir = this.m_myTeam.convertDir(2);
    }

    static {
        SHOOT_MIN_HALF_RANGE = new int[]{30, 40, 50, 58, 66, 74};
        s_lastPadTick = -1L;
        s_lastPadDir = -1;
        s_ballReceiver = new CPlayer[2];
        s_oneTwoPlayer = new CPlayer[2];
        s_oneTwoStartPointX = new int[2];
        s_oneTwoPressed = new boolean[2];
    }
}

