/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class ASpriteInstance {
    int _posX;
    int _posY;
    int _nOldX;
    int _nOldY;
    int _pos_ox;
    int _pos_oy;
    int _flags;
    static final int FLAG_LOOP_FOREVER = 65536;
    static final int FLAG_HIDDEN = 131072;
    static final int FLAG_PAUSED = 262144;
    static final int FLAG_STAY_AT_LAST_FRAME = 524288;
    ASprite _sprite;
    short _nCrtAnim;
    short _nCrtAFrame;
    short _nCrtTime;
    boolean _bValidRect;
    int[] _rect;
    byte _nInitialDelay;
    byte _nZOrder;
    byte _type;
    int[] _data;
    int[] _trajectory;
    byte _nMapping;
    static final boolean DRAW_DEBUG_FRAMES = false;
    static ASpriteInstance _parent;
    public static final int k_anim_end_type_hide_at_end = 0;
    public static final int k_anim_end_type_loop = 1;
    public static final int k_anim_end_type_stay_at_end = 2;
    public int m_iCurAnimEndType;
    static final byte TYPE_UNUSED = 0;
    static final byte TYPE_ANIM = 1;
    static final byte TYPE_SNOW_DOWN = 2;
    static final byte TYPE_SALUTE = 3;
    static final byte TYPE_STAR_EXPLODE = 4;
    public static final int k_star_max_stay_frame = 30;
    public static final int k_star_init_speed = 25600;
    public static final int k_star_init_speed_base = 6400;
    public static final int k_star_init_speed_base_2 = 19200;
    int m_iStarLastFrame;
    public static final int k_salute_init_speed = 46080;
    public static final int k_salute_init_speed_base = 11520;
    public static final int k_salute_init_speed_base_2 = 34560;
    public static final int k_salute_friction_coef = 179;
    public static final int k_salute_y_acc_speed = 128;
    int m_iHidePosY;
    public static final int k_snow_down_min_y_speed = 64;
    public static final int k_snow_down_max_y_speed = 1024;
    public static final int k_snow_down_max_x_acc_speed = 256;
    public static final int k_snow_down_max_x_acc_speed_half = 128;
    public static final int k_snow_down_max_x_speed = 1024;
    int m_iSpeedX;
    int m_iSpeedY;
    static final int GENERIC_OBJECT_STATE = 0;

    ASpriteInstance() {
    }

    ASpriteInstance(int spr, int posX, int posY) {
        this._posX = posX << 8;
        this._posY = posY << 8;
        this._type = 1;
        this._sprite = CGame._sprites[(byte)spr];
        this._rect = new int[4];
    }

    ASpriteInstance(ASprite spr, int posX, int posY) {
        this._posX = posX << 8;
        this._posY = posY << 8;
        this._type = 1;
        this._sprite = spr;
        this._rect = new int[4];
    }

    void SetType(byte type) {
        this._type = type;
        if (this._type == 2) {
            this.InitSnowDown();
            this.SetAnimEndType(1);
        } else if (this._type == 3) {
            this.InitSalute();
            this.SetAnimEndType(1);
        } else if (this._type == 4) {
            this.InitStarExplode();
            this.SetAnimEndType(1);
        }
    }

    int getPosX() {
        return this._posX >> 8;
    }

    int getPosY() {
        return this._posY >> 8;
    }

    void SetAnimEndType(int type) {
        switch (type) {
            case 0: {
                this.SetNoLoop();
                this.SetNoStayAtEnd();
                break;
            }
            case 1: {
                this.SetLoop();
                break;
            }
            case 2: {
                this.SetStayAtEnd();
            }
        }
        this.m_iCurAnimEndType = type;
    }

    void SetLoop() {
        this._flags |= 0x10000;
        this._flags &= 0xFFF7FFFF;
    }

    void SetNoLoop() {
        this._flags &= 0xFFFEFFFF;
    }

    void SetStayAtEnd() {
        this._flags |= 0x80000;
        this._flags &= 0xFFFEFFFF;
    }

    void SetNoStayAtEnd() {
        this._flags &= 0xFFF7FFFF;
    }

    boolean IsLoop() {
        return (this._flags & 0x10000) != 0;
    }

    void SetPos(int posX, int posY) {
        this._posX = posX << 8;
        this._posY = posY << 8;
    }

    void SetHide() {
        this._flags |= 0x20000;
    }

    void SetActive() {
        this._flags &= 0xFFFDFFFF;
    }

    void SetPause() {
        this._flags |= 0x40000;
    }

    void SetGoOn() {
        this._flags &= 0xFFFBFFFF;
    }

    boolean IsActive() {
        return (this._flags & 0x60000) == 0;
    }

    void SetInitialDelay(int nValue) {
        this._nInitialDelay = (byte)nValue;
    }

    void Update() {
        if (this._nInitialDelay > 0) {
            this._nInitialDelay = (byte)(this._nInitialDelay - 1);
            return;
        }
        if ((this._flags & 0x20000) != 0) {
            return;
        }
        if ((this._flags & 0x40000) != 0) {
            return;
        }
        this._nOldX = this._posX;
        this._nOldY = this._posY;
        switch (this._type) {
            case 1: {
                this.UpdateAnim();
                break;
            }
            case 2: {
                this.UpdateSnowDown();
                break;
            }
            case 3: {
                this.UpdateSalute();
                break;
            }
            case 4: {
                this.UpdateStarExplode();
            }
        }
    }

    void InitStarExplode() {
        int speed = 6400 + CGame.GetRand(19200);
        int angle = CGame.GetRand(360);
        this.m_iSpeedX = speed * CGame.getCos(angle) / 100;
        this.m_iSpeedY = -speed * CGame.getSin(angle) / 100;
        this.m_iStarLastFrame = CGame.GetRand(30);
    }

    void UpdateStarExplode() {
        if (this._sprite == null) {
            return;
        }
        if ((this._flags & 0x60000) != 0) {
            return;
        }
        int accX = -(this.m_iSpeedX * 179 >> 8);
        int accY = -(this.m_iSpeedY * 179 >> 8);
        this.m_iSpeedX += (accX += 128 - CGame.GetRand(256));
        this.m_iSpeedY += (accY += 128);
        this._posX += this.m_iSpeedX;
        this._posY += this.m_iSpeedY;
        if (this.m_iStarLastFrame-- <= 0) {
            this._flags |= 0x20000;
            return;
        }
        this.UpdateAnim();
    }

    void InitSalute() {
        int speed = 11520 + CGame.GetRand(34560);
        int angle = CGame.GetRand(180);
        this.m_iSpeedX = speed * CGame.getCos(angle) / 100;
        this.m_iSpeedY = -speed * CGame.getSin(angle) / 100;
        this.m_iHidePosY = this._posY;
    }

    void UpdateSalute() {
        if (this._sprite == null) {
            return;
        }
        if ((this._flags & 0x60000) != 0) {
            return;
        }
        int accX = -(this.m_iSpeedX * 179 >> 8);
        int accY = -(this.m_iSpeedY * 179 >> 8);
        this.m_iSpeedX += (accX += 128 - CGame.GetRand(256));
        this.m_iSpeedY += (accY += 128);
        this._posX += this.m_iSpeedX;
        this._posY += this.m_iSpeedY;
        if (this._posY > this.m_iHidePosY) {
            this._flags |= 0x20000;
        }
        this.UpdateAnim();
    }

    void InitSnowDown() {
        this._posX = CGame.GetRand(240) << 8;
        this._posY = CGame.GetRand(320) - 320 << 8;
        this.m_iSpeedX = 0;
        this.m_iSpeedY = 64 + CGame.GetRand(1024);
    }

    void UpdateSnowDown() {
        if (this._sprite == null) {
            return;
        }
        if ((this._flags & 0x60000) != 0) {
            return;
        }
        int acc = 128 - CGame.GetRand(256);
        this.m_iSpeedX += acc;
        this._posX += this.m_iSpeedX;
        this._posY += this.m_iSpeedY;
        if (this._posY > 81920) {
            this._flags |= 0x20000;
        }
        this.UpdateAnim();
    }

    void Paint(Graphics g) {
        if ((this._flags & 0x20000) != 0) {
            return;
        }
        switch (this._type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.PaintAnim(g);
            }
        }
    }

    void Paint(Graphics g, int x, int y) {
        int oldX = this._posX;
        int oldY = this._posY;
        this._posX = x << 8;
        this._posY = y << 8;
        this.Paint(g);
        this._posX = oldX;
        this._posY = oldY;
    }

    void SetObjState(int state) {
        this._data[0] = state;
    }

    void UpdateAnim() {
        this.UpdateSpriteAnim();
    }

    void PaintAnim(Graphics g) {
        this.PaintSprite(g);
    }

    void SetAnim(int id) {
        if (id != this._nCrtAnim) {
            this._nCrtAnim = (short)id;
            this._nCrtAFrame = 0;
            this._nCrtTime = 0;
            this._pos_ox = 0;
            this._pos_oy = 0;
            this._bValidRect = false;
        }
    }

    void ResetAnim() {
        this._nCrtAnim = 0;
        this._nCrtTime = 0;
        this._nCrtAFrame = 0;
    }

    void ResetCurAnim() {
        this._nCrtTime = 0;
        this._nCrtAFrame = 0;
        this._pos_ox = 0;
        this._pos_oy = 0;
    }

    void ApplyAnimOff() {
        this._posX -= this._pos_ox;
        this._posY -= this._pos_oy;
        int off = this._sprite._anims_af_start[this._nCrtAnim] + this._nCrtAFrame;
        this._pos_ox = (this._sprite._aframes_ox[off] << 8) * 1 / 1;
        if ((this._flags & 1) != 0) {
            this._pos_ox = -this._pos_ox;
        }
        this._pos_oy = (this._sprite._aframes_oy[off] << 8) * 1 / 1;
        if ((this._flags & 2) != 0) {
            this._pos_oy = -this._pos_oy;
        }
        this._posX += this._pos_ox;
        this._posY += this._pos_oy;
    }

    boolean IsAnimEnded() {
        if ((this._flags & 0x20000) != 0) {
            return true;
        }
        if ((this._flags & 0x10000) != 0) {
            return false;
        }
        if (this._nCrtAFrame != this._sprite.GetAFrames(this._nCrtAnim) - 1) {
            return false;
        }
        int time = this._sprite.GetAFrameTime(this._nCrtAnim, this._nCrtAFrame);
        return time == 0 || this._nCrtTime == time - 1;
    }

    void PaintSpriteOnScreen(Graphics g, int posX, int posY) {
        if (this._nCrtTime >= 0) {
            this._sprite.PaintAFrame(g, this._nCrtAnim, this._nCrtAFrame, posX, posY, this._flags & 0xFFFEFFFF, 0, 0);
        } else if (this._nCrtAnim >= 0) {
            this._sprite.PaintModule(g, this._nCrtAnim, posX, posY, this._flags & 0xFFFEFFFF);
        } else if (this._nCrtAFrame >= 0) {
            this._sprite.PaintFrame(g, this._nCrtAFrame, posX, posY, this._flags & 0xFFFEFFFF, 0, 0);
        }
    }

    void GetCurAnimFrameRect(int[] rc, int posX, int posY, int flags) {
        int f = this._sprite.GetAnimFrame(this._nCrtAnim, this._nCrtAFrame);
        this._sprite.GetFrameRect(rc, f, posX, posY, flags);
    }

    private void PaintSprite(Graphics g) {
        if (this._sprite == null) {
            return;
        }
        int posX = (this._posX + this._pos_ox >> 8) + 0;
        int posY = (this._posY + this._pos_oy >> 8) + 0;
        this.PaintSpriteOnScreen(g, posX, posY);
    }

    void UpdateSpriteAnim() {
        if (this._sprite == null) {
            return;
        }
        if ((this._flags & 0x60000) != 0) {
            return;
        }
        if (this._nCrtTime < 0) {
            return;
        }
        int time = this._sprite.GetAFrameTime(this._nCrtAnim, this._nCrtAFrame);
        if (time == 0) {
            return;
        }
        this._nCrtTime = (short)(this._nCrtTime + 1);
        if (time > this._nCrtTime) {
            return;
        }
        this._nCrtTime = 0;
        this._nCrtAFrame = (short)(this._nCrtAFrame + 1);
        this._bValidRect = false;
        if (this._nCrtAFrame >= this._sprite.GetAFrames(this._nCrtAnim)) {
            if ((0x80000 & this._flags) != 0) {
                this._nCrtTime = (short)(time - 1);
                this._nCrtAFrame = (short)(this._nCrtAFrame - 1);
            } else {
                this.ResetCurAnim();
                if (!this.IsLoop()) {
                    this.SetHide();
                }
            }
        }
    }

    int[] GetRect() {
        if (this._bValidRect) {
            return this._rect;
        }
        if (this._rect == null) {
            this._rect = new int[4];
        }
        if (this._sprite != null) {
            if (this._nCrtTime >= 0) {
                this._sprite.GetAFrameRect(this._rect, this._nCrtAnim, this._nCrtAFrame, this._posX >> 8, this._posY >> 8, this._flags & 0xFFFEFFFF, 0, 0);
            } else if (this._nCrtAnim >= 0) {
                this._sprite.GetModuleRect(this._rect, this._nCrtAnim, this._posX >> 8, this._posY >> 8, this._flags & 0xFFFEFFFF);
            } else if (this._nCrtAFrame >= 0) {
                this._sprite.GetFrameRect(this._rect, this._nCrtAFrame, this._posX >> 8, this._posY >> 8, this._flags & 0xFFFEFFFF, 0, 0);
            }
            this._rect[0] = (this._rect[0] << 8) - this._pos_ox;
            this._rect[1] = (this._rect[1] << 8) - this._pos_oy;
            this._rect[2] = (this._rect[2] << 8) - this._pos_ox;
            this._rect[3] = (this._rect[3] << 8) - this._pos_oy;
            this._bValidRect = true;
        }
        return this._rect;
    }

    static boolean IsRectCrossing(int[] rect1, int[] rect2) {
        if (rect1[0] > rect2[2]) {
            return false;
        }
        if (rect1[2] < rect2[0]) {
            return false;
        }
        if (rect1[1] > rect2[3]) {
            return false;
        }
        return rect1[3] >= rect2[1];
    }

    static boolean IsPointInRect(int x, int y, int[] rect) {
        if (x < rect[0]) {
            return false;
        }
        if (x > rect[2]) {
            return false;
        }
        if (y < rect[1]) {
            return false;
        }
        return y <= rect[3];
    }

    boolean IsNear(int x, int y, int tolerance) {
        if (Math.abs(this._posX - x) > tolerance) {
            return false;
        }
        return Math.abs(this._posY - y) <= tolerance;
    }
}

