/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class ASprite {
    static final int MAX_SPRITE_PALETTES = 17;
    static final int MAX_MODULE_MAPPINGS = 25;
    static final int MAX_TRANSFORMATION_FLAGS = 8;
    static final int TMP_BUFFER_SIZE = 16384;
    static final int PNG_BUFFER_SIZE = 4096;
    static final boolean DEBUG_bDbgS = false;
    static final boolean DEBUG_bErr = false;
    static final boolean DEBUG_bDbgVM = false;
    static final boolean DEBUG_bDbgO = false;
    static final boolean DEBUG_bEmu = false;
    static final boolean DEBUG_bDbgI = false;
    static final boolean DEBUG_bDbgModuleUsage = false;
    static final short BSPRITE_v003 = 991;
    static final int BS_MODULES = 1;
    static final int BS_MODULES_XY = 2;
    static final int BS_MODULES_IMG = 4;
    static final int BS_MODULES_WH_SHORT = 16;
    static final int BS_MODULES_XY_SHORT = 32;
    static final int BS_MODULES_USAGE = 64;
    static final int BS_FRAMES = 256;
    static final int BS_FM_OFF_SHORT = 1024;
    static final int BS_NFM_1_BYTE = 2048;
    static final int BS_SKIP_FRAME_RC = 4096;
    static final int BS_FRAME_COLL_RC = 8192;
    static final int BS_FM_PALETTE = 16384;
    static final int BS_FRAME_RECTS = 32768;
    static final int BS_ANIMS = 65536;
    static final int BS_NO_AF_START = 131072;
    static final int BS_AF_OFF_SHORT = 262144;
    static final int BS_NAF_1_BYTE = 524288;
    static final int BS_MODULE_IMAGES_FX = 0x800000;
    static final int BS_MODULE_IMAGES = 0x1000000;
    static final int BS_PNG_CRC = 0x2000000;
    static final int BS_KEEP_PAL = 0x4000000;
    static final int BS_TRANSP_FIRST = 0x8000000;
    static final int BS_TRANSP_LAST = 0x10000000;
    static final int BS_SINGLE_IMAGE = 0x20000000;
    static final int BS_MODULE_USAGE = 0x40000000;
    static final int BS_GIF_HEADER = Integer.MIN_VALUE;
    static final int BS_DEFAULT_DOJA = 65793;
    static final int BS_DEFAULT_MIDP2 = 0x1010101;
    static final int BS_DEFAULT_NOKIA = 0x1010101;
    static final int BS_DEFAULT_MIDP1 = 65795;
    static final int BS_DEFAULT_MIDP1b = 0x3010101;
    static final int BS_DEFAULT_MIDP1c = 536936707;
    static final short PIXEL_FORMAT_8888 = -30584;
    static final short PIXEL_FORMAT_4444 = 17476;
    static final short PIXEL_FORMAT_1555 = 21781;
    static final short PIXEL_FORMAT_0565 = 25861;
    static final short ENCODE_FORMAT_I2 = 512;
    static final short ENCODE_FORMAT_I4 = 1024;
    static final short ENCODE_FORMAT_I8 = 2048;
    static final short ENCODE_FORMAT_I16 = 5632;
    static final short ENCODE_FORMAT_I256 = 22018;
    static final short ENCODE_FORMAT_I64RLE = 25840;
    static final short ENCODE_FORMAT_I127RLE = 10225;
    static final short ENCODE_FORMAT_I256RLE = 22258;
    static final byte FLAG_FLIP_X = 1;
    static final byte FLAG_FLIP_Y = 2;
    static final byte FLAG_ROT_90 = 4;
    static final byte FLAG_USER0 = 16;
    static final byte FLAG_USER1 = 32;
    static final byte FLAG_HYPER_FM = 16;
    static final int FLAG_INDEX_EX_MASK = 192;
    static final int INDEX_MASK = 1023;
    static final int INDEX_EX_MASK = 768;
    static final int INDEX_EX_SHIFT = 2;
    static final byte FLAG_OFFSET_FM = 16;
    static final byte FLAG_OFFSET_AF = 32;
    static final int OPERATION_DRAW = 0;
    static final int OPERATION_COMPUTERECT = 1;
    static final int OPERATION_RECORD = 2;
    static final int OPERATION_MARK = 3;
    static boolean s_bCompressSpriteData;
    public int m_cacheType = 1;
    static int[] s_tempRect;
    private static Graphics _gTarget;
    static final int[] midp2_flags;
    static int record_index;
    static int record_frame;
    static int _text_w;
    static int _text_h;
    static int _text_lines;
    public static byte[] _map_char;
    private int _line_spacing = 0;
    byte _defaultInter;
    byte _spaceWidth;
    static short[] _sizes;
    static int _index1;
    static int _index2;
    int _old_pal;
    boolean _bRestoreCol = false;
    static char[] tokenArray;
    static int s_iBuffSize;
    static byte[] buff;
    public static final char[] k_newline_token_chars;
    int _nModules;
    short[] _modules_w;
    short[] _modules_h;
    byte[] _modules_usage;
    byte[] _frames_nfm;
    short[] _frames_fm_start;
    byte[] _frames_rc;
    byte[] _frames_col;
    byte[] _fmodules_id;
    short[] _fmodules_ox;
    short[] _fmodules_oy;
    byte[] _fmodules_pal;
    byte[] _fmodules_flags;
    int _anim_num;
    byte[] _anims_naf;
    short[] _anims_af_start;
    byte[] _aframes_frame;
    byte[] _aframes_time;
    short[] _aframes_ox;
    short[] _aframes_oy;
    byte[] _aframes_flags;
    short[][] _map;
    private int _cur_map;
    int _bs_flags;
    int[][] _pal8888;
    short[][] _pal;
    int _palettes;
    int _colors;
    private int _crt_pal;
    boolean _alpha;
    short _data_format;
    int _i64rle_color_mask;
    int _i64rle_color_bits;
    byte[] _modules_data;
    int[] _modules_data_off;
    Image[][] _modules_image;
    Image[] _main_image;
    int[] _PNG_packed_PLTE_CRC;
    int[] _PNG_packed_tRNS_CRC;
    int[] _PNG_packed_IHDR_CRC;
    int[] _PNG_packed_IDAT_ADLER;
    int[] _PNG_packed_IDAT_CRC;
    static int _images_count;
    static int _images_size;
    static int _operation;
    static int _rectX1;
    static int _rectY1;
    static int _rectX2;
    static int _rectY2;
    private static ASprite[] m_poolASprite;
    private static int[] m_poolModuleIndex;
    private static int[] m_poolPalIndex;
    private static int m_poolPos;

    void ArrayCopyToShort(byte[] src, int src_offset, short[] dest, int dest_offset, int length) {
        if (src == null || dest == null) {
            throw new NullPointerException();
        }
        if (src_offset < 0 || dest_offset < 0 || length < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = 0; i < length; ++i) {
            dest[i + dest_offset] = (short)((src[i * 2 + src_offset] & 0xFF) + ((src[i * 2 + 1 + src_offset] & 0xFF) << 8));
        }
    }

    void Load(byte[] file, int offset) {
        int nAFrames;
        int nFrames;
        int nFModules;
        int _data_flag = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8) + ((file[offset++] & 0xFF) << 16) + ((file[offset++] & 0xFF) << 24);
        this._nModules = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8);
        if (this._nModules > 0) {
            this._modules_w = new short[this._nModules];
            this._modules_h = new short[this._nModules];
            this.ArrayCopyToShort(file, offset, this._modules_w, 0, this._nModules);
            this.ArrayCopyToShort(file, offset += this._nModules * 2, this._modules_h, 0, this._nModules);
            offset += this._nModules * 2;
        }
        if ((nFModules = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8)) > 0) {
            this._fmodules_id = new byte[nFModules];
            this._fmodules_ox = new short[nFModules];
            this._fmodules_oy = new short[nFModules];
            this._fmodules_flags = new byte[nFModules];
            System.arraycopy(file, offset, this._fmodules_id, 0, nFModules);
            this.ArrayCopyToShort(file, offset += nFModules, this._fmodules_ox, 0, nFModules);
            this.ArrayCopyToShort(file, offset += nFModules * 2, this._fmodules_oy, 0, nFModules);
            System.arraycopy(file, offset += nFModules * 2, this._fmodules_flags, 0, nFModules);
            offset += nFModules;
        }
        if ((nFrames = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8)) > 0) {
            this._frames_nfm = new byte[nFrames];
            this._frames_fm_start = new short[nFrames];
            System.arraycopy(file, offset, this._frames_nfm, 0, nFrames);
            offset += nFrames;
            short frame_start = 0;
            for (int i = 0; i < nFrames; ++i) {
                this._frames_fm_start[i] = frame_start;
                frame_start = (short)(frame_start + (this._frames_nfm[i] & 0xFF));
            }
        }
        if ((nAFrames = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8)) > 0) {
            this._aframes_frame = new byte[nAFrames];
            this._aframes_time = new byte[nAFrames];
            this._aframes_ox = new short[nAFrames];
            this._aframes_oy = new short[nAFrames];
            this._aframes_flags = new byte[nAFrames];
            System.arraycopy(file, offset, this._aframes_frame, 0, nAFrames);
            System.arraycopy(file, offset += nAFrames, this._aframes_time, 0, nAFrames);
            this.ArrayCopyToShort(file, offset += nAFrames, this._aframes_ox, 0, nAFrames);
            this.ArrayCopyToShort(file, offset += nAFrames * 2, this._aframes_oy, 0, nAFrames);
            System.arraycopy(file, offset += nAFrames * 2, this._aframes_flags, 0, nAFrames);
            offset += nAFrames;
        }
        this._anim_num = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8);
        if (this._anim_num > 0) {
            this._anims_naf = new byte[this._anim_num];
            this._anims_af_start = new short[this._anim_num];
            System.arraycopy(file, offset, this._anims_naf, 0, this._anim_num);
            offset += this._anim_num;
            short af_start = 0;
            for (int i = 0; i < this._anim_num; ++i) {
                this._anims_af_start[i] = af_start;
                af_start = (short)(af_start + (this._anims_naf[i] & 0xFF));
            }
        }
        short bs_version = (short)((file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8));
        this._bs_flags = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8) + ((file[offset++] & 0xFF) << 16) + ((file[offset++] & 0xFF) << 24);
        if ((this._bs_flags & 0x1000000) != 0) {
            short _pixel_format = (short)((file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8));
            this._palettes = file[offset++] & 0xFF;
            this._colors = file[offset++] & 0xFF;
            if (this._colors == 0) {
                this._colors = 256;
            }
            this._pal = new short[17][];
            this._pal8888 = new int[17][];
            for (int p = 0; p < this._palettes; ++p) {
                int c;
                this._pal[p] = new short[this._colors];
                this._pal8888[p] = new int[this._colors];
                if (_pixel_format == -30584) {
                    for (c = 0; c < this._colors; ++c) {
                        int _8888 = file[offset++] & 0xFF;
                        _8888 += (file[offset++] & 0xFF) << 8;
                        _8888 += (file[offset++] & 0xFF) << 16;
                        if (((_8888 += (file[offset++] & 0xFF) << 24) & 0xFF000000) != -16777216) {
                            this._alpha = true;
                        }
                        int _4444 = (_8888 & 0xF0000000) >> 16 | (_8888 & 0xF00000) >> 12 | (_8888 & 0xF000) >> 8 | (_8888 & 0xF0) >> 4;
                        this._pal[p][c] = (short)(_4444 & 0xFFFF);
                        this._pal8888[p][c] = _8888;
                    }
                    continue;
                }
                if (_pixel_format == 17476) {
                    for (c = 0; c < this._colors; ++c) {
                        int _4444 = file[offset++] & 0xFF;
                        if (((_4444 += (file[offset++] & 0xFF) << 8) & 0xF000) != 61440) {
                            this._alpha = true;
                        }
                        int _8888 = (_4444 & 0xF000) << 16 | (_4444 & 0xF000) << 12 | (_4444 & 0xF00) << 12 | (_4444 & 0xF00) << 8 | (_4444 & 0xF0) << 8 | (_4444 & 0xF0) << 4 | (_4444 & 0xF) << 4 | _4444 & 0xF;
                        this._pal[p][c] = (short)(_4444 & 0xFFFF);
                        this._pal8888[p][c] = _8888;
                    }
                    continue;
                }
                if (_pixel_format != 25861) continue;
                for (c = 0; c < this._colors; ++c) {
                    int _0565 = file[offset++] & 0xFF;
                    int n = offset++;
                    int a = -16777216;
                    if ((_0565 += (file[n] & 0xFF) << 8) == 63519) {
                        a = 0;
                        this._alpha = true;
                    }
                    int _8888 = a | (_0565 & 0xF800) << 8 | (_0565 & 0x7E0) << 5 | (_0565 & 0x1F) << 3;
                    this._pal[p][c] = (short)((_8888 >> 24 & 0xF0) << 8 | (_8888 >> 16 & 0xF0) << 4 | _8888 >> 8 & 0xF0 | (_8888 & 0xF0) >> 4);
                    this._pal8888[p][c] = _8888;
                }
            }
            this._data_format = (short)((file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8));
            if (this._data_format == 25840 || s_bCompressSpriteData && this._data_format == 22018) {
                int clrs = this._colors - 1;
                this._i64rle_color_mask = 1;
                this._i64rle_color_bits = 0;
                while (clrs != 0) {
                    clrs >>= 1;
                    this._i64rle_color_mask <<= 1;
                    ++this._i64rle_color_bits;
                }
                --this._i64rle_color_mask;
            }
            if (this._nModules > 0) {
                int size;
                int m;
                this._modules_data_off = new int[this._nModules];
                int len = 0;
                int off = offset;
                for (m = 0; m < this._nModules; ++m) {
                    size = (file[off++] & 0xFF) + ((file[off++] & 0xFF) << 8);
                    this._modules_data_off[m] = len;
                    off += size;
                    len += size;
                }
                if (s_bCompressSpriteData && this._data_format == 22018 && this._i64rle_color_bits <= 6) {
                    int k;
                    int j;
                    int i;
                    int nI256PixelsCount = this._modules_data_off[this._nModules - 1] + this.GetModuleWidth(this._nModules - 1) * this.GetModuleHeight(this._nModules - 1);
                    int nMaxSameColorCount = ((0xFF & ~this._i64rle_color_mask) >> this._i64rle_color_bits) + 1;
                    int nI256Index = 0;
                    int nI64RLEIndex = 0;
                    byte clr = 0;
                    int nSameColorCount = 0;
                    byte nLastColor = 0;
                    for (i = 0; i < this._nModules; ++i) {
                        nSameColorCount = 1;
                        nLastColor = file[(offset += 2) + nI256Index++];
                        for (j = 0; j < this._modules_h[i]; ++j) {
                            for (k = 0; k < this._modules_w[i]; ++k) {
                                if (j == 0 && k == 0) continue;
                                if ((clr = file[offset + nI256Index++]) != nLastColor || nSameColorCount == nMaxSameColorCount) {
                                    ++nI64RLEIndex;
                                    nSameColorCount = 1;
                                    nLastColor = clr;
                                    continue;
                                }
                                ++nSameColorCount;
                            }
                        }
                        ++nI64RLEIndex;
                    }
                    byte[] I64RLE_buf = new byte[nI64RLEIndex];
                    nI256Index = 0;
                    nI64RLEIndex = 0;
                    offset -= 2 * this._nModules;
                    for (i = 0; i < this._nModules; ++i) {
                        nSameColorCount = 1;
                        nLastColor = file[(offset += 2) + nI256Index++];
                        for (j = 0; j < this._modules_h[i]; ++j) {
                            for (k = 0; k < this._modules_w[i]; ++k) {
                                if (j == 0 && k == 0) continue;
                                if ((clr = file[offset + nI256Index++]) != nLastColor || nSameColorCount == nMaxSameColorCount) {
                                    I64RLE_buf[nI64RLEIndex++] = (byte)((nSameColorCount - 1 << this._i64rle_color_bits | nLastColor) & 0xFF);
                                    nSameColorCount = 1;
                                    nLastColor = clr;
                                    continue;
                                }
                                ++nSameColorCount;
                            }
                        }
                        I64RLE_buf[nI64RLEIndex++] = (byte)((nSameColorCount - 1 << this._i64rle_color_bits | nLastColor) & 0xFF);
                        if (i == this._nModules - 1) continue;
                        this._modules_data_off[i + 1] = nI64RLEIndex;
                    }
                    this._modules_data = I64RLE_buf;
                    this._data_format = (short)25840;
                    offset += nI256PixelsCount;
                } else {
                    this._modules_data = new byte[len];
                    for (m = 0; m < this._nModules; ++m) {
                        size = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8);
                        System.arraycopy(file, offset, this._modules_data, this._modules_data_off[m], size);
                        offset += size;
                    }
                }
            }
        }
        System.gc();
    }

    void BuildCacheImages(int pal, int m1, int m2, int pal_copy) {
        if (this.m_cacheType == 1) {
            return;
        }
        if (this._nModules == 0) {
            return;
        }
        if (m2 == -1) {
            m2 = this._nModules - 1;
        }
        if (this._modules_image == null) {
            this._modules_image = new Image[this._palettes][];
        }
        if ((this._bs_flags & 0x1000000) != 0) {
            if (this._modules_image[pal] == null) {
                this._modules_image[pal] = new Image[this._nModules];
            }
            if (pal_copy >= 0) {
                for (int i = m1; i <= m2; ++i) {
                    this._modules_image[pal][i] = this._modules_image[pal_copy][i];
                }
            } else {
                int old_pal = this._crt_pal;
                this._crt_pal = pal;
                System.gc();
                for (int i = m1; i <= m2; ++i) {
                    int[] image_data;
                    if (this._modules_usage != null && this._modules_usage[i] == 0) continue;
                    int sizeX = this._modules_w[i] & 0xFFFF;
                    int sizeY = this._modules_h[i] & 0xFFFF;
                    if (sizeX <= 0 || sizeY <= 0 || (image_data = this.DecodeImage8888(i, 0)) == null) continue;
                    this._modules_image[pal][i] = Image.createRGBImage((int[])image_data, (int)sizeX, (int)sizeY, (boolean)this._alpha);
                    image_data = null;
                }
                System.gc();
                this._crt_pal = old_pal;
            }
        }
        System.gc();
    }

    void FreeCacheData() {
        if (this.m_cacheType == 1) {
            return;
        }
        this._modules_data = null;
        this._modules_data_off = null;
        System.gc();
    }

    void FreeSprite() {
        this._modules_w = null;
        this._modules_h = null;
        this._frames_nfm = null;
        this._frames_fm_start = null;
        this._fmodules_id = null;
        this._fmodules_ox = null;
        this._fmodules_oy = null;
        this._fmodules_flags = null;
        this._anims_naf = null;
        this._anims_af_start = null;
        this._aframes_frame = null;
        this._aframes_time = null;
        this._aframes_ox = null;
        this._aframes_oy = null;
        this._aframes_flags = null;
        this._pal = null;
        this._modules_data = null;
        this._modules_data_off = null;
    }

    int GetAFrameTime(int anim, int aframe) {
        return this._aframes_time[this._anims_af_start[anim] + aframe] & 0xFF;
    }

    int GetAFrames(int anim) {
        return this._anims_naf[anim] & 0xFF;
    }

    int GetFModules(int frame) {
        return this._frames_nfm[frame] & 0xFF;
    }

    int GetModuleWidth(int module) {
        return this._modules_w[module] & 0xFFFF;
    }

    int GetModuleHeight(int module) {
        return this._modules_h[module] & 0xFFFF;
    }

    int GetFrameWidth(int frame) {
        this.GetFrameRect(s_tempRect, frame, 0, 0, 0, 0, 0);
        int w = s_tempRect[2] - s_tempRect[0];
        return Math.abs(w);
    }

    int GetFrameHeight(int frame) {
        this.GetFrameRect(s_tempRect, frame, 0, 0, 0, 0, 0);
        int h = s_tempRect[3] - s_tempRect[1];
        return Math.abs(h);
    }

    int GetFrameModuleX(int frame, int fmodule) {
        return this._fmodules_ox[this._frames_fm_start[frame] + fmodule];
    }

    int GetFrameModuleY(int frame, int fmodule) {
        return this._fmodules_oy[this._frames_fm_start[frame] + fmodule];
    }

    int GetFrameModuleWidth(int frame, int fmodule) {
        int index = this._fmodules_id[this._frames_fm_start[frame] + fmodule] & 0xFF;
        return this._modules_w[index] & 0xFFFF;
    }

    int GetFrameModuleHeight(int frame, int fmodule) {
        int index = this._fmodules_id[this._frames_fm_start[frame] + fmodule] & 0xFF;
        return this._modules_h[index] & 0xFFFF;
    }

    int GetAnimFrame(int anim, int aframe) {
        return this._aframes_frame[this._anims_af_start[anim] + aframe] & 0xFF;
    }

    void GetAFrameRect(int[] rc, int anim, int aframe, int posX, int posY, int flags) {
        _rectX1 = 102400;
        _rectY1 = 102400;
        _rectX2 = -102400;
        _rectY2 = -102400;
        _operation = 1;
        this.PaintAFrame(anim, aframe, posX, posY, flags);
        _operation = 0;
        rc[0] = _rectX1;
        rc[1] = _rectY1;
        rc[2] = _rectX2;
        rc[3] = _rectY2;
    }

    void GetFrameRect(int[] rc, int frame, int posX, int posY, int flags) {
        _rectX1 = 0x1900000;
        _rectY1 = 0x1900000;
        _rectX2 = -26214400;
        _rectY2 = -26214400;
        _operation = 1;
        this.PaintFrame(frame, posX, posY, flags);
        _operation = 0;
        rc[0] = _rectX1;
        rc[1] = _rectY1;
        rc[2] = _rectX2;
        rc[3] = _rectY2;
    }

    void GetFModuleRect(int[] rc, int frame, int fmodule, int posX, int posY, int flags) {
        _rectX1 = 102400;
        _rectY1 = 102400;
        _rectX2 = -102400;
        _rectY2 = -102400;
        _operation = 1;
        this.PaintFModule(frame, fmodule, posX, posY, flags);
        _operation = 0;
        rc[0] = _rectX1;
        rc[1] = _rectY1;
        rc[2] = _rectX2;
        rc[3] = _rectY2;
    }

    void GetModuleRect(int[] rc, int module, int posX, int posY, int flags) {
        _rectX1 = 102400;
        _rectY1 = 102400;
        _rectX2 = -102400;
        _rectY2 = -102400;
        _operation = 1;
        this.PaintModule(module, posX, posY, flags);
        _operation = 0;
        rc[0] = _rectX1;
        rc[1] = _rectY1;
        rc[2] = _rectX2;
        rc[3] = _rectY2;
    }

    int CountFrameModules(int frame) {
        int count;
        int realcount = count = this.GetFModules(frame);
        for (int fmodule = 0; fmodule < count; ++fmodule) {
            int off = this._frames_fm_start[frame] + fmodule;
            int fm_flags = this._fmodules_flags[off] & 0xFF;
            int index = this._fmodules_id[off] & 0xFF;
            if ((fm_flags & 0x10) == 0) continue;
            realcount = realcount - 1 + this.CountFrameModules(index);
        }
        return realcount;
    }

    int GetNumFrames() {
        return this._frames_nfm.length;
    }

    static void SetGraphics(Graphics g) {
        _gTarget = g;
    }

    static Graphics GetGraphics() {
        return _gTarget;
    }

    void DrawString(Graphics g, String s, int x, int y, int anchor) {
        ASprite.SetGraphics(g);
        this.DrawString(s, x, y, anchor);
    }

    void DrawString(Graphics g, byte[] s, int x, int y, int anchor) {
        ASprite.SetGraphics(g);
        this.DrawString(s, x, y, anchor);
    }

    void DrawString(Graphics g, byte[] s, int x, int y, int text_width, int anchor) {
        ASprite.SetGraphics(g);
        this.DrawString(s, x, y, text_width, anchor);
    }

    void DrawPageB(Graphics g, byte[] s, short[] sizes, int x, int y, int startLine, int maxLines, int anchor) {
        ASprite.SetGraphics(g);
        this.DrawPageB(s, sizes, x, y, startLine, maxLines, anchor);
    }

    void DrawPage(Graphics g, String s, int x, int y, int anchor) {
        ASprite.SetGraphics(g);
        this.DrawPage(s, x, y, anchor);
    }

    void DrawPage(Graphics g, byte[] s, int x, int y, int anchor) {
        ASprite.SetGraphics(g);
        this.DrawPage(s, x, y, anchor);
    }

    void DrawPage(Graphics g, byte[] s, int x, int y, int anchor, int start, int end) {
        ASprite.SetGraphics(g);
        this.DrawPage(s, x, y, anchor, start, end);
    }

    void PaintAFrame(Graphics g, int anim, int aframe, int posX, int posY, int flags, int hx, int hy) {
        ASprite.SetGraphics(g);
        this.PaintAFrame(anim, aframe, posX, posY, flags);
    }

    void PaintFrame(Graphics g, int frame, int posX, int posY, int flags, int hx, int hy) {
        ASprite.SetGraphics(g);
        this.PaintFrame(frame, posX, posY, flags);
    }

    void PaintModule(Graphics g, int module, int posX, int posY, int flags) {
        ASprite.SetGraphics(g);
        this.PaintModule(module, posX, posY, flags);
    }

    void GetAFrameRect(int[] rc, int anim, int aframe, int posX, int posY, int flags, int hx, int hy) {
        this.GetAFrameRect(rc, anim, aframe, posX, posY, flags);
    }

    void GetFrameRect(int[] rc, int frame, int posX, int posY, int flags, int hx, int hy) {
        this.GetFrameRect(rc, frame, posX, posY, flags);
    }

    void PaintAFrame(int anim, int aframe, int posX, int posY, int flags) {
        int off = this._anims_af_start[anim] + aframe;
        int frame = this._aframes_frame[off] & 0xFF;
        frame |= (this._aframes_flags[off] & 0xC0) << 2;
        if ((flags & 4) != 0) {
            posX = (flags & 1) != 0 ? (posX -= this._aframes_ox[off]) : (posX += this._aframes_ox[off]);
            posY = (flags & 2) != 0 ? (posY -= this._aframes_oy[off]) : (posY += this._aframes_oy[off]);
        } else {
            posX = (flags & 1) != 0 ? (posX -= this._aframes_ox[off]) : (posX += this._aframes_ox[off]);
            posY = (flags & 2) != 0 ? (posY -= this._aframes_oy[off]) : (posY += this._aframes_oy[off]);
        }
        this.PaintFrame(frame, posX, posY, flags ^ this._aframes_flags[off] & 0xF);
    }

    void PaintFrame(int frame, int posX, int posY, int flags) {
        if (this._crt_pal >= this._palettes && _operation == 0) {
            return;
        }
        int nFModules = this._frames_nfm[frame] & 0xFF;
        for (int fmodule = 0; fmodule < nFModules; ++fmodule) {
            this.PaintFModule(frame, fmodule, posX, posY, flags);
        }
    }

    void PaintFModule(int frame, int fmodule, int posX, int posY, int flags) {
        int off = this._frames_fm_start[frame] + fmodule;
        int fm_flags = this._fmodules_flags[off] & 0xFF;
        int index = this._fmodules_id[off] & 0xFF;
        index |= (fm_flags & 0xC0) << 2;
        if ((flags & 4) != 0) {
            if ((fm_flags & 0x10) != 0) {
                posY = (flags & 1) != 0 ? (posY -= this._fmodules_ox[off]) : (posY += this._fmodules_ox[off]);
                posX = (flags & 2) != 0 ? (posX -= this._fmodules_oy[off]) : (posX += this._fmodules_oy[off]);
            } else {
                posY = (flags & 1) != 0 ? (posY -= this._fmodules_ox[off] + (this._modules_w[index] & 0xFFFF)) : (posY += this._fmodules_ox[off]);
                posX = (flags & 2) != 0 ? (posX -= this._fmodules_oy[off] + (this._modules_h[index] & 0xFFFF)) : (posX += this._fmodules_oy[off]);
            }
        } else if ((fm_flags & 0x10) != 0) {
            posX = (flags & 1) != 0 ? (posX -= this._fmodules_ox[off]) : (posX += this._fmodules_ox[off]);
            posY = (flags & 2) != 0 ? (posY -= this._fmodules_oy[off]) : (posY += this._fmodules_oy[off]);
        } else {
            posX = (flags & 1) != 0 ? (posX -= this._fmodules_ox[off] + (this._modules_w[index] & 0xFFFF)) : (posX += this._fmodules_ox[off]);
            posY = (flags & 2) != 0 ? (posY -= this._fmodules_oy[off] + (this._modules_h[index] & 0xFFFF)) : (posY += this._fmodules_oy[off]);
        }
        if ((fm_flags & 0x10) != 0) {
            this.PaintFrame(index, posX, posY, flags ^ fm_flags & 0xF);
        } else {
            this.PaintModule(index, posX, posY, flags ^ fm_flags & 0xF);
        }
    }

    void PaintModule(int module, int posX, int posY, int flags) {
        if (_operation == 3) {
            int n = module;
            this._modules_usage[n] = (byte)(this._modules_usage[n] | 1 << (flags & 7));
            return;
        }
        int sizeX = this._modules_w[module] & 0xFFFF;
        int sizeY = this._modules_h[module] & 0xFFFF;
        if (sizeX <= 0 || sizeY <= 0) {
            return;
        }
        if (_operation == 1) {
            if (posX < _rectX1) {
                _rectX1 = posX;
            }
            if (posY < _rectY1) {
                _rectY1 = posY;
            }
            if (posX + sizeX > _rectX2) {
                _rectX2 = posX + sizeX;
            }
            if (posY + sizeY > _rectY2) {
                _rectY2 = posY + sizeY;
            }
            return;
        }
        if (_operation == 0) {
            int cx = _gTarget.getClipX();
            int cy = _gTarget.getClipY();
            int cw = _gTarget.getClipWidth();
            int ch = _gTarget.getClipHeight();
            if (posX + sizeX < cx || posY + sizeY < cy || posX >= cx + cw || posY >= cy + ch) {
                return;
            }
        }
        Image img = null;
        if (this._modules_image != null && this._modules_image[this._crt_pal] != null) {
            img = this._modules_image[this._crt_pal][module];
        }
        switch (_operation) {
            case 0: {
                if (img != null) {
                    _gTarget.drawRegion(img, 0, 0, sizeX, sizeY, midp2_flags[flags & 7], posX, posY, 0);
                    break;
                }
                int[] image_data = null;
                image_data = this.DecodeImage8888(module, 0);
                if (image_data == null) {
                    System.out.println("\nnull image_data");
                    return;
                }
                img = Image.createRGBImage((int[])image_data, (int)sizeX, (int)sizeY, (boolean)this._alpha);
                this.putIntoPool(img, this._crt_pal, module);
                _gTarget.drawRegion(img, 0, 0, sizeX, sizeY, midp2_flags[flags & 7], posX, posY, 0);
            }
        }
    }

    int[] DecodeImage8888(int module, int flags) {
        int[] img_data;
        block17: {
            int[] pal;
            int ds;
            int di;
            int si;
            byte[] image;
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        if (this._modules_data == null || this._modules_data_off == null) {
                                            return null;
                                        }
                                        int sizeX = this._modules_w[module] & 0xFFFF;
                                        int sizeY = this._modules_h[module] & 0xFFFF;
                                        image = this._modules_data;
                                        si = this._modules_data_off[module];
                                        di = 0;
                                        ds = sizeX * sizeY;
                                        img_data = new int[ds + 7];
                                        pal = this._pal8888[this._crt_pal];
                                        if (pal == null) {
                                            return null;
                                        }
                                        if (this._data_format != 25840) break block18;
                                        while (di < ds) {
                                            int c = image[si++] & 0xFF;
                                            int clr = pal[c & this._i64rle_color_mask];
                                            c >>= this._i64rle_color_bits;
                                            while (c-- >= 0) {
                                                img_data[di++] = clr;
                                            }
                                        }
                                        break block17;
                                    }
                                    if (this._data_format != 10225) break block19;
                                    while (di < ds) {
                                        int c;
                                        if ((c = image[si++] & 0xFF) > 127) {
                                            int c2 = image[si++] & 0xFF;
                                            int clr = pal[c2];
                                            c -= 128;
                                            while (c-- > 0) {
                                                img_data[di++] = clr;
                                            }
                                            continue;
                                        }
                                        img_data[di++] = pal[c];
                                    }
                                    break block17;
                                }
                                if (this._data_format != 22258) break block20;
                                while (di < ds) {
                                    int c;
                                    if ((c = image[si++] & 0xFF) > 127) {
                                        c -= 128;
                                        while (c-- > 0) {
                                            img_data[di++] = pal[image[si++] & 0xFF];
                                        }
                                        continue;
                                    }
                                    int clr = pal[image[si++] & 0xFF];
                                    while (c-- > 0) {
                                        img_data[di++] = clr;
                                    }
                                }
                                break block17;
                            }
                            if (this._data_format != 5632) break block21;
                            while (di < ds) {
                                img_data[di++] = pal[image[si] >> 4 & 0xF];
                                img_data[di++] = pal[image[si] & 0xF];
                                ++si;
                            }
                            break block17;
                        }
                        if (this._data_format != 2048) break block22;
                        while (di < ds) {
                            img_data[di++] = pal[image[si] >> 5 & 7];
                            img_data[di++] = pal[image[si] >> 2 & 7];
                            if (di >= ds) break block17;
                            img_data[di++] = pal[image[si] << 1 & 6 | image[++si] >> 7 & 1];
                            img_data[di++] = pal[image[si] >> 4 & 7];
                            img_data[di++] = pal[image[si] >> 1 & 7];
                            if (di < ds) {
                                img_data[di++] = pal[image[si] << 2 & 4 | image[++si] >> 6 & 3];
                                img_data[di++] = pal[image[si] >> 3 & 7];
                                img_data[di++] = pal[image[si] & 7];
                                ++si;
                                continue;
                            }
                            break block17;
                        }
                        break block17;
                    }
                    if (this._data_format != 1024) break block23;
                    while (di < ds) {
                        img_data[di++] = pal[image[si] >> 6 & 3];
                        img_data[di++] = pal[image[si] >> 4 & 3];
                        img_data[di++] = pal[image[si] >> 2 & 3];
                        img_data[di++] = pal[image[si] & 3];
                        ++si;
                    }
                    break block17;
                }
                if (this._data_format != 512) break block24;
                while (di < ds) {
                    img_data[di++] = pal[image[si] >> 7 & 1];
                    img_data[di++] = pal[image[si] >> 6 & 1];
                    img_data[di++] = pal[image[si] >> 5 & 1];
                    img_data[di++] = pal[image[si] >> 4 & 1];
                    img_data[di++] = pal[image[si] >> 3 & 1];
                    img_data[di++] = pal[image[si] >> 2 & 1];
                    img_data[di++] = pal[image[si] >> 1 & 1];
                    img_data[di++] = pal[image[si] & 1];
                    ++si;
                }
                break block17;
            }
            if (this._data_format != 22018) break block17;
            while (di < ds) {
                img_data[di++] = pal[image[si++] & 0xFF];
            }
        }
        return img_data;
    }

    private void DRAW_STRINGS_SYSTEM___() {
    }

    int GetLineSpacing() {
        return this._line_spacing;
    }

    void SetLineSpacing(int spacing) {
        this._line_spacing = spacing;
    }

    void SetLineSpacingToDefault() {
        this._line_spacing = (this._modules_h[0] & 0xFFFF) >> 1;
    }

    int GetFontSpaceWidth() {
        return this._modules_w[0] & 0xFFFF;
    }

    int GetFontHeight() {
        return this._modules_h[0] & 0xFFFF;
    }

    int GetFontWidth(int charId) {
        return this._modules_w[charId] & 0xFFFF;
    }

    void SetModuleInterval(int inter) {
        this._fmodules_ox[0] = (byte)inter;
    }

    void ResetModuleInterval() {
        this._fmodules_ox[0] = this._defaultInter;
    }

    void SetSpace(int w) {
        this._spaceWidth = (byte)w;
    }

    short[] WraptextB(String s, int width) {
        return this.WraptextB(s.getBytes(), width);
    }

    short[] WraptextB(byte[] s, int width) {
        int i;
        int str_len = s.length;
        int strLines = str_len * (this._modules_w[1] & 0xFFFF) / width;
        int lineSize = 0;
        int cnt = 1;
        int lastSpacePos = 0;
        int distFromLastSpacePos = 0;
        boolean bSpaceFound = false;
        int lines = 0;
        for (i = 0; i < str_len; ++i) {
            if (s[i] != 10 && s[i] != 124) continue;
            ++lines;
        }
        for (i = 0; i < str_len; ++i) {
            int m;
            int c = s[i] & 0xFF;
            if (c == 32) {
                lineSize = (short)(lineSize + (this.GetFrameWidth(0) + this._fmodules_ox[0]));
                lastSpacePos = i;
                distFromLastSpacePos = 0;
                bSpaceFound = true;
                if (lineSize <= width) continue;
                bSpaceFound = false;
                for (int pos = lastSpacePos; pos >= 0 && (s[pos] & 0xFF) == 32; --pos) {
                    lineSize = (short)(lineSize - (this.GetFrameWidth(0) + this._fmodules_ox[0]));
                }
                while (lastSpacePos < str_len && (s[lastSpacePos] & 0xFF) == 32) {
                    lastSpacePos = (short)(lastSpacePos + 1);
                }
                i = lastSpacePos = (int)((short)(lastSpacePos - 1));
                int n = cnt;
                cnt = (short)(cnt + 1);
                ASprite._sizes[n] = (short)(lastSpacePos + 1);
                int n2 = cnt;
                cnt = (short)(cnt + 1);
                ASprite._sizes[n2] = (short)(lineSize - distFromLastSpacePos);
                lineSize = 0;
                continue;
            }
            if (c == 10 || c == 124) {
                int n = cnt;
                cnt = (short)(cnt + 1);
                ASprite._sizes[n] = (short)i;
                int n3 = cnt;
                cnt = (short)(cnt + 1);
                ASprite._sizes[n3] = lineSize;
                lineSize = 0;
                distFromLastSpacePos = 0;
                continue;
            }
            if (c < 32) {
                if (c == 1) {
                    ++i;
                    continue;
                }
                if (c != 2) continue;
                c = s[++i] & 0xFF;
            } else {
                c = _map_char[c] & 0xFF;
            }
            if (c >= this.GetFModules(0)) {
                c = 0;
            }
            if ((m = this._fmodules_id[c] & 0xFF) >= this._nModules) {
                m = 0;
                c = 0;
            }
            int charSize = m == 0 ? (this._modules_w[0] & 0xFFFF) + this._fmodules_ox[0] : (this._modules_w[m] & 0xFFFF) + this._fmodules_ox[c] + this._fmodules_ox[0];
            distFromLastSpacePos = (short)(distFromLastSpacePos + charSize);
            if ((lineSize = (int)((short)(lineSize + charSize))) <= width || !bSpaceFound) continue;
            bSpaceFound = false;
            for (int pos = lastSpacePos; pos >= 0 && (s[pos] & 0xFF) == 32; --pos) {
                lineSize = (short)(lineSize + (this.GetFrameWidth(0) + this._fmodules_ox[0]));
            }
            int n = cnt;
            cnt = (short)(cnt + 1);
            ASprite._sizes[n] = (short)(lastSpacePos + 1);
            int n4 = cnt;
            cnt = (short)(cnt + 1);
            ASprite._sizes[n4] = (short)(lineSize - distFromLastSpacePos);
            lineSize = 0;
            i = lastSpacePos;
        }
        if (lineSize != 0) {
            int n = cnt;
            cnt = (short)(cnt + 1);
            ASprite._sizes[n] = (short)str_len;
            int n5 = cnt;
            cnt = (short)(cnt + 1);
            ASprite._sizes[n5] = lineSize;
        }
        ASprite._sizes[0] = (short)(cnt / 2);
        return _sizes;
    }

    void DrawPageB(String s, short[] sizes, int x, int y, int startLine, int maxLines, int anchor) {
        this.DrawPageB(s.getBytes(), sizes, x, y, startLine, maxLines, anchor);
    }

    void DrawPageB(byte[] s, short[] sizes, int x, int y, int startLine, int maxLines, int anchor) {
        short lines = sizes[0];
        if (maxLines < 0 || maxLines > lines - startLine) {
            maxLines = lines - startLine;
        }
        int maxchar = this._modules_h[0] & 0xFFFF;
        int th = this.GetLineSpacing() + maxchar;
        if ((anchor & 0x20) != 0) {
            y -= th * (maxLines - 1);
        } else if ((anchor & 2) != 0) {
            y -= th * (maxLines - 1) >> 1;
        }
        this._old_pal = this._crt_pal;
        int k = 0;
        int j = startLine;
        while (k < maxLines) {
            _index1 = j > 0 ? sizes[(j - 1) * 2 + 1] : 0;
            _index2 = sizes[j * 2 + 1];
            if (s[_index1] == 10 || s[_index1] == 124) {
                ++_index1;
            }
            int xx = x;
            int yy = y + k * th;
            if ((anchor & 0x2B) != 0) {
                if ((anchor & 8) != 0) {
                    xx -= sizes[(j + 1) * 2];
                } else if ((anchor & 1) != 0) {
                    xx -= sizes[(j + 1) * 2] >> 1;
                }
                if ((anchor & 0x20) != 0) {
                    yy -= this._modules_h[1] & 0xFFFF;
                } else if ((anchor & 2) != 0) {
                    yy -= (this._modules_h[1] & 0xFFFF) >> 1;
                }
            }
            this.DrawString(s, xx, yy, 0);
            ++k;
            ++j;
        }
        _index1 = -1;
        _index2 = -1;
        this._crt_pal = this._old_pal;
    }

    static void SetSubString(int i1, int i2) {
        _index1 = i1;
        _index2 = i2;
    }

    static byte[] GetStringBytes(String s) {
        try {
            return s.getBytes("ISO-8859-1");
        }
        catch (Exception exception) {
            return null;
        }
    }

    void UpdateStringSize(String s) {
        this.UpdateStringSize(ASprite.GetStringBytes(s));
    }

    void UpdateStringSize(byte[] s) {
        _text_w = 0;
        _text_h = this._modules_h[0] & 0xFFFF;
        int tw = 0;
        int index1 = _index1 >= 0 ? _index1 : 0;
        int index2 = _index2 >= 0 ? _index2 : s.length;
        for (int i = index1; i < index2; ++i) {
            int c = s[i] & 0xFF;
            if (c == 32) {
                tw += this.GetFrameWidth(0) + this._fmodules_ox[0];
                continue;
            }
            if (c == 10 || c == 124) {
                if (tw > _text_w) {
                    _text_w = tw;
                }
                tw = 0;
                _text_h += this._line_spacing + (this._modules_h[0] & 0xFFFF);
                continue;
            }
            if (c == 94) {
                ++i;
                continue;
            }
            if (c < 32) {
                if (c == 1) {
                    ++i;
                    continue;
                }
                if (c != 2) continue;
                c = s[++i] & 0xFF;
            } else if (c > 32) {
                c = _map_char[c] & 0xFF;
            }
            int m = this._fmodules_id[c] & 0xFF;
            tw += this.GetFrameWidth(c) + this._fmodules_ox[0];
        }
        if (tw > _text_w) {
            _text_w = tw;
        }
        if (_text_w > 0) {
            _text_w -= this._fmodules_ox[0];
        }
    }

    void DrawString(byte[] str, int x, int y, int text_width, int anchor) {
        int i;
        int nrWord = 0;
        int tw = 0;
        int spaceBetweenWords = 0;
        for (i = 0; i < str.length - 1; ++i) {
            if (str[i] == 32 || str[i] == 9) {
                if (str[i + 1] == 32 || str[i + 1] == 9 || str[i + 1] == 10) continue;
                ++nrWord;
                continue;
            }
            if (i != 0 || str[i] == 32) continue;
            ++nrWord;
        }
        for (i = 0; i < str.length - 1; ++i) {
            int c = str[i] & 0xFF;
            if (str[i] <= 32) continue;
            if (str[i + 1] == 32) {
                tw += this._modules_w[c - 32] & 0xFFFF;
                continue;
            }
            tw += (this._modules_w[c - 32] & 0xFFFF) + this._fmodules_ox[0];
        }
        if ((str[str.length - 1] & 0xFF) > 32) {
            tw += this._modules_w[str[str.length - 1] - 32] & 0xFFFF;
        }
        if (nrWord != 0) {
            spaceBetweenWords = (text_width - tw << 4) / nrWord >> 4;
        }
        int accuracy = text_width - nrWord * spaceBetweenWords - tw;
        boolean restorecol = this._bRestoreCol;
        int xx = x;
        int yy = y;
        boolean bIsNewWord = true;
        if (restorecol) {
            this._old_pal = this._crt_pal;
        }
        int index1 = _index1 >= 0 ? _index1 : 0;
        int index2 = _index2 >= 0 ? _index2 : str.length;
        for (i = index1; i < index2; ++i) {
            int c = str[i] & 0xFF;
            if (c == 32 && bIsNewWord) {
                xx += spaceBetweenWords;
                bIsNewWord = false;
                if (accuracy <= 0) continue;
                ++xx;
                --accuracy;
                continue;
            }
            if (c == 10 || c == 124) {
                xx = x;
                yy += this._line_spacing + (this._modules_h[0] & 0xFFFF);
                continue;
            }
            if (c == 94) {
                if (str[++i] == 126) continue;
                this._crt_pal = str[i] - 48;
                continue;
            }
            if (c < 32) {
                if (c == 1) {
                    int pal;
                    if ((pal = str[++i] & 0xFF) == 255) {
                        this._crt_pal = this._old_pal;
                        continue;
                    }
                    if (pal >= this._palettes) continue;
                    this._crt_pal = pal;
                    continue;
                }
                if (c != 2) continue;
                c = str[++i] & 0xFF;
            } else if (c > 32) {
                c = _map_char[c] & 0xFF;
            }
            int m = this._fmodules_id[c] & 0xFF;
            this.PaintFrame(c, xx, yy, 0);
            xx += this.GetFrameWidth(c) + this._fmodules_ox[0];
            if (i <= 0 || str[i - 1] != 32 || str[i] == 32 || bIsNewWord) continue;
            bIsNewWord = true;
        }
        if (restorecol) {
            this._crt_pal = this._old_pal;
        }
    }

    void DrawString(int strid, int x, int y, int anchor) {
        this.DrawString(CGame.GetString(strid), x, y, anchor);
    }

    void DrawString(String s, int x, int y, int anchor) {
        this.DrawString(ASprite.GetStringBytes(s), x, y, anchor);
    }

    void DrawString(byte[] s, int x, int y, int anchor) {
        boolean restorecol = this._bRestoreCol;
        if ((anchor & 0x2B) != 0) {
            this.UpdateStringSize(s);
            if ((anchor & 8) != 0) {
                x -= _text_w;
            } else if ((anchor & 1) != 0) {
                x -= _text_w >> 1;
            }
            if ((anchor & 0x20) != 0) {
                y -= _text_h;
            } else if ((anchor & 2) != 0) {
                y -= _text_h >> 1;
            }
        }
        int xx = x;
        int yy = y;
        if (restorecol) {
            this._old_pal = this._crt_pal;
        }
        int index1 = _index1 >= 0 ? _index1 : 0;
        int index2 = _index2 >= 0 ? _index2 : s.length;
        for (int i = index1; i < index2; ++i) {
            int c = s[i] & 0xFF;
            if (c == 32) {
                xx += this.GetFrameWidth(0) + this._fmodules_ox[0];
                continue;
            }
            if (c == 10 || c == 124) {
                xx = x;
                yy += this._line_spacing + (this._modules_h[0] & 0xFFFF);
                continue;
            }
            if (c == 94) {
                if (s[++i] == 126) continue;
                this._crt_pal = s[i] - 48;
                continue;
            }
            if (c < 32) {
                if (c == 1) {
                    int pal;
                    if ((pal = s[++i] & 0xFF) == 255) {
                        this._crt_pal = this._old_pal;
                        continue;
                    }
                    if (pal >= this._palettes) continue;
                    this._crt_pal = pal;
                    continue;
                }
                if (c != 2) continue;
                c = s[++i] & 0xFF;
            } else if (c > 32) {
                c = _map_char[c] & 0xFF;
            }
            int m = this._fmodules_id[c] & 0xFF;
            this.PaintFrame(c, xx, yy, 0);
            xx += this.GetFrameWidth(c) + this._fmodules_ox[0];
        }
        if (restorecol) {
            this._crt_pal = this._old_pal;
        }
    }

    void PaintCharactor(byte ch, int x, int y, int anchor) {
        int c = ch & 0xFF;
        if (c > 32) {
            c = _map_char[c] & 0xFF;
            int m = this._fmodules_id[c] & 0xFF;
            if ((anchor & 8) != 0) {
                x -= this._modules_w[m] & 0xFFFF;
            } else if ((anchor & 1) != 0) {
                x -= (this._modules_w[m] & 0xFFFF) >> 1;
            }
            if ((anchor & 0x20) != 0) {
                y -= this._modules_h[m] & 0xFFFF;
            } else if ((anchor & 2) != 0) {
                y -= (this._modules_h[m] & 0xFFFF) >> 1;
            }
            this.PaintFModule(0, c, x, y, 0);
        }
    }

    static int StringTokenize(byte[] s, int index1, int index2, char[] token, int[] indices) {
        int lines = 0;
        indices[0] = index1 - 1;
        block0: for (int i = index1; i < index2; ++i) {
            for (int j = 0; j < token.length; ++j) {
                if (s[i] != token[j]) continue;
                indices[++lines] = i;
                continue block0;
            }
        }
        indices[++lines] = index2;
        return lines;
    }

    static int StringTokenize(byte[] s, int index1, int index2, char token, int[] indices) {
        ASprite.tokenArray[0] = token;
        return ASprite.StringTokenize(s, index1, index2, tokenArray, indices);
    }

    byte[] Str_fitToFixedWidth(String str, int text_w) {
        byte[] _strByte = null;
        try {
            _strByte = str.getBytes("ISO8859_1");
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.Str_fitToFixedWidth(_strByte, text_w);
    }

    byte[] Str_fitToFixedWidth(byte[] str, int text_w) {
        int i = 0;
        int len = str.length;
        if (len > buff.length) {
            buff = new byte[len];
            s_iBuffSize = len;
        } else {
            for (int j = 0; j < s_iBuffSize; ++j) {
                ASprite.buff[j] = 0;
            }
        }
        _text_lines = 1;
        System.arraycopy(str, 0, buff, 0, len);
        while (i < len) {
            int i2 = this.Str_getNextLineIndex(str, i, text_w);
            if (i2 < len) {
                ASprite.buff[i2] = 10;
                ++_text_lines;
            }
            i = i2 + 1;
        }
        _text_h = _text_lines * (this._line_spacing + this._modules_h[0]);
        return buff;
    }

    int Str_getNextLineIndex(byte[] str, int startIndex, int line_w) {
        int i = startIndex;
        int strLen = str.length;
        boolean inWord = true;
        int curW = 0;
        int spaceStart = i;
        int wordStart = i;
        while (curW < line_w) {
            if (i == strLen || str[i] == 10 || str[i] == 124) {
                if (inWord) {
                    _index1 = wordStart;
                    _index2 = i;
                    this.UpdateStringSize(str);
                    _index1 = -1;
                    _index2 = -1;
                    curW += _text_w;
                }
                if (curW < line_w) {
                    return i;
                }
                return spaceStart;
            }
            if (inWord) {
                if (str[i] == 32) {
                    _index1 = wordStart;
                    _index2 = i;
                    this.UpdateStringSize(str);
                    _index1 = -1;
                    _index2 = -1;
                    if ((curW += _text_w) >= line_w) {
                        return spaceStart;
                    }
                    spaceStart = i;
                    inWord = false;
                    continue;
                }
                ++i;
                continue;
            }
            if (str[i] == 32) {
                curW += this.GetFontSpaceWidth();
                ++i;
                continue;
            }
            wordStart = i;
            inWord = true;
        }
        return spaceStart;
    }

    void DrawPage(int strId, int x, int y, int anchor) {
        String str = CGame.GetString(strId);
        if (strId == 29) {
            str = str + ": " + (CGame.s_bSoundOn ? CGame.GetString(4) : CGame.GetString(5));
        }
        this.DrawPage(str, x, y, anchor);
    }

    void DrawPage(String s, int x, int y, int anchor) {
        this.DrawPage(ASprite.GetStringBytes(s), x, y, anchor, 0, s.length());
    }

    void DrawPage(byte[] s, int x, int y, int anchor) {
        this.DrawPage(s, x, y, anchor, 0, s.length);
    }

    void DrawPage(byte[] s, int x, int y, int anchor, int start, int end) {
        int offflength = 120;
        int[] off = new int[offflength];
        int lines = ASprite.StringTokenize(s, start, end, k_newline_token_chars, off);
        int th = this._line_spacing + (this._modules_h[0] & 0xFFFF);
        if ((anchor & 0x20) != 0) {
            y -= th * (lines - 1);
        } else if ((anchor & 2) != 0) {
            y -= th * (lines - 1) >> 1;
        }
        for (int j = 0; j < lines; ++j) {
            _index1 = off[j] + 1;
            _index2 = off[j + 1];
            this.DrawString(s, x, y + j * th, anchor);
        }
        _index1 = -1;
        _index2 = -1;
    }

    private void ___DRAW_STRINGS_SYSTEM() {
    }

    void SetCurrentPalette(int pal) {
        if (pal < this._palettes) {
            this._crt_pal = pal;
        }
    }

    int GetCurrentPalette() {
        return this._crt_pal;
    }

    static short[] GenPalette(int type, short[] pal) {
        if (type < 0) {
            return pal;
        }
        if (type == 0) {
            return null;
        }
        short[] new_pal = new short[pal.length];
        switch (type) {
            case 4: {
                for (int i = 0; i < pal.length; ++i) {
                    int a = (pal[i] & 0xF000) >> 12;
                    int r = (pal[i] & 0xF00) >> 8;
                    int g = (pal[i] & 0xF0) >> 4;
                    int b = pal[i] & 0xF;
                    int light = (r + g + b) / 3 & 0xF;
                    new_pal[i] = (short)((((a << 4) + (r + 15) / 2 << 4) + g / 2 << 4) + b / 2);
                }
                break;
            }
        }
        return new_pal;
    }

    static int[] GenPalette8888(int type, int[] pal) {
        if (type < 0) {
            return pal;
        }
        if (type == 0) {
            return null;
        }
        int[] new_pal = new int[pal.length];
        switch (type) {
            case 4: {
                for (int i = 0; i < pal.length; ++i) {
                    int a = pal[i] & 0xFF000000;
                    int r = (pal[i] & 0xFF0000) >> 16;
                    int g = (pal[i] & 0xFF00) >> 8;
                    int b = pal[i] & 0xFF;
                    int light = (r + g + b) / 3 & 0xFF;
                    new_pal[i] = a | (r + 255) / 2 << 16 | g / 2 << 8 | b / 2;
                }
                break;
            }
        }
        return new_pal;
    }

    void ModifyPaletteAlpha(int palNb, short alpha) {
        alpha = (short)((alpha << 4) / 100);
        for (int i = 0; i < this._pal[palNb].length; ++i) {
            if ((this._pal[palNb][i] & 0xFFF) == 3855) continue;
            this._pal[palNb][i] = (short)((alpha & 0xF) << 12 | this._pal[palNb][i] & 0xFFF);
        }
    }

    public static void initPool() {
        System.out.println("\ninit Pool...");
        for (int i = 0; i < 100; ++i) {
            ASprite.m_poolASprite[i] = null;
            ASprite.m_poolPalIndex[i] = -1;
            ASprite.m_poolModuleIndex[i] = -1;
        }
        m_poolPos = 0;
    }

    public static void freePool() {
        System.out.println("\nfree Pool...");
        for (int i = 0; i < 100; ++i) {
            if (m_poolASprite[i] != null) {
                ASprite.m_poolASprite[i]._modules_image[ASprite.m_poolPalIndex[i]][ASprite.m_poolModuleIndex[i]] = null;
            }
            ASprite.m_poolASprite[i] = null;
            ASprite.m_poolPalIndex[i] = -1;
            ASprite.m_poolModuleIndex[i] = -1;
        }
        m_poolPos = 0;
        System.gc();
        Thread.yield();
    }

    private void putIntoPool(Image poolElement, int palIndex, int moduleIndex) {
        if (m_poolASprite[m_poolPos] != null) {
            ASprite.m_poolASprite[ASprite.m_poolPos]._modules_image[ASprite.m_poolPalIndex[ASprite.m_poolPos]][ASprite.m_poolModuleIndex[ASprite.m_poolPos]] = null;
            ASprite.m_poolASprite[ASprite.m_poolPos] = null;
            ASprite.m_poolPalIndex[ASprite.m_poolPos] = -1;
            ASprite.m_poolModuleIndex[ASprite.m_poolPos] = -1;
        }
        if (this._modules_image == null) {
            this._modules_image = new Image[this._palettes][];
        }
        if (this._modules_image[palIndex] == null) {
            this._modules_image[palIndex] = new Image[this._nModules];
        }
        this._modules_image[palIndex][moduleIndex] = poolElement;
        ASprite.m_poolASprite[ASprite.m_poolPos] = this;
        ASprite.m_poolPalIndex[ASprite.m_poolPos] = palIndex;
        ASprite.m_poolModuleIndex[ASprite.m_poolPos] = moduleIndex;
        if (++m_poolPos >= 100) {
            m_poolPos = 0;
        }
    }

    ASprite() {
    }

    static {
        s_tempRect = new int[4];
        midp2_flags = new int[]{0, 2, 1, 3, 5, 7, 4, 6};
        record_index = -1;
        record_frame = -1;
        _sizes = new short[100];
        _index1 = -1;
        _index2 = -1;
        tokenArray = new char[1];
        s_iBuffSize = 100;
        buff = new byte[s_iBuffSize];
        k_newline_token_chars = new char[]{'\n', '|'};
        _operation = 0;
        m_poolASprite = new ASprite[100];
        m_poolModuleIndex = new int[100];
        m_poolPalIndex = new int[100];
        m_poolPos = 0;
    }
}

