/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class IGP {
    static final int STATE_LOADING = 0;
    static final int STATE_PAGE = 1;
    static final int STATE_INTERPAGE_LOADING = 2;
    static final int STATE_EXIT_IGP = 3;
    public static final int ACTION_NONE = 0;
    public static final int ACTION_UP = 21;
    public static final int ACTION_DOWN = 32;
    public static final int ACTION_LEFT = 23;
    public static final int ACTION_RIGHT = 24;
    public static final int ACTION_SELECT = 25;
    public static final int ACTION_BACK = 26;
    public static final int ACTION_KEY_0 = 1;
    public static final int ACTION_KEY_1 = 2;
    public static final int ACTION_KEY_2 = 3;
    public static final int ACTION_KEY_3 = 4;
    public static final int ACTION_KEY_4 = 5;
    public static final int ACTION_KEY_5 = 6;
    public static final int ACTION_KEY_6 = 7;
    public static final int ACTION_KEY_7 = 8;
    public static final int ACTION_KEY_8 = 9;
    public static final int ACTION_KEY_9 = 10;
    public static final int ACTION_KEY_POUND = 11;
    static final String URL_PREFIX = "URL";
    static final int PROGRESSBAR_BORDER_COLOR = 0xFFFFFF;
    static final int PROGRESSBAR_FILL_COLOR = 0xFF0000;
    static final int PROGRESSBAR_FILL_HEIGHT = 3;
    static final int PROGRESSBAR_BORDER_SPACING = 1;
    static final int PROGRESSBAR_BORDER_HEIGHT = 6;
    static final int LOAD_START = 0;
    static final int LOAD_LIBOPEN = 1;
    static final int LOAD_TEXTS = 2;
    static final int LOAD_FONT = 3;
    static final int LOAD_GLOBAL_RES = 4;
    static final int LOAD_PROMO0 = 5;
    static final int LOAD_PROMOTION = 8;
    static final int LOAD_DEMO = 9;
    static final int LOAD_WH = 10;
    static final int LOAD_BS = 11;
    static final int LOAD_COMPLETE_CATALOG = 12;
    static final int LOAD_STEP_CATALOG = 12;
    static final int LOAD_END = 13;
    static final int PAGE_PROMO_0 = 0;
    static final int PAGE_PROMO_1 = 1;
    static final int PAGE_PROMO_2 = 2;
    static final int PAGE_PROMOTION = 3;
    static final int PAGE_DEMO = 4;
    static final int PAGE_WHATS_HOT = 5;
    static final int PAGE_BESTSELLERS = 6;
    static final int PAGE_COMPLETE_CATALOG = 7;
    static final int LAST_PAGE_CATALOG = 7;
    static final int MAX_PAGE_NUMBER = 8;
    static final int DISPLAY_SELECT_SK = 1;
    static final int DISPLAY_BACK_SK = 2;
    static final int IMG_4BLUE = 0;
    static final int IMG_4WHITE = 1;
    static final int IMG_6BLUE = 2;
    static final int IMG_6WHITE = 3;
    static final int IMG_BACK = 4;
    static final int IMG_TICK = 5;
    static final int IMG_GAMELOFT = 6;
    static final int IMG_MORE = 7;
    static final int EN_IMG_COUNT = 8;
    static final int DATA_IMG_COUNT = 8;
    static String _lib_sFileName;
    static int _lib_nChunks;
    static int[] _lib_pOffset;
    static byte[][] _lib_pData;
    static int dataOffset;
    private static byte[][] fontDescriptor;
    private static int fontHeight;
    static final int FONT_X = 0;
    static final int FONT_Y = 1;
    static final int FONT_W = 2;
    static final int FONT_H = 3;
    private static Image[] fontImage;
    static int drawColor;
    static final int MAX_NB_LINES = 10;
    static final byte lineSeparator = 10;
    static int[] s_line_w;
    static int s_text_h;
    static int s_text_w;
    static int char_spacing;
    static int line_spacing;
    static boolean bDetermineSizeOnly;
    static int nbLines;
    static final byte k_Check_NULL = 1;
    static final byte k_Check_DEL = 2;
    static final byte k_Check_NO = 4;
    static final byte k_Check_ALL = 7;
    static final byte k_Check_PROMO = 2;
    static final byte k_Check_DEMO = 7;
    static final byte k_Check_ORANGE = 2;
    static final String[] PAGE_LIST_PREFIXES;
    static final String s_IGP_PROMOS = "IGP-PROMOS";
    static final String s_IGP_DEMOS = "IGP-DEMOS";
    static final String s_IGP_WN = "IGP-WN";
    static final String s_IGP_BS = "IGP-BS";
    static final String s_IGP_HOST = "IGP-HOST";
    static final String s_IGP_CATEGORIES = "IGP-CATEGORIES";
    static final String k_URL_TEMPLATE_GAME = "URL-TEMPLATE-GAME";
    static final String k_IGP_VERSION = "IGP-VERSION";
    static final String s_PLACEHOLDER = "XXXX";
    static final String s_ctg_PLACEHOLDER = "&ctg=XXXX";
    static final String s_VERSION_PLACEHOLDER = "&ver=";
    static final String s_INGAMEADS_SERVER = "ingameads.gameloft.com";
    static final String s_GAME_SEPARATOR = ";";
    static String s_URL_TEMPLATE_GAME;
    static boolean b_useIGPRedir;
    static String s_igpVersion;
    static String[] _StrMgr_Pack;
    static short[] _StrMgr_Offsets;
    static int _arrowPressedCounter;
    static boolean _redArrowLeft;
    static boolean _redArrowRight;
    static int s_box_color;
    static MIDlet MidletInstance;
    static String URLPlatformRequest;
    static boolean IsAvailable;
    static int CurrentState;
    static int CurrentPage;
    static int CurrentPageIdx;
    static int CurrentLoadingStep;
    static int TotalLoadingSteps;
    static int ValidPages;
    static int[] ValidPagesIdx;
    static Image _imgBB;
    static Graphics _gBB;
    static boolean bRefreshBB;
    static boolean bRefreshList;
    static Image[] GlobalImages;
    static Image[] PageImages;
    static Image[][] LIST_Images;
    static String[][] LIST_URLs;
    static int[][] ValidLISTIdx;
    static int[][] LIST_Texts;
    static int[] LIST_nbItems;
    static int currentList;
    static int currentList_nbItems;
    static int LIST_visibleItemCount;
    static int s_igpListDisplayItemStart;
    static int s_ItemListIndex;
    static String[] PageURLs;
    static int pageTextId;
    static boolean bDisplayButton;
    static byte s_displaySoftKeys;
    static boolean bIsListPage;
    static int iButtonStringId;
    static int box_w;
    static int box_h;
    static int box_x;
    static int box_y;
    static int CurrentLanguage;
    static Image PageCatalogueImage;
    static Image PagePromotionImage;
    static String s_textPt;
    static String StringLoading;
    static String s_urlOperator;

    static void drawGradient(Graphics g, int x, int y, int wx, int wy, int C1, int C2) {
        int gradR1 = C1 >> 16;
        int gradG1 = C1 >> 8 & 0xFF;
        int gradB1 = C1 & 0xFF;
        int gradR2 = C2 >> 16;
        int gradG2 = C2 >> 8 & 0xFF;
        int gradB2 = C2 & 0xFF;
        if (y + wy > 320) {
            wy = 320 - y;
        }
        if (x + wx > 240) {
            wx = 240 - x;
        }
        int dr = gradR2 - gradR1;
        int dg = gradG2 - gradG1;
        int db = gradB2 - gradB1;
        int intr = gradR1;
        int intg = gradG1;
        int intb = gradB1;
        int stp = 0;
        for (int i = y; i < y + wy; ++i) {
            if (i < 160) {
                stp = i;
            } else if (i == 160) {
                intr = gradR2;
                intg = gradG2;
                intb = gradB2;
                stp = 0;
            } else {
                stp = 160 - i;
            }
            g.setColor(intr + dr * stp / 160, intg + dg * stp / 160, intb + db * stp / 160);
            g.drawLine(x, i, x + wx, i);
        }
    }

    static void drawProgressBar(Graphics g, int y, int wx, int progress, int total) {
        if (progress > total) {
            progress = total;
        }
        int x = (240 - wx) / 2;
        g.setColor(0xFFFFFF);
        g.drawRect(x, y, wx, 6);
        int fillWidth = (wx - 2 - 2) * progress / total + 1;
        g.setColor(0xFF0000);
        g.fillRect(x + 1 + 1, y + 1 + 1, fillWidth, 3);
    }

    static boolean Lib_Open(String sLibFileName, boolean bRead) {
        IGP.Lib_Close();
        _lib_sFileName = sLibFileName;
        try {
            System.gc();
            InputStream is = "a".getClass().getResourceAsStream(sLibFileName);
            System.gc();
            _lib_nChunks = is.read() & 0xFF;
            _lib_pOffset = new int[_lib_nChunks += (is.read() & 0xFF) << 8];
            int i = 0;
            while (i < _lib_nChunks) {
                IGP._lib_pOffset[i] = is.read() & 0xFF;
                int n = i;
                _lib_pOffset[n] = _lib_pOffset[n] + ((is.read() & 0xFF) << 8);
                int n2 = i;
                _lib_pOffset[n2] = _lib_pOffset[n2] + ((is.read() & 0xFF) << 16);
                int n3 = i++;
                _lib_pOffset[n3] = _lib_pOffset[n3] + ((is.read() & 0xFF) << 24);
            }
            if (bRead) {
                _lib_pData = new byte[_lib_nChunks][];
                for (i = 0; i < _lib_nChunks - 1; ++i) {
                    int chunk_size = _lib_pOffset[i + 1] - _lib_pOffset[i];
                    if (chunk_size <= 0) continue;
                    IGP._lib_pData[i] = new byte[chunk_size];
                    is.read(_lib_pData[i]);
                }
            }
            is.close();
            is = null;
            System.gc();
        }
        catch (Exception e) {
            System.out.println("Exception in Lib_Openn( " + sLibFileName + ") : " + e.toString());
            return false;
        }
        return true;
    }

    static void Lib_Close() {
        _lib_sFileName = null;
        _lib_pOffset = null;
        _lib_pData = null;
        _lib_nChunks = 0;
        System.gc();
    }

    static byte[] Lib_GetData(int index, boolean bCopy) {
        if (index < 0 || index >= _lib_nChunks - 1) {
            return null;
        }
        int chunk_size = _lib_pOffset[index + 1] - _lib_pOffset[index];
        if (chunk_size == 0) {
            return null;
        }
        if (_lib_pData != null) {
            if (bCopy) {
                byte[] data = new byte[chunk_size];
                System.arraycopy(_lib_pData, index, data, 0, chunk_size);
                return data;
            }
            return _lib_pData[index];
        }
        byte[] data = null;
        try {
            InputStream is = null;
            is = "a".getClass().getResourceAsStream(_lib_sFileName);
            is.skip(2 + 4 * _lib_nChunks + _lib_pOffset[index]);
            data = new byte[chunk_size];
            is.read(data);
            is.close();
            is = null;
        }
        catch (Exception e) {
            System.out.println("Exception in Lib[" + _lib_sFileName + "]->GetData(" + index + ", " + bCopy + ") : " + e.toString());
        }
        System.gc();
        return data;
    }

    static int readInt(byte[] data) {
        return (data[dataOffset++] & 0xFF) + ((data[dataOffset++] & 0xFF) << 8);
    }

    static byte readByte(byte[] data) {
        return (byte)(data[dataOffset++] & 0xFF);
    }

    static Image readImage(byte[] data) {
        int size = IGP.readInt(data);
        Image img = Image.createImage((byte[])data, (int)dataOffset, (int)size);
        dataOffset += size;
        return img;
    }

    static String readPlainString(byte[] data) {
        int size = IGP.readInt(data);
        dataOffset += size;
        return null;
    }

    private static int getPNGChunkOffset(byte[] buffer, int offset, int length, String chunkName) {
        for (int i = offset; i < length - 4; ++i) {
            if ((buffer[i] & 0xFF) != chunkName.charAt(0) || (buffer[i + 1] & 0xFF) != chunkName.charAt(1) || (buffer[i + 2] & 0xFF) != chunkName.charAt(2) || (buffer[i + 3] & 0xFF) != chunkName.charAt(3)) continue;
            return i;
        }
        return -1;
    }

    private static Image createImageFromPal(byte[] buffer, int offset, int length, int paletteColor, int finalColor) {
        int pngPlteOffset = IGP.getPNGChunkOffset(buffer, offset, length, "PLTE");
        int pngtRNSOffset = IGP.getPNGChunkOffset(buffer, offset, length, "tRNS");
        Image img = null;
        if (pngPlteOffset > 0 && pngtRNSOffset > 0) {
            int plteBytesSize = (buffer[pngPlteOffset - 4] << 24 & 0xFF000000) + (buffer[pngPlteOffset - 3] << 16 & 0xFF0000) + (buffer[pngPlteOffset - 2] << 8 & 0xFF00) + (buffer[pngPlteOffset - 1] << 0 & 0xFF);
            for (int i = 0; i < plteBytesSize; ++i) {
                long c;
                int n;
                if (buffer[pngtRNSOffset + 4 + i] == 0 || (buffer[pngPlteOffset + 4 + 3 * i] & 0xFF) != ((paletteColor & 0xFF0000) >> 16 & 0xFF) || (buffer[pngPlteOffset + 4 + 3 * i + 1] & 0xFF) != ((paletteColor & 0xFF00) >> 8 & 0xFF) || (buffer[pngPlteOffset + 4 + 3 * i + 2] & 0xFF) != (paletteColor & 0xFF)) continue;
                int tempColor = IGP.ArrayToInt(buffer, pngPlteOffset + 4 + 3 * i, 3);
                IGP.IntToArray(buffer, pngPlteOffset + 4 + 3 * i, 3, finalColor);
                byte[] tmpBuf = new byte[plteBytesSize + 4];
                System.arraycopy(buffer, pngPlteOffset, tmpBuf, 0, plteBytesSize + 4);
                long[] crc_table = new long[256];
                for (n = 0; n < 256; ++n) {
                    c = n;
                    for (int k = 0; k < 8; ++k) {
                        if ((c & 1L) == 1L) {
                            c = 0xEDB88320L ^ c >> 1;
                            continue;
                        }
                        c >>= 1;
                    }
                    crc_table[n] = c;
                }
                c = 0xFFFFFFFFL;
                for (n = 0; n < tmpBuf.length; ++n) {
                    c = crc_table[(int)(c ^ (long)tmpBuf[n]) & 0xFF] ^ c >> 8;
                }
                int tempCRC = IGP.ArrayToInt(buffer, pngPlteOffset + 4 + plteBytesSize, 4);
                IGP.IntToArray(buffer, pngPlteOffset + 4 + plteBytesSize, 4, (int)(c ^= 0xFFFFFFFFL));
                tmpBuf = null;
                crc_table = null;
                System.gc();
                img = Image.createImage((byte[])buffer, (int)offset, (int)length);
                IGP.IntToArray(buffer, pngPlteOffset + 4 + 3 * i, 3, tempColor);
                IGP.IntToArray(buffer, pngPlteOffset + 4 + plteBytesSize, 4, tempCRC);
                break;
            }
        }
        return img;
    }

    static void IntToArray(byte[] buffer, int startOffset, int nbBytes, int intValue) {
        for (int i = nbBytes - 1; i >= 0; --i) {
            buffer[startOffset + nbBytes - 1 - i] = (byte)((intValue & 255 << 8 * i) >> 8 * i);
        }
    }

    static int ArrayToInt(byte[] buffer, int startOffset, int nbBytes) {
        int retVal = 0;
        for (int i = nbBytes - 1; i >= 0; --i) {
            retVal += buffer[startOffset + nbBytes - 1 - i] << 8 * i & 255 << 8 * i;
        }
        return retVal;
    }

    public static String getString(int strIdx) {
        return "" + _StrMgr_Pack[strIdx];
    }

    static void drawString(int strIdx, Graphics g, int x, int y, int anchor) {
        IGP.drawString(_StrMgr_Pack[strIdx], g, x, y, anchor);
    }

    static void drawString(String str, Graphics g, int x, int y, int anchor) {
        char c;
        int i;
        IGP.s_line_w[0] = 0;
        s_text_w = 0;
        int line = 0;
        char[] charArray = str.toCharArray();
        int len = str.length();
        for (i = 0; i < len; ++i) {
            c = charArray[i];
            if (c == '\n' && line < 10) {
                int n = line;
                s_line_w[n] = s_line_w[n] - char_spacing;
                if (s_line_w[line] > s_text_w) {
                    s_text_w = s_line_w[line];
                }
                IGP.s_line_w[++line] = 0;
                continue;
            }
            if (c == '\u0000' || c == '\u0001') continue;
            int n = line;
            s_line_w[n] = s_line_w[n] + (fontDescriptor[c][2] + char_spacing);
        }
        int n = line;
        s_line_w[n] = s_line_w[n] - char_spacing;
        if (s_line_w[line] > s_text_w) {
            s_text_w = s_line_w[line];
        }
        s_text_h = (line + 1) * fontHeight + line * line_spacing;
        nbLines = line + 1;
        if (bDetermineSizeOnly) {
            bDetermineSizeOnly = false;
            return;
        }
        y += line_spacing * line / 2;
        line = 0;
        if ((anchor & 0x20) != 0) {
            y -= s_text_h;
        } else if ((anchor & 2) != 0) {
            y -= s_text_h >> 1;
        }
        int posX = x;
        boolean newLine = true;
        for (i = 0; i < len; ++i) {
            c = charArray[i];
            if (newLine) {
                posX = x;
                if ((anchor & 8) != 0) {
                    posX -= s_line_w[line];
                } else if ((anchor & 1) != 0) {
                    posX -= s_line_w[line] >> 1;
                }
                newLine = false;
            }
            if (c == '\n' && line < 10) {
                y += fontHeight + line_spacing;
                ++line;
                newLine = true;
                continue;
            }
            if (c == '\u0000') {
                if (i >= len - 1) continue;
                drawColor = charArray[++i];
                continue;
            }
            g.setClip(posX, y, fontDescriptor[c][2] & 0xFF, fontDescriptor[c][3] & 0xFF);
            g.drawRegion(fontImage[drawColor], fontDescriptor[c][0] & 0xFF, fontDescriptor[c][1] & 0xFF, fontDescriptor[c][2] & 0xFF, fontDescriptor[c][3] & 0xFF, 0, posX, y, 20);
            posX += (fontDescriptor[c][2] & 0xFF) + char_spacing;
        }
        g.setClip(0, 0, 240, 320);
        drawColor = 0;
    }

    public static void initialize(MIDlet midlet) {
        MidletInstance = midlet;
        IGP.readAndParseURLs();
        TotalLoadingSteps = 13;
    }

    static boolean checkURL(String url, int checkFlags) {
        if (url == null) {
            return (checkFlags & 1) == 0;
        }
        url = url.trim();
        return !((checkFlags & 1) != 0 && url.length() == 0 || (checkFlags & 2) != 0 && url.toUpperCase().compareTo("DEL") == 0 || (checkFlags & 4) != 0 && (url.toUpperCase().compareTo("NO") == 0 || url.toUpperCase().compareTo("0") == 0));
    }

    private static String getRedirLink(String appProp, String code, String urlTemplate) {
        String url = "";
        try {
            if (urlTemplate != null && appProp != null && code != null) {
                int startPos = appProp.indexOf(code + "=");
                urlTemplate = urlTemplate.trim();
                if (startPos >= 0 && urlTemplate.length() > 0) {
                    int endPos = appProp.indexOf(s_GAME_SEPARATOR, startPos += code.length() + 1);
                    if (endPos < 0) {
                        endPos = appProp.length();
                    }
                    url = appProp.substring(startPos, endPos);
                    if ((url = url.trim()).length() == 0 || url.compareTo("0") == 0 || url.toUpperCase().compareTo("NO") == 0) {
                        url = "";
                    } else if (url.toUpperCase().compareTo("DEL") != 0 && code.compareTo("OP") != 0) {
                        int separatorPos = urlTemplate.indexOf(s_PLACEHOLDER);
                        url = urlTemplate.substring(0, separatorPos) + url + urlTemplate.substring(separatorPos + s_PLACEHOLDER.length());
                    }
                }
            }
        }
        catch (Exception e) {
            url = "";
        }
        return url;
    }

    private static void parseSplash(int page, String code, int check, String jadEntry, String urlTemplate) {
        try {
            IGP.PageURLs[page] = b_useIGPRedir ? IGP.getRedirLink(MidletInstance.getAppProperty(jadEntry), code, urlTemplate) : MidletInstance.getAppProperty("URL-" + code);
            if (IGP.checkURL(PageURLs[page], check)) {
                IGP.ValidPagesIdx[IGP.ValidPages++] = page;
                if (PageURLs[page].toUpperCase().compareTo("NO") == 0 || PageURLs[page].toUpperCase().compareTo("0") == 0) {
                    IGP.PageURLs[page] = "";
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static void parseList(int list, String[] list_codes, int page, int itemNo, int currentList_item_start, String jadEntry) {
        IGP.LIST_URLs[list] = new String[itemNo];
        IGP.ValidLISTIdx[list] = new int[itemNo];
        IGP.LIST_Texts[list] = new int[itemNo];
        int nbItems = 0;
        String urlTemplate = "";
        if (b_useIGPRedir) {
            try {
                jadEntry = MidletInstance.getAppProperty(jadEntry);
                urlTemplate = s_URL_TEMPLATE_GAME;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (int j = 0; j < list_codes.length; ++j) {
            try {
                String url = "";
                if (j == itemNo - 1) {
                    if (!b_useIGPRedir) {
                        url = MidletInstance.getAppProperty(PAGE_LIST_PREFIXES[list]);
                    } else if (s_urlOperator.length() > 0) {
                        url = IGP.getRedirLink(MidletInstance.getAppProperty(s_IGP_CATEGORIES), list_codes[j], s_urlOperator + s_ctg_PLACEHOLDER);
                    }
                } else {
                    url = b_useIGPRedir ? IGP.getRedirLink(jadEntry, list_codes[j], urlTemplate) : MidletInstance.getAppProperty(PAGE_LIST_PREFIXES[list] + "-" + list_codes[j]);
                }
                if (!IGP.checkURL(url, 7)) continue;
                IGP.LIST_URLs[list][nbItems] = url;
                IGP.ValidLISTIdx[list][nbItems++] = j;
                IGP.LIST_Texts[list][j] = currentList_item_start + j;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (nbItems > 0) {
            IGP.ValidPagesIdx[IGP.ValidPages++] = page;
            IGP.LIST_nbItems[list] = nbItems;
        }
    }

    private static void readAndParseURLs() {
        String[] PROMOS = new String[]{"RF08", "MBRC", "CSIM"};
        ValidPages = 0;
        ValidPagesIdx = new int[8];
        PageURLs = new String[8];
        String[][] LIST = new String[][]{{"LNUR", "ASCR", "GRTO", "BUBA", "WN"}, {"MDPL", "BBRK", "HERO", "GANG", "BS"}};
        LIST_URLs = new String[2][];
        ValidLISTIdx = new int[2][];
        LIST_Texts = new int[2][];
        LIST_nbItems = new int[2];
        try {
            s_URL_TEMPLATE_GAME = MidletInstance.getAppProperty(k_URL_TEMPLATE_GAME).trim();
            b_useIGPRedir = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        s_igpVersion = "";
        try {
            s_igpVersion = MidletInstance.getAppProperty(k_IGP_VERSION).trim();
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int promo = 0; promo < 3; ++promo) {
            IGP.parseSplash(promo, PROMOS[promo], 2, s_IGP_PROMOS, s_URL_TEMPLATE_GAME);
        }
        String l_urlOperator = null;
        try {
            String str;
            l_urlOperator = MidletInstance.getAppProperty("URL-OPERATOR");
            if (IGP.checkURL(l_urlOperator, 7)) {
                s_urlOperator = l_urlOperator;
            }
            if ((str = MidletInstance.getAppProperty("URL-PT")) != null) {
                s_textPt = "";
                int len = str.length();
                for (int i = 0; i < len; ++i) {
                    char c = str.charAt(i);
                    if (i < len - 1 && c == '\\' && (str.charAt(i + 1) == 'n' || str.charAt(i + 1) == 'N')) {
                        s_textPt = s_textPt + '\n';
                        ++i;
                        continue;
                    }
                    s_textPt = s_textPt + c;
                }
                if (!IGP.checkURL(s_textPt = s_textPt.toUpperCase(), 7)) {
                    s_textPt = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (IGP.checkURL(s_urlOperator, 7)) {
            IGP.parseSplash(3, "PROMO", 7, s_IGP_CATEGORIES, s_urlOperator + s_ctg_PLACEHOLDER);
        }
        IGP.parseSplash(4, "DEMOPG", 7, s_IGP_DEMOS, s_URL_TEMPLATE_GAME);
        IGP.parseList(0, LIST[0], 5, 5, 10, s_IGP_WN);
        IGP.parseList(1, LIST[1], 6, 5, 15, s_IGP_BS);
        if (!b_useIGPRedir || IGP.checkURL(IGP.getRedirLink(MidletInstance.getAppProperty(s_IGP_CATEGORIES), "OP", s_urlOperator), 7)) {
            IGP.PageURLs[7] = s_urlOperator;
            if (IGP.checkURL(s_urlOperator, 7)) {
                IGP.ValidPagesIdx[IGP.ValidPages++] = 7;
            }
        }
        LIST = null;
        PROMOS = null;
        IsAvailable = ValidPages > 0;
    }

    public static void enterIGP(String loadingMsg, int lang) {
        CurrentLanguage = lang;
        StringLoading = loadingMsg;
        CurrentLoadingStep = -1;
        CurrentState = 0;
        CurrentPageIdx = 0;
        CurrentPage = ValidPagesIdx[0];
        s_igpListDisplayItemStart = 0;
        s_ItemListIndex = 0;
        drawColor = 0;
        System.gc();
        System.out.println("Free memory before entering IGP:" + Runtime.getRuntime().freeMemory() / 1024L + "k");
        s_line_w = new int[10];
        _imgBB = CGame._imgBB;
        _gBB = CGame._gBB;
    }

    static boolean isPageVisible(int page) {
        boolean visible = false;
        for (int i = 0; i < ValidPages; ++i) {
            if (ValidPagesIdx[i] != page) continue;
            visible = true;
            break;
        }
        return visible;
    }

    private static void loadResources(int loadStep) {
        dataOffset = 0;
        int idx = 0;
        int page = loadStep - 5;
        int list = 0;
        int resource_slot = 0;
        int resource_nbItems = 0;
        if (page > 0 && loadStep < 13) {
            if (!IGP.isPageVisible(page)) {
                return;
            }
            IGP.PageImages[page] = GlobalImages[6];
        }
        System.out.println("\tloadStep=" + loadStep);
        switch (loadStep) {
            case 0: {
                GlobalImages = new Image[8];
                PageImages = new Image[8];
                LIST_Images = new Image[2][];
                IGP.LIST_Images[0] = new Image[5];
                IGP.LIST_Images[1] = new Image[5];
                break;
            }
            case 1: {
                IGP.Lib_Open("/dataIGP", true);
                System.gc();
                System.out.println("\tFree memory after libopen:" + Runtime.getRuntime().freeMemory() / 1024L + "k");
                break;
            }
            case 2: {
                int size;
                int i;
                byte[] data = IGP.Lib_GetData(0, false);
                for (i = 0; i < CurrentLanguage; ++i) {
                    size = IGP.readInt(data);
                    dataOffset += size;
                }
                IGP.readInt(data);
                size = IGP.readInt(data);
                _StrMgr_Pack = new String[size];
                byte[] rawData = new byte[size];
                System.arraycopy(data, dataOffset, rawData, 0, size);
                dataOffset += size;
                IGP.readInt(data);
                int nStrings = data[dataOffset++] & 0xFF | (data[dataOffset++] & 0xFF) << 8;
                _StrMgr_Offsets = new short[nStrings];
                for (i = 0; i < nStrings - 1; ++i) {
                    IGP._StrMgr_Offsets[i] = (short)((data[dataOffset++] & 0xFF) + ((data[dataOffset++] & 0xFF) << 8));
                }
                IGP._StrMgr_Offsets[nStrings - 1] = (short)size;
                for (i = 0; i < nStrings; ++i) {
                    int off = i == 0 ? 0 : _StrMgr_Offsets[i - 1] & 0xFFFF;
                    int len = (_StrMgr_Offsets[i] & 0xFFFF) - off - 1;
                    if (len == 0) continue;
                    try {
                        StringBuffer strbuf = new StringBuffer(len / 2 + 2);
                        int j = off;
                        while (j < off + len) {
                            if ((rawData[j] & 0x80) == 0) {
                                strbuf.append((char)(rawData[j++] & 0xFF));
                                continue;
                            }
                            if ((rawData[j] & 0xE0) == 192) {
                                if (j + 1 >= off + len || (rawData[j + 1] & 0xC0) != 128) {
                                    throw new Exception();
                                }
                                strbuf.append((char)((rawData[j++] & 0x1F) << 6 | rawData[j++] & 0x3F));
                                continue;
                            }
                            if ((rawData[j] & 0xF0) == 224) {
                                if (j + 2 >= off + len || (rawData[j + 1] & 0xC0) != 128 || (rawData[j + 2] & 0xC0) != 128) {
                                    throw new Exception();
                                }
                                strbuf.append((char)((rawData[j++] & 0xF) << 12 | (rawData[j++] & 0x3F) << 6 | rawData[j++] & 0x3F));
                                continue;
                            }
                            throw new Exception();
                        }
                        IGP._StrMgr_Pack[i] = strbuf.toString();
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("failed to load string id " + i);
                    }
                }
                break;
            }
            case 3: {
                fontImage = new Image[2];
                byte[] data = IGP.Lib_GetData(1, false);
                int imageSize = IGP.readInt(data);
                dataOffset = 0;
                IGP.fontImage[0] = IGP.readImage(data);
                IGP.fontImage[1] = IGP.createImageFromPal(data, 2, imageSize, 0, 0xFF0000);
                int nrChars = IGP.readInt(data) / 6;
                fontDescriptor = new byte[IGP.readInt(data) + 1][4];
                for (int i = 0; i < nrChars; ++i) {
                    int imageNameInt = IGP.readInt(data) & 0xFFFF;
                    IGP.fontDescriptor[imageNameInt][0] = IGP.readByte(data);
                    IGP.fontDescriptor[imageNameInt][1] = IGP.readByte(data);
                    IGP.fontDescriptor[imageNameInt][2] = IGP.readByte(data);
                    IGP.fontDescriptor[imageNameInt][3] = IGP.readByte(data);
                    if (imageNameInt != 32) continue;
                    fontHeight = fontDescriptor[imageNameInt][3] & 0xFF;
                }
                System.gc();
                System.out.println("\tFree memory after font:" + Runtime.getRuntime().freeMemory() / 1024L + "k");
                break;
            }
            case 4: {
                byte[] data = IGP.Lib_GetData(2, false);
                for (int i = 0; i < 8; ++i) {
                    IGP.GlobalImages[i] = IGP.readImage(data);
                }
                System.gc();
                System.out.println("\tFree memory after global res:" + Runtime.getRuntime().freeMemory() / 1024L + "k");
                break;
            }
            default: {
                idx = 3 + page;
                if (loadStep == 9) {
                    idx = 7;
                }
                IGP.PageImages[page] = IGP.readImage(IGP.Lib_GetData(idx, false));
                System.gc();
                System.out.println("\tFree memory after splash " + page + ":" + Runtime.getRuntime().freeMemory() / 1024L + "k");
                break;
            }
            case 10: {
                resource_nbItems = 4;
                resource_slot = 8;
            }
            case 11: {
                if (loadStep == 11) {
                    list = 1;
                    resource_nbItems = 4;
                    resource_slot = 9;
                }
                byte[] data = IGP.Lib_GetData(resource_slot, false);
                while (idx < resource_nbItems) {
                    IGP.LIST_Images[list][idx] = IGP.readImage(data);
                    ++idx;
                }
                IGP.LIST_Images[list][idx] = GlobalImages[7];
                break;
            }
            case 8: 
            case 12: {
                byte[] data = IGP.Lib_GetData(6, false);
                if (loadStep == 12) {
                    PageCatalogueImage = IGP.createImageFromPal(data, 2, data.length - 2, 0xFF3300, 22923);
                }
                if (loadStep != 8) break;
                PagePromotionImage = IGP.readImage(data);
                break;
            }
            case 13: {
                IGP.Lib_Close();
            }
        }
    }

    static void unloadResources(boolean complete) {
        int i = 0;
        if (complete) {
            IGP.Lib_Close();
            fontDescriptor = null;
            fontImage = null;
            for (i = 0; i < 8; ++i) {
                IGP.GlobalImages[i] = null;
            }
            GlobalImages = null;
        }
        for (i = 0; i < 8; ++i) {
            IGP.PageImages[i] = null;
        }
        if (complete) {
            PageImages = null;
        }
        PagePromotionImage = null;
        PageCatalogueImage = null;
        for (i = 0; i < LIST_Images.length; ++i) {
            if (LIST_Images[i] == null) continue;
            for (int j = 0; j < LIST_Images[i].length; ++j) {
                IGP.LIST_Images[i][j] = null;
            }
        }
        if (complete) {
            LIST_Images = null;
        }
        if (complete) {
            _StrMgr_Offsets = null;
            _StrMgr_Pack = null;
            s_line_w = null;
            _imgBB = null;
            _gBB = null;
            StringLoading = null;
        }
        System.gc();
    }

    public static boolean updateIGP(int action) {
        block25: {
            if (!IsAvailable) {
                return true;
            }
            switch (CurrentState) {
                case 0: {
                    if (CurrentLoadingStep++ >= TotalLoadingSteps) {
                        IGP.initPage(1);
                        bRefreshBB = true;
                        CGame.soundPlay(65);
                        break;
                    }
                    IGP.loadResources(CurrentLoadingStep);
                    break;
                }
                case 1: {
                    switch (action) {
                        case 26: {
                            CurrentState = 3;
                            break;
                        }
                        case 5: 
                        case 23: {
                            if (ValidPages <= 1) break;
                            if (CurrentPageIdx-- == 0) {
                                CurrentPageIdx = ValidPages - 1;
                            }
                            _redArrowLeft = true;
                        }
                        case 7: 
                        case 24: {
                            if (ValidPages <= 1) break;
                            if (!_redArrowLeft) {
                                if (CurrentPageIdx++ == ValidPages - 1) {
                                    CurrentPageIdx = 0;
                                }
                                _redArrowRight = true;
                            }
                            s_igpListDisplayItemStart = 0;
                            s_ItemListIndex = 0;
                            IGP.initPage(1);
                            break;
                        }
                        case 9: 
                        case 32: {
                            if (bIsListPage && s_ItemListIndex < currentList_nbItems - 1) {
                                if (++s_ItemListIndex - s_igpListDisplayItemStart >= LIST_visibleItemCount) {
                                    ++s_igpListDisplayItemStart;
                                }
                                bRefreshBB = true;
                                break;
                            }
                            break block25;
                        }
                        case 3: 
                        case 21: {
                            if (bIsListPage && s_ItemListIndex > 0) {
                                if (--s_ItemListIndex - s_igpListDisplayItemStart < 0) {
                                    --s_igpListDisplayItemStart;
                                }
                                bRefreshBB = true;
                                break;
                            }
                            break block25;
                        }
                        case 6: 
                        case 25: {
                            String url = PageURLs[CurrentPage];
                            if (bIsListPage) {
                                url = LIST_URLs[currentList][s_ItemListIndex];
                            }
                            if (url != null && url.length() > 0) {
                                if (s_igpVersion.length() > 0 && s_URL_TEMPLATE_GAME.toLowerCase().indexOf(s_VERSION_PLACEHOLDER) == -1 && s_URL_TEMPLATE_GAME.toLowerCase().indexOf(s_INGAMEADS_SERVER) >= 0) {
                                    url = url + s_VERSION_PLACEHOLDER + s_igpVersion;
                                }
                                URLPlatformRequest = url;
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    IGP.unloadResources(true);
                    System.gc();
                    System.out.println("Free memory after exiting IGP::" + Runtime.getRuntime().freeMemory() / 1024L + "k");
                    return true;
                }
            }
        }
        return false;
    }

    static void initPage(int nextState) {
        CurrentState = nextState;
        bRefreshBB = true;
        CurrentPage = ValidPagesIdx[CurrentPageIdx];
        s_displaySoftKeys = 0;
        pageTextId = CurrentPage;
        s_ItemListIndex = 0;
        currentList_nbItems = 0;
        s_igpListDisplayItemStart = 0;
        bIsListPage = false;
        bDisplayButton = PageURLs[CurrentPage] != null && PageURLs[CurrentPage].length() > 0 && PageURLs[CurrentPage].compareTo("DEL") != 0;
        s_box_color = 0xFF0000;
        if (CurrentPage == 5) {
            currentList = 0;
            bIsListPage = true;
        }
        if (CurrentPage == 6) {
            currentList = 1;
            bIsListPage = true;
        }
        if (CurrentPage == 7) {
            bDisplayButton = true;
        }
        if (bIsListPage) {
            currentList_nbItems = LIST_nbItems[currentList];
        }
        if (bDisplayButton || bIsListPage) {
            s_displaySoftKeys = (byte)(s_displaySoftKeys | 1);
        }
        s_displaySoftKeys = (byte)(s_displaySoftKeys | 2);
        iButtonStringId = 8;
        if (CurrentPage < 3 || CurrentPage == 4) {
            iButtonStringId = 9;
        }
        if (CurrentState == 1) {
            IGP.getFlashingBoxRect();
        }
    }

    public static void getFlashingBoxRect() {
        bDetermineSizeOnly = true;
        IGP.drawString(iButtonStringId, null, 0, 0, 3);
        box_w = s_text_w + 4;
        box_h = s_text_h + 2;
        box_x = 120 - box_w / 2;
        box_y = 320 - box_h - 12;
        if (CurrentPage < 3) {
            box_y = 160 - box_h / 2;
        }
    }

    public static void paintIGP(Graphics g) {
        g.setClip(0, 0, 240, 320);
        if (!IsAvailable) {
            return;
        }
        switch (CurrentState) {
            case 0: {
                g.setColor(0);
                g.fillRect(0, 0, 240, 320);
                IGP.drawProgressBar(g, 160, 180, CurrentLoadingStep, TotalLoadingSteps);
                if (StringLoading == null || StringLoading.trim().equals("")) break;
                g.setColor(0xFFFFFF);
                g.setFont(Font.getFont((int)0, (int)0, (int)8));
                g.drawString(StringLoading, 120, 155, 33);
                break;
            }
            case 1: {
                _gBB.setClip(0, 0, 240, 320);
                boolean number_length = false;
                if (bRefreshBB) {
                    int gradientTop = 201756;
                    int gradientCenter = 35031;
                    if (CurrentPage == 4) {
                        gradientTop = 16756742;
                        gradientCenter = 16052737;
                    }
                    if (CurrentPage == 7 || CurrentPage == 3) {
                        gradientTop = 16756742;
                        gradientCenter = 16052737;
                    }
                    int listSelectionColor = 0xFFFFFF;
                    IGP.drawGradient(_gBB, 0, 0, 240, 320, gradientTop, gradientCenter);
                    IGP.drawSoftkeys(_gBB);
                    int image_y = 10;
                    int text_y = 39;
                    int text_anchor = 17;
                    boolean bDrawPageImage = PageImages[CurrentPage] != null;
                    boolean bDrawPageText = true;
                    if (CurrentPage == 4) {
                        image_y = 43;
                    }
                    if (CurrentPage < 3) {
                        image_y = 15;
                        text_y = 160 + (15 + PageImages[CurrentPage].getHeight()) / 2;
                        text_anchor = 3;
                    } else if (!bIsListPage) {
                        text_anchor = 3;
                        text_y = 160;
                    }
                    if (CurrentPage == 3) {
                        if (s_textPt != null && s_textPt.length() > 0) {
                            text_y = 120;
                            IGP.drawString(s_textPt, _gBB, 120, 220, 3);
                        }
                        _gBB.drawImage(PagePromotionImage, 120, text_y, 3);
                    }
                    if (CurrentPage == 7) {
                        _gBB.drawImage(PageCatalogueImage, 120, text_y, 3);
                        drawColor = 1;
                    }
                    if (bIsListPage) {
                        int reduce_space_h = 0;
                        int list_vspace = Math.max(2 * fontHeight, LIST_Images[currentList][ValidLISTIdx[currentList][0]].getHeight()) - reduce_space_h;
                        bDetermineSizeOnly = true;
                        IGP.drawString(pageTextId, null, 0, 0, 0);
                        int list_y = text_y + s_text_h;
                        int arrow_height = 14;
                        int listArea_maxHeight = 320 - list_y - 10;
                        LIST_visibleItemCount = currentList_nbItems;
                        if (listArea_maxHeight / (list_vspace += 8) < currentList_nbItems) {
                            LIST_visibleItemCount = (listArea_maxHeight - 2 * arrow_height) / list_vspace;
                        }
                        int y = list_y += (listArea_maxHeight - LIST_visibleItemCount * list_vspace) / 2 + 5;
                        if (LIST_visibleItemCount < currentList_nbItems) {
                            if (s_ItemListIndex > 0) {
                                IGP.drawArrow(_gBB, 120, list_y - arrow_height, 16, 65535, true, false);
                            }
                            if (s_ItemListIndex < currentList_nbItems - 1) {
                                IGP.drawArrow(_gBB, 120, list_y + LIST_visibleItemCount * list_vspace + arrow_height, 16, 65535, true, true);
                            }
                        }
                        y = list_y + list_vspace / 2;
                        for (int i = s_igpListDisplayItemStart; i < s_igpListDisplayItemStart + LIST_visibleItemCount; ++i) {
                            int item = ValidLISTIdx[currentList][i];
                            _gBB.drawImage(LIST_Images[currentList][item], 25, y, 6);
                            if (item == LIST_Texts[currentList].length - 1) {
                                drawColor = 1;
                            }
                            IGP.drawString(LIST_Texts[currentList][item], _gBB, 25 + LIST_Images[currentList][item].getWidth() + 3, y + 0, 6);
                            y += list_vspace;
                        }
                        int selIndex = s_ItemListIndex - s_igpListDisplayItemStart;
                        int sel_x = 23;
                        int sel_h = list_vspace;
                        int sel_y = list_y + list_vspace * selIndex;
                        int sel_w = 240 - 2 * sel_x;
                        _gBB.setColor(listSelectionColor);
                        _gBB.drawRect(sel_x, sel_y, sel_w, sel_h);
                        drawColor = 1;
                    }
                    if (bDrawPageImage) {
                        _gBB.drawImage(PageImages[CurrentPage], 120, image_y, 17);
                    }
                    if (bDrawPageText) {
                        IGP.drawString(pageTextId, _gBB, 120, text_y, text_anchor);
                    }
                }
                g.drawImage(_imgBB, 0, 0, 0);
                if (System.currentTimeMillis() % 1000L > 500L) {
                    IGP.drawFlashingBox(g);
                }
                if (ValidPages <= 1) break;
                int interval = Math.abs(Math.abs((int)System.currentTimeMillis()) / 50 % 14 - 7) - 3;
                int img4 = 1;
                int img6 = 3;
                if (_redArrowLeft) {
                    img4 = 0;
                    ++_arrowPressedCounter;
                }
                g.drawImage(GlobalImages[img4], 2 + interval, 160, 6);
                if (_redArrowRight) {
                    img6 = 2;
                    ++_arrowPressedCounter;
                }
                g.drawImage(GlobalImages[img6], 238 - interval, 160, 10);
                if (_arrowPressedCounter <= 4) break;
                _redArrowLeft = false;
                _redArrowRight = false;
                _arrowPressedCounter = 0;
            }
        }
        bRefreshBB = false;
    }

    public static void drawArrow(Graphics g, int x, int y, int height, int fillColor, boolean rotate, boolean flip) {
        int iFlip;
        int n = iFlip = flip ? -1 : 1;
        if (height % 2 == 0) {
            --height;
        }
        g.setColor(0xFFFFFF);
        if (rotate) {
            g.fillTriangle(x, y, x - (height >> 1), y + iFlip * (height >> 1), x + (height >> 1), y + iFlip * (height >> 1));
        } else {
            g.fillTriangle(x, y, x - iFlip * (height >> 1), y - (height >> 1), x - iFlip * (height >> 1), y + (height >> 1));
        }
        g.setColor(fillColor);
        if (rotate) {
            g.fillTriangle(x, y + iFlip, x - (height >> 1) + 2, y + iFlip * (height >> 1) - iFlip, x + (height >> 1) - 2, y + iFlip * (height >> 1) - iFlip);
        } else {
            g.fillTriangle(x - iFlip, y, x - iFlip * (height >> 1) + iFlip, y - (height >> 1) + 2, x - iFlip * (height >> 1) + iFlip, y + (height >> 1) - 2);
        }
    }

    public static void drawFlashingBox(Graphics g) {
        if (bDisplayButton) {
            g.setColor(s_box_color);
            g.fillRect(box_x, box_y, box_w, box_h);
            drawColor = 1;
            IGP.drawString(iButtonStringId, g, 120, box_y + (box_h >> 1) + -1, 3);
        }
    }

    public static void drawSoftkeys(Graphics g) {
        boolean invertSoftkeys = true;
        if ((s_displaySoftKeys & 1) != 0) {
            g.drawImage(GlobalImages[5], 2, 318, 36);
        }
        if ((s_displaySoftKeys & 2) != 0) {
            g.drawImage(GlobalImages[4], 238, 318, 40);
        }
    }

    static {
        char_spacing = 0;
        line_spacing = 0;
        PAGE_LIST_PREFIXES = new String[]{"URL-WN", "URL-BS", URL_PREFIX};
    }
}

