/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FontText {
    private static byte[] fontX;
    private static byte[] fontY;
    private static byte[] fontW;
    private static byte fontH;
    private static byte fontSpace;
    private static byte fontDx;
    private static String mapFile;
    private static byte[][] mTexts;
    private static short[][] mTextIndexes;
    public static final int AA_LT = 0;
    public static final int AA_LC = 4;
    public static final int AA_LB = 8;
    public static final int AA_CT = 1;
    public static final int AA_CC = 5;
    public static final int AA_CB = 9;
    public static final int AA_RT = 2;
    public static final int AA_RC = 6;
    public static final int AA_RB = 10;
    public static final int[] anchorShift;
    public static final byte TCHAR_SPACE = -1;
    public static final byte TCHAR_NEW_LINE = -2;
    public static byte[][] lang;
    public static int curLang;
    public static byte[] f2;
    public static Image fontImg;

    public static final void loadFonts(String name) {
        try {
            DataInputStream dis = EIo.getFile(name + ".def");
            int num = dis.readByte() & 0xFF;
            fontX = EIo.readByteArray(dis, num);
            fontY = EIo.readByteArray(dis, num);
            fontW = EIo.readByteArray(dis, num);
            fontH = dis.readByte();
            fontSpace = dis.readByte();
            fontDx = dis.readByte();
            fontDx = 1;
            dis.close();
            FontText.loadMap(name + ".map", num);
            byte[] a = FontText.stringToByte("A");
            System.out.println(num);
            System.out.println(139);
            System.out.println(fontX[a[0]] + "");
            System.out.println(fontY[a[0]] + "");
            f2 = EIo.loadObjects((short)3)[0];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final void loadMap(String s, int num) {
        DataInputStream dis = EIo.getFile(s);
        mapFile = "";
        try {
            dis.skip(2L);
            int cnt = 0;
            while (cnt < num) {
                int c1 = dis.read();
                int c2 = dis.read();
                int code = (c2 & 0xFF) << 8 | c1 & 0xFF;
                char c = (char)code;
                if (c == '\n') {
                    ++cnt;
                }
                mapFile = mapFile + c;
            }
            try {
                dis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void loadTexts(String name) {
        int cnt = 0;
        while (Menu.fileExist("/t" + cnt)) {
            ++cnt;
        }
        mTextIndexes = new short[cnt][];
        mTexts = new byte[cnt][];
        for (int i = 0; i < cnt; ++i) {
            try {
                DataInputStream dis = EIo.getFile(name + "" + i);
                FontText.mTextIndexes[i] = EIo.readShortArray(dis, dis.readUnsignedShort());
                FontText.mTexts[i] = EIo.readByteArray(dis, dis.readUnsignedShort());
                dis.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static final void renderText(Graphics g, int textId, int x, int y, int anchor, int scale) {
        if (textId != -1) {
            byte[] txt = FontText.textByIndex(textId, curLang);
            FontText.renderText(g, txt, x, y, anchor, scale);
        }
    }

    public static final void renderText(Graphics g, byte[] text, int x, int y, int anchor, int scale) {
        FontText.renderText(g, text, 0, text.length, x, y, anchor, scale);
    }

    public static final void renderText(Graphics g, byte[] text, int indexFrom, int indexTo, int x, int y, int anchor, int scale, int[] colors) {
        try {
            if ((anchor & 3) != 0) {
                x += FontText.anchorOffset(anchor & 3, FontText.textWidth(text, indexFrom, indexTo, scale));
            }
            if (anchor >>> 2 != 0) {
                y += FontText.anchorOffset(anchor >>> 2, FontText.textHeight(scale));
            }
            for (int i = indexFrom; i < indexTo; ++i) {
                x += FontText.renderSymbol(g, text[i] & 0xFF, x, y, 0, scale, colors);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        g.setClip(0, 0, Menu.W, Menu.H);
    }

    public static final void renderText(Graphics a_g, byte[] a_Text, int a_iIndexFrom, int a_iIndexTo, int a_iX, int a_iY, int a_iAnchorXY, int scale) {
        FontText.renderText(a_g, a_Text, a_iIndexFrom, a_iIndexTo, a_iX, a_iY, a_iAnchorXY, scale, new int[]{0, 0xFFFFFF});
    }

    public static final int renderSymbol(Graphics g, int symbolId, int x, int y, int anchor, int scale, int[] colors) {
        int symbolW = FontText.symbolWidth(symbolId, scale);
        if (symbolId < fontX.length) {
            int iSymbolH = FontText.textHeight(scale);
            x += FontText.anchorOffset(anchor & 3, symbolW);
            y += FontText.anchorOffset(anchor >>> 2, iSymbolH);
            if (symbolId >= 0 && symbolId < fontX.length) {
                Painter.renderPieceOfShape(g, f2, x, y, fontX[symbolId], fontY[symbolId], fontW[symbolId], fontH, colors, scale);
            } else {
                symbolW += 6;
            }
        }
        return symbolW;
    }

    public static final int symbolWidth(int symbolId, int scale) {
        int ID = symbolId & 0xFF;
        if (ID < 0 || ID >= fontW.length) {
            return fontSpace;
        }
        return fontW[ID] * Painter.pixelW * scale;
    }

    public static final int textWidth(int textId, int lang, int scale) {
        return FontText.textWidth(mTexts[lang], mTextIndexes[lang][textId], mTextIndexes[lang][textId + 1], scale);
    }

    public static final int textWidth(byte[] text, int indexFrom, int indexTo, int scale) {
        int result = 0;
        if (indexFrom < indexTo) {
            byte dx = fontDx;
            for (int i = indexFrom; i < indexTo; ++i) {
                result += FontText.symbolWidth(text[i], scale) + dx;
            }
            result -= dx;
        }
        return result;
    }

    public static final int textHeight() {
        return fontH * Painter.pixelH;
    }

    public static final int textHeight(int scale) {
        return fontH * Painter.pixelH * scale;
    }

    public static final int anchorOffset(int anchor, int size) {
        return -(size >>> anchorShift[anchor]);
    }

    public static final byte[] textByIndex(int index, int lang) {
        byte[] byArray;
        if (index >= 0) {
            byArray = FontText.submass_of_mass(mTexts[lang], FontText.textIndex(index, lang), FontText.textLength(index, lang));
        } else {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = -1;
        }
        byte[] temp = byArray;
        switch (index) {
            case -2: {
                temp = FontText.submass_of_mass(mTexts[lang], FontText.textIndex(11, lang), FontText.textLength(11, lang));
                temp = FontText.concatTexts(temp, FontText.textByIndex(Data.isSoundOn ? 15 : 16, lang), (byte)-1);
                break;
            }
            case -3: {
                temp = FontText.submass_of_mass(mTexts[lang], FontText.textIndex(12, lang), FontText.textLength(12, lang));
                temp = FontText.concatTexts(temp, FontText.textByIndex(Data.isVibraOn ? 15 : 16, lang), (byte)-1);
                break;
            }
            default: {
                if (index > -10) break;
                int lan = -index - 10;
                temp = FontText.submass_of_mass(mTexts[lan], FontText.textIndex(0, lan), FontText.textLength(0, lan));
            }
        }
        return temp;
    }

    public static final int textIndex(int index, int lang) {
        return mTextIndexes[lang][index] & 0xFFFF;
    }

    public static final int textLength(int index, int lang) {
        return FontText.textIndex(index + 1, lang) - FontText.textIndex(index, lang);
    }

    public static byte[] submass_of_mass(byte[] mass, int ind, int lenght) {
        byte[] result = new byte[lenght];
        System.arraycopy(mass, ind, result, 0, result.length);
        return result;
    }

    public static final byte[] concatTexts(byte[] text1, byte[] text2, byte delim) {
        byte[] res = new byte[text1.length + text2.length + 1];
        System.arraycopy(text1, 0, res, 0, text1.length);
        res[text1.length] = delim;
        System.arraycopy(text2, 0, res, text1.length + 1, text2.length);
        return res;
    }

    public static short[] parseText(int textId, int wid, int scale) {
        return FontText.parseText(mTexts[curLang], mTextIndexes[curLang][textId], mTextIndexes[curLang][textId + 1], wid, scale);
    }

    public static short[] parseText(byte[] text, int indFrom, int indTo, int width, int scale) {
        int i;
        if (text == null || width == 0) {
            return null;
        }
        int[] result = new int[100];
        int a_first = indFrom;
        int a_second = indFrom;
        int row = 0;
        for (i = indFrom; i < indTo; ++i) {
            if (text[i] == -2) {
                if (FontText.textWidth(text, a_first, i, scale) >= width) {
                    result[row++] = a_first;
                    result[row++] = a_second + 1;
                } else {
                    result[row++] = a_first;
                }
                a_first = i + 1;
                a_second = i + 1;
                continue;
            }
            if (text[i] != -1) continue;
            if (FontText.textWidth(text, a_first, i, scale) >= width) {
                result[row++] = a_first;
                a_first = a_second + 1;
            }
            a_second = i;
        }
        if (FontText.textWidth(text, a_first, i, scale) >= width) {
            result[row++] = a_first;
            result[row++] = a_second + 1;
        } else {
            result[row++] = a_first;
        }
        short[] lastRes = new short[row + 1];
        for (int j = 0; j < row; j = (int)((byte)(j + 1))) {
            lastRes[j] = (short)result[j];
        }
        lastRes[row] = (short)indTo;
        return lastRes;
    }

    public static int renderParseText(Graphics g, short[] massTextId, int scroll_poss, int[] rect, int align, int scale) {
        byte[] _Text = mTexts[curLang];
        return FontText.renderParseText(g, _Text, massTextId, scroll_poss, rect, align, scale);
    }

    public static int renderParseText(Graphics g, byte[] _Text, short[] massTextId, int scroll_poss, int[] rect, int align, int scale) {
        if (massTextId == null || _Text == null) {
            return scroll_poss;
        }
        int cntLine = (rect[3] - rect[1]) / FontText.textHeight(scale);
        int start_h = (rect[3] - rect[1] - Math.min(cntLine, massTextId.length - 1) * FontText.textHeight(scale)) / 2;
        if (Menu.keys[Menu.UP]) {
            if (scroll_poss > 0) {
                --scroll_poss;
            }
            if (scroll_poss < 0) {
                scroll_poss = 0;
            }
        } else if (Menu.keys[Menu.DOWN] && massTextId.length > cntLine) {
            if (scroll_poss < massTextId.length - 1 - cntLine) {
                ++scroll_poss;
            }
            if (cntLine > massTextId.length) {
                scroll_poss = 0;
                cntLine = massTextId.length - 1 - cntLine;
            }
        }
        if (scroll_poss < 0) {
            scroll_poss = 0;
        }
        for (int i = scroll_poss; i < scroll_poss + cntLine; ++i) {
            if (i + 1 >= massTextId.length) continue;
            int _x = (rect[2] + rect[0]) / 2;
            int _y = start_h + rect[1] + FontText.textHeight(scale) * (i - scroll_poss);
            if (align == 0) {
                _x = rect[0] + 2;
                _y = rect[1] + FontText.textHeight(scale) * (i - scroll_poss);
            } else if (align == 2) {
                _x = rect[2] - 3;
                _y = rect[1] + FontText.textHeight(scale) * (i - scroll_poss);
            } else {
                align = 1;
            }
            FontText.renderText(g, _Text, massTextId[i], massTextId[i + 1], _x, _y, align, scale);
        }
        return scroll_poss;
    }

    public static final byte[] stringToByte(String s) {
        int k = 0;
        byte[] res = new byte[s.length()];
        try {
            block2: for (int i = 0; i < s.length(); ++i) {
                k = 0;
                if (s.charAt(i) == ' ') {
                    res[i] = -1;
                    continue;
                }
                if (s.charAt(i) == '\n') {
                    res[i] = -2;
                    continue;
                }
                if (s.charAt(i) == '\r') {
                    res[i] = -1;
                    continue;
                }
                for (int j = 0; j < mapFile.length(); ++j) {
                    if (mapFile.charAt(j) == '\n') {
                        k = (byte)(k + 1);
                    }
                    if (mapFile.charAt(j) == s.charAt(i)) {
                        res[i] = k;
                        continue block2;
                    }
                    res[i] = -1;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static int getFontCng() {
        return mTextIndexes.length;
    }

    static {
        anchorShift = new int[]{31, 1, 0};
        curLang = 0;
    }
}

