/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Bullet
extends Shape {
    public double realX;
    public double previousStepX;
    public double realY;
    public double previousStepY;
    public double delta;
    public double deltaX;
    public double deltaY;
    public double deltaStepX;
    public double deltaStepY;
    public double deltaStepsCount;
    double tempDouble;
    public double speedX = 1.0;
    public double newSpeedX = 1.0;
    public double fullSpeedX;
    public double speedY = 1.0;
    public double newSpeedY = 1.0;
    public double fullSpeedY;
    public double forsage = 1.0;
    public double newForsage = 1.0;
    public double bulletTailWidthCoefficient = 1.0;
    public double speedModule = Tools.precision * Tools.precision;
    short tempShort;
    boolean tempBoolean;
    public boolean intersectedX;
    public boolean intersectedY;
    public boolean moved = false;
    public short courseX = 1;
    public short newCourseX = 1;
    public boolean isChangingCourseX = true;
    public short courseY = 1;
    public short newCourseY = 1;
    public boolean isChangingCourseY = true;
    public long forsageTime = -1L;
    public long newForsageTime = -1L;
    public boolean burn = false;
    public long burnTime = -1L;
    public int bulletTailWidth;
    public int bulletTailHeight;
    public short[] previousPosition = new short[2];
    public boolean isMoving = false;
    public long movingLastTime = 0L;
    public long currentTime = 0L;
    short[] bulletTail;
    short[] bulletTailX;
    short[] bulletTailY;
    public long tailLastTime = 0L;
    public long tailCurrentTime = 0L;

    public void setSpeed(double speedX, double speedY, double forsage) {
        this.speedX = speedX;
        this.speedY = speedY;
        this.newSpeedX = speedX;
        this.newSpeedY = speedY;
        this.forsage = forsage;
        this.newForsage = forsage;
        this.deltaX = 0.0;
        this.deltaY = 0.0;
        this.deltaStepsCount = 0.0;
        this.fullSpeedX = speedX * forsage;
        this.fullSpeedY = speedY * forsage;
        this.delta = Math.max(this.fullSpeedX, this.fullSpeedY);
        if (this.delta == 0.0) {
            this.deltaStepX = 0.0;
            this.deltaStepY = 0.0;
        } else {
            this.delta = Tools.roundPrecision(this.delta);
            this.deltaStepX = this.fullSpeedX / this.delta;
            this.deltaStepY = this.fullSpeedY / this.delta;
        }
    }

    public void setPosition(short x, short y) {
        super.setPosition(x, y);
        this.applyXY();
    }

    public void restoreTime() {
        this.setCurrentTime();
        if (this.forsageTime != -1L) {
            this.forsageTime += this.currentTime - Level.savedTime;
        }
        if (this.newForsageTime != -1L) {
            this.newForsageTime += this.currentTime - Level.savedTime;
        }
        if (this.burnTime != -1L) {
            this.burnTime += this.currentTime - Level.savedTime;
        }
    }

    public void setType(short newType) {
        this.type = newType;
        if (this.isUsingMask) {
            this.setColor(Data.BULLET_COLORS[newType]);
        } else {
            this.imageOrMaskIndex = (short)Data.BULLET_IMAGE_INDEXES[newType];
            this.setScale(1);
        }
    }

    private void setCurrentTime() {
        this.currentTime = System.currentTimeMillis();
    }

    public void setMoving(boolean setIsMoving) {
        this.isMoving = setIsMoving;
        if (this.isMoving) {
            this.setCurrentTime();
            this.movingLastTime = this.currentTime;
        }
    }

    public void changeCourse() {
        if (!this.isChangingCourseX && !this.isChangingCourseY) {
            return;
        }
        if (this.intersectedX && this.isChangingCourseX) {
            this.newCourseX = this.courseX = (short)(-this.courseX);
        }
        if (this.intersectedY && this.isChangingCourseY) {
            this.newCourseY = this.courseY = (short)(-this.courseY);
        }
    }

    public void exchangeCourseAndSpeed(Bullet b) {
        if (!this.isChangingCourseX && !this.isChangingCourseY) {
            return;
        }
        if (this.isChangingCourseX) {
            this.newCourseX = b.courseX;
            b.newCourseX = this.courseX;
            this.newSpeedX = b.speedX;
            b.newSpeedX = this.speedX;
        }
        if (this.isChangingCourseY) {
            this.newCourseY = b.courseY;
            b.newCourseY = this.courseY;
            this.newSpeedY = b.speedY;
            b.newSpeedY = this.speedY;
        }
        if (this.isChangingCourseX || this.isChangingCourseY) {
            this.newForsage = b.forsage;
            b.newForsage = this.forsage;
            this.newForsageTime = b.forsageTime;
            b.newForsageTime = this.forsageTime;
        }
    }

    public boolean intersect(Bullet b) {
        boolean tempBoolean = this.intersect((Shape)b);
        if (tempBoolean) {
            if (this.right == b.left && this.courseX > 0 || this.left == b.right && this.courseX < 0) {
                this.newCourseX = -this.courseX;
            }
            if (this.bottom == b.top && this.courseY > 0 || this.top == b.bottom && this.courseY < 0) {
                this.newCourseY = -this.courseY;
            }
            this.newSpeedX = b.speedX;
            this.newSpeedY = b.speedY;
        }
        return tempBoolean;
    }

    public boolean touchScreen() {
        if (!this.moved) {
            return false;
        }
        this.tempBoolean = false;
        if (this.left == Painter.screenLeftBoard && this.courseX < 0 || this.right == Painter.screenRightBoard && this.courseX > 0) {
            this.tempBoolean = true;
            this.intersectedX = true;
        }
        if (this.top == Painter.screenTopBoard && this.courseY < 0 || this.bottom == Painter.screenBottomBoard && this.courseY > 0) {
            if (this.bottom == Painter.screenBottomBoard && this.courseY > 0) {
                return false;
            }
            this.tempBoolean = true;
            this.intersectedY = true;
        }
        return this.tempBoolean;
    }

    public void touchAction(Shape s) {
        s.touched = true;
        if (s.type == 2) {
            switch (s.bonus) {
                case 1: {
                    this.setEffect((short)1);
                    break;
                }
                case 2: {
                    this.setEffect((short)2);
                    break;
                }
                case 4: {
                    this.setEffect((short)3);
                    break;
                }
                case 3: {
                    if (Some.bullets.objectsCount >= 5) break;
                    Some.bullets.additionalBullets(this);
                    Background.addMessage(34);
                    break;
                }
                case 5: {
                    Level.scoreX = 5;
                    Level.scoreXtime = System.currentTimeMillis();
                    Background.addMessage(38);
                    break;
                }
                case 6: {
                    Some.ship.setType((short)2);
                    Ship.widthTime = System.currentTimeMillis();
                    Background.addMessage(39);
                }
            }
        }
    }

    public boolean touchCorner(Shape s) {
        return this.touchCorner(s, false);
    }

    public boolean touchCorner(Shape s, boolean checkForBurnAndDestroyed) {
        this.tempBoolean = false;
        if (!this.moved) {
            return false;
        }
        if (this.intersectedX || this.intersectedY) {
            return false;
        }
        if ((this.courseX > 0 && this.right == s.left - 1 || this.courseX < 0 && this.left == s.right + 1) && (this.courseY > 0 && this.bottom == s.top - 1 || this.courseY < 0 && this.top == s.bottom + 1)) {
            this.tempBoolean = true;
            if (!checkForBurnAndDestroyed || !this.burn) {
                this.intersectedX = true;
                this.intersectedY = true;
            }
        }
        if (this.tempBoolean) {
            if (checkForBurnAndDestroyed && this.burn) {
                this.tempBoolean = false;
                if (!s.destroyed) {
                    Some.deads.add(s);
                    s.destroyed = true;
                }
            } else {
                this.touchAction(s);
            }
        }
        return this.tempBoolean;
    }

    public boolean touch(Shape s) {
        return this.touch(s, false);
    }

    public boolean touch(Shape s, boolean checkForBurnAndDestroyed) {
        if (!this.moved) {
            return false;
        }
        if (checkForBurnAndDestroyed && s.destroyed) {
            return false;
        }
        this.tempBoolean = false;
        if ((this.left == s.right + 1 && this.courseX < 0 || this.right == s.left - 1 && this.courseX > 0) && this.top <= s.bottom && this.bottom >= s.top) {
            this.tempBoolean = true;
            if (!checkForBurnAndDestroyed || !this.burn) {
                this.intersectedX = true;
            }
        }
        if ((this.top == s.bottom + 1 && this.courseY < 0 || this.bottom == s.top - 1 && this.courseY > 0) && this.left <= s.right && this.right >= s.left) {
            this.tempBoolean = true;
            if (!checkForBurnAndDestroyed || !this.burn) {
                this.intersectedY = true;
            }
        }
        if (this.tempBoolean) {
            if (checkForBurnAndDestroyed && this.burn) {
                this.tempBoolean = false;
                if (!s.destroyed) {
                    Some.deads.add(s);
                    s.destroyed = true;
                }
            } else {
                this.touchAction(s);
            }
        }
        return this.tempBoolean;
    }

    private void clearDelta() {
        this.deltaX = 0.0;
        this.deltaY = 0.0;
        this.deltaStepsCount = 0.0;
    }

    public void prepare() {
        this.moved = false;
        if (!this.isMoving) {
            return;
        }
        this.setCurrentTime();
        if (this.movingLastTime + 1L > this.currentTime) {
            return;
        }
        this.movingLastTime = this.currentTime;
        this.intersectedX = false;
        this.intersectedY = false;
        this.setDelta();
        this.previousPosition[0] = this.x;
        this.previousPosition[1] = this.y;
        this.previousStepX = this.realX;
        this.previousStepY = this.realY;
        this.newCourseX = this.courseX;
        this.newCourseY = this.courseY;
        this.newForsageTime = this.forsageTime;
        this.moved = true;
    }

    public void applyIntersection() {
        if (this.intersectedX || this.intersectedY) {
            this.applyXY();
        }
    }

    public void applyCourse() {
        this.courseX = this.newCourseX;
        this.courseY = this.newCourseY;
        this.setSpeed(this.newSpeedX, this.newSpeedY, this.newForsage);
        this.forsageTime = this.newForsageTime;
    }

    public void duplicate(Bullet b) {
        super.duplicate(b);
        this.intersectedX = b.intersectedX;
        this.intersectedY = b.intersectedY;
        this.setSpeed(b.speedX, b.speedY, b.forsage);
        this.speedModule = b.speedModule;
        this.realX = b.realX;
        this.previousStepX = b.previousStepX;
        this.courseX = b.courseX;
        this.newCourseX = b.newCourseX;
        this.isChangingCourseX = b.isChangingCourseX;
        this.realY = b.realY;
        this.previousStepY = b.previousStepY;
        this.courseY = b.courseY;
        this.newCourseY = b.newCourseY;
        this.isChangingCourseY = b.isChangingCourseY;
        this.forsageTime = b.forsageTime;
        this.newForsageTime = b.newForsageTime;
        this.burn = b.burn;
        this.burnTime = b.burnTime;
        this.isMoving = b.isMoving;
        this.movingLastTime = b.movingLastTime;
        this.tailLastTime = b.tailLastTime;
        this.bulletTailWidth = b.bulletTailWidth;
        this.bulletTailHeight = b.bulletTailHeight;
        this.bulletTailWidthCoefficient = b.bulletTailWidthCoefficient;
        System.arraycopy(b.previousPosition, 0, this.previousPosition, 0, b.previousPosition.length);
        this.bulletTail = new short[b.bulletTail.length];
        this.bulletTailX = new short[b.bulletTailX.length];
        this.bulletTailY = new short[b.bulletTailY.length];
        System.arraycopy(b.bulletTail, 0, this.bulletTail, 0, b.bulletTail.length);
        System.arraycopy(b.bulletTailX, 0, this.bulletTailX, 0, b.bulletTailX.length);
        System.arraycopy(b.bulletTailY, 0, this.bulletTailY, 0, b.bulletTailY.length);
    }

    public void transfer(int deltaX, int deltaY) {
        this.setPosition((short)(this.x + deltaX), (short)(this.y + deltaY));
    }

    public void render(Graphics g) {
        this.renderTail(g);
        super.render(g);
    }

    public void setEffect(short curEffect) {
        switch (curEffect) {
            case 1: {
                Some.bullets.setEffect((short)1);
                break;
            }
            case 2: {
                Some.bullets.setEffect((short)2);
                break;
            }
            case 3: {
                this.burn = true;
                this.burnTime = this.currentTime;
                this.setType((short)2);
                Background.addMessage(33);
            }
        }
    }

    public void checkEffects() {
        this.setCurrentTime();
        if (this.forsageTime >= 0L && this.forsageTime + 20000L < this.currentTime) {
            this.forsageTime = -1L;
            this.newForsageTime = -1L;
            this.setSpeed(this.speedX, this.speedY, Tools.precision);
        }
        if (this.burnTime >= 0L && this.burnTime + 20000L < this.currentTime) {
            this.burn = false;
            this.burnTime = -1L;
            this.setType((short)1);
        }
    }

    public void createTail() {
        this.bulletTail = new short[this.width * 10 / 3];
        this.bulletTailX = new short[this.width * 10 / 3];
        this.bulletTailY = new short[this.width * 10 / 3];
        this.setCurrentTime();
        this.tailLastTime = this.currentTime;
    }

    public void clearTail() {
        for (int i = 0; i < this.bulletTail.length; ++i) {
            this.bulletTail[i] = 0;
        }
    }

    public void updateTail() {
        this.setCurrentTime();
        if (this.tailLastTime + 1L > this.currentTime) {
            return;
        }
        this.tailLastTime = this.currentTime;
        for (int i = this.bulletTail.length - 1; i > 0; --i) {
            this.bulletTail[i] = (short)(this.bulletTail[i] - 5);
        }
        short tmpPositionX = this.previousPosition[0];
        short tmpPositionY = this.previousPosition[1];
        int tmpDeltaX = this.x - tmpPositionX;
        int tmpDeltaY = this.y - tmpPositionY;
        int tmpDeltaI = Math.abs(tmpDeltaX);
        int tmpDeltaJ = Math.abs(tmpDeltaY);
        int tmpCourseX = 1;
        int tmpCourseY = 1;
        if (tmpDeltaI != 0) {
            tmpCourseX = tmpDeltaX / tmpDeltaI;
        }
        if (tmpDeltaJ != 0) {
            tmpCourseY = tmpDeltaY / tmpDeltaJ;
        }
        int count = this.width / (2 * Painter.basicScale);
        do {
            for (int i = 0; i <= tmpDeltaI && count != 0; ++i) {
                for (int j = 0; j <= tmpDeltaJ && count != 0; ++j) {
                    if (Background.rnd(5) != 1) continue;
                    System.arraycopy(this.bulletTail, 0, this.bulletTail, 1, this.bulletTail.length - 1);
                    System.arraycopy(this.bulletTailX, 0, this.bulletTailX, 1, this.bulletTailX.length - 1);
                    System.arraycopy(this.bulletTailY, 0, this.bulletTailY, 1, this.bulletTailY.length - 1);
                    this.bulletTail[0] = 100;
                    this.bulletTailX[0] = (short)(tmpPositionX + this.width / 2 + tmpCourseX * i);
                    this.bulletTailY[0] = (short)(tmpPositionY + this.height / 2 + tmpCourseY * j);
                    if (tmpDeltaI > tmpDeltaJ) {
                        this.bulletTailY[0] = count % 2 == 0 ? (short)(this.bulletTailY[0] + Math.abs(Background.rnd(this.height / 2) - j)) : (short)(this.bulletTailY[0] - Math.abs(Background.rnd(this.height / 2) - j));
                    } else {
                        this.bulletTailX[0] = count % 2 == 0 ? (short)(this.bulletTailX[0] + Math.abs(Background.rnd(this.width / 2) - i)) : (short)(this.bulletTailX[0] - Math.abs(Background.rnd(this.width / 2) - i));
                    }
                    --count;
                }
            }
        } while (count > 0);
    }

    private void renderTail(Graphics g) {
        for (int i = 0; i < this.bulletTail.length; ++i) {
            if (this.bulletTail[i] <= 0 || this.bulletTailX[i] <= 0 || this.bulletTailY[i] <= 0) continue;
            short _x = this.bulletTailX[i];
            short _y = this.bulletTailY[i];
            int pos = Math.min(_x / Background.BAR_W + _y / Background.BAR_H * Background.X, Background.pallete.length - 1);
            int curColor = Background.pallete[pos];
            int color = Background.getColorByIntens(0xFFFFFF, 100 - this.bulletTail[i], curColor);
            g.setColor(color);
            g.fillRect(_x * Painter.pixelW, _y * Painter.pixelH, Painter.basicScale, Painter.basicScale);
        }
    }

    public void applyXY() {
        this.realX = this.x * Tools.precision;
        this.realY = this.y * Tools.precision;
    }

    public boolean stepForwardForTest() {
        if (!this.moved) {
            return false;
        }
        this.previousStepX = this.realX;
        this.previousStepY = this.realY;
        this.realX += this.speedX * (double)this.courseX;
        this.realY += this.speedY * (double)this.courseY;
        this.x = Tools.roundPrecision(this.realX, 1);
        this.y = Tools.roundPrecision(this.realY, 1);
        this.setBoards();
        return true;
    }

    public boolean stepForward() {
        if (!this.moved) {
            return false;
        }
        if (this.intersectedX || this.intersectedY) {
            return false;
        }
        if (this.deltaX == 0.0 && this.deltaY == 0.0) {
            return false;
        }
        this.previousStepX = this.realX;
        this.previousStepY = this.realY;
        if (this.deltaStepsCount == 0.0) {
            this.realX += this.deltaX * (double)this.courseX;
            this.deltaX = 0.0;
            this.realY += this.deltaY * (double)this.courseY;
            this.deltaY = 0.0;
        } else {
            this.deltaStepsCount -= 1.0;
            this.realX += this.deltaStepX * (double)this.courseX;
            this.deltaX -= this.deltaStepX;
            this.realY += this.deltaStepY * (double)this.courseY;
            this.deltaY -= this.deltaStepY;
        }
        this.x = Tools.roundPrecision(this.realX, 1);
        this.y = Tools.roundPrecision(this.realY, 1);
        this.setBoards();
        return true;
    }

    public void stepBackward() {
        if (!this.moved) {
            return;
        }
        this.realX = this.previousStepX;
        this.realY = this.previousStepY;
        this.x = Tools.roundPrecision(this.realX, 1);
        this.y = Tools.roundPrecision(this.realY, 1);
        this.setBoards();
    }

    private void setDelta() {
        this.deltaX = Tools.roundPrecision(this.fullSpeedX);
        this.deltaY = Tools.roundPrecision(this.fullSpeedY);
        this.delta = Math.max(this.deltaX, this.deltaY);
        if (this.delta == 0.0) {
            this.deltaStepsCount = 0.0;
        } else {
            this.deltaStepsCount = Tools.roundPrecision(this.delta, 0);
            if (this.deltaStepsCount == this.delta * (double)Tools.precision) {
                this.deltaStepsCount -= 1.0;
            }
        }
    }
}

