/*
 * Decompiled with CFR 0.152.
 */
import com.ea.sdk.SDKString;

public class MenuButton {
    public static final int kMaxNumStrings = 4;
    SDKString[] m_pText = new SDKString[4];
    FGImage m_pButtonOff;
    FGImage m_pButtonOn;
    int m_width;
    int m_x;
    int m_y;
    boolean m_selected;
    boolean m_frobbable;
    boolean m_visible;
    int m_currSel;
    int m_numText;
    FGFont m_pFont;

    void init(int n, int n2) {
        FGEAStringManager fGEAStringManager = LifeEngine.getInstance().getStringTable();
        this.initLiteral(fGEAStringManager.getString(n), n2, null);
    }

    void initLiteral(SDKString sDKString, int n) {
        this.initLiteral(sDKString, n, null);
    }

    void initLiteral(SDKString sDKString, int n, FGFont fGFont) {
        this.m_pFont = fGFont == null ? LifeEngine.getInstance().getLargeFont() : fGFont;
        this.m_width = n;
        this.m_pText[0] = sDKString;
        FGResLoader fGResLoader = LifeEngine.getInstance().getResLoader();
        this.m_pButtonOff = fGResLoader.getImage("button_off.png");
        this.m_pButtonOn = fGResLoader.getImage("button_on.png");
        this.setPos(0, 0);
        this.m_selected = false;
        this.m_frobbable = false;
        this.m_visible = true;
        this.m_currSel = 0;
        this.m_numText = 1;
    }

    void drawSelf(FGGraphics fGGraphics) {
        if (!this.m_visible) {
            return;
        }
        int n = this.m_pButtonOff.getWidth() / 3;
        int n2 = this.m_width - 2 * n;
        if (n2 < 0) {
            n2 = 4;
        }
        FGImage fGImage = this.m_selected ? this.m_pButtonOn : this.m_pButtonOff;
        int n3 = fGImage.getHeight();
        fGImage.drawSelf(fGGraphics, this.m_x, this.m_y, 0, 0, n, n3);
        fGImage.drawTiledFromRegion(fGGraphics, this.m_x + n, this.m_y, n2, n3, n, 0, n, n3);
        fGImage.drawSelf(fGGraphics, this.m_x + n + n2, this.m_y, 2 * n, 0, n, fGImage.getHeight());
        FGFont fGFont = this.m_pFont;
        int n4 = fGFont.getDisplayLength(this.m_pText[this.m_currSel]);
        int n5 = fGFont.getHeight();
        int n6 = this.m_x + (this.m_width - n4) / 2;
        if (n6 < 0) {
            n6 = 2;
        }
        int n7 = this.m_y + (this.m_pButtonOff.getHeight() - n5) / 2;
        fGFont.drawText(fGGraphics, this.m_pText[this.m_currSel], n6, n7);
    }

    void addText(int n) {
        this.addTextLiteral(LifeEngine.getInstance().getStringTable().getString(n));
    }

    void addTextLiteral(SDKString sDKString) {
        this.m_pText[this.m_numText] = sDKString;
        this.m_frobbable = true;
        ++this.m_numText;
    }

    void keyPressed(int n) {
        if (this.m_frobbable) {
            switch (n) {
                case 2: 
                case 52: {
                    --this.m_currSel;
                    if (this.m_currSel >= 0) break;
                    this.m_currSel = this.m_numText - 1;
                    break;
                }
                case 5: 
                case 54: {
                    ++this.m_currSel;
                    if (this.m_currSel < this.m_numText) break;
                    this.m_currSel = 0;
                }
            }
            if (n == LifeEngine.getInstance().AVK_FIRE || n == 53) {
                ++this.m_currSel;
                if (this.m_currSel >= this.m_numText) {
                    this.m_currSel = 0;
                }
            }
        }
    }

    int getWidth() {
        return this.m_width;
    }

    int getHeight() {
        return this.m_pButtonOff.getHeight();
    }

    void setPos(int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
    }

    int getX() {
        return this.m_x;
    }

    int getY() {
        return this.m_y;
    }

    void select(boolean bl) {
        this.m_selected = bl;
    }

    int getVal() {
        return this.m_currSel;
    }

    void setVal(int n) {
        this.m_currSel = n;
    }

    void setVisible(boolean bl) {
        this.m_visible = bl;
    }

    boolean getVisible() {
        return this.m_visible;
    }
}

