/*
 * Decompiled with CFR 0.152.
 */
import com.ea.sdk.SDKString;

class FGString {
    private static final int MAX_BUFFER = 2048;
    private String m_string;
    private SDKString m_sdkString;
    private boolean m_bIsSDKString;
    private static SDKString g_buffer = new SDKString(2048, 0);

    public static boolean nativeEquals(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static int nativeLength(String string) {
        return string.length();
    }

    public FGString() {
        this.m_string = "";
        this.clearSDKString();
    }

    private void clearSDKString() {
        this.m_bIsSDKString = false;
        this.m_sdkString = null;
    }

    public void becomeSDKString() {
        if (this.m_bIsSDKString) {
            return;
        }
        this.m_sdkString = new SDKString(this.m_string);
        this.m_bIsSDKString = true;
        this.m_string = null;
    }

    public FGString(String string) {
        this.set(string);
    }

    public FGString(FGString fGString) {
        this.set(fGString);
    }

    public FGString(FGData fGData) {
        this.set(fGData);
    }

    public FGString(FGData fGData, int n) {
        this.set(fGData, n);
    }

    public void set(String string) {
        this.m_string = string;
        this.clearSDKString();
    }

    public void set(FGString fGString) {
        if (fGString.m_bIsSDKString) {
            this.set(fGString.m_sdkString);
        } else {
            this.set(fGString.m_string);
        }
    }

    public void set(FGData fGData) {
        this.set(fGData, 0, fGData.m_dataLength);
    }

    public void set(FGData fGData, int n) {
        this.set(fGData, 0, n);
        this.clearSDKString();
    }

    public void set(FGData fGData, int n, int n2) {
        try {
            this.m_string = new String(fGData.m_data, n, n2, "ISO-8859-1");
        }
        catch (Exception exception) {
            FGEngine.fatal("could not encode string with ISO-8859-1");
        }
        this.clearSDKString();
    }

    public void set(SDKString sDKString) {
        this.m_string = null;
        this.m_sdkString = sDKString;
        this.m_bIsSDKString = true;
    }

    public boolean equals(FGString fGString) {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.equals1");
            return false;
        }
        return this.m_string.equals(fGString.getNativeString());
    }

    public boolean equals(String string) {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.equals2");
            return false;
        }
        return this.getNativeString().equals(string);
    }

    boolean startsWith(String string) {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.startsWith");
            return false;
        }
        return this.getNativeString().startsWith(string);
    }

    boolean endsWith(String string) {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.endsWith");
            return false;
        }
        return this.getNativeString().endsWith(string);
    }

    public int toInt() {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.toInt");
            return 0;
        }
        try {
            return Integer.parseInt(this.m_string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public boolean canParseToInt() {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.canParseToInt");
            return false;
        }
        try {
            Integer.parseInt(this.m_string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public int toIntFromHex() {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.toIntFromHex");
            return 0;
        }
        try {
            return Integer.parseInt(this.m_string, 16);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void add(FGString fGString) {
        if (fGString.m_bIsSDKString) {
            this.add(fGString.m_sdkString);
        } else {
            this.add(fGString.getNativeString());
        }
    }

    public void add(SDKString sDKString) {
        if (!this.m_bIsSDKString) {
            this.becomeSDKString();
        }
        g_buffer.setLength(0);
        g_buffer.append(this.m_sdkString);
        g_buffer.append(sDKString);
        this.m_sdkString = g_buffer.toSDKString();
    }

    public void add(byte by) {
        this.add("" + by);
    }

    public void add(char c2) {
        this.add("" + c2);
    }

    public void add(short s) {
        this.add("" + s);
    }

    public void add(int n) {
        this.add("" + n);
    }

    public void add(long l) {
        this.add("" + l);
    }

    public void add(String string) {
        if (this.m_bIsSDKString) {
            this.add(new SDKString(string));
        } else {
            this.m_string = this.m_string + string;
        }
    }

    public int length() {
        if (this.m_bIsSDKString) {
            return this.m_sdkString.length();
        }
        return this.m_string.length();
    }

    public void outputToConsole() {
        if (this.m_bIsSDKString) {
            System.out.println("(SDK):" + this.m_sdkString.toString());
        } else {
            System.out.println(this.m_string);
        }
    }

    public char charAt(int n) {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.charAt");
            return '\u0000';
        }
        return this.m_string.charAt(n);
    }

    public int indexOf(char c2) {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.indexOf1");
            return -1;
        }
        return this.indexOf(c2, 0);
    }

    public int indexOf(char c2, int n) {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.indexOf2");
            return -1;
        }
        return this.m_string.indexOf(c2, n);
    }

    public int indexOf(FGString fGString) {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.indexOf3");
            return -1;
        }
        return this.indexOf(fGString, 0);
    }

    public int indexOf(FGString fGString, int n) {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.indexOf4");
            return -1;
        }
        int n2 = this.m_string.indexOf(fGString.getNativeString(), n);
        return n2;
    }

    public int indexOf(String string) {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.indexOf5");
            return -1;
        }
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.indexOf6");
            return -1;
        }
        return this.m_string.indexOf(string, n);
    }

    public FGString substring(int n) {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.substring1");
            return null;
        }
        return this.substring(n, this.length());
    }

    public FGString substring(int n, int n2) {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.substring2");
            return null;
        }
        String string = this.m_string.substring(n, n2);
        return new FGString(string);
    }

    public FGString trim() {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.trim");
            return null;
        }
        return new FGString(this.m_string.trim());
    }

    public FGString toLowerCase() {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.toLowerCase");
            return null;
        }
        return new FGString(this.m_string.toLowerCase());
    }

    public FGString toUpperCase() {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.toUpperCase");
            return null;
        }
        return new FGString(this.m_string.toUpperCase());
    }

    public static boolean isWhitespace(char c2) {
        if (c2 == ' ') {
            return true;
        }
        if (c2 == '\t') {
            return true;
        }
        if (c2 == '\r') {
            return true;
        }
        return c2 == '\n';
    }

    public void format(SDKString sDKString, SDKString sDKString2) {
        SDKString[] sDKStringArray = new SDKString[]{sDKString2};
        SDKString sDKString3 = sDKString.replace(sDKStringArray);
        this.set(sDKString3);
    }

    public void format(SDKString sDKString, SDKString sDKString2, SDKString sDKString3) {
        SDKString[] sDKStringArray = new SDKString[]{sDKString2, sDKString3};
        SDKString sDKString4 = sDKString.replace(sDKStringArray);
        this.set(sDKString4);
    }

    public void format(SDKString sDKString, SDKString sDKString2, SDKString sDKString3, SDKString sDKString4) {
        SDKString[] sDKStringArray = new SDKString[]{sDKString2, sDKString3, sDKString4};
        SDKString sDKString5 = sDKString.replace(sDKStringArray);
        this.set(sDKString5);
    }

    public void format(SDKString sDKString, SDKString sDKString2, SDKString sDKString3, SDKString sDKString4, SDKString sDKString5) {
        SDKString[] sDKStringArray = new SDKString[]{sDKString2, sDKString3, sDKString4, sDKString5};
        SDKString sDKString6 = sDKString.replace(sDKStringArray);
        this.set(sDKString6);
    }

    public String getNativeString() {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("getNativeString called on sdk string");
            return "";
        }
        return this.m_string;
    }

    public SDKString getSDKString() {
        if (this.m_bIsSDKString) {
            return this.m_sdkString;
        }
        return new SDKString(this.m_string);
    }

    public int getHash() {
        if (this.m_bIsSDKString) {
            FGEngine.fatal("Invalid state FGString.getHash");
            return 0;
        }
        return FGString.getHash(this.m_string);
    }

    public static int getHash(String string) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = string.charAt(i);
            if (n3 < 0) {
                n3 += 256;
            }
            n2 += n3;
        }
        return n2;
    }
}

