/*
 * Decompiled with CFR 0.152.
 */
class FGAnimation {
    FGPointerList m_frames = new FGPointerList();
    FGTimer m_timer = new FGTimer();
    int m_cycleTime;
    boolean m_bPlayingOnce;

    FGAnimation() {
    }

    void init(int n) {
        this.m_cycleTime = n;
        this.m_bPlayingOnce = false;
        this.m_timer.start(0);
        this.m_frames.clear();
    }

    public void clearArt() {
        this.init(100);
    }

    public FGTimer getTimer() {
        return this.m_timer;
    }

    void init(FGAnimation fGAnimation) {
        this.m_cycleTime = fGAnimation.m_cycleTime;
        this.m_bPlayingOnce = false;
        this.m_frames.clear();
        for (int i = 0; i < fGAnimation.getNumFrames(); ++i) {
            this.m_frames.addPointer(fGAnimation.m_frames.getPointer(i));
        }
        this.m_timer.start(0);
    }

    void addFrame(FGImage fGImage) {
        this.m_frames.addPointer(fGImage);
    }

    void addFrameSet(FGResLoader fGResLoader, String string, String string2, int n, boolean bl, boolean bl2) {
        for (int i = 0; i < n; ++i) {
            FGImage fGImage = fGResLoader.getImageFromSet(string, string2, i, bl, bl2);
            this.addFrame(fGImage);
        }
    }

    int getDuration() {
        return this.m_cycleTime * this.getNumFrames();
    }

    FGImage getFrame(int n) {
        if (n < 0) {
            return null;
        }
        if (n >= this.getNumFrames()) {
            return null;
        }
        return (FGImage)this.m_frames.getPointer(n);
    }

    int getNumFrames() {
        return this.m_frames.getNumPointers();
    }

    void playOnce() {
        this.m_timer.start(this.getDuration());
        this.m_bPlayingOnce = true;
    }

    void restart() {
        this.m_timer.start(this.getDuration());
        this.m_bPlayingOnce = false;
    }

    boolean finishedPlaying() {
        if (!this.m_bPlayingOnce) {
            return false;
        }
        return this.m_timer.isOver();
    }

    public int getCurrentFrameIndex() {
        int n;
        int n2;
        if (this.getNumFrames() == 0) {
            return -1;
        }
        if (!this.m_timer.isPaused()) {
            while (this.m_timer.isOver() && !this.m_bPlayingOnce) {
                n2 = -this.m_timer.remainingTime();
                this.m_timer.start(this.getDuration());
                this.m_timer.advance(n2);
            }
        }
        if ((n = (n2 = this.m_timer.elapsedTime()) / this.m_cycleTime) >= this.getNumFrames()) {
            n = this.getNumFrames() - 1;
        }
        return n;
    }

    FGImage getCurrentFrame() {
        int n = this.getCurrentFrameIndex();
        return this.getFrame(n);
    }

    void pause() {
        this.m_timer.pause();
    }

    void resume() {
        this.m_timer.resume();
    }
}

