/*
 * Decompiled with CFR 0.152.
 */
import com.ea.sdk.SDKString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class ModeGame
extends FGMode {
    public static final int kStateSpinning = 1;
    public static final int kStateChoosePath = 2;
    public static final int kStateShowJob = 3;
    public static final int kStateInit = 4;
    public static final int kStateMoving = 5;
    public static final int kStatePlayerLostJob = 6;
    public static final int kStateAnnouncingPlayer = 7;
    public static final int kStateAnnouncingAICollege = 8;
    public static final int kStateAnnouncingAICareer = 9;
    public static final int kStateWaitingForSpin2Win = 10;
    public static final int kStateShowAIInvestment = 11;
    public static final int kStateRollForStart = 12;
    public static final int kStateGameOver = 13;
    public static final int kStateLostTurn = 14;
    public static final int kStatePNPNextPlayer = 15;
    public static final int kStateShowEvent = 16;
    public static final int kStateQuitting = 17;
    public static final int kStateLookAhead = 18;
    public static final int kStateLookAheadBranchWasCanceled = 19;
    public static final int kStatePowerBar = 20;
    public static final int kShowingJobCards = 21;
    public static final int kStateShowOtherPlayers = 22;
    public static final int kShowingPlayerNewJob = 23;
    public static final int kShowInitialSTW = 24;
    public static final int kStateWaitingForInitialText = 25;
    public static final int kStateShowingWeddingGifts = 26;
    public static final int kStateShowingPension = 27;
    public static final int kStateDrawTutorial = 28;
    public static final int kStateBrowseTexts = 29;
    public static final int kAnnounceTime = 1500;
    public static final int kShowAIJobTime = 3000;
    public static final int kShowInvestmentTime = 3000;
    public static final int kPassNPlay = -1;
    public static final int kMaxNumPlayers = 4;
    public static final int NUM_CARS = 4;
    private static final int kMinSpinTime = 250;
    private static final int kMaxSpinTime = 2000;
    private static final int kPowerBarMax = 100;
    private static final int kPowerBarMaxTimes2 = 200;
    private static final int kPowerBarSpeed = FGFixed.toFixed(185);
    private static final int kInvestmentCost = 10000;
    private static final int kWeddingGiftLarge = 10000;
    private static final int kWeddingGiftSmall = 5000;
    private static final int kPensionAmount = 10000;
    FGTimer dbgTimer = new FGTimer();
    int backState = -1;
    static int val = -2;
    Car[] m_ppCars = new Car[4];
    Board m_pBoard;
    Hud m_pHud;
    Player[] m_pPlayers = new Player[4];
    Player[] m_pTempPlayers = new Player[4];
    int m_numPlayers;
    CareerCardPile m_pCareerCards;
    CollegeCareerCardPile m_pCollegeCareerCards;
    LifeCardPile m_pLifeCardPile;
    ShareTheWealthCardPile m_pShareTheWealthCardPile;
    int m_currState;
    int m_currPlayer;
    boolean m_choosingPaths;
    int[] m_investNums = new int[10];
    int m_humanIdx;
    int m_playerColor;
    int[] m_rollOrder = new int[4];
    int m_currRoller;
    int m_currOrder;
    boolean m_rollingForFirst;
    FGImage[][] m_pCarImgs;
    FGImage[][] m_pCarStartImgs;
    FGImage[][] m_pCarEndImgs;
    FGTimer m_spinTimer = new FGTimer();
    boolean m_timerStarted;
    boolean m_megaPaused;
    FGTimer m_timer = new FGTimer();
    FGString m_scratch = new FGString();
    FGString m_scratchStr = new FGString();
    boolean m_spinningForWedding;
    boolean m_spinningForPension;
    boolean m_loading;
    int m_displayedSpace;
    FGString m_tempStr = new FGString();
    int m_powerBarPos;
    SDKString m_1X;
    SDKString m_2X;
    SDKString m_turns;
    LifeEngine m_pLifeEngine = LifeEngine.getInstance();
    boolean m_isPNP = false;
    boolean m_hidePopupPending;

    static void registerNeededImages(FGResLoader fGResLoader) {
        fGResLoader.registerImage("port1.png");
        fGResLoader.registerImage("port2.png");
        fGResLoader.registerImage("port3.png");
        fGResLoader.registerImage("port4.png");
        fGResLoader.registerImage("rank_places.png");
        fGResLoader.registerImageSet("carGred", ".png", 16, false, false);
        if (LifeEngine.getInstance().useStartStopAnims()) {
            fGResLoader.registerImageSet("carGstart01_red", ".png", 16, false, false);
            fGResLoader.registerImageSet("carGstop01_red", ".png", 16, false, false);
        }
    }

    ModeGame() {
    }

    void newGame() {
        this.m_currPlayer = 0;
        this.m_choosingPaths = true;
        for (int i = 0; i < 10; ++i) {
            this.m_investNums[i] = 0;
        }
        this.m_pCareerCards = new CareerCardPile();
        this.m_pCareerCards.init();
        this.m_pCollegeCareerCards = new CollegeCareerCardPile();
        this.m_pCollegeCareerCards.init();
        this.m_pLifeCardPile = new LifeCardPile();
        this.m_pLifeCardPile.init();
        this.m_pShareTheWealthCardPile = new ShareTheWealthCardPile();
        this.m_pShareTheWealthCardPile.init();
        this.m_pPlayers[0] = new Player();
        this.m_pPlayers[0].init(3, this.m_pLifeEngine.getStringTable().getString(123), 0, true, this.m_ppCars[0], 0);
        this.m_pPlayers[1] = new Player();
        this.m_pPlayers[1].init(2, this.m_pLifeEngine.getStringTable().getString(124), 1, true, this.m_ppCars[1], 1);
        this.m_numPlayers = 4;
        this.m_pPlayers[2] = new Player();
        this.m_pPlayers[2].init(0, this.m_pLifeEngine.getStringTable().getString(125), 0, true, this.m_ppCars[2], 2);
        this.m_pPlayers[3] = new Player();
        this.m_pPlayers[3].init(1, this.m_pLifeEngine.getStringTable().getString(126), 1, true, this.m_ppCars[3], 3);
        this.m_pBoard = LifeEngine.getInstance().getBoard();
        this.m_pBoard.init(this.m_pPlayers, this.m_pLifeCardPile, this.m_pCareerCards, this.m_pCollegeCareerCards, this.m_pShareTheWealthCardPile, 0, this.m_pHud);
        this.setCurrState(4);
        this.m_rollingForFirst = false;
    }

    void loadGame() {
        int n;
        FGData fGData = SaveGame.getRMS(this.m_isPNP ? "LIFEP" : "LIFEG");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fGData.m_data);
        this.m_currPlayer = StaticMethods.readInt(byteArrayInputStream);
        this.m_choosingPaths = StaticMethods.readBoolean(byteArrayInputStream);
        for (n = 0; n < 10; ++n) {
            this.m_investNums[n] = StaticMethods.readInt(byteArrayInputStream);
        }
        this.m_pCareerCards = new CareerCardPile();
        this.m_pCareerCards.load(byteArrayInputStream);
        this.m_pCollegeCareerCards = new CollegeCareerCardPile();
        this.m_pCollegeCareerCards.load(byteArrayInputStream);
        this.m_pLifeCardPile = new LifeCardPile();
        this.m_pLifeCardPile.load(byteArrayInputStream);
        this.m_pShareTheWealthCardPile = new ShareTheWealthCardPile();
        this.m_pShareTheWealthCardPile.load(byteArrayInputStream);
        this.m_numPlayers = StaticMethods.readInt(byteArrayInputStream);
        for (n = 0; n < this.m_numPlayers; ++n) {
            this.m_pPlayers[n] = new Player();
            this.m_pPlayers[n].load(byteArrayInputStream, this.m_ppCars[n]);
            this.setCarAndPortrait(this.m_pPlayers[n], this.m_pPlayers[n].getCarColor(), this.m_pPlayers[n].getCharacter());
            this.m_pPlayers[n].setPortrait(0);
        }
        this.m_pBoard = LifeEngine.getInstance().getBoard();
        this.m_pBoard.init(this.m_pPlayers, this.m_pLifeCardPile, this.m_pCareerCards, this.m_pCollegeCareerCards, this.m_pShareTheWealthCardPile, this.m_numPlayers, this.m_pHud);
        this.m_pBoard.load(byteArrayInputStream);
        this.m_pBoard.m_isPNP = this.m_isPNP;
        this.setCurrState(StaticMethods.readInt(byteArrayInputStream));
        this.m_rollingForFirst = StaticMethods.readBoolean(byteArrayInputStream);
        this.m_currRoller = StaticMethods.readInt(byteArrayInputStream);
        this.m_humanIdx = StaticMethods.readInt(byteArrayInputStream);
        this.m_pBoard.setHumanIndex(this.m_humanIdx);
        this.m_loading = true;
        this.m_pBoard.setCurrPlayer(this.m_currPlayer);
        if (this.m_currState == 5) {
            this.announceCurrPlayer(false);
        }
        this.loadSpecific(byteArrayInputStream);
        try {
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void saveGame() {
        int n;
        if (!(this.m_pCareerCards != null && this.m_pCareerCards.getNumCards() != 0 && this.m_pCollegeCareerCards != null && this.m_pCollegeCareerCards.getNumCards() != 0 && this.m_pLifeCardPile != null && this.m_pLifeCardPile.getNumCards() != 0 && this.m_pShareTheWealthCardPile != null && this.m_pShareTheWealthCardPile.getNumCards() != 0 || this.m_isPNP)) {
            return;
        }
        if (this.m_rollingForFirst || this.m_currState == 12 || this.m_currState == 4 || this.m_currState == 22) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StaticMethods.writeInt(byteArrayOutputStream, this.m_currPlayer);
        StaticMethods.writeBoolean(byteArrayOutputStream, this.m_choosingPaths);
        for (n = 0; n < 10; ++n) {
            StaticMethods.writeInt(byteArrayOutputStream, this.m_investNums[n]);
        }
        this.m_pCareerCards.save(byteArrayOutputStream);
        this.m_pCollegeCareerCards.save(byteArrayOutputStream);
        this.m_pLifeCardPile.save(byteArrayOutputStream);
        this.m_pShareTheWealthCardPile.save(byteArrayOutputStream);
        StaticMethods.writeInt(byteArrayOutputStream, this.m_numPlayers);
        for (n = 0; n < this.m_numPlayers; ++n) {
            this.m_pPlayers[n].save(byteArrayOutputStream);
        }
        this.m_pBoard.save(byteArrayOutputStream);
        StaticMethods.writeInt(byteArrayOutputStream, this.m_currState);
        StaticMethods.writeBoolean(byteArrayOutputStream, this.m_rollingForFirst);
        StaticMethods.writeInt(byteArrayOutputStream, this.m_currRoller);
        StaticMethods.writeInt(byteArrayOutputStream, this.m_humanIdx);
        this.saveSpecific(byteArrayOutputStream);
        FGData fGData = new FGData();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        fGData.init(byArray.length);
        System.arraycopy(byArray, 0, fGData.m_data, 0, byArray.length);
        SaveGame.saveRMS(this.m_isPNP ? "LIFEP" : "LIFEG", fGData);
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void setupSaveGame() {
        this.m_isPNP = false;
    }

    void init0(boolean bl) {
        this.m_hidePopupPending = false;
        FGResLoader fGResLoader = this.m_pLifeEngine.getResLoader();
        this.m_loading = bl;
        this.m_timerStarted = false;
        this.m_spinningForWedding = false;
        this.m_spinningForPension = false;
        this.setupSaveGame();
        for (int i = 0; i < 4; ++i) {
            this.m_ppCars[i] = new Car();
            this.m_ppCars[i].SetExtraCarFrames(true);
        }
        this.m_pHud = LifeEngine.getInstance().getHud();
        if (this.m_pHud == null) {
            FGEngine.fatal("hud is null");
            return;
        }
        this.m_pHud.init();
        if (bl) {
            this.loadGame();
        } else {
            this.newGame();
        }
    }

    void init1() {
        this.setBoardViewport(true);
    }

    void init2() {
        LifeEngine lifeEngine = LifeEngine.getInstance();
        lifeEngine.prepCarImages();
        this.m_pCarImgs = lifeEngine.m_pCarImgs;
        this.m_pCarStartImgs = lifeEngine.m_pCarStartImgs;
        this.m_pCarEndImgs = lifeEngine.m_pCarEndImgs;
    }

    void init3() {
        FGResLoader fGResLoader = this.m_pLifeEngine.getResLoader();
        block6: for (int i = 0; i < this.m_numPlayers; ++i) {
            int n = this.m_pPlayers[i].getCarColor();
            if (LifeEngine.getInstance().useStartStopAnims()) {
                this.m_pPlayers[i].getCar().init(this.m_pCarImgs[n], this.m_pCarStartImgs[n], this.m_pCarEndImgs[n]);
            } else {
                this.m_pPlayers[i].getCar().init(this.m_pCarImgs[n], null, null);
            }
            if (this.m_loading) continue;
            switch (n) {
                case 3: {
                    this.m_pPlayers[i].loadPortraits(fGResLoader, "port1", 0);
                    continue block6;
                }
                case 2: {
                    this.m_pPlayers[i].loadPortraits(fGResLoader, "port2", 1);
                    continue block6;
                }
                case 0: {
                    this.m_pPlayers[i].loadPortraits(fGResLoader, "port3", 1);
                    continue block6;
                }
                case 1: {
                    this.m_pPlayers[i].loadPortraits(fGResLoader, "port4", 1);
                }
            }
        }
        this.m_pHud.setLeftPlayer(this.m_pPlayers[this.m_currPlayer]);
        this.m_pLifeEngine.positiveSoftkeySet(3);
        this.m_pLifeEngine.negativeSoftkeySet(4);
        this.m_megaPaused = false;
        if (!this.m_loading) {
            this.saveGame();
        }
        this.m_displayedSpace = -1;
        FGEAStringManager fGEAStringManager = LifeEngine.getInstance().getStringTable();
        this.m_1X = fGEAStringManager.getString(206);
        this.m_2X = fGEAStringManager.getString(207);
        this.m_turns = fGEAStringManager.getString(208);
        if (this.m_pLifeEngine.shouldShowTutorial() && !this.m_isPNP) {
            this.m_pHud.showTutorial();
        }
    }

    public void tick() {
        int n;
        if (LifeEngine.getInstance().showTextsCheatEnabled) {
            if (this.backState == -1) {
                this.backState = this.m_currState;
            }
            this.setCurrState(29);
            return;
        }
        if (this.backState != -1) {
            this.setCurrState(this.backState);
            this.backState = -1;
        }
        if (this.m_isPNP) {
            this.m_pHud.hideTutorial();
        }
        this.setSoftkeys();
        boolean bl = true;
        for (n = 0; n < this.m_numPlayers; ++n) {
            bl = bl && this.m_pPlayers[n].isRetired();
        }
        if (bl) {
            this.setCurrState(13);
            ModeEndgame modeEndgame = new ModeEndgame();
            modeEndgame.init(this.m_pPlayers, this.m_pHud, this.m_numPlayers);
            this.m_pLifeEngine.getModeMgr().pushMode(modeEndgame);
            return;
        }
        for (n = 0; n < 4; ++n) {
            this.m_ppCars[n].Tick(this.m_pLifeEngine.getTickTime());
        }
        this.m_pBoard.tick();
        this.m_pHud.tick();
        if (this.m_hidePopupPending) {
            this.m_pHud.hideArrowPopupText();
            this.m_hidePopupPending = false;
        }
        switch (this.m_currState) {
            case 8: {
                if (!this.m_timer.isOver()) break;
                this.announceCurrPlayer(false);
                break;
            }
            case 9: {
                if (!this.m_timer.isOver()) break;
                this.setCurrState(3);
                break;
            }
            case 2: {
                this.m_pHud.setLeftPlayer(this.m_pPlayers[this.m_currPlayer]);
                if (!this.m_pPlayers[this.m_currPlayer].isAI()) {
                    this.m_pBoard.centerOnSpinner();
                    this.m_pHud.hideArrowPopupText();
                    this.m_pHud.hideInfoPopupText();
                    ModeChoosePath modeChoosePath = new ModeChoosePath();
                    modeChoosePath.init();
                    modeChoosePath.dontLoop();
                    this.m_pLifeEngine.getModeMgr().pushMode(modeChoosePath);
                    break;
                }
                int n2 = this.m_pLifeEngine.rand() % 2;
                if (n2 == 0) {
                    this.m_pBoard.placeCarForStart(this.m_pPlayers[this.m_currPlayer].getCar(), true);
                    this.announceAIPath(true);
                } else {
                    this.m_pBoard.placeCarForStart(this.m_pPlayers[this.m_currPlayer].getCar(), false);
                    this.announceAIPath(false);
                }
                this.m_pBoard.centerOnCar(this.m_pPlayers[this.m_currPlayer].getCar());
                break;
            }
            case 1: {
                if (this.m_pBoard.isSpinning()) break;
                this.setCurrState(5);
                break;
            }
            case 3: {
                this.newCareer();
                break;
            }
            case 5: {
                this.rankPlayers();
                int n3 = this.m_pBoard.getState();
                switch (n3) {
                    case 0: {
                        this.doNextPlayer();
                        break;
                    }
                    case 50: {
                        this.announceCurrPlayer(true);
                        break;
                    }
                    case 22: {
                        this.setCurrState(6);
                        if (!this.m_pPlayers[this.m_currPlayer].isAI()) {
                            ModeChooseSmallCard modeChooseSmallCard = new ModeChooseSmallCard();
                            modeChooseSmallCard.init(this.m_pCareerCards.getNumCards(), LifeEngine.getInstance().getResLoader().getImage("cardback.png"), 1, LifeEngine.getInstance().getStringTable().getString(36));
                            LifeEngine.getInstance().getModeMgr().pushMode(modeChooseSmallCard);
                            break;
                        }
                        this.newCareer();
                        break;
                    }
                    case 40: {
                        this.m_pHud.displayInfoPopupText(0, this.m_pLifeEngine.getStringTable().getString(107), this.m_pLifeEngine.getSmallFont(), -1);
                        this.setCurrState(20);
                        break;
                    }
                    case 41: {
                        this.doSpinForFirstStuff();
                        break;
                    }
                    case 53: {
                        if (this.m_spinningForWedding) {
                            SDKString sDKString;
                            int n4 = this.m_pBoard.getSpinnerValue();
                            int n5 = 0;
                            if (n4 <= 10 && n4 >= 8) {
                                n5 = 10000;
                            } else if (n4 >= 5 && n4 <= 7) {
                                n5 = 5000;
                            } else {
                                n5 = 0;
                                if (this.m_pPlayers[this.m_currPlayer].isAI()) {
                                    sDKString = this.m_pLifeEngine.getStringTable().getString(326);
                                    this.m_scratchStr.format(sDKString, this.m_pPlayers[this.m_currPlayer].getName());
                                    this.m_pHud.displayInfoPopupText(0, this.m_scratchStr.getSDKString(), LifeEngine.getInstance().getSmallFont(), 3000);
                                } else {
                                    sDKString = this.m_pLifeEngine.getStringTable().getString(327);
                                    this.m_pHud.displayInfoPopupText(0, sDKString, LifeEngine.getInstance().getSmallFont(), 3000);
                                }
                                this.m_timer.start(3000);
                            }
                            if (n5 != 0) {
                                Hud.makeMoneyString(n5, this.m_scratch);
                                if (this.m_pPlayers[this.m_currPlayer].isAI()) {
                                    sDKString = this.m_pLifeEngine.getStringTable().getString(324);
                                    this.m_scratchStr.format(sDKString, this.m_pPlayers[this.m_currPlayer].getName(), this.m_scratch.getSDKString());
                                } else {
                                    sDKString = this.m_pLifeEngine.getStringTable().getString(325);
                                    this.m_scratchStr.format(sDKString, this.m_scratch.getSDKString());
                                }
                                int n6 = this.m_pHud.allPlayersPay(n5, this.m_currPlayer, this.m_pPlayers, this.m_numPlayers, false);
                                this.m_pHud.displayInfoPopupText(0, this.m_scratchStr.getSDKString(), LifeEngine.getInstance().getSmallFont(), n6);
                                this.m_timer.start(n6);
                            }
                            this.setCurrState(26);
                            break;
                        }
                        this.announceCurrPlayer(true, true);
                        this.m_spinningForWedding = true;
                        break;
                    }
                    case 56: {
                        if (this.m_spinningForPension) {
                            int n7 = this.m_pBoard.getSpinnerValue() * 10000;
                            Hud.makeMoneyString(n7, this.m_scratch);
                            if (this.m_pPlayers[this.m_currPlayer].isAI()) {
                                SDKString sDKString = this.m_pLifeEngine.getStringTable().getString(334);
                                this.m_scratchStr.format(sDKString, this.m_pPlayers[this.m_currPlayer].getName(), this.m_scratch.getSDKString());
                            } else {
                                SDKString sDKString = this.m_pLifeEngine.getStringTable().getString(335);
                                this.m_scratchStr.format(sDKString, this.m_scratch.getSDKString());
                            }
                            this.m_pHud.displayInfoPopupText(0, this.m_scratchStr.getSDKString(), LifeEngine.getInstance().getSmallFont(), 3000);
                            this.m_timer.start(3000);
                            this.setCurrState(27);
                            this.m_pHud.showBank();
                            int n8 = LifeEngine.getInstance().rand() % 1;
                            this.m_pHud.displayFlyingMoney(false, this.m_pPlayers[this.m_currPlayer].getCash(), this.m_pPlayers[this.m_currPlayer], this.m_pPlayers[this.m_currPlayer].getCash() + n7);
                            this.m_pPlayers[this.m_currPlayer].transactCash(n7);
                            break;
                        }
                        this.announceCurrPlayer(true, false, true);
                        this.m_spinningForPension = true;
                    }
                }
                break;
            }
            case 7: {
                int n9;
                if (!this.m_timer.isOver() || !this.m_pPlayers[n9 = this.m_rollingForFirst ? this.m_currRoller : this.m_currPlayer].isAI()) break;
                this.setCurrState(1);
                break;
            }
            case 14: {
                if (!this.m_timer.isOver()) break;
                this.m_pPlayers[this.m_currPlayer].loseNextTurn(false);
                this.doLoseTurn();
                break;
            }
            case 11: {
                if (!this.m_timer.isOver()) break;
                this.announceCurrPlayer();
                break;
            }
            case 20: {
                int n10 = this.m_pLifeEngine.getTickTime();
                int n11 = FGFixed.toFixed(this.m_powerBarPos);
                int n12 = kPowerBarSpeed;
                int n13 = FGGeometry.applyPPSVel(n11, kPowerBarSpeed, n10);
                this.m_powerBarPos = FGFixed.toInt(n13);
                if (this.m_powerBarPos <= 200) break;
                this.m_powerBarPos -= 200;
                break;
            }
            case 25: {
                if (!this.m_timer.isOver()) break;
                this.m_pHud.hideArrowPopupText();
                this.announceCurrPlayer();
                break;
            }
            case 26: {
                if (!this.m_timer.isOver() || !this.m_pHud.allPlayersPayDone()) break;
                this.m_spinningForWedding = false;
                this.m_pBoard.doneSpinningForGifts();
                this.doNextPlayer();
                break;
            }
            case 27: {
                if (!this.m_timer.isOver()) break;
                this.m_spinningForPension = false;
                this.m_pBoard.doneSpinningForPension();
                this.doNextPlayer();
            }
        }
    }

    public void drawSelf(FGGraphics fGGraphics) {
        this.m_pBoard.drawSelf(fGGraphics);
        this.m_pHud.drawSelf(fGGraphics);
        if (this.m_currState == 20) {
            int n = this.m_pLifeEngine.getScreenWidth();
            int n2 = n / 2;
            int n3 = 6;
            int n4 = (n - n2) / 2;
            int n5 = this.m_pLifeEngine.getScreenHeight() - this.m_pHud.getHeight() - n3 * 2;
            int n6 = this.m_powerBarPos < 100 ? this.m_powerBarPos : 200 - this.m_powerBarPos;
            this.m_pHud.hideInfoPopupText();
            int n7 = n6 * n2 / 100;
            fGGraphics.setColor(0);
            fGGraphics.drawRect(n4 - 1, n5 - 1, n2 + 2, n3 + 1);
            fGGraphics.setColor(FGGraphics.makeRGB(255, 255, 255));
            fGGraphics.fillRect(n4, n5, n2, n3);
            fGGraphics.setColor(FGGraphics.makeRGB(0, 255, 0));
            fGGraphics.fillRect(n4, n5, n7, n3);
            FGFont fGFont = LifeEngine.getInstance().getSmallBoldFont();
            int n8 = fGFont.getDisplayLength(this.m_1X);
            fGFont.drawText(fGGraphics, this.m_1X, n4 - n8 - 2, n5);
            fGFont.drawText(fGGraphics, this.m_2X, n4 + n2 + 2, n5);
            n8 = fGFont.getDisplayLength(this.m_turns);
            fGFont.drawText(fGGraphics, this.m_turns, n4 + (n2 - n8) / 2, n5 - fGFont.getHeight());
        }
    }

    public void activate() {
        int n;
        if (this.m_megaPaused) {
            this.m_pLifeEngine.megaResume();
            this.m_megaPaused = false;
            int n2 = this.m_pLifeEngine.getIntHack();
            if (n2 == 1) {
                this.quit();
            } else {
                this.setSoftkeys();
            }
            return;
        }
        if (this.m_currState == 17) {
            return;
        }
        if (this.m_loading) {
            this.m_loading = false;
            return;
        }
        switch (this.m_currState) {
            case 4: {
                this.m_pHud.setLeftPlayer(null);
                this.choosePlayers();
                break;
            }
            case 12: {
                n = LifeEngine.getInstance().getIntHack();
                if (n == -1) {
                    this.quit();
                    LifeEngine.getInstance().setIntHack(0);
                    return;
                }
                this.setupPlayers(true);
                this.announceCurrRoller();
                break;
            }
            case 2: {
                n = this.m_pLifeEngine.getIntHack();
                if (n == 0) {
                    this.m_pBoard.placeCarForStart(this.m_pPlayers[this.m_currPlayer].getCar(), true);
                    this.setCurrState(25);
                    this.m_timer.start(3000);
                    this.m_pHud.hideArrowPopupText();
                    this.m_pHud.hideSpinner();
                } else {
                    this.setCurrState(21);
                    this.m_pBoard.placeCarForStart(this.m_pPlayers[this.m_currPlayer].getCar(), false);
                    ModeChooseSmallCard modeChooseSmallCard = new ModeChooseSmallCard();
                    modeChooseSmallCard.init(this.m_pCareerCards.getNumCards(), this.m_pLifeEngine.getResLoader().getImage("cardback.png"), 1, this.m_pLifeEngine.getStringTable().getString(36));
                    this.m_pLifeEngine.getModeMgr().pushMode(modeChooseSmallCard);
                }
                this.m_pBoard.centerOnCar(this.m_pPlayers[this.m_currPlayer].getCar());
                break;
            }
            case 3: {
                this.announceCurrPlayer();
                this.m_pBoard.centerOnCar(this.m_pPlayers[this.m_currPlayer].getCar());
                this.m_hidePopupPending = true;
                break;
            }
            case 6: {
                if (!this.m_pPlayers[this.m_currPlayer].isAI()) {
                    this.newCareer();
                    this.m_pPlayers[this.m_currPlayer].loseJob(this.m_pCareerCards, this.m_pCollegeCareerCards);
                    this.setCurrState(23);
                    break;
                }
                this.m_pPlayers[this.m_currPlayer].loseJob(this.m_pCareerCards, this.m_pCollegeCareerCards);
                this.nextPlayer();
                this.announceCurrPlayer();
                break;
            }
            case 23: {
                this.nextPlayer();
                if (this.m_choosingPaths) break;
                this.announceCurrPlayer();
                break;
            }
            case 13: {
                this.quit();
                return;
            }
            case 19: {
                this.announceCurrPlayer(true);
                break;
            }
            case 18: {
                n = this.m_pBoard.getState();
                if (n != 25 && n != 11) break;
                this.announceCurrPlayer(true);
                break;
            }
            case 21: {
                this.setCurrState(3);
                break;
            }
            case 22: {
                n = LifeEngine.getInstance().getIntHack();
                if (n == -1) {
                    this.quit();
                    return;
                }
                this.setupPlayers(false);
                for (int i = 0; i < this.m_numPlayers; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        this.m_pPlayers[i].addShareTheWealth((ShareTheWealthCard)this.m_pShareTheWealthCardPile.drawOne());
                    }
                }
                this.setCurrState(24);
                ModeChoosePlayer modeChoosePlayer = new ModeChoosePlayer();
                modeChoosePlayer.init(this.m_pTempPlayers, this.m_pHud, true, false, this.m_humanIdx, null, false);
                modeChoosePlayer.setNoChoice();
                LifeEngine.getInstance().getModeMgr().pushMode(modeChoosePlayer);
                break;
            }
            case 24: {
                if (this.m_isPNP) {
                    this.PNPNextPlayer();
                    break;
                }
                this.showInitialSTWCards();
            }
        }
        if ((this.m_pBoard.getState() == 11 || this.m_pBoard.getState() == 25) && (n = this.m_pLifeEngine.getIntHack()) == -1) {
            this.setCurrState(18);
        }
        this.m_pBoard.activate();
        this.setSoftkeys();
    }

    public void deactivate() {
        this.m_pLifeEngine.positiveSoftkeyShow(false);
        this.m_pLifeEngine.negativeSoftkeyShow(false);
    }

    public void pause() {
    }

    public void resume() {
    }

    public void keyPressed(int n) {
        if ((this.m_pLifeEngine.isPositiveSoftkey(n) || n == this.m_pLifeEngine.AVK_FIRE) && this.m_currState == 28) {
            this.m_pHud.hideTutorial();
            this.m_pLifeEngine.setShowedTutorial(true);
            this.setCurrState(12);
            this.setupPlayers(true);
            this.announceCurrRoller();
            this.setBoardViewport(true);
            this.m_pHud.showPlayerInfoBox();
            return;
        }
        if (this.m_pLifeEngine.isNegativeSoftkey(n)) {
            this.m_megaPaused = true;
            this.m_pLifeEngine.megaPause();
            ModePause modePause = new ModePause();
            int n2 = 0;
            if (this.m_rollingForFirst) {
                n2 = 1;
            } else if (this.getPlayerForStatus() != this.m_pPlayers[this.m_currPlayer]) {
                n2 = 2;
            }
            modePause.init(this.getPlayerForStatus(), this.m_pHud, this.m_investNums, n2);
            this.m_pLifeEngine.getModeMgr().pushMode(modePause);
            return;
        }
        if (this.m_pLifeEngine.isPositiveSoftkey(n)) {
            FGImage[] fGImageArray = new FGImage[]{this.m_pCarImgs[0][2], this.m_pCarImgs[1][2], this.m_pCarImgs[2][2], this.m_pCarImgs[3][2]};
            ModeLaunchStatus modeLaunchStatus = new ModeLaunchStatus();
            modeLaunchStatus.init(this.m_pPlayers, this.m_pHud, fGImageArray, this.getPlayerForStatus());
            this.m_pLifeEngine.getModeMgr().pushMode(modeLaunchStatus);
            if (this.m_pHud.isMoneyFlying()) {
                this.m_pHud.RevertFlyingMoney();
            }
            return;
        }
        this.m_pHud.keyPressed(n);
        if (this.m_rollingForFirst) {
            int n3 = this.m_currRoller;
        } else {
            int n4 = this.m_currPlayer;
        }
        if (this.m_currState == 29) {
            if (n == 42) {
                if (this.m_pHud.stateSpaceTexts) {
                    this.m_pHud.stateSpaceTexts = false;
                    this.m_pHud.stateCareerChoice = true;
                } else if (this.m_pHud.stateCareerChoice) {
                    this.m_pHud.stateCareerChoice = false;
                    this.m_pHud.stateHouseChoice = true;
                } else if (this.m_pHud.stateHouseChoice) {
                    this.m_pHud.stateHouseChoice = false;
                    this.m_pHud.stateSpecialEvents = true;
                }
            }
            if (this.m_pHud.stateSpaceTexts) {
                if ((n == 2 || n == 52) && this.m_pHud.textIdPointer > 0) {
                    --this.m_pHud.textIdPointer;
                }
                if ((n == 5 || n == 54) && 209 + this.m_pHud.textIdPointer < 309) {
                    ++this.m_pHud.textIdPointer;
                }
            }
            if (this.m_pHud.stateCareerChoice) {
                if ((n == 2 || n == 52) && this.m_pHud.choiceCardPointer > 0) {
                    --this.m_pHud.choiceCardPointer;
                }
                if ((n == 5 || n == 54) && this.m_pHud.choiceCardPointer < 11) {
                    ++this.m_pHud.choiceCardPointer;
                }
            }
            if (this.m_pHud.stateHouseChoice) {
                if ((n == 2 || n == 52) && this.m_pHud.choiceHousePointer > 0) {
                    --this.m_pHud.choiceHousePointer;
                }
                if ((n == 5 || n == 54) && this.m_pHud.choiceHousePointer < 11) {
                    ++this.m_pHud.choiceHousePointer;
                }
            }
            if (this.m_pHud.stateSpecialEvents) {
                if ((n == 2 || n == 52) && this.m_pHud.specialEventsPointer > 0) {
                    --this.m_pHud.specialEventsPointer;
                }
                if ((n == 5 || n == 54) && this.m_pHud.specialEventsPointer < 3) {
                    ++this.m_pHud.specialEventsPointer;
                }
            }
        }
        if (this.m_currState == 20) {
            if (LifeEngine.getInstance().spinWheelCheatEnabled) {
                if (val == -2) {
                    val = -1;
                    return;
                }
                switch (n) {
                    case 48: {
                        val = 10;
                        break;
                    }
                    case 49: {
                        val = 1;
                        break;
                    }
                    case 50: {
                        val = 2;
                        break;
                    }
                    case 51: {
                        val = 3;
                        break;
                    }
                    case 52: {
                        val = 4;
                        break;
                    }
                    case 53: {
                        val = 5;
                        break;
                    }
                    case 54: {
                        val = 6;
                        break;
                    }
                    case 55: {
                        val = 7;
                        break;
                    }
                    case 56: {
                        val = 8;
                        break;
                    }
                    case 57: {
                        val = 9;
                    }
                }
                if (val != -1) {
                    this.m_pBoard.startSpin(val);
                    this.setCurrState(1);
                    val = -1;
                    return;
                }
            }
            if (n == this.m_pLifeEngine.AVK_FIRE || n == 53) {
                val = this.m_pBoard.getSpinnerValue() + this.m_powerBarPos * 10 / 100;
                if ((val %= 10) < 0) {
                    val += 10;
                }
                if (val > 9) {
                    val -= 10;
                }
                if (val == 0) {
                    val = 10;
                }
                this.m_pBoard.startSpin(val);
                this.setCurrState(1);
            }
        }
    }

    public void keyReleased(int n) {
        if ((this.m_rollingForFirst && this.m_pPlayers[this.m_currRoller].isAI() || !this.m_rollingForFirst && this.m_pPlayers[this.m_currPlayer].isAI()) && LifeEngine.getInstance().cheatsOn()) {
            int n2 = -1;
            switch (n) {
                case 48: {
                    n2 = 10;
                    break;
                }
                case 49: {
                    n2 = 1;
                    break;
                }
                case 50: {
                    n2 = 2;
                    break;
                }
                case 51: {
                    n2 = 3;
                    break;
                }
                case 52: {
                    n2 = 4;
                    break;
                }
                case 53: {
                    n2 = 5;
                    break;
                }
                case 54: {
                    n2 = 6;
                    break;
                }
                case 55: {
                    n2 = 7;
                    break;
                }
                case 56: {
                    n2 = 8;
                    break;
                }
                case 57: {
                    n2 = 9;
                }
            }
            if (n2 != -1) {
                this.m_pBoard.startSpin(n2);
                this.setCurrState(1);
                return;
            }
        }
        if ((n == this.m_pLifeEngine.AVK_FIRE || n == 53) && (this.m_rollingForFirst && this.m_pPlayers[this.m_currRoller].isAI() || !this.m_rollingForFirst && this.m_pPlayers[this.m_currPlayer].isAI())) {
            switch (this.m_currState) {
                case 9: {
                    this.setCurrState(3);
                    break;
                }
                case 3: 
                case 7: {
                    if (!this.m_pPlayers[this.m_currPlayer].getCar().IsPlaced()) break;
                }
                case 1: {
                    this.jumpToAIMove();
                    return;
                }
            }
        }
        this.m_pBoard.keyPressed(n);
        switch (this.m_currState) {
            case 20: {
                if (this.m_rollingForFirst || n != 35 && n != 42 || this.m_pPlayers[this.m_currPlayer].isRetired()) break;
                this.m_pHud.hideArrowPopupText();
                this.m_pHud.hideInfoPopupText();
                this.m_pHud.hideSpinner();
                this.setCurrState(18);
                this.m_pBoard.startLookAhead();
                break;
            }
            case 18: {
                if (n == 35) {
                    this.m_pBoard.incrementLookAhead();
                    break;
                }
                if (n == 42) {
                    this.m_pBoard.decrementLookAhead();
                    break;
                }
                if (n == this.m_pLifeEngine.AVK_FIRE || n == 53) {
                    if (this.m_pBoard.getState() == 45 || this.m_pBoard.m_lookAheadChoseBranch) {
                        this.m_pBoard.cancelLookAheadBranch();
                        this.setCurrState(19);
                        break;
                    }
                    this.m_pHud.hideArrowPopupText();
                    this.m_pBoard.cancelLookAhead();
                    this.announceCurrPlayer();
                    this.setCurrState(20);
                    this.setSoftkeys();
                }
            }
            case 1: {
                break;
            }
            case 10: {
                if (n != this.m_pLifeEngine.AVK_FIRE && n != 53 || this.m_pPlayers[this.m_currPlayer].isAI()) break;
                this.m_pHud.hideInfoPopupText();
                this.m_pBoard.startSpin(250, -1);
                this.setCurrState(1);
                break;
            }
            case 16: {
                if (!this.m_timer.isOver()) break;
                this.PNPNextPlayer();
                break;
            }
            case 25: {
                if (n != this.m_pLifeEngine.AVK_FIRE && n != 53 || this.m_timer.elapsedTime() <= 250) break;
                this.m_pHud.hideArrowPopupText();
                this.announceCurrPlayer();
                break;
            }
            case 15: {
                if (!this.m_timer.isOver()) break;
                if (!this.m_choosingPaths) {
                    this.PNPNextPlayer();
                    if (this.m_currState == 16) break;
                    this.announceCurrPlayer();
                    break;
                }
                this.PNPNextPlayer();
            }
        }
    }

    void newCareer() {
        Card card = this.m_pCareerCards.drawOne();
        CareerCard careerCard = (CareerCard)card;
        if (careerCard == null) {
            FGEngine.fatal("AI drew NULL career card!");
            return;
        }
        this.m_pPlayers[this.m_currPlayer].takeJob(careerCard, false);
        ModeChooseCareer modeChooseCareer = new ModeChooseCareer();
        int n = !this.m_pPlayers[this.m_currPlayer].isAI() ? -1 : 3000;
        modeChooseCareer.init(n);
        modeChooseCareer.ShowJob(careerCard);
        this.m_pLifeEngine.getModeMgr().pushMode(modeChooseCareer);
    }

    void announceCurrPlayer() {
        this.announceCurrPlayer(false, false, false);
    }

    void announceCurrPlayer(boolean bl) {
        this.announceCurrPlayer(bl, false, false);
    }

    void announceCurrPlayer(boolean bl, boolean bl2) {
        this.announceCurrPlayer(bl, bl2, false);
    }

    void announceCurrPlayer(boolean bl, boolean bl2, boolean bl3) {
        FGEAStringManager fGEAStringManager = this.m_pLifeEngine.getStringTable();
        Player player = this.m_pPlayers[this.m_currPlayer];
        this.m_pHud.setLeftPlayer(this.m_pPlayers[this.m_currPlayer], true);
        if (!this.m_rollingForFirst) {
            this.setSoftkeys();
        }
        FGString fGString = new FGString();
        if (player.isAI()) {
            SDKString sDKString = bl ? (bl2 ? fGEAStringManager.getString(322) : (bl3 ? fGEAStringManager.getString(332) : fGEAStringManager.getString(64))) : (player.isRetired() ? fGEAStringManager.getString(163) : (player.lostNextTurn() ? fGEAStringManager.getString(164) : fGEAStringManager.getString(63)));
            fGString.format(sDKString, player.getName());
            this.m_pHud.displayInfoPopupText(0, fGString.getSDKString(), this.m_pLifeEngine.getSmallBoldFont(), 1500);
        } else {
            SDKString sDKString = bl ? (bl2 ? fGEAStringManager.getString(323) : (bl3 ? fGEAStringManager.getString(333) : fGEAStringManager.getString(61))) : (player.isRetired() ? fGEAStringManager.getString(162) : (player.lostNextTurn() ? fGEAStringManager.getString(165) : fGEAStringManager.getString(62)));
            this.m_pHud.displayInfoPopupText(0, sDKString, this.m_pLifeEngine.getSmallBoldFont(), -1);
            this.m_pBoard.centerOnSpinner();
        }
        if (player.lostNextTurn()) {
            this.setCurrState(14);
            this.m_timer.start(1500);
            return;
        }
        if (player.isAI()) {
            this.setCurrState(7);
            this.m_timer.start(1500);
            this.m_pBoard.startSpin(1500, -1);
        } else {
            this.setCurrState(20);
        }
    }

    void announceCurrRoller() {
        FGString fGString = new FGString();
        this.m_pHud.setLeftPlayer(this.m_pPlayers[this.m_currRoller]);
        if (this.m_pPlayers[this.m_currRoller].isAI()) {
            fGString.format(this.m_pLifeEngine.getStringTable().getString(128), this.m_pPlayers[this.m_currRoller].getName());
            this.m_pHud.displayInfoPopupText(0, fGString.getSDKString(), this.m_pLifeEngine.getSmallBoldFont(), 1500);
        } else {
            this.m_pBoard.centerOnSpinner();
            this.m_pHud.displayInfoPopupText(0, this.m_pLifeEngine.getStringTable().getString(129), this.m_pLifeEngine.getSmallBoldFont(), -1);
        }
        if (this.m_pPlayers[this.m_currRoller].isAI()) {
            this.setCurrState(7);
            this.m_timer.start(1500);
            this.m_pBoard.startSpin(1500, -1);
        } else {
            this.setCurrState(20);
        }
    }

    void announceAIPath(boolean bl) {
        FGString fGString = new FGString();
        if (bl) {
            SDKString sDKString = this.m_pPlayers[this.m_currPlayer].getSex() == 0 ? this.m_pLifeEngine.getStringTable().getString(65) : this.m_pLifeEngine.getStringTable().getString(66);
            fGString.format(sDKString, this.m_pPlayers[this.m_currPlayer].getName());
            this.setCurrState(8);
        } else {
            fGString.format(this.m_pLifeEngine.getStringTable().getString(67), this.m_pPlayers[this.m_currPlayer].getName());
            this.setCurrState(9);
        }
        this.m_pHud.displayInfoPopupText(0, fGString.getSDKString(), this.m_pLifeEngine.getSmallBoldFont(), 1500);
        this.m_timer.start(1500);
    }

    void nextPlayer() {
        ++this.m_currPlayer;
        if (this.m_currPlayer >= this.m_numPlayers) {
            this.m_currPlayer = 0;
            this.m_choosingPaths = false;
        }
        if (this.m_choosingPaths) {
            this.setCurrState(2);
        }
        this.rankPlayers();
        Player player = this.m_pPlayers[this.m_currPlayer];
        if (!this.m_rollingForFirst) {
            this.setSoftkeys();
        }
        this.m_pHud.setLeftPlayer(this.m_pPlayers[this.m_currPlayer], true);
        this.m_pBoard.setCurrPlayer(this.m_currPlayer);
        if (!this.m_choosingPaths && player.isAI() && player.willBuyInvestment()) {
            int n = this.m_pLifeEngine.rand() % 9;
            while (this.m_investNums[n] != 0) {
                n = this.m_pLifeEngine.rand() % 9;
            }
            player.setInvestment(n);
            player.transactCash(-10000);
            this.m_investNums[n] = 1;
            this.setCurrState(11);
            this.m_timer.start(3000);
            FGString fGString = new FGString("");
            fGString.add(n + 1);
            fGString.becomeSDKString();
            this.m_scratchStr.format(this.m_pLifeEngine.getStringTable().getString(120), player.getName(), fGString.getSDKString());
            this.m_pHud.displayInfoPopupText(0, this.m_scratchStr.getSDKString(), this.m_pLifeEngine.getSmallFont(), 3000);
        }
        this.saveGame();
    }

    void doSpinForFirstStuff() {
        this.m_rollOrder[this.m_currRoller] = this.m_pBoard.getSpinnerValue();
        ++this.m_currOrder;
        ++this.m_currRoller;
        int n = 0;
        if (this.m_currRoller >= this.m_numPlayers) {
            for (int i = 0; i < this.m_numPlayers; ++i) {
                int n2 = -10;
                int n3 = -1;
                for (int j = 0; j < this.m_numPlayers; ++j) {
                    if (this.m_rollOrder[j] <= n2) continue;
                    n2 = this.m_rollOrder[j];
                    n3 = j;
                }
                this.m_pPlayers[n] = this.m_pTempPlayers[n3];
                this.m_pTempPlayers[n3] = null;
                ++n;
                this.m_rollOrder[n3] = -1;
            }
            this.m_rollingForFirst = false;
            this.m_pBoard.setNumPlayers(this.m_numPlayers);
            this.preparePlayers();
            this.saveGame();
        } else {
            this.announceCurrRoller();
        }
    }

    void PNPNextPlayer() {
    }

    void setSoftkeys() {
        if (this.m_currState == 20 || this.m_currState == 5) {
            this.m_pLifeEngine.positiveSoftkeySet(3);
            this.m_pLifeEngine.negativeSoftkeySet(4);
            this.m_pLifeEngine.positiveSoftkeyShow(true);
            this.m_pLifeEngine.negativeSoftkeyShow(true);
        } else if (this.m_currState == 28) {
            this.m_pLifeEngine.positiveSoftkeyShow(true);
            this.m_pLifeEngine.negativeSoftkeySet(0);
            this.m_pLifeEngine.negativeSoftkeyShow(false);
        } else {
            this.m_pLifeEngine.positiveSoftkeyShow(false);
            this.m_pLifeEngine.negativeSoftkeyShow(false);
        }
    }

    void quit() {
        if (this.m_rollingForFirst || this.m_currState == 12 || this.m_currState == 4 || this.m_currState == 22) {
            SaveGame.deleteRMS(this.m_isPNP ? "LIFEP" : "LIFEG");
        }
        ModeMainMenu modeMainMenu = new ModeMainMenu();
        modeMainMenu.init();
        this.m_pLifeEngine.getModeMgr().setMode(modeMainMenu);
        LifeEngine.getInstance().spinWheelCheatEnabled = false;
        LifeEngine.getInstance().showTextsCheatEnabled = false;
        this.setCurrState(17);
    }

    void setCarAndPortrait(Player player, int n, int n2) {
        this.init2();
        FGResLoader fGResLoader = this.m_pLifeEngine.getResLoader();
        if (LifeEngine.getInstance().useStartStopAnims()) {
            player.getCar().init(this.m_pCarImgs[n], this.m_pCarStartImgs[n], this.m_pCarEndImgs[n]);
        } else {
            player.getCar().init(this.m_pCarImgs[n], null, null);
        }
        player.setNameAndSex(n2);
        player.setCharacter(n2);
        player.setColor(n);
        switch (n2) {
            case 0: {
                player.loadPortraits(fGResLoader, "port1", 0);
                break;
            }
            case 1: {
                player.loadPortraits(fGResLoader, "port2", 1);
                break;
            }
            case 2: {
                player.loadPortraits(fGResLoader, "port3", 1);
                break;
            }
            case 3: {
                player.loadPortraits(fGResLoader, "port4", 1);
            }
        }
    }

    public Hud getHud() {
        return this.m_pHud;
    }

    void choosePlayers() {
        FGImage[] fGImageArray = new FGImage[]{this.m_pCarImgs[0][2], this.m_pCarImgs[1][2], this.m_pCarImgs[2][2], this.m_pCarImgs[3][2]};
        ModeChoosePlayer modeChoosePlayer = new ModeChoosePlayer();
        modeChoosePlayer.init(this.m_pPlayers, this.m_pHud, false, false, -1, fGImageArray, true);
        this.m_pLifeEngine.getModeMgr().pushMode(modeChoosePlayer);
        this.setCurrState(22);
    }

    void setupPlayers(boolean bl) {
        int n;
        if (bl) {
            return;
        }
        int n2 = this.m_pLifeEngine.getIntHack();
        if (n2 == -1) {
            this.quit();
            return;
        }
        int n3 = (n2 & 0xFF0000) >> 16;
        int n4 = (n2 & 0xFF00) >> 8;
        this.m_numPlayers = n2 & 0xFF;
        this.m_humanIdx = n4;
        this.m_playerColor = n3;
        this.m_currRoller = 0;
        this.m_rollingForFirst = true;
        this.m_currOrder = 0;
        this.m_pPlayers[this.m_humanIdx].setCharacter(n4);
        this.m_pPlayers[this.m_humanIdx].setColor(this.m_playerColor);
        this.setCarAndPortrait(this.m_pPlayers[this.m_humanIdx], this.m_playerColor, n4);
        this.m_pPlayers[this.m_humanIdx].setAI(false);
        this.m_pTempPlayers[0] = this.m_pPlayers[this.m_humanIdx];
        this.m_pPlayers[this.m_humanIdx] = null;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        for (n = 0; n < 4; ++n) {
            nArray[n] = 1;
            nArray2[n] = 1;
        }
        nArray[this.m_playerColor] = 0;
        nArray2[n4] = 0;
        for (n = 0; n < 4; ++n) {
            if (n == this.m_humanIdx) continue;
            n3 = this.m_pLifeEngine.rand() % 4;
            while (nArray[n3] == 0) {
                n3 = this.m_pLifeEngine.rand() % 4;
            }
            nArray[n3] = 0;
            n4 = this.m_pLifeEngine.rand() % 4;
            while (nArray2[n4] == 0) {
                n4 = this.m_pLifeEngine.rand() % 4;
            }
            nArray2[n4] = 0;
            this.setCarAndPortrait(this.m_pPlayers[n], n3, n4);
        }
        for (n = 1; n < this.m_numPlayers; ++n) {
            int n5 = this.m_pLifeEngine.rand() % 4;
            while (this.m_pPlayers[n5] == null) {
                n5 = this.m_pLifeEngine.rand() % 4;
            }
            this.m_pTempPlayers[n] = this.m_pPlayers[n5];
            this.m_pPlayers[n5] = null;
        }
        for (n = 0; n < 4; ++n) {
            this.m_pPlayers[n] = null;
            this.m_rollOrder[n] = -1;
        }
        for (n = 0; n < this.m_numPlayers; ++n) {
            this.m_pPlayers[n] = this.m_pTempPlayers[n];
        }
        for (n = 0; n < this.m_numPlayers; ++n) {
            if (this.m_pPlayers[n].isAI()) continue;
            this.m_humanIdx = n;
        }
    }

    void preparePlayers() {
        int n;
        this.m_pBoard.centerOnSpinner();
        this.m_currPlayer = 0;
        for (n = 0; n < this.m_numPlayers; ++n) {
            this.m_pPlayers[n].putInGame();
            if (!this.m_pPlayers[n].isAI()) {
                this.m_humanIdx = n;
            }
            this.m_pPlayers[n].setRank(n);
        }
        for (n = this.m_numPlayers; n < 4; ++n) {
            this.m_pPlayers[n] = null;
        }
        this.m_pBoard.setHumanIndex(this.m_humanIdx);
        this.m_pBoard.setCurrPlayer(0);
        this.setCurrState(2);
    }

    void doLoseTurn() {
        this.nextPlayer();
        this.announceCurrPlayer();
    }

    Player getPlayerForStatus() {
        return this.m_pPlayers[this.m_humanIdx];
    }

    void doNextPlayer() {
        if (this.m_pPlayers[this.m_currPlayer].getCar().IsStopped() && this.m_pPlayers[this.m_currPlayer].getCar().GetSpace().m_spaceType != 24) {
            this.announceCurrPlayer(true);
            return;
        }
        this.nextPlayer();
        if (!this.m_choosingPaths && this.m_currState != 11 && this.m_currState != 15) {
            this.announceCurrPlayer();
        }
    }

    void saveSpecific(ByteArrayOutputStream byteArrayOutputStream) {
    }

    void loadSpecific(ByteArrayInputStream byteArrayInputStream) {
    }

    void doSpin() {
        this.m_timerStarted = false;
        int n = this.m_spinTimer.elapsedTime();
        if (n < 250) {
            n = 250;
        }
        if (n > 2000) {
            n = 2000;
        }
        int n2 = 1750;
        int n3 = 100 * n / n2;
        this.m_pHud.hideInfoPopupText();
        this.m_pHud.hideArrowPopupText();
        this.m_pBoard.startSpin(250, n3);
        this.setCurrState(1);
    }

    void setCurrState(int n) {
        this.m_currState = n;
        switch (this.m_currState) {
            case 20: {
                this.m_powerBarPos = 0;
                this.m_pHud.hideArrowPopupText();
                int n2 = this.m_pBoard.getSpinnerValue();
                this.m_pHud.displaySpinner(n2, -1);
                break;
            }
            case 1: {
                this.m_pHud.hideSpinner();
                break;
            }
            case 3: {
                this.m_pHud.hideArrowPopupText();
                this.m_pHud.hideInfoPopupText();
                break;
            }
            case 15: {
                this.m_timer.start(250);
                break;
            }
            case 29: {
                this.m_pHud.showTexts();
            }
        }
    }

    void rankPlayers() {
        int n;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        for (n = 0; n < 4; ++n) {
            nArray[n] = -1;
            nArray2[n] = n;
        }
        for (n = 0; n < this.m_numPlayers; ++n) {
            nArray[n] = this.m_pPlayers[n].calcNetWorth();
        }
        for (n = 0; n < this.m_numPlayers; ++n) {
            for (int i = this.m_numPlayers - 1; i > n; --i) {
                if (nArray[i - 1] >= nArray[i]) continue;
                int n2 = nArray[i];
                nArray[i] = nArray[i - 1];
                nArray[i - 1] = n2;
                n2 = nArray2[i];
                nArray2[i] = nArray2[i - 1];
                nArray2[i - 1] = n2;
            }
        }
        for (n = 0; n < this.m_numPlayers; ++n) {
            this.m_pPlayers[nArray2[n]].setRank(n);
        }
    }

    void jumpToAIMove() {
        boolean bl = false;
        if (this.m_currState != 1 || this.m_rollingForFirst) {
            bl = true;
        }
        this.setCurrState(5);
        this.m_pBoard.jumpToMove(bl);
    }

    void setBoardViewport(boolean bl) {
        int n = this.m_pLifeEngine.getScreenWidth();
        int n2 = this.m_pLifeEngine.getScreenHeight();
        int n3 = this.m_pBoard.getWidth();
        int n4 = this.m_pBoard.getHeight();
        int n5 = bl ? n2 - this.m_pHud.getHeight() : n2;
        int n6 = n - n3 >> 1;
        int n7 = n5 - n4 >> 1;
        this.m_pBoard.setViewport(-n6, -n7, n, n5);
    }

    void showInitialSTWCards() {
        ModeShowShareTheWealth modeShowShareTheWealth = new ModeShowShareTheWealth();
        modeShowShareTheWealth.init(this.m_pPlayers[this.m_currPlayer].getShareTheWealthCards(), false, true, true, true);
        LifeEngine.getInstance().getModeMgr().pushMode(modeShowShareTheWealth);
        if (this.m_pLifeEngine.shouldShowTutorial() && !this.m_isPNP) {
            this.setCurrState(28);
            this.setBoardViewport(false);
            this.m_pHud.hidePlayerInfoBox();
        } else if (this.m_isPNP) {
            this.setCurrState(24);
        } else {
            this.setCurrState(12);
        }
    }
}

