/*
 * Decompiled with CFR 0.152.
 */
import com.ea.sdk.SDKString;

class LifeLayout {
    public static final boolean VERBOSE = true;
    public static final int OPT_RECT_SIZE = 25;
    public int m_numElements;
    public int m_backgroundColor;
    public int m_width;
    public int m_height;
    public int[] m_xValues;
    public int[] m_solidColorValue;
    public int[] m_yValues;
    public boolean[] m_bTileables;
    public int[] m_widths;
    public int[] m_heights;
    private int[] m_filenameIDs;
    private int[] m_IDStringIDs;
    public FGImage[] m_images;
    private FGPointerList m_strings;
    private int[] m_stringHashes;
    public int[] m_flip;
    public boolean[] m_bNotes;
    int[] m_optElementIdxs;
    int m_numOptElements;
    int m_optRectX;
    int m_optRectY;
    int m_optRectW;
    int m_optRectH;

    public boolean init(String string) {
        FGString fGString;
        int n;
        FGData fGData = StaticMethods.getByteArrayFromFile(string);
        if (fGData == null) {
            FGString fGString2 = new FGString();
            fGString2.set("Could not load layout file: ");
            fGString2.add(string);
            FGEngine.fatal(fGString2.getNativeString());
            return false;
        }
        FGDataReader fGDataReader = new FGDataReader();
        fGDataReader.init(fGData);
        FGData fGData2 = new FGData();
        fGData2.init(5);
        for (int i = 0; i < 5; ++i) {
            fGData2.m_data[i] = fGDataReader.readByte();
        }
        fGData2.m_dataLength = 5;
        FGString fGString3 = new FGString();
        fGString3.set(fGData2);
        if (!fGString3.equals("FGLYT")) {
            return false;
        }
        int n2 = fGDataReader.readInt();
        if (n2 != 4) {
            FGString fGString4 = new FGString();
            fGString4.set("Invalid version of layout file: ");
            fGString4.add(string);
            FGEngine.fatal(fGString4.getNativeString());
            return false;
        }
        int n3 = fGDataReader.readInt();
        int n4 = fGDataReader.readInt();
        int n5 = fGDataReader.readInt();
        n5 = 4295685;
        int n6 = fGDataReader.readInt();
        this.m_strings = new FGPointerList(16, 8);
        for (n = 0; n < n6; ++n) {
            fGString = fGDataReader.readUTF();
            this.noteString(fGString.getNativeString());
        }
        this.m_stringHashes = new int[n6];
        for (n = 0; n < n6; ++n) {
            fGString = (FGString)this.m_strings.getPointer(n);
            this.m_stringHashes[n] = FGString.getHash(fGString.getNativeString());
        }
        n = fGDataReader.readInt();
        this.internalInit(n, n5, n3, n4);
        for (int i = 0; i < this.m_numElements; ++i) {
            int n7 = fGDataReader.readInt();
            int n8 = fGDataReader.readInt();
            int n9 = fGDataReader.readInt();
            int n10 = fGDataReader.readInt();
            boolean bl = fGDataReader.readBoolean();
            int n11 = fGDataReader.readInt();
            int n12 = fGDataReader.readInt();
            int n13 = fGDataReader.readInt();
            fGDataReader.readInt();
            this.setImage(i, n9, n10, bl, n11, n12, n13, n7, n8, false);
        }
        this.m_optRectX = -1;
        this.m_optRectY = -1;
        this.m_optRectW = -1;
        this.m_optRectH = -1;
        this.m_numOptElements = 0;
        return true;
    }

    public void registerNoteName(String string) {
        int n = this.getStringTableID(string);
        if (n == -1) {
            return;
        }
        for (int i = 0; i < this.m_numElements; ++i) {
            if (this.m_IDStringIDs[i] != n) continue;
            this.m_bNotes[i] = true;
        }
    }

    public void registerNeededImages(FGResLoader fGResLoader) {
        for (int i = 0; i < this.m_numElements; ++i) {
            if (this.isNote(i) || this.m_solidColorValue[i] != 0xFF00FF) continue;
            fGResLoader.registerImage(this.getElementName(i));
        }
    }

    public void getNeededImages(FGResLoader fGResLoader) {
        for (int i = 0; i < this.m_numElements; ++i) {
            this.m_images[i] = this.isNote(i) || this.m_solidColorValue[i] != 0xFF00FF ? null : fGResLoader.getImage(this.getElementName(i));
        }
    }

    public void releaseImages() {
        for (int i = 0; i < this.m_numElements; ++i) {
            this.m_images[i] = null;
        }
    }

    public void drawImageAt(FGGraphics fGGraphics, FGImage fGImage, String string, int n, int n2) {
        int n3 = this.getFirstIdx(string);
        if (n3 == -1) {
            return;
        }
        fGImage.drawSelf(fGGraphics, this.m_xValues[n3] + n, this.m_yValues[n3] + n2);
    }

    public void drawTextIn(FGGraphics fGGraphics, FGFont fGFont, SDKString sDKString, String string, int n, int n2) {
        int n3 = this.getFirstIdx(string);
        if (n3 == -1) {
            return;
        }
        int n4 = this.m_xValues[n3] + n;
        int n5 = this.m_yValues[n3] + n2;
        int n6 = this.m_widths[n3];
        int n7 = fGFont.getDisplayHeight(sDKString, n6);
        fGFont.drawText(fGGraphics, sDKString, n4, n5 += (this.m_heights[n3] - n7) / 2, n6);
    }

    public void drawSelfFlippedH(FGGraphics fGGraphics, int n, int n2) {
        this.drawSelf(fGGraphics, n, n2, 2);
    }

    public void drawSelfFlippedV(FGGraphics fGGraphics, int n, int n2) {
        this.drawSelf(fGGraphics, n, n2, 1);
    }

    public void drawSelf(FGGraphics fGGraphics, int n, int n2) {
        this.drawSelf(fGGraphics, n, n2, 0);
    }

    public void drawSelf(FGGraphics fGGraphics, int n, int n2, int n3) {
        int n4 = fGGraphics.getClipX();
        int n5 = fGGraphics.getClipY();
        int n6 = fGGraphics.getClipWidth();
        int n7 = fGGraphics.getClipHeight();
        fGGraphics.intersectClip(n, n2, this.m_width, this.m_height);
        if (!this.isInOptRect(fGGraphics, n, n2)) {
            this.recalcOpts(fGGraphics, n, n2);
        }
        if (this.m_backgroundColor != 0xFF00FF) {
            fGGraphics.setColor(this.m_backgroundColor);
            fGGraphics.fillRect(n, n2, this.m_width, this.m_height);
        }
        for (int i = 0; i < this.m_numOptElements; ++i) {
            int n8;
            int n9 = this.m_optElementIdxs[i];
            if (this.isNote(n9)) continue;
            if (this.m_flip[n9] == 2) {
                if (n3 == 2) {
                    n8 = 0;
                } else {
                    if (n3 == 1) {
                        FGEngine.fatal("horizontal and vertical flip both applied in layout");
                        return;
                    }
                    n8 = this.m_flip[n9];
                }
            } else if (this.m_flip[n9] == 1) {
                if (n3 == 1) {
                    n8 = 0;
                } else {
                    if (n3 == 2) {
                        FGEngine.fatal("horizontal and vertical flip both applied in layout");
                        return;
                    }
                    n8 = this.m_flip[n9];
                }
            } else {
                n8 = n3;
            }
            int n10 = n + this.getElementX(n9, n3);
            int n11 = n2 + this.getElementY(n9, n3);
            if (this.m_solidColorValue[n9] != 0xFF00FF) {
                fGGraphics.setColor(this.m_solidColorValue[n9]);
                fGGraphics.fillRect(n10, n11, this.m_widths[n9], this.m_heights[n9]);
                continue;
            }
            if (this.m_bTileables[n9]) {
                this.m_images[n9].drawTiled(fGGraphics, n10, n11, this.m_widths[n9], this.m_heights[n9]);
                continue;
            }
            this.m_images[n9].drawSelfFlipped(fGGraphics, n10, n11, n8);
        }
        fGGraphics.setClip(n4, n5, n6, n7);
    }

    public int getFirstIdx(String string) {
        int n = this.getStringTableID(string);
        if (n == -1) {
            return -1;
        }
        for (int i = 0; i < this.m_numElements; ++i) {
            if (this.m_IDStringIDs[i] != n) continue;
            return i;
        }
        return -1;
    }

    int getWidth() {
        return this.m_width;
    }

    int getHeight() {
        return this.m_height;
    }

    int getNumElements() {
        return this.m_numElements;
    }

    int getElementX(int n) {
        return this.getElementX(n, 0);
    }

    int getElementY(int n) {
        return this.getElementY(n, 0);
    }

    int getElementX(int n, int n2) {
        if (n2 == 2) {
            return this.m_width - this.m_xValues[n] - this.m_widths[n];
        }
        return this.m_xValues[n];
    }

    int getElementY(int n, int n2) {
        if (n2 == 1) {
            return this.m_height - this.m_yValues[n] - this.m_heights[n];
        }
        return this.m_yValues[n];
    }

    int getElementWidth(int n) {
        return this.m_widths[n];
    }

    int getElementHeight(int n) {
        return this.m_heights[n];
    }

    String getElementName(int n) {
        return this.getString(this.m_filenameIDs[n]);
    }

    String getElementIDString(int n) {
        return this.getString(this.m_IDStringIDs[n]);
    }

    public boolean isNote(int n) {
        return this.m_bNotes[n];
    }

    public void setNote(int n, boolean bl) {
        this.m_bNotes[n] = bl;
    }

    public int getElementX(String string) {
        return this.getElementX(string, 0);
    }

    public int getElementX(String string, int n) {
        int n2 = this.getFirstIdx(string);
        if (n2 == -1) {
            return -1;
        }
        return this.getElementX(n2, n);
    }

    public int getElementY(String string) {
        return this.getElementY(string, 0);
    }

    public int getElementY(String string, int n) {
        int n2 = this.getFirstIdx(string);
        if (n2 == -1) {
            return -1;
        }
        return this.getElementY(n2, n);
    }

    public int getElementWidth(String string) {
        int n = this.getFirstIdx(string);
        if (n == -1) {
            return -1;
        }
        return this.getElementWidth(n);
    }

    public int getElementHeight(String string) {
        int n = this.getFirstIdx(string);
        if (n == -1) {
            return -1;
        }
        return this.getElementHeight(n);
    }

    public FGImage getElementImage(String string) {
        int n = this.getFirstIdx(string);
        if (n == -1) {
            return null;
        }
        return this.m_images[n];
    }

    public boolean initManual(int n, int n2, int n3, int n4) {
        this.m_strings = new FGPointerList(16, 8);
        return this.internalInit(n, n2, n3, n4);
    }

    private boolean internalInit(int n, int n2, int n3, int n4) {
        this.m_width = n3;
        this.m_height = n4;
        this.m_backgroundColor = n2;
        this.m_numElements = n;
        this.m_xValues = new int[this.m_numElements];
        this.m_yValues = new int[this.m_numElements];
        this.m_bTileables = new boolean[this.m_numElements];
        this.m_widths = new int[this.m_numElements];
        this.m_heights = new int[this.m_numElements];
        this.m_filenameIDs = new int[this.m_numElements];
        this.m_IDStringIDs = new int[this.m_numElements];
        this.m_images = new FGImage[this.m_numElements];
        this.m_bNotes = new boolean[this.m_numElements];
        this.m_solidColorValue = new int[this.m_numElements];
        this.m_flip = new int[this.m_numElements];
        this.m_optElementIdxs = new int[this.m_numElements];
        for (int i = 0; i < this.m_numElements; ++i) {
            this.m_solidColorValue[i] = 0xFF00FF;
            this.m_flip[i] = 0;
        }
        return true;
    }

    public void setImage(int n, int n2, int n3, boolean bl, int n4, int n5, int n6, String string, String string2, boolean bl2) {
        int n7 = this.noteString(string);
        int n8 = this.noteString(string2);
        this.setImage(n, n2, n3, bl, n4, n5, n6, n7, n8, bl2);
    }

    public void setImage(int n, int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        this.m_xValues[n] = n2;
        this.m_yValues[n] = n3;
        this.m_bTileables[n] = bl;
        this.m_widths[n] = n4;
        this.m_heights[n] = n5;
        this.m_filenameIDs[n] = n7;
        this.m_IDStringIDs[n] = n8;
        this.m_bNotes[n] = bl2;
        this.m_flip[n] = n6;
        FGString fGString = new FGString(this.getElementName(n));
        if (fGString.startsWith("0x")) {
            FGString fGString2 = fGString.substring(2);
            this.m_solidColorValue[n] = fGString2.toIntFromHex();
        }
    }

    private int noteString(String string) {
        for (int i = 0; i < this.m_strings.getNumPointers(); ++i) {
            FGString fGString = (FGString)this.m_strings.getPointer(i);
            if (!fGString.equals(string)) continue;
            return i;
        }
        FGString fGString = new FGString(string);
        this.m_strings.addPointer(fGString);
        return this.m_strings.getNumPointers() - 1;
    }

    public String getString(int n) {
        FGString fGString = (FGString)this.m_strings.getPointer(n);
        return fGString.getNativeString();
    }

    private int getStringTableID(String string) {
        int n = FGString.getHash(string);
        for (int i = 0; i < this.m_strings.getNumPointers(); ++i) {
            FGString fGString;
            if (n != this.m_stringHashes[i] || !(fGString = (FGString)this.m_strings.getPointer(i)).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void clearArt() {
        for (int i = 0; i < this.m_numElements; ++i) {
            this.m_images[i] = null;
        }
    }

    public boolean isInOptRect(FGGraphics fGGraphics, int n, int n2) {
        int n3 = -n + fGGraphics.getClipX();
        int n4 = -n2 + fGGraphics.getClipY();
        int n5 = fGGraphics.getClipWidth();
        int n6 = fGGraphics.getClipHeight();
        if (n3 < this.m_optRectX) {
            return false;
        }
        if (n4 < this.m_optRectY) {
            return false;
        }
        if (n3 + n5 > this.m_optRectX + this.m_optRectW) {
            return false;
        }
        return n4 + n6 <= this.m_optRectY + this.m_optRectH;
    }

    public void recalcOpts(FGGraphics fGGraphics, int n, int n2) {
        int n3 = -n + fGGraphics.getClipX();
        int n4 = -n2 + fGGraphics.getClipY();
        int n5 = fGGraphics.getClipWidth();
        int n6 = fGGraphics.getClipHeight();
        this.m_optRectX = this.nearestChunk(n3);
        this.m_optRectY = this.nearestChunk(n4);
        int n7 = this.nearestChunk(n3 + n5) + 25;
        int n8 = this.nearestChunk(n4 + n6) + 25;
        this.m_optRectW = n7 - this.m_optRectX;
        this.m_optRectH = n8 - this.m_optRectY;
        this.m_numOptElements = 0;
        for (int i = 0; i < this.m_numElements; ++i) {
            if (!this.overlapsOpsRect(i)) continue;
            this.m_optElementIdxs[this.m_numOptElements] = i;
            ++this.m_numOptElements;
        }
    }

    private int nearestChunk(int n) {
        if (n % 25 == 0) {
            return n;
        }
        n -= n % 25;
        return n;
    }

    private boolean overlapsOpsRect(int n) {
        int n2 = this.m_optRectX + this.m_optRectW;
        int n3 = this.m_optRectY + this.m_optRectH;
        if (this.m_xValues[n] > n2) {
            return false;
        }
        if (this.m_xValues[n] + this.m_widths[n] < this.m_optRectX) {
            return false;
        }
        if (this.m_yValues[n] > n3) {
            return false;
        }
        return this.m_yValues[n] + this.m_heights[n] >= this.m_optRectY;
    }
}

