/*
 * Decompiled with CFR 0.152.
 */
import com.ea.sdk.SDKString;

class LifeEngine
extends FGEngine {
    private int OK_SPAM_TIME = 400;
    public static final int kSoftkeyOK = 0;
    public static final int kSoftkeyCancel = 1;
    public static final int kSoftkeyBack = 2;
    public static final int kSoftkeyStatus = 3;
    public static final int kSoftkeyMenu = 4;
    public static final int kEnglish = 0;
    public static final int kFrench = 1;
    public static final int kItalian = 2;
    public static final int kGerman = 3;
    public static final int kSpanish = 4;
    private static final int kOptionsSize = 8;
    FGImage m_pLife;
    FGImage m_pLifeImg;
    FGResLoader m_pResLoader;
    FGFont m_pSmallFont;
    FGFont m_pSmallBoldFont;
    FGFont m_pLargeFont;
    FGModeManager m_pModeMgr;
    FGEAStringManager m_pStringTable;
    FGSoundManager m_pSoundMgr;
    int m_LSKCode;
    UIButton m_LSK;
    int m_RSKCode;
    UIButton m_RSK;
    int m_pPSKCode;
    int m_pNSKCode;
    UIButton m_pPSK;
    UIButton m_pNSK;
    int m_intHack;
    boolean m_launchPending;
    boolean m_loading;
    boolean m_passNPlay;
    int m_progress;
    boolean m_loadGame;
    static LifeEngine m_instance;
    int m_temp;
    public String m_debugString;
    public String m_debugString1;
    boolean m_initing;
    int m_initStage;
    ModeGame m_pModeGame;
    long m_b4resources;
    long m_afterResources;
    long m_totalResources;
    boolean m_drawBar;
    boolean m_registered;
    int m_languageId;
    FGString m_thousandsSep;
    FGString m_currency;
    boolean m_useStartStop;
    boolean m_useBoardAnims;
    boolean m_useNiceBackground;
    boolean m_useHudCar;
    boolean m_useAllFonts;
    boolean m_useFireworks;
    boolean m_useSkidMarks;
    boolean m_doPaletteChange;
    boolean m_useCheats;
    boolean m_allowCheats;
    boolean m_versionOn;
    SDKString m_version;
    int m_versLen;
    int m_versHeight;
    boolean m_showedTutorial;
    boolean m_firstTime;
    boolean m_backgroundDrawPending;
    boolean m_bOKSpamming;
    FGTimer m_OKSpamTimer = new FGTimer();
    Board m_pBoard;
    Hud m_pHud;
    FGImage[][] m_pCarImgs = new FGImage[4][16];
    FGImage[][] m_pCarStartImgs;
    FGImage[][] m_pCarEndImgs;
    boolean m_bCarImagesPrepped;

    FGFont getSmallFont() {
        return this.m_pSmallFont;
    }

    FGFont getSmallBoldFont() {
        if (this.m_useAllFonts) {
            return this.m_pSmallBoldFont;
        }
        return this.m_pSmallFont;
    }

    FGFont getLargeFont() {
        return this.m_pSmallFont;
    }

    FGEAStringManager getStringTable() {
        return this.m_pStringTable;
    }

    FGModeManager getModeMgr() {
        return this.m_pModeMgr;
    }

    FGResLoader getResLoader() {
        return this.m_pResLoader;
    }

    boolean useStartStopAnims() {
        return this.m_useStartStop;
    }

    boolean useBoardAnims() {
        return this.m_useBoardAnims;
    }

    boolean useNiceBackground() {
        return this.m_useNiceBackground;
    }

    boolean useHudCar() {
        return this.m_useHudCar;
    }

    boolean useFireworks() {
        return this.m_useFireworks;
    }

    boolean useSkidMarks() {
        return this.m_useSkidMarks;
    }

    boolean allowCheats() {
        return this.m_allowCheats;
    }

    boolean doPaletteChange() {
        return this.m_doPaletteChange;
    }

    boolean cheatsOn() {
        return this.m_useCheats;
    }

    void setCheats(boolean bl) {
        this.m_useCheats = bl;
    }

    void showVersion(boolean bl) {
        this.m_versionOn = bl;
    }

    boolean isFirstTime() {
        return this.m_firstTime;
    }

    boolean shouldShowTutorial() {
        return this.isFirstTime() && !this.m_showedTutorial;
    }

    void setShowedTutorial(boolean bl) {
        this.m_showedTutorial = bl;
    }

    int getIntHack() {
        return this.m_intHack;
    }

    void setIntHack(int n) {
        this.m_intHack = n;
    }

    static LifeEngine getInstance() {
        return m_instance;
    }

    LifeEngine() {
        m_instance = this;
        this.m_languageId = -1;
    }

    public void init() {
        this.m_backgroundDrawPending = false;
        this.m_versionOn = false;
        this.m_initing = false;
        this.m_temp = 0;
        this.m_pResLoader = new FGResLoader();
        this.m_pResLoader.init(384);
        this.m_loadGame = false;
        this.m_useStartStop = false;
        this.m_useBoardAnims = false;
        this.m_useNiceBackground = false;
        this.m_useHudCar = false;
        this.m_useAllFonts = false;
        this.m_useFireworks = false;
        this.m_useSkidMarks = false;
        this.m_doPaletteChange = false;
        if (this.getProperty("START_STOP") != null) {
            this.m_useStartStop = true;
        }
        if (this.getProperty("BOARD_ANIMS") != null) {
            this.m_useBoardAnims = true;
        }
        if (this.getProperty("NICE_BG") != null) {
            this.m_useNiceBackground = true;
        }
        if (this.getProperty("HUD_CAR") != null) {
            this.m_useHudCar = true;
        }
        if (this.getProperty("ALL_FONTS") != null) {
            this.m_useAllFonts = true;
        }
        if (this.getProperty("USE_FIREWORKS") != null) {
            this.m_useFireworks = true;
        }
        if (this.getProperty("SKID_MARKS") != null) {
            this.m_useSkidMarks = true;
        }
        if (this.getProperty("PALETTE_CHANGE") != null) {
            this.m_doPaletteChange = true;
        }
        this.m_allowCheats = false;
        this.setCheats(false);
        if (this.m_useAllFonts) {
            this.m_pSmallFont = new FGFont();
            this.m_pSmallFont.init("font_small.png", "font_small.rff");
            this.m_pSmallBoldFont = new FGFont();
            this.m_pSmallBoldFont.init("font_small_bold.png", "font_small_bold.rff");
            this.m_pLargeFont = new FGFont();
            this.m_pLargeFont.init("font_large.png", "font_large.rff");
        } else {
            this.m_pSmallFont = new FGFont();
            this.m_pSmallFont.init("font_small.png", "font_small.rff");
        }
        this.m_pStringTable = new FGEAStringManager();
        this.m_pStringTable.init();
        this.m_showedTutorial = false;
        if (SaveGame.isRMS("LIFEO")) {
            if (this.readOptions()) {
                this.m_firstTime = false;
            } else {
                this.m_firstTime = true;
                this.setLanguage(0);
            }
        } else {
            this.m_firstTime = true;
            this.setLanguage(0);
        }
        this.m_pSoundMgr = new FGSoundManager();
        this.m_pSoundMgr.init();
        this.registerUIImages();
        this.m_pResLoader.registerImage("spinnerSpinning2.png");
        this.m_pResLoader.loadAllResources();
        this.registerSounds();
        this.m_LSK = new UIButton();
        this.m_RSK = new UIButton();
        this.m_LSKCode = this.AVK_LEFT_SOFT;
        this.m_RSKCode = this.AVK_RIGHT_SOFT;
        this.m_LSK.init(this.m_pResLoader.getImage("icon_ok.png"), 0);
        this.m_RSK.init(this.m_pResLoader.getImage("icon_ok.png"), 0);
        this.m_LSK.setPos(0, this.getScreenHeight() - this.m_LSK.getHeight());
        this.m_RSK.setPos(this.getScreenWidth() - this.m_RSK.getWidth(), this.getScreenHeight() - this.m_RSK.getHeight());
        this.m_pNSKCode = this.m_RSKCode;
        this.m_pNSK = this.m_RSK;
        this.m_pPSKCode = this.m_LSKCode;
        this.m_pPSK = this.m_LSK;
        this.positiveSoftkeySet(0);
        this.negativeSoftkeySet(2);
        ModeSplash modeSplash = new ModeSplash();
        ((FGMode)modeSplash).init();
        this.m_pModeMgr = new FGModeManager();
        this.m_pModeMgr.setMode(modeSplash);
        this.m_loading = false;
        this.m_progress = 0;
        this.m_launchPending = false;
        this.m_drawBar = false;
        this.m_registered = false;
        String string = FGApp.g_app.getAppProperty("MIDlet-Version");
        if (string == null) {
            string = "NO VERS";
        }
        this.m_version = new SDKString(string);
        this.m_versLen = this.m_pSmallFont.getDisplayLength(this.m_version);
        this.m_versHeight = this.m_pSmallFont.getHeight();
    }

    public void onKeyPressed(int n) {
        if (n == this.AVK_SONYQUIT) {
            n = this.AVK_RIGHT_SOFT;
        }
        if (this.m_pModeMgr.m_nextAction != -1) {
            return;
        }
        this.m_pModeMgr.keyPressed(n);
    }

    public void onKeyReleased(int n) {
        if (this.m_pModeMgr.m_nextAction != -1) {
            return;
        }
        this.m_pModeMgr.keyReleased(n);
    }

    public void onDrawSelf(FGGraphics fGGraphics) {
        if (this.m_backgroundDrawPending) {
            FGResLoader fGResLoader = this.getResLoader();
            ModeMenu.drawBackgroundWithLogo(fGGraphics, fGResLoader.getImage("splash_b.png"));
            this.m_backgroundDrawPending = false;
        }
        this.m_pModeMgr.drawSelf(fGGraphics);
        if (!this.m_loading) {
            this.m_LSK.drawSelf(fGGraphics);
            this.m_RSK.drawSelf(fGGraphics);
        }
        if (this.m_loading || this.m_initing || this.m_drawBar) {
            int n = this.getScreenWidth() / 2;
            int n2 = 6;
            int n3 = (this.getScreenWidth() - n) / 2;
            int n4 = this.getScreenHeight() - 12;
            int n5 = this.m_progress * n / 100;
            fGGraphics.setColor(0);
            fGGraphics.drawRect(n3 - 1, n4 - 1, n + 2, n2 + 1);
            fGGraphics.setColor(FGGraphics.makeRGB(255, 255, 255));
            fGGraphics.fillRect(n3, n4, n, n2);
            fGGraphics.setColor(FGGraphics.makeRGB(0, 255, 0));
            fGGraphics.fillRect(n3, n4, n5, n2);
        }
        if (this.m_drawBar && !this.m_registered) {
            this.m_launchPending = true;
        }
    }

    public void onTick() {
        if (this.m_bOKSpamming && this.m_OKSpamTimer.isOver()) {
            this.onKeyPressed(this.AVK_FIRE);
            this.onKeyReleased(this.AVK_FIRE);
            this.m_OKSpamTimer.start(this.OK_SPAM_TIME);
        }
        ++this.m_temp;
        this.m_pModeMgr.tick();
        if (this.m_launchPending) {
            if (!this.m_registered) {
                this.registerGameImages();
            }
            this.m_registered = true;
            this.m_loading = true;
            this.negativeSoftkeyShow(false);
            this.positiveSoftkeyShow(false);
            this.m_launchPending = false;
        } else if (this.m_loading) {
            this.m_pResLoader.loadNextResource();
            int n = this.m_pResLoader.getProgress(0);
            this.m_progress = 3 * n / 4;
            if (n == 100) {
                this.m_loading = false;
                this.m_initing = true;
                this.m_initStage = 0;
            }
        } else if (this.m_initing) {
            switch (this.m_initStage) {
                case 0: {
                    this.m_pModeGame = this.m_passNPlay ? new ModePassNPlay() : new ModeGame();
                    this.m_pModeGame.init0(this.m_loadGame);
                    this.m_initStage = 1;
                    this.m_progress += 6;
                    break;
                }
                case 1: {
                    this.m_pModeGame.init1();
                    this.m_initStage = 2;
                    this.m_progress += 6;
                    break;
                }
                case 2: {
                    this.m_pModeGame.init2();
                    this.m_initStage = 3;
                    this.m_progress += 6;
                    break;
                }
                case 3: {
                    this.m_pModeGame.init3();
                    this.m_initStage = 4;
                    this.m_progress += 6;
                    break;
                }
                case 4: {
                    this.m_pModeMgr.setMode(this.m_pModeGame);
                    this.m_initing = false;
                    this.m_drawBar = false;
                    this.m_versionOn = false;
                }
            }
        }
    }

    Board getBoard() {
        if (this.m_pBoard == null) {
            this.m_pBoard = new Board();
        }
        return this.m_pBoard;
    }

    Hud getHud() {
        if (this.m_pHud == null) {
            this.m_pHud = new Hud();
        }
        return this.m_pHud;
    }

    void prepCarImages() {
        if (this.m_bCarImagesPrepped) {
            return;
        }
        FGResLoader fGResLoader = this.getResLoader();
        if (this.useStartStopAnims()) {
            this.m_pCarStartImgs = new FGImage[4][16];
            this.m_pCarEndImgs = new FGImage[4][16];
        }
        for (int i = 0; i < 16; ++i) {
            this.m_pCarImgs[0][i] = fGResLoader.getImageFromSet("carGred", ".png", i, false, false);
            if (!this.useStartStopAnims()) continue;
            this.m_pCarStartImgs[0][i] = fGResLoader.getImageFromSet("carGstart01_red", ".png", i, false, false);
            this.m_pCarEndImgs[0][i] = fGResLoader.getImageFromSet("carGstop01_red", ".png", i, false, false);
        }
        FGPaletteChanger fGPaletteChanger = new FGPaletteChanger();
        FGString fGString = new FGString();
        for (int i = 1; i <= 3; ++i) {
            switch (i) {
                case 1: {
                    fGPaletteChanger.init("car_yellow.plf");
                    break;
                }
                case 2: {
                    fGPaletteChanger.init("car_blue.plf");
                    break;
                }
                case 3: {
                    fGPaletteChanger.init("car_green.plf");
                }
            }
            for (int j = 0; j < 16; ++j) {
                fGString.set("carGred");
                fGString.add(j + 1);
                fGString.add(".png");
                this.m_pCarImgs[i][j] = fGPaletteChanger.createRepalettedImage(fGString.getNativeString());
                if (!this.useStartStopAnims()) continue;
                fGString.set("carGstart01_red");
                fGString.add(j + 1);
                fGString.add(".png");
                this.m_pCarStartImgs[i][j] = fGPaletteChanger.createRepalettedImage(fGString.getNativeString());
                fGString.set("carGstop01_red");
                fGString.add(j + 1);
                fGString.add(".png");
                this.m_pCarEndImgs[i][j] = fGPaletteChanger.createRepalettedImage(fGString.getNativeString());
            }
        }
        this.m_bCarImagesPrepped = true;
    }

    public void onPause() {
        if (this.m_pModeMgr != null) {
            this.m_pModeMgr.pause();
        }
    }

    public void onResume() {
        if (this.m_loading || this.m_initing) {
            this.m_backgroundDrawPending = true;
        }
        if (this.m_pModeMgr != null) {
            this.m_pModeMgr.resume();
        }
    }

    public void onExitApp() {
        this.writeOptions();
    }

    public void launchGame(boolean bl, boolean bl2) {
        this.m_pModeMgr.popMode();
        this.m_launchPending = true;
        this.m_drawBar = true;
        this.m_loadGame = bl;
        this.m_passNPlay = bl2;
    }

    boolean isPositiveSoftkey(int n) {
        if (!this.m_pPSK.getVisible()) {
            return false;
        }
        return n == this.m_pPSKCode;
    }

    void positiveSoftkeyShow(boolean bl) {
        this.m_pPSK.setVisible(bl);
    }

    void positiveSoftkeySet(int n) {
        this.m_pPSK.setImage(this.softkey2Img(n));
        this.m_pPSK.setVisible(true);
        if (this.m_pPSK == this.m_RSK) {
            int n2 = this.m_RSK.getWidth();
            this.m_RSK.setPos(this.getScreenWidth() - n2, this.getScreenHeight() - this.m_RSK.getHeight());
        }
    }

    int softkeyHeight() {
        return this.m_LSK.getHeight();
    }

    void negativeSoftkeySet(int n) {
        this.m_pNSK.setImage(this.softkey2Img(n));
        this.m_pNSK.setVisible(true);
        if (this.m_pNSK == this.m_RSK) {
            int n2 = this.m_RSK.getWidth();
            this.m_RSK.setPos(this.getScreenWidth() - n2, this.getScreenHeight() - this.m_RSK.getHeight());
        }
    }

    boolean isNegativeSoftkey(int n) {
        if (!this.m_pNSK.getVisible()) {
            return false;
        }
        return n == this.m_pNSKCode;
    }

    void negativeSoftkeyShow(boolean bl) {
        this.m_pNSK.setVisible(bl);
    }

    FGImage softkey2Img(int n) {
        FGResLoader fGResLoader = LifeEngine.getInstance().getResLoader();
        switch (n) {
            case 0: {
                return fGResLoader.getImage("icon_ok.png");
            }
            case 1: {
                return fGResLoader.getImage("icon_cancel.png");
            }
            case 2: {
                return fGResLoader.getImage("icon_back.png");
            }
            case 3: {
                return fGResLoader.getImage("icon_player.png");
            }
            case 4: {
                return fGResLoader.getImage("icon_menu.png");
            }
        }
        return fGResLoader.getImage("icon_ok.png");
    }

    void registerUIImages() {
        FGResLoader fGResLoader = LifeEngine.getInstance().getResLoader();
        fGResLoader.registerImage("button_off.png");
        fGResLoader.registerImage("button_on.png");
        fGResLoader.registerImage("splash_b.png");
        if (LifeEngine.getInstance().useNiceBackground()) {
            fGResLoader.registerImage("splash_b2.png");
        }
        fGResLoader.registerImage("icon_back.png");
        fGResLoader.registerImage("icon_cancel.png");
        fGResLoader.registerImage("icon_player.png");
        fGResLoader.registerImage("icon_menu.png");
        fGResLoader.registerImage("icon_ok.png");
        fGResLoader.registerImage("arrow_sm_down.png");
    }

    void registerGameImages() {
        FGResLoader fGResLoader = LifeEngine.getInstance().getResLoader();
        BetterHouseCardPile.registerNeededImages(fGResLoader);
        Board.registerNeededImages(fGResLoader);
        CareerCardPile.registerNeededImages(fGResLoader);
        CollegeCareerCardPile.registerNeededImages(fGResLoader);
        Hud.registerNeededImages(fGResLoader);
        ModeChoose.registerNeededImages(fGResLoader);
        ModeChoosePath.registerNeededImages(fGResLoader);
        ModeGame.registerNeededImages(fGResLoader);
        ShareTheWealthCardPile.registerNeededImages(fGResLoader);
        StarterHouseCardPile.registerNeededImages(fGResLoader);
        ModeSpin2Win.registerNeededImages(fGResLoader);
    }

    void megaPause() {
        FGPointerList fGPointerList = this.getTimerRegistry();
        for (int i = 0; i < fGPointerList.getNumPointers(); ++i) {
            FGTimer fGTimer = (FGTimer)fGPointerList.getPointer(i);
            fGTimer.pause();
        }
    }

    void megaResume() {
        FGPointerList fGPointerList = this.getTimerRegistry();
        for (int i = 0; i < fGPointerList.getNumPointers(); ++i) {
            FGTimer fGTimer = (FGTimer)fGPointerList.getPointer(i);
            fGTimer.resume();
        }
    }

    void setLanguage(int n) {
        if (n == this.m_languageId) {
            return;
        }
        this.m_pStringTable.setLanguage(n);
        this.m_languageId = n;
        switch (n) {
            default: {
                this.m_pLife = FGImage.createImage("splash_t_en.png");
                this.m_pLifeImg = FGImage.createImage("icon_life_en.png");
                break;
            }
            case 1: {
                this.m_pLife = FGImage.createImage("splash_t_fr.png");
                this.m_pLifeImg = FGImage.createImage("icon_life_fr.png");
                break;
            }
            case 3: {
                this.m_pLife = FGImage.createImage("splash_t_de.png");
                this.m_pLifeImg = FGImage.createImage("icon_life_de.png");
                break;
            }
            case 4: {
                this.m_pLife = FGImage.createImage("splash_t_es.png");
                this.m_pLifeImg = FGImage.createImage("icon_life_es.png");
            }
        }
        this.m_currency = this.m_pStringTable.getFGString(32);
        this.m_thousandsSep = this.m_pStringTable.getFGString(39);
    }

    int getLanguage() {
        return this.m_languageId;
    }

    public void deleteSavedGame() {
        SaveGame.deleteRMS("LIFEG");
        SaveGame.deleteRMS("LIFEP");
    }

    void writeOptions() {
        FGData fGData = new FGData();
        fGData.init(8);
        int n = this.getLanguage();
        fGData.m_data[0] = (byte)n;
        boolean bl = this.getSoundManager().getSoundOn();
        boolean bl2 = bl;
        fGData.m_data[1] = (byte)(bl2 ? 1 : 0);
        boolean bl3 = this.getSoundManager().getVibrateOn();
        boolean bl4 = bl3;
        fGData.m_data[2] = (byte)(bl4 ? 1 : 0);
        fGData.m_dataLength = 3;
        SaveGame.saveRMS("LIFEO", fGData);
        fGData = null;
    }

    public boolean readOptions() {
        if (SaveGame.isRMS("LIFEO")) {
            byte by;
            FGData fGData = SaveGame.getRMS("LIFEO");
            byte by2 = by = fGData.m_data[0];
            this.setLanguage(by);
            by = fGData.m_data[1];
            boolean bl = by == 1;
            this.getSoundManager().setSoundOn(bl);
            by = fGData.m_data[2];
            boolean bl2 = by == 1;
            this.getSoundManager().setVibrateOn(bl2);
            fGData = null;
            return true;
        }
        return false;
    }

    void registerSounds() {
        this.getSoundManager().registerSound();
    }
}

