/*
 * Decompiled with CFR 0.152.
 */
class FGVector {
    public int m_fixX;
    public int m_fixY;

    public void set(FGVector fGVector) {
        this.m_fixX = fGVector.m_fixX;
        this.m_fixY = fGVector.m_fixY;
    }

    public void setXY(int n, int n2) {
        this.m_fixX = n;
        this.m_fixY = n2;
    }

    public boolean equals(FGVector fGVector) {
        return this.m_fixX == fGVector.m_fixX && this.m_fixY == fGVector.m_fixY;
    }

    public void setRTheta(int n, int n2) {
        int n3 = FGFixed.cos(n2);
        int n4 = FGFixed.sin(n2);
        this.m_fixX = FGFixed.multiply(n, n3);
        this.m_fixY = FGFixed.multiply(n, n4);
    }

    public int getLength() {
        int n = FGFixed.multiply(this.m_fixX, this.m_fixX);
        int n2 = FGFixed.multiply(this.m_fixY, this.m_fixY);
        int n3 = n + n2;
        return FGFixed.sqrt(n3);
    }

    public int getAngle() {
        int n = FGFixed.atan2(this.m_fixX, this.m_fixY);
        return n;
    }

    public void addVector(FGVector fGVector) {
        this.m_fixX += fGVector.m_fixX;
        this.m_fixY += fGVector.m_fixY;
    }

    public void subtractVector(FGVector fGVector) {
        this.m_fixX -= fGVector.m_fixX;
        this.m_fixY -= fGVector.m_fixY;
    }

    public void scalarMultiply(int n) {
        if (n < FGFixed.toFixed(1)) {
            int n2 = FGFixed.divide(FGFixed.toFixed(1), n);
            this.m_fixX = FGFixed.divide(this.m_fixX, n2);
            this.m_fixY = FGFixed.divide(this.m_fixY, n2);
        } else {
            this.m_fixX = FGFixed.multiply(this.m_fixX, n);
            this.m_fixY = FGFixed.multiply(this.m_fixY, n);
        }
    }

    public void scalarDivide(int n) {
        if (n < FGFixed.toFixed(1)) {
            int n2 = FGFixed.divide(FGFixed.toFixed(1), n);
            this.m_fixX = FGFixed.multiply(this.m_fixX, n2);
            this.m_fixY = FGFixed.multiply(this.m_fixY, n2);
        } else {
            this.m_fixX = FGFixed.divide(this.m_fixX, n);
            this.m_fixY = FGFixed.divide(this.m_fixY, n);
        }
    }

    public void rotate(int n) {
        int n2 = FGFixed.multiply(this.m_fixX, FGFixed.cos(n)) - FGFixed.multiply(this.m_fixY, FGFixed.sin(n));
        int n3 = FGFixed.multiply(this.m_fixX, FGFixed.sin(n)) + FGFixed.multiply(this.m_fixY, FGFixed.cos(n));
        this.m_fixX = n2;
        this.m_fixY = n3;
    }

    public void normalize() {
        int n = this.getLength();
        this.scalarDivide(n);
    }

    public void setLength(int n) {
        int n2 = this.getLength();
        this.scalarMultiply(n);
        this.scalarDivide(n2);
    }

    public FGString toFGString() {
        String string = "(" + FGFixed.toFGString(this.m_fixX) + ", " + FGFixed.toFGString(this.m_fixY) + ")";
        return new FGString(string);
    }
}

