/*
 * Decompiled with CFR 0.152.
 */
class FGPointerList {
    public static final int DEFAULT_STARTSIZE = 8;
    public static final int DEFAULT_GROWSIZE = 16;
    private Object[] m_pointers;
    private int m_allocated;
    private int m_numPointers;
    private int m_growSize;

    public FGPointerList() {
        this.init(8, 16);
    }

    public FGPointerList(int n, int n2) {
        this.init(n, n2);
    }

    private void init(int n, int n2) {
        this.m_growSize = n2;
        this.growTo(n);
        this.m_numPointers = 0;
    }

    public void clear() {
        for (int i = 0; i < this.m_allocated; ++i) {
            this.m_pointers[i] = null;
        }
        this.m_numPointers = 0;
    }

    public void addPointer(Object object) {
        this.ensureSize(this.m_numPointers + 1);
        this.m_pointers[this.m_numPointers] = object;
        ++this.m_numPointers;
    }

    public void removePointer(Object object) {
        int n = this.getPointerIdx(object);
        if (n == -1) {
            return;
        }
        this.removePointer(n);
    }

    public void deleteAllPointers() {
    }

    public void removePointer(int n) {
        this.m_pointers[n] = null;
        for (int i = n; i < this.m_numPointers - 1; ++i) {
            this.m_pointers[i] = this.m_pointers[i + 1];
        }
        --this.m_numPointers;
    }

    public int getNumPointers() {
        return this.m_numPointers;
    }

    public Object getPointer(int n) {
        return this.m_pointers[n];
    }

    public int getPointerIdx(Object object) {
        for (int i = 0; i < this.m_numPointers; ++i) {
            if (object != this.m_pointers[i]) continue;
            return i;
        }
        return -1;
    }

    private void ensureSize(int n) {
        if (this.m_allocated < n) {
            this.growTo(this.m_allocated + this.m_growSize);
        }
    }

    private void growTo(int n) {
        Object[] objectArray = new Object[n];
        if (this.m_pointers != null) {
            System.arraycopy(this.m_pointers, 0, objectArray, 0, this.m_numPointers);
        }
        this.m_pointers = objectArray;
        this.m_allocated = n;
    }
}

