/*
 * Decompiled with CFR 0.152.
 */
class FGPakReader {
    private FGFileData[] m_files;
    private FGData m_pakData;
    private int m_numFiles;

    public boolean init(String string) {
        FGData fGData = StaticMethods.getByteArrayFromFile(string);
        if (fGData == null) {
            System.out.println("Could not open pak file");
            return false;
        }
        return this.init(fGData);
    }

    public boolean init(FGData fGData) {
        this.m_pakData = fGData;
        FGDataReader fGDataReader = new FGDataReader();
        fGDataReader.init(this.m_pakData);
        FGData fGData2 = new FGData();
        fGData2.init(5);
        fGDataReader.readRaw(fGData2, 5);
        FGString fGString = new FGString(fGData2);
        if (!fGString.equals(new FGString("FGPAK"))) {
            System.out.println("Invalid pak file format");
            return false;
        }
        fGDataReader.readInt();
        this.m_numFiles = fGDataReader.readInt();
        this.m_files = new FGFileData[this.m_numFiles];
        for (int i = 0; i < this.m_numFiles; ++i) {
            this.m_files[i] = new FGFileData();
            this.m_files[i].m_fileName = fGDataReader.readUTF();
            this.m_files[i].m_compSize = fGDataReader.readInt();
            this.m_files[i].m_uncompSize = fGDataReader.readInt();
            if (this.m_files[i].m_compSize != this.m_files[i].m_uncompSize) {
                System.out.println("pak file has compression. J2ME side doesn't support compression");
                return false;
            }
            this.m_files[i].m_offset = fGDataReader.readInt();
        }
        return true;
    }

    public FGData getFile(String string) {
        int n = this.getFileIdx(string);
        if (n == -1) {
            return null;
        }
        int n2 = this.m_files[n].m_uncompSize;
        FGData fGData = new FGData();
        fGData.init(n2);
        return this.getFile(string, fGData);
    }

    public FGData getFile(String string, FGData fGData) {
        int n = this.getFileIdx(string);
        if (n == -1) {
            return null;
        }
        int n2 = this.m_files[n].m_offset;
        int n3 = this.m_files[n].m_uncompSize;
        System.arraycopy(this.m_pakData.m_data, n2, fGData.m_data, 0, n3);
        fGData.m_dataLength = n3;
        return fGData;
    }

    public int getFileStart(String string) {
        int n = this.getFileIdx(string);
        if (n == -1) {
            return -1;
        }
        int n2 = this.m_files[n].m_offset;
        return n2;
    }

    public int getNumFiles() {
        return this.m_numFiles;
    }

    public FGString getFileName(int n) {
        return this.m_files[n].m_fileName;
    }

    public int getFileLength(String string) {
        int n = this.getFileIdx(string);
        if (n == -1) {
            return -1;
        }
        return this.m_files[n].m_uncompSize;
    }

    private int getFileIdx(String string) {
        for (int i = 0; i < this.m_numFiles; ++i) {
            if (!this.m_files[i].m_fileName.equals(string)) continue;
            return i;
        }
        return -1;
    }

    class FGFileData {
        public FGString m_fileName;
        int m_offset;
        int m_uncompSize;
        int m_compSize;
        boolean m_bSaved;

        FGFileData() {
        }
    }
}

