/*
 * Decompiled with CFR 0.152.
 */
class FGFixed {
    public static final int SHIFT_BITS = 8;
    public static final int ONE = 256;
    public static final int[] g_sinTable = new int[]{0, 25, 50, 74, 98, 121, 142, 162, 181, 198, 213, 226, 237, 245, 251, 255, 256, 255, 251, 245, 237, 226, 213, 198, 181, 162, 142, 121, 98, 74, 50, 25, 0, -25, -50, -74, -98, -121, -142, -162, -181, -198, -213, -226, -237, -245, -251, -255, -256, -255, -251, -245, -237, -226, -213, -198, -181, -162, -142, -121, -98, -74, -50, -25};
    public static final int[] g_cosTable = new int[]{256, 255, 251, 245, 237, 226, 213, 198, 181, 162, 142, 121, 98, 74, 50, 25, 0, -25, -50, -74, -98, -121, -142, -162, -181, -198, -213, -226, -237, -245, -251, -255, -256, -255, -251, -245, -237, -226, -213, -198, -181, -162, -142, -121, -98, -74, -50, -25, 0, 25, 50, 74, 98, 121, 142, 162, 181, 198, 213, 226, 237, 245, 251, 255};
    public static final int FOURKAYS_PER_TAN_TABLE_ENTRY = 16;
    public static final int[] g_tanTable = new int[]{0, 6, 13, 19, 25, 32, 38, 44, 51, 57, 64, 71, 78, 85, 92, 99, 106, 113, 121, 129, 137, 145, 153, 162, 171, 180, 190, 200, 210, 221, 232, 244, 256, 269, 282, 297, 312, 328, 345, 363, 383, 404, 427, 452, 479, 509, 541, 578, 618, 664, 715, 775, 844, 925, 1022, 1140, 1287, 1475, 1726, 2076, 2599, 3471, 5211, 10428, 20000};

    private FGFixed() {
    }

    public static int toFixed(int n) {
        return n << 8;
    }

    public static int toInt(int n) {
        return n >> 8;
    }

    public static int toFixedFourkays(int n) {
        int n2 = n * 4096 / 360;
        return FGFixed.toFixed(n2);
    }

    public static FGString toDegreesFGString(int n) {
        int n2 = FGFixed.multiply(n, FGFixed.toFixed(360));
        n2 = FGFixed.divide(n2, FGFixed.toFixed(4096));
        return FGFixed.toFGString(n2);
    }

    public static int toDegrees(int n) {
        int n2 = FGFixed.multiply(n, FGFixed.toFixed(360));
        n2 = FGFixed.divide(n2, FGFixed.toFixed(4096));
        return FGFixed.toInt(n2);
    }

    public static FGString toFGString(int n) {
        boolean bl = false;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        int n2 = FGFixed.toInt(n);
        int n3 = FGFixed.multiply(n, FGFixed.toFixed(1000));
        int n4 = FGFixed.toInt(n3 -= FGFixed.multiply(FGFixed.toFixed(n2), FGFixed.toFixed(1000)));
        String string = bl ? "-" : "";
        string = string + "" + n2;
        string = string + ".";
        if (n4 < 100) {
            string = string + "0";
        }
        if (n4 < 10) {
            string = string + "0";
        }
        string = string + n4;
        return new FGString(string);
    }

    public static int multiply(int n, int n2) {
        int n3 = n * n2;
        return n3 >> 8;
    }

    public static int divide(int n, int n2) {
        return (n <<= 8) / n2;
    }

    public static int divideLargeNumerator(int n, int n2) {
        n /= n2;
        return n <<= 8;
    }

    public static int sqrt(int n) {
        int n2 = 44721;
        int n3 = n2 * 2;
        if (n > n3) {
            int n4;
            int n5 = 2;
            int n6 = n;
            while (n6 > n3) {
                n4 = n5 * n5;
                n6 = FGFixed.divideLargeNumerator(n, FGFixed.toFixed(n4));
                if (n6 < n3) continue;
                ++n5;
            }
            n4 = FGFixed.doSqrt(n6);
            int n7 = FGFixed.multiply(n4, FGFixed.toFixed(n5));
            return n7;
        }
        return FGFixed.doSqrt(n);
    }

    private static int doSqrt(int n) {
        int n2;
        if (n < 0) {
            throw new ArithmeticException("Negative value sent to FGFixed.sqrt()");
        }
        if (n == 0) {
            return 0;
        }
        int n3 = n;
        int n4 = 0;
        int n5 = n3 / 2;
        int n6 = 0;
        boolean bl = false;
        while (!bl) {
            n2 = n5 * n5;
            if (n2 > n) {
                if (n5 - 1 == n4) {
                    n6 = n4;
                    bl = true;
                }
                n3 = n5;
                n5 = n4 + (n3 - n4) / 2;
                continue;
            }
            if (n2 < n) {
                if (n5 + 1 == n3) {
                    n6 = n5;
                    bl = true;
                }
                n4 = n5;
                n5 = n4 + (n3 - n4) / 2;
                continue;
            }
            n6 = n5;
            bl = true;
        }
        n2 = n6 << 4;
        return n2;
    }

    public static int sin(int n) {
        int n2 = FGFixed.toInt(n);
        n2 = FGFixed.conformAngle(n2);
        return FGFixed.getTableValue(g_sinTable, n2);
    }

    public static int cos(int n) {
        int n2 = FGFixed.toInt(n);
        n2 = FGFixed.conformAngle(n2);
        return FGFixed.getTableValue(g_cosTable, n2);
    }

    public static int conformAngle(int n) {
        int n2 = n;
        if (n < 0) {
            n2 = -n2;
            n2 %= 4096;
            n2 = -n2;
            n2 += 4096;
        } else {
            n2 %= 4096;
        }
        return n2;
    }

    public static int atan2(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n == 0) {
            if (n2 > 0) {
                return FGFixed.toFixedFourkays(90);
            }
            if (n2 < 0) {
                return FGFixed.toFixedFourkays(270);
            }
            return 0;
        }
        int n6 = FGFixed.divide(n2, n);
        if (n6 < 0) {
            n6 = -n6;
        }
        int n7 = -1;
        int n8 = -1;
        for (n5 = 0; n5 < g_tanTable.length - 1; ++n5) {
            n4 = n5;
            n3 = n5 + 1;
            if (n6 < g_tanTable[n4] || n6 >= g_tanTable[n3]) continue;
            n7 = n4;
            n8 = n3;
            break;
        }
        if (n7 != -1) {
            n4 = g_tanTable[n7];
            n3 = g_tanTable[n8];
            int n9 = n3 - n4;
            int n10 = FGFixed.toFixed(n7 * 16);
            int n11 = FGFixed.toFixed(n8 * 16);
            int n12 = n11 - n10;
            int n13 = n6 - n4;
            int n14 = FGFixed.multiply(n13, n12);
            n14 = FGFixed.divide(n14, n9);
            n5 = n10 + n14;
        } else {
            n5 = FGFixed.toFixedFourkays(90);
        }
        if (n > 0 && n2 >= 0) {
            return n5;
        }
        if (n < 0 && n2 >= 0) {
            return FGFixed.toFixedFourkays(180) - n5;
        }
        if (n < 0 && n2 <= 0) {
            return FGFixed.toFixedFourkays(180) + n5;
        }
        return FGFixed.toFixedFourkays(360) - n5;
    }

    private static int getTableValue(int[] nArray, int n) {
        int n2 = n * nArray.length / 4096;
        int n3 = n2 + 1;
        int n4 = nArray[n2];
        int n5 = n3 == nArray.length ? nArray[0] : nArray[n3];
        int n6 = n2 * 4096 / nArray.length;
        int n7 = n3 * 4096 / nArray.length;
        int n8 = n7 - n6;
        int n9 = n5 - n4;
        int n10 = n4 + (n - n6) * n9 / n8;
        return n10;
    }
}

