/*
 * Decompiled with CFR 0.152.
 */
import com.ea.sdk.SDKString;

public class ModeChooseHouse
extends ModeChoose {
    int m_defaultCardHeight;
    boolean m_bIsActiveMode;
    Player m_pPlayer;
    CardPile m_pCardPile;
    FGString m_line1;
    FGString m_line2;

    ModeChooseHouse() {
        this.m_ppCards = null;
        this.m_boardDrawPending = true;
    }

    void init(CardPile cardPile, Player player, int n) {
        FGResLoader fGResLoader = LifeEngine.getInstance().getResLoader();
        this.m_currCard = 0;
        this.m_title = new FGProcessedString();
        if (player.getHouse() == null) {
            this.m_title.init(LifeEngine.getInstance().getStringTable().getString(46));
        } else {
            this.m_title.init(LifeEngine.getInstance().getStringTable().getString(50));
        }
        this.m_title.process(this.m_titleFont, 7 * LifeEngine.getInstance().getScreenWidth() / 8);
        super.init(n);
        this.drawBackground(false);
        this.m_boardDrawPending = true;
        this.m_numCards = cardPile.getNumCards();
        this.m_ppCards = new Card[this.m_numCards];
        Card card = cardPile.getCards();
        for (int i = 0; i < this.m_numCards; ++i) {
            this.m_ppCards[i] = card;
            card = card.m_pNext;
        }
        FGEAStringManager fGEAStringManager = LifeEngine.getInstance().getStringTable();
        this.m_pPlayer = player;
        this.m_pCardPile = cardPile;
        this.m_cardWidth = cardPile.m_cardWidth;
        this.m_cardHeight = cardPile.m_cardHeight;
        this.CalcSize(this.m_ppCards[0]);
    }

    public void tick() {
        super.tick();
    }

    void DrawCardSpecific(FGGraphics fGGraphics, int n, int n2, int n3) {
        FGFont fGFont = LifeEngine.getInstance().getSmallFont();
        FGFont fGFont2 = LifeEngine.getInstance().getSmallBoldFont();
        int n4 = fGFont2.getHeight();
        int n5 = n3 + n4 / 2;
        HouseCard houseCard = (HouseCard)this.m_ppCards[n];
        houseCard.m_pImage.drawSelf(fGGraphics, n2 + (this.m_cardWidth - houseCard.m_pImage.getWidth()) / 2, n5);
        fGFont2.setJustify(2);
        fGFont.setJustify(2);
        houseCard.processText(this.m_cardWidth);
        fGFont2.drawProcessedText(fGGraphics, houseCard.m_pTitleStr, n2 + this.m_cardWidth / 2, n5 += houseCard.m_pImage.getHeight());
        fGFont2.drawProcessedText(fGGraphics, houseCard.m_pPriceStr, n2 + this.m_cardWidth / 2, n5 += houseCard.m_pTitleStr.m_displayHeight + n4);
        n5 += houseCard.m_pPriceStr.m_displayHeight + fGFont2.getHeight();
        if (houseCard.m_salePrice != -1) {
            fGFont.drawProcessedText(fGGraphics, houseCard.m_pSalePriceStr, n2 + this.m_cardWidth / 2, n5);
        }
        fGFont2.setJustify(0);
        fGFont.setJustify(0);
    }

    public void drawSelf(FGGraphics fGGraphics) {
        Object object;
        if (this.m_boardDrawPending) {
            object = LifeEngine.getInstance().getModeMgr();
            ((FGModeManager)object).getPreviousMode(1).drawSelf(fGGraphics);
        }
        super.drawSelf(fGGraphics);
        if (this.m_numCards == 1) {
            return;
        }
        object = (HouseCard)this.m_ppCards[this.m_currCard];
        if (((HouseCard)object).m_price > this.m_pPlayer.getCash()) {
            FGEAStringManager fGEAStringManager = LifeEngine.getInstance().getStringTable();
            SDKString sDKString = fGEAStringManager.getString(60);
            int n = LifeEngine.getInstance().getSmallBoldFont().getDisplayLength(sDKString);
            int n2 = n + LifeEngine.getInstance().getSmallBoldFont().getSpaceWidth() * 3;
            int n3 = LifeEngine.getInstance().getSmallBoldFont().getHeight() + 4;
            fGGraphics.setColor(FGGraphics.makeRGB(255, 255, 255));
            fGGraphics.fillRect(0, LifeEngine.getInstance().getScreenHeight() - n3, n2, n3);
            int n4 = (n2 - n) / 2;
            int n5 = LifeEngine.getInstance().getScreenHeight() - n3 + 4;
            LifeEngine.getInstance().getSmallBoldFont().drawText(fGGraphics, sDKString, n4, n5);
        }
    }

    void ShowHouse(Card card, int n) {
        if (this.m_ppCards == null) {
            this.m_ppCards = new Card[1];
        }
        this.m_ppCards[0] = card;
        this.m_numCards = 1;
        this.m_boardDrawPending = true;
        if (!this.m_drawTitleBar) {
            this.m_title = new FGProcessedString();
            this.m_title.init(LifeEngine.getInstance().getStringTable().getString(132));
            this.m_title.process(this.m_titleFont, 7 * LifeEngine.getInstance().getScreenWidth() / 8);
        }
        this.CalcSize(card);
        if (n != -1) {
            this.m_cardWidth = n;
        }
    }

    public void keyPressed(int n) {
        super.keyPressed(n);
        if (n == LifeEngine.getInstance().AVK_FIRE || n == 53) {
            if (this.m_numCards != 1) {
                HouseCard houseCard = (HouseCard)this.m_pCardPile.drawThisCard(this.m_ppCards[this.m_currCard]);
                this.m_pPlayer.buyHouse(houseCard);
            }
            LifeEngine.getInstance().getModeMgr().popMode();
        }
    }

    void CalcSize(Card card) {
        HouseCard houseCard = (HouseCard)card;
        if (houseCard.m_cardHeight > this.m_cardHeight) {
            this.m_cardHeight = houseCard.m_cardHeight;
        }
    }

    void GetCardSize(int n) {
        this.m_defaultCardHeight = this.m_cardHeight;
        HouseCard houseCard = (HouseCard)this.m_ppCards[n];
        this.m_cardHeight = houseCard.m_cardHeight;
    }

    void ResetCardSize() {
        this.m_cardHeight = this.m_defaultCardHeight;
    }
}

