/*
 * Decompiled with CFR 0.152.
 */
class FGPaletteChanger {
    private int crc = 0;
    private static int[] crc_table = FGPaletteChanger.make_crc_table();
    byte[] m_origReds;
    byte[] m_origGreens;
    byte[] m_origBlues;
    byte[] m_changedReds;
    byte[] m_changedGreens;
    byte[] m_changedBlues;
    int m_numChanges;

    public void init(String string) {
        FGData fGData = this.getFile(string);
        if (fGData == null) {
            FGEngine.fatal("Could not load palette difference file: " + string);
            return;
        }
        this.init(fGData);
    }

    public void init(FGData fGData) {
        FGDataReader fGDataReader = new FGDataReader();
        fGDataReader.init(fGData);
        if ((char)fGDataReader.readByte() != 'F') {
            FGEngine.fatal("invalid plf data");
            return;
        }
        if ((char)fGDataReader.readByte() != 'G') {
            FGEngine.fatal("invalid plf data");
            return;
        }
        if ((char)fGDataReader.readByte() != 'P') {
            FGEngine.fatal("invalid plf data");
            return;
        }
        if ((char)fGDataReader.readByte() != 'L') {
            FGEngine.fatal("invalid plf data");
            return;
        }
        if ((char)fGDataReader.readByte() != 'D') {
            FGEngine.fatal("invalid plf data");
            return;
        }
        if ((char)fGDataReader.readByte() != 'F') {
            FGEngine.fatal("invalid plf data");
            return;
        }
        int n = fGDataReader.readInt();
        if (n != 1) {
            FGEngine.fatal("invalid palette file version");
            return;
        }
        this.m_numChanges = fGDataReader.readInt();
        this.m_origReds = new byte[this.m_numChanges];
        this.m_origGreens = new byte[this.m_numChanges];
        this.m_origBlues = new byte[this.m_numChanges];
        this.m_changedReds = new byte[this.m_numChanges];
        this.m_changedGreens = new byte[this.m_numChanges];
        this.m_changedBlues = new byte[this.m_numChanges];
        for (int i = 0; i < this.m_numChanges; ++i) {
            this.m_origReds[i] = fGDataReader.readByte();
            this.m_origGreens[i] = fGDataReader.readByte();
            this.m_origBlues[i] = fGDataReader.readByte();
            this.m_changedReds[i] = fGDataReader.readByte();
            this.m_changedGreens[i] = fGDataReader.readByte();
            this.m_changedBlues[i] = fGDataReader.readByte();
        }
    }

    FGImage createRepalettedImage(String string) {
        FGString fGString = FGImage.getImageFilename(string);
        FGData fGData = this.getFile(fGString.getNativeString());
        if (fGData == null) {
            FGEngine.fatal("Could not load repaletting image data");
            return null;
        }
        return this.createRepalettedImage(fGData);
    }

    FGImage createRepalettedImage(FGData fGData) {
        int n;
        int n2;
        int n3;
        FGDataReader fGDataReader = new FGDataReader();
        fGDataReader.init(fGData);
        if (fGDataReader.readByte() != -119) {
            return null;
        }
        if (fGDataReader.readByte() != 80) {
            return null;
        }
        if (fGDataReader.readByte() != 78) {
            return null;
        }
        if (fGDataReader.readByte() != 71) {
            return null;
        }
        if (fGDataReader.readByte() != 13) {
            return null;
        }
        if (fGDataReader.readByte() != 10) {
            return null;
        }
        if (fGDataReader.readByte() != 26) {
            return null;
        }
        if (fGDataReader.readByte() != 10) {
            return null;
        }
        int n4 = -1;
        int n5 = -1;
        while (!fGDataReader.getError()) {
            n3 = fGDataReader.getDataPos();
            n2 = fGDataReader.readInt();
            n = fGDataReader.readInt();
            if (n == 1347179589) {
                n4 = n3;
                n5 = n2;
                break;
            }
            fGDataReader.setDataPos(fGDataReader.getDataPos() + n2);
            fGDataReader.readInt();
        }
        if (n4 == -1) {
            return null;
        }
        fGDataReader.setDataPos(n4);
        fGDataReader.readInt();
        fGDataReader.readInt();
        if (n5 % 3 != 0) {
            return null;
        }
        n3 = n5 / 3;
        for (n2 = 0; n2 < n3; ++n2) {
            this.adjustTriplet(fGData, fGDataReader.getDataPos());
            fGDataReader.setDataPos(fGDataReader.getDataPos() + 3);
        }
        n2 = fGDataReader.getDataPos();
        n = fGDataReader.readInt();
        this.reset();
        this.update(fGData.m_data, n4 + 4, n5 + 4);
        int n6 = (int)this.getValue();
        FGDataWriter fGDataWriter = new FGDataWriter();
        fGDataWriter.init(fGData);
        fGDataWriter.setDataPos(n2);
        fGDataWriter.writeInt(n6);
        FGImage fGImage = new FGImage();
        fGImage.init(fGData);
        return fGImage;
    }

    private void adjustTriplet(FGData fGData, int n) {
        byte by = fGData.m_data[n];
        byte by2 = fGData.m_data[n + 1];
        byte by3 = fGData.m_data[n + 2];
        for (int i = 0; i < this.m_numChanges; ++i) {
            if (by != this.m_origReds[i] || by2 != this.m_origGreens[i] || by3 != this.m_origBlues[i]) continue;
            fGData.m_data[n] = this.m_changedReds[i];
            fGData.m_data[n + 1] = this.m_changedGreens[i];
            fGData.m_data[n + 2] = this.m_changedBlues[i];
            return;
        }
    }

    private FGData getFile(String string) {
        FGEngine fGEngine = FGEngine.getEngine();
        FGData fGData = StaticMethods.getByteArrayFromFile(string);
        return fGData;
    }

    private static int[] make_crc_table() {
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            int n = i;
            int n2 = 8;
            while (--n2 >= 0) {
                if ((n & 1) != 0) {
                    n = 0xEDB88320 ^ n >>> 1;
                    continue;
                }
                n >>>= 1;
            }
            nArray[i] = n;
        }
        return nArray;
    }

    private long getValue() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    private void reset() {
        this.crc = 0;
    }

    private void update(int n) {
        int n2 = ~this.crc;
        n2 = crc_table[(n2 ^ n) & 0xFF] ^ n2 >>> 8;
        this.crc = ~n2;
    }

    private void update(byte[] byArray, int n, int n2) {
        int n3 = ~this.crc;
        while (--n2 >= 0) {
            n3 = crc_table[(n3 ^ byArray[n++]) & 0xFF] ^ n3 >>> 8;
        }
        this.crc = ~n3;
    }

    private void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }
}

