/*
 * Decompiled with CFR 0.152.
 */
class FGCuts {
    private static final int FILE_VERSION = 1;
    private static final boolean DEBUG = true;
    FGImage m_image;
    int m_numCuts;
    FGCutImage[] m_cuts;
    FGString[] m_IDStrings;
    int[] m_IDInts;
    int m_numAnims;
    FGAnimation[] m_anims;
    public FGString[] m_animIDs;
    public int[] m_animIDHashes;

    public void init(FGImage fGImage, String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.m_image = fGImage;
        FGData fGData = StaticMethods.getByteArrayFromFile(string);
        if (fGData == null) {
            FGEngine.fatal("could not load cutfile data");
            return;
        }
        FGDataReader fGDataReader = new FGDataReader();
        fGDataReader.init(fGData);
        int n6 = fGDataReader.readInt();
        if (n6 != 1) {
            FGEngine.fatal("invalid cutfile version. Are you using the latest CutTool?");
            return;
        }
        this.m_numCuts = fGDataReader.readInt();
        this.m_cuts = new FGCutImage[this.m_numCuts];
        this.m_IDStrings = new FGString[this.m_numCuts];
        this.m_IDInts = new int[this.m_numCuts];
        for (n5 = 0; n5 < this.m_numCuts; ++n5) {
            n4 = fGDataReader.readInt();
            n3 = fGDataReader.readInt();
            n2 = fGDataReader.readInt();
            n = fGDataReader.readInt();
            int n7 = fGDataReader.readInt();
            int n8 = fGDataReader.readInt();
            this.m_cuts[n5] = new FGCutImage();
            this.m_cuts[n5].init(this.m_image, n4, n3, n2, n, n7, n8);
            boolean bl = false;
            if (n4 < 0) {
                bl = true;
            }
            if (n3 < 0) {
                bl = true;
            }
            if (n4 + n2 > fGImage.getWidth()) {
                bl = true;
            }
            if (n3 + n > fGImage.getHeight()) {
                bl = true;
            }
            if (bl) {
                FGEngine.fatal("bad cut in cut file:" + string);
                return;
            }
            FGString fGString = fGDataReader.readUTF();
            if (fGString.canParseToInt()) {
                this.m_IDInts[n5] = fGString.toInt();
                continue;
            }
            this.m_IDStrings[n5] = fGString;
            this.m_IDInts[n5] = fGString.getHash();
        }
        this.m_numAnims = fGDataReader.readInt();
        this.m_anims = new FGAnimation[this.m_numAnims];
        this.m_animIDs = new FGString[this.m_numAnims];
        this.m_animIDHashes = new int[this.m_numAnims];
        for (n5 = 0; n5 < this.m_numAnims; ++n5) {
            this.m_animIDs[n5] = fGDataReader.readUTF();
            this.m_animIDHashes[n5] = this.m_animIDs[n5].getHash();
            n4 = fGDataReader.readInt();
            this.m_anims[n5] = new FGAnimation();
            this.m_anims[n5].init(n4);
            n3 = fGDataReader.readInt();
            for (n2 = 0; n2 < n3; ++n2) {
                n = fGDataReader.readInt();
                if (n == -1) {
                    FGEngine.fatal("illegal frame in animation from cut file");
                    return;
                }
                this.m_anims[n5].addFrame(this.m_cuts[n]);
            }
        }
    }

    public FGCutImage getCut(String string) {
        int n = this.getHashSearchIdx(string, this.m_IDStrings, this.m_IDInts, this.m_numCuts);
        if (n == -1) {
            int n2 = -1;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n2 != -1) {
                for (int i = 0; i < this.m_numCuts; ++i) {
                    if (this.m_IDStrings[i] != null || this.m_IDInts[i] != n2) continue;
                    n = i;
                }
            }
        }
        if (n == -1) {
            return null;
        }
        return this.m_cuts[n];
    }

    public FGAnimation getAnimation(String string) {
        int n = this.getHashSearchIdx(string, this.m_animIDs, this.m_animIDHashes, this.m_numAnims);
        if (n == -1) {
            return null;
        }
        return this.m_anims[n];
    }

    private int getHashSearchIdx(String string, FGString[] fGStringArray, int[] nArray, int n) {
        int n2 = FGString.getHash(string);
        for (int i = 0; i < n; ++i) {
            if (nArray[i] != n2 || fGStringArray[i] == null || !fGStringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }
}

