/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class ModePassNPlay
extends ModeGame {
    PNPPlayerInfo m_playerInfo = new PNPPlayerInfo();
    int m_oldState;
    boolean m_showingPlayerId;
    boolean[] m_showingInitialSTWCards = new boolean[4];

    public ModePassNPlay() {
        this.m_isPNP = true;
        for (int i = 0; i < 4; ++i) {
            this.m_showingInitialSTWCards[i] = false;
        }
    }

    void choosePlayers() {
        FGImage[] fGImageArray = new FGImage[]{this.m_pCarImgs[0][2], this.m_pCarImgs[1][2], this.m_pCarImgs[2][2], this.m_pCarImgs[3][2]};
        ModePNPChoosePlayer modePNPChoosePlayer = new ModePNPChoosePlayer();
        modePNPChoosePlayer.init(this.m_pPlayers, this.m_pHud, this.m_playerInfo, fGImageArray);
        LifeEngine.getInstance().getModeMgr().pushMode(modePNPChoosePlayer);
        this.setCurrState(12);
    }

    void setupPlayers(boolean bl) {
        int n;
        if (!bl) {
            return;
        }
        this.m_numPlayers = this.m_playerInfo.m_numPlayers;
        for (n = 0; n < this.m_numPlayers; ++n) {
            this.setCarAndPortrait(this.m_pPlayers[n], this.m_playerInfo.m_colorChoices[n], this.m_playerInfo.m_characterChoices[n]);
            this.m_pPlayers[n].setAI(false);
            this.m_pPlayers[n].setPassNPlayId(n);
            this.m_pPlayers[n].setCharacter(this.m_playerInfo.m_characterChoices[n]);
            this.m_pPlayers[n].setColor(this.m_playerInfo.m_colorChoices[n]);
            this.m_pTempPlayers[n] = this.m_pPlayers[n];
        }
        for (n = this.m_numPlayers; n < 4; ++n) {
            this.m_pPlayers[n] = null;
        }
        for (n = 0; n < 4; ++n) {
            this.m_rollOrder[n] = -1;
        }
        this.m_currRoller = 0;
        this.m_rollingForFirst = true;
        this.m_currOrder = 0;
        this.m_showingPlayerId = false;
    }

    void announceCurrPlayer(boolean bl) {
        FGEAStringManager fGEAStringManager = LifeEngine.getInstance().getStringTable();
        Player player = this.m_pPlayers[this.m_currPlayer];
        this.m_pHud.setLeftPlayer(player);
        if (!this.m_rollingForFirst) {
            this.setSoftkeys();
        }
        this.rankPlayers();
        Player.makePassNPlayName(this.m_tempStr, player.getCarColor(), true, true, true);
        if (bl) {
            this.m_tempStr.add(fGEAStringManager.getString(61));
        } else if (player.isRetired()) {
            this.m_tempStr.add(fGEAStringManager.getString(162));
        } else if (player.lostNextTurn()) {
            this.m_tempStr.add(fGEAStringManager.getString(165));
        } else {
            this.m_tempStr.add(fGEAStringManager.getString(62));
        }
        this.m_pHud.displayInfoPopupText(0, this.m_tempStr.getSDKString(), LifeEngine.getInstance().getSmallBoldFont(), -1);
        this.m_pBoard.centerOnSpinner();
        if (player.lostNextTurn()) {
            this.setCurrState(14);
            this.m_timer.start(1500);
            return;
        }
        this.setCurrState(7);
        this.m_timer.start(1500);
        this.setCurrState(20);
    }

    void announceCurrRoller() {
        int n = this.m_pPlayers[this.m_currRoller].getCarColor();
        Player.makePassNPlayName(this.m_tempStr, n, true, true, true);
        this.m_tempStr.add(LifeEngine.getInstance().getStringTable().getString(129));
        this.m_pBoard.centerOnSpinner();
        this.m_pHud.displayInfoPopupText(0, this.m_tempStr.getSDKString(), LifeEngine.getInstance().getSmallBoldFont(), -1);
        this.setCurrState(7);
        this.m_timer.start(1500);
        this.setCurrState(20);
        this.m_pHud.setLeftPlayer(this.m_pPlayers[this.m_currRoller]);
    }

    void nextPlayer() {
        this.m_pHud.hideInfoPopupText();
        ++this.m_currPlayer;
        if (this.m_currPlayer >= this.m_numPlayers) {
            this.m_currPlayer = 0;
            this.m_choosingPaths = false;
        }
        this.setCurrState(15);
        Player.makePassNPlayName(this.m_tempStr, this.m_pPlayers[this.m_currPlayer].getCarColor(), true, true, true);
        this.m_tempStr.add(LifeEngine.getInstance().getStringTable().getString(176));
        this.m_pHud.displayInfoPopupText(0, this.m_tempStr.getSDKString(), LifeEngine.getInstance().getSmallBoldFont(), -1);
        this.m_pHud.setLeftPlayer(this.m_pPlayers[this.m_currPlayer]);
        this.m_pBoard.setCurrPlayer(this.m_currPlayer);
        this.m_showingPlayerId = true;
        this.saveGame();
    }

    void PNPNextPlayer() {
        this.m_timer.start(250);
        this.m_showingPlayerId = false;
        if (this.m_showingInitialSTWCards[this.m_currPlayer]) {
            this.showInitialSTWCards();
            this.m_showingInitialSTWCards[this.m_currPlayer] = false;
            return;
        }
        if (this.m_pPlayers[this.m_currPlayer].eventPending()) {
            this.processEvent();
        } else {
            this.announceCurrPlayer();
            this.startTurn();
        }
    }

    void preparePlayers() {
        int n;
        this.setCurrState(2);
        this.m_pBoard.centerOnSpinner();
        this.m_currPlayer = 0;
        for (n = 0; n < this.m_numPlayers; ++n) {
            this.m_pPlayers[n].putInGame();
            this.m_pPlayers[n].setRank(n);
            this.m_showingInitialSTWCards[n] = true;
        }
        for (n = this.m_numPlayers; n < 4; ++n) {
            this.m_pPlayers[n] = null;
        }
        this.m_pBoard.setIsPNP();
        for (n = 0; n < this.m_numPlayers; ++n) {
            for (int i = 0; i < 3; ++i) {
                this.m_pPlayers[n].addShareTheWealth((ShareTheWealthCard)this.m_pShareTheWealthCardPile.drawOne());
            }
        }
        this.setCurrState(15);
        Player.makePassNPlayName(this.m_tempStr, this.m_pPlayers[this.m_currPlayer].getCarColor(), true, true, true);
        this.m_tempStr.add(LifeEngine.getInstance().getStringTable().getString(176));
        this.m_pHud.displayInfoPopupText(0, this.m_tempStr.getSDKString(), LifeEngine.getInstance().getSmallBoldFont(), -1);
        this.m_pHud.setLeftPlayer(this.m_pPlayers[this.m_currPlayer]);
        this.m_pBoard.setCurrPlayer(0);
    }

    void doLoseTurn() {
        this.nextPlayer();
    }

    void startTurn() {
        if (this.m_choosingPaths) {
            this.setCurrState(2);
        } else if (!this.m_pPlayers[this.m_currPlayer].lostNextTurn()) {
            this.setCurrState(20);
        }
        Player player = this.m_pPlayers[this.m_currPlayer];
        if (!this.m_rollingForFirst) {
            this.setSoftkeys();
        }
        this.m_pHud.setLeftPlayer(this.m_pPlayers[this.m_currPlayer]);
        this.m_pBoard.setCurrPlayer(this.m_currPlayer);
        if (!this.m_choosingPaths && player.isAI() && player.willBuyInvestment()) {
            int n = LifeEngine.getInstance().rand() % 10;
            while (this.m_investNums[n] != 0) {
                n = LifeEngine.getInstance().rand() % 10;
            }
            player.setInvestment(n);
            player.transactCash(-10000);
            this.m_investNums[n] = 1;
            this.setCurrState(11);
            this.m_timer.start(3000);
            FGString fGString = new FGString("");
            fGString.add(n + 1);
            this.m_scratchStr.format(LifeEngine.getInstance().getStringTable().getString(120), player.getName(), fGString.getSDKString());
            this.m_pHud.displayInfoPopupText(0, this.m_scratchStr.getSDKString(), LifeEngine.getInstance().getSmallFont(), 3000);
        }
        this.saveGame();
    }

    void processEvent() {
        Event event = this.m_pPlayers[this.m_currPlayer].getNextEvent();
        FGString fGString = new FGString();
        event.toText(fGString, this.m_pPlayers, this.m_pHud);
        this.m_pHud.displayInfoPopupText(0, fGString.getSDKString(), LifeEngine.getInstance().getSmallFont(), -1);
        this.setCurrState(16);
    }

    Player getPlayerForStatus() {
        return this.m_pPlayers[this.m_currPlayer];
    }

    void doNextPlayer() {
        this.saveGame();
        if (this.m_pPlayers[this.m_currPlayer].getCar().IsStopped() && this.m_pPlayers[this.m_currPlayer].getCar().GetSpace().m_spaceType != 24) {
            this.announceCurrPlayer(true);
            return;
        }
        this.nextPlayer();
        if (!this.m_choosingPaths && this.m_currState != 11 && !this.m_showingPlayerId) {
            this.announceCurrPlayer();
        }
    }

    void setupSaveGame() {
        this.m_isPNP = true;
    }

    void saveSpecific(ByteArrayOutputStream byteArrayOutputStream) {
        StaticMethods.writeBoolean(byteArrayOutputStream, this.m_showingPlayerId);
    }

    void loadSpecific(ByteArrayInputStream byteArrayInputStream) {
        this.m_showingPlayerId = StaticMethods.readBoolean(byteArrayInputStream);
    }
}

