/*
 * Decompiled with CFR 0.152.
 */
public class FGModeManager {
    public static final int MODE_STACK_SIZE = 32;
    public static final int ACTION_NONE = -1;
    public static final int ACTION_PUSH_MODE = 0;
    public static final int ACTION_POP_MODE = 1;
    public static final int ACTION_SET_MODE = 2;
    public FGMode[] m_modeStack = new FGMode[32];
    public int m_modeStackPos = -1;
    public int m_nextAction = -1;
    public FGMode m_nextActionMode = null;

    public void setMode(FGMode fGMode) {
        if (this.m_nextAction != -1) {
            return;
        }
        this.m_nextAction = 2;
        this.m_nextActionMode = fGMode;
    }

    public void pushMode(FGMode fGMode) {
        if (this.m_nextAction != -1) {
            FGEngine.fatal("pushMode: overwriting next action");
            return;
        }
        this.m_nextAction = 0;
        this.m_nextActionMode = fGMode;
    }

    public void popMode() {
        if (this.m_nextAction != -1) {
            FGEngine.fatal("popMode: overwriting next action");
            return;
        }
        this.m_nextAction = 1;
        this.m_nextActionMode = null;
    }

    public FGMode getCurrentMode() {
        if (this.m_modeStackPos == -1) {
            return null;
        }
        return this.m_modeStack[this.m_modeStackPos];
    }

    public void tick() {
        this.performModeChanges();
        FGMode fGMode = this.getCurrentMode();
        if (fGMode != null) {
            fGMode.tick();
        }
        this.performModeChanges();
    }

    public void drawSelf(FGGraphics fGGraphics) {
        FGMode fGMode = this.getCurrentMode();
        if (fGMode != null) {
            fGMode.drawSelf(fGGraphics);
        }
    }

    public void keyPressed(int n) {
        FGMode fGMode = this.getCurrentMode();
        if (fGMode != null) {
            fGMode.keyPressed(n);
        }
    }

    public void keyReleased(int n) {
        FGMode fGMode = this.getCurrentMode();
        if (fGMode != null) {
            fGMode.keyReleased(n);
        }
    }

    public void mousePressed(int n) {
        FGMode fGMode = this.getCurrentMode();
        if (fGMode != null) {
            fGMode.mousePressed(n);
        }
    }

    public void mouseReleased(int n) {
        FGMode fGMode = this.getCurrentMode();
        if (fGMode != null) {
            fGMode.mouseReleased(n);
        }
    }

    public void mouseWheel(int n) {
        FGMode fGMode = this.getCurrentMode();
        if (fGMode != null) {
            fGMode.mouseWheel(n);
        }
    }

    public void pause() {
        FGMode fGMode = this.getCurrentMode();
        if (fGMode != null) {
            fGMode.pause();
        }
    }

    public void resume() {
        FGMode fGMode = this.getCurrentMode();
        if (fGMode != null) {
            fGMode.resume();
        }
    }

    public void doSetMode(FGMode fGMode) {
        FGMode fGMode2 = this.getCurrentMode();
        if (fGMode2 != null) {
            this.doPopMode(false);
        }
        this.doPushMode(fGMode);
    }

    public void doPushMode(FGMode fGMode) {
        if (this.m_modeStackPos >= 32) {
            FGEngine.fatal("mode stack overflow");
            return;
        }
        FGMode fGMode2 = this.getCurrentMode();
        if (fGMode2 != null) {
            fGMode2.deactivate();
        }
        ++this.m_modeStackPos;
        this.m_modeStack[this.m_modeStackPos] = fGMode;
        this.getCurrentMode().activate();
    }

    public void doPopMode(boolean bl) {
        FGMode fGMode = this.getCurrentMode();
        if (fGMode == null) {
            FGEngine.fatal("doPopMode called when there is no mode");
            return;
        }
        fGMode.deactivate();
        --this.m_modeStackPos;
        fGMode = this.getCurrentMode();
        if (bl && fGMode != null) {
            fGMode.activate();
        }
    }

    public void performModeChanges() {
        while (this.m_nextAction != -1) {
            int n = this.m_nextAction;
            FGMode fGMode = this.m_nextActionMode;
            this.m_nextAction = -1;
            this.m_nextActionMode = null;
            if (n == 2) {
                this.doSetMode(fGMode);
                continue;
            }
            if (n == 0) {
                this.doPushMode(fGMode);
                continue;
            }
            if (n != 1) continue;
            this.doPopMode(true);
        }
    }

    public void clearModeStack() {
        FGMode fGMode = this.getCurrentMode();
        if (fGMode != null) {
            fGMode.deactivate();
        }
        this.m_modeStackPos = -1;
    }

    public void unwindModeStack(FGMode fGMode) {
        FGMode fGMode2 = this.getCurrentMode();
        if (fGMode2 != null) {
            fGMode2.deactivate();
        }
        while (this.m_modeStackPos >= 0) {
            if (this.m_modeStack[this.m_modeStackPos] == fGMode) {
                return;
            }
            --this.m_modeStackPos;
        }
        FGEngine.fatal("unwindModeStack called with mode not in the stack");
    }

    public FGMode getPreviousMode(int n) {
        int n2 = this.m_modeStackPos - n;
        if (n2 < 0) {
            return null;
        }
        return this.m_modeStack[n2];
    }
}

