/*
 * Decompiled with CFR 0.152.
 */
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKTextUtils;
import javax.microedition.lcdui.Image;

class FGFont {
    public static final int JUSTIFY_LEFT = 0;
    public static final int JUSTIFY_RIGHT = 1;
    public static final int JUSTIFY_CENTER = 2;
    private static final short NEWLINE_CHAR = 124;
    public static final int MAX_LINEBREAKS = 1024;
    Image m_image;
    Object m_font;
    int m_height;
    int m_spaceWidth;
    int m_lineSpacing;
    int m_justify = 0;

    public void init(String string, String string2) {
        try {
            this.m_image = Image.createImage((String)("/" + string));
        }
        catch (Exception exception) {
            FGEngine.fatal("could not load font image: " + string);
        }
        FGData fGData = StaticMethods.getByteArrayFromFile(string2);
        byte[] byArray = fGData.m_data;
        this.m_font = SDKTextUtils.loadFont(this.m_image, byArray);
        SDKTextUtils.setFont(this.m_font);
        this.m_spaceWidth = SDKTextUtils.getSpaceSpacing();
        this.m_height = SDKTextUtils.getLineSize();
        this.m_lineSpacing = SDKTextUtils.getLeadingSpacing();
    }

    public void setJustify(int n) {
        this.m_justify = n;
    }

    public int getJustify() {
        return this.m_justify;
    }

    private int getAnchor() {
        int n = this.m_justify == 0 ? 20 : (this.m_justify == 2 ? 17 : 24);
        return n;
    }

    public short[] getLineBreaks(SDKString sDKString, int n) {
        short[] sArray = null;
        SDKTextUtils.setFont(this.m_font);
        try {
            sArray = SDKTextUtils.wrapString(sDKString, null, n, (short)124);
        }
        catch (Exception exception) {
            try {
                sArray = new short[1024];
                SDKTextUtils.wrapString(sDKString, sArray, n, (short)124);
            }
            catch (Exception exception2) {
                FGEngine.fatal("maximum number of line breaks exceeded in FGFont.getLineBreaks");
            }
        }
        return sArray;
    }

    public void drawText(FGGraphics fGGraphics, SDKString sDKString, int n, int n2) {
        SDKTextUtils.setGraphics(fGGraphics.getJavaGraphics());
        SDKTextUtils.setFont(this.m_font);
        SDKTextUtils.drawString(sDKString, n, n2, this.getAnchor());
    }

    public void drawText(FGGraphics fGGraphics, SDKString sDKString, int n, int n2, int n3) {
        if (this.m_justify == 2) {
            n += n3 / 2;
        } else if (this.m_justify == 1) {
            n += n3;
        }
        SDKTextUtils.setGraphics(fGGraphics.getJavaGraphics());
        SDKTextUtils.setFont(this.m_font);
        short[] sArray = this.getLineBreaks(sDKString, n3);
        SDKTextUtils.drawWrappedString(sDKString, sArray, 1, sArray[0], n, n2, this.getAnchor());
    }

    public void drawText(FGGraphics fGGraphics, SDKString sDKString, int n, int n2, int n3, int n4, int n5) {
        int n6 = n5 + 1;
        int n7 = n4 / this.getHeight();
        if (this.m_justify == 2) {
            n += n3 / 2;
        } else if (this.m_justify == 1) {
            n += n3;
        }
        SDKTextUtils.setGraphics(fGGraphics.getJavaGraphics());
        SDKTextUtils.setFont(this.m_font);
        short[] sArray = this.getLineBreaks(sDKString, n3);
        if (n5 + n7 > sArray[0]) {
            n7 = sArray[0] - n5;
        }
        SDKTextUtils.drawWrappedString(sDKString, sArray, n6, n7, n, n2, this.getAnchor());
    }

    public void drawProcessedText(FGGraphics fGGraphics, FGProcessedString fGProcessedString, int n, int n2) {
        this.drawProcessedText(fGGraphics, fGProcessedString, n, n2, 0, -1);
    }

    public void drawProcessedText(FGGraphics fGGraphics, FGProcessedString fGProcessedString, int n, int n2, int n3, int n4) {
        short s;
        int n5;
        SDKTextUtils.setGraphics(fGGraphics.getJavaGraphics());
        SDKTextUtils.setFont(this.m_font);
        if (n4 == -1) {
            n4 = fGProcessedString.m_offsets[0];
        }
        if ((n5 = n3 + n4 - 1) >= (s = fGProcessedString.m_offsets[0])) {
            n4 = s - n3 + 1;
        }
        SDKTextUtils.drawWrappedString(fGProcessedString.m_str, fGProcessedString.m_offsets, n3 + 1, n4, n, n2, this.getAnchor());
    }

    public int getDisplayHeight(SDKString sDKString, int n) {
        return this.getDisplayLines(sDKString, n) * this.getHeight();
    }

    public int getDisplayLines(SDKString sDKString, int n) {
        short[] sArray = this.getLineBreaks(sDKString, n);
        return sArray[0];
    }

    public int getDisplayLength(SDKString sDKString) {
        SDKTextUtils.setFont(this.m_font);
        return SDKTextUtils.getStringSize(sDKString);
    }

    public int getDisplayLength(SDKString sDKString, int n) {
        SDKTextUtils.setFont(this.m_font);
        short[] sArray = this.getLineBreaks(sDKString, n);
        int n2 = 0;
        int n3 = sArray[0];
        for (int i = 0; i < n3; ++i) {
            int n4 = i + 1;
            short s = sArray[n4];
            int n5 = sArray[n4 + 1] - s;
            int n6 = SDKTextUtils.getSubStringSize(sDKString, s, n5);
            if (n6 <= n2) continue;
            n2 = n6;
        }
        return n2;
    }

    public int getSpaceWidth() {
        return this.m_spaceWidth;
    }

    public int getHeight() {
        return this.m_height;
    }

    public int getLineSpacing() {
        return this.m_lineSpacing;
    }
}

