/*
 * Decompiled with CFR 0.152.
 */
class Car {
    private static final int[] m_pegCoordsMedium = new int[]{14, 9, 17, 12, 12, 11, 15, 14, 9, 13, 12, 16, 14, 9, 15, 12, 11, 10, 12, 13, 8, 11, 9, 14, 15, 9, 15, 12, 11, 9, 11, 12, 7, 9, 7, 12, 16, 9, 14, 12, 12, 8, 10, 11, 9, 6, 7, 9, 15, 9, 12, 11, 13, 7, 10, 9, 11, 5, 8, 7, 17, 8, 13, 10, 15, 5, 11, 7, 14, 3, 10, 5, 18, 9, 13, 9, 18, 6, 13, 6, 18, 3, 13, 3, 19, 10, 15, 9, 20, 7, 16, 6, 21, 4, 17, 3, 19, 11, 16, 8, 21, 9, 18, 6, 23, 7, 20, 4, 18, 11, 17, 8, 21, 10, 20, 7, 24, 9, 23, 6, 16, 12, 16, 9, 20, 12, 20, 9, 24, 12, 24, 9, 16, 12, 16, 9, 19, 13, 19, 10, 22, 14, 22, 11, 14, 12, 17, 10, 17, 14, 20, 12, 20, 16, 23, 14, 14, 12, 17, 10, 16, 14, 19, 12, 17, 17, 21, 15, 14, 11, 18, 11, 14, 13, 18, 13, 14, 16, 18, 16, 14, 11, 17, 11, 13, 13, 16, 14, 11, 16, 14, 17};
    private static final int[] m_pegCoordsMediumStart = new int[]{11, 10, 14, 13, 9, 13, 12, 16, 7, 16, 10, 19, 11, 9, 13, 12, 8, 11, 10, 14, 5, 14, 7, 17, 12, 9, 12, 12, 9, 10, 9, 13, 5, 11, 5, 14, 13, 7, 12, 10, 10, 7, 9, 10, 7, 7, 6, 10, 13, 7, 11, 10, 11, 6, 9, 9, 9, 5, 7, 8, 14, 7, 11, 8, 13, 6, 10, 7, 12, 5, 9, 6, 16, 8, 12, 8, 16, 6, 12, 6, 16, 4, 12, 4, 17, 9, 14, 8, 18, 7, 15, 6, 19, 5, 16, 4, 19, 8, 16, 6, 21, 7, 18, 5, 23, 6, 20, 4, 18, 9, 16, 6, 21, 9, 19, 6, 24, 9, 22, 6, 18, 10, 17, 7, 21, 11, 20, 8, 24, 11, 23, 8, 17, 12, 19, 10, 20, 13, 22, 11, 23, 15, 25, 13, 15, 12, 17, 11, 18, 14, 20, 13, 21, 17, 23, 16, 14, 12, 17, 10, 16, 15, 19, 13, 17, 18, 20, 17, 13, 11, 17, 11, 13, 14, 17, 14, 13, 18, 17, 18, 12, 10, 16, 11, 11, 14, 15, 15, 10, 18, 14, 19};
    private static final int[] m_pegCoordsMediumEnd = new int[]{13, 7, 15, 9, 11, 9, 13, 11, 9, 11, 11, 13, 14, 6, 15, 9, 11, 7, 12, 10, 8, 9, 9, 12, 13, 6, 13, 10, 10, 6, 10, 10, 7, 7, 7, 11, 14, 6, 13, 9, 12, 5, 11, 8, 9, 4, 8, 7, 15, 7, 12, 9, 13, 5, 10, 7, 11, 3, 8, 5, 15, 6, 12, 7, 14, 4, 11, 5, 13, 2, 10, 3, 16, 7, 12, 7, 16, 5, 12, 5, 16, 2, 12, 2, 17, 7, 14, 6, 18, 5, 15, 4, 19, 3, 16, 2, 18, 8, 15, 6, 19, 6, 16, 4, 21, 5, 18, 3, 16, 9, 14, 6, 19, 8, 17, 5, 22, 7, 20, 4, 15, 10, 15, 6, 18, 9, 18, 5, 21, 10, 21, 6, 14, 10, 15, 6, 17, 11, 18, 7, 20, 12, 21, 8, 14, 10, 16, 7, 16, 11, 18, 8, 18, 13, 20, 10, 12, 9, 16, 7, 13, 11, 17, 9, 15, 14, 19, 12, 12, 7, 17, 7, 12, 10, 17, 10, 12, 13, 17, 13, 12, 8, 16, 9, 11, 10, 15, 11, 10, 12, 14, 13};
    private static final int[] m_pegDrawOrderMedium = new int[]{0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 0, 2, 4, 1, 3, 5, 4, 2, 0, 5, 3, 1, 4, 5, 2, 3, 0, 1, 4, 5, 2, 3, 0, 1, 5, 4, 3, 2, 1, 0, 5, 4, 3, 2, 1, 0, 5, 4, 3, 2, 1, 0, 5, 4, 3, 2, 1, 0, 1, 0, 3, 2, 5, 4, 1, 0, 3, 2, 5, 4, 1, 0, 3, 2, 5, 4, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5};
    private static final int[] m_mediumSmokeOffsets = new int[]{2, 17, 1, 14, 1, 7, 3, 3, 5, 1, 9, 1, 17, 1, 22, 1, 27, 3, 28, 6, 29, 12, 28, 16, 23, 18, 18, 20, 12, 20, 8, 18};
    public static final int[] m_mediumCenterPoints = new int[]{15, 13, 15, 13, 15, 13, 15, 13, 15, 13, 15, 13, 15, 13, 15, 13, 15, 13, 15, 13, 15, 13, 15, 13, 15, 13, 15, 13, 15, 13, 15, 13};
    public static final int[] m_mediumCarFrameOffsets = new int[]{9, 9, 9, 11, 9, 11, 8, 9, 9, 8, 12, 7, 15, 7, 12, 7, 9, 8, 8, 9, 9, 11, 8, 11, 9, 9, 12, 9, 12, 8, 12, 8};
    FGVector w_result = new FGVector();
    FGVector w_destination = new FGVector();
    private static final int kNumBoardSpaces = 16;
    private static final int kDefaultNumCarFrames = 8;
    private static final int kExtraCarFrames = 16;
    public static final int kIdle = 0;
    public static final int kMoving = 1;
    public static final int kPaused = 2;
    public static final int kDone = 3;
    public static final int COLOR_RED = 0;
    public static final int COLOR_YELLOW = 1;
    public static final int COLOR_BLUE = 2;
    public static final int COLOR_GREEN = 3;
    public static final int kNumColors = 4;
    public static final int kNumCarFrames = 16;
    public static final int kNumCarStartFrames = 2;
    public static final int kCarStartAnimFrameTime = 300;
    public static final int kCarStopAnimFrameTime = 200;
    public static final int kSmokeFrameTime = 100;
    private static final int kAccelScalarFixed = FGFixed.toFixed(48);
    int m_currState = 0;
    FGVector m_vel = new FGVector();
    FGVector m_pos = new FGVector();
    FGVector m_accel = new FGVector();
    FGVector m_startPos = new FGVector();
    int m_startSpeedFixed;
    boolean m_speedingUp;
    int m_totalDistanceFixed = 0;
    int m_halfDistanceFixed;
    int m_curDistanceFixed;
    int m_nextSpaceDistanceFixed;
    int m_nextSpaceProgressFixed;
    BoardSpace[] m_pSpaces = new BoardSpace[16];
    int m_currBoardSpaceIdx = 0;
    int m_numBoardSpaces = 0;
    BoardSpace m_pCurrBoardSpace;
    boolean m_extraCarFrames = false;
    int m_curCarFrame;
    int m_startFrame;
    int m_endFrame;
    int m_numCarFrames = 8;
    boolean m_stopSpace = false;
    boolean m_placed = false;
    FGImage[] m_ppCarImgs;
    FGImage[] m_ppCarStartImgs;
    FGImage[] m_ppCarEndImgs;
    FGAnimation m_startAnim = new FGAnimation();
    FGAnimation m_endAnim = new FGAnimation();
    FGAnimation m_smokeAnim = new FGAnimation();
    int[] m_pDrawOrder;
    int[] m_pPegCoords;
    int[] m_pPegCoordsStart;
    int[] m_pPegCoordsEnd;
    Player m_pDriver;
    boolean m_startAnimPlaying;
    boolean m_endAnimPlaying;
    boolean m_smokeAnimPlaying;
    int m_smokeX;
    int m_smokeY;
    boolean m_smokePlaced;
    int m_startSpaceIdx;
    private static final int CAR_NUM_BOARD_SPACES = 11;
    private static final int DEFAULT_NUM_CAR_FRAMES = 8;
    private static final int EXTRA_CAR_FRAMES = 16;
    boolean m_startStopAnims;
    int m_pegCoordOffsetX;
    int m_pegCoordOffsetY;

    Car() {
    }

    void Tick(int n) {
        if (this.m_currState == 1) {
            this.CalcCurDisplacement();
            int n2 = this.m_nextSpaceProgressFixed + this.m_curDistanceFixed;
            if (!this.m_speedingUp) {
                if (n2 >= this.m_totalDistanceFixed) {
                    this.m_currBoardSpaceIdx = this.m_numBoardSpaces - 1;
                    this.Place(this.m_pSpaces[this.m_currBoardSpaceIdx]);
                    this.m_currState = 3;
                    return;
                }
            } else if (n2 > this.m_halfDistanceFixed) {
                this.m_speedingUp = false;
            }
            if (this.m_nextSpaceProgressFixed >= this.m_nextSpaceDistanceFixed) {
                this.m_curDistanceFixed += this.m_nextSpaceProgressFixed;
                this.Place(this.m_pSpaces[this.m_currBoardSpaceIdx]);
                this.m_curCarFrame = this.GetSpriteFrame(this.m_pSpaces[this.m_currBoardSpaceIdx]);
                ++this.m_currBoardSpaceIdx;
                if (this.m_currBoardSpaceIdx >= this.m_numBoardSpaces) {
                    this.m_currBoardSpaceIdx = this.m_numBoardSpaces - 1;
                    this.Place(this.m_pSpaces[this.m_currBoardSpaceIdx]);
                    this.m_currState = 3;
                    return;
                }
                FGVector fGVector = new FGVector();
                fGVector.setXY(FGFixed.toFixed(this.m_pSpaces[this.m_currBoardSpaceIdx].m_x), FGFixed.toFixed(this.m_pSpaces[this.m_currBoardSpaceIdx].m_y));
                this.CalcNewVelocity(this.m_pos, fGVector);
                this.m_nextSpaceDistanceFixed = this.GetDist(this.m_pos, fGVector);
                this.m_nextSpaceProgressFixed = 0;
                this.m_startFrame = this.m_curCarFrame;
                this.m_endFrame = this.GetSpriteFrame(this.m_pSpaces[this.m_currBoardSpaceIdx]);
                if (this.m_pCurrBoardSpace.IsPauseSpace()) {
                    this.m_currState = 2;
                    return;
                }
            }
            this.AccelerateAndMove(n);
            if (this.m_startFrame != this.m_endFrame) {
                int n3 = this.m_endFrame - this.m_startFrame;
                if (n3 > this.m_numCarFrames / 2) {
                    n3 -= this.m_numCarFrames;
                } else if (n3 < -this.m_numCarFrames / 2) {
                    n3 += this.m_numCarFrames;
                }
                int n4 = this.m_startFrame + n3 * this.m_nextSpaceProgressFixed / this.m_nextSpaceDistanceFixed;
                this.m_curCarFrame = n4 % this.m_numCarFrames;
                while (this.m_curCarFrame < 0) {
                    this.m_curCarFrame += this.m_numCarFrames;
                }
                while (this.m_curCarFrame >= this.m_numCarFrames) {
                    this.m_curCarFrame -= this.m_numCarFrames;
                }
            }
        }
    }

    void AccelerateAndMove(int n) {
        if (this.m_currState == 0) {
            return;
        }
        this.w_destination.setXY(FGFixed.toFixed(this.m_pSpaces[this.m_currBoardSpaceIdx].m_x), FGFixed.toFixed(this.m_pSpaces[this.m_currBoardSpaceIdx].m_y));
        FGGeometry.applyPPSVel(this.m_vel, this.m_accel, n, this.w_result);
        this.m_vel.set(this.w_result);
        int n2 = FGEngine.getEngine().getScreenWidth() / 2;
        int n3 = FGFixed.toFixed(n2);
        FGGeometry.applyPPSVelToward(this.m_pos, n3, this.w_destination, n, this.w_result);
        this.m_pos.set(this.w_result);
    }

    void CalcCurDisplacement() {
        FGVector fGVector = new FGVector();
        if (this.m_currBoardSpaceIdx == 0) {
            fGVector.set(this.m_startPos);
        } else {
            int n = FGFixed.toFixed(this.m_pSpaces[this.m_currBoardSpaceIdx - 1].m_x);
            int n2 = FGFixed.toFixed(this.m_pSpaces[this.m_currBoardSpaceIdx - 1].m_y);
            fGVector.setXY(n, n2);
        }
        this.m_nextSpaceProgressFixed = this.GetDist(this.m_pos, fGVector);
    }

    void AddToPath(BoardSpace boardSpace) {
        this.AddToPath(boardSpace, false);
    }

    void AddToPath(BoardSpace boardSpace, boolean bl) {
        int n;
        int n2;
        if (bl) {
            this.m_currBoardSpaceIdx = 0;
            this.m_numBoardSpaces = 0;
            this.m_totalDistanceFixed = 0;
            this.m_stopSpace = false;
        }
        if (this.m_stopSpace) {
            return;
        }
        this.m_pSpaces[this.m_currBoardSpaceIdx] = boardSpace;
        FGVector fGVector = new FGVector();
        FGVector fGVector2 = new FGVector();
        if (this.m_currBoardSpaceIdx == 0) {
            fGVector.set(this.m_pos);
        } else {
            n2 = FGFixed.toFixed(this.m_pSpaces[this.m_currBoardSpaceIdx - 1].m_x);
            n = FGFixed.toFixed(this.m_pSpaces[this.m_currBoardSpaceIdx - 1].m_y);
            fGVector.setXY(n2, n);
        }
        n2 = FGFixed.toFixed(this.m_pSpaces[this.m_currBoardSpaceIdx].m_x);
        n = FGFixed.toFixed(this.m_pSpaces[this.m_currBoardSpaceIdx].m_y);
        fGVector2.setXY(n2, n);
        fGVector2.subtractVector(fGVector);
        this.m_totalDistanceFixed += fGVector2.getLength();
        ++this.m_currBoardSpaceIdx;
        ++this.m_numBoardSpaces;
        if (boardSpace.IsStopSpace()) {
            this.m_stopSpace = true;
        }
    }

    void Go() {
        this.m_currState = 1;
        this.m_speedingUp = true;
        this.m_currBoardSpaceIdx = 0;
        this.m_vel.setXY(256, 0);
        this.m_vel.setXY(FGFixed.toFixed(60), 0);
        FGVector fGVector = new FGVector();
        fGVector.setXY(FGFixed.toFixed(this.m_pSpaces[this.m_currBoardSpaceIdx].m_x), FGFixed.toFixed(this.m_pSpaces[this.m_currBoardSpaceIdx].m_y));
        this.CalcNewVelocity(this.m_pos, fGVector);
        this.m_halfDistanceFixed = this.m_totalDistanceFixed / 2;
        this.m_halfDistanceFixed += this.m_totalDistanceFixed / 8;
        this.m_curDistanceFixed = 0;
        this.m_nextSpaceDistanceFixed = this.GetDist(this.m_pos, fGVector);
        this.m_nextSpaceProgressFixed = 0;
        this.m_startPos.set(this.m_pos);
        this.m_startFrame = this.m_curCarFrame;
        this.m_endFrame = this.GetSpriteFrame(this.m_pSpaces[this.m_currBoardSpaceIdx]);
    }

    void CalcNewVelocity(FGVector fGVector, FGVector fGVector2) {
    }

    int GetDist(FGVector fGVector, FGVector fGVector2) {
        FGVector fGVector3 = new FGVector();
        fGVector3.set(fGVector2);
        fGVector3.subtractVector(fGVector);
        return fGVector3.getLength();
    }

    int GetSpriteFrame(BoardSpace boardSpace) {
        int n = boardSpace.GetCarSpriteFrame();
        return n;
    }

    void Place(BoardSpace boardSpace) {
        this.m_pos.setXY(FGFixed.toFixed(boardSpace.m_x), FGFixed.toFixed(boardSpace.m_y));
        this.m_curCarFrame = this.GetSpriteFrame(boardSpace);
        if (boardSpace == null) {
            int n = 5;
        }
        this.m_pCurrBoardSpace = boardSpace;
        this.m_placed = true;
    }

    void PlayStartAnim() {
        if (this.m_startStopAnims) {
            int n = this.GetSpriteFrame();
            this.m_startAnim.clearArt();
            this.m_startAnim.init(300);
            this.m_startAnim.addFrame(this.m_ppCarStartImgs[n]);
            this.m_startAnim.playOnce();
            this.m_startAnimPlaying = true;
        }
    }

    void PlayStartSmokeAnim() {
        this.m_smokeAnimPlaying = true;
        this.m_smokeAnim.playOnce();
    }

    void PlayEndAnim() {
        if (this.m_startStopAnims) {
            this.m_endAnim.clearArt();
            this.m_endAnim.init(200);
            this.m_endAnim.addFrame(this.m_ppCarEndImgs[this.GetSpriteFrame()]);
            this.m_endAnim.playOnce();
            this.m_endAnimPlaying = true;
        }
    }

    void PlayEndSmokeAnim() {
    }

    void init(FGImage[] fGImageArray, FGImage[] fGImageArray2, FGImage[] fGImageArray3) {
        this.m_ppCarImgs = fGImageArray;
        this.m_startStopAnims = LifeEngine.getInstance().useStartStopAnims();
        if (this.m_startStopAnims) {
            this.m_ppCarStartImgs = fGImageArray2;
            this.m_ppCarEndImgs = fGImageArray3;
            this.m_startAnim.init(300);
            this.m_endAnim.init(200);
        }
        this.m_smokeAnim.clearArt();
        this.m_smokeAnim.init(100);
        this.m_smokeAnim.addFrameSet(LifeEngine.getInstance().getResLoader(), "smoke0", ".png", 4, false, false);
        this.m_pDrawOrder = m_pegDrawOrderMedium;
        this.m_pPegCoords = m_pegCoordsMedium;
        this.m_pPegCoordsStart = m_pegCoordsMediumStart;
        this.m_pPegCoordsEnd = m_pegCoordsMediumEnd;
        if (this.m_startStopAnims) {
            this.m_startAnimPlaying = false;
            this.m_endAnimPlaying = false;
        }
        this.m_pegCoordOffsetX = LifeEngine.getInstance().getResLoader().getImage("personBlue.png").getWidth() / 2;
        this.m_pegCoordOffsetY = LifeEngine.getInstance().getResLoader().getImage("personBlue.png").getHeight();
    }

    boolean StartAnimFinished() {
        if (this.m_startStopAnims) {
            return this.m_startAnim.finishedPlaying();
        }
        return true;
    }

    boolean EndAnimFinished() {
        if (this.m_startStopAnims) {
            return this.m_endAnim.finishedPlaying();
        }
        return true;
    }

    void GetDrawPos(int[] nArray) {
        nArray[0] = FGFixed.toInt(this.m_pos.m_fixX);
        nArray[1] = FGFixed.toInt(this.m_pos.m_fixY);
    }

    void GetAdjustedCenterPos(int[] nArray) {
        this.GetDrawPos(nArray);
        int n = this.GetSpriteFrame() * 2;
        nArray[0] = nArray[0] + m_mediumCenterPoints[n];
        nArray[1] = nArray[1] + m_mediumCenterPoints[n + 1];
    }

    void GetAdjustedCenterPos(int[] nArray, int n) {
        int n2 = n * 2;
        nArray[0] = m_mediumCenterPoints[n2];
        nArray[1] = m_mediumCenterPoints[n2 + 1];
    }

    void Draw(FGGraphics fGGraphics, int n, int n2) {
        int n3;
        int n4;
        BoardSpace boardSpace = this.GetSpace();
        int n5 = this.GetSpriteFrame();
        int[] nArray = new int[2];
        this.GetDrawPos(nArray);
        int n6 = nArray[0];
        int n7 = nArray[1];
        n6 += n;
        n7 += n2;
        FGImage fGImage = null;
        if (this.m_startStopAnims) {
            if (this.m_startAnimPlaying) {
                if (!this.m_startAnim.finishedPlaying()) {
                    fGImage = this.m_startAnim.getCurrentFrame();
                } else {
                    this.m_startAnimPlaying = false;
                }
            }
            if (this.m_endAnimPlaying) {
                if (!this.m_endAnim.finishedPlaying()) {
                    fGImage = this.m_endAnim.getCurrentFrame();
                } else {
                    this.m_endAnimPlaying = false;
                }
            }
        }
        if (fGImage == null) {
            fGImage = this.m_ppCarImgs[n5];
        }
        if (this.m_smokeAnimPlaying) {
            if (!this.m_smokePlaced) {
                int n8 = n5 * 2;
                n4 = m_mediumSmokeOffsets[n8++];
                n3 = m_mediumSmokeOffsets[n8];
                this.m_smokeX = n6 + n4;
                this.m_smokeY = n7 + n3;
                this.m_smokePlaced = true;
            }
            if (!this.m_smokeAnim.finishedPlaying()) {
                this.m_smokeAnim.getCurrentFrame().drawSelf(fGGraphics, this.m_smokeX, this.m_smokeY);
            } else {
                this.m_smokeAnimPlaying = false;
            }
        }
        fGImage.drawSelf(fGGraphics, n6, n7);
        int[] nArray2 = this.m_pDriver.getCarOccupants();
        n3 = n5 * 12;
        int n9 = n5 * 6;
        int[] nArray3 = this.m_startStopAnims ? (this.m_startAnimPlaying ? this.m_pPegCoordsStart : (this.m_endAnimPlaying ? this.m_pPegCoordsEnd : this.m_pPegCoords)) : this.m_pPegCoords;
        FGImage fGImage2 = LifeEngine.getInstance().getResLoader().getImage("personBlue.png");
        FGImage fGImage3 = LifeEngine.getInstance().getResLoader().getImage("personPink.png");
        for (n4 = 0; n4 < 6; ++n4) {
            int n10 = n3 + this.m_pDrawOrder[n9] * 2;
            int n11 = this.m_pPegCoords[n10];
            int n12 = this.m_pPegCoords[n10 + 1];
            n11 -= this.m_pegCoordOffsetX;
            n12 -= this.m_pegCoordOffsetY;
            int n13 = nArray2[this.m_pDrawOrder[n9]];
            if (n13 != -1) {
                if (n13 == 0) {
                    fGImage2.drawSelf(fGGraphics, n6 + n11, n7 + n12);
                } else {
                    fGImage3.drawSelf(fGGraphics, n6 + n11, n7 + n12);
                }
            }
            ++n9;
        }
    }

    void SetPlayer(Player player) {
        this.m_pDriver = player;
    }

    void SetExtraCarFrames(boolean bl) {
        this.m_extraCarFrames = bl;
        this.m_numCarFrames = 16;
    }

    int GetState() {
        return this.m_currState;
    }

    void SetState(int n) {
        this.m_currState = n;
    }

    BoardSpace GetSpace() {
        return this.m_pCurrBoardSpace;
    }

    FGVector GetPos() {
        return this.m_pos;
    }

    int GetCurrFrameWidth() {
        return this.m_ppCarImgs[this.m_curCarFrame].getWidth();
    }

    int GetCurrFrameHeight() {
        return this.m_ppCarImgs[this.m_curCarFrame].getHeight();
    }

    int GetSpriteFrame() {
        return this.m_curCarFrame;
    }

    boolean IsPlaced() {
        return this.m_placed;
    }

    boolean IsStopped() {
        return this.m_stopSpace;
    }
}

