/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class DeviceSound {
    private static DeviceSound instance;
    private static Player[] midi_sounds;
    private static Player midi_current;
    private static int[] MIDI_FILES;
    private static boolean[] MIDI_LOOPS;
    private static boolean[] SUPPORTED;
    private static int[] SOUND_MAPPING;

    public static void init() {
        try {
            midi_sounds = new Player[MIDI_FILES.length];
            for (int i = 0; i < midi_sounds.length; ++i) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void play(int n) {
        int n2 = SOUND_MAPPING[n];
        if (!SUPPORTED[n2]) {
            return;
        }
        int n3 = Engine.lastSound = MIDI_LOOPS[n2] ? n2 : -1;
        if (!Engine.soundOn || Engine.hideNotify) {
            return;
        }
        try {
            DeviceSound.stop();
            midi_current = Manager.createPlayer((InputStream)new ByteArrayInputStream(ResourceMaster.getResource(MIDI_FILES[n2])), (String)"audio/midi");
            midi_current.setLoopCount(MIDI_LOOPS[n2] ? -1 : 1);
            midi_current.start();
            VolumeControl volumeControl = (VolumeControl)midi_current.getControl("VolumeControl");
            volumeControl.setLevel(50);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stop() {
        try {
            if (midi_current != null) {
                midi_current.deallocate();
                midi_current.stop();
                midi_current = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean resume() {
        int n = Engine.lastSound;
        if (Engine.soundOn && n == 0 && !DeviceSound.isSoundPlaying()) {
            DeviceSound.play(n);
            return DeviceSound.isSoundPlaying();
        }
        return true;
    }

    private static boolean isSoundPlaying() {
        return midi_current != null && midi_current.getState() == 400;
    }

    static {
        MIDI_FILES = new int[]{65864, 65858, 65859, 65860, 65861, 65863, 65862};
        MIDI_LOOPS = new boolean[]{true, false, false, false, false, false, false};
        SUPPORTED = new boolean[]{true, true, false, false, true, true, true};
        SOUND_MAPPING = new int[]{0, 1, 2, 3, 4, 5, 6};
    }
}

