/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DeviceImage
implements Constants {
    public static final boolean USE_CLIPPING = false;
    private Image image;
    private int manipulation = 0;
    private int clip_x;
    private int clip_y;
    public int width;
    public int height;
    public boolean requireClipping;
    public static final boolean REALTIME_SCALING = true;
    private int[] pixels;
    public int[] scaled;
    public int scaled_width;
    public int scaled_height;
    private int old_scaled_width;
    private int old_scaled_height;
    public static final int FLIP_HORIZONTAL = 0;
    private static final int MAX_SCALE = 150;
    public static final boolean ZOOM = true;
    public static final boolean NO_ZOOM = false;

    public DeviceImage(byte[] byArray, int n, int n2) {
        this.createImage(byArray);
        this.image = DeviceImage.scale2(this.image, n, n2);
        this.width = n;
        this.height = n2;
    }

    public static final Image scale2(Image image, int n, int n2) {
        int n3 = image.getWidth();
        int n4 = image.getHeight();
        Image image2 = Image.createImage((int)n, (int)n2);
        Graphics graphics = image2.getGraphics();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                graphics.setClip(i, j, 1, 1);
                graphics.drawImage(image, i - i * n3 / n, j - j * n4 / n2, 20);
            }
        }
        return image2;
    }

    public static void drawDoubleImage(Graphics graphics, Image image, int n, int n2, int n3) {
    }

    public void scale(int n, int n2) {
        Image image = Image.createImage((int)n, (int)n2);
        Graphics graphics = image.getGraphics();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                graphics.setClip(i, j, 1, 1);
                graphics.drawImage(this.image, i - i * this.width / n, j - j * this.height / n2, 20);
            }
        }
        this.image = image;
        this.width = n;
        this.height = n2;
    }

    public void getRGB(int[] nArray, int n) {
        this.image.getRGB(nArray, 0, this.image.getWidth(), 0, 0, this.image.getWidth(), this.image.getHeight());
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = 0;
            int n4 = nArray[i] & 0xFFFFFF;
            if (0xFFFFFF == n4) {
                n3 = 0;
            } else if (-1 == n4) {
                n3 = 255;
            } else if (n > 0) {
                n3 = n;
            }
            nArray[i] = n4 += (n3 <<= 24);
        }
    }

    public DeviceImage(byte[] byArray) {
        this.createImage(byArray);
    }

    public DeviceImage(int n) {
        this.createImage(ResourceMaster.getResource(n));
    }

    public DeviceImage(String string) throws Exception {
        this.createImage(ResourceMaster.getResource(string));
    }

    public DeviceImage(String string, int n) throws Exception {
        byte[] byArray = ResourceMaster.getResource(string);
        this.createImage(byArray);
    }

    public DeviceImage(DeviceImage deviceImage, int n) {
        this.image = deviceImage.image;
        this.manipulation = n;
        this.clip_x = deviceImage.clip_x;
        this.clip_y = deviceImage.clip_y;
        this.requireClipping = deviceImage.requireClipping;
        if (n >= 4) {
            this.width = deviceImage.height;
            this.height = deviceImage.width;
        } else {
            this.width = deviceImage.width;
            this.height = deviceImage.height;
        }
    }

    private void createImage(byte[] byArray) {
        try {
            this.image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            this.width = (short)this.image.getWidth();
            this.height = (short)this.image.getHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DeviceImage(DeviceImage deviceImage, int n, int n2, int n3, int n4) {
        this.width = (short)n3;
        this.height = (short)n4;
        this.image = deviceImage.image;
        this.clip_x = n;
        this.clip_y = n2;
        if (this.clip_x != 0 || this.clip_y != 0 || this.width != deviceImage.width || this.height != deviceImage.height) {
            this.requireClipping = true;
        }
    }

    public DeviceImage[] divide(int n) {
        int n2 = this.width / n;
        int n3 = this.height;
        return this.divide(n2, n3);
    }

    public DeviceImage[] divide(int n, int n2) {
        int n3 = this.width / n;
        int n4 = this.height / n2;
        DeviceImage[] deviceImageArray = new DeviceImage[n4 * n3];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                deviceImageArray[n5++] = new DeviceImage(this, j * n, i * n2, n, n2);
            }
        }
        return deviceImageArray;
    }

    public void drawImage(Graphics graphics, int n, int n2, int n3) {
        if (this.requireClipping || this.manipulation != 0) {
            if (this.manipulation >= 4) {
                graphics.drawRegion(this.image, this.clip_x, this.clip_y, this.height, this.width, this.manipulation, n, n2, n3);
            } else {
                graphics.drawRegion(this.image, this.clip_x, this.clip_y, this.width, this.height, this.manipulation, n, n2, n3);
            }
        } else {
            graphics.drawImage(this.image, n, n2, n3);
        }
    }

    public void drawImage(Graphics graphics, int n, int n2) {
        if (this.requireClipping || this.manipulation != 0) {
            if (this.manipulation >= 4) {
                graphics.drawRegion(this.image, this.clip_x, this.clip_y, this.height, this.width, this.manipulation, n, n2, 20);
            } else {
                graphics.drawRegion(this.image, this.clip_x, this.clip_y, this.width, this.height, this.manipulation, n, n2, 20);
            }
        } else {
            graphics.drawImage(this.image, n, n2, 0);
        }
    }

    public void drawImageNoClipping(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.image, n - this.clip_x, n2 - this.clip_y, 20);
    }

    public DeviceImage(byte[] byArray, boolean bl) {
        try {
            this.image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            this.width = (short)this.image.getWidth();
            this.height = (short)this.image.getHeight();
            if (bl) {
                this.pixels = new int[this.width * this.height];
                this.scaled = new int[this.width * 150 / 100 * (this.height * 150 / 100)];
                this.image.getRGB(this.pixels, 0, this.width, 0, 0, this.width, this.height);
                this.old_scaled_height = -1;
                this.old_scaled_width = -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DeviceImage(byte[] byArray, boolean bl, int n, int n2) {
        try {
            this.image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            this.width = (short)this.image.getWidth();
            this.height = (short)this.image.getHeight();
            if (bl) {
                this.pixels = new int[this.width * this.height];
                this.scaled = new int[2500];
                this.image.getRGB(this.pixels, 0, this.width, 0, 0, this.width, this.height);
                this.old_scaled_height = -1;
                this.old_scaled_width = -1;
                this.resize(n, n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DeviceImage(int[] nArray, int n, int n2) {
        this.pixels = new int[nArray.length];
        this.old_scaled_height = -1;
        this.old_scaled_width = -1;
        this.width = 50;
        this.height = 50;
        System.arraycopy(nArray, 0, this.pixels, 0, this.pixels.length);
        this.scaled = new int[n * n2];
        this.resize(n, n2);
    }

    public void drawImageScaled(Graphics graphics, int n, int n2) {
        graphics.drawRGB(this.scaled, 0, this.scaled_width, n, n2, this.scaled_width, this.scaled_height, true);
    }

    public void drawImageScaled(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.scaled_width / n4;
        graphics.drawRGB(this.scaled, n5 * n3, this.scaled_width, n, n2, n5, this.scaled_height, true);
    }

    public void drawImageScaled(Graphics graphics, int n, int n2, int n3) {
        int[] nArray = new int[this.scaled.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.scaled[i];
            int n4 = 0;
            int n5 = nArray[i] & 0xFFFFFF;
            if (0xFFFFFF == n5) {
                n4 = 0;
            } else if (-1 == n5) {
                n4 = 255;
            } else if (n5 == 0) {
                n4 = 0;
            } else if (n3 > 0) {
                n4 = n3;
            }
            nArray[i] = n5 += (n4 <<= 24);
        }
        graphics.drawRGB(nArray, 0, this.scaled_width, n, n2, this.scaled_width, this.scaled_height, true);
    }

    public void resize(int n, int n2) {
        this.scaled_width = n;
        this.scaled_height = n2;
        this.scale(this.pixels, this.width, this.height, this.scaled, this.scaled_width, this.scaled_height, this.scaled_width, this.scaled_height, 0, 0);
    }

    public void resize(int n) {
        if (n > 150) {
            n = 150;
        }
        this.scaled_width = this.width * n / 100;
        this.scaled_height = this.height * n / 100;
        if (this.old_scaled_width == this.scaled_width && this.old_scaled_height == this.scaled_height) {
            return;
        }
        this.old_scaled_width = this.scaled_width;
        this.old_scaled_height = this.scaled_height;
        this.resize(this.scaled_width, this.scaled_height);
    }

    private void scale(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = 1;
        boolean bl = true;
        int n10 = 0;
        int n11 = 0;
        if (n3 == 0 || n4 == 0) {
            return;
        }
        int n12 = Math.abs(n3);
        int n13 = Math.abs(n4);
        int n14 = (n << 16) / n12;
        int n15 = (n2 << 16) / n13;
        if (n3 > 0 && n4 > 0) {
            n11 = n5 - n12;
        } else if (n3 > 0 && n4 < 0) {
            n11 = -n5 - n12;
        } else if (n3 < 0 && n4 > 0) {
            n11 = n5 + n12;
        } else if (n3 < 0 && n4 < 0) {
            n11 = -n5 + n12;
        }
        int n16 = 0;
        int n17 = n7 + n8 * n5;
        for (int i = 0; i < n13; ++i) {
            int n18 = 0;
            for (int j = 0; j < n12; ++j) {
                nArray2[n17] = nArray[(n18 >> 16) + n16];
                n17 += n9;
                n18 += n14;
            }
            n17 += n11;
            n16 += ((n10 += n15) >> 16) * n;
            n10 &= 0xFFFF;
        }
    }
}

