/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class FontMgr {
    public static final boolean DEBUG_FONTS = false;
    public static final boolean AUTO_CONVERT_TO_UPPERCASE = true;
    public static final int FONT_DISABLED = -1;
    public static final int FONT_TYPE_BMP = 0;
    public static final int FONT_TYPE_MIDP = 1;
    public static final int MIDP_FONT_FACE = 0;
    public static final int MIDP_FONT_COLOR = 1;
    public static final int BMP_FONT_FACE = 0;
    public static final int BMP_FONT_PALETTE = 1;
    public static final int PROP_BASELINE = 0;
    public static final int PROP_BELOW_BASELINE = 1;
    public static final int PROP_BELOW_DESCENDER = 2;
    public static final int PROP_ASCENDER_SPACE = 3;
    public static final int NO_PALETTE = -1;
    public static final int NO_COLOUR = -1;
    private static int[] FONT_CHAR_HEIGHT = new int[Device.MIDP_FONT_FACES.length];
    private static int[] FONT_LINE_HEIGHT = new int[Device.MIDP_FONT_FACES.length];
    private static DeviceImage[][] font_img = new DeviceImage[18][];
    private static char[][] font_chars = new char[18][];
    private static int[] uniform_spacing = new int[18];
    public static int[] maxCharWidth = new int[18];
    public static int[] charHeight = new int[18];
    public static int[] lineHeight = new int[18];
    public static Hashtable[] CHAR_INDEX;
    public static int[][] CHAR_INDEX_ASCII;
    private static final char[] SPECIAL_CHARACTER_MAPPING;

    FontMgr() {
    }

    public static void realise(int n) {
        if (Device.FONT_TYPE[n] == 0 && Device.USE_BITMAP_FONTS) {
            if (font_img[n] != null) {
                return;
            }
            try {
                Object[] objectArray;
                DeviceImage deviceImage;
                int n2;
                int n3 = Device.BMP_FONT_COMPOSITIONS[(n << 1) + 0];
                int n4 = Device.BMP_FONT_FACES[(n3 << 1) + 1];
                byte[] byArray = ResourceMaster.getResource(n4);
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                byArray = null;
                FontMgr.uniform_spacing[n] = dataInputStream.readByte();
                FontMgr.maxCharWidth[n] = dataInputStream.readByte();
                FontMgr.charHeight[n] = dataInputStream.readByte();
                byte by = dataInputStream.readByte();
                FontMgr.lineHeight[n] = charHeight[n] + by;
                int n5 = dataInputStream.readByte() & 0xFF;
                String string = dataInputStream.readUTF();
                FontMgr.font_chars[n] = string.toCharArray();
                byte[] byArray2 = new byte[n5];
                short[] sArray = new short[n5 * 2];
                for (n2 = 0; n2 < n5; ++n2) {
                    byArray2[n2] = dataInputStream.readByte();
                }
                for (n2 = 0; n2 < n5 * 2; ++n2) {
                    sArray[n2] = dataInputStream.readShort();
                }
                n2 = Device.BMP_FONT_FACES[n3 << 1];
                byte[] byArray3 = ResourceMaster.getResource(n2);
                int n6 = Device.BMP_FONT_COMPOSITIONS[(n << 1) + 1];
                if (n6 == -1) {
                    deviceImage = new DeviceImage(byArray3);
                } else {
                    objectArray = ResourceMaster.getResource(n6);
                    deviceImage = new DeviceImage(Engine.insertPLTE(byArray3, objectArray));
                }
                objectArray = new DeviceImage[n5];
                for (int i = 0; i < objectArray.length; ++i) {
                    byte by2 = byArray2[i];
                    short s = sArray[i << 1];
                    short s2 = sArray[(i << 1) + 1];
                    objectArray[i] = (byte)new DeviceImage(deviceImage, s, s2, by2, charHeight[n]);
                }
                FontMgr.font_img[n] = (DeviceImage[])objectArray;
                FontMgr.buildCharIndexCache(n);
                dataInputStream.close();
                dataInputStream = null;
            }
            catch (Exception exception) {}
        } else {
            int n7 = Device.MIDP_FONT_COMPOSITIONS[(n << 1) + 0];
            FontMgr.charHeight[n] = FONT_CHAR_HEIGHT[n7];
            FontMgr.lineHeight[n] = FONT_LINE_HEIGHT[n7];
            FontMgr.maxCharWidth[n] = Device.MIDP_FONT_FACES[n7].charWidth('W');
        }
    }

    public static void release(int n) {
        if (Device.USE_BITMAP_FONTS) {
            FontMgr.font_img[n] = null;
            FontMgr.font_chars[n] = null;
        }
    }

    public static void buildCharIndexCache(int n) {
        FontMgr.CHAR_INDEX[n] = new Hashtable();
        FontMgr.CHAR_INDEX_ASCII[n] = new int[255];
        for (int i = 0; i < font_chars[n].length; ++i) {
            char c = font_chars[n][i];
            int n2 = FontMgr.getRealCharIndex(n, c);
            if (c < '\u00ff') {
                FontMgr.CHAR_INDEX_ASCII[n][c] = n2;
                continue;
            }
            CHAR_INDEX[n].put(new Integer(c), new Integer(n2));
        }
    }

    public static int getRealCharIndex(int n, char c) {
        if (Device.USE_BITMAP_FONTS) {
            for (int i = 0; i < font_chars[n].length; ++i) {
                if (c != font_chars[n][i]) continue;
                return i;
            }
        }
        return -1;
    }

    private static int getCharIndex(int n, char c) {
        if (c < '\u00ff') {
            return CHAR_INDEX_ASCII[n][c];
        }
        return (Integer)CHAR_INDEX[n].get(new Integer(c));
    }

    public static int charWidth(int n, char c) {
        if (Device.FONT_TYPE[n] == -1) {
            return Font.getDefaultFont().charWidth(c);
        }
        if (Device.USE_BITMAP_FONTS && Device.FONT_TYPE[n] == 0) {
            int n2 = FontMgr.getCharIndex(n, c);
            if (n2 != -1) {
                return FontMgr.font_img[n][n2].width + uniform_spacing[n];
            }
            return maxCharWidth[n] >> 1;
        }
        Font font = Device.MIDP_FONT_FACES[Device.MIDP_FONT_COMPOSITIONS[(n << 1) + 0]];
        return font.charWidth(c);
    }

    public static int stringWidth(int n, String string) {
        if (Device.FONT_TYPE[n] == -1) {
            return Font.getDefaultFont().stringWidth(string);
        }
        if (Device.USE_BITMAP_FONTS && Device.FONT_TYPE[n] == 0) {
            char[] cArray = string.toCharArray();
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c == ' ') {
                    n2 += maxCharWidth[n] >> 1;
                    continue;
                }
                n3 = FontMgr.getCharIndex(n, c);
                if ((n3 = FontMgr.convertCharIndexToUpper(n, c, n3)) != -1) {
                    n2 += FontMgr.font_img[n][n3].width + uniform_spacing[n];
                    continue;
                }
                n2 += maxCharWidth[n] >> 1;
            }
            return n2 - uniform_spacing[n];
        }
        Font font = Device.MIDP_FONT_FACES[Device.MIDP_FONT_COMPOSITIONS[(n << 1) + 0]];
        return font.stringWidth(string);
    }

    public static int substringWidth(int n, String string, int n2, int n3) {
        return FontMgr.stringWidth(n, string.substring(n2, n3));
    }

    public static int convertCharIndexToUpper(int n, char c, int n2) {
        if (n2 == -1 || Device.FORCE_UPPERCASE[n]) {
            int n3 = -1;
            if (n3 != -1) {
                c = (char)n3;
            } else {
                char c2 = Character.toUpperCase(c);
                if (c2 != '?') {
                    c = c2;
                }
            }
            n2 = FontMgr.getCharIndex(n, c);
        }
        return n2;
    }

    public static void drawString(int n, Graphics graphics, String string, int n2, int n3, int n4) {
        if (Device.FONT_TYPE[n] == -1) {
            return;
        }
        if (Device.USE_BITMAP_FONTS && Device.FONT_TYPE[n] == 0) {
            int n5;
            if (font_img[n] == null) {
                return;
            }
            int n6 = string.length();
            char[] cArray = string.toCharArray();
            int n7 = 0;
            if ((n4 & 1) > 0) {
                n5 = FontMgr.stringWidth(n, string);
                n2 -= n5 >> 1;
            } else if ((n4 & 8) > 0) {
                n5 = FontMgr.stringWidth(n, string);
                n2 = n2 - n5 + 1;
            }
            if ((n4 & 0x60) > 0) {
                n3 = n3 - charHeight[n] + 1;
            } else if ((n4 & 2) > 0) {
                n3 -= charHeight[n] >> 1;
            }
            n5 = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < n6; ++i) {
                char c = cArray[i];
                if (c == ' ') {
                    n2 += maxCharWidth[n] >> 1;
                    continue;
                }
                n7 = FontMgr.getCharIndex(n, c);
                if ((n7 = FontMgr.convertCharIndexToUpper(n, c, n7)) == -1) {
                    graphics.setColor(0);
                    graphics.fillRect(n2 + 1, n3 + 1, (maxCharWidth[n] >> 1) - 1, charHeight[n] - 1);
                    n2 += maxCharWidth[n] >> 1;
                    continue;
                }
                DeviceImage deviceImage = font_img[n][n7];
                deviceImage.drawImage(graphics, n2, n3);
                n2 += deviceImage.width + uniform_spacing[n];
            }
        } else {
            int n8 = Device.MIDP_FONT_COMPOSITIONS[(n << 1) + 1];
            int n9 = Device.MIDP_FONT_COMPOSITIONS[(n << 1) + 0];
            Font font = Device.MIDP_FONT_FACES[n9];
            if (Device.FORCE_UPPERCASE[n]) {
                string = string.toUpperCase();
            }
            if ((n4 & 1) > 0) {
                int n10 = font.stringWidth(string);
                n2 -= n10 >> 1;
            } else if ((n4 & 8) > 0) {
                int n11 = font.stringWidth(string);
                n2 = n2 - n11 + 1;
            }
            if ((n4 & 0x40) > 0) {
                n3 -= charHeight[n];
            } else if ((n4 & 0x20) > 0) {
                n3 -= charHeight[n] + 2;
            }
            if ((n4 & 2) > 0) {
                n3 -= charHeight[n] >> 1;
            }
            if (n8 != -1) {
                graphics.setColor(n8);
            }
            graphics.setFont(font);
            graphics.drawString(string, n2, n3 - Device.MIDP_FONT_PROPS[n9 * 4 + 3], 20);
        }
    }

    public static int getMapping(char[] cArray, int n) {
        for (int i = 0; i < cArray.length; i += 2) {
            if (n != cArray[i]) continue;
            return cArray[i + 1];
        }
        return -1;
    }

    static {
        for (int i = 0; i < Device.MIDP_FONT_FACES.length; ++i) {
            int n = i * 4;
            int n2 = Device.MIDP_FONT_PROPS[n + 0];
            int n3 = Device.MIDP_FONT_PROPS[n + 1];
            int n4 = Device.MIDP_FONT_PROPS[n + 2];
            int n5 = n3 - n4;
            FontMgr.FONT_CHAR_HEIGHT[i] = n2 - n3;
            FontMgr.FONT_LINE_HEIGHT[i] = n2 - n5 + 10;
        }
        CHAR_INDEX = new Hashtable[18];
        CHAR_INDEX_ASCII = new int[18][];
        SPECIAL_CHARACTER_MAPPING = new char[]{'\u010d', '\u010c', '\u017e', '\u017d', '\u016f', '\u016e', '\u0159', '\u0158', '\u00e9', '\u00c9', '\u00e0', '\u00c0', '\u00f3', '\u00d3', '\u00e7', '\u00c7', '\u00e3', '\u00c3', '\u00e1', '\u00c1', '\u00fa', '\u00da', '\u00ed', '\u00cd', '\u00f1', '\u00d1', '\u00e2', '\u00c2', '\u00ea', '\u00ca', '\u00ee', '\u00cd', '\u00f4', '\u00d4', '\u00fb', '\u00db', '\u00f6', '\u00d6', '\u00e8', '\u00c8', '\u00f2', '\u00d2', '\u00fc', '\u00dc', '\u00e4', '\u00c4', '\u00f5', '\u00d5', '\u00f9', '\u00d9'};
    }
}

