/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;

public class Profile {
    public static final long MILLISECONDS_IN_A_DAY = 86400000L;
    public static final int LEVELEDUPMASK = 0x400000;
    public static Profile[] profiles;
    public static String[] profileNames;
    public String name;
    public int numTotalActivitiesPlayed;
    public int numTotalDaysPlayed;
    public long profileCreatedDate;
    public static final int[] LEVEL_THRESHOLDS;
    public int currentLevel;
    public int startDay;
    public int startMonth;
    public int startYear;
    public int triviaToShow;
    public int[] gamePlays;
    public int[] daysPlayed;
    public int[] dayScores;
    public int[] brainSectionOverallScores;
    public int[] gameScores;
    public int currentDayIndex;
    public boolean hasSeenDailyIntro;
    public Calendar startCalendar;
    public Calendar todaysCalendar;
    public Calendar currentDay;
    public boolean hasPhotoProfile;
    public int photoImgLength;
    public int[] photoImg;
    public boolean hadOnlineSerial;
    public String onlineSerial;
    public int previousSubmittedScore;
    public int geniusScore;
    public boolean emptyProfile;
    public boolean[] BONUS_GAME_UNLOCKED = new boolean[]{false, false};
    public boolean[][] GAME_UNLOCKED = new boolean[][]{{false, false, false}, {false, false, false}, {false, false, false}, {false, false, false}, {true, false, false}, {false, false, false}, {false, false, false}, {false, false, false}, {false, false, false}, {false, false, false}, {true, false, false}, {false, false, false}, {false, false, false}, {false, false, false}, {true, false, false}, {true, false, false}, {false, false, false}, {false, false, false}};
    public int[][] MEDALS_AWARDED = new int[][]{{-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}};
    public static final int NUM_GAMES_TO_GIVE_BRAIN_POWER = 7;
    public Hashtable cachedDateScores = new Hashtable();
    public static int lastFoundDayIndex;
    public boolean leveledUp;

    public Profile(String string) {
        int n;
        int n2;
        int n3;
        this.name = string;
        this.gamePlays = new int[GameWorld.GAME_NAMES.length];
        this.daysPlayed = new int[0];
        this.dayScores = new int[0];
        this.brainSectionOverallScores = new int[4];
        this.startCalendar = Calendar.getInstance();
        this.todaysCalendar = Calendar.getInstance();
        this.currentDayIndex = Profile.getDaysPassed(this.startCalendar, this.todaysCalendar);
        this.profileCreatedDate = this.startCalendar.getTime().getTime();
        this.currentDay = Calendar.getInstance();
        this.gameScores = new int[54];
        for (n3 = 0; n3 < this.gameScores.length; ++n3) {
            this.gameScores[n3] = n3 < this.gameScores.length - 6 ? 0 : Integer.MAX_VALUE;
        }
        this.hasPhotoProfile = false;
        this.onlineSerial = "";
        this.geniusScore = 0;
        this.emptyProfile = true;
        if (string.equals("CHEAT")) {
            for (n3 = 0; n3 < 15; ++n3) {
                this.addDailyScore(new int[]{Engine.rndPositive(100), Engine.rndPositive(100), Engine.rndPositive(100), Engine.rndPositive(100)});
                n2 = 1 + Engine.rndPositive(2);
                for (n = 0; n < n2; ++n) {
                    this.sleep();
                }
            }
            for (n3 = 0; n3 < this.GAME_UNLOCKED.length; ++n3) {
                for (n2 = 0; n2 < this.GAME_UNLOCKED[n3].length; ++n2) {
                    this.GAME_UNLOCKED[n3][n2] = true;
                }
            }
            for (n3 = 0; n3 < this.BONUS_GAME_UNLOCKED.length; ++n3) {
                this.BONUS_GAME_UNLOCKED[n3] = true;
            }
            if (Engine.menuMain != null) {
                if (this.name.toUpperCase().equals(Engine.strCheat.toUpperCase())) {
                    n3 = 7;
                    if (Engine.upsellMode != 0) {
                        n3 = 8;
                    }
                    Engine.menuMain.text[n3] = Engine.strCheat;
                } else {
                    Engine.menuMain.text[7] = Engine.text[33];
                }
            }
        }
        if (Demo.isEnabled()) {
            for (n3 = 0; n3 < 15; ++n3) {
                this.addDailyScore(new int[]{Engine.rndPositive(100), Engine.rndPositive(100), Engine.rndPositive(100), Engine.rndPositive(100)});
                n2 = 1 + Engine.rndPositive(2);
                for (n = 0; n < n2; ++n) {
                    this.sleep();
                }
            }
            for (n3 = 0; n3 < this.GAME_UNLOCKED.length; ++n3) {
                for (n2 = 0; n2 < this.GAME_UNLOCKED[n3].length; ++n2) {
                    this.GAME_UNLOCKED[n3][n2] = false;
                }
            }
            for (n3 = 0; n3 < this.BONUS_GAME_UNLOCKED.length; ++n3) {
                this.BONUS_GAME_UNLOCKED[n3] = false;
            }
            this.leveledUp = false;
        }
    }

    public Profile(String string, boolean bl) {
        this(string);
        this.emptyProfile = bl;
    }

    public int[] getAverageOfDays(int n) {
        int[] nArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = Math.min(this.brainSectionOverallScores[i] * 100 / LEVEL_THRESHOLDS[Math.min(LEVEL_THRESHOLDS.length - 1, this.currentLevel)], 100);
        }
        return nArray;
    }

    public int[][] getRecentDays(int n, int n2) {
        int[][] nArray = new int[4][n2];
        int n3 = n - 1;
        int n4 = Math.max(-1, n3 - n2);
        int n5 = n2 - 1;
        for (int i = n3; i > n4; --i) {
            for (int j = 0; j < 4; ++j) {
                nArray[j][n5] = i < this.numTotalDaysPlayed ? this.dayScores[i * 4 + j] : -1;
            }
            --n5;
        }
        return nArray;
    }

    public void addActivityScore(int n, int n2, int n3) {
        this.MEDALS_AWARDED[n][Engine.currentDifficulty] = Math.max(this.MEDALS_AWARDED[n][Engine.currentDifficulty], n3);
        ++this.numTotalActivitiesPlayed;
        Engine.showAchievementScreenNext = Engine.checkAchievementEvent(this, 0, this.numTotalActivitiesPlayed, n);
        int n4 = n;
        this.gamePlays[n4] = this.gamePlays[n4] + 1;
    }

    public void updateGameScore(int n, int n2, int n3) {
        if (n3 > this.gameScores[n * 3 + n2]) {
            this.gameScores[n * 3 + n2] = n3;
        }
        this.geniusScore = this.getAllExerciseScore();
    }

    public void updateBonusGameScore(int n, int n2, int n3) {
        if (n3 < this.gameScores[n * 3 + n2]) {
            this.gameScores[n * 3 + n2] = n3;
        }
        this.geniusScore = this.getAllExerciseScore();
    }

    public int getGameScore(int n, int n2) {
        return this.gameScores[n * 3 + n2];
    }

    public int getAllExerciseScore() {
        int n = 0;
        for (int i = 0; i < this.gameScores.length - 6; ++i) {
            n += this.gameScores[i];
        }
        return n;
    }

    public int[] getScoresForDate(int n, int n2, int n3) {
        return (int[])this.cachedDateScores.get(n3 + "" + n2 + "" + n);
    }

    public void levelUp() {
        Engine.levelAchievementString = "";
        this.leveledUp = true;
        ++this.currentLevel;
        for (int i = 0; i < this.brainSectionOverallScores.length; ++i) {
            this.brainSectionOverallScores[i] = 0;
        }
        Engine.checkAchievementEvent(this, 2, this.currentLevel, 0);
    }

    public void addDailyScore(int[] nArray) {
        if (this.daysPlayed.length == 0 || this.daysPlayed[this.daysPlayed.length - 1] != this.currentDayIndex) {
            this.numTotalActivitiesPlayed += 4;
            ++this.numTotalDaysPlayed;
            int[] nArray2 = new int[5];
            int[] nArray3 = new int[this.dayScores.length + nArray.length];
            System.arraycopy(this.dayScores, 0, nArray3, 0, this.dayScores.length);
            int n = nArray3.length - nArray.length;
            boolean bl = true;
            for (int i = 0; i < nArray.length; ++i) {
                if (Engine.todaysGames != null) {
                    int n2 = Engine.todaysGames[i];
                    this.gamePlays[n2] = this.gamePlays[n2] + 1;
                } else {
                    int n3 = Engine.rndPositive(GameWorld.GAME_NAMES.length);
                    this.gamePlays[n3] = this.gamePlays[n3] + 1;
                }
                nArray2[i] = nArray[i];
                nArray3[n + i] = nArray[i];
                int n4 = i;
                this.brainSectionOverallScores[n4] = this.brainSectionOverallScores[n4] + nArray[i];
                if (this.brainSectionOverallScores[i] >= LEVEL_THRESHOLDS[Math.min(this.currentLevel, LEVEL_THRESHOLDS.length - 1)]) continue;
                bl = false;
            }
            if (bl) {
                this.levelUp();
                nArray2[4] = 1;
            }
            this.dayScores = nArray3;
            this.cachedDateScores.put(this.todaysCalendar.get(1) + "" + this.todaysCalendar.get(2) + "" + this.todaysCalendar.get(5), nArray2);
            int[] nArray4 = new int[this.daysPlayed.length + 1];
            System.arraycopy(this.daysPlayed, 0, nArray4, 0, this.daysPlayed.length);
            nArray4[nArray4.length - 1] = this.currentDayIndex;
            if (bl) {
                int n5 = nArray4.length - 1;
                nArray4[n5] = nArray4[n5] | 0x400000;
            }
            this.daysPlayed = nArray4;
            if (Engine.checkAchievementEvent(this, 1, this.numTotalDaysPlayed, 0)) {
                Engine.showAchievementScreenNext = true;
            }
        }
    }

    public static void loadAllProfiles(DataInputStream dataInputStream) {
        try {
            byte by = dataInputStream.readByte();
            profiles = new Profile[by];
            for (int i = 0; i < profiles.length; ++i) {
                Profile.profiles[i] = Profile.loadProfile(dataInputStream);
                Profile.profiles[i].leveledUp = false;
            }
        }
        catch (Exception exception) {
            profiles = new Profile[0];
        }
        Profile.updateProfileNames();
    }

    public static void updateProfileNames() {
        profileNames = new String[profiles.length];
        for (int i = 0; i < profiles.length; ++i) {
            Profile.profileNames[i] = Profile.profiles[i].name;
        }
    }

    public static void addProfile(Profile profile) {
        profile.emptyProfile = false;
        Profile.profiles[Engine.selectedProfile] = profile;
        Profile.updateProfileNames();
    }

    public static void storeAllProfiles(DataOutputStream dataOutputStream) {
        try {
            if (profiles == null) {
                profiles = new Profile[3];
                dataOutputStream.writeByte(profiles.length);
                for (int i = 0; i < profiles.length; ++i) {
                    Profile.profiles[i] = new Profile(Engine.getText(256));
                    profiles[i].storeProfileData(dataOutputStream);
                }
            } else {
                dataOutputStream.writeByte(profiles.length);
                for (int i = 0; i < profiles.length; ++i) {
                    profiles[i].storeProfileData(dataOutputStream);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void storeProfileData(DataOutputStream dataOutputStream) {
        try {
            int n;
            int n2;
            dataOutputStream.writeUTF(this.name);
            dataOutputStream.writeBoolean(this.emptyProfile);
            dataOutputStream.writeLong(this.profileCreatedDate);
            dataOutputStream.writeInt(this.numTotalActivitiesPlayed);
            dataOutputStream.writeInt(this.currentLevel);
            dataOutputStream.writeInt(this.triviaToShow);
            for (n2 = 0; n2 < this.GAME_UNLOCKED.length; ++n2) {
                for (n = 0; n < this.GAME_UNLOCKED[n2].length; ++n) {
                    dataOutputStream.writeByte(this.GAME_UNLOCKED[n2][n] ? 1 : 0);
                    dataOutputStream.writeByte(this.MEDALS_AWARDED[n2][n]);
                }
            }
            for (n2 = 0; n2 < this.BONUS_GAME_UNLOCKED.length; ++n2) {
                dataOutputStream.writeByte(this.BONUS_GAME_UNLOCKED[n2] ? 1 : 0);
            }
            dataOutputStream.writeInt(this.numTotalDaysPlayed);
            for (n2 = 0; n2 < this.numTotalDaysPlayed; ++n2) {
                dataOutputStream.writeInt(this.daysPlayed[n2]);
                for (n = 0; n < 4; ++n) {
                    dataOutputStream.writeShort(this.dayScores[n2 * 4 + n]);
                }
            }
            for (n2 = 0; n2 < this.gamePlays.length; ++n2) {
                dataOutputStream.writeInt(this.gamePlays[n2]);
            }
            for (n2 = 0; n2 < this.brainSectionOverallScores.length; ++n2) {
                dataOutputStream.writeInt(this.brainSectionOverallScores[n2]);
            }
            dataOutputStream.writeBoolean(this.hasSeenDailyIntro);
            for (n2 = 0; n2 < this.gameScores.length; ++n2) {
                dataOutputStream.writeInt(this.gameScores[n2]);
            }
            dataOutputStream.writeInt(this.geniusScore);
            Engine.debug("saved score " + this.getAllExerciseScore());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static int getDaysPassed(Calendar calendar, Calendar calendar2) {
        calendar.set(11, 1);
        calendar2.set(11, 1);
        calendar.set(12, 1);
        calendar2.set(12, 1);
        calendar.set(13, 1);
        calendar2.set(13, 1);
        calendar.set(14, 1);
        calendar2.set(14, 1);
        long l = calendar.getTime().getTime();
        long l2 = calendar2.getTime().getTime();
        long l3 = l2 - l;
        int n = (int)(l3 / 86400000L);
        return Math.max(0, n);
    }

    public static Profile loadProfile(DataInputStream dataInputStream) {
        try {
            int n;
            int n2;
            Profile profile = new Profile(dataInputStream.readUTF());
            profile.emptyProfile = dataInputStream.readBoolean();
            profile.profileCreatedDate = dataInputStream.readLong();
            profile.startCalendar = Calendar.getInstance();
            profile.startCalendar.setTime(new Date(profile.profileCreatedDate));
            profile.numTotalActivitiesPlayed = dataInputStream.readInt();
            profile.currentLevel = dataInputStream.readInt();
            profile.triviaToShow = dataInputStream.readInt();
            for (n2 = 0; n2 < 18; ++n2) {
                for (int i = 0; i < 3; ++i) {
                    profile.GAME_UNLOCKED[n2][i] = dataInputStream.readByte() == 1;
                    profile.MEDALS_AWARDED[n2][i] = dataInputStream.readByte();
                }
            }
            for (n2 = 0; n2 < 2; ++n2) {
                profile.BONUS_GAME_UNLOCKED[n2] = dataInputStream.readByte() == 1;
            }
            profile.numTotalDaysPlayed = dataInputStream.readInt();
            profile.daysPlayed = new int[profile.numTotalDaysPlayed];
            profile.dayScores = new int[profile.numTotalDaysPlayed * 4];
            long l = profile.todaysCalendar.getTime().getTime();
            Calendar calendar = Calendar.getInstance();
            for (int i = 0; i < profile.numTotalDaysPlayed; ++i) {
                profile.daysPlayed[i] = dataInputStream.readInt();
                int[] nArray = new int[5];
                for (int j = 0; j < 4; ++j) {
                    nArray[j] = dataInputStream.readShort();
                    profile.dayScores[i * 4 + j] = nArray[j];
                }
                long l2 = profile.profileCreatedDate + (long)(profile.daysPlayed[i] & 0xFFFF) * 86400000L;
                calendar.setTime(new Date(l2));
                if ((profile.daysPlayed[i] & 0x400000) != 0) {
                    nArray[4] = 1;
                }
                profile.cachedDateScores.put(calendar.get(1) + "" + calendar.get(2) + "" + calendar.get(5), nArray);
            }
            long l3 = 0L;
            if (profile.daysPlayed.length > 0) {
                l3 = profile.daysPlayed[profile.daysPlayed.length - 1] & 0xFFFFF;
            }
            l = Math.max(l, profile.profileCreatedDate + l3 * 86400000L);
            profile.todaysCalendar.setTime(new Date(l));
            profile.currentDayIndex = Profile.getDaysPassed(profile.startCalendar, profile.todaysCalendar);
            for (n = 0; n < profile.gamePlays.length; ++n) {
                profile.gamePlays[n] = dataInputStream.readInt();
            }
            profile.brainSectionOverallScores = new int[4];
            for (n = 0; n < profile.brainSectionOverallScores.length; ++n) {
                profile.brainSectionOverallScores[n] = dataInputStream.readInt();
            }
            profile.hasSeenDailyIntro = dataInputStream.readBoolean();
            for (n = 0; n < profile.gameScores.length; ++n) {
                profile.gameScores[n] = dataInputStream.readInt();
            }
            profile.geniusScore = dataInputStream.readInt();
            return profile;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void sleep() {
        Engine.hasShuffledGames = false;
        this.todaysCalendar.setTime(new Date(this.todaysCalendar.getTime().getTime() + 86400000L));
        this.currentDayIndex = Profile.getDaysPassed(this.startCalendar, this.todaysCalendar);
    }

    public int getTotalScore(int n) {
        int n2 = 0;
        for (int i = 0; i < this.gameScores.length / 3; ++i) {
            n2 += this.gameScores[i * 3 + n];
        }
        return n2;
    }

    public int getMedals(int n, int n2) {
        return this.MEDALS_AWARDED[n][n2];
    }

    public static int[][] getAllDailyPerformaceProfile(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int[][] nArrayArray = new int[profiles.length][];
        for (n5 = 0; n5 < profiles.length; ++n5) {
            nArrayArray[n5] = new int[Profile.profiles[n5].numTotalDaysPlayed];
            for (n4 = 0; n4 < Profile.profiles[n5].numTotalDaysPlayed; ++n4) {
                int n7;
                n6 = 0;
                for (n3 = 0; n3 < 4; ++n3) {
                    n6 += Profile.profiles[n5].dayScores[n4 * 4 + n3];
                }
                n6 = Math.min(n6, 400);
                n3 = Engine.divideFixed(25600, 102400);
                nArrayArray[n5][n4] = n7 = Engine.multiFixed(n3, n6 << 8) >> 8;
            }
        }
        n5 = n - 1;
        n4 = Math.max(-1, n5 - n2);
        n3 = n2 - 1;
        int[][] nArray = new int[profiles.length][n2];
        for (int i = 0; i < profiles.length; ++i) {
            n3 = n2 - 1;
            for (int j = n5; j > n4; --j) {
                if (j >= 0) {
                    nArray[i][n3] = j < nArrayArray[i].length ? nArrayArray[i][j] : -1;
                }
                --n3;
            }
        }
        return nArray;
    }

    public static void deleteProfile2(int n) {
        Profile.profiles[n] = new Profile("Empty");
    }

    static {
        LEVEL_THRESHOLDS = new int[]{100, 100, 150, 150, 190, 200};
        lastFoundDayIndex = 0;
    }
}

