/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class InputString {
    private static final boolean INPUT_STANDARD_NUMPAD = true;
    private static final int INPUT_KEY_REPEAT_TIME = 1000;
    private static final int INPUT_MAX_LENGTH = 8;
    public static boolean VALID_INPUT = true;
    private static final int MAPPED_STRING_START = 38;
    private static final int MAPPED_STRING_END = 51;
    private static String combinedKeys = "";
    private static final int[] MAPPED_KEYS = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48};
    private static final int[] MAPPED_KEYS_RIM8100 = new int[]{0x510000, 49, 50, 51, 0x4F0000, 0x410000, 52, 53, 54, 0x4C0000, 0x5A0000, 55, 56, 57, 48};
    private static final int[] MAPPED_KEYS_UPANDDOWN = new int[]{-1, -2, -4};
    private static char[] inputString;
    public static int inputStringLength;
    private static int inputStringCursor;
    private static int inputStringChar;
    private static int inputStringTimer;
    private static int inputStringLastKey;
    private static String inputJoyString;
    private static String s;
    private static int combinedKeysPosition;
    public static int inputStringMode;

    public static void initInputString(String string, int n) {
        inputString = new char[8];
        inputStringMode = n;
        InputString.makeInputCharacters();
        if (string != null) {
            if ((string = string.trim()).length() >= 8) {
                string = string.substring(0, 8);
            }
            for (int i = 0; i < string.length(); ++i) {
                InputString.inputString[i] = string.charAt(i);
            }
            inputStringLength = string.length();
            inputStringCursor = Math.min(inputStringLength, 7);
        } else {
            inputStringLength = 0;
            inputStringCursor = 0;
        }
        inputStringLastKey = 0;
        inputStringTimer = 0;
        inputStringChar = 0;
        Engine.resetKeyBuffers();
    }

    public static String tickInputString() {
        if (!Engine.key(1) && !Engine.key(2) && Engine.key(64) || Engine.key(16) && Engine.keyUnmapped != 53) {
            if (Engine.validInput()) {
                String string = new String(inputString).trim();
                inputString = null;
                return string;
            }
            return null;
        }
        if (Engine.qwertyInput != -1) {
            try {
                if (inputStringCursor < 7) {
                    char c;
                    InputString.inputString[InputString.inputStringCursor] = c = (char)(65 + Engine.qwertyInput);
                    if (inputStringLength < 7) {
                        ++inputStringLength;
                    }
                    ++inputStringCursor;
                }
                Engine.qwertyInput = -1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (Engine.key(128)) {
            Device.soundFunction(3, 2);
            if (inputStringCursor == 0 && inputString[inputStringCursor] == '\u0000') {
                Engine.setMenu(Engine.menuCurrent.previous, true);
            } else if (inputStringCursor >= 0) {
                for (int i = 0; i < inputString.length + 1; ++i) {
                    if (i != inputString.length && inputString[i] != '\u0000') continue;
                    InputString.inputString[i - 1] = '\u0000';
                    inputStringCursor = Math.max(0, i - 1);
                    inputStringLength = Math.max(0, i - 1);
                    break;
                }
                inputStringTimer = 0;
                inputStringChar = 0;
                inputStringLastKey = -1;
            }
        }
        return null;
    }

    public static void makeInputCharacters() {
        for (int i = 48; i < 56; ++i) {
            combinedKeys = combinedKeys + Engine.text[i];
        }
        combinedKeys = " " + combinedKeys + "0123456789";
    }

    private static void handleKeyInputString(int n) {
        Device.soundFunction(3, 2);
        if (inputStringTimer > 0 && n == inputStringLastKey && inputStringMode == 4) {
            if (++inputStringChar >= Engine.text[38 + n].length()) {
                inputStringChar = 0;
            }
        } else {
            inputStringChar = 0;
            if (inputStringCursor < inputStringLength) {
                ++inputStringCursor;
            }
            if (inputStringLength < 7) {
                ++inputStringLength;
            }
        }
        char c = Engine.text[38 + n].charAt(inputStringChar);
        if (inputStringMode == 8 && Engine.keyUnmapped > 47 && Engine.keyUnmapped < 58) {
            c = ("" + (char)Engine.keyUnmapped).charAt(0);
        }
        InputString.inputString[InputString.inputStringCursor] = c;
        inputStringLastKey = n;
        inputStringTimer = 1000;
    }

    private static void handleJoyInputString() {
        boolean bl = false;
        if (Engine.key(1)) {
            if (--inputStringChar < 0) {
                inputStringChar = inputJoyString.length() - 1;
            }
            bl = true;
        } else if (Engine.key(2)) {
            if (inputStringChar == -1 || ++inputStringChar >= inputJoyString.length()) {
                inputStringChar = 0;
            }
            bl = true;
        } else if (Engine.key(8) && inputString[inputStringCursor] != '\u0000' && inputStringCursor < 7) {
            ++inputStringCursor;
            ++inputStringLength;
            inputStringChar = 0;
            bl = true;
        }
        if (bl) {
            InputString.inputString[InputString.inputStringCursor] = inputJoyString.charAt(inputStringChar);
        }
    }

    private static void updateStringChar() {
        inputStringChar = -1;
        char c = inputString[inputStringCursor];
        int n = inputJoyString.length();
        while (n-- != 0) {
            if (inputJoyString.charAt(n) != c) continue;
            inputStringChar = n;
            break;
        }
    }

    public static void paintInputString(Graphics graphics, int n, int n2) {
        int n3;
        s = "";
        for (n3 = 0; n3 < inputString.length; ++n3) {
            if (inputString[n3] == '\u0000') continue;
            s = s + inputString[n3];
        }
        n3 = FontMgr.substringWidth(1, s, 0, inputStringCursor);
        graphics.setColor(0xFFFFFF);
        int n4 = FontMgr.stringWidth(1, s);
        FontMgr.drawString(1, graphics, s, n - (n4 >> 1), n2, 20);
        if (Engine.tick % 10 < 5) {
            graphics.setColor(11288576);
            graphics.fillRect(n3 + n - (n4 >> 1), n2 + FontMgr.lineHeight[1], FontMgr.maxCharWidth[1], 1);
        }
    }

    public static String getInputStringAsString() {
        return s;
    }

    static {
        s = "";
        combinedKeysPosition = 0;
    }
}

