/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Hashtable;

public class ResourceMaster {
    private static final boolean STORE_HASH_ID = true;
    private static final boolean PRELOAD_PAK_CONTENT = true;
    private static DataInputStream dis;
    private static int[] fileHashList;
    private static int[] fileOffset;
    private static int[] fileLength;
    private static byte[][] fileBytes;
    private static int disPosition;
    private static int currentPak;
    private static Hashtable resourceCache;
    private static int[] fileRef;
    private static boolean fileRefInit;

    public static byte[] getResource(int n) {
        if (n == -1) {
            return null;
        }
        int n2 = n & 0xFFFF;
        int n3 = n >> 16 & 0xFFFF;
        byte[] byArray = null;
        try {
            if (n3 == 0) {
                byArray = ResourceMaster.getResourceFromJar(n2 + ".res", true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public static byte[] getResource(String string) {
        int n = ResourceMaster.getIDFromHash(string.hashCode());
        if (n != -1) {
            byte[] byArray = ResourceMaster.getResource(n);
            return byArray;
        }
        return null;
    }

    public static InputStream getResourceAsStream(String string) {
        try {
            InputStream inputStream = ((Object)((Object)Engine.parent)).getClass().getResourceAsStream("/" + string);
            inputStream.skip(4L);
            return inputStream;
        }
        catch (Exception exception) {
            try {
                return new ByteArrayInputStream(ResourceMaster.getResource(string));
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public static int getIDFromHash(int n) {
        int n2 = ResourceMaster.getIDFromRef(n);
        if (n2 != -1) {
            return n2;
        }
        if (currentPak == -1) {
            return -1;
        }
        for (n2 = 0; n2 < fileHashList.length; ++n2) {
            if (fileHashList[n2] != n) continue;
            return currentPak << 16 | n2;
        }
        return -1;
    }

    public static int getIDFromRef(int n) {
        if (!fileRefInit) {
            try {
                InputStream inputStream = ((Object)((Object)Engine.parent)).getClass().getResourceAsStream("/ref.bin");
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                int n2 = dataInputStream.readInt();
                fileRef = new int[n2 << 1];
                for (int i = 0; i < n2; ++i) {
                    ResourceMaster.fileRef[i << 1] = dataInputStream.readInt();
                    ResourceMaster.fileRef[(i << 1) + 1] = dataInputStream.readInt();
                }
                dataInputStream.close();
                fileRefInit = true;
            }
            catch (Exception exception) {
                return -1;
            }
        }
        for (int i = 0; i < fileRef.length; i += 2) {
            if (n != fileRef[i]) continue;
            return fileRef[i + 1];
        }
        return -1;
    }

    public static boolean isCached(int n) {
        return false;
    }

    public static byte[] getResourceFromJar(String string) {
        return ResourceMaster.getResourceFromJar(string, false);
    }

    public static byte[] getResourceFromJar(String string, boolean bl) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = ((Object)((Object)Engine.parent)).getClass().getResourceAsStream("/" + string);
            if (bl) {
                inputStream.skip(4L);
            }
            int n = 0;
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            inputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void closeResource() {
        currentPak = -1;
        fileOffset = null;
        fileLength = null;
        fileHashList = null;
        fileBytes = null;
        try {
            if (dis != null) {
                dis.close();
                dis = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    public static void initPak(int n) {
        if (currentPak != -1) {
            ResourceMaster.closeResource();
        }
        currentPak = n;
        dis = new DataInputStream(((Object)((Object)Engine.parent)).getClass().getResourceAsStream("/" + n + ".pak"));
        try {
            int n2;
            int n3 = dis.readShort();
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            fileHashList = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                ResourceMaster.fileHashList[n2] = dis.readInt();
                nArray[n2] = dis.readInt();
                nArray2[n2] = dis.readInt();
            }
            fileBytes = new byte[n3][];
            for (n2 = 0; n2 < n3; ++n2) {
                ResourceMaster.fileBytes[n2] = new byte[nArray2[n2]];
                dis.read(fileBytes[n2]);
            }
            nArray = null;
            nArray2 = null;
            dis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        currentPak = -1;
        fileRefInit = false;
    }
}

