/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CrossPix
implements Constants {
    private Engine engine;
    private int state;
    private static final boolean INFINITE_LIVES = false;
    private static final int GS_READY = -1;
    private static final int GS_PLAYING = 0;
    private static final int GS_GAMEOVER = 1;
    private static final int GS_COMPLETE = 2;
    private static Graphics sG;
    private static int DEVICE_WIDTH;
    private static int DEVICE_HEIGHT;
    private static int BOARD_WIDTH;
    private static int BOARD_HEIGHT;
    public static int puzzleIndex;
    public static final int TUTORIAL_INTRO = 0;
    public static final int TUTORIAL_INTRO_2 = 1;
    public static final int TUTORIAL_EXPLAIN_NUMBERS = 2;
    public static final int TUTORIAL_EXPLAIN_COLUMN = 3;
    public static final int TUTORIAL_FILL_COLUMN = 4;
    public static final int TUTORIAL_EXPLAIN_ROW = 5;
    public static final int TUTORIAL_FILL_ROW = 6;
    public static final int TUTORIAL_PRAISE_COLUMN_ROW = 7;
    public static final int TUTORIAL_EXPLAIN_CROSS = 8;
    public static final int TUTORIAL_FLASH_CROSS = 9;
    public static final int TUTORIAL_FINAL_COLUMN = 10;
    public static final int TUTORIAL_FINAL_COLUMN_2 = 11;
    public static final int TUTORIAL_FLASH_FINAL_COLUMN = 12;
    public static final int TUTORIAL_CONGRATS = 13;
    public static final int TUTORIAL_END = 14;
    public static final int TUTORIAL_PLACE_WRONG = 20;
    public static final int TUTORIAL_CORRECT = 2;
    public static final int TUTORIAL_WRONG = 3;
    public static final int TUTORIAL_CROSS = 4;
    public static final int TUTORIAL_COMPLETE = 5;
    public static int TutorialState;
    public static int prevTutorialState;
    public static boolean bTutorial;
    public static boolean bTutorialWrong;
    public static boolean bNextTutorialState;
    public static byte[] TutorialFlashColumn;
    public static byte[] TutorialFlashRow;
    public static final int TutorialFlashColor1 = 12008822;
    public static final int TutorialFlashColor2 = 16751285;
    public static byte TutorialFlashRippleCount;
    public static long TutorialFlashRippleTime;
    public static final int TutorialFlashRippleDelay = 250;
    private static final int COMPLETE_STATE_START = 1;
    private static final int COMPLETE_STATE_CENTRE = 2;
    private static final int COMPLETE_STATE_CENTRE_MOVE = 3;
    private static final int COMPLETE_STATE_ZOOM_OUT = 4;
    private static final int COMPLETE_STATE_FILL_GRID = 5;
    private static final int COMPLETE_STATE_FRAME = 6;
    private static final int COMPLETE_STATE_END = 99;
    private static int completeState;
    private static int transitionGradient;
    private static int transitionY;
    private static int transitionX;
    private static final int TRANSITION_SPEED = 3;
    private static boolean bHideClues;
    public static boolean bLevelCleared;
    public static boolean bLevelFailed;
    public static DeviceImage imgFramePuzzle;
    public static String strMenuTheme;
    public static Image imgBuffClueTop;
    public static Graphics gBuffClueTop;
    public static Image imgBuffClueSide;
    public static Graphics gBuffClueSide;
    public static Image imgBuffGrid;
    public static Graphics gBuffGrid;
    private static boolean bBufferGridRedraw;
    private static boolean bBufferClueSideRedraw;
    private static boolean bBufferClueTopRedraw;
    public static final int GAME_INIT = 0;
    public static final int GAME_MENU = 1;
    public static final int GAME_PLAY = 2;
    public static final int GAME_NEXT_LEVEL = 3;
    public static final int GAME_LEVEL_COMPLETE = 4;
    public static final int GAME_OVER = 5;
    public static final int GAME_USE_HINT = 6;
    public static final int GAME_HINT = 7;
    public static final int GAME_TUTORIAL = 8;
    public static int curState;
    public static final int GAME_GFX_MENU_SUPER_INIT = 11;
    public static final int GAME_GFX_MENU_SUPER = 12;
    public static final int GAME_GFX_MENU_PUZZLE_INIT = 13;
    public static final int GAME_GFX_MENU_PUZZLE = 14;
    public static int TILE_W;
    public static int TILE_H;
    private static int MAX_TILE_W;
    private static int MIN_TILE_W;
    private static int[] TILE_MIN_MAX;
    private static int[] SMALLSCREEN_SCALE;
    private static int[] ZOOMOUT_SCALE;
    private static final int TILE_BLANK = 0;
    private static final int TILE_BLOCK = 1;
    private static final int TILE_CROSS = 2;
    public static int VIEWPORT_X;
    public static int VIEWPORT_Y;
    private static int VIEWPORT_W;
    private static int VIEWPORT_H;
    private static int VIEWPORT_TILE_W;
    private static int VIEWPORT_TILE_H;
    private static int VIEWPORT_MID_X;
    private static int VIEWPORT_MID_Y;
    private static int VIEWPORT_EDGE_W;
    private static int VIEWPORT_EDGE_H;
    public static int cursorX;
    public static int cursorY;
    private static int cursorTileX;
    private static int cursorTileY;
    public static int mapMX;
    public static int mapMY;
    private static int scrollSpeed;
    private static int clueSideWidth;
    public static int gameGridW;
    public static int gameGridH;
    private static int[][] clueTop;
    private static int[][] clueSide;
    private static boolean[] TopDone;
    private static boolean[] SideDone;
    private static byte[] TopDoneSub;
    private static byte[] SideDoneSub;
    public static int[][] gameGrid;
    private static int[][] solutionGrid;
    public static long startTime;
    public static long pauseTime;
    public static boolean bInGame;
    private static int gameLives;
    public static long hintStartTime;
    private static final int PUZ_ID_15 = 0;
    private static final int PUZ_ID_10 = 1;
    private static final int PUZ_ID_5 = 2;
    public static final int PUZ_ID_SUPER = 3;
    private static final int PUZ_TRAINER = 0;
    private static final int PUZ_SPORTS = 0;
    private static final int PUZ_CLOTHES = 1;
    private static final int PUZ_ANIMAL = 0;
    private static final int PUZ_BIRD = 1;
    private static final int PUZ_FAST_FOOD = 2;
    private static final int PUZ_FRUIT = 3;
    private static final int PUZ_COUNTRIES = 4;
    private static final int PUZ_SCHOOL = 5;
    private static final int PUZ_VEHICLE = 6;
    private static final int PUZ_SEA = 7;
    private static final int PUZ_TOOL = 8;
    private static final int PUZ_MUSICAL = 9;
    private static final int PUZ_EDITOR = 10;
    private static final int PUZ_SUPER_1 = 0;
    private static final int PUZ_SUPER_2 = 1;
    private static final int PUZ_SUPER_3 = 2;
    private static final int PUZ_SUPER_4 = 3;
    private static final int PUZ_SUPER_W = 3;
    private static final int PUZ_SUPER_H = 3;
    private static int curPuzzleResID;
    public static int curPuzzleGroup;
    public static int curTheme;
    public static int prevTheme;
    public static int curThemePuzzle;
    public static final int THEME_TRAINER = 0;
    public static final int THEME_SPORTS = 1;
    public static final int THEME_CLOTHES = 2;
    public static final int THEME_ANIMAL = 3;
    public static final int THEME_SUPER_1 = 4;
    public static final int THEME_BIRD = 5;
    public static final int THEME_FAST_FOOD = 6;
    public static final int THEME_FRUIT = 7;
    public static final int THEME_SUPER_2 = 8;
    public static final int THEME_COUNTRIES = 9;
    public static final int THEME_SCHOOL = 10;
    public static final int THEME_VEHICLE = 11;
    public static final int THEME_SUPER_3 = 12;
    public static final int THEME_SEA = 13;
    public static final int THEME_TOOL = 14;
    public static final int THEME_MUSICAL = 15;
    public static final int THEME_SUPER_4 = 16;
    public static final int THEME_EDITOR = 17;
    public static int[] puzzleStructure;
    public static final int[] PUZZLE_GAME_IDS;
    public static final int[] SUPER_PUZZLE_GAME_IDS;
    public static int[] puzzleMidiStructure;
    private static DeviceImage[] imgColoured;
    private static Image imgColouredScaled;
    private static Image imgScaled;
    private static Graphics gScaled;
    private static DeviceImage imgProfessor;
    private static DeviceImage imgProfessorSad;
    public static DeviceImage imgSmallProfessor;
    public static DeviceImage[] imgSmallProfessorExpression;
    private static DeviceImage imgTopBar;
    public static Image[] imgBlocks;
    public static int gfxMenuX;
    public static int gfxMenuY;
    public static final int dialogGap = 5;
    public static int dialogTop;
    public static int dialogLeft;
    public static int dialogWidth;
    public static int dialogHeight;
    public static boolean bDialog;
    public static String strDialog;
    public static String[] strSplitDialog;
    public static final byte PROFF_EXPRESSION_NORMAL = 0;
    public static final byte PROFF_EXPRESSION_BLINK = 1;
    public static final byte PROFF_EXPRESSION_HAPPY = 2;
    public static final byte PROFF_EXPRESSION_CRY = 3;
    public static final byte PROFF_EXPRESSION_TALK = 4;
    public static byte proffExpression;
    public static long proffExpressionStartTime;
    public static final long proffExpressionTime = 2500L;
    private static int CLUE_TOP_YOFFSET;
    private static int CLUE_SIDE_XOFFSET;
    public static int MARK_IDLE;
    public static int MARK_BLOCK;
    public static int MARK_CROSS;
    public static int MARK_BLANK;
    public static int MARK_STOP;
    public static int markState;
    private static final int cursorWrongTime = 5;
    private static int cursorWrongCounter;
    public static boolean bCursorWrong;
    public static boolean bMarkBlockStop;
    private static int zoomDir;
    private static int TILE_ZOOM;
    private static int zoomSize;
    private static int markCrossX;
    private static int markCrossY;
    private static int STATUS_BAR_HEIGHT;
    private static int STATUS_BAR_GAP;
    private static Image imgSmallScreen;
    private static Graphics gSmallScreen;
    private static int smallScreenScale;
    private static final int smallScreenGap = 3;
    public static Image[] imgScaleThumb;
    public static int gradientCounter;
    public static int gradientCounterDir;
    public static int statPuzzlePlayed;
    public static int statPuzzleCompleted;
    public static int statPuzzleFailed;
    public static int statMistakes;
    public static int curMistakes;
    public static long statCompletionTime;
    public static int completion;
    public static long gameTime;
    public static boolean gameComplete;
    public static short[] bfPuzzleComplete;
    public static int[] bfPuzzleBestTime;
    public static int[] bfPuzzleBestLives;
    public static final int ANIMATE_HINT_IDLE = 0;
    public static final int ANIMATE_HINT_BOTH = 1;
    public static final int ANIMATE_HINT_SIDE = 2;
    public static final int ANIMATE_HINT_TOP = 3;
    public static int AnimateHintState;
    public static int curCS;
    public static int CS_GRID_SEPORATOR;
    public static int CS_BLOCK_SEPORATOR;
    public static int CS_CURSOR;
    public static int CS_CURSOR_SHADOW;
    public static int CS_CROSS;
    public static int CS_GRID_CLUE_1;
    public static int CS_GRID_CLUE_2;
    public static int CS_GRID_CLUE_LINE;
    public static int CS_SMALLSCREEN_BG;
    public static int CS_SMALLSCREEN_FG;
    public static int CS_GRADIENT_1;
    public static int CS_GRADIENT_2;
    public static int CS_GRID_BLOCK;
    public static int CS_GRID_BLANK;
    public static int[][] ColorScheme;
    public static int CS_VEHICLE_FASTFOOD;
    public static int CS_COUNTRIES_SUPER_1;
    public static int CS_FRUIT_BIRD;
    public static int CS_SEA_SUPER_3;
    public static int CS_ANIMAL_SUPER_2;
    public static int CS_SCHOOL_SUPER_4;
    public static int CS_SPORTS_CLOTHES;
    public static int CS_TUTORIAL_SHAPES;
    public static int CS_TOOLS_MUSIC;
    public static int[] CSMapping;
    public static int[] frameBGColor;
    public static short[] editorBFBlock;
    public static boolean bSaveGame;
    public static long saveGameTime;
    public static int saveGameLives;
    public static short[] saveGameBFBlock;
    public static short[] saveGameBFCross;
    public static int saveGameTheme;
    public static int saveGamePuzzle;
    private static boolean bLoadSavedEditorGame;

    public CrossPix(Engine engine) {
        this.engine = engine;
        this.runState();
        Engine.resetKeyBuffers();
        this.state = -1;
    }

    public void paint(Graphics graphics) {
        CrossPix.paintState(graphics);
    }

    public void tick() {
        if (this.state != 0) {
            if (this.state == -1) {
                this.state = 0;
            } else {
                Engine.state = 40;
            }
            return;
        }
        this.runState();
    }

    public void runState() {
        switch (curState) {
            case 0: {
                DEVICE_WIDTH = 320;
                DEVICE_HEIGHT = 222;
                BOARD_WIDTH = 319;
                BOARD_HEIGHT = 222 - Engine.imgTips[0].height - 2;
                STATUS_BAR_GAP = 1;
                STATUS_BAR_HEIGHT = 50;
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 2: {
                int n;
                CrossPix.clipScreen();
                CrossPix.keyGameGrid();
                bInGame = true;
                if (TILE_ZOOM != TILE_W) {
                    if (zoomDir < 0 && TILE_W < TILE_ZOOM - zoomDir) {
                        zoomDir = 0;
                        TILE_W = MIN_TILE_W;
                        TILE_H = MIN_TILE_W;
                        TILE_ZOOM = TILE_W;
                    }
                    CrossPix.initGrid();
                    cursorX = cursorTileX * (TILE_W += zoomDir);
                    cursorY = cursorTileY * (TILE_H += zoomDir);
                    CrossPix.centreGrid();
                    CrossPix.RedrawGrid();
                } else if (Engine.key(4096)) {
                    if (TILE_ZOOM >= MIN_TILE_W && TILE_ZOOM < MAX_TILE_W - 1) {
                        zoomDir = 1;
                        TILE_ZOOM += 5;
                    } else {
                        zoomDir = -2;
                        TILE_ZOOM = MIN_TILE_W;
                    }
                }
                if (!bTutorial && Engine.cheat(0)) {
                    CrossPix.drawSmallScreen(false);
                    completeState = 1;
                    bLevelCleared = true;
                    startTime -= 1800000L;
                    return;
                }
                if (bLevelCleared) {
                    switch (completeState) {
                        case 1: {
                            CrossPix.unLoadGridBuffers(true);
                            zoomDir = -1;
                            if (gameGridH == 15) {
                                // empty if block
                            }
                            if (TILE_W > (TILE_ZOOM = TILE_MIN_MAX[curPuzzleGroup << 1])) break;
                            completeState = 2;
                            if (!bLevelCleared) break;
                            CrossPix.LevelCleared();
                            break;
                        }
                        case 2: {
                            TopDone = new boolean[gameGridW];
                            SideDone = new boolean[gameGridH];
                            for (n = 0; n < gameGridH; ++n) {
                                for (int i = 0; i < gameGridW; ++i) {
                                    CrossPix.gameGrid[i][n] = solutionGrid[i][n];
                                }
                            }
                            bHideClues = true;
                            transitionX = VIEWPORT_X - (DEVICE_WIDTH - gameGridW * TILE_W >> 1);
                            cursorX = 0;
                            cursorY = 0;
                            completeState = 3;
                            break;
                        }
                        case 3: {
                            if ((transitionX -= 3) >= 0) {
                                VIEWPORT_X -= 3;
                                transitionGradient += 4;
                                break;
                            }
                            transitionY = 0;
                            transitionGradient = 100;
                            if (!bTutorial) {
                                CrossPix.setColourScaled(imgColoured[CrossPix.ColouredImageIndex()], TILE_W);
                            }
                            completeState = 5;
                            break;
                        }
                        case 5: {
                            if ((transitionY += TILE_H) <= gameGridH * TILE_H + 1) break;
                            completeState = 4;
                            break;
                        }
                        case 4: {
                            CrossPix.unLoadGridBuffers(false);
                            zoomDir = -1;
                            TILE_ZOOM = ZOOMOUT_SCALE[curPuzzleGroup];
                            imgScaled = null;
                            if (!bTutorial) {
                                CrossPix.setColourScaled(imgColoured[CrossPix.ColouredImageIndex()], TILE_W);
                            }
                            if (TILE_W != TILE_ZOOM) break;
                            if (curPuzzleGroup == 2 || curPuzzleGroup == 3) {
                                CrossPix.initProfessorDialog(Engine.text[309]);
                            } else {
                                boolean bl;
                                String string = Engine.text[312] + " ";
                                String string2 = Engine.text[313] + " ";
                                int n2 = curTheme * 10 + curThemePuzzle;
                                boolean bl2 = bl = !gameComplete || gameTime < (long)bfPuzzleBestTime[n2];
                                if (bl) {
                                    CrossPix.bfPuzzleBestTime[n2] = (int)gameTime;
                                    CrossPix.bfPuzzleBestLives[n2] = gameLives;
                                }
                                CrossPix.initProfessorDialog(CrossPix.puzzleName(curTheme, curThemePuzzle) + Engine.text[309] + "\n" + string + CrossPix.milliSecsToString(gameTime, true, true) + "\n" + string2 + gameLives);
                                Engine.EditorMode = 0;
                            }
                            Engine.resetAllKeyBuffers();
                            curState = 4;
                            GameWorld.state = 3;
                            CrossPix crossPix = this;
                            crossPix.engine.resetAllKeyBuffers();
                            break;
                        }
                        case 6: {
                            break;
                        }
                        case 99: {
                            break;
                        }
                    }
                }
                cursorTileX = cursorX / TILE_W;
                cursorTileY = cursorY / TILE_H;
                if (mapMX < CrossPix.mapX()) {
                    mapMX += scrollSpeed;
                }
                if (mapMX > CrossPix.mapX()) {
                    mapMX -= scrollSpeed;
                }
                if (mapMY < CrossPix.mapY()) {
                    mapMY += scrollSpeed;
                }
                if (mapMY > CrossPix.mapY()) {
                    mapMY -= scrollSpeed;
                }
                scrollSpeed = cursorX - VIEWPORT_W + TILE_W * 3 > mapMX || cursorY - VIEWPORT_H + TILE_H * 3 > mapMY || cursorX - TILE_W * 2 < mapMX || cursorY - TILE_H * 2 < mapMY ? TILE_W / 2 : TILE_W / 4;
                if (cursorX - VIEWPORT_W + TILE_W > mapMX) {
                    mapMX = cursorX - VIEWPORT_W + TILE_W;
                }
                if (cursorX < mapMX) {
                    mapMX = cursorX;
                }
                if (cursorY - VIEWPORT_H + TILE_H > mapMY) {
                    mapMY = cursorY - VIEWPORT_H + TILE_H;
                }
                if (cursorY < mapMY) {
                    mapMY = cursorY;
                }
                if (mapMX < 0) {
                    mapMX = 0;
                }
                if (mapMY < 0) {
                    mapMY = 0;
                }
                for (n = 0; n < 150; ++n) {
                    Engine.vAnim[n].tick();
                    if (!bLevelCleared && !bLevelFailed || Engine.vAnim[n].state != 1) continue;
                    Engine.vAnim[n].state = 0;
                }
                if (!bLevelFailed) break;
                CrossPix.LevelFailed();
                break;
            }
            case 4: {
                if (Engine.key(16) || Engine.key(64)) {
                    bLevelCleared = false;
                    bLevelFailed = false;
                    this.engine.goToMainMenuFromGame(Engine.menuMain);
                }
                Engine.resetAllKeyBuffers();
                break;
            }
            case 5: {
                if (Engine.key(16) || Engine.key(64)) {
                    this.engine.freeCrossPix();
                    this.engine.goToMainMenuFromGame(Engine.menuMain);
                }
                Engine.resetAllKeyBuffers();
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 11: {
                break;
            }
        }
    }

    private static void loadFramePuzzle() {
    }

    private static void setSuperImage() {
    }

    public static String puzzleName(int n, int n2) {
        String string = "";
        if (curPuzzleGroup == 3 || Engine.EditorMode == 1) {
            string = "";
        }
        return (string = Engine.text[n * 5 + 314 + n2]) != "" ? string + "\n" : "";
    }

    public static void paintState(Graphics graphics) {
        if (sG == null) {
            sG = graphics;
        }
        switch (curState) {
            case 0: {
                CrossPix.TutorialOff();
                if (bSaveGame || Engine.EditorMode == 2) {
                    curState = 2;
                    bSaveGame = false;
                    break;
                }
                curState = 6;
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                CrossPix.drawGame();
                break;
            }
            case 8: {
                CrossPix.drawGame();
                if (!bDialog) break;
                CrossPix.drawProfessorDialogTutorial();
                Engine.paintMenu(sG);
                break;
            }
            case 2: {
                CrossPix.drawGame();
                if (!bLevelCleared) break;
                switch (completeState) {
                    case 5: {
                        sG.setClip(VIEWPORT_X, VIEWPORT_Y, TILE_W * gameGridW, transitionY);
                        sG.drawImage(imgScaled, VIEWPORT_X + 1, VIEWPORT_Y, 20);
                        break;
                    }
                    case 4: {
                        sG.setClip(VIEWPORT_X, VIEWPORT_Y, TILE_W * gameGridW, transitionY);
                        sG.drawImage(imgScaled, VIEWPORT_X + 1, VIEWPORT_Y, 20);
                    }
                }
                CrossPix.clipScreen();
                sG.setColor(CrossPix.gradientColor(ColorScheme[curCS][CS_GRID_CLUE_1], 0, transitionGradient));
                sG.fillRect(0, DEVICE_HEIGHT - Engine.imgTips[0].height, DEVICE_WIDTH, Engine.imgTips[0].height + 1);
                break;
            }
            case 4: {
                CrossPix.clipScreen();
                Engine.paintTextBgRect(graphics, 5, 5, 310, 205, false, 0xFFFFFF);
                int n = 5;
                int n2 = DEVICE_HEIGHT / 7 * 2;
                int n3 = imgScaled.getWidth() + n * 2 + (imgScaled.getWidth() >> 1);
                int n4 = imgScaled.getHeight() + n * 2;
                CrossPix.clipScreen();
                sG.drawImage(imgScaled, DEVICE_WIDTH - imgScaled.getWidth() >> 1, n2, 20);
                CrossPix.drawProfessorDialog();
                break;
            }
            case 5: {
                Engine.paintTextBgRect(graphics, 5, 5, 310, 205, false, 0xFFFFFF);
                CrossPix.drawProfessorDialog();
                break;
            }
            case 14: {
                break;
            }
        }
    }

    private static boolean isPuzzleComplete(int n, int n2) {
        return CrossPix.bBitFlag(bfPuzzleComplete[n], n2);
    }

    public static void TutorialOff() {
        bTutorial = false;
        bTutorialWrong = false;
        bDialog = false;
        bNextTutorialState = false;
        TutorialFlashColumn = null;
        TutorialFlashRow = null;
    }

    public static void setTutorialDialog(String string) {
    }

    public static void setTutorial(int n) {
    }

    public static String reverseString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = n - 1; i >= 0; --i) {
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static void LevelCleared() {
        gameComplete = (bfPuzzleComplete[curTheme] & 2 << curThemePuzzle) != 0;
        int n = curTheme;
        bfPuzzleComplete[n] = (short)(bfPuzzleComplete[n] | 2 << curThemePuzzle);
        ++statPuzzleCompleted;
        statMistakes += curMistakes;
        gameTime = System.currentTimeMillis() - startTime;
        statCompletionTime += gameTime;
        GameWorld.saveBousGameBestTime((int)gameTime);
        Engine.resetKeyBuffers();
        Device.soundFunction(3, 6);
        Engine.lastSound = -1;
    }

    private static void LevelFailed() {
        Device.soundFunction(3, 6);
        if (curPuzzleGroup != 2) {
            ++statPuzzleFailed;
        }
        zoomDir = -2;
        TILE_ZOOM = MIN_TILE_W;
        CrossPix.initProfessorDialog(Engine.text[310]);
        curState = 5;
        Device.soundFunction(3, 1);
        Engine.lastSound = -1;
        GameWorld.state = 3;
        Engine.resetAllKeyBuffers();
    }

    public static void drawFrame(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    private static void clipScreen() {
        sG.setClip(0, 0, DEVICE_WIDTH, DEVICE_HEIGHT);
    }

    public static void RedrawGrid() {
        bBufferGridRedraw = true;
        bBufferClueSideRedraw = true;
        bBufferClueTopRedraw = true;
    }

    public static void drawGame() {
        CrossPix.clipScreen();
        sG.setColor(ColorScheme[curCS][CS_GRID_CLUE_1]);
        if (bHideClues) {
            sG.setColor(CrossPix.gradientColor(ColorScheme[curCS][CS_GRID_CLUE_1], 0, transitionGradient));
        }
        if (bLevelCleared) {
            sG.fillRect(0, 0, DEVICE_WIDTH, DEVICE_HEIGHT);
        }
        sG.setClip(0, 0, DEVICE_WIDTH, BOARD_HEIGHT);
        CrossPix.drawGrid(sG, mapMX, mapMY);
        if (Engine.EditorMode != 2) {
            CrossPix.drawClues(sG, mapMX, mapMY);
        }
        CrossPix.clipScreen();
        CrossPix.drawBlockTip();
        CrossPix.clipScreen();
        int n = VIEWPORT_X - clueSideWidth + (clueSideWidth - gameGridW * smallScreenScale >> 1);
        int n2 = VIEWPORT_Y - STATUS_BAR_HEIGHT - imgSmallScreen.getHeight() >> 1;
        sG.setClip(VIEWPORT_X - clueSideWidth, STATUS_BAR_HEIGHT + 0, gameGridW * TILE_W + clueSideWidth, gameGridH * TILE_H + VIEWPORT_Y - STATUS_BAR_HEIGHT - 0);
        sG.setColor(ColorScheme[curCS][CS_GRID_CLUE_2]);
        if (bHideClues) {
            sG.setColor(CrossPix.gradientColor(ColorScheme[curCS][CS_GRID_CLUE_2], 0, transitionGradient));
        }
        sG.fillRect(VIEWPORT_X - clueSideWidth, 0, clueSideWidth, VIEWPORT_Y);
        if (!bHideClues) {
            sG.drawImage(imgSmallScreen, n, n2 + STATUS_BAR_HEIGHT, 20);
        }
        sG.setClip(0, 0, DEVICE_WIDTH, BOARD_HEIGHT);
        sG.setColor(0);
        sG.drawRect(VIEWPORT_X - clueSideWidth, STATUS_BAR_HEIGHT + 0, gameGridW * TILE_W + clueSideWidth, gameGridH * TILE_H + VIEWPORT_Y - STATUS_BAR_HEIGHT - 0);
        CrossPix.clipScreen();
        CrossPix.drawCursor();
        sG.setColor(CS_CURSOR);
        if (bHideClues) {
            sG.setColor(CrossPix.gradientColor(CS_CURSOR, 0, transitionGradient));
        }
        int n3 = mapMX / TILE_W * smallScreenScale;
        int n4 = mapMY / TILE_H * smallScreenScale;
        sG.drawRect(n + n3 - 1, n2 + n4 + STATUS_BAR_HEIGHT - 1, VIEWPORT_TILE_W * smallScreenScale + 1, VIEWPORT_TILE_H * smallScreenScale + 1);
        if (AnimateHintState == 0 && CrossPix.drawCursorAndClue()) {
            sG.setColor(CS_CURSOR);
            if (bHideClues) {
                sG.setColor(CrossPix.gradientColor(CS_CURSOR, 0, transitionGradient));
            }
            sG.fillRect(n + cursorTileX * smallScreenScale, n2 + cursorTileY * smallScreenScale + STATUS_BAR_HEIGHT, smallScreenScale, smallScreenScale);
        }
        for (n3 = 0; n3 < 150; ++n3) {
            Engine.vAnim[n3].draw(sG);
        }
        CrossPix.drawStatusBar();
    }

    public static boolean bThemeComplete(int n) {
        int n2;
        switch (puzzleStructure[n * 2]) {
            case 3: {
                n2 = 9;
                break;
            }
            default: {
                n2 = 10;
            }
        }
        return bfPuzzleComplete[n] == (2 << n2) - 2;
    }

    public static void MenuLoadPuzzle(int n, int n2) {
        curTheme = n;
        curThemePuzzle = n2;
        curCS = 0;
        n += n;
        curPuzzleGroup = puzzleStructure[n];
        imgColoured = null;
        int n3 = 0;
        switch (curPuzzleGroup) {
            case 0: {
                n3 = 287 + puzzleStructure[n + 1] * 10 + n2;
                break;
            }
            case 1: {
                n3 = 282 + puzzleStructure[n + 1] * 10 + n2;
                break;
            }
            case 2: {
                n3 = 292 + puzzleStructure[n + 1] * 10 + n2;
                break;
            }
        }
        CrossPix.LoadPuzzle(n3);
    }

    public static void LoadThemeTiles(int n) {
        if (curTheme == prevTheme) {
            return;
        }
        prevTheme = n;
        int n2 = MAX_TILE_W * 2 + 3;
        Engine.paintLoading();
        int n3 = 278;
        try {
            imgBlocks = new Image[n2];
            DeviceImage deviceImage = new DeviceImage(ResourceMaster.getResource(n3));
            for (int i = MIN_TILE_W - 2; i < imgBlocks.length; ++i) {
                switch (i) {
                    case 9: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 19: {
                        break;
                    }
                    default: {
                        CrossPix.imgBlocks[i] = CrossPix.scaleImage(deviceImage, i, i, 0);
                    }
                }
                Engine.paintLoading();
            }
            CrossPix.imgBlocks[9] = CrossPix.DeviceImageToImage(new DeviceImage(ResourceMaster.getResource(n3 - 4)), 0);
            Engine.paintLoading();
            CrossPix.imgBlocks[13] = CrossPix.DeviceImageToImage(new DeviceImage(ResourceMaster.getResource(n3 - 3)), 0);
            Engine.paintLoading();
            CrossPix.imgBlocks[14] = CrossPix.DeviceImageToImage(new DeviceImage(ResourceMaster.getResource(n3 - 2)), 0);
            Engine.paintLoading();
            CrossPix.imgBlocks[17] = CrossPix.DeviceImageToImage(new DeviceImage(ResourceMaster.getResource(n3 - 1)), 0);
            Engine.paintLoading();
            CrossPix.imgBlocks[19] = CrossPix.DeviceImageToImage(new DeviceImage(ResourceMaster.getResource(n3 - 0)), 0);
            Engine.paintLoading();
        }
        catch (Exception exception) {
            System.out.println("LoadTiles error " + exception);
        }
    }

    public static void LoadPuzzle(int n) {
        int n2;
        int n3;
        curPuzzleResID = n;
        CrossPix.RedrawGrid();
        ++statPuzzlePlayed;
        curMistakes = 0;
        if (Engine.EditorMode == 0 && !bLoadSavedEditorGame) {
            try {
                byte[] byArray = ResourceMaster.getResource(n);
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                int n4 = n3 = dataInputStream.readShort();
                gameGrid = new int[n3][n4];
                solutionGrid = new int[n3][n4];
                gameGridW = gameGrid.length;
                gameGridH = gameGrid[0].length;
                short s = 0;
                int n5 = 0;
                while ((s = dataInputStream.readShort()) != -1) {
                    for (int i = 0; i < gameGridW; ++i) {
                        if (((short)s & 1 << i) != 1 << i) continue;
                        CrossPix.solutionGrid[i][n5] = 1;
                    }
                    ++n5;
                }
                dataInputStream.close();
                dataInputStream = null;
                byArray = null;
            }
            catch (Exception exception) {
                System.out.println("LoadPuzzle error " + exception);
            }
        } else {
            byte by = Engine.editorPuzzleGridSize;
            gameGrid = new int[by][by];
            solutionGrid = new int[by][by];
            gameGridW = gameGrid.length;
            gameGridH = gameGrid[0].length;
            if (Engine.bEditorPuzzleExist) {
                if (Engine.EditorMode == 1 || bLoadSavedEditorGame) {
                    for (int i = 0; i < gameGridH; ++i) {
                        for (n3 = 0; n3 < gameGridW; ++n3) {
                            if (!CrossPix.bBitFlag(editorBFBlock[i], n3)) continue;
                            CrossPix.solutionGrid[n3][i] = 1;
                        }
                    }
                } else {
                    for (int i = 0; i < gameGridH; ++i) {
                        for (n3 = 0; n3 < gameGridW; ++n3) {
                            CrossPix.solutionGrid[n3][i] = 1;
                            if (!CrossPix.bBitFlag(editorBFBlock[i], n3)) continue;
                            CrossPix.gameGrid[n3][i] = 1;
                        }
                    }
                }
            }
        }
        bLevelCleared = false;
        bHideClues = false;
        completeState = 0;
        transitionX = 0;
        transitionY = 0;
        transitionGradient = 0;
        MIN_TILE_W = TILE_MIN_MAX[curPuzzleGroup << 1];
        MAX_TILE_W = TILE_MIN_MAX[(curPuzzleGroup << 1) + 1];
        TILE_W = MIN_TILE_W;
        TILE_H = MIN_TILE_W;
        TILE_ZOOM = TILE_W;
        Engine.touchGameMode = 2;
        CrossPix.LoadThemeTiles(curTheme);
        CrossPix.setSmallScreen(gameGridW, gameGridH, SMALLSCREEN_SCALE[curPuzzleGroup]);
        CrossPix.initGrid();
        cursorX = gameGridW / 2 * TILE_W;
        cursorY = gameGridH / 2 * TILE_H;
        cursorTileX = cursorX / TILE_W;
        cursorTileY = cursorY / TILE_H;
        CrossPix.centreGrid();
        TopDone = new boolean[gameGridW];
        SideDone = new boolean[gameGridH];
        TopDoneSub = new byte[gameGridW];
        SideDoneSub = new byte[gameGridH];
        for (n2 = 0; n2 < clueTop.length; ++n2) {
            if (clueTop[n2][0] != 0) continue;
            CrossPix.TopDone[n2] = true;
            for (int i = 0; i < gameGridH; ++i) {
                CrossPix.gameGrid[n2][i] = 2;
            }
        }
        for (n2 = 0; n2 < clueSide.length; ++n2) {
            if (clueSide[n2][0] != 0) continue;
            CrossPix.SideDone[n2] = true;
            for (int i = 0; i < gameGridW; ++i) {
                CrossPix.gameGrid[i][n2] = 2;
            }
        }
        switch (curTheme) {
            case 0: {
                gameLives = 9;
                break;
            }
            case 1: 
            case 2: {
                gameLives = 8;
                break;
            }
            default: {
                gameLives = 6;
            }
        }
        AnimateHintState = 0;
        bCursorWrong = false;
        bLevelCleared = false;
        bLevelFailed = false;
        for (n2 = 0; n2 < 150; ++n2) {
            if (Engine.vAnim[n2] == null) continue;
            Engine.vAnim[n2].setIdle();
            Engine.vAnim[n2].Count = 0;
        }
        imgColouredScaled = null;
        imgScaled = null;
        gScaled = null;
        imgFramePuzzle = null;
        imgSmallProfessor = null;
        imgSmallProfessorExpression = null;
        if (!bTutorial) {
            CrossPix.setPuzzleImage(curTheme);
        }
        curState = 0;
    }

    public static void setPuzzleImage(int n) {
        int n2 = puzzleStructure[n * 2];
        if (n2 != curPuzzleGroup || imgColoured == null) {
            switch (n2) {
                case 0: {
                    imgColoured = new DeviceImage(ResourceMaster.getResource(280)).divide(15, 15);
                    break;
                }
                case 1: {
                    imgColoured = new DeviceImage(ResourceMaster.getResource(279)).divide(10, 10);
                    break;
                }
                case 2: {
                    imgColoured = new DeviceImage(ResourceMaster.getResource(281)).divide(5, 5);
                    break;
                }
            }
        }
        curPuzzleGroup = n2;
    }

    private static int ColouredImageIndex() {
        int n = 0;
        switch (curPuzzleGroup) {
            case 0: {
                n = curPuzzleResID - 287;
                break;
            }
            case 1: {
                n = curPuzzleResID - 282;
                break;
            }
            case 2: {
                n = curPuzzleResID - 292;
                break;
            }
            case 3: {
                n = curThemePuzzle;
            }
        }
        if (Engine.EditorMode == 1) {
            n = 0;
        }
        return n;
    }

    private static void initGrid() {
        clueTop = CrossPix.genClueTop();
        clueSide = CrossPix.genClueSide();
        clueSideWidth = CrossPix.getClueSideWidth() + (CLUE_SIDE_XOFFSET << 1);
        int n = (clueSideWidth = Math.max(clueSideWidth, gameGridW * smallScreenScale + 6)) + gameGridW * TILE_W;
        VIEWPORT_X = n < BOARD_WIDTH ? (BOARD_WIDTH - n >> 1) + clueSideWidth : clueSideWidth;
        if (completeState == 4) {
            VIEWPORT_X = BOARD_WIDTH - gameGridW * TILE_W >> 1;
        }
        VIEWPORT_Y = Math.max(CrossPix.getClueTopHeight() + CLUE_TOP_YOFFSET * 2 + STATUS_BAR_HEIGHT, gameGridH * smallScreenScale + STATUS_BAR_HEIGHT + 6);
        VIEWPORT_W = BOARD_WIDTH - VIEWPORT_X;
        VIEWPORT_H = BOARD_HEIGHT - VIEWPORT_Y;
        VIEWPORT_TILE_W = VIEWPORT_W / TILE_W + (VIEWPORT_W % TILE_W > 0 ? 1 : 0);
        VIEWPORT_TILE_H = VIEWPORT_H / TILE_H + (VIEWPORT_H % TILE_H > 0 ? 1 : 0);
        if (VIEWPORT_TILE_W >= gameGridW) {
            VIEWPORT_TILE_W = gameGridW;
        }
        if (VIEWPORT_TILE_H >= gameGridH) {
            VIEWPORT_TILE_H = gameGridH;
        }
        VIEWPORT_MID_X = (VIEWPORT_W >> 1) - (TILE_W >> 1);
        VIEWPORT_MID_Y = (VIEWPORT_H >> 1) - (TILE_H >> 1);
        VIEWPORT_EDGE_W = gameGridW * TILE_W - VIEWPORT_W;
        VIEWPORT_EDGE_H = gameGridH * TILE_H - VIEWPORT_H;
        if (VIEWPORT_EDGE_W < 0) {
            VIEWPORT_EDGE_W = 0;
        }
        if (VIEWPORT_EDGE_H < 0) {
            VIEWPORT_EDGE_H = 0;
        }
        CrossPix.unLoadGridBuffers(false);
        if (!bLevelCleared) {
            // empty if block
        }
    }

    public static void unLoadGridBuffers(boolean bl) {
    }

    public static int mapX() {
        int n = cursorX - VIEWPORT_MID_X;
        if (n <= 0) {
            n = 0;
        } else if (n >= VIEWPORT_EDGE_W) {
            n = gameGridW * TILE_W < VIEWPORT_W ? 0 : VIEWPORT_EDGE_W;
        }
        return n;
    }

    public static int mapY() {
        int n = cursorY - VIEWPORT_MID_Y;
        if (n <= 0) {
            n = 0;
        } else if (n >= VIEWPORT_EDGE_H) {
            n = gameGridH * TILE_H < VIEWPORT_H ? 0 : VIEWPORT_EDGE_H;
        }
        return n;
    }

    public static void centreGrid() {
        mapMX = cursorX - VIEWPORT_MID_X;
        mapMY = cursorY - VIEWPORT_MID_Y;
        if (mapMX <= 0) {
            mapMX = 0;
        } else if (mapMX >= VIEWPORT_EDGE_W) {
            mapMX = VIEWPORT_EDGE_W;
        }
        if (mapMY <= 0) {
            mapMY = 0;
        } else if (mapMY >= VIEWPORT_EDGE_H) {
            mapMY = VIEWPORT_EDGE_H;
        }
    }

    public static void initProfessorDialog(String string) {
        int n = 100;
        strDialog = string;
        strSplitDialog = Engine.getStrings(strDialog, n, 0);
    }

    public static void drawProfessorDialog() {
        CrossPix.clipScreen();
        CrossPix.clipScreen();
        int n = FontMgr.charHeight[0];
        int n2 = 0;
        n2 = curState == 5 ? 111 : DEVICE_HEIGHT / 7 * 2 + imgScaled.getHeight() + 20;
        for (int i = 0; i < strSplitDialog.length; ++i) {
            FontMgr.drawString(0, sG, strSplitDialog[i], 160, n2, 17);
            n2 += n;
        }
        Engine.paintTooltips(sG, 2);
    }

    public static void drawSmallProfessor(Graphics graphics, int n, int n2) {
    }

    public static void drawProfessorDialogTutorial() {
        CrossPix.clipScreen();
        sG.setColor(0xFFFFFF);
        sG.fillRect(dialogLeft, dialogTop, dialogWidth, dialogHeight);
        sG.setColor(0);
        sG.drawRect(dialogLeft, dialogTop, dialogWidth, dialogHeight);
    }

    public static void drawClues(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n / TILE_W;
        int n9 = n2 / TILE_H;
        int n10 = n % TILE_W;
        int n11 = n2 % TILE_H;
        String string = "";
        int n12 = FontMgr.charHeight[4 + zoomSize] + 1;
        int n13 = 4 + zoomSize;
        graphics.setClip(0, VIEWPORT_Y, VIEWPORT_X, VIEWPORT_H);
        if (TutorialFlashColumn != null || TutorialFlashRow != null) {
            CrossPix.gradientTick(7);
        }
        for (n7 = 0; n7 < VIEWPORT_TILE_H + 1; ++n7) {
            string = "";
            n6 = n7 + n9;
            if (n6 <= -1 || n6 >= clueSide.length) continue;
            n5 = VIEWPORT_Y + n7 * TILE_H - n11;
            if ((n7 + n9) % 2 == 0) {
                graphics.setColor(ColorScheme[curCS][CS_GRID_CLUE_1]);
                if (bHideClues) {
                    graphics.setColor(CrossPix.gradientColor(ColorScheme[curCS][CS_GRID_CLUE_1], 0, transitionGradient));
                }
            } else {
                graphics.setColor(ColorScheme[curCS][CS_GRID_CLUE_2]);
                if (bHideClues) {
                    graphics.setColor(CrossPix.gradientColor(ColorScheme[curCS][CS_GRID_CLUE_2], 0, transitionGradient));
                }
            }
            if (CrossPix.drawCursorAndClue() && cursorTileY == n7 + n9) {
                if (bCursorWrong) {
                    graphics.setColor(CS_CROSS);
                } else {
                    graphics.setColor(CS_CURSOR);
                }
            }
            if (TutorialFlashRow != null) {
                for (n4 = 0; n4 < TutorialFlashRow.length; ++n4) {
                    if (TutorialFlashRow[n4] != n7 + n9) continue;
                    graphics.setColor(CrossPix.gradientColor(12008822, 16751285, gradientCounter));
                }
            }
            graphics.fillRect(VIEWPORT_X - clueSideWidth, n5, clueSideWidth, TILE_H);
            graphics.setColor(ColorScheme[curCS][CS_GRID_CLUE_LINE]);
            if (bHideClues) {
                graphics.setColor(CrossPix.gradientColor(ColorScheme[curCS][CS_GRID_CLUE_LINE], 0, transitionGradient));
            }
            graphics.drawLine(VIEWPORT_X - 1, VIEWPORT_Y - 1, VIEWPORT_X - 1, VIEWPORT_Y + TILE_W * gameGridW);
            if (SideDone[n6]) {
                n13 = 14 + zoomSize;
            }
            if (bHideClues || n7 >= gameGridH) continue;
            n4 = 0;
            for (n3 = clueSide[n7].length - 1; n3 > -1; --n3) {
                if (!SideDone[n6]) {
                    n13 = CrossPix.bBitFlag(SideDoneSub[n6], n3) ? 14 + zoomSize : 4 + zoomSize;
                    if (bLevelCleared) {
                        n13 = 4 + zoomSize;
                    }
                }
                if (clueSide[n6][n3] != 0) {
                    string = clueSide[n6][n3] + " ";
                    FontMgr.drawString(n13, graphics, string, VIEWPORT_X - CLUE_SIDE_XOFFSET - (n4 += FontMgr.stringWidth(n13, string)), n5 + (TILE_H - n12 >> 1), 20);
                    continue;
                }
                if (n3 != 0) continue;
                FontMgr.drawString(n13, graphics, "0 ", VIEWPORT_X - CLUE_SIDE_XOFFSET, n5 + (TILE_H - n12 >> 1), 24);
            }
        }
        graphics.setClip(VIEWPORT_X - clueSideWidth, STATUS_BAR_HEIGHT + 0, gameGridW * TILE_W + clueSideWidth, gameGridH * TILE_H + VIEWPORT_Y - STATUS_BAR_HEIGHT - 0);
        block3: for (n7 = 0; n7 < VIEWPORT_TILE_W + 1; ++n7) {
            n6 = n7 + n8;
            if (n6 <= -1 || n6 >= clueTop.length) continue;
            n5 = VIEWPORT_X + n7 * TILE_W - n10;
            if ((n7 + n8) % 2 == 0) {
                graphics.setColor(ColorScheme[curCS][CS_GRID_CLUE_1]);
                if (bHideClues) {
                    graphics.setColor(CrossPix.gradientColor(ColorScheme[curCS][CS_GRID_CLUE_1], 0, transitionGradient));
                }
            } else {
                graphics.setColor(ColorScheme[curCS][CS_GRID_CLUE_2]);
                if (bHideClues) {
                    graphics.setColor(CrossPix.gradientColor(ColorScheme[curCS][CS_GRID_CLUE_2], 0, transitionGradient));
                }
            }
            if (CrossPix.drawCursorAndClue() && cursorTileX == n7 + n8) {
                if (bCursorWrong) {
                    graphics.setColor(CS_CROSS);
                } else {
                    graphics.setColor(CS_CURSOR);
                }
            }
            if (TutorialFlashColumn != null) {
                for (n4 = 0; n4 < TutorialFlashColumn.length; ++n4) {
                    if (TutorialFlashColumn[n4] != n7 + n8) continue;
                    graphics.setColor(CrossPix.gradientColor(12008822, 16751285, gradientCounter));
                }
            }
            graphics.fillRect(n5, 0, TILE_W, VIEWPORT_Y);
            if (!bHideClues) {
                // empty if block
            }
            graphics.setColor(ColorScheme[curCS][CS_GRID_CLUE_LINE]);
            if (bHideClues) {
                graphics.setColor(CrossPix.gradientColor(ColorScheme[curCS][CS_GRID_CLUE_LINE], 0, transitionGradient));
            }
            graphics.drawLine(VIEWPORT_X - 1, VIEWPORT_Y - 1, VIEWPORT_X + TILE_W * gameGridW, VIEWPORT_Y - 1);
            if (TopDone[n6]) {
                n13 = 14 + zoomSize;
            }
            if (bHideClues || n7 >= gameGridW) continue;
            for (n4 = 0; n4 < clueTop[n7].length; ++n4) {
                if (!TopDone[n6]) {
                    n13 = CrossPix.bBitFlag(TopDoneSub[n6], n4) ? 14 + zoomSize : 4 + zoomSize;
                    if (bLevelCleared) {
                        n13 = 4 + zoomSize;
                    }
                }
                n3 = TILE_W - FontMgr.stringWidth(4 + zoomSize, "" + clueTop[n6][n4]) >> 1;
                if (clueTop[n6][n4] == 0) {
                    n3 = TILE_W - FontMgr.stringWidth(4 + zoomSize, "0") >> 1;
                    if (n4 != 0) continue block3;
                    FontMgr.drawString(n13, graphics, "0", n5 + n3, VIEWPORT_Y - n12 - CLUE_TOP_YOFFSET, 20);
                    continue block3;
                }
                FontMgr.drawString(n13, sG, "" + clueTop[n6][n4], n5 + n3, VIEWPORT_Y - n12 - n4 * n12 - CLUE_TOP_YOFFSET, 20);
            }
        }
    }

    public static void drawCluesBuffer() {
        if (TutorialFlashColumn != null || TutorialFlashRow != null) {
            CrossPix.gradientTick(7);
        }
        if (bBufferClueSideRedraw) {
            if (gBuffClueSide != null) {
                CrossPix.drawBufferCluesSide(gBuffClueSide);
            }
            bBufferClueSideRedraw = false;
        }
        if (bBufferClueTopRedraw) {
            if (gBuffClueTop != null) {
                CrossPix.drawBufferCluesTop(gBuffClueTop);
            }
            bBufferClueTopRedraw = false;
        }
        if (TutorialFlashColumn != null) {
            bBufferClueTopRedraw = true;
        }
        if (TutorialFlashRow != null) {
            bBufferClueSideRedraw = true;
        }
    }

    public static void drawBufferCluesSide(Graphics graphics) {
        String string = "";
        int n = FontMgr.charHeight[4 + zoomSize];
        int n2 = 4 + zoomSize;
        for (int i = 0; i < gameGridH + 1; ++i) {
            int n3;
            string = "";
            int n4 = i;
            if (n4 <= -1 || n4 >= clueSide.length) continue;
            int n5 = i * TILE_H;
            if (i % 2 == 0) {
                graphics.setColor(ColorScheme[curCS][CS_GRID_CLUE_1]);
                if (bHideClues) {
                    graphics.setColor(CrossPix.gradientColor(ColorScheme[curCS][CS_GRID_CLUE_1], 0, transitionGradient));
                }
            } else {
                graphics.setColor(ColorScheme[curCS][CS_GRID_CLUE_2]);
                if (bHideClues) {
                    graphics.setColor(CrossPix.gradientColor(ColorScheme[curCS][CS_GRID_CLUE_2], 0, transitionGradient));
                }
            }
            if (CrossPix.drawCursorAndClue() && cursorTileY == i) {
                if (bCursorWrong) {
                    graphics.setColor(CS_CROSS);
                } else {
                    graphics.setColor(CS_CURSOR);
                }
            }
            if (TutorialFlashRow != null) {
                for (n3 = 0; n3 < TutorialFlashRow.length; ++n3) {
                    if (TutorialFlashRow[n3] != i) continue;
                    graphics.setColor(CrossPix.gradientColor(12008822, 16751285, gradientCounter));
                }
            }
            graphics.fillRect(0, n5, clueSideWidth, TILE_H);
            graphics.setColor(ColorScheme[curCS][CS_GRID_CLUE_LINE]);
            if (bHideClues) {
                graphics.setColor(CrossPix.gradientColor(ColorScheme[curCS][CS_GRID_CLUE_LINE], 0, transitionGradient));
            }
            graphics.drawLine(clueSideWidth - 1, 0, clueSideWidth - 1, TILE_W * gameGridW);
            if (SideDone[n4]) {
                n2 = 14 + zoomSize;
            }
            if (bHideClues || i >= gameGridH) continue;
            n3 = 0;
            for (int j = clueSide[i].length - 1; j > -1; --j) {
                if (!SideDone[n4]) {
                    n2 = CrossPix.bBitFlag(SideDoneSub[n4], j) ? 14 + zoomSize : 4 + zoomSize;
                    if (bLevelCleared) {
                        n2 = 4 + zoomSize;
                    }
                }
                if (clueSide[n4][j] != 0) {
                    string = clueSide[n4][j] + " ";
                    FontMgr.drawString(n2, graphics, string, clueSideWidth - CLUE_SIDE_XOFFSET - (n3 += FontMgr.stringWidth(n2, string)), n5 + (TILE_H - n >> 1), 20);
                    continue;
                }
                if (j != 0) continue;
                FontMgr.drawString(n2, graphics, "0 ", clueSideWidth - CLUE_SIDE_XOFFSET, n5 + (TILE_H - n >> 1), 24);
            }
        }
    }

    public static void drawBufferCluesTop(Graphics graphics) {
        int n = FontMgr.charHeight[4 + zoomSize] + 1;
        int n2 = 4 + zoomSize;
        int n3 = imgBuffClueTop.getHeight();
        block0: for (int i = 0; i < gameGridW + 1; ++i) {
            int n4;
            int n5 = i;
            if (n5 <= -1 || n5 >= clueTop.length) continue;
            int n6 = i * TILE_W;
            if (i % 2 == 0) {
                graphics.setColor(ColorScheme[curCS][CS_GRID_CLUE_1]);
                if (bHideClues) {
                    graphics.setColor(CrossPix.gradientColor(ColorScheme[curCS][CS_GRID_CLUE_1], 0, transitionGradient));
                }
            } else {
                graphics.setColor(ColorScheme[curCS][CS_GRID_CLUE_2]);
                if (bHideClues) {
                    graphics.setColor(CrossPix.gradientColor(ColorScheme[curCS][CS_GRID_CLUE_2], 0, transitionGradient));
                }
            }
            if (CrossPix.drawCursorAndClue() && cursorTileX == i) {
                if (bCursorWrong) {
                    graphics.setColor(CS_CROSS);
                } else {
                    graphics.setColor(CS_CURSOR);
                }
            }
            if (TutorialFlashColumn != null) {
                for (n4 = 0; n4 < TutorialFlashColumn.length; ++n4) {
                    if (TutorialFlashColumn[n4] != i) continue;
                    graphics.setColor(CrossPix.gradientColor(12008822, 16751285, gradientCounter));
                }
            }
            graphics.fillRect(n6, 0, TILE_W + 1, n3);
            graphics.setColor(ColorScheme[curCS][CS_GRID_CLUE_LINE]);
            if (bHideClues) {
                graphics.setColor(CrossPix.gradientColor(ColorScheme[curCS][CS_GRID_CLUE_LINE], 0, transitionGradient));
            }
            graphics.drawLine(0, n3 - 1, TILE_W * gameGridW, n3 - 1);
            if (TopDone[n5]) {
                n2 = 14 + zoomSize;
            }
            if (bHideClues || i >= gameGridW) continue;
            for (n4 = 0; n4 < clueTop[i].length; ++n4) {
                if (!TopDone[n5]) {
                    n2 = CrossPix.bBitFlag(TopDoneSub[n5], n4) ? 14 + zoomSize : 4 + zoomSize;
                    if (bLevelCleared) {
                        n2 = 4 + zoomSize;
                    }
                }
                int n7 = TILE_W - FontMgr.stringWidth(4 + zoomSize, "" + clueTop[n5][n4]) >> 1;
                if (clueTop[n5][n4] == 0) {
                    n7 = TILE_W - FontMgr.stringWidth(4 + zoomSize, "0") >> 1;
                    if (n4 != 0) continue block0;
                    FontMgr.drawString(n2, graphics, "0", n6 + n7, n3 - n - CLUE_TOP_YOFFSET, 20);
                    continue block0;
                }
                FontMgr.drawString(n2, graphics, "" + clueTop[n5][n4], n6 + n7, n3 - n - n4 * n - CLUE_TOP_YOFFSET, 20);
            }
        }
    }

    public static void drawGridBuffer(Graphics graphics) {
        int n;
        int n2;
        graphics.setColor(ColorScheme[curCS][CS_GRID_BLANK]);
        graphics.fillRect(0, 0, TILE_W * gameGridW, TILE_H * gameGridH);
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        for (n2 = 0; n2 < gameGridH; ++n2) {
            for (n = 0; n < gameGridW; ++n) {
                int n5 = CrossPix.gameGridID(n, n2);
                n3 = n * TILE_W;
                n4 = n2 * TILE_H;
                switch (n5) {
                    case 1: {
                        if (completeState == 4) break;
                        graphics.drawImage(imgBlocks[TILE_W], n3 + 1, n4 + 1, 20);
                        break;
                    }
                    case 2: {
                        graphics.setColor(CS_CROSS);
                        int n6 = 2;
                        int n7 = n3 + n6;
                        int n8 = n4 + n6;
                        int n9 = n3 + TILE_W - n6;
                        int n10 = n4 + TILE_H - n6;
                        int n11 = n3 + TILE_W - n6;
                        graphics.drawLine(n7, n8, n9, n10);
                        graphics.drawLine(n7 + 1, n8, n9, n10 - 1);
                        graphics.drawLine(n7, n8 + 1, n9 - 1, n10);
                        graphics.drawLine(n11, n8, n7, n10);
                        graphics.drawLine(n11 - 1, n8, n7, n10 - 1);
                        graphics.drawLine(n11, n8 + 1, n7 + 1, n10);
                    }
                }
                graphics.setColor(CS_BLOCK_SEPORATOR);
                graphics.drawLine(n3, 0, n3, 0 + TILE_H * gameGridH);
            }
            graphics.setColor(CS_BLOCK_SEPORATOR);
            graphics.drawLine(0, n4, 0 + TILE_W * gameGridW, n4);
        }
        graphics.setColor(CS_GRID_SEPORATOR);
        for (n2 = 0; n2 < gameGridH + 1; ++n2) {
            for (n = 0; n < gameGridW + 1; ++n) {
                if (n % 5 != 0) continue;
                n3 = n * TILE_W;
                graphics.drawLine(n3, 0, n3, 0 + TILE_H * gameGridH);
            }
            if (n2 % 5 != 0) continue;
            n4 = n2 * TILE_H;
            graphics.drawLine(0, n4, TILE_W * gameGridW, n4);
        }
    }

    public static void drawGrid(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        int n5 = n / TILE_W;
        int n6 = n2 / TILE_H;
        int n7 = n % TILE_W;
        int n8 = n2 % TILE_H;
        graphics.setClip(VIEWPORT_X, VIEWPORT_Y, VIEWPORT_W + 1, VIEWPORT_H + 1);
        if (bLevelCleared) {
            graphics.setClip(VIEWPORT_X, VIEWPORT_Y, TILE_W * gameGridW, TILE_H * gameGridH);
        }
        graphics.setColor(ColorScheme[curCS][CS_GRID_BLANK]);
        graphics.fillRect(VIEWPORT_X, VIEWPORT_Y, TILE_W * gameGridW, TILE_H * gameGridH);
        int n9 = 0;
        int n10 = 0;
        boolean bl = false;
        int n11 = 0;
        int n12 = VIEWPORT_TILE_H + 1;
        if (bLevelCleared) {
            n12 = TILE_H * gameGridH;
        }
        for (n4 = 0; n4 < n12; ++n4) {
            for (n3 = 0; n3 < VIEWPORT_TILE_W + 1; ++n3) {
                n11 = CrossPix.gameGridID(n3 + n5, n4 + n6);
                n9 = VIEWPORT_X + n3 * TILE_W - n7;
                n10 = VIEWPORT_Y + n4 * TILE_H - n8;
                switch (n11) {
                    case 1: {
                        if (completeState == 4) break;
                        graphics.drawImage(imgBlocks[TILE_W], n9 + 1, n10 + 1, 20);
                        break;
                    }
                    case 2: {
                        graphics.setColor(CS_CROSS);
                        int n13 = 2;
                        int n14 = n9 + n13;
                        int n15 = n10 + n13;
                        int n16 = n9 + TILE_W - n13;
                        int n17 = n10 + TILE_H - n13;
                        int n18 = n9 + TILE_W - n13;
                        graphics.drawLine(n14, n15, n16, n17);
                        graphics.drawLine(n14 + 1, n15, n16, n17 - 1);
                        graphics.drawLine(n14, n15 + 1, n16 - 1, n17);
                        graphics.drawLine(n18, n15, n14, n17);
                        graphics.drawLine(n18 - 1, n15, n14, n17 - 1);
                        graphics.drawLine(n18, n15 + 1, n14 + 1, n17);
                    }
                }
                graphics.setColor(CS_BLOCK_SEPORATOR);
                graphics.drawLine(n9, VIEWPORT_Y, n9, VIEWPORT_Y + TILE_H * gameGridH);
            }
            graphics.setColor(CS_BLOCK_SEPORATOR);
            graphics.drawLine(VIEWPORT_X, n10, VIEWPORT_X + TILE_W * gameGridW, n10);
        }
        graphics.setColor(CS_GRID_SEPORATOR);
        for (n4 = 0; n4 < VIEWPORT_TILE_H + 1; ++n4) {
            for (n3 = 0; n3 < VIEWPORT_TILE_W + 1; ++n3) {
                if ((n3 + n5) % 5 != 0) continue;
                n9 = VIEWPORT_X + n3 * TILE_W - n7;
                graphics.drawLine(n9, VIEWPORT_Y, n9, VIEWPORT_Y + TILE_H * gameGridH);
            }
            if ((n4 + n6) % 5 != 0) continue;
            n10 = VIEWPORT_Y + n4 * TILE_H - n8;
            graphics.drawLine(VIEWPORT_X, n10, VIEWPORT_X + TILE_W * gameGridW, n10);
        }
    }

    private static boolean drawCursorAndClue() {
        if (bLevelCleared) {
            return false;
        }
        return !bTutorial || TutorialState != 0 && TutorialState != 1 && TutorialState != 2 && TutorialState != 3 && TutorialState != 5 && TutorialState != 7 && TutorialState != 8 && TutorialState != 10 && TutorialState != 11 && TutorialState != 13;
    }

    private static void drawCursor() {
        if (AnimateHintState != 0 || !CrossPix.drawCursorAndClue()) {
            return;
        }
        int n = VIEWPORT_X + cursorX - mapMX - TILE_W / 5;
        int n2 = VIEWPORT_Y + cursorY - mapMY - TILE_H / 5;
        int n3 = TILE_W / 5;
        int n4 = 2;
        if (n3 == 1) {
            n4 = 1;
        }
        int n5 = TILE_W + TILE_W / 5 * 2;
        int n6 = TILE_H + TILE_H / 5 * 2;
        sG.setColor(CS_CURSOR_SHADOW);
        sG.fillRect(n4 + n, n4 + n2, n3, n6);
        sG.fillRect(n4 + n + n5 - n3, n4 + n2, n3, n6);
        sG.fillRect(n4 + n + n3, n4 + n2, n5 - (n3 << 1), n3);
        sG.fillRect(n4 + n + n3, n4 + n2 + n6 - n3, n5 - (n3 << 1), n3);
        sG.setColor(CS_CURSOR);
        sG.fillRect(n, n2, n3, n6);
        sG.fillRect(n + n5 - n3, n2, n3, n6);
        sG.fillRect(n + n3, n2, n5 - (n3 << 1), n3);
        sG.fillRect(n + n3, n2 + n6 - n3, n5 - (n3 << 1), n3);
    }

    public static boolean IgnoreTutorialStates() {
        return bTutorial && TutorialState != 4 && TutorialState != 6 && TutorialState != 12;
    }

    private static void drawBlockTip() {
        if (curState == 6 || curState == 7 || bLevelCleared || CrossPix.IgnoreTutorialStates()) {
            return;
        }
        int n = DEVICE_WIDTH - Engine.imgTips[0].width - 1;
        int n2 = DEVICE_HEIGHT - Engine.imgTips[0].height;
        int n3 = n = Engine.reverseTooltips ? n : 1;
        if (curState == 5) {
            Engine.paintTooltips(sG, 2);
        } else {
            Engine.paintTooltips(sG, 36);
        }
    }

    private static int gameGridID(int n, int n2) {
        if (n < 0 || n2 < 0 || n > gameGridW - 1 || n2 > gameGridH - 1) {
            return -1;
        }
        return gameGrid[n][n2];
    }

    private static int solutionGridID(int n, int n2) {
        if (n < 0 || n2 < 0 || n > gameGridW - 1 || n2 > gameGridH - 1) {
            return -1;
        }
        return solutionGrid[n][n2];
    }

    private static void changeGameGridID(int n, int n2, int n3) {
        CrossPix.gameGrid[n][n2] = n3;
        bBufferGridRedraw = true;
    }

    private static int[][] genClueTop() {
        int n;
        int[][] nArrayArray = new int[solutionGrid.length][];
        for (n = 0; n < solutionGrid.length; ++n) {
            nArrayArray[n] = new int[solutionGrid.length / 2 + 1];
        }
        for (n = 0; n < solutionGrid.length + 1; ++n) {
            int n2 = 0;
            int n3 = 0;
            for (int i = solutionGrid[0].length - 1; i > -2; --i) {
                if (CrossPix.solutionGridID(n, i) == 1) {
                    ++n2;
                    continue;
                }
                if (CrossPix.solutionGridID(n, i + 1) != 1) continue;
                nArrayArray[n][n3] = n2;
                n2 = 0;
                ++n3;
            }
        }
        return nArrayArray;
    }

    private static int[][] genClueSide() {
        int n;
        int[][] nArrayArray = new int[solutionGrid.length][];
        for (n = 0; n < solutionGrid.length; ++n) {
            nArrayArray[n] = new int[solutionGrid.length / 2 + 1];
        }
        for (n = 0; n < solutionGrid[0].length + 1; ++n) {
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < solutionGrid.length + 1; ++i) {
                if (CrossPix.solutionGridID(i, n) == 1) {
                    ++n2;
                    continue;
                }
                if (CrossPix.solutionGridID(i - 1, n) != 1) continue;
                nArrayArray[n][n3] = n2;
                n2 = 0;
                ++n3;
            }
        }
        return nArrayArray;
    }

    private static int getClueTopHeight() {
        int n = 0;
        int n2 = FontMgr.charHeight[4 + zoomSize] + 1;
        for (int i = 0; i < clueTop.length - 1; ++i) {
            for (int j = 0; j < clueTop[i].length && clueTop[i][j] != 0; ++j) {
                if (n2 * (j + 1) <= n) continue;
                n = n2 * (j + 1);
            }
        }
        return n;
    }

    private static int getClueSideWidth() {
        int n = 0;
        for (int i = 0; i < clueSide.length - 1; ++i) {
            String string = "";
            for (int j = 0; j < clueSide[i].length; ++j) {
                if (clueSide[i][j] == 0) {
                    if (j != 0) break;
                    string = "0 ";
                    break;
                }
                string = string + clueSide[i][j] + " ";
            }
            if (FontMgr.stringWidth(4 + zoomSize, string) <= n) continue;
            n = FontMgr.stringWidth(4 + zoomSize, string);
        }
        return n;
    }

    private static boolean bLineComplete(int n, boolean bl) {
        for (int i = 0; i < (bl ? gameGridH : gameGridW); ++i) {
            if (!(bl ? solutionGrid[n][i] == 1 && gameGrid[n][i] != solutionGrid[n][i] : solutionGrid[i][n] == 1 && gameGrid[i][n] != solutionGrid[i][n])) continue;
            return false;
        }
        return true;
    }

    private static boolean bPuzzleComplete() {
        for (int i = 0; i < gameGridW; ++i) {
            for (int j = 0; j < gameGridH; ++j) {
                if (solutionGrid[i][j] != 1 || gameGrid[i][j] == solutionGrid[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public static void Restart() {
        if (Engine.EditorMode == 1) {
            Engine.bEditorPuzzleExist = true;
        }
        CrossPix.LoadPuzzle(curPuzzleResID);
    }

    public static boolean bIgnoreInput() {
        return bDialog || bNextTutorialState || bLevelCleared || bLevelFailed || completeState != 0;
    }

    private static void keyGameGrid() {
        if (CrossPix.bIgnoreInput()) {
            return;
        }
        int n = TILE_W;
        if (!bMarkBlockStop && Engine.isPressed(16448)) {
            CrossPix.placeBlock(cursorTileX, cursorTileY, false);
        }
        if (cursorWrongCounter < 5) {
            ++cursorWrongCounter;
            bCursorWrong = true;
        } else {
            bCursorWrong = false;
        }
        if (bMarkBlockStop && !Engine.isPressed(16448)) {
            bMarkBlockStop = false;
        }
        if (Engine.isPressed(16)) {
            if (Engine.EditorMode != 2) {
                if (markState == MARK_IDLE) {
                    if (CrossPix.gameGridID(cursorTileX, cursorTileY) == 0) {
                        markState = MARK_CROSS;
                    }
                    if (CrossPix.gameGridID(cursorTileX, cursorTileY) == 2) {
                        markState = MARK_BLANK;
                    }
                } else {
                    CrossPix.placeCross();
                }
            } else {
                Engine.bEditorSaveChanges = true;
                CrossPix.changeGameGridID(cursorTileX, cursorTileY, 0);
                CrossPix.drawSmallScreen(false);
            }
        }
        if (!Engine.isPressed(16)) {
            markState = MARK_IDLE;
        }
        if (!bMarkBlockStop) {
            if (Engine.key(4) || Engine.isPressedDelay(4)) {
                if (cursorX > 0) {
                    cursorX -= n;
                }
                bBufferClueTopRedraw = true;
            } else if (Engine.key(8) || Engine.isPressedDelay(8)) {
                if (cursorX < (gameGridW - 1) * TILE_W) {
                    cursorX += n;
                }
                bBufferClueTopRedraw = true;
            } else if (Engine.key(1) || Engine.isPressedDelay(1)) {
                if (cursorY > 0) {
                    cursorY -= n;
                }
                bBufferClueSideRedraw = true;
            } else if (Engine.key(2) || Engine.isPressedDelay(2)) {
                if (cursorY < (gameGridH - 1) * TILE_H) {
                    cursorY += n;
                }
                bBufferClueSideRedraw = true;
            } else if (Engine.key(256) || Engine.isPressedDelay(256)) {
                if (cursorX > 0) {
                    cursorX -= n;
                }
                if (cursorY > 0) {
                    cursorY -= n;
                }
                bBufferClueSideRedraw = true;
                bBufferClueTopRedraw = true;
            } else if (Engine.key(512) || Engine.isPressedDelay(512)) {
                if (cursorX < (gameGridW - 1) * TILE_W) {
                    cursorX += n;
                }
                if (cursorY > 0) {
                    cursorY -= n;
                }
                bBufferClueSideRedraw = true;
                bBufferClueTopRedraw = true;
            } else if (Engine.key(1024) || Engine.isPressedDelay(1024)) {
                if (cursorX > 0) {
                    cursorX -= n;
                }
                if (cursorY < (gameGridH - 1) * TILE_H) {
                    cursorY += n;
                }
                bBufferClueSideRedraw = true;
                bBufferClueTopRedraw = true;
            } else if (Engine.key(2048) || Engine.isPressedDelay(2048)) {
                if (cursorX < (gameGridW - 1) * TILE_W) {
                    cursorX += n;
                }
                if (cursorY < (gameGridH - 1) * TILE_H) {
                    cursorY += n;
                }
                bBufferClueSideRedraw = true;
                bBufferClueTopRedraw = true;
            }
        }
    }

    public static void placeBlock(int n, int n2, boolean bl) {
        Engine.touchGameMode = 0;
        cursorTileX = n;
        cursorTileY = n2;
        Engine.bEditorSaveChanges = true;
        if (CrossPix.gameGridID(cursorTileX, cursorTileY) == 0) {
            if (solutionGrid[cursorTileX][cursorTileY] == 1) {
                CrossPix.changeGameGridID(cursorTileX, cursorTileY, 1);
                if (CrossPix.bLineComplete(cursorTileX, true)) {
                    CrossPix.TopDone[CrossPix.cursorTileX] = true;
                    bBufferClueTopRedraw = true;
                }
                if (CrossPix.bLineComplete(cursorTileY, false)) {
                    CrossPix.SideDone[CrossPix.cursorTileY] = true;
                    bBufferClueSideRedraw = true;
                }
                CrossPix.drawSmallScreen(false);
                if (!bTutorial && CrossPix.bPuzzleComplete() && Engine.EditorMode != 2) {
                    completeState = 1;
                    bLevelCleared = true;
                }
                Engine.vAnim[Engine.freeAnimIndex()].setAnimation(cursorTileX, cursorTileY, (byte)1, 10, 2);
            } else {
                Engine.vAnim[Engine.freeAnimIndex()].setAnimation(cursorTileX, cursorTileY, (byte)0, TILE_W, TILE_W / 5);
                CrossPix.changeGameGridID(cursorTileX, cursorTileY, 2);
                Device.vibrate(500);
                bMarkBlockStop = true;
                cursorWrongCounter = 0;
                if (bTutorial) {
                    bTutorialWrong = true;
                } else {
                    ++curMistakes;
                    if (--gameLives < 1) {
                        gameLives = 0;
                        bLevelFailed = true;
                    }
                }
            }
            CrossPix.greyOutCheck();
        }
    }

    public static void placeCross(int n, int n2, boolean bl) {
        cursorTileX = n;
        cursorTileY = n2;
        if (Engine.EditorMode != 2) {
            if (bl) {
                if (CrossPix.gameGridID(cursorTileX, cursorTileY) == 0) {
                    markState = MARK_CROSS;
                    CrossPix.placeCross();
                } else if (CrossPix.gameGridID(cursorTileX, cursorTileY) == 2) {
                    markState = MARK_BLANK;
                    CrossPix.placeCross();
                }
            } else {
                CrossPix.placeCross();
            }
        } else {
            Engine.bEditorSaveChanges = true;
            CrossPix.changeGameGridID(cursorTileX, cursorTileY, 0);
            CrossPix.drawSmallScreen(false);
        }
    }

    private static void placeCross() {
        Engine.touchGameMode = 1;
        if (CrossPix.gameGridID(cursorTileX, cursorTileY) != 1) {
            if (markState == MARK_CROSS) {
                CrossPix.changeGameGridID(cursorTileX, cursorTileY, 2);
                if (cursorTileX != markCrossX || cursorTileY != markCrossY) {
                    Engine.vAnim[Engine.freeAnimIndex()].setAnimation(cursorTileX, cursorTileY, (byte)4, 10, 2);
                    markCrossX = cursorTileX;
                    markCrossY = cursorTileY;
                }
            }
            if (markState == MARK_BLANK) {
                CrossPix.changeGameGridID(cursorTileX, cursorTileY, 0);
            }
            CrossPix.greyOutCheck();
        }
    }

    private static void drawTopBar() {
    }

    public static void drawStatusBar() {
        String string = "";
        String string2 = "";
        if (Engine.EditorMode != 2) {
            if (bTutorial || curState == 7 || curState == 6 || GameWorld.state == 4) {
                string = Engine.text[312] + " " + "0:00:00";
                string = string + " - " + Engine.text[313] + " " + gameLives;
            } else if (!bLevelCleared && !bLevelFailed) {
                if (GameWorld.state == 1) {
                    long l = System.currentTimeMillis() - startTime;
                    string = Engine.text[312] + " " + CrossPix.milliSecsToString(l, true, true);
                    string = string + " - " + Engine.text[313] + " " + gameLives;
                } else {
                    string = Engine.text[312] + " " + "0:00:00";
                    string = string + " - " + Engine.text[313] + " " + gameLives;
                }
            }
            FontMgr.drawString(0, sG, string, 160, GameWorld.roundIndicatorY + 8, 3);
        }
    }

    public static String FormatTime(int n, int n2, int n3) {
        String string = n3 < 10 ? "0" + n3 : "" + n3;
        String string2 = n2 < 10 ? "0" + n2 : "" + n2;
        return n + ":" + string2 + ":" + string;
    }

    public static String milliSecsToString(long l, boolean bl, boolean bl2) {
        int n = (int)((l /= 1000L) / 3600L);
        int n2 = (int)(l % 3600L / 60L);
        int n3 = (int)(l % 3600L % 60L);
        return CrossPix.FormatTime(n, n2, n3);
    }

    private static void setSmallScreen(int n, int n2, int n3) {
        smallScreenScale = n3;
        imgSmallScreen = Image.createImage((int)(n * smallScreenScale), (int)(n2 * smallScreenScale));
        gSmallScreen = imgSmallScreen.getGraphics();
        gSmallScreen.setColor(ColorScheme[curCS][CS_SMALLSCREEN_BG]);
        gSmallScreen.fillRect(0, 0, n * smallScreenScale, n2 * smallScreenScale);
    }

    public static void drawSmallScreen(boolean bl) {
        gSmallScreen.setColor(ColorScheme[curCS][CS_SMALLSCREEN_BG]);
        gSmallScreen.fillRect(0, 0, smallScreenScale * gameGridW, smallScreenScale * gameGridH);
        gSmallScreen.setColor(ColorScheme[curCS][CS_SMALLSCREEN_FG]);
        for (int i = 0; i < gameGridW; ++i) {
            for (int j = 0; j < gameGridH; ++j) {
                if (bl) {
                    gSmallScreen.setColor(65280);
                    if (CrossPix.solutionGridID(i, j) != 1) continue;
                    gSmallScreen.fillRect(i * smallScreenScale, j * smallScreenScale, smallScreenScale, smallScreenScale);
                    continue;
                }
                if (CrossPix.gameGridID(i, j) != 1) continue;
                gSmallScreen.fillRect(i * smallScreenScale, j * smallScreenScale, smallScreenScale, smallScreenScale);
            }
        }
    }

    private static void setMonoScaled(int n, int n2, int n3) {
        imgScaled = Image.createImage((int)(gameGridW * n3), (int)(gameGridH * n3));
        gScaled = imgScaled.getGraphics();
        gScaled.setColor(n2);
        gScaled.fillRect(0, 0, gameGridW * n3, gameGridH * n3);
        for (int i = 0; i < gameGridW; ++i) {
            for (int j = 0; j < gameGridH; ++j) {
                gScaled.setColor(n);
                if (CrossPix.solutionGridID(i, j) != 1) continue;
                gScaled.fillRect(i * n3, j * n3, n3, n3);
            }
        }
    }

    public static Image DeviceImageToImage(DeviceImage deviceImage, int n) {
        Image image = Image.createImage((int)deviceImage.width, (int)deviceImage.height);
        Graphics graphics = image.getGraphics();
        graphics.setColor(n);
        graphics.fillRect(0, 0, deviceImage.width, deviceImage.height);
        deviceImage.drawImage(graphics, 0, 0);
        return image;
    }

    public static Image scaleImage(DeviceImage deviceImage, int n, int n2, int n3) {
        Image image = CrossPix.DeviceImageToImage(deviceImage, n3);
        int n4 = image.getWidth();
        int n5 = image.getHeight();
        Image image2 = Image.createImage((int)n, (int)n5);
        Graphics graphics = image2.getGraphics();
        int n6 = (n4 << 16) / n;
        int n7 = n6 / 2;
        for (int i = 0; i < n; ++i) {
            graphics.setClip(i, 0, 1, n5);
            graphics.drawImage(image, i - (n7 >> 16), 0, 20);
            n7 += n6;
        }
        Image image3 = Image.createImage((int)n, (int)n2);
        graphics = image3.getGraphics();
        n6 = (n5 << 16) / n2;
        n7 = n6 / 2;
        for (int i = 0; i < n2; ++i) {
            graphics.setClip(0, i, n, 1);
            graphics.drawImage(image2, 0, i - (n7 >> 16), 20);
            n7 += n6;
        }
        return image3;
    }

    public static void ScaleThumb(int n, int n2) {
        if (imgColoured != null) {
            imgScaleThumb = new Image[10];
            int n3 = CrossPix.imgColoured[n].width;
            for (int i = 0; i < 10; ++i) {
                CrossPix.imgScaleThumb[i] = CrossPix.scaleImage(imgColoured[n + i], n3 * n2, n3 * n2, frameBGColor[curTheme]);
            }
        }
    }

    private static void setColourScaled(DeviceImage deviceImage, int n) {
        if (Engine.EditorMode == 1) {
            CrossPix.setMonoScaled(0x404040, frameBGColor[curTheme], n);
        } else {
            imgScaled = CrossPix.scaleImage(deviceImage, gameGridW * n, gameGridH * n, 0xFFFFFF);
        }
    }

    public static void gradientTick(int n) {
        if (gradientCounter > 100) {
            gradientCounterDir = -1;
        }
        if (gradientCounter < 0) {
            gradientCounterDir = 1;
        }
        gradientCounter += n * gradientCounterDir;
    }

    public static int gradientColor(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n >> 16 & 0xFF;
        int n8 = n >> 8 & 0xFF;
        int n9 = n & 0xFF;
        int n10 = n2 >> 16 & 0xFF;
        int n11 = n2 >> 8 & 0xFF;
        int n12 = n2 & 0xFF;
        if (n3 >= 100) {
            n6 = n10;
            n5 = n11;
            n4 = n12;
        } else if (n3 <= 0) {
            n6 = n7;
            n5 = n8;
            n4 = n9;
        } else {
            n6 = n7 + (n10 - n7) * 10 / (1000 / n3);
            n5 = n8 + (n11 - n8) * 10 / (1000 / n3);
            n4 = n9 + (n12 - n9) * 10 / (1000 / n3);
        }
        return n6 << 16 | n5 << 8 | n4;
    }

    public static boolean bBitFlag(int n, int n2) {
        return (n & 2 << n2) == 2 << n2;
    }

    public static void saveCurrentGame() {
    }

    public static void loadCurrentGame() {
        curTheme = saveGameTheme;
        curThemePuzzle = saveGamePuzzle;
        if (curTheme == 17) {
            Engine.EditorMode = 1;
            bLoadSavedEditorGame = true;
            Engine.bEditorPuzzleExist = true;
            CrossPix.LoadEditorPuzzle((byte)curThemePuzzle);
        }
        CrossPix.MenuLoadPuzzle(curTheme, curThemePuzzle);
        if (curTheme == 17) {
            bLoadSavedEditorGame = false;
            Engine.bEditorPuzzleExist = false;
        }
        gameLives = saveGameLives;
        startTime = System.currentTimeMillis() - saveGameTime;
        for (int i = 0; i < gameGridH; ++i) {
            for (int j = 0; j < gameGridW; ++j) {
                CrossPix.gameGrid[j][i] = 0;
                if (CrossPix.bBitFlag(saveGameBFBlock[i], j)) {
                    CrossPix.gameGrid[j][i] = 1;
                }
                if (!CrossPix.bBitFlag(saveGameBFCross[i], j)) continue;
                CrossPix.gameGrid[j][i] = 2;
            }
        }
        CrossPix.drawSmallScreen(false);
        bSaveGame = false;
        bSaveGame = true;
        CrossPix.greyOutGridCheck();
    }

    public static void LoadEditorPuzzle(byte by) {
        CrossPix.MenuLoadPuzzle(17, by);
        if (Engine.EditorMode == 2) {
            CrossPix.drawSmallScreen(false);
        }
        Engine.state = 100;
    }

    public static void ClearGrid() {
        for (int i = 0; i < gameGridH; ++i) {
            for (int j = 0; j < gameGridW; ++j) {
                CrossPix.solutionGrid[j][i] = 1;
                CrossPix.gameGrid[j][i] = 0;
            }
        }
        Engine.EditorMode = (byte)2;
    }

    public static void SaveEditorPuzzle(byte by) {
    }

    private static void greyOutCheck() {
        if (Engine.EditorMode == 2) {
            return;
        }
        CrossPix.greyOutCheckSide(cursorTileY);
        CrossPix.greyOutCheckTop(cursorTileX);
    }

    private static void greyOutGridCheck() {
        if (Engine.EditorMode == 2) {
            return;
        }
        for (int i = 0; i < gameGridW; ++i) {
            CrossPix.greyOutCheckSide(i);
            CrossPix.greyOutCheckTop(i);
        }
    }

    private static void greyOutCheckSide(int n) {
        int n2;
        int n3;
        if (SideDone[n]) {
            return;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        byte by = SideDoneSub[n];
        CrossPix.SideDoneSub[n] = 0;
        for (n3 = 0; n3 < gameGridW && gameGrid[n3][n] != 0; ++n3) {
            ++n4;
        }
        if (n4 > 0) {
            for (n2 = n3 = --n4; n2 > -1 && gameGrid[n2][n] == 1 && gameGrid[n2 + (n2 != gameGridW - 1 ? 1 : 0)][n] == 2; --n2) {
                --n4;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (gameGrid[n3][n] == 1) {
                ++n5;
            }
            if (n5 != clueSide[n][n6] || n5 != clueSide[n][n6]) continue;
            if (n3 + 1 < gameGridW) {
                if (gameGrid[n3 + 1][n] != 2) continue;
                int n7 = n;
                SideDoneSub[n7] = (byte)(SideDoneSub[n7] | 2 << n6);
                ++n6;
                n5 = 0;
                continue;
            }
            int n8 = n;
            SideDoneSub[n8] = (byte)(SideDoneSub[n8] | 2 << n6);
            ++n6;
            n5 = 0;
        }
        if (CrossPix.bLineComplete(n, false)) {
            CrossPix.SideDone[n] = true;
        }
        if (!SideDone[n]) {
            n4 = 0;
            n5 = 0;
            n6 = 0;
            for (n3 = 0; n3 < gameGridW && gameGrid[gameGridW - 1 - n3][n] != 0; ++n3) {
                ++n4;
            }
            if (n4 > 0) {
                for (n2 = n3 = --n4; n2 > -1 && gameGrid[gameGridW - 1 - n2][n] == 1 && gameGrid[gameGridW - 1 - n2 - (gameGridW - 1 - n2 != 0 ? 1 : 0)][n] == 2; --n2) {
                    --n4;
                }
            }
            n6 = CrossPix.clueLength(clueSide[n]) - 1;
            for (n3 = 0; n3 < n4; ++n3) {
                if (gameGrid[gameGridW - 1 - n3][n] == 1) {
                    ++n5;
                }
                if (n5 != clueSide[n][n6]) continue;
                int n9 = n;
                SideDoneSub[n9] = (byte)(SideDoneSub[n9] | 2 << n6);
                --n6;
                n5 = 0;
            }
        }
        if (SideDoneSub[n] == (2 << (n3 = CrossPix.clueLength(clueSide[n]))) - 2 && !CrossPix.bLineComplete(n, false)) {
            CrossPix.SideDoneSub[n] = 0;
        }
        n5 = 0;
        for (n2 = 0; n2 < gameGridW; ++n2) {
            if (gameGrid[n2][n] == 0) continue;
            ++n5;
        }
        if (n5 == gameGridW) {
            CrossPix.SideDoneSub[n] = 0;
        }
        if (SideDoneSub[n] != by) {
            bBufferClueSideRedraw = true;
        }
    }

    private static void greyOutCheckTop(int n) {
        int n2;
        int n3;
        if (TopDone[n]) {
            return;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = CrossPix.clueLength(clueTop[n]) - 1;
        byte by = TopDoneSub[n];
        CrossPix.TopDoneSub[n] = 0;
        for (n3 = 0; n3 < gameGridH && gameGrid[n][n3] != 0; ++n3) {
            ++n4;
        }
        if (n4 > 0) {
            for (n2 = n3 = --n4; n2 > -1 && gameGrid[n][n2] == 1 && gameGrid[n][n2 + (n2 != gameGridH - 1 ? 1 : 0)] == 2; --n2) {
                --n4;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (gameGrid[n][n3] == 1) {
                ++n5;
            }
            if (n5 != clueTop[n][n7 - n6]) continue;
            if (n3 + 1 < gameGridH) {
                if (gameGrid[n][n3 + 1] != 2) continue;
                int n8 = n;
                TopDoneSub[n8] = (byte)(TopDoneSub[n8] | 2 << n7 - n6);
                ++n6;
                n5 = 0;
                continue;
            }
            int n9 = n;
            TopDoneSub[n9] = (byte)(TopDoneSub[n9] | 2 << n7 - n6);
            ++n6;
            n5 = 0;
        }
        if (CrossPix.bLineComplete(n, true)) {
            CrossPix.TopDone[n] = true;
        }
        if (!TopDone[n]) {
            n4 = 0;
            n5 = 0;
            n6 = 0;
            for (n3 = 0; n3 < gameGridH && gameGrid[n][gameGridH - 1 - n3] != 0; ++n3) {
                ++n4;
            }
            if (n4 > 0) {
                for (n2 = n3 = --n4; n2 > -1 && gameGrid[n][gameGridH - 1 - n2] == 1 && gameGrid[n][gameGridH - 1 - n2 - (gameGridH - 1 - n2 != 0 ? 1 : 0)] == 2; --n2) {
                    --n4;
                }
            }
            for (n3 = 0; n3 < n4; ++n3) {
                if (gameGrid[n][gameGridH - 1 - n3] == 1) {
                    ++n5;
                }
                if (n5 != clueTop[n][n6]) continue;
                int n10 = n;
                TopDoneSub[n10] = (byte)(TopDoneSub[n10] | 2 << n6);
                ++n6;
                n5 = 0;
            }
        }
        if (TopDoneSub[n] == (2 << (n7 = CrossPix.clueLength(clueTop[n]))) - 2 && !CrossPix.bLineComplete(n, true)) {
            CrossPix.TopDoneSub[n] = 0;
        }
        n5 = 0;
        for (n3 = 0; n3 < gameGridH; ++n3) {
            if (gameGrid[n][n3] == 0) continue;
            ++n5;
        }
        if (n5 == gameGridH) {
            CrossPix.TopDoneSub[n] = 0;
        }
        if (TopDoneSub[n] != by) {
            bBufferClueTopRedraw = true;
        }
    }

    private static int clueLength(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) {
                return n;
            }
            ++n;
        }
        return n;
    }

    private static void debug(String string) {
        System.out.println("debug> " + string);
    }

    public static boolean bGridBlank() {
        for (int i = 0; i < gameGridH; ++i) {
            for (int j = 0; j < gameGridW; ++j) {
                if (gameGrid[j][i] == 0) continue;
                return false;
            }
        }
        return true;
    }

    static {
        puzzleIndex = 0;
        TutorialState = 0;
        prevTutorialState = 0;
        bTutorial = false;
        bTutorialWrong = false;
        bNextTutorialState = false;
        TutorialFlashRippleCount = 0;
        TutorialFlashRippleTime = 0L;
        completeState = 0;
        transitionGradient = 0;
        transitionY = 0;
        transitionX = 0;
        bHideClues = false;
        bLevelCleared = false;
        bLevelFailed = false;
        strMenuTheme = "";
        bBufferGridRedraw = true;
        bBufferClueSideRedraw = true;
        bBufferClueTopRedraw = true;
        curState = 0;
        TILE_W = 0;
        TILE_H = 0;
        MAX_TILE_W = 0;
        MIN_TILE_W = 0;
        TILE_MIN_MAX = DeviceConstants.TILE_MIN_MAX;
        SMALLSCREEN_SCALE = DeviceConstants.SMALLSCREEN_SCALE;
        ZOOMOUT_SCALE = DeviceConstants.ZOOMOUT_SCALE;
        VIEWPORT_X = 0;
        VIEWPORT_Y = 0;
        VIEWPORT_W = 180;
        VIEWPORT_H = 180;
        cursorX = 0;
        cursorY = 0;
        cursorTileX = 0;
        cursorTileY = 0;
        mapMY = 0;
        scrollSpeed = 2;
        clueSideWidth = 0;
        bInGame = false;
        gameLives = 0;
        curPuzzleResID = 0;
        curPuzzleGroup = -1;
        curTheme = -1;
        prevTheme = -2;
        curThemePuzzle = 0;
        puzzleStructure = new int[]{2, 0, 1, 0, 0, 0, 1, 1, 3, 0, 0, 1, 0, 2, 0, 3, 3, 1, 0, 4, 0, 5, 0, 6, 3, 2, 0, 7, 0, 8, 0, 9, 3, 3, 0, 10};
        PUZZLE_GAME_IDS = new int[]{0, 1, 2, 3, 5, 6, 7, 9, 10, 11, 13, 14, 15};
        SUPER_PUZZLE_GAME_IDS = new int[]{4, 8, 12, 16};
        puzzleMidiStructure = new int[]{2, 2, 2, 3, 3, 3, 3, 3, 4, 3, 3, 4, 4, 4, 4, 4, 4, 2};
        gfxMenuX = 0;
        gfxMenuY = 0;
        dialogTop = 0;
        dialogLeft = 0;
        dialogWidth = 0;
        dialogHeight = 0;
        bDialog = false;
        proffExpression = 0;
        proffExpressionStartTime = 0L;
        CLUE_TOP_YOFFSET = 2;
        CLUE_SIDE_XOFFSET = 1;
        MARK_IDLE = 0;
        MARK_BLOCK = 1;
        MARK_CROSS = 2;
        MARK_BLANK = 3;
        MARK_STOP = 4;
        markState = MARK_IDLE;
        cursorWrongCounter = 5;
        bCursorWrong = false;
        bMarkBlockStop = false;
        zoomDir = 1;
        TILE_ZOOM = TILE_W;
        zoomSize = 0;
        markCrossX = -1;
        markCrossY = -1;
        STATUS_BAR_HEIGHT = 0;
        STATUS_BAR_GAP = 0;
        gradientCounter = 0;
        gradientCounterDir = 1;
        statPuzzlePlayed = 0;
        statPuzzleCompleted = 0;
        statPuzzleFailed = 0;
        statMistakes = 0;
        curMistakes = 0;
        statCompletionTime = 0L;
        completion = 0;
        bfPuzzleComplete = new short[puzzleStructure.length / 2];
        bfPuzzleBestTime = new int[puzzleStructure.length / 2 * 10];
        bfPuzzleBestLives = new int[puzzleStructure.length / 2 * 10];
        AnimateHintState = 0;
        curCS = 0;
        CS_GRID_SEPORATOR = 0;
        CS_BLOCK_SEPORATOR = 0xC7C7C7;
        CS_CURSOR = 0xFFFF00;
        CS_CURSOR_SHADOW = 0;
        CS_CROSS = 0xFF0000;
        CS_GRID_CLUE_1 = 0;
        CS_GRID_CLUE_2 = 1;
        CS_GRID_CLUE_LINE = 2;
        CS_SMALLSCREEN_BG = 3;
        CS_SMALLSCREEN_FG = 4;
        CS_GRADIENT_1 = 5;
        CS_GRADIENT_2 = 6;
        CS_GRID_BLOCK = 7;
        CS_GRID_BLANK = 8;
        ColorScheme = new int[][]{{8502229, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 8502229, 9850463, 8861529, 3045888, 0xFFFFFF}, {12910502, 0xFFFFFF, 5555355, 5555355, 2577415, 5555355, 2792596, 2577415, 0xFFFFFF}, {16757983, 0xFFFFFF, 0xDD6AAD, 15749761, 7671652, 16740800, 15749761, 7671652, 0xFFFFFF}, {0xB7FFFB, 0xFFFFFF, 218826, 5495534, 218826, 5495534, 689873, 218826, 0xFFFFFF}, {15719167, 0xFFFFFF, 12288486, 12288486, 0x6E366E, 12288486, 9854145, 0x6E366E, 0xFFFFFF}, {15197890, 0xFFFFFF, 8815969, 12159832, 7356745, 12171412, 8815969, 7356745, 0xFFFFFF}, {14804629, 0xFFFFFF, 8101698, 12174948, 23387, 12174948, 8101698, 23387, 0xFFFFFF}, {11727359, 0xFFFFFF, 161986, 11727359, 16729495, 8901631, 7059711, 16729495, 0xFFFFFF}, {0xD6D6D6, 0xFFFFFF, 0x424242, 0xADADAD, 0, 0xADADAD, 0x737373, 0x808080, 0xFFFFFF}};
        CS_VEHICLE_FASTFOOD = 0;
        CS_COUNTRIES_SUPER_1 = 1;
        CS_FRUIT_BIRD = 2;
        CS_SEA_SUPER_3 = 3;
        CS_ANIMAL_SUPER_2 = 4;
        CS_SCHOOL_SUPER_4 = 5;
        CS_SPORTS_CLOTHES = 6;
        CS_TUTORIAL_SHAPES = 7;
        CS_TOOLS_MUSIC = 8;
        CSMapping = new int[]{CS_TUTORIAL_SHAPES, CS_SPORTS_CLOTHES, CS_SPORTS_CLOTHES, CS_ANIMAL_SUPER_2, CS_ANIMAL_SUPER_2, CS_FRUIT_BIRD, CS_VEHICLE_FASTFOOD, CS_FRUIT_BIRD, CS_COUNTRIES_SUPER_1, CS_COUNTRIES_SUPER_1, CS_SCHOOL_SUPER_4, CS_VEHICLE_FASTFOOD, CS_SEA_SUPER_3, CS_SEA_SUPER_3, CS_TOOLS_MUSIC, CS_TOOLS_MUSIC, CS_SCHOOL_SUPER_4, CS_SCHOOL_SUPER_4};
        frameBGColor = new int[]{0x9E9E9E, 8176212, 16553591, 8476346, 0xFFFF99, 3581415, 0x44CC77, 0xFFFFFF, 0xFFFF99, 7570856, 5941325, 4437996, 0xFFFF99, 1597622, 7570856, 12809727, 0xFFFF99, 0xFFFF99};
        bSaveGame = false;
        saveGameTime = 0L;
        saveGameLives = 0;
        saveGameTheme = 0;
        saveGamePuzzle = 0;
        bLoadSavedEditorGame = false;
    }
}

