/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameWorld
implements Constants {
    public static final int SUDOKU_CONTROL_MODE_NOJOYPAD = 2;
    public static final int SUDOKU_CONTROL_MODE_JOYPAD = 1;
    public static int SUDOKU_CONTROL_MODE = 1;
    public static final int GAME_TYPE_ORDER = 8;
    public static final int GAME_TYPE_GRID = 5;
    public static final int GAME_SUB_TYPE_MISSING_NUMBERS = 0;
    public static final int GAME_SUB_TYPE_FRUIT_BOX = 1;
    public static final int GAME_SUB_TYPE_CONSTELLATIONS = 2;
    public static final int GAME_SUB_TYPE_FAST_FOOD = 3;
    public static final int GAME_SUB_TYPE_TELEPHONE_NUMBERS = 4;
    public static final int GAME_SUB_TYPE_SPOTLIGHT = 5;
    public static final int GAME_SUB_TYPE_WATCHING_THE_BOX = 6;
    public static final int GAME_SUB_TYPE_CHEMICAL_REACTION = 7;
    public static final int GAME_SUB_TYPE_UFO = 8;
    public static final int GAME_SUB_TYPE_FLIPPING_NUMBERS = 9;
    public static final int GAME_SUB_TYPE_FLIPPING_MATH = 10;
    public static final int GAME_SUB_TYPE_LIGHT_SWITCHES = 11;
    public static final int GAME_SUB_TYPE_SHAPING_UP = 12;
    public static final int GAME_SUB_TYPE_HEAVYWEIGHT = 13;
    public static final int GAME_SUB_TYPE_PARTY_TIME = 14;
    public static final int GAME_SUB_TYPE_FALL = 15;
    public static final int GAME_SUB_TYPE_SUDOKU = 16;
    public static final int GAME_SUB_TYPE_CROSSPIX = 17;
    public static final int GAME_CATEGORY_LOGIC = 7;
    public static final int GAME_CATEGORY_OBSERVATION = 0;
    public static final int GAME_CATEGORY_NEW_MEMORY = 1;
    public static final int GAME_CATEGORY_NEW_CALCULATION = 2;
    public static final int GAME_CATEGORY_REASONING = 3;
    public static final int[] GAME_TYPES = new int[]{2, 1, 3, 1, 1, 0, 2, 3, 0, 1, 2, 0, 3, 2, 3, 0, 5, 5};
    public static final int[][] GAME_BENCHMARK = new int[][]{{11, 10, 4}, {12, 10, 10}, {14, 14, 14}, {11, 10, 7}, {15, 11, 8}, {10, 11, 12}, {10, 5, 3}, {15, 15, 10}, {12, 12, 12}, {8, 6, 6}, {7, 8, 6}, {8, 8, 7}, {15, 12, 8}, {8, 7, 5}, {10, 10, 10}, {18, 18, 18}, {7, 5, 5}, {3, 3, 3}};
    public static final int[] SUB_GAME_TYPES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    public static final int[] GAME_CATEGORIES = new int[]{2, 1, 3, 1, 1, 0, 2, 3, 0, 1, 2, 0, 3, 2, 3, 0, 7, 7};
    public static final int[] BONUS_GAMES = new int[]{17, 16};
    public static String[] GAME_NAMES;
    public static final int[][] GAME_MENU;
    public static final int NUM_GAMES = 18;
    public static final int NUM_BONUS_GAMES = 2;
    public static String[] CATEGORY_NAMES;
    public static String[] NEW_CATEGORY_NAMES;
    public static String[] GAME_TYPE_DESCRIPTIONS;
    public static String[] BONUS_NAMES;
    private Engine engine;
    public static DeviceImage imgSliderCamera;
    public static DeviceImage imgSliderCameraUse;
    public DeviceImage imgTimeUp;
    public DeviceImage[] imgMedals;
    public DeviceImage imgHand;
    public DeviceImage imgSetting;
    public DeviceImage imgTimer;
    public DeviceImage imgPreview;
    public DeviceImage imgTxtOverlay;
    public DeviceImage activitySummary;
    public DeviceImage[] imgResult;
    public DeviceImage[] imgCountDown;
    public DeviceImage imgCountDownSpeachBubble;
    public DeviceImage imgTimerBar;
    public DeviceImage imgRound;
    public DeviceImage imgKeyPad;
    public static final int WRONG_ANSWER_FIX_TIME = 0;
    public static final int SUM_GAME_KEY_WAIT_TIME = 2;
    public static final int INTERMEDIARY_RESULT_TIMING = 20;
    public static final int COUNTDOWN_TIMING = 50;
    public static final int STATE_VIEW_ACTIVITY_CHALLENGE = 0;
    public static final int STATE_PERFORM_ACTIVITY = 1;
    public static final int STATE_SHOW_SUB_RESULT = 2;
    public static final int STATE_SHOW_FINAL_RESULT = 3;
    public static final int STATE_COUNTDOWN = 4;
    public static final int STATE_TIMEUP = 5;
    public static final int STATE_PROFESSOR_SLIDE_IN = 6;
    public static final int BRONZE_MEDAL = 0;
    public static final int SILVER_MEDAL = 1;
    public static final int GOLD_MEDAL = 2;
    public DeviceImage[] orderArrows;
    public int type;
    public int subType;
    public int toolTips;
    public int lastRoundChangeTick;
    public int numGoodResults;
    public int numBadResults;
    public int currentRound;
    public boolean roundResult;
    public static int state;
    public int userNumberIndex;
    public int roundTime;
    public int totalRoundTime;
    public int gameTick;
    public String[] userNumbers;
    public String userNumberString;
    public String userInputString;
    public static boolean isBonusGame;
    private int imgSettingHeight;
    private int imgSettingWidth;
    public DeviceImage[] imgFruitBox;
    public DeviceImage imgFruitCup;
    public DeviceImage imgCrateTop;
    public DeviceImage imgCrateBottom;
    public DeviceImage[] imgCrateTopCorners;
    public DeviceImage[] imgCrateBottomCorners;
    public DeviceImage[] imgCrateSides;
    public DeviceImage[] imgHiResShapes;
    public DeviceImage imgCalDigitsCover;
    public DeviceImage imgNotePadPiece;
    public int telephone_numbers_length;
    public String the_number;
    private SGSprite sgSprite;
    private SGSprite sudokuCursor;
    private SGSprite sgWindowBlinds;
    private SGSprite[] sgSpriteArray;
    private SGSprite[] sgBlinds;
    private SGSprite[] sgLeaves;
    public int maxFlipped;
    public int countDownImgTracker;
    public DeviceImage[] weightsBronze;
    public DeviceImage[] weightsRed;
    public DeviceImage[] weightsSilver;
    public DeviceImage[] weightsGold;
    public static int roundIndicatorY;
    private int photoAmount;
    private int displayInfoTextY;
    private int speachBubbleHeight;
    private int screenCentreY;
    private int professorSlideInX;
    private int animateScoreTicker;
    private boolean stopFinalScoreTicking;
    private boolean stopGeniusScoreTicking;
    private int oldGeniusScore;
    private final int GENIUS_SCORE_TICK_INC;
    private final int EXERCISE_TIME_FALL;
    private final int EXERCISE_TIME_UFO;
    private final int EXERCISE_TIME_SPOTLIGHT;
    private final int EXERCISE_TIME_LIGHT_SWITCHES;
    private final int EXERCISE_TIME_TELEPHONE_NUMBERS;
    private final int EXERCISE_TIME_FAST_FOOD;
    private final int EXERCISE_TIME_FLIPPING_NUMBERS;
    private final int EXERCISE_TIME_FRUIT_BOX;
    private final int EXERCISE_TIME_FLIPPING_MATHS;
    private final int EXERCISE_TIME_HEAVYWEIGHT;
    private final int EXERCISE_TIME_WATCHING_THE_BOX;
    private final int EXERCISE_TIME_MISSING_NUMBERS;
    private final int EXERCISE_TIME_PARTY_TIME;
    private final int EXERCISE_TIME_CONSTELLATIONS;
    private final int EXERCISE_TIME_CHEMICAL_REACTION;
    private final int EXERCISE_TIME_SHAPING_UP;
    public int gameTime;
    public int activityScore;
    public int numDeletions;
    public int medalAwarded;
    public boolean gotBestScore;
    public int resultFactor;
    public int resultPercentage;
    public static final int GOLD_THRESHOLD = 0;
    public static final int SILVER_THRESHOLD = 2;
    public static final int BRONZE_THRESHOLD = 4;
    public static final int GENIUS_MAX_SCORE = 3000;
    public static final int JUNIOR_MAX_SCORE = 1000;
    public static final int MASTER_MAX_SCORE = 2000;
    public static final int MAX_SCORE = 1000;
    public static final int FINAL_RESULT_BRAIN_TIMING = 40;
    public static final int[] CATEGORY_BG_COLOURS;
    public static final int NUM_COUNTDOWN_STEPS = 3;
    public static String[] DIFFICULTY_NAME;
    public static String[] MEDAL_NAMES;
    public int bonusTimerHeight;
    public static final int RESULT_FLASHING_SPEED = 6;
    public static final int ORDER_SPEED_BASE = 15;
    public int[] wantedOrder;
    public int[] achievedOrder;
    public DeviceImage[] imgOrderSmall;
    public DeviceImage[] imgOrderLarge;
    public DeviceImage[] imgOrder;
    public DeviceImage[] summaryBrain;
    public int orderDelay;
    public int orderIndex;
    public int flashItemIndex;
    public static final int EASY = 0;
    public static final int MEDIUM = 1;
    public static final int HARD = 2;
    public int numActiveOptions;
    public static final int DIRECTION_LEFT = 0;
    public static final int DIRECTION_UP = 1;
    public static final int DIRECTION_RIGHT = 2;
    public static final int DIRECTION_DOWN = 3;
    public static final int KEY_FIRE = 4;
    public static final String[] OPERAND_STRING;
    public static final int OPERAND_PLUS = 0;
    public static final int OPERAND_MINUS = 1;
    public static final int OPERAND_MULTIPLY = 2;
    public static final int OPERAND_DIVIDE = 3;
    public static final int NUM_USER_NUMBERS = 12;
    public static final int HEAVYWEIGHT_MAX_NUMBERS = 3;
    public int[] currentFactors;
    public int currentOperand;
    public int wantedSum;
    public int achievedSum;
    public int currentAngle;
    public int prevWantedSum;
    public int GRID_WIDTH;
    public int GRID_HEIGHT;
    public int GRID_RECT_SIZE;
    public DeviceImage[] profileImage;
    public int[] wantedGrid;
    public int[] achievedGrid;
    public int[] gridState;
    public int[] cellState;
    public int xPos;
    public int yPos;
    public boolean[] sgSpriteUsed;
    private int cellWipeWidth;
    private int sudokuTransitionType;
    public static final int SUDOKU_WIPE_LEFT_TO_RIGHT = 0;
    public static final int SUDOKU_WIPE_RIGHT_TO_LEFT = 1;
    public static final int SUDOKU_WIPE_UP_TO_DOWN = 2;
    public static final int SUDOKU_WIPE_DOWN_TO_UP = 3;
    public static final int SUDOKU_WIPE_OUT_TO_IN = 4;
    public Image imgBuffGrid;
    public Graphics gBuffGrid;
    public static final int SUDOKU_PREPLACED = 2;
    public static final int SUDOKU_BLANK_CELL = 0;
    public static final int SUDOKU_USED_CELL = 1;
    public static final int SUDOKU_BLANK_TO_NUMBER = 2;
    public static final int SUDOKU_NUMBER_TO_NUMBER = 3;
    public static String loadFileName;
    public int sudokuGridTopLeftPosX;
    public int sudokuGridTopLeftPosY;
    public static final int SUDOKU_GRID_WIDTH = 9;
    public static final int SUDOKU_GRID_HEIGHT = 9;
    public static final int CORRECT_CELL_COLOUR = 12968956;
    public static final int INNER_LINE_COLOUR = 8502229;
    public int PLAY_AREA_X;
    public int PLAY_AREA_Y;
    public int PLAY_AREA_HEIGHT;
    public int PLAY_AREA_WIDTH;
    public int clipHeight;
    public int gameTicker;
    public static final int FRUIT_BOX_MAX_GRID_WIDTH = 5;
    public static final int FRUIT_BOX_MAX_GRID_HEIGHT = 5;
    public DeviceImage[] imgFruits;
    public DeviceImage[] imgCup;
    public DeviceImage[] imgBoxTop;
    public DeviceImage[] imgBottom;
    public DeviceImage[] imgLeft;
    public DeviceImage[] imgRight;
    public int gridOffSetX;
    public int gridOffSetY;
    public int shapeWidth;
    public int shapeHeight;
    public int chosenFruit;
    public int chosenFruitAmount;
    public int maxType;
    public int gridWidth;
    public int gridHeight;
    public static final int LEFT_SIDE = 0;
    public static final int RIGHT_SIDE = 1;
    public static final int ANSWER = 2;
    public int chosenSideToHide;
    public int copyOfWantedSum;
    public int calculatorButtonPressed;
    public static final int RIGHT_ARROW = 0;
    public static final int DOWN_ARROW = 1;
    public static final int LEFT_ARROW = 2;
    public static final int UP_ARROW = 3;
    public static final int MIN_TIME_TO_VIEW_UFOS = 20;
    public static final int UFO_UP = 0;
    public static final int UFO_RIGHT = 1;
    public static final int UFO_DOWN = 2;
    public static final int UFO_LEFT = 3;
    public int wantedUFO;
    public static final int UFO_GAP = 3;
    public int[] boxes_order;
    public int[] velocity_array;
    public int[][] gridArray;
    public int[][] gridArrayType;
    public DeviceImage[] imgArrows;
    public int[][] star_paths;
    public int currentPath;
    public int nextPath;
    public int maxPathInShape;
    public int[] moveSpotlightOrder;
    public int prevX;
    public int prevY;
    public int vel;
    public int[] starTail;
    public static final int[] EASY_SHAPES_LIST;
    public static final int[] MEDIUM_SHAPES_LIST;
    public static final int[] HARD_SHAPES_LIST;
    public int percent;
    public boolean finishCycle;
    public int[] shapesChosen;
    public static final int[] keypad_pos;
    public static final int MAX_SHAPES = 25;
    public int[] shapeOrder;
    public int[] shapesPos;
    public int[] chosenShapePos;
    public int[] shapeUnderSpotlight;
    public int[][] shapeOnKeyPad1;
    public DeviceImage imgUnderSpotlight;
    public boolean all_boxes_filled;
    public int current_box;
    public int removedBoxIndex;
    public int flashAmount;
    public DeviceImage[] imgTopCrate;
    public DeviceImage[] imgToys;
    public DeviceImage[] imgBottomCrate;
    public static final int MAX_TOY_BOX_COLOURS = 3;
    public static final int WATER_GLASS_EMPTY = 0;
    public static final int WATER_GLASS_FULL = 1;
    public static final int WATER_GLASS_HALF_FULL = 2;
    public static final int WATER_GLASS_QUARTER_FULL = 3;
    public static final int WATER_GLASS_3_QUARTER_FULL = 4;
    public int[] water_glass_state;
    public static final int ONE_PRECISION = 256;
    public static final int HALF_PRECISION;
    public static final int QUARTER_PRECISION;
    public static final int THREE_QUARTERS_PRECISION;
    public static final int MAX_TEST_TUBE_COLUMN = 6;
    public static final int MAX_TEST_TUBE_ROW = 2;
    public int lowestNumber;
    public int highestNumber;
    public int[][] cardState;
    public int[] cardState1;
    public int[] gridArray1;
    public static final int CARD_STATE_FACEDOWN = 0;
    public static final int CARD_STATE_CORRECTCARD = 1;
    public static final int CARD_STATE_FLIP_FACE_UP = 2;
    public static final int CARD_STATE_WRONGCARD = 3;
    public static final int CARD_STATE_FLIP_BACKWARD = 12;
    public static final int FLIPPING_WAIT_DELAY = 8;
    public int cardID;
    public int[] gridEdges;
    public int incrementValue;
    public int formationType;
    public int flippingMath_state;
    public static final int FLIPPING_MATH_STATE_FLIP_CARD = 0;
    public static final int FLIPPING_MATH_STATE_SHOW_FACE = 1;
    public static final int FLIPPING_MATH_STATE_FLIP_BACKWARD = 2;
    public static final int FLIPPING_MATH_STATE_SHOW_SUM = 3;
    public static final int FLIPPING_MATH_STATE_CHECK_AND_FLIP_BACKWARD = 4;
    public static final int FLIPPING_MATH_STATE_WAIT_THEN_CHECK = 5;
    public int totalNumberOfCards;
    public static final int MAX_WINDOW_TYPE = 5;
    public int numberOfWindows;
    public DeviceImage[] imgWindows;
    public int amountFlashed;
    public int lightsOffDelay;
    public int windowCapacity;
    public boolean flashLight;
    public static final int MAX_WINDOW_COLUMN = 4;
    public static final int MAX_WINDOW_FLASH_LIST = 4;
    public int maxWindowsShownAtOnce;
    public String[] theString;
    public int[] shapesVectors;
    public int[] shapeFillColour;
    public int[][] shapesXYPos;
    private static final int[] polygonFillColour;
    public int[] weightsPlate;
    public int[][] scaleTrays;
    public int currentPlate;
    private int weightsWidth;
    private int weightsHeight;
    public static final int trayWidth = 59;
    public int[][] windowsOrder;
    public static final int NUM_WINDOWS = 2;
    public static final int WINDOW_CLOSED = 0;
    public static final int WINDOW_SLIDE_OPEN = 1;
    public static final int WINDOW_SLIDE_SHUT = 2;
    public static final int WINDOW_OPENED = 3;
    public int[] windowState;
    public int[] curtainWidth;
    public int[] windowShowFaceIndex;
    public int windowWidth;
    public int windowHeight;
    public static final int WINDOW_LEFT = 0;
    public static final int WINDOW_RIGHT = 1;
    public static final int WINDOW_BOTH = 2;
    public int animateWindow;
    public int numLeaves;
    public int[] leaf_type;
    public int[] leaves_list;
    private int[] boxesY;

    public GameWorld() {
        this.GENIUS_SCORE_TICK_INC = 121;
        this.EXERCISE_TIME_FALL = 450;
        this.EXERCISE_TIME_UFO = 300;
        this.EXERCISE_TIME_SPOTLIGHT = 675;
        this.EXERCISE_TIME_LIGHT_SWITCHES = 675;
        this.EXERCISE_TIME_TELEPHONE_NUMBERS = 900;
        this.EXERCISE_TIME_FAST_FOOD = 300;
        this.EXERCISE_TIME_FLIPPING_NUMBERS = 900;
        this.EXERCISE_TIME_FRUIT_BOX = 300;
        this.EXERCISE_TIME_FLIPPING_MATHS = 100;
        this.EXERCISE_TIME_HEAVYWEIGHT = 800;
        this.EXERCISE_TIME_WATCHING_THE_BOX = 100;
        this.EXERCISE_TIME_MISSING_NUMBERS = 500;
        this.EXERCISE_TIME_PARTY_TIME = 105;
        this.EXERCISE_TIME_CONSTELLATIONS = 960;
        this.EXERCISE_TIME_CHEMICAL_REACTION = 500;
        this.EXERCISE_TIME_SHAPING_UP = 800;
        this.flashItemIndex = -1;
        this.prevWantedSum = -1;
        this.GRID_RECT_SIZE = 18;
        this.gameTicker = 0;
        this.formationType = 0;
        this.maxWindowsShownAtOnce = 0;
        this.animateWindow = 0;
    }

    public GameWorld(Engine engine, int n, int n2) {
        block66: {
            this.GENIUS_SCORE_TICK_INC = 121;
            this.EXERCISE_TIME_FALL = 450;
            this.EXERCISE_TIME_UFO = 300;
            this.EXERCISE_TIME_SPOTLIGHT = 675;
            this.EXERCISE_TIME_LIGHT_SWITCHES = 675;
            this.EXERCISE_TIME_TELEPHONE_NUMBERS = 900;
            this.EXERCISE_TIME_FAST_FOOD = 300;
            this.EXERCISE_TIME_FLIPPING_NUMBERS = 900;
            this.EXERCISE_TIME_FRUIT_BOX = 300;
            this.EXERCISE_TIME_FLIPPING_MATHS = 100;
            this.EXERCISE_TIME_HEAVYWEIGHT = 800;
            this.EXERCISE_TIME_WATCHING_THE_BOX = 100;
            this.EXERCISE_TIME_MISSING_NUMBERS = 500;
            this.EXERCISE_TIME_PARTY_TIME = 105;
            this.EXERCISE_TIME_CONSTELLATIONS = 960;
            this.EXERCISE_TIME_CHEMICAL_REACTION = 500;
            this.EXERCISE_TIME_SHAPING_UP = 800;
            this.flashItemIndex = -1;
            this.prevWantedSum = -1;
            this.GRID_RECT_SIZE = 18;
            this.gameTicker = 0;
            this.formationType = 0;
            this.maxWindowsShownAtOnce = 0;
            this.animateWindow = 0;
            this.engine = engine;
            Device.soundFunction(4, 4);
            Engine.random = new Random();
            this.type = n;
            this.subType = n2;
            roundIndicatorY = 0;
            this.oldGeniusScore = Engine.currentProfile.geniusScore;
            this.imgRound = new DeviceImage(ResourceMaster.getResource(144));
            roundIndicatorY -= this.imgRound.height;
            roundIndicatorY = 0;
            if (n2 != 17) {
                this.imgTimer = new DeviceImage(ResourceMaster.getResource(153));
                this.imgTimerBar = new DeviceImage(ResourceMaster.getResource(154));
                this.imgTimeUp = new DeviceImage(ResourceMaster.getResource(155));
                this.imgResult = new DeviceImage(ResourceMaster.getResource(116)).divide(2);
                this.imgTxtOverlay = new DeviceImage(ResourceMaster.getResource(149));
                this.speachBubbleHeight = this.imgTxtOverlay.height;
            }
            this.initTouchNumberKeyPadBoxes();
            block10 : switch (n) {
                case 5: {
                    switch (n2) {
                        case 16: {
                            try {
                                this.sgSprite = new SGSprite("sudoku");
                                this.sudokuCursor = new SGSprite("sudoku_cursor");
                            }
                            catch (Exception exception) {}
                            break block10;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (n2) {
                        case 2: {
                            this.imgSetting = new DeviceImage(ResourceMaster.getResource(100));
                            this.imgOrderSmall = new DeviceImage[1];
                            this.imgOrderSmall[0] = new DeviceImage(ResourceMaster.getResource(150));
                            this.initSkyGazingOrder();
                            this.imgKeyPad = new DeviceImage(ResourceMaster.getResource(123));
                            break;
                        }
                        case 7: {
                            this.imgSetting = new DeviceImage(ResourceMaster.getResource(100));
                            try {
                                this.sgSprite = new SGSprite("chemicals");
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case 12: {
                            this.imgSetting = new DeviceImage(ResourceMaster.getResource(101));
                            this.imgKeyPad = new DeviceImage(ResourceMaster.getResource(123));
                            break;
                        }
                        case 14: {
                            this.imgSetting = new DeviceImage(ResourceMaster.getResource(98));
                            try {
                                this.sgSprite = new SGSprite("faces");
                                this.sgWindowBlinds = new SGSprite("window");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.profileImage = null;
                            this.orderArrows = new DeviceImage(ResourceMaster.getResource(140)).divide(2);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n2) {
                        case 1: {
                            this.imgSetting = new DeviceImage(ResourceMaster.getResource(100));
                            this.imgFruitBox = new DeviceImage(ResourceMaster.getResource(146)).divide(4);
                            this.imgOrderLarge = new DeviceImage(ResourceMaster.getResource(145)).divide(4);
                            this.imgFruitCup = new DeviceImage(ResourceMaster.getResource(112));
                            this.imgCrateTop = new DeviceImage(ResourceMaster.getResource(157));
                            this.imgCrateBottom = new DeviceImage(ResourceMaster.getResource(102));
                            this.imgCrateTopCorners = new DeviceImage(ResourceMaster.getResource(158)).divide(2);
                            this.imgCrateBottomCorners = new DeviceImage(ResourceMaster.getResource(103)).divide(2);
                            this.imgCrateSides = new DeviceImage(ResourceMaster.getResource(147)).divide(2);
                            break;
                        }
                        case 3: {
                            this.imgSetting = new DeviceImage(ResourceMaster.getResource(100));
                            this.imgOrderLarge = new DeviceImage(ResourceMaster.getResource(113)).divide(4);
                            this.imgOrderSmall = new DeviceImage(ResourceMaster.getResource(114)).divide(4);
                            for (int i = 0; i < 4; ++i) {
                                int n3 = Engine.rndPositive(4);
                                DeviceImage deviceImage = this.imgOrderLarge[i];
                                DeviceImage deviceImage2 = this.imgOrderSmall[i];
                                this.imgOrderLarge[i] = this.imgOrderLarge[n3];
                                this.imgOrderSmall[i] = this.imgOrderSmall[n3];
                                this.imgOrderLarge[n3] = deviceImage;
                                this.imgOrderSmall[n3] = deviceImage2;
                            }
                            this.imgOrder = this.imgOrderSmall;
                            this.imgKeyPad = new DeviceImage(ResourceMaster.getResource(123));
                            break;
                        }
                        case 4: {
                            this.imgSetting = new DeviceImage(ResourceMaster.getResource(100));
                            this.imgNotePadPiece = new DeviceImage(ResourceMaster.getResource(138));
                            this.telephone_numbers_length = 2;
                            this.the_number = "";
                            break;
                        }
                        case 9: {
                            this.imgSetting = new DeviceImage(ResourceMaster.getResource(100));
                            try {
                                this.sgSprite = new SGSprite("cards");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.imgHand = new DeviceImage(ResourceMaster.getResource(117));
                        }
                    }
                    break;
                }
                case 0: {
                    switch (n2) {
                        case 8: {
                            this.imgSetting = new DeviceImage(ResourceMaster.getResource(100));
                            try {
                                this.sgSprite = new SGSprite("ufos");
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case 5: {
                            this.imgSetting = new DeviceImage(ResourceMaster.getResource(101));
                            this.imgOrderSmall = new DeviceImage[1];
                            switch (Engine.currentDifficulty) {
                                case 0: {
                                    this.imgOrderSmall[0] = new DeviceImage(ResourceMaster.getResource(124));
                                    break;
                                }
                                case 1: {
                                    this.imgOrderSmall[0] = new DeviceImage(ResourceMaster.getResource(125));
                                    break;
                                }
                                case 2: {
                                    this.imgOrderSmall[0] = new DeviceImage(ResourceMaster.getResource(126));
                                    break;
                                }
                                default: {
                                    this.imgOrderSmall[0] = new DeviceImage(ResourceMaster.getResource(124));
                                }
                            }
                            this.initSkyGazingOrder();
                            this.imgKeyPad = new DeviceImage(ResourceMaster.getResource(123));
                            break;
                        }
                        case 11: {
                            this.imgSetting = new DeviceImage(ResourceMaster.getResource(142));
                            this.imgOrder = new DeviceImage(ResourceMaster.getResource(161)).divide(10);
                            break;
                        }
                        case 15: {
                            this.imgSetting = new DeviceImage(ResourceMaster.getResource(100));
                            try {
                                this.sgLeaves = new SGSprite[4];
                                this.sgLeaves[0] = new SGSprite("leaf");
                                this.sgLeaves[0].releaseBaseSprite();
                                this.sgLeaves[1] = new SGSprite("leaf", 271);
                                this.sgLeaves[1].releaseBaseSprite();
                                this.sgLeaves[2] = new SGSprite("leaf", 273);
                                this.sgLeaves[2].releaseBaseSprite();
                                this.sgLeaves[3] = new SGSprite("leaf", 272);
                                this.sgLeaves[3].releaseBaseSprite();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.imgKeyPad = new DeviceImage(ResourceMaster.getResource(123));
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 10: {
                            this.imgSetting = new DeviceImage(ResourceMaster.getResource(97));
                            try {
                                this.sgSprite = new SGSprite("cards");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.imgHand = new DeviceImage(ResourceMaster.getResource(117));
                            break block10;
                        }
                        case 0: {
                            this.imgSetting = new DeviceImage(ResourceMaster.getResource(100));
                            this.imgCalDigitsCover = new DeviceImage(ResourceMaster.getResource(108));
                            try {
                                this.sgSprite = new SGSprite("calculator");
                            }
                            catch (Exception exception) {}
                            break block66;
                        }
                        case 6: {
                            this.imgSetting = new DeviceImage(ResourceMaster.getResource(100));
                            this.imgOrderSmall = new DeviceImage(ResourceMaster.getResource(159)).divide(4);
                            this.imgOrderLarge = new DeviceImage[6];
                            this.imgOrderLarge[0] = new DeviceImage(ResourceMaster.getResource(111));
                            this.imgOrderLarge[1] = new DeviceImage(ResourceMaster.getResource(110));
                            this.imgOrderLarge[2] = new DeviceImage(Engine.insertPLTE(ResourceMaster.getResource(111), ResourceMaster.getResource(265)));
                            this.imgOrderLarge[3] = new DeviceImage(Engine.insertPLTE(ResourceMaster.getResource(110), ResourceMaster.getResource(265)));
                            this.imgOrderLarge[4] = new DeviceImage(Engine.insertPLTE(ResourceMaster.getResource(111), ResourceMaster.getResource(266)));
                            this.imgOrderLarge[5] = new DeviceImage(Engine.insertPLTE(ResourceMaster.getResource(110), ResourceMaster.getResource(266)));
                            try {
                                this.sgSprite = new SGSprite("box_disappear");
                            }
                            catch (Exception exception) {}
                            break block66;
                        }
                        case 13: {
                            this.imgSetting = new DeviceImage(ResourceMaster.getResource(100));
                            try {
                                this.sgSprite = new SGSprite("scales");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.weightsBronze = new DeviceImage(ResourceMaster.getResource(119)).divide(3);
                            this.weightsRed = new DeviceImage(Engine.insertPLTE(ResourceMaster.getResource(119), ResourceMaster.getResource(269))).divide(3);
                            this.weightsSilver = new DeviceImage(Engine.insertPLTE(ResourceMaster.getResource(119), ResourceMaster.getResource(270))).divide(3);
                            this.weightsGold = new DeviceImage(Engine.insertPLTE(ResourceMaster.getResource(119), ResourceMaster.getResource(268))).divide(3);
                        }
                    }
                }
            }
        }
        if (this.imgSetting != null) {
            this.imgSettingHeight = this.imgSetting.height;
            this.imgSettingWidth = this.imgSetting.width;
        } else {
            this.imgSettingHeight = 222;
            this.imgSettingWidth = 320;
        }
        if (n2 != 17) {
            this.screenCentreY = 24 + (this.imgSettingHeight >> 1);
        } else if (this.imgSetting != null) {
            this.screenCentreY = 111;
        }
        this.displayInfoTextY = 188;
        this.medalAwarded = -1;
        this.initNextRound();
    }

    public void getNumberInput() {
        int n;
        this.userNumberString = "";
        for (n = 0; n < this.userNumberIndex; ++n) {
            this.userNumberString = this.userNumberString + this.userNumbers[n];
        }
        if (Engine.keyUnmapped > 47 && Engine.keyUnmapped < 58 && this.userNumberIndex < this.userNumbers.length) {
            this.lastRoundChangeTick = 0;
            n = Engine.keyUnmapped - 48;
            Engine.resetKeyBuffers();
            this.userNumbers[Math.min((int)this.userNumbers.length, (int)this.userNumberIndex)] = "" + n;
            if (this.userNumberIndex < this.userNumbers.length) {
                ++this.userNumberIndex;
            }
        }
    }

    public void initNumberInput() {
        this.userNumberIndex = 0;
        this.userNumberString = "";
        this.userNumbers = this.subType == 13 ? new String[3] : new String[12];
        for (int i = 0; i < this.userNumbers.length; ++i) {
            this.userNumbers[i] = "";
        }
    }

    public void initNextRound() {
        Engine.resetKeyBuffers();
        this.lastRoundChangeTick = 0;
        switch (this.type) {
            case 8: {
                this.initOrderGameRound();
                break;
            }
            case 5: {
                this.initGridGameRound();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.initNewBG2Games();
            }
        }
        state = 0;
        if (this.currentRound == 0) {
            state = isBonusGame ? 0 : 4;
        }
    }

    public static void paintTitle(Graphics graphics, String string) {
        FontMgr.drawString(1, graphics, string, 160, 10, 3);
    }

    public void startTiming() {
        this.gameTime = 0;
        switch (this.subType) {
            case 15: {
                this.totalRoundTime = 450;
                break;
            }
            case 8: {
                this.totalRoundTime = 300;
                break;
            }
            case 5: {
                this.totalRoundTime = 675;
                break;
            }
            case 11: {
                this.totalRoundTime = 675;
                break;
            }
            case 4: {
                this.totalRoundTime = 900;
                break;
            }
            case 3: {
                this.totalRoundTime = 300;
                break;
            }
            case 9: {
                this.totalRoundTime = 900;
                break;
            }
            case 1: {
                this.totalRoundTime = 300;
                break;
            }
            case 10: {
                this.totalRoundTime = 100;
                break;
            }
            case 13: {
                this.totalRoundTime = 800;
                break;
            }
            case 6: {
                this.totalRoundTime = 100;
                break;
            }
            case 0: {
                this.totalRoundTime = 500;
                break;
            }
            case 14: {
                this.totalRoundTime = 105;
                break;
            }
            case 2: {
                this.totalRoundTime = 960;
                break;
            }
            case 7: {
                this.totalRoundTime = 500;
                break;
            }
            case 12: {
                this.totalRoundTime = 800;
            }
        }
        this.roundTime = this.totalRoundTime;
    }

    public void updateTiming() {
        --this.roundTime;
        if (this.roundTime <= 0) {
            this.endActivity();
        }
    }

    public void endRound() {
        Engine.resetKeyBuffers();
        this.lastRoundChangeTick = 0;
        if (isBonusGame) {
            switch (this.subType) {
                case 16: {
                    for (int i = 0; i < this.sgSpriteUsed.length; ++i) {
                        if (!this.sgSpriteUsed[i]) continue;
                        return;
                    }
                    this.roundResult = true;
                    state = 2;
                }
            }
        } else {
            switch (this.type) {
                case 8: {
                    this.roundResult = this.checkOrderGameResult();
                    state = 2;
                    break;
                }
                case 5: {
                    this.roundResult = this.checkGridGameResult();
                    state = 2;
                    break;
                }
                case 0: 
                case 2: {
                    this.roundResult = this.checkSumGameResult();
                    state = 2;
                    break;
                }
                case 1: {
                    switch (this.subType) {
                        case 3: {
                            this.roundResult = this.checkSumGameResult();
                            break;
                        }
                        case 4: {
                            this.roundResult = this.checkOrderGameResult();
                            break;
                        }
                        default: {
                            this.roundResult = this.checkSumGameResult();
                        }
                    }
                    state = 2;
                    break;
                }
                case 3: {
                    this.roundResult = this.checkSumGameResult();
                    state = 2;
                    break;
                }
                default: {
                    this.roundResult = true;
                    state = 2;
                }
            }
        }
    }

    public void endActivity() {
        int n;
        int n2;
        int n3;
        Engine.resetKeyBuffers();
        if (!isBonusGame) {
            this.resultFactor = Engine.div(this.numGoodResults << 8, GAME_BENCHMARK[Engine.currentGameIndex][Engine.currentDifficulty] << 8);
            n3 = Engine.multiFixed(GAME_BENCHMARK[Engine.currentGameIndex][Engine.currentDifficulty] << 8, 384);
            n2 = Engine.div(this.numBadResults << 8, n3);
            this.resultFactor -= n2;
            n = 256 * this.numDeletions / 100;
            this.resultFactor -= n;
            this.resultFactor = Math.max(0, this.resultFactor);
            switch (Engine.currentDifficulty) {
                case 0: {
                    this.activityScore = Engine.mul(this.resultFactor, 256000) >> 8;
                    break;
                }
                case 1: {
                    this.activityScore = Engine.mul(this.resultFactor, 512000) >> 8;
                    break;
                }
                case 2: {
                    this.activityScore = Engine.mul(this.resultFactor, 768000) >> 8;
                }
            }
            this.resultPercentage = Engine.mul(this.resultFactor, 25600) >> 8;
        }
        if (!isBonusGame) {
            if (this.resultPercentage >= 4) {
                Device.soundFunction(3, 6);
                Engine.lastSound = 6;
            } else {
                Device.soundFunction(3, 1);
                Engine.lastSound = 1;
            }
            n3 = GAME_BENCHMARK[Engine.currentGameIndex][Engine.currentDifficulty];
            n2 = 100;
            n = n3 < 4 ? n3 - 1 : n3 - 2;
            int n4 = Engine.div(n << 8, n3 << 8);
            n4 = Engine.mul(n4, 25600) >> 8;
            n = n3 < 4 ? n3 - 2 : n3 - 4;
            int n5 = Engine.div(n << 8, n3 << 8);
            n5 = Engine.mul(n5, 25600) >> 8;
            if (this.resultPercentage >= n2) {
                if (Engine.currentDifficulty < 2 && !Engine.dailyExersize && !Engine.currentProfile.GAME_UNLOCKED[Engine.currentGameIndex][Engine.currentDifficulty + 1]) {
                    Engine.unlockedDifficulty = Engine.currentDifficulty + 1;
                    Engine.currentProfile.GAME_UNLOCKED[Engine.currentGameIndex][Engine.currentDifficulty + 1] = true;
                }
                this.medalAwarded = 2;
            } else {
                this.medalAwarded = this.resultPercentage >= n4 ? 1 : (this.resultPercentage >= n5 ? 0 : -1);
            }
        }
        if (!Engine.dailyExersize) {
            if (isBonusGame) {
                GameWorld.saveBousGameBestTime(this.gameTime);
                this.gotoFinalResult();
                Device.soundFunction(3, 6);
                Engine.lastSound = 6;
            } else {
                if (Engine.hasBetterScore(this.activityScore)) {
                    this.gotBestScore = true;
                }
                Engine.currentProfile.addActivityScore(Engine.currentGameIndex, this.activityScore, this.medalAwarded);
                Engine.currentProfile.updateGameScore(Engine.currentGameIndex, Engine.currentDifficulty, this.activityScore);
                state = 5;
            }
        } else if (Engine.dailyExersize) {
            Engine.todaysGameTotal += this.activityScore;
            Engine.todaysGamesScores[GameWorld.GAME_CATEGORIES[Engine.currentGameIndex]] = Math.min(100, this.resultPercentage);
            if (Engine.currentTodaysGameIndex == Engine.todaysGames.length - 1) {
                Engine.currentProfile.addDailyScore(Engine.todaysGamesScores);
            }
            state = 5;
        }
        this.lastRoundChangeTick = 0;
    }

    public void endCountDown() {
        this.imgCountDown = null;
        this.startTiming();
        this.toolTips = 4;
        state = 0;
    }

    public void tick() {
        ++this.gameTick;
        this.toolTips = 4;
        if (state != 3 && this.engine.cheatProfileEnabled() && this.subType != 17) {
            if (Engine.key(4096)) {
                Engine.resetKeyBuffers();
                this.endActivity();
            } else if (Engine.key(16384)) {
                Engine.resetKeyBuffers();
                this.numGoodResults = GAME_BENCHMARK[Engine.currentGameIndex][Engine.currentDifficulty];
                this.endActivity();
            }
        }
        switch (state) {
            case 4: {
                this.toolTips = 12;
                if (this.gameTick != 50) break;
                this.endCountDown();
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                ++this.lastRoundChangeTick;
                this.toolTips = 0;
                if (this.lastRoundChangeTick < 40) break;
                this.lastRoundChangeTick = 0;
                Engine.resetKeyBuffers();
                this.gotoFinalResult();
                break;
            }
            case 3: {
                this.toolTips = 2;
                ++this.lastRoundChangeTick;
                break;
            }
            case 1: {
                if (!isBonusGame) {
                    this.updateTiming();
                    break;
                }
                this.gameTime += 50;
                break;
            }
            case 2: {
                if (this.lastRoundChangeTick == 1 && !isBonusGame) {
                    if (this.roundResult) {
                        Device.soundFunction(3, 4);
                        Engine.lastSound = 4;
                    } else {
                        Device.soundFunction(3, 5);
                        Engine.lastSound = 5;
                        Device.vibrate(500);
                    }
                    this.calculatorButtonPressed = -1;
                }
                ++this.lastRoundChangeTick;
                boolean bl = false;
                if (this.lastRoundChangeTick > 20 || Engine.currentGameIndex == 16 && this.lastRoundChangeTick > 3) {
                    bl = true;
                }
                if (!bl) break;
                this.lastRoundChangeTick = 0;
                Engine.resetKeyBuffers();
                if (isBonusGame && this.subType == 16) {
                    this.endActivity();
                    return;
                }
                if (this.roundResult) {
                    ++this.numGoodResults;
                } else {
                    ++this.numBadResults;
                }
                ++this.currentRound;
                this.initNextRound();
            }
        }
        switch (this.type) {
            case 8: {
                this.tickOrderGame();
                break;
            }
            case 5: {
                this.tickGridGame();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.tickNewBG2Games();
            }
        }
    }

    private void gotoFinalResult() {
        boolean bl;
        state = 3;
        Engine.paintLoading();
        this.imgSetting = null;
        this.imgOrder = null;
        this.imgOrderLarge = null;
        this.imgResult = null;
        this.sgSprite = null;
        this.sgSpriteArray = null;
        this.imgMedals = new DeviceImage(ResourceMaster.getResource(127)).divide(3);
        this.summaryBrain = new DeviceImage(ResourceMaster.getResource(151)).divide(2);
        boolean bl2 = bl = !Engine.dailyExersize && this.medalAwarded >= 0;
        if (bl) {
            String[] stringArray = new String[]{Engine.currentProfile.name, MEDAL_NAMES[this.medalAwarded]};
            this.initProfessorText(Engine.getText(237, stringArray));
        }
        if (!bl) {
            if (Engine.getBestScore() == 0) {
                this.initProfessorText(Engine.getText(153));
            } else {
                this.initProfessorText(Engine.getText(154, new String[]{Engine.getBestScoreName(), "" + Engine.getBestScore()}));
            }
        }
    }

    public static void saveBousGameBestTime(int n) {
        Engine.currentProfile.updateBonusGameScore(Engine.currentGameIndex, Engine.currentDifficulty, n);
    }

    public void paintTiming(Graphics graphics) {
        this.imgTimer.drawImageNoClipping(graphics, 0, 0);
        int n = 292;
        int n2 = Engine.mul(Engine.div(this.roundTime << 8, this.totalRoundTime << 8), n << 8) >> 8;
        graphics.setClip(20, 7, n2, 11);
        this.imgTimerBar.drawImage(graphics, 20, 7);
        graphics.setClip(0, 0, 320, 222);
    }

    public void paintGameSpecificScreen(Graphics graphics) {
        switch (this.type) {
            case 8: {
                this.paintOrderGame(graphics);
                break;
            }
            case 5: {
                this.paintGridGame(graphics);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.paintNewGames(graphics);
            }
        }
    }

    public void paintBonusGameResult(Graphics graphics) {
        int n = 10;
        int n2 = 107 - FontMgr.lineHeight[3] - n;
        FontMgr.drawString(0, graphics, Engine.text[225], 160, n2, 3);
        FontMgr.drawString(3, graphics, Engine.milliSecsToString(this.gameTime, true, true), 160, n2 += FontMgr.lineHeight[3] + n, 3);
        FontMgr.drawString(0, graphics, Engine.text[226], 160, n2 += FontMgr.lineHeight[3] + n, 3);
    }

    public void paint(Graphics graphics) {
        String string;
        graphics.setClip(0, 0, 320, 222);
        if (isBonusGame || state == 3) {
            Engine.drawGameBg(graphics);
        } else {
            Engine.cls(graphics, 14525815);
        }
        if (isBonusGame && this.subType == 17 && state != 3) {
            this.engine.crossPix.paint(graphics);
            if (state == 1) {
                this.toolTips = 0;
            }
        }
        if (state != 3) {
            this.paintGameBackdrop(graphics, 320 - this.imgSettingWidth >> 1, 24);
            if (!isBonusGame) {
                this.paintTiming(graphics);
            }
            if (isBonusGame) {
                if (this.imgRound != null) {
                    this.imgRound.drawImageNoClipping(graphics, 320 - this.imgRound.width >> 1, roundIndicatorY);
                }
                string = DIFFICULTY_NAME[Engine.currentDifficulty] + " - " + Engine.text[227] + " " + (this.currentRound + 1);
                if (isBonusGame && this.subType == 16) {
                    string = Engine.milliSecsToString(this.gameTime, true, true);
                } else if (isBonusGame && this.subType == 17) {
                    string = "";
                    CrossPix.drawStatusBar();
                }
                FontMgr.drawString(0, graphics, string, 160, roundIndicatorY + 8, 3);
                if (state == 4 || state == 6) {
                    graphics.setClip(0, 0, 320, 0);
                    Engine.imgGameBgTop.drawImageNoClipping(graphics, 0, 0);
                    graphics.setClip(0, 0, 320, 222);
                }
            }
        }
        string = GAME_NAMES[Engine.currentGameIndex];
        if (isBonusGame) {
            string = BONUS_NAMES[Engine.bonusGameIndex];
        }
        if (state == 3) {
            if (Engine.dailyExersize) {
                String[] stringArray = new String[]{"" + (Engine.currentTodaysGameIndex + 1)};
                string = Engine.getText(238, stringArray);
            } else {
                string = Engine.text[228];
            }
        }
        switch (state) {
            case 4: {
                int n = Math.max(1, 3 - this.gameTick / 16);
                if (this.subType == 13) {
                    this.paintGameSpecificScreen(graphics);
                } else if (isBonusGame && this.subType == 16) {
                    this.paintSudokuGame(graphics);
                }
                int n2 = 111 - FontMgr.lineHeight[3];
                int n3 = FontMgr.lineHeight[3] * 2;
                graphics.setColor(0);
                graphics.fillRect(0, n2 - 1, 320, n3 + 2);
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, n2, 320, n3);
                FontMgr.drawString(3, graphics, "" + n, 160, 111, 3);
                break;
            }
            case 6: {
                if (this.subType == 13) {
                    this.paintGameSpecificScreen(graphics);
                    break;
                }
                if (!isBonusGame || this.subType != 16) break;
                this.paintSudokuGame(graphics);
                break;
            }
            case 0: {
                this.paintGameSpecificScreen(graphics);
                break;
            }
            case 3: {
                Engine.paintTextBgRect(graphics, 5, 5, 310, 205, false, 16572104);
                int n = 17;
                if (isBonusGame) {
                    if (this.subType == 16) {
                        this.paintBonusGameResult(graphics);
                        break;
                    }
                    this.engine.crossPix.paint(graphics);
                    break;
                }
                boolean bl = !Engine.dailyExersize && this.medalAwarded >= 0;
                int n4 = 0;
                int n5 = FontMgr.lineHeight[n4] - 0;
                String string2 = "";
                string2 = this.gotBestScore && !Engine.dailyExersize ? Engine.text[229] : (this.medalAwarded == 2 ? Engine.text[230] : (this.medalAwarded == 1 ? Engine.text[231] : (this.medalAwarded == 0 ? Engine.text[232] : Engine.text[233])));
                FontMgr.drawString(n4, graphics, string2, 160, n += n5, 17);
                n += n5;
                int n6 = 0;
                int n7 = this.summaryBrain[0].width + 4 + FontMgr.stringWidth(3, "" + this.activityScore);
                int n8 = 320 - n7 >> 1;
                this.summaryBrain[0].drawImage(graphics, (320 - this.summaryBrain[0].width >> 1) - n6, n += n5 >> 1);
                int n9 = 20;
                int n10 = Engine.mul(this.resultFactor, this.summaryBrain[0].height - n9 << 8);
                int n11 = Engine.mul(Engine.div(Math.min(40, this.lastRoundChangeTick) << 8, 10240), n10) >> 8;
                if (this.stopFinalScoreTicking) {
                    n11 = Engine.mul(Engine.div(10240, 10240), n10) >> 8;
                    if (!Engine.dailyExersize) {
                        this.oldGeniusScore = this.oldGeniusScore + 121 < Engine.currentProfile.geniusScore ? (this.oldGeniusScore += 121) : Engine.currentProfile.geniusScore;
                    }
                }
                graphics.setClip(0, n + this.summaryBrain[0].height - n11 - (n9 >> 1), 320, n11);
                this.summaryBrain[1].drawImage(graphics, (320 - this.summaryBrain[0].width >> 1) - n6, n);
                int n12 = Engine.mul(Engine.div(n11 << 8, n10), 25600) >> 8;
                if (!this.stopFinalScoreTicking) {
                    this.animateScoreTicker = this.activityScore / 100 * n12;
                    if (n11 >= n10 >> 8) {
                        this.animateScoreTicker = this.activityScore;
                        this.stopFinalScoreTicking = true;
                    }
                }
                graphics.setClip(0, 0, 320, 222);
                FontMgr.drawString(12, graphics, this.animateScoreTicker + "", 160, n + (this.summaryBrain[0].height >> 1), 3);
                n += (n5 >> 1) + this.summaryBrain[1].height;
                graphics.setColor(16623722);
                int n13 = n5 * 4 - -3;
                if (Engine.dailyExersize) {
                    n13 = n5 * 3 - -3;
                }
                graphics.fillRect(10, n, 300, n13);
                graphics.setColor(16554063);
                graphics.fillRect(10, n + 1, 300, 1);
                graphics.fillRect(10, n + n13 - 2, 300, 1);
                String[] stringArray = new String[]{"" + this.numGoodResults};
                FontMgr.drawString(n4, graphics, Engine.getText(234, stringArray), 160, n += (n5 >> 1) - 0, 17);
                stringArray = new String[]{"" + this.numBadResults};
                FontMgr.drawString(n4, graphics, Engine.getText(235, stringArray), 160, n += n5, 17);
                if (!Engine.dailyExersize) {
                    stringArray = new String[]{"" + this.oldGeniusScore};
                    String string3 = Engine.getText(236, stringArray);
                    int n14 = FontMgr.stringWidth(n4, Engine.getText(236, new String[]{"" + Engine.currentProfile.geniusScore}));
                    FontMgr.drawString(n4, graphics, string3, 320 - n14 >> 1, n += n5, 20);
                }
                n += n5 + 3;
                n += n5;
                if (bl) {
                    this.imgMedals[this.medalAwarded].drawImage(graphics, 320 - this.imgMedals[0].width >> 1, n);
                    n += (n5 >> 1) + this.imgMedals[0].height;
                    for (int i = 0; i < this.theString.length; ++i) {
                        FontMgr.drawString(n4, graphics, this.theString[i], 160, n + i * FontMgr.lineHeight[n4], 17);
                    }
                }
                if (bl) break;
                n += n5;
                for (int i = 0; i < this.theString.length; ++i) {
                    FontMgr.drawString(n4, graphics, this.theString[i], 160, n + i * FontMgr.lineHeight[n4], 17);
                }
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                this.paintGameSpecificScreen(graphics);
                if (state == 2 && !isBonusGame) {
                    int n = 0;
                    if (!this.roundResult) {
                        n = 1;
                    }
                    int n15 = 320 - this.imgResult[n].width >> 1;
                    int n16 = 222 - this.imgResult[n].height >> 1;
                    if (this.lastRoundChangeTick % 6 >= 3) break;
                    this.imgResult[n].drawImage(graphics, n15, n16);
                    break;
                }
                if (state != 5) break;
                int n = Engine.rnd(3);
                int n17 = Engine.rnd(3);
                if (Engine.currentGameIndex == 16) {
                    n = 0;
                    n17 = 0;
                }
                this.imgTimeUp.drawImage(graphics, (320 - this.imgTimeUp.width >> 1) + n, (222 - this.imgTimeUp.height >> 1) + n17);
                int n18 = 121;
                FontMgr.drawString(0, graphics, Engine.text[253], 160, n18, 3);
            }
        }
    }

    public void fillGameBg(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(n);
        graphics.fillRect(n2, n3, 320, 222);
    }

    private void paintGameBackdrop(Graphics graphics, int n, int n2) {
        if (this.imgSetting != null) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(n, n2, 320, 222);
            this.imgSetting.drawImage(graphics, n, n2);
        } else if (!isBonusGame) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, 320, 222);
            switch (Engine.currentGameIndex) {
                case 2: {
                    this.fillGameBg(graphics, 0, n, n2);
                    break;
                }
                case 11: {
                    this.fillGameBg(graphics, 0, n, n2);
                    break;
                }
                default: {
                    this.fillGameBg(graphics, 14525815, n, n2);
                }
            }
        }
        if (!isBonusGame) {
            this.paintTxtOverlay(graphics);
        }
    }

    public static void paintOutlinedRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(n6);
        graphics.drawRect(n - 1, n2 - 1, n3 + 1, n4 + 1);
        graphics.setColor(n5);
        graphics.fillRect(n, n2, n3, n4);
    }

    public void initOrderGameRound() {
        int n;
        this.orderIndex = -1;
        int n2 = 2;
        switch (Engine.currentDifficulty) {
            case 0: {
                this.numActiveOptions = 3;
                n2 += this.numGoodResults >> 1;
                n2 = Math.min(4, n2);
                this.orderDelay = 15 + n2 - (this.numGoodResults >> 1) - this.currentRound;
                break;
            }
            case 1: {
                n2 = 3 + (this.numGoodResults >> 1);
                n2 = Math.min(6, n2);
                this.orderDelay = 15 + n2 - (this.numGoodResults >> 1) - this.currentRound;
                this.numActiveOptions = 4;
                break;
            }
            case 2: {
                n2 = 5 + (this.numGoodResults >> 2);
                n2 = Math.min(8, n2);
                this.orderDelay = 15 + n2 - (this.numGoodResults >> 1) - this.currentRound;
                this.numActiveOptions = 4;
            }
        }
        this.orderDelay = Math.max(14, this.orderDelay);
        this.wantedOrder = new int[n2];
        this.lastRoundChangeTick = 0;
        if (this.subType == 4) {
            this.wantedOrder = new int[this.telephone_numbers_length];
            for (n = 0; n < this.wantedOrder.length; ++n) {
                this.wantedOrder[n] = Engine.rndPositive(10);
                if (n > 0 && this.wantedOrder[n] == this.wantedOrder[n - 1]) {
                    --n;
                }
                this.the_number = this.the_number + "" + this.wantedOrder[n];
            }
        } else {
            for (n = 0; n < this.wantedOrder.length; ++n) {
                this.wantedOrder[n] = Engine.rndPositive(this.numActiveOptions);
                if (n <= 0 || this.wantedOrder[n] != this.wantedOrder[n - 1]) continue;
                --n;
            }
        }
        this.achievedOrder = new int[this.wantedOrder.length];
        for (n = 0; n < this.wantedOrder.length; ++n) {
            this.achievedOrder[n] = -1;
        }
    }

    public void tickOrderIncrement() {
        ++this.lastRoundChangeTick;
        if (this.lastRoundChangeTick == this.orderDelay) {
            this.lastRoundChangeTick = 0;
            ++this.orderIndex;
            if (this.orderIndex == this.wantedOrder.length) {
                this.orderIndex = 0;
                Engine.resetKeyBuffers();
                String string = Engine.getText(260, new String[]{this.engine.getRankText(this.chosenFruit + 1)});
                this.initProfessorText(string);
                state = 1;
            }
        }
    }

    public void tickOrderGame() {
        switch (state) {
            case 0: {
                this.tickOrderIncrement();
                break;
            }
            case 1: {
                int n;
                boolean bl = false;
                for (n = 0; n < this.orderIndex; ++n) {
                    if (this.achievedOrder[n] == this.wantedOrder[n]) continue;
                    bl = true;
                }
                if (this.checkOrderGameResult()) {
                    this.orderIndex = this.achievedOrder.length;
                    this.endRound();
                    break;
                }
                if (this.orderIndex == this.achievedOrder.length || bl) {
                    ++this.lastRoundChangeTick;
                    if (this.lastRoundChangeTick <= 0) break;
                    this.lastRoundChangeTick = 0;
                    this.endRound();
                    break;
                }
                n = -1;
                if (Engine.key(1)) {
                    n = 1;
                } else if (Engine.key(2) && this.numActiveOptions > 3) {
                    n = 3;
                } else if (Engine.key(4)) {
                    n = 0;
                } else if (Engine.key(8)) {
                    n = 2;
                }
                if (n == -1) break;
                this.flashItemIndex = n;
                if (this.orderIndex < this.achievedOrder.length) {
                    this.achievedOrder[this.orderIndex] = n;
                }
                Engine.resetKeyBuffers();
                ++this.orderIndex;
                if (this.orderIndex != this.achievedOrder.length) break;
                this.lastRoundChangeTick = 0;
            }
        }
    }

    public boolean checkOrderGameResult() {
        boolean bl = true;
        for (int i = 0; i < this.achievedOrder.length; ++i) {
            if (this.achievedOrder[i] == this.wantedOrder[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void paintOrderGame(Graphics graphics) {
        int n = 24;
        int n2 = 160;
        int n3 = 0;
        n3 = this.imgKeyPad != null ? this.imgKeyPad.height : 0;
        int n4 = 39;
        switch (state) {
            case 0: {
                int n5;
                n4 = 24 + (this.imgSettingHeight >> 1);
                n = 55;
                graphics.setColor(0x808080);
                if (this.imgPreview != null) {
                    this.imgPreview.drawImageNoClipping(graphics, 320 - this.imgPreview.width >> 1, n4 - (this.imgPreview.height >> 1));
                } else if (this.imgOrderLarge != null) {
                    graphics.setColor(0xFFFFFF);
                    n5 = this.imgOrderLarge[0].width + (this.imgOrderLarge[0].width >> 1);
                    graphics.fillRoundRect(320 - n5 >> 1, n4 - (n5 >> 1), n5, n5, 8, 8);
                    graphics.setColor(0x848284);
                    graphics.drawRoundRect(320 - n5 >> 1, n4 - (n5 >> 1), n5, n5, 8, 8);
                }
                if (this.orderIndex == -1) break;
                switch (this.subType) {
                    case 3: {
                        n5 = this.imgOrderLarge[this.wantedOrder[this.orderIndex]].width >> 1;
                        this.imgOrderLarge[this.wantedOrder[this.orderIndex]].drawImage(graphics, n2 - n5, n4 - n5);
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                this.imgKeyPad.drawImage(graphics, 320 - this.imgKeyPad.width >> 1, n4);
                for (int i = 0; i < this.numActiveOptions; ++i) {
                    int n6;
                    if (i == 0 || i == 2) {
                        n6 = n2 - (this.imgKeyPad.width >> 1) + (28 - this.imgOrder[i].width >> 1) + 1;
                        if (i == 2) {
                            n6 = n2 + (this.imgKeyPad.width >> 1) - 14 - (this.imgOrder[i].width >> 1) - 1;
                        }
                        if (this.flashItemIndex != i) {
                            switch (this.subType) {
                                case 3: {
                                    this.imgOrder[i].drawImage(graphics, n6, n4 + (n3 >> 1) - (this.imgOrder[i].height >> 1));
                                }
                            }
                        }
                    }
                    if (i != 1 && i != 3) continue;
                    n6 = n4 + (28 - this.imgOrder[i].width >> 1) + 1;
                    if (i == 3) {
                        n6 = n4 + this.imgKeyPad.height - 28 - 1;
                    }
                    if (this.flashItemIndex == i) continue;
                    switch (this.subType) {
                        case 3: {
                            this.imgOrder[i].drawImage(graphics, 320 - this.imgOrder[i].width >> 1, n6);
                        }
                    }
                }
                this.setKeyPadTouchZone();
                this.flashItemIndex = -1;
            }
        }
    }

    public void paintOrderSequence(Graphics graphics, int[] nArray, int n) {
        int n2 = 24;
        int n3 = 4;
        int n4 = nArray.length * (n2 + n3);
        int n5 = (320 - n4 >> 1) + 2;
        int n6 = 39;
        n6 += 2;
        for (int i = 0; i < nArray.length; ++i) {
            GameWorld.paintOutlinedRect(graphics, n5 - 1, n6 - 1, n2 + 1, n2 + 1, 0xFFFFFF, 0xFFFFFF);
            if (i < n && nArray[i] >= 0) {
                switch (this.subType) {
                    case 3: {
                        this.imgOrderSmall[nArray[i]].drawImage(graphics, n5 + (n2 >> 1) - (this.imgOrderSmall[nArray[i]].width >> 1), n6 + (n2 >> 1) - (this.imgOrderSmall[nArray[i]].height >> 1));
                    }
                }
            }
            n5 += n2 + n3;
        }
    }

    public void initSumsGameRound() {
        this.initNumberInput();
        this.currentFactors = new int[2];
        this.achievedSum = Integer.MIN_VALUE;
        this.currentOperand = Engine.rndPositive(4);
        this.orderIndex = -1;
        this.orderDelay = 15 - this.currentRound;
        switch (this.subType) {
            case 0: 
            case 10: {
                this.fillOperand();
            }
        }
        this.wantedSum = this.calculateSum();
    }

    public void fillOperand() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        switch (Engine.currentDifficulty) {
            case 0: {
                this.currentOperand = Engine.rndPositive(2);
                n = 10 + this.numGoodResults;
                n2 = this.numGoodResults;
                n3 = 50;
                break;
            }
            case 1: {
                n = 20 + (this.numGoodResults << 1);
                this.currentOperand = Engine.rndPositive(4);
                n2 = 10;
                n = Math.min(n, 35);
                n3 = 100;
                break;
            }
            case 2: {
                n = 30 + (this.numGoodResults << 1);
                n2 = 100;
                this.currentOperand = Engine.rndPositive(4);
                n3 = 999;
            }
        }
        if (this.subType == 10) {
            n2 = 10;
            n3 = 99;
            if (this.currentOperand >= 2) {
                n = Math.min(n / (1 + Engine.currentDifficulty), 98);
            }
        }
        switch (this.currentOperand) {
            case 0: {
                n = Math.min(n, 20);
                this.currentFactors[0] = n2 + Engine.rndPositive(n);
                this.currentFactors[1] = n2 + Engine.rndPositive(n);
                this.currentFactors[0] = Math.min(this.currentFactors[0], 499);
                this.currentFactors[1] = Math.min(this.currentFactors[1], 499);
                if (this.subType != 10) break;
                this.currentFactors[0] = Math.min(this.currentFactors[0], 49);
                this.currentFactors[1] = Math.min(this.currentFactors[1], 49);
                break;
            }
            case 1: {
                n = Math.min(n, 60);
                this.currentFactors[0] = n2 + Engine.rndPositive(n * (1 + Engine.currentDifficulty));
                this.currentFactors[1] = Engine.rndPositive(this.currentFactors[0] - 1);
                this.currentFactors[0] = Math.min(this.currentFactors[0], 999);
                this.currentFactors[1] = Math.min(this.currentFactors[1], 999);
                if (this.subType != 10) break;
                this.currentFactors[0] = Math.min(this.currentFactors[0], 99);
                this.currentFactors[1] = Math.min(this.currentFactors[1], 99);
                break;
            }
            case 2: {
                do {
                    this.currentFactors[0] = 1 + Engine.rndPositive(n);
                    this.currentFactors[1] = 1 + Engine.rndPositive(n);
                } while (this.currentFactors[0] * this.currentFactors[1] > n3);
                break;
            }
            case 3: {
                this.currentFactors[0] = 1;
                this.currentFactors[1] = 1;
                while (this.currentFactors[1] == 1 || this.currentFactors[1] == this.currentFactors[0]) {
                    this.currentFactors[0] = n2 + Engine.rndPositive(n * (1 + Engine.currentDifficulty));
                    this.currentFactors[1] = Engine.rndPositive(n * (1 + Engine.currentDifficulty)) + 1;
                    while (this.currentFactors[0] % this.currentFactors[1] != 0 && this.currentFactors[0] % this.currentFactors[1] < n3) {
                        this.currentFactors[1] = Engine.rndPositive(n * (1 + Engine.currentDifficulty)) + 1;
                    }
                }
                break;
            }
        }
    }

    public int calculateSum() {
        switch (this.subType) {
            case 0: 
            case 10: {
                switch (this.currentOperand) {
                    case 0: {
                        return this.currentFactors[0] + this.currentFactors[1];
                    }
                    case 1: {
                        return this.currentFactors[0] - this.currentFactors[1];
                    }
                    case 2: {
                        return this.currentFactors[0] * this.currentFactors[1];
                    }
                    case 3: {
                        return this.currentFactors[0] / this.currentFactors[1];
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public boolean checkSumGameResult() {
        return this.wantedSum == this.achievedSum;
    }

    private void initProfessorText(String string) {
        int n = 0;
        if (state == 3) {
            n = 10;
        }
        this.theString = Engine.getStrings(string, 259 - n, 0);
    }

    private void paintTextInfo(Graphics graphics, String string) {
        int n = 0;
        n += 59;
        if (this.theString == null) {
            return;
        }
        this.paintTxtOverlay(graphics);
        int n2 = 0;
        String string2 = "";
        if (this.theString.length <= 1) {
            FontMgr.drawString(n2, graphics, this.theString[0] + string, n, this.displayInfoTextY + FontMgr.lineHeight[n2] - 1, 6);
        } else {
            for (int i = 0; i < this.theString.length; ++i) {
                if (i == this.theString.length - 1) {
                    string2 = string;
                }
                FontMgr.drawString(n2, graphics, this.theString[i] + string2, n, this.displayInfoTextY + i * FontMgr.lineHeight[n2], 20);
            }
        }
    }

    public boolean allEqual(int[] nArray) {
        int n = nArray[0];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == n) continue;
            return false;
        }
        return true;
    }

    public void initGridGameRound() {
        this.lastRoundChangeTick = 0;
        switch (this.subType) {
            case 16: {
                int n;
                int n2;
                int n3;
                this.GRID_WIDTH = 9;
                this.GRID_HEIGHT = 9;
                int n4 = 50;
                this.wantedGrid = new int[this.GRID_WIDTH * this.GRID_WIDTH];
                this.achievedGrid = new int[this.wantedGrid.length];
                this.gridState = new int[this.wantedGrid.length];
                this.cellState = new int[this.wantedGrid.length];
                this.cellWipeWidth = 0;
                this.xPos = 0;
                this.yPos = 0;
                this.sudokuTransitionType = Engine.rndPositive(5);
                int n5 = 18 * this.GRID_WIDTH >> 1;
                this.sudokuGridTopLeftPosX = 160 - n5;
                this.sudokuGridTopLeftPosY = 30;
                this.sudokuGridTopLeftPosY += 10;
                int n6 = 212 + Engine.rndPositive(n4);
                byte[] byArray = ResourceMaster.getResource(n6);
                int n7 = 0;
                for (n3 = 0; n3 < 81; ++n3) {
                    n2 = n3;
                    n = byArray[n2] & 0xF;
                    int n8 = (byArray[n2] & 0xFF) >> 7;
                    this.wantedGrid[n3] = n;
                    if (n8 == 1) {
                        this.achievedGrid[n3] = n;
                        this.gridState[n3] = 2;
                        this.cellState[n3] = 1;
                        continue;
                    }
                    ++n7;
                    this.achievedGrid[n3] = -1;
                    this.cellState[n3] = 0;
                }
                n3 = 10;
                if (!isBonusGame) {
                    switch (Engine.currentDifficulty) {
                        case 0: {
                            n3 = 3 + Math.min(4, this.currentRound / 3);
                            break;
                        }
                        case 1: {
                            n3 = 5 + Math.min(5, this.currentRound / 2);
                            break;
                        }
                        case 2: {
                            n3 = 7 + Math.min(7, this.currentRound);
                        }
                    }
                } else {
                    switch (Engine.currentDifficulty) {
                        case 0: {
                            n3 = 15;
                            break;
                        }
                        case 1: {
                            n3 = 30;
                        }
                    }
                }
                if (Engine.currentDifficulty != 2 || !isBonusGame) {
                    while (n7 > n3) {
                        n2 = Engine.rndPositive(this.achievedGrid.length);
                        if (this.achievedGrid[n2] == -1) {
                            this.gridState[n2] = 2;
                            this.achievedGrid[n2] = this.wantedGrid[n2];
                            this.cellState[n2] = 1;
                        }
                        n7 = 0;
                        for (n = 0; n < this.achievedGrid.length; ++n) {
                            if (this.achievedGrid[n] != -1) continue;
                            ++n7;
                        }
                    }
                }
                this.sgSpriteArray = new SGSprite[2];
                this.sgSpriteUsed = new boolean[2];
                for (n2 = 0; n2 < this.sgSpriteUsed.length; ++n2) {
                    this.sgSpriteArray[n2] = new SGSprite(this.sgSprite);
                    this.sgSpriteUsed[n2] = false;
                }
                break;
            }
        }
    }

    public boolean checkGridGameResult() {
        for (int i = 0; i < this.wantedGrid.length; ++i) {
            if (this.wantedGrid[i] == this.achievedGrid[i]) continue;
            return false;
        }
        return true;
    }

    public void tickGridGame() {
        switch (state) {
            case 0: {
                switch (this.subType) {
                    case 16: {
                        this.tickSudokuGridTransition();
                        break;
                    }
                    case 17: {
                        this.lastRoundChangeTick = 0;
                        Engine.resetKeyBuffers();
                        state = 1;
                        CrossPix.startTime = System.currentTimeMillis();
                    }
                }
                break;
            }
            case 1: {
                switch (this.subType) {
                    case 16: {
                        if (this.checkGridGameResult()) {
                            this.endRound();
                        }
                        this.tickSudokuGrid();
                        break;
                    }
                    case 17: {
                        this.engine.crossPix.tick();
                    }
                }
                break;
            }
            case 2: {
                this.tickSudokuGrid();
            }
        }
    }

    public void wrapXYPos() {
        int n = this.GRID_HEIGHT;
        if (this.xPos < 0) {
            this.xPos = this.GRID_WIDTH - 1;
        }
        if (this.xPos >= this.GRID_WIDTH) {
            this.xPos = 0;
        }
        if (this.yPos < 0) {
            this.yPos = n - 1;
        }
        if (this.yPos >= this.GRID_HEIGHT) {
            this.yPos = 0;
        }
    }

    public void tickSudokuGrid() {
        int n;
        int n2;
        ++this.lastRoundChangeTick;
        if (this.subType == 16 && (this.currentOperand == 1 || SUDOKU_CONTROL_MODE == 1 && Engine.keyUnmapped > 48 && Engine.keyUnmapped < 58)) {
            if (Engine.keyUnmapped > 48 && Engine.keyUnmapped < 58 && this.gridState[this.xPos + this.yPos * this.GRID_WIDTH] != 2) {
                n2 = Engine.keyUnmapped - 48;
                if (this.achievedGrid[this.xPos + this.yPos * this.GRID_WIDTH] == n2) {
                    return;
                }
                n = 0;
                for (int i = 0; i < this.sgSpriteUsed.length; ++i) {
                    if (this.sgSpriteUsed[i]) continue;
                    n = 1;
                    break;
                }
                this.calculatorButtonPressed = n2;
                this.lastRoundChangeTick = 0;
                Engine.resetAllKeyBuffers();
                if (n != 0) {
                    switch (this.cellState[this.xPos + this.yPos * this.GRID_WIDTH]) {
                        case 0: 
                        case 1: {
                            this.achievedGrid[this.xPos + this.yPos * this.GRID_WIDTH] = n2;
                            this.currentOperand = 0;
                            this.gridState[this.xPos + this.yPos * this.GRID_WIDTH] = 0;
                            this.setCellAnimation();
                            break;
                        }
                    }
                }
            }
        } else if (SUDOKU_CONTROL_MODE != 1 || Engine.keyUnmapped <= 48 || Engine.keyUnmapped >= 58) {
            if (Engine.key(1)) {
                --this.yPos;
            } else if (Engine.key(2)) {
                ++this.yPos;
            } else if (Engine.key(8)) {
                ++this.xPos;
            } else if (Engine.key(4)) {
                --this.xPos;
            }
            Engine.resetAllKeyBuffers();
        }
        this.wrapXYPos();
        if (this.lastRoundChangeTick > 2) {
            this.calculatorButtonPressed = -1;
        }
        block8: for (n2 = 0; n2 < this.cellState.length; ++n2) {
            switch (this.cellState[n2]) {
                case 0: {
                    continue block8;
                }
                case 2: 
                case 3: {
                    for (n = 0; n < this.sgSpriteArray.length; ++n) {
                        if (!this.sgSpriteUsed[n]) continue;
                        this.sgSpriteArray[n].tickAnimation(50);
                        if (!this.sgSpriteArray[n].animationDone) continue;
                        this.cellState[n2] = 1;
                        this.sgSpriteUsed[n] = false;
                        continue block8;
                    }
                    continue block8;
                }
            }
        }
        Engine.resetAllKeyBuffers();
    }

    public void setCellAnimation() {
        switch (this.cellState[this.xPos + this.yPos * this.GRID_WIDTH]) {
            case 0: {
                for (int i = 0; i < this.sgSpriteArray.length; ++i) {
                    if (this.sgSpriteUsed[i]) continue;
                    this.sgSpriteArray[i].startAnimation(0 + Engine.rndPositive(4), 1);
                    this.sgSpriteArray[i].setPosition(this.sudokuGridTopLeftPosX + this.xPos * this.GRID_RECT_SIZE + 1, this.sudokuGridTopLeftPosY + this.yPos * this.GRID_RECT_SIZE + 1);
                    this.sgSpriteUsed[i] = true;
                    break;
                }
                this.cellState[this.xPos + this.yPos * this.GRID_WIDTH] = 2;
                break;
            }
            case 1: {
                for (int i = 0; i < this.sgSpriteArray.length; ++i) {
                    if (this.sgSpriteUsed[i]) continue;
                    this.sgSpriteArray[i].startAnimation(4 + Engine.rndPositive(4), 1);
                    this.sgSpriteArray[i].setPosition(this.sudokuGridTopLeftPosX + this.xPos * this.GRID_RECT_SIZE + 1, this.sudokuGridTopLeftPosY + this.yPos * this.GRID_RECT_SIZE + 1);
                    this.sgSpriteUsed[i] = true;
                    break;
                }
                this.cellState[this.xPos + this.yPos * this.GRID_WIDTH] = 3;
            }
        }
    }

    public void tickSudokuGridTransition() {
        this.cellWipeWidth = this.sudokuTransitionType == 4 ? (this.cellWipeWidth += HALF_PRECISION) : (this.cellWipeWidth += 256);
        if (this.cellWipeWidth >> 8 >= 18) {
            this.lastRoundChangeTick = 0;
            state = 1;
            Engine.resetAllKeyBuffers();
        }
    }

    public void touchSudokuGrid(int n, int n2) {
    }

    public void paintSudokuGrid(Graphics graphics, int[] nArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = n4 = this.sudokuGridTopLeftPosX;
        int n6 = this.sudokuGridTopLeftPosY;
        int n7 = 11;
        int n8 = n6;
        graphics.setColor(0xFFFFFF);
        for (n3 = 0; n3 < this.GRID_HEIGHT; ++n3) {
            for (n2 = 0; n2 < this.GRID_WIDTH; ++n2) {
                if (this.gridState[n3 * this.GRID_WIDTH + n2] == 0 || state == 4 || state == 6) {
                    graphics.setColor(0xFFFFFF);
                } else {
                    graphics.setColor(12968956);
                }
                graphics.fillRect(n5, n8, 18, 18);
                if (nArray[n3 * this.GRID_WIDTH + n2] > 0 && state != 4 && state != 6) {
                    FontMgr.drawString(n7, graphics, "" + nArray[n3 * this.GRID_WIDTH + n2], n5 + 9, n8 + 9, 3);
                }
                if (state == 0 && this.gridState[n3 * this.GRID_WIDTH + n2] == 2) {
                    graphics.setColor(0xFFFFFF);
                    int n9 = this.cellWipeWidth >> 8;
                    switch (this.sudokuTransitionType) {
                        case 0: {
                            graphics.fillRect(n5 + n9, n8, 18 - n9, 18);
                            break;
                        }
                        case 1: {
                            graphics.fillRect(n5, n8, 18 - n9, 18);
                            break;
                        }
                        case 2: {
                            graphics.fillRect(n5, n8 + n9, 18, 18 - n9);
                            break;
                        }
                        case 3: {
                            graphics.fillRect(n5, n8, 18, 18 - n9);
                            break;
                        }
                        case 4: {
                            graphics.fillRect(n5 + n9, n8 + n9, 18 - (n9 << 1), 18 - (n9 << 1));
                        }
                    }
                }
                graphics.setColor(8502229);
                graphics.drawRect(n5, n8, 18, 18);
                n5 += 18;
            }
            n5 = n4;
            n8 += 18;
        }
        n5 = n4;
        n8 = n6;
        for (n3 = 0; n3 < this.GRID_HEIGHT / 3; ++n3) {
            for (n2 = 0; n2 < this.GRID_WIDTH / 3; ++n2) {
                graphics.setColor(0);
                graphics.drawRect(n5, n8, 54, 54);
                graphics.setColor(0);
                graphics.drawRect(n5 + 1 + (n2 > 0 ? -1 : 0), n8 + 1, 54 + (n2 > 0 ? -1 : 0), 54 + (n3 == 2 ? -2 : -1));
                n5 += 54;
            }
            n5 = n4;
            n8 += 54;
        }
    }

    public void paintSudokuBufferGrid(Graphics graphics, int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4 = n3 = 0;
        int n5 = 0;
        int n6 = 11;
        int n7 = n5;
        graphics.setColor(0xFFFFFF);
        for (n2 = 0; n2 < this.GRID_HEIGHT; ++n2) {
            for (n = 0; n < this.GRID_WIDTH; ++n) {
                if (this.gridState[n2 * this.GRID_WIDTH + n] == 0) {
                    graphics.setColor(0xFFFFFF);
                } else {
                    graphics.setColor(12968956);
                }
                graphics.fillRect(n4, n7, 18, 18);
                if (nArray[n2 * this.GRID_WIDTH + n] > 0 && state != 4 && state != 6) {
                    FontMgr.drawString(n6, graphics, "" + nArray[n2 * this.GRID_WIDTH + n], n4 + 9, n7 + 9, 3);
                }
                graphics.setColor(8502229);
                graphics.drawRect(n4, n7, 18, 18);
                n4 += 18;
            }
            n4 = n3;
            n7 += 18;
        }
        n4 = n3;
        n7 = n5;
        for (n2 = 0; n2 < this.GRID_HEIGHT / 3; ++n2) {
            for (n = 0; n < this.GRID_WIDTH / 3; ++n) {
                graphics.setColor(0);
                graphics.drawRect(n4, n7, 54, 54);
                graphics.setColor(0);
                graphics.drawRect(n4 + 1 + (n > 0 ? -1 : 0), n7 + 1, 54 + (n > 0 ? -1 : 0), 54 + (n2 == 2 ? -2 : -1));
                n4 += 54;
            }
            n4 = n3;
            n7 += 54;
        }
    }

    public void paintSudokuSprite(Graphics graphics) {
        if (state == 1) {
            int n;
            for (n = 0; n < this.sgSpriteArray.length; ++n) {
                if (!this.sgSpriteUsed[n]) continue;
                this.sgSpriteArray[n].paint(graphics, 0, 0);
            }
            n = this.sudokuGridTopLeftPosX + this.xPos * this.GRID_RECT_SIZE;
            int n2 = this.sudokuGridTopLeftPosY + this.yPos * this.GRID_RECT_SIZE;
            this.sudokuCursor.setPosition(n - (this.sudokuCursor.getWidth() - 18 >> 1), n2 - (this.sudokuCursor.getHeight() - 18 >> 1));
            this.sudokuCursor.paint(graphics, 0, 0);
        }
    }

    public void paintSudokuGame(Graphics graphics) {
        if (this.imgBuffGrid != null) {
            // empty if block
        }
        this.paintSudokuGrid(graphics, this.achievedGrid, 0);
    }

    public void paintGridGame(Graphics graphics) {
        block0 : switch (state) {
            case 0: {
                switch (this.subType) {
                    case 16: {
                        this.paintSudokuGame(graphics);
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                switch (this.subType) {
                    case 16: {
                        this.paintSudokuGame(graphics);
                        this.paintSudokuSprite(graphics);
                        break block0;
                    }
                }
            }
        }
    }

    public void proceedFromFinalResult() {
        if (!this.stopFinalScoreTicking && this.animateScoreTicker < this.activityScore) {
            this.stopFinalScoreTicking = true;
            this.animateScoreTicker = this.activityScore;
            if (Engine.dailyExersize) {
                // empty if block
            }
            return;
        }
        if (!Engine.dailyExersize && !this.stopGeniusScoreTicking && this.oldGeniusScore < Engine.currentProfile.geniusScore) {
            this.stopGeniusScoreTicking = true;
            this.oldGeniusScore = Engine.currentProfile.geniusScore;
            return;
        }
        if (!Engine.dailyExersize) {
            if (Engine.text[293].length() > 0 && Engine.unlockedDifficulty == -1 && Engine.currentProfile.numTotalActivitiesPlayed % 4 == 0) {
                Engine.showTrivia = true;
                ++Engine.currentProfile.triviaToShow;
            }
            this.engine.goToMainMenuFromGame(Engine.menuMain);
        } else {
            ++Engine.currentTodaysGameIndex;
            this.engine.startNextTodaysGame();
        }
    }

    public static int scaleGameX(int n) {
        return 0;
    }

    public static int scaleGameY(int n) {
        return 0;
    }

    public static int scaleToBaseX(int n) {
        return 0;
    }

    public static int scaleToBaseY(int n) {
        return 0;
    }

    public void initNewBG2Games() {
        this.PLAY_AREA_Y = 24;
        this.PLAY_AREA_HEIGHT = this.imgSettingHeight;
        this.clipHeight = this.imgSettingHeight - 1;
        this.PLAY_AREA_X = 20;
        this.PLAY_AREA_WIDTH = 280;
        Engine.resetKeyBuffers();
        Engine.keysPressed = 0;
        this.gameTicker = 0;
        this.calculatorButtonPressed = -1;
        switch (this.type) {
            case 2: {
                this.initCalculationGames();
                break;
            }
            case 0: {
                this.initObservationGames();
                break;
            }
            case 1: {
                this.initMemoryGames();
                break;
            }
            case 3: {
                this.initReasoningGames();
            }
        }
    }

    public void initCalculationGames() {
        switch (this.subType) {
            case 0: {
                int n;
                this.wantedSum = Integer.MIN_VALUE;
                this.achievedSum = Integer.MIN_VALUE;
                this.initSumsGameRound();
                this.copyOfWantedSum = this.wantedSum;
                this.chosenSideToHide = Engine.rndPositive(3);
                if (this.chosenSideToHide == 0) {
                    this.wantedSum = this.currentFactors[0];
                } else if (this.chosenSideToHide == 1) {
                    this.wantedSum = this.currentFactors[1];
                }
                this.sgSpriteArray = new SGSprite[10];
                int n2 = 320 - this.imgSettingWidth >> 1;
                int n3 = 24;
                for (n = 0; n < this.sgSpriteArray.length; ++n) {
                    this.sgSpriteArray[n] = new SGSprite(this.sgSprite);
                }
                n = 147;
                int n4 = 83;
                this.sgSpriteArray[0].setPosition(n2 + n4, n3 + n);
                n3 = this.sgSpriteArray[0].getY() - 26;
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        this.sgSpriteArray[1 + i * 3 + j].setPosition(n2 + n4 + j * 32, n3 - i * 26);
                    }
                }
                this.calculatorButtonPressed = -1;
                break;
            }
            case 6: {
                int n;
                int n5;
                int n6;
                this.initNumberInput();
                this.wantedSum = 0;
                this.achievedSum = Integer.MIN_VALUE;
                this.shapeWidth = this.imgOrderLarge[0].width;
                this.shapeHeight = this.imgOrderLarge[0].height + this.imgOrderLarge[1].height;
                int n7 = 0;
                this.vel = 1024;
                int n8 = 4;
                switch (Engine.currentDifficulty) {
                    case 0: {
                        this.boxes_order = new int[2];
                        n7 = 3 + Engine.rndPositive(n8 * this.boxes_order.length - 3);
                        n7 = Math.min(n7, n8 * this.boxes_order.length);
                        break;
                    }
                    case 1: {
                        this.boxes_order = new int[3];
                        n8 = 5;
                        n6 = 5 + this.numGoodResults;
                        n6 = Math.min(n6, n8 * this.boxes_order.length);
                        n5 = 0;
                        if (n6 >= n8 * this.boxes_order.length - 4) {
                            n5 = 4;
                        }
                        n7 = 4 + Engine.rndPositive(n6 - n5);
                        n7 = Math.min(n7, n8 * this.boxes_order.length);
                        break;
                    }
                    case 2: {
                        this.boxes_order = new int[4];
                        n8 = 6;
                        n6 = 10 + this.numGoodResults;
                        n6 = Math.min(n6, n8 * this.boxes_order.length);
                        n5 = 0;
                        if (n6 >= n8 * this.boxes_order.length - 4) {
                            n5 = 4;
                        }
                        n7 = 5 + Engine.rndPositive(n6 - n5);
                        n7 = Math.min(n7, n8 * this.boxes_order.length);
                    }
                }
                n6 = 0;
                n5 = n7;
                for (n = 0; n < this.boxes_order.length; ++n) {
                    if (n == this.boxes_order.length - 1) {
                        this.boxes_order[n] = n5;
                    } else {
                        n6 = n5 / this.boxes_order.length + Engine.rndPositive(n5 / this.boxes_order.length);
                        this.boxes_order[n] = n6 = Math.min(n6, n8);
                        n5 = n5 - n6 >= 0 ? (n5 -= n6) : 0;
                    }
                    this.wantedSum += this.boxes_order[n];
                }
                if (this.boxes_order[this.boxes_order.length - 1] > n8) {
                    int n9 = this.boxes_order.length - 1;
                    this.boxes_order[n9] = this.boxes_order[n9] - 1;
                    for (n = 0; n < this.boxes_order.length - 1; ++n) {
                        if (this.boxes_order[n] >= n8) continue;
                        int n10 = n;
                        this.boxes_order[n10] = this.boxes_order[n10] + 1;
                        break;
                    }
                    this.wantedSum = 0;
                    for (n = 0; n < this.boxes_order.length; ++n) {
                        this.wantedSum += this.boxes_order[n];
                    }
                }
                this.removedBoxIndex = Engine.rndPositive(this.boxes_order.length);
                this.wantedSum -= this.boxes_order[this.removedBoxIndex];
                this.current_box = 0;
                this.setToysOrder(this.current_box);
                this.imgTopCrate = new DeviceImage[this.boxes_order.length];
                this.imgBottomCrate = new DeviceImage[this.boxes_order.length];
                for (n = 0; n < this.boxes_order.length; ++n) {
                    int n11 = Engine.rndPositive(3);
                    this.imgTopCrate[n] = this.imgOrderLarge[n11 << 1];
                    this.imgBottomCrate[n] = this.imgOrderLarge[(n11 << 1) + 1];
                }
                this.shapesPos = new int[2];
                this.shapesPos[1] = this.PLAY_AREA_Y - this.imgOrderSmall[0].height;
                this.all_boxes_filled = false;
                this.chosenFruitAmount = 0;
                this.finishCycle = false;
                this.flashAmount = 0;
                this.initProfessorText(Engine.text[258]);
                break;
            }
            case 10: {
                int n;
                int n12;
                int n13;
                this.wantedSum = Integer.MIN_VALUE;
                this.achievedSum = Integer.MIN_VALUE;
                this.initSumsGameRound();
                this.chosenSideToHide = 2;
                this.gridHeight = 1;
                this.gridWidth = 3;
                this.totalNumberOfCards = 3;
                switch (Engine.currentDifficulty) {
                    case 0: {
                        this.gridWidth += this.numGoodResults >> 2;
                        this.gridWidth = Math.min(7, this.gridWidth);
                        break;
                    }
                    case 1: {
                        this.gridHeight = 2;
                        this.gridWidth = 2;
                        this.gridWidth += this.numGoodResults >> 2;
                        this.gridWidth = Math.min(5, this.gridWidth);
                        break;
                    }
                    case 2: {
                        this.gridHeight = 2;
                        this.gridWidth = 2;
                        this.gridWidth += this.numGoodResults >> 1;
                        this.gridWidth = Math.min(6, this.gridWidth);
                    }
                }
                this.orderDelay = 20;
                this.gridArray = new int[this.gridHeight][this.gridWidth];
                this.cardState = new int[this.gridHeight][this.gridWidth];
                this.cardState1 = new int[this.gridHeight * this.gridWidth];
                this.gridArray1 = new int[this.gridHeight * this.gridWidth];
                Vector<String> vector = new Vector<String>();
                vector.addElement("" + this.wantedSum);
                for (n13 = 1; n13 < this.gridHeight * this.gridWidth; ++n13) {
                    n12 = 1;
                    while (n12 != 0) {
                        int n14;
                        int n15;
                        boolean bl;
                        n = Engine.rndPositive(100);
                        if (this.wantedSum > 10 && this.wantedSum < 90) {
                            if (n13 < (this.gridHeight * this.gridWidth >> 1) + 1) {
                                n = this.wantedSum - 10 + Engine.rndPositive(3) * 10;
                                bl = false;
                                for (n15 = 0; n15 < vector.size(); ++n15) {
                                    n14 = Integer.parseInt((String)vector.elementAt(n15));
                                    if (n != n14) continue;
                                    bl = true;
                                    break;
                                }
                                if (bl) {
                                    n = this.wantedSum - (this.gridHeight * this.gridWidth >> 1) + Engine.rndPositive(this.gridHeight * this.gridWidth + 2);
                                }
                            } else {
                                n = this.wantedSum - (this.gridHeight * this.gridWidth >> 1) + Engine.rndPositive(this.gridHeight * this.gridWidth + 2);
                            }
                        } else {
                            n = this.wantedSum <= 10 ? 1 + Engine.rndPositive(this.gridHeight * this.gridWidth + 6) : 80 + Engine.rndPositive(20);
                        }
                        if ((n = Math.min(99, n)) == this.wantedSum) continue;
                        bl = false;
                        for (n15 = 0; n15 < vector.size(); ++n15) {
                            n14 = Integer.parseInt((String)vector.elementAt(n15));
                            if (n != n14) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        vector.addElement("" + n);
                        n12 = 0;
                    }
                }
                for (n13 = 0; n13 < this.gridHeight * this.gridWidth; ++n13) {
                    n12 = Engine.rndPositive(vector.size());
                    this.gridArray1[n13] = n = Integer.parseInt((String)vector.elementAt(n12));
                    vector.removeElementAt(n12);
                    this.cardState1[n13] = 0;
                }
                this.sgSpriteArray = new SGSprite[this.gridHeight * this.gridWidth];
                for (n13 = 0; n13 < this.gridHeight * this.gridWidth; ++n13) {
                    this.sgSpriteArray[n13] = new SGSprite(this.sgSprite);
                    this.sgSpriteArray[n13].startAnimation(0, 1);
                }
                this.shapeWidth = this.sgSpriteArray[0].getWidth();
                this.shapeHeight = this.sgSpriteArray[0].getHeight();
                this.setCardsFormation();
                this.shapesPos = new int[2];
                this.shapesPos[0] = 0;
                this.shapesPos[1] = 0;
                this.cardID = 0;
                this.finishCycle = false;
                this.flippingMath_state = 3;
                this.maxFlipped = 0;
                break;
            }
            case 13: {
                int n;
                this.wantedSum = Integer.MIN_VALUE;
                this.achievedSum = Integer.MIN_VALUE;
                this.orderIndex = 0;
                int n16 = 0;
                int n17 = 2;
                this.initNumberInput();
                this.scaleTrays = new int[2][];
                this.currentPlate = Engine.rndPositive(2);
                this.numActiveOptions = 4;
                int n18 = 1;
                switch (Engine.currentDifficulty) {
                    case 0: {
                        n16 = 20;
                        n17 = 2 + (this.numGoodResults >> 1);
                        n17 = Math.min(n17, 2);
                        this.currentPlate = 0;
                        this.numActiveOptions = 3;
                        n18 += this.numGoodResults;
                        break;
                    }
                    case 1: {
                        n16 = 50;
                        n17 = 2 + (this.numGoodResults >> 1);
                        n17 = Math.min(n17, 3);
                        n18 = 20;
                        break;
                    }
                    case 2: {
                        n18 = 40;
                        n16 = 100;
                        n17 = 4 + (this.numGoodResults >> 1);
                        n17 = Math.min(n17, 3);
                    }
                }
                n16 = Math.min(n16, 49);
                int n19 = n18 + Engine.rndPositive(n16);
                n19 = Math.min(n19, 98);
                this.wantedSum = n19 << 1;
                this.scaleTrays[0] = new int[n17];
                this.testFill(n19, n17, this.scaleTrays[0]);
                Engine.bubbleSort(this.scaleTrays[0]);
                this.scaleTrays[1] = new int[n17];
                this.testFill(n19, n17, this.scaleTrays[1]);
                Engine.bubbleSort(this.scaleTrays[1]);
                this.weightsPlate = new int[this.numActiveOptions];
                int n20 = 0;
                while ((n20 = (n = this.scaleTrays[this.currentPlate][Engine.rndPositive(this.scaleTrays[this.currentPlate].length)])) == 0) {
                }
                if (n20 > 0) {
                    for (n = 0; n < this.scaleTrays[this.currentPlate].length; ++n) {
                        if (this.scaleTrays[this.currentPlate][n] != n20) continue;
                        this.scaleTrays[this.currentPlate][n] = -1;
                        break;
                    }
                }
                this.orderIndex = this.scaleTrays[this.currentPlate].length - 1;
                this.sgSprite.setPosition(160, 107);
                this.wantedSum = n20;
                this.sgSprite.setFrame(0);
                this.initProfessorText(Engine.text[270]);
            }
        }
    }

    public void initObservationGames() {
        switch (this.subType) {
            case 8: {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                this.initNumberInput();
                this.gridHeight = 4;
                this.gridWidth = 4;
                this.gridArray = new int[this.gridHeight][this.gridWidth];
                this.gridArrayType = new int[this.gridHeight][this.gridWidth];
                this.wantedSum = Integer.MIN_VALUE;
                this.achievedSum = Integer.MIN_VALUE;
                for (n5 = 0; n5 < this.gridHeight; ++n5) {
                    for (n4 = 0; n4 < this.gridWidth; ++n4) {
                        this.gridArray[n5][n4] = Integer.MIN_VALUE;
                        this.gridArrayType[n5][n4] = Integer.MIN_VALUE;
                    }
                }
                n5 = 0;
                switch (Engine.currentDifficulty) {
                    case 0: {
                        this.maxType = 2 + (this.numGoodResults >> 1);
                        n5 = 1;
                        this.maxType = Math.min(6, this.maxType);
                        break;
                    }
                    case 1: {
                        this.maxType = 3 + (this.numGoodResults >> 1);
                        n5 = 1 + (this.numGoodResults >> 2);
                        n5 = Math.min(n5, 2);
                        this.maxType = Math.min(8, this.maxType);
                        break;
                    }
                    case 2: {
                        this.maxType = 3 + (this.numGoodResults >> 1);
                        n5 = 1 + (this.numGoodResults >> 1);
                        this.maxType = Math.min(8, this.maxType);
                    }
                }
                this.orderDelay = 20 + (this.maxType - 1) * 250 / 50;
                n5 = Math.min(3, n5);
                n4 = 0;
                for (n3 = 0; n3 < this.maxType; ++n3) {
                    if (!this.addBox(Engine.rndPositive(n5 + 1))) continue;
                    ++n4;
                }
                this.maxType = n4;
                this.boxes_order = new int[this.maxType];
                this.sgSpriteArray = new SGSprite[this.maxType];
                this.velocity_array = new int[this.maxType];
                n3 = 0;
                int n6 = 0;
                int n7 = 100;
                int n8 = 60;
                for (n2 = 0; n2 < this.gridHeight; ++n2) {
                    for (n = 0; n < this.gridWidth; ++n) {
                        if (this.gridArrayType[n2][n] < 0) continue;
                        this.boxes_order[n3] = this.gridArrayType[n2][n];
                        this.sgSpriteArray[n3] = new SGSprite(this.sgSprite);
                        this.sgSpriteArray[n3].startAnimation(this.boxes_order[n3], 0);
                        this.sgSpriteArray[n3].setFrame(Engine.rndPositive(this.sgSpriteArray[n3].getFrameSequenceLength()));
                        switch (Engine.currentDifficulty) {
                            case 0: {
                                this.velocity_array[n3] = 0;
                                break;
                            }
                            case 1: {
                                if ((n == 0 || n == this.gridWidth - 1) && n6 < 2) {
                                    this.velocity_array[n3] = n8 + Engine.rndPositive(n7);
                                    ++n6;
                                    break;
                                }
                                this.velocity_array[n3] = 0;
                                break;
                            }
                            case 2: {
                                this.velocity_array[n3] = n == 0 || n == this.gridWidth - 1 ? n8 + Engine.rndPositive(n7) : n8 + Engine.rndPositive(15);
                            }
                        }
                        ++n3;
                    }
                }
                this.wantedUFO = this.boxes_order[Engine.rndPositive(this.boxes_order.length)];
                n2 = 0;
                for (n = 0; n < this.boxes_order.length; ++n) {
                    if (this.boxes_order[n] != this.wantedUFO) continue;
                    ++n2;
                }
                this.wantedSum = n2;
                break;
            }
            case 5: {
                int n;
                int n9;
                this.wantedSum = Integer.MIN_VALUE;
                this.achievedSum = Integer.MIN_VALUE;
                this.shapesPos = new int[2];
                this.chosenShapePos = new int[2];
                this.currentPath = 0;
                this.nextPath = 1;
                this.shapesPos[0] = this.PLAY_AREA_X + Engine.rndPositive(this.PLAY_AREA_WIDTH - this.imgOrderSmall[0].width);
                this.shapesPos[1] = this.PLAY_AREA_Y + Engine.rndPositive(this.PLAY_AREA_HEIGHT - this.imgOrderSmall[0].height);
                this.setSpotlightPos(this.shapesPos[0], this.shapesPos[1]);
                this.finishCycle = false;
                if (++this.orderIndex >= this.shapeOrder.length) {
                    this.orderIndex = 0;
                }
                int n10 = this.shapeOrder[this.orderIndex];
                this.shapeWidth = 96;
                this.shapeHeight = 96;
                this.chosenShapePos[0] = this.PLAY_AREA_X + Engine.rndPositive(this.PLAY_AREA_WIDTH - this.shapeWidth - this.imgOrderSmall[0].width);
                this.chosenShapePos[1] = this.PLAY_AREA_Y + this.imgOrderSmall[0].height + Engine.rndPositive(this.PLAY_AREA_HEIGHT - this.shapeHeight - (this.imgOrderSmall[0].height << 1));
                this.maxType = 4;
                this.shapesChosen = new int[this.maxType];
                Vector<String> vector = new Vector<String>();
                for (n9 = 1; n9 <= 25; ++n9) {
                    if (n9 == n10) continue;
                    vector.addElement("" + n9);
                }
                for (n9 = 0; n9 < this.maxType; ++n9) {
                    n = Engine.rndPositive(vector.size());
                    this.shapesChosen[n9] = Integer.parseInt((String)vector.elementAt(n));
                    vector.removeElementAt(n);
                }
                n9 = Engine.rndPositive(this.maxType);
                this.shapesChosen[n9] = n10;
                this.wantedSum = n9;
                this.numActiveOptions = 4;
                this.loadShapes();
                this.star_paths = new int[this.shapeUnderSpotlight.length >> 1][2];
                this.moveSpotlightOrder = new int[this.shapeUnderSpotlight.length >> 1];
                this.getSpotlightOrder(this.moveSpotlightOrder);
                switch (Engine.currentDifficulty) {
                    case 0: {
                        for (n = 0; n < this.star_paths.length; ++n) {
                            this.star_paths[n][0] = this.shapeUnderSpotlight[n * 2] - (this.imgOrderSmall[0].width >> 1);
                            this.star_paths[n][1] = this.shapeUnderSpotlight[n * 2 + 1] - (this.imgOrderSmall[0].height >> 1);
                        }
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.getSpotlightOrder(this.moveSpotlightOrder);
                        for (n = 0; n < this.star_paths.length; ++n) {
                            int n11 = this.moveSpotlightOrder[n];
                            this.star_paths[n][0] = this.shapeUnderSpotlight[n11 << 1] - (this.imgOrderSmall[0].width >> 1);
                            this.star_paths[n][1] = this.shapeUnderSpotlight[(n11 << 1) + 1] - (this.imgOrderSmall[0].height >> 1);
                        }
                        break;
                    }
                }
                this.numActiveOptions = 4;
                this.finishCycle = false;
                this.initProfessorText(Engine.text[262]);
                break;
            }
            case 11: {
                int n;
                int n12;
                this.initNumberInput();
                int n13 = 2;
                this.lightsOffDelay = 6;
                int n14 = 4;
                this.windowCapacity = 4;
                switch (Engine.currentDifficulty) {
                    case 0: {
                        n13 = 2;
                        this.numberOfWindows = 12;
                        this.orderDelay = 22 - (this.numGoodResults >> 1);
                        n14 += Engine.rndPositive(this.numberOfWindows);
                        this.maxWindowsShownAtOnce = 5;
                        this.windowCapacity = 9;
                        break;
                    }
                    case 1: {
                        n13 = 3;
                        this.numberOfWindows = 16;
                        this.orderDelay = 20 - (this.numGoodResults >> 1);
                        n14 += 1 + Engine.rndPositive(this.numGoodResults + 6);
                        this.windowCapacity = 9;
                        this.maxWindowsShownAtOnce = 8;
                        break;
                    }
                    case 2: {
                        n13 = 5;
                        this.numberOfWindows = 20;
                        this.orderDelay = 19 - (this.numGoodResults >> 1);
                        n14 += 3 + Engine.rndPositive(this.numGoodResults + 6);
                        this.windowCapacity = 7;
                        this.maxWindowsShownAtOnce = 10;
                    }
                }
                n14 = Math.min(this.maxWindowsShownAtOnce * this.windowCapacity, n14);
                n13 = Math.min(n13, 5);
                this.orderDelay = Math.max(15, this.orderDelay);
                this.orderIndex = 0;
                this.imgWindows = new DeviceImage[this.numberOfWindows];
                this.gridArray = new int[this.numberOfWindows][this.windowCapacity];
                this.gridArrayType = new int[this.numberOfWindows][1];
                for (n12 = 0; n12 < this.numberOfWindows; ++n12) {
                    for (n = 0; n < this.windowCapacity; ++n) {
                        this.gridArray[n12][n] = 0;
                    }
                    this.gridArrayType[n12][0] = Engine.rndPositive(n13);
                    this.imgWindows[n12] = this.imgOrder[this.gridArrayType[n12][0]];
                }
                for (n12 = 0; n12 < n14; ++n12) {
                    n = 0;
                    while (n == 0) {
                        int n15 = Engine.rndPositive(this.numberOfWindows);
                        n = this.addLightToList2(n15) ? 1 : 0;
                    }
                }
                this.flashLight = false;
                this.gameTicker = 0;
                this.finishCycle = false;
                this.wantedSum = n14;
                this.amountFlashed = n14;
                this.achievedSum = Integer.MIN_VALUE;
                break;
            }
            case 15: {
                int n;
                this.wantedSum = Integer.MIN_VALUE;
                this.achievedSum = Integer.MIN_VALUE;
                int n16 = 2;
                this.numLeaves = 5;
                int n17 = 0;
                switch (Engine.currentDifficulty) {
                    case 0: {
                        this.numLeaves += (this.numGoodResults >> 1) * 2;
                        this.numLeaves = Math.min(this.numLeaves, 14);
                        break;
                    }
                    case 1: {
                        this.numLeaves = 7 + (this.numGoodResults >> 1) * 2;
                        n17 += this.numGoodResults;
                        n16 = 3;
                        this.numLeaves = Math.min(this.numLeaves, 37);
                        break;
                    }
                    case 2: {
                        this.numLeaves = 10 + (this.numGoodResults << 1);
                        n17 += this.numGoodResults * Engine.currentDifficulty;
                        n16 = 4;
                        if (this.numGoodResults <= 0) break;
                        this.numLeaves += this.numGoodResults + (this.numGoodResults >> 1);
                    }
                }
                n17 = Math.min(n17, 30);
                n16 = Math.min(n16, 4);
                this.numLeaves = Math.min(this.numLeaves, 42);
                this.numActiveOptions = n16;
                this.leaf_type = new int[this.numLeaves];
                this.leaves_list = new int[n16];
                int[] nArray = new int[n16];
                this.shapesPos = new int[this.numLeaves << 1];
                this.velocity_array = new int[this.numLeaves << 1];
                this.shapesVectors = new int[this.numLeaves << 1];
                for (n = 0; n < this.leaves_list.length; ++n) {
                    this.leaves_list[n] = n;
                }
                n = 160 - (this.imgSettingWidth >> 1) + 20;
                int n18 = this.sgLeaves[0].getHeight();
                int n19 = this.sgLeaves[0].getWidth();
                int n20 = 24 + n19;
                int n21 = 0;
                this.sgSpriteArray = new SGSprite[this.numLeaves];
                int n22 = Engine.rndPositive(n16);
                block45: for (int i = 0; i < this.numLeaves; ++i) {
                    int n23;
                    int n24;
                    int n25;
                    int n26 = 3 + Engine.rndPositive(20) + n17;
                    this.velocity_array[i << 1] = Engine.divideFixed(n26 << 8, 65536);
                    int n27 = Engine.rndPositive(2);
                    if (n27 == 1) {
                        this.velocity_array[i << 1] = -this.velocity_array[i << 1];
                    }
                    this.velocity_array[(i << 1) + 1] = Engine.divideFixed(30 + Engine.rndPositive(40) << 8, 65536);
                    this.shapesPos[i << 1] = n + n17 + Engine.rndPositive(this.imgSettingWidth - n26 - n17 - 20 - n18);
                    this.shapesPos[(i << 1) + 1] = n20 + Engine.rndPositive(this.imgSettingHeight >> 1);
                    if (i == this.numLeaves - 1) {
                        int n28;
                        n25 = 0;
                        n24 = 0;
                        n23 = 0;
                        for (n28 = 0; n28 < nArray.length; ++n28) {
                            n24 = Math.max(nArray[n28], n24);
                        }
                        for (n28 = 0; n28 < nArray.length; ++n28) {
                            if (nArray[n28] != n24) continue;
                            n23 = n28;
                            break;
                        }
                        for (n28 = 0; n28 < nArray.length; ++n28) {
                            if (nArray[n28] != n24 - 1) continue;
                            this.leaf_type[i] = this.leaves_list[n23];
                            n25 = 1;
                            break;
                        }
                        if (n25 == 0) {
                            this.leaf_type[i] = this.leaves_list[Engine.rndPositive(n16)];
                        }
                    } else if (i < this.leaves_list.length) {
                        this.leaf_type[i] = this.leaves_list[i];
                    } else {
                        n25 = 0;
                        if (this.numLeaves > 10) {
                            n24 = 0;
                            for (n23 = 0; n23 < n16; ++n23) {
                                if (n23 == n22 || (n24 = Math.abs(nArray[n22] - nArray[n23])) >= 3) continue;
                                n25 = 1;
                                this.leaf_type[i] = n22;
                                break;
                            }
                        }
                        if (n25 == 0) {
                            this.leaf_type[i] = this.leaves_list[Engine.rndPositive(n16)];
                        }
                    }
                    for (n25 = 0; n25 < this.leaves_list.length; ++n25) {
                        if (this.leaf_type[i] != this.leaves_list[n25]) continue;
                        int n29 = n25;
                        nArray[n29] = nArray[n29] + 1;
                        break;
                    }
                    this.sgSpriteArray[i] = new SGSprite(this.sgLeaves[this.leaf_type[i]]);
                    this.sgSpriteArray[i].startAnimation(Engine.rndPositive(2), 0);
                    this.sgSpriteArray[i].setFrame(Engine.rndPositive(this.sgSpriteArray[i].getFrameSequenceLength()));
                    if (i != this.numLeaves - 1) continue;
                    n25 = 0;
                    for (n24 = 0; n24 < nArray.length; ++n24) {
                        n25 = Math.max(nArray[n24], n25);
                    }
                    for (n24 = 0; n24 < nArray.length; ++n24) {
                        if (nArray[n24] != n25) continue;
                        n21 = n24;
                        continue block45;
                    }
                }
                this.wantedSum = n21;
                this.finishCycle = false;
                this.initProfessorText(Engine.text[262]);
            }
        }
    }

    public void initMemoryGames() {
        switch (this.subType) {
            case 1: {
                int n;
                this.initNumberInput();
                this.shapeWidth = this.imgFruitBox[0].width;
                this.shapeHeight = this.imgFruitBox[0].height;
                this.maxType = 2;
                this.shapesPos = new int[2];
                this.shapesPos[0] = Engine.rndPositive(2) == 0 ? 1 : -1;
                this.shapesPos[1] = 0;
                switch (Engine.currentDifficulty) {
                    case 0: {
                        this.maxType = 2;
                        this.gridWidth = 2 + (this.numGoodResults >> 1);
                        this.gridHeight = 2;
                        this.gridWidth = Math.min(6, this.gridWidth);
                        this.gridHeight = Math.min(3, this.gridHeight);
                        break;
                    }
                    case 1: {
                        this.maxType = 3;
                        this.gridWidth = 3 + (this.numGoodResults >> 1);
                        this.gridHeight = 3 + this.numGoodResults / 8;
                        this.gridWidth = Math.min(6, this.gridWidth);
                        this.gridHeight = Math.min(3, this.gridHeight);
                        break;
                    }
                    case 2: {
                        this.maxType = 3 + (this.numGoodResults >> 2);
                        this.gridWidth = 4 + (this.numGoodResults >> 1);
                        this.gridHeight = 3 + this.numGoodResults / 8;
                        this.gridWidth = Math.min(6, this.gridWidth);
                        this.gridHeight = Math.min(4, this.gridHeight);
                    }
                }
                int n2 = 10;
                n2 -= this.numGoodResults >> 2;
                n2 = Math.max(6, n2);
                this.orderDelay = (this.gridWidth * this.gridHeight >> 1) * n2 - this.numGoodResults;
                this.maxType = Math.min(4, this.maxType);
                this.orderDelay = Math.max(20, this.orderDelay);
                this.gridOffSetX = 320 - this.shapeWidth * this.gridWidth >> 1;
                this.gridOffSetY = this.screenCentreY - (this.shapeHeight * this.gridHeight >> 1);
                this.imgFruits = new DeviceImage[this.gridWidth * this.gridHeight];
                this.imgCup = new DeviceImage[this.gridWidth * this.gridHeight];
                this.imgBoxTop = new DeviceImage[this.gridWidth];
                this.imgBottom = new DeviceImage[this.gridWidth];
                this.imgLeft = new DeviceImage[this.gridHeight];
                this.imgRight = new DeviceImage[this.gridHeight];
                this.chosenFruit = Engine.rndPositive(this.maxType);
                this.chosenFruitAmount = 0;
                this.wantedSum = Integer.MIN_VALUE;
                this.achievedSum = Integer.MIN_VALUE;
                int n3 = 0;
                for (n = 0; n < this.gridWidth * this.gridHeight; ++n) {
                    n3 = Engine.rndPositive(this.maxType);
                    if (n == this.gridWidth * this.gridHeight - 1 && this.chosenFruitAmount == 0) {
                        n3 = this.chosenFruit;
                    }
                    this.imgFruits[n] = this.imgFruitBox[n3];
                    this.imgCup[n] = this.imgFruitCup;
                    if (n3 != this.chosenFruit) continue;
                    ++this.chosenFruitAmount;
                }
                for (n = 0; n < this.gridWidth; ++n) {
                    this.imgBoxTop[n] = this.imgCrateTop;
                    this.imgBottom[n] = this.imgCrateBottom;
                }
                for (n = 0; n < this.gridHeight; ++n) {
                    this.imgLeft[n] = this.imgCrateSides[0];
                    this.imgRight[n] = this.imgCrateSides[1];
                }
                this.vel = 0;
                this.finishCycle = false;
                this.gameTicker = 0;
                this.wantedSum = this.chosenFruitAmount;
                this.initProfessorText(Engine.text[273]);
                break;
            }
            case 3: {
                this.initOrderGameRound();
                this.wantedSum = Integer.MIN_VALUE;
                this.achievedSum = Integer.MIN_VALUE;
                this.chosenFruit = Engine.rndPositive(this.wantedOrder.length);
                this.chosenFruitAmount = 0;
                this.wantedSum = this.wantedOrder[this.chosenFruit];
                this.initProfessorText(Engine.text[256]);
                break;
            }
            case 4: {
                this.wantedSum = Integer.MIN_VALUE;
                this.achievedSum = Integer.MIN_VALUE;
                switch (Engine.currentDifficulty) {
                    case 0: {
                        this.telephone_numbers_length = 2 + (this.numGoodResults >> 1);
                        this.telephone_numbers_length = Math.min(this.telephone_numbers_length, 4);
                        break;
                    }
                    case 1: {
                        this.telephone_numbers_length = 3 + (this.numGoodResults >> 1);
                        this.telephone_numbers_length = Math.min(this.telephone_numbers_length, 6);
                        break;
                    }
                    case 2: {
                        this.telephone_numbers_length = 4 + (this.numGoodResults >> 1);
                        this.telephone_numbers_length = Math.min(this.telephone_numbers_length, 8);
                    }
                }
                this.initOrderGameRound();
                this.initNumberInput();
                this.initProfessorText(Engine.text[267]);
                break;
            }
            case 9: {
                int n;
                this.wantedSum = Integer.MIN_VALUE;
                this.achievedSum = Integer.MIN_VALUE;
                this.gridHeight = 2;
                this.gridWidth = 2;
                this.incrementValue = 1;
                switch (Engine.currentDifficulty) {
                    case 0: {
                        this.gridHeight = 2;
                        this.gridWidth = 2 + (this.numGoodResults >> 1);
                        this.gridHeight = Math.min(2, this.gridHeight);
                        this.gridWidth = Math.min(3, this.gridWidth);
                        this.orderDelay = 8 + this.gridWidth * this.gridHeight;
                        break;
                    }
                    case 1: {
                        this.gridHeight = 2 + this.numGoodResults / 6;
                        this.gridWidth = 3 + (this.numGoodResults >> 2);
                        this.gridHeight = Math.min(2, this.gridHeight);
                        this.gridWidth = Math.min(4, this.gridWidth);
                        this.orderDelay = 8 + this.gridWidth * this.gridHeight;
                        break;
                    }
                    case 2: {
                        this.gridHeight = 2;
                        this.gridWidth = 3 + this.numGoodResults / 3;
                        this.gridHeight = Math.min(2, this.gridHeight);
                        this.gridWidth = Math.min(4, this.gridWidth);
                        this.orderDelay = 8 + this.gridWidth * this.gridHeight;
                    }
                }
                this.gridArray = new int[this.gridHeight][this.gridWidth];
                this.cardState = new int[this.gridHeight][this.gridWidth];
                this.gridArray1 = new int[this.gridHeight * this.gridWidth];
                this.cardState1 = new int[this.gridHeight * this.gridWidth];
                Vector<String> vector = new Vector<String>();
                int n4 = 1;
                n4 = Math.min(n4, 50);
                for (n = 0; n < this.gridHeight * this.gridWidth; ++n) {
                    vector.addElement("" + (n4 + n) * this.incrementValue);
                }
                this.lowestNumber = Integer.parseInt((String)vector.firstElement());
                this.highestNumber = Integer.parseInt((String)vector.lastElement());
                for (n = 0; n < this.gridHeight * this.gridWidth; ++n) {
                    int n5;
                    int n6 = Engine.rndPositive(vector.size());
                    this.gridArray1[n] = n5 = Integer.parseInt((String)vector.elementAt(n6));
                    vector.removeElementAt(n6);
                    this.cardState1[n] = 0;
                }
                this.wantedSum = this.lowestNumber;
                this.shapesPos = new int[2];
                this.shapesPos[0] = 0;
                this.shapesPos[1] = 0;
                this.cardID = 0;
                this.sgSpriteArray = new SGSprite[this.gridHeight * this.gridWidth];
                for (n = 0; n < this.gridHeight * this.gridWidth; ++n) {
                    this.sgSpriteArray[n] = new SGSprite(this.sgSprite);
                }
                this.shapeWidth = this.sgSpriteArray[0].getWidth();
                this.shapeHeight = this.sgSpriteArray[0].getHeight();
                this.setCardsFormation();
                this.finishCycle = false;
                this.flippingMath_state = 5;
                this.maxFlipped = 0;
            }
        }
    }

    public void initReasoningGames() {
        switch (this.subType) {
            case 2: {
                int n;
                this.vel = 0;
                this.percent = 0;
                this.shapeWidth = 0;
                this.shapeHeight = 0;
                this.wantedSum = Integer.MIN_VALUE;
                this.achievedSum = Integer.MIN_VALUE;
                this.numActiveOptions = 4;
                int n2 = 0;
                int n3 = Engine.rndPositive(2);
                switch (Engine.currentDifficulty) {
                    case 0: {
                        this.numActiveOptions = 3;
                        n3 = 0;
                        n2 = 20;
                        break;
                    }
                    case 1: {
                        this.numActiveOptions = 4;
                        n3 = 0;
                        n2 = 10;
                        break;
                    }
                    case 2: {
                        this.numActiveOptions = 4;
                        n3 = 1;
                        n2 = 2;
                    }
                }
                if (++this.orderIndex >= this.shapeOrder.length) {
                    this.orderIndex = 0;
                }
                int n4 = this.shapeOrder[this.orderIndex];
                this.finishCycle = false;
                this.shapesChosen = new int[this.numActiveOptions];
                this.shapesPos = new int[2];
                Vector<String> vector = new Vector<String>();
                for (n = 1; n <= 25; ++n) {
                    if (n == n4) continue;
                    vector.addElement("" + n);
                }
                for (n = 0; n < this.shapesChosen.length; ++n) {
                    int n5 = Engine.rndPositive(vector.size());
                    this.shapesChosen[n] = Integer.parseInt((String)vector.elementAt(n5));
                    vector.removeElementAt(n5);
                }
                n = Engine.rndPositive(this.shapesChosen.length);
                this.shapesChosen[n] = n4;
                this.wantedSum = n;
                this.chosenShapePos = new int[2];
                this.chosenShapePos[0] = 112;
                this.chosenShapePos[1] = 63;
                this.loadShapes();
                if (n3 == 1) {
                    int[] nArray = new int[this.shapeUnderSpotlight.length];
                    int n6 = (nArray.length >> 1) - 1;
                    int n7 = 0;
                    while (n6 >= 0) {
                        nArray[n7 << 1] = this.shapeUnderSpotlight[n6 << 1];
                        nArray[(n7 << 1) + 1] = this.shapeUnderSpotlight[(n6 << 1) + 1];
                        --n6;
                        ++n7;
                    }
                    for (n6 = 0; n6 < nArray.length >> 1; ++n6) {
                        this.shapeUnderSpotlight[n6 << 1] = nArray[n6 << 1];
                        this.shapeUnderSpotlight[(n6 << 1) + 1] = nArray[(n6 << 1) + 1];
                    }
                }
                this.starTail = new int[n2 * 2];
                for (int i = 0; i < this.starTail.length; ++i) {
                    this.starTail[i] = -1;
                }
                this.maxPathInShape = this.shapeUnderSpotlight.length >> 1;
                this.currentPath = Engine.rndPositive(this.maxPathInShape - 1);
                this.nextPath = this.currentPath + 1;
                this.prevX = this.shapeUnderSpotlight[this.currentPath * 2];
                this.prevY = this.shapeUnderSpotlight[this.currentPath * 2 + 1];
                this.initProfessorText(Engine.text[254]);
                break;
            }
            case 7: {
                int n;
                int n8;
                this.wantedSum = 0;
                this.achievedSum = Integer.MIN_VALUE;
                this.initNumberInput();
                int n9 = 0;
                Vector<String> vector = new Vector<String>();
                boolean bl = false;
                int n10 = 0;
                int n11 = 3;
                switch (Engine.currentDifficulty) {
                    case 0: {
                        n11 = 4 + (this.numGoodResults >> 1);
                        this.maxType = 1;
                        break;
                    }
                    case 1: {
                        n11 = 4 + (this.numGoodResults >> 1);
                        this.maxType = 2;
                        break;
                    }
                    case 2: {
                        n11 = 5 + (this.numGoodResults >> 1);
                        this.maxType = 4;
                    }
                }
                this.orderDelay = 15 - Math.min(20, this.numGoodResults + 10);
                n11 = Math.min(12, n11);
                n10 = 1 + Engine.rndPositive(n11 - 1);
                this.maxType = Math.min(this.maxType, 4);
                n10 = Math.min(12, n10);
                boolean bl2 = false;
                int n12 = -1;
                int n13 = n10 << 8;
                for (n8 = 0; n8 < n11; ++n8) {
                    n = 1 + Engine.rndPositive(this.maxType);
                    n = n12 < 0 ? 1 + Engine.rndPositive(this.maxType) : n12;
                    if (n10 == n11) {
                        n = 1;
                        bl = true;
                        vector.addElement("" + n);
                        bl2 = true;
                        n13 = 0;
                    } else if (n13 <= 0) {
                        n = 0;
                        bl = true;
                        vector.addElement("" + n);
                        bl2 = true;
                        n13 = 0;
                    }
                    switch (n) {
                        case 1: {
                            n9 = 256;
                            break;
                        }
                        case 2: {
                            n9 = HALF_PRECISION;
                            break;
                        }
                        case 0: {
                            n9 = 0;
                            break;
                        }
                        case 3: {
                            n9 = QUARTER_PRECISION;
                            break;
                        }
                        case 4: {
                            n9 = THREE_QUARTERS_PRECISION;
                        }
                    }
                    if (bl2) continue;
                    if (n13 - n9 >= 0) {
                        if (n8 == n11 - 2) {
                            Engine.debug("Last 2 loop " + n8);
                            if (n13 - n9 <= 256) {
                                vector.addElement("" + n);
                                if ((n13 -= n9) == 256) {
                                    n12 = 1;
                                    continue;
                                }
                                if (n13 == HALF_PRECISION) {
                                    n12 = 2;
                                    continue;
                                }
                                if (n13 == 0) {
                                    n12 = 0;
                                    continue;
                                }
                                if (n13 == QUARTER_PRECISION) {
                                    n12 = 3;
                                    continue;
                                }
                                if (n13 != THREE_QUARTERS_PRECISION) continue;
                                n12 = 4;
                                continue;
                            }
                        }
                        if (!bl) {
                            n12 = -1;
                            n13 -= n9;
                            vector.addElement("" + n);
                            n9 = 0;
                        }
                    } else {
                        --n8;
                    }
                    n9 = 0;
                }
                if (n13 > 0) {
                    bl = false;
                    block46: while (!bl) {
                        for (n8 = 0; n8 < vector.size(); ++n8) {
                            n = Integer.parseInt((String)vector.elementAt(n8));
                            if (n == 2) {
                                if (n13 - HALF_PRECISION >= 0) {
                                    n13 -= HALF_PRECISION;
                                    vector.setElementAt("1", n8);
                                }
                            } else if (n == 3) {
                                if (n13 - QUARTER_PRECISION >= 0) {
                                    n13 -= QUARTER_PRECISION;
                                    vector.setElementAt("2", n8);
                                }
                            } else if (n == 4 && n13 - QUARTER_PRECISION >= 0) {
                                n13 -= QUARTER_PRECISION;
                                vector.setElementAt("1", n8);
                            }
                            if (n13 != 0) continue;
                            bl = true;
                            continue block46;
                        }
                    }
                }
                this.water_glass_state = new int[vector.size()];
                this.sgSpriteArray = new SGSprite[vector.size()];
                for (n8 = 0; n8 < this.water_glass_state.length; ++n8) {
                    if (!vector.isEmpty()) {
                        n = Engine.rndPositive(vector.size());
                        this.water_glass_state[n8] = Integer.parseInt((String)vector.elementAt(n));
                        vector.removeElementAt(n);
                    }
                    switch (this.water_glass_state[n8]) {
                        case 1: {
                            this.sgSpriteArray[n8] = new SGSprite(this.sgSprite);
                            this.sgSpriteArray[n8].startAnimation(0, 0);
                            break;
                        }
                        case 2: {
                            this.sgSpriteArray[n8] = new SGSprite(this.sgSprite);
                            this.sgSpriteArray[n8].startAnimation(2, 0);
                            break;
                        }
                        case 0: {
                            this.sgSpriteArray[n8] = new SGSprite(this.sgSprite);
                            this.sgSpriteArray[n8].startAnimation(4, 0);
                            break;
                        }
                        case 3: {
                            this.sgSpriteArray[n8] = new SGSprite(this.sgSprite);
                            this.sgSpriteArray[n8].startAnimation(3, 0);
                            break;
                        }
                        case 4: {
                            this.sgSpriteArray[n8] = new SGSprite(this.sgSprite);
                            this.sgSpriteArray[n8].startAnimation(1, 0);
                        }
                    }
                    this.sgSpriteArray[n8].setFrame(Engine.rndPositive(this.sgSpriteArray[n8].getFrameSequenceLength()));
                }
                this.shapeWidth = this.sgSprite.getWidth();
                this.wantedSum = n10;
                this.initProfessorText(Engine.text[259]);
                break;
            }
            case 12: {
                int n;
                int n14;
                int n15;
                int n16;
                int n17;
                this.wantedSum = Integer.MIN_VALUE;
                this.achievedSum = Integer.MIN_VALUE;
                int n18 = 3;
                int n19 = 0;
                this.numActiveOptions = 3;
                this.shapeWidth = 24;
                this.shapeHeight = 24;
                int n20 = 32;
                int n21 = 1;
                int n22 = 0;
                switch (Engine.currentDifficulty) {
                    case 0: {
                        n18 += this.numGoodResults >> 2;
                        n20 -= this.numGoodResults * 2;
                        n18 = Math.min(n18, 3);
                        n21 = polygonFillColour.length;
                        break;
                    }
                    case 1: {
                        n18 += this.numGoodResults >> 1;
                        n19 = Engine.multiFixed(QUARTER_PRECISION, this.numGoodResults << 2 << 8);
                        n19 = Math.min(512, n19);
                        this.numActiveOptions += this.numGoodResults >> 1;
                        n20 -= this.numGoodResults * 2;
                        n21 = polygonFillColour.length;
                        n22 = 2;
                        break;
                    }
                    case 2: {
                        n18 = 4;
                        n18 += this.numGoodResults >> 1;
                        n19 = Engine.multiFixed(QUARTER_PRECISION, this.numGoodResults << 2 << 8);
                        n19 = Math.min(768, n19);
                        this.numActiveOptions = 4;
                        n20 -= this.numGoodResults * 2;
                        n21 = polygonFillColour.length;
                        n22 = n18;
                    }
                }
                this.numActiveOptions = Math.min(4, this.numActiveOptions);
                n20 = Math.max(n20, this.shapeWidth >> 1);
                n18 = Math.min(n18, 12);
                int n23 = 10 + this.numGoodResults;
                n23 = Math.min(n23, 24);
                this.shapesChosen = new int[this.numActiveOptions];
                this.shapeOrder = new int[n18];
                this.shapesPos = new int[this.shapeOrder.length << 1];
                this.shapesVectors = new int[this.shapeOrder.length << 1];
                this.shapeFillColour = new int[this.shapeOrder.length];
                this.wantedSum = 2 + this.numGoodResults + Engine.rndPositive(n23 - this.numGoodResults);
                this.wantedSum = Math.min(this.wantedSum, 23);
                Vector<String> vector = new Vector<String>();
                Vector<String> vector2 = new Vector<String>();
                for (n17 = 2; n17 <= n23; ++n17) {
                    if (n17 == this.wantedSum) continue;
                    vector.addElement("" + n17);
                }
                for (n17 = 0; n17 < this.shapeOrder.length; ++n17) {
                    n16 = Engine.rndPositive(vector.size());
                    this.shapeOrder[n17] = Integer.parseInt((String)vector.elementAt(n16));
                    vector2.addElement("" + this.shapeOrder[n17]);
                    vector.removeElementAt(n16);
                }
                for (n17 = 0; n17 < this.shapesChosen.length; ++n17) {
                    n16 = Engine.rndPositive(vector2.size());
                    this.shapesChosen[n17] = Integer.parseInt((String)vector2.elementAt(n16));
                    vector2.removeElementAt(n16);
                }
                int n24 = Engine.rndPositive(this.numActiveOptions);
                this.shapesChosen[n24] = this.wantedSum;
                this.wantedSum = n24;
                this.loadShapes();
                this.shapesXYPos = new int[this.shapeOrder.length][];
                Vector vector3 = new Vector();
                n16 = 0;
                for (n15 = 0; n15 < this.shapeOrder.length; ++n15) {
                    vector3.removeAllElements();
                    vector3 = this.getShapesFromResource("shape" + this.shapeOrder[n15] + ".shp");
                    this.shapesXYPos[n15] = new int[vector3.size() - 1];
                    for (n14 = 0; n14 < this.shapesXYPos[n15].length; ++n14) {
                        this.shapesXYPos[n15][n14] = Integer.parseInt((String)vector3.elementAt(n14)) - n16;
                    }
                    this.resizePolygon(this.shapesXYPos[n15], 32, 32);
                }
                this.shapeWidth = 32;
                this.shapeHeight = 32;
                this.currentAngle = 0;
                vector3 = new Vector();
                for (n16 = 0; n16 < this.shapeOrder.length; ++n16) {
                    n15 = 0;
                    block55: while (n15 == 0) {
                        int n25;
                        n14 = 2 + (320 - this.imgSettingWidth >> 1) + Engine.rndPositive(this.imgSettingWidth - this.shapeWidth - 2);
                        n = 25 + Engine.rndPositive(this.imgSettingHeight - this.speachBubbleHeight - this.shapeHeight);
                        if (n16 == 0) {
                            this.shapesPos[n16 << 1] = n14 << 8;
                            this.shapesPos[(n16 << 1) + 1] = n << 8;
                            n15 = 1;
                            continue;
                        }
                        boolean bl = true;
                        for (n25 = 0; n25 < this.shapeOrder.length; ++n25) {
                            int n26 = this.shapesPos[n25 << 1] >> 8;
                            int n27 = this.shapesPos[(n25 << 1) + 1] >> 8;
                            if (n14 > n26 + n20 || n14 + n20 < n26 || n > n27 + n20 || n + n20 < n27) continue;
                            bl = false;
                            break;
                        }
                        if (!bl) continue;
                        for (n25 = 0; n25 < this.shapeOrder.length; ++n25) {
                            if (this.shapesPos[n25 << 1] != 0) continue;
                            this.shapesPos[n25 << 1] = n14 << 8;
                            this.shapesPos[(n25 << 1) + 1] = n << 8;
                            n15 = 1;
                            continue block55;
                        }
                    }
                }
                n16 = 0;
                n15 = polygonFillColour[Engine.rndPositive(n21)];
                for (n14 = 0; n14 < this.shapeOrder.length; ++n14) {
                    if (n16 < n22) {
                        this.shapesVectors[n14 << 1] = Engine.multiFixed(256, Engine.rndPositive(n19 >> 8) << 8);
                        n = Engine.rndPositive(2);
                        if (n == 1) {
                            this.shapesVectors[n14 << 1] = -this.shapesVectors[n14 << 1];
                        }
                        this.shapesVectors[(n14 << 1) + 1] = Engine.multiFixed(256, Engine.rndPositive(n19 >> 8) << 8);
                        n = Engine.rndPositive(2);
                        if (n == 1) {
                            this.shapesVectors[(n14 << 1) + 1] = -this.shapesVectors[(n14 << 1) + 1];
                        }
                    }
                    this.shapeFillColour[n14] = Engine.currentDifficulty == 0 ? n15 : polygonFillColour[Engine.rndPositive(n21)];
                    ++n16;
                }
                this.initProfessorText(Engine.text[262]);
                break;
            }
            case 14: {
                int n;
                int n28;
                int n29;
                int n30;
                int n31;
                int n32;
                this.wantedSum = Integer.MIN_VALUE;
                this.achievedSum = Integer.MIN_VALUE;
                this.sgSpriteArray = new SGSprite[2];
                this.sgBlinds = new SGSprite[2];
                for (n32 = 0; n32 < this.sgSpriteArray.length; ++n32) {
                    this.sgSpriteArray[n32] = new SGSprite(this.sgSprite);
                    this.sgBlinds[n32] = new SGSprite(this.sgWindowBlinds);
                    this.sgBlinds[n32].startAnimation(0, 1);
                }
                this.windowState = new int[2];
                this.curtainWidth = new int[2];
                this.windowShowFaceIndex = new int[2];
                n32 = 4;
                int n33 = 4;
                boolean bl = false;
                switch (Engine.currentDifficulty) {
                    case 0: {
                        n33 = Math.min(n33, 4);
                        this.animateWindow = 2;
                        break;
                    }
                    case 1: {
                        n32 = 5;
                        n33 = 5;
                        n33 = Math.min(n33, 5);
                        this.animateWindow = 2;
                        break;
                    }
                    case 2: {
                        n32 = 6;
                        n33 = 6;
                        n33 = Math.min(n33, 6);
                        this.animateWindow = 2;
                    }
                }
                n32 += 2;
                n33 = Math.min(n33, this.sgSprite.animationSequences.length >> 1);
                int n34 = this.sgSprite.animationSequences.length;
                n32 = Math.min(n32, n34 >> 1);
                int[] nArray = new int[n32 * 2];
                nArray[0] = 0;
                Vector<String> vector = new Vector<String>();
                for (n31 = 1; n31 < nArray.length; ++n31) {
                    n30 = 1;
                    while (n30 != 0) {
                        n29 = 1 + Engine.rndPositive(n34);
                        if (!vector.isEmpty()) {
                            n28 = 0;
                            for (n = 0; n < vector.size(); ++n) {
                                int n35 = Integer.parseInt((String)vector.elementAt(n));
                                if (n29 != n35) continue;
                                n28 = 1;
                                break;
                            }
                            if (n28 != 0) continue;
                            vector.addElement("" + n29);
                            n30 = 0;
                            continue;
                        }
                        vector.addElement("" + n29);
                        n30 = 0;
                    }
                }
                if (bl) {
                    for (n31 = 0; n31 < this.photoAmount; ++n31) {
                        n30 = 1 + n31;
                        vector.setElementAt("" + -n30, n31);
                    }
                }
                for (n31 = 1; n31 < nArray.length; ++n31) {
                    n30 = Engine.rndPositive(vector.size());
                    nArray[n31] = Integer.parseInt((String)vector.elementAt(n30));
                    vector.removeElementAt(n30);
                }
                n31 = Engine.rndPositive(2);
                this.windowsOrder = new int[2][];
                for (n30 = 0; n30 < 2; ++n30) {
                    this.windowsOrder[n30] = n30 == n31 ? new int[n33] : new int[n33];
                }
                vector.removeAllElements();
                n30 = 1 + Engine.rndPositive(2);
                for (n29 = 0; n29 < 2; ++n29) {
                    for (n28 = 0; n28 < this.windowsOrder[n29].length; ++n28) {
                        if (n29 == n31) {
                            vector.addElement("" + nArray[n33 + n28]);
                            continue;
                        }
                        this.windowsOrder[n29][n28] = n28 < n33 - n30 ? nArray[1 + n28] : (Engine.currentDifficulty != 0 ? nArray[1 + Engine.rndPositive(n33 - 1)] : nArray[Engine.rndPositive(n33)]);
                    }
                    this.windowState[n29] = 0;
                    this.curtainWidth[n29] = 0;
                    this.windowShowFaceIndex[n29] = 0;
                }
                for (n29 = 0; n29 < this.windowsOrder[n31].length; ++n29) {
                    n28 = Engine.rndPositive(vector.size());
                    this.windowsOrder[n31][n29] = Integer.parseInt((String)vector.elementAt(n28));
                    vector.removeElementAt(n28);
                }
                n29 = 1;
                n28 = n31 == 0 ? 1 : 0;
                for (n = 0; n < this.windowsOrder[n28].length; ++n) {
                    if (this.windowsOrder[n28][n] <= 0) continue;
                    n29 = 0;
                    break;
                }
                if (n29 != 0) {
                    this.windowsOrder[n28][Engine.rndPositive((int)this.windowsOrder[n28].length)] = nArray[1];
                }
                this.windowWidth = this.sgSpriteArray[0].getWidth();
                this.windowHeight = this.sgSpriteArray[0].getHeight();
                this.orderIndex = 0;
                this.finishCycle = false;
                this.wantedSum = n31 + 1;
                this.initProfessorText(Engine.text[271]);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void tickNewBG2Games() {
        switch (state) {
            case 0: {
                switch (this.subType) {
                    case 2: {
                        this.tickConstellations();
                        this.updateTiming();
                        if (!this.finishCycle) {
                            if (!Engine.hasAnyKeyPressed()) return;
                        }
                        this.removeGuiZone(false);
                        this.initProfessorText(Engine.text[268]);
                        this.finishCycle = true;
                        state = 1;
                        Engine.resetKeyBuffers();
                        this.gameTicker = 0;
                        return;
                    }
                    case 3: {
                        this.tickOrderGame();
                        return;
                    }
                    case 5: {
                        this.lightShow();
                        this.updateTiming();
                        if (!Engine.hasAnyKeyPressed()) return;
                        this.removeGuiZone(false);
                        this.finishCycle = true;
                        state = 1;
                        this.initProfessorText(Engine.text[268]);
                        Engine.resetKeyBuffers();
                        this.gameTicker = 0;
                        return;
                    }
                    case 6: {
                        this.tickWatchingTheBox();
                        if (!this.finishCycle) return;
                        state = 1;
                        Engine.resetKeyBuffers();
                        this.gameTicker = 0;
                        return;
                    }
                    case 0: {
                        ++this.gameTicker;
                        if (this.gameTicker <= 5) return;
                        state = 1;
                        Engine.resetKeyBuffers();
                        this.gameTicker = 0;
                        return;
                    }
                    case 9: {
                        this.tickFlippingMathChallenge();
                        if (!this.finishCycle) return;
                        state = 1;
                        Engine.resetKeyBuffers();
                        this.gameTicker = 0;
                        return;
                    }
                    case 7: {
                        state = 1;
                        Engine.resetKeyBuffers();
                        this.gameTicker = 0;
                        return;
                    }
                    case 1: {
                        ++this.gameTicker;
                        if (this.gameTicker <= this.orderDelay) return;
                        this.initProfessorText(Engine.text[266]);
                        state = 1;
                        Engine.resetKeyBuffers();
                        this.gameTicker = 0;
                        return;
                    }
                    case 4: {
                        this.updateTiming();
                        this.getNumberInput();
                        if (this.userNumberString.length() <= 0) return;
                        String string = this.userNumberString.charAt(this.userNumberString.length() - 1) + "";
                        this.achievedOrder[this.userNumberString.length() - 1] = Integer.parseInt(string);
                        state = 1;
                        Engine.resetKeyBuffers();
                        this.gameTicker = 0;
                        return;
                    }
                    case 13: {
                        this.tickHeavyweight();
                        state = 1;
                        Engine.resetKeyBuffers();
                        this.gameTicker = 0;
                        return;
                    }
                    case 8: {
                        ++this.gameTicker;
                        this.tickAllSgSpriteAnimation(0);
                        if (this.gameTicker <= this.orderDelay) return;
                        this.initProfessorText(Engine.text[266]);
                        this.sgSprite.startAnimation(this.wantedUFO, 0);
                        this.sgSprite.setPosition(160, 24 + (this.imgSettingHeight >> 1));
                        state = 1;
                        Engine.resetKeyBuffers();
                        this.gameTicker = 0;
                        return;
                    }
                    case 10: {
                        ++this.gameTicker;
                        this.tickFlippingMathChallenge();
                        if (!this.finishCycle) return;
                        state = 1;
                        Engine.resetKeyBuffers();
                        this.gameTicker = 0;
                        return;
                    }
                    case 11: {
                        ++this.gameTicker;
                        this.tickLightSwitches2();
                        if (!this.finishCycle) return;
                        this.initProfessorText(Engine.text[265]);
                        state = 1;
                        Engine.resetKeyBuffers();
                        this.gameTicker = 0;
                        return;
                    }
                    case 12: {
                        this.tickOverlap();
                        this.updateTiming();
                        if (!Engine.hasAnyKeyPressed()) return;
                        this.removeGuiZone(false);
                        this.initProfessorText(Engine.text[269]);
                        state = 1;
                        Engine.resetKeyBuffers();
                        this.gameTicker = 0;
                        return;
                    }
                    case 14: {
                        ++this.gameTicker;
                        this.tickWindowGame();
                        if (!this.finishCycle) return;
                        state = 1;
                        Engine.resetKeyBuffers();
                        this.gameTicker = 0;
                        return;
                    }
                    case 15: {
                        ++this.gameTicker;
                        this.tickTree();
                        this.updateTiming();
                        this.removeGuiZone(true);
                        if (!Engine.hasAnyKeyPressed()) {
                            if (this.gameTicker <= 200) return;
                        }
                        state = 1;
                        this.initProfessorText(Engine.text[272]);
                        this.finishCycle = true;
                        this.removeGuiZone(false);
                        this.gameTicker = 0;
                        return;
                    }
                }
                ++this.gameTicker;
                if (this.gameTicker <= 50) return;
                state = 1;
                Engine.resetKeyBuffers();
                this.gameTicker = 0;
                return;
            }
            case 1: {
                ++this.gameTicker;
                switch (this.subType) {
                    case 0: 
                    case 1: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 11: 
                    case 13: {
                        int n;
                        int n2;
                        ++this.lastRoundChangeTick;
                        String string = this.wantedSum + "";
                        boolean bl = false;
                        if (this.userNumberString.length() > 0) {
                            n2 = string.length();
                            n2 = Math.min(n2, this.userNumberString.length());
                            for (n = 0; n < n2; ++n) {
                                if (this.userNumberString.charAt(n) == string.charAt(n)) continue;
                                bl = true;
                            }
                        }
                        if (this.checkSumGameResult()) {
                            bl = true;
                            if (this.subType == 13) {
                                this.tickHeavyweight();
                            }
                            this.endRound();
                        } else if (bl && this.lastRoundChangeTick == 2) {
                            if (this.subType == 13) {
                                this.tickHeavyweight();
                            }
                            this.endRound();
                        } else {
                            n2 = this.userNumberIndex;
                            this.getNumberInput();
                            if (this.userNumberString.length() > 0) {
                                this.achievedSum = Integer.parseInt(this.userNumberString);
                                this.calculatorButtonPressed = n = Integer.parseInt("" + this.userNumberString.charAt(this.userNumberString.length() - 1));
                            } else {
                                this.achievedSum = Integer.MIN_VALUE;
                                this.calculatorButtonPressed = -1;
                            }
                            if (n2 < this.userNumberIndex && this.userNumberIndex > 0) {
                                this.calculatorButtonPressed = -1;
                            }
                        }
                        if (this.lastRoundChangeTick > 2) {
                            this.calculatorButtonPressed = -1;
                        }
                        if (this.subType == 8) {
                            this.sgSprite.tickAnimation(50);
                            return;
                        }
                        if (this.subType != 7) return;
                        this.tickAllSgSpriteAnimation(this.orderDelay);
                        return;
                    }
                    case 2: 
                    case 5: 
                    case 12: 
                    case 15: {
                        boolean bl = false;
                        if (Engine.key(1) && this.numActiveOptions >= 3) {
                            this.achievedSum = 2;
                            bl = true;
                        } else if (Engine.key(2) && this.numActiveOptions == 4) {
                            this.achievedSum = 3;
                            bl = true;
                        } else if (Engine.key(8)) {
                            this.achievedSum = 1;
                            bl = true;
                        } else if (Engine.key(4)) {
                            this.achievedSum = 0;
                            bl = true;
                        }
                        Engine.resetKeyBuffers();
                        if (!bl) return;
                        if (this.checkSumGameResult()) {
                            this.endRound();
                            return;
                        }
                        this.endRound();
                        return;
                    }
                    case 3: {
                        int n = -1;
                        if (Engine.key(1)) {
                            n = 1;
                        } else if (Engine.key(2) && this.numActiveOptions > 3) {
                            n = 3;
                        } else if (Engine.key(4)) {
                            n = 0;
                        } else if (Engine.key(8)) {
                            n = 2;
                        }
                        if (n == -1) return;
                        this.achievedSum = n;
                        if (this.checkSumGameResult()) {
                            this.endRound();
                            return;
                        }
                        this.endRound();
                        return;
                    }
                    case 4: {
                        int n;
                        int n3;
                        ++this.lastRoundChangeTick;
                        String string = "";
                        for (n3 = 0; n3 < this.wantedOrder.length; ++n3) {
                            string = string + this.wantedOrder[n3] + "";
                        }
                        n3 = 0;
                        if (this.userNumberString.length() > 0) {
                            n = string.length();
                            n = Math.min(n, this.userNumberString.length());
                            for (int i = 0; i < n; ++i) {
                                if (string.charAt(i) == this.userNumberString.charAt(i)) continue;
                                n3 = 1;
                            }
                        }
                        if (this.checkOrderGameResult()) {
                            this.endRound();
                        } else if (n3 != 0 && this.userNumberString.length() > 0) {
                            this.endRound();
                        } else {
                            n = this.userNumberIndex;
                            this.getNumberInput();
                            if (this.userNumberString.length() > 0) {
                                String string2 = this.userNumberString.charAt(this.userNumberString.length() - 1) + "";
                                this.achievedOrder[this.userNumberString.length() - 1] = Integer.parseInt(string2);
                                this.calculatorButtonPressed = this.achievedOrder[this.userNumberString.length() - 1];
                            } else {
                                this.calculatorButtonPressed = -1;
                            }
                            if (n < this.userNumberIndex && this.userNumberIndex > 0) {
                                this.calculatorButtonPressed = -1;
                            }
                        }
                        if (this.lastRoundChangeTick <= 2) return;
                        this.calculatorButtonPressed = -1;
                        return;
                    }
                    case 9: 
                    case 10: {
                        int n = -1;
                        if (Engine.key(1)) {
                            n = 1;
                        } else if (Engine.key(2)) {
                            n = 3;
                        } else if (Engine.key(4)) {
                            n = 0;
                        } else if (Engine.key(8)) {
                            n = 2;
                        } else if (Engine.key(16)) {
                            n = 4;
                        }
                        Engine.resetKeyBuffers();
                        if (n != -1) {
                            switch (n) {
                                case 2: {
                                    this.updateCursorPos(n);
                                    break;
                                }
                                case 0: {
                                    this.updateCursorPos(n);
                                    break;
                                }
                                case 1: {
                                    this.updateCursorPos(n);
                                    break;
                                }
                                case 3: {
                                    this.updateCursorPos(n);
                                    break;
                                }
                                case 4: {
                                    this.selectedSquare();
                                    break;
                                }
                            }
                        }
                        this.tickFlippingNumberChallenge();
                        if (this.subType == 9) {
                            if (this.wantedSum != this.highestNumber + 1) return;
                            this.achievedSum = this.wantedSum;
                            this.endRound();
                            return;
                        }
                        boolean bl = false;
                        if (this.wantedSum == this.achievedSum) {
                            bl = true;
                        }
                        if (bl) {
                            this.endRound();
                            return;
                        }
                        if (this.achievedSum != -1) return;
                        this.endRound();
                        return;
                    }
                    case 14: {
                        int n = -1;
                        if (Engine.key(4)) {
                            n = 0;
                        } else if (Engine.key(8)) {
                            n = 2;
                        }
                        Engine.resetKeyBuffers();
                        if (n == -1) return;
                        switch (n) {
                            case 2: {
                                this.achievedSum = 2;
                                break;
                            }
                            case 0: {
                                this.achievedSum = 1;
                                break;
                            }
                        }
                        this.endRound();
                    }
                }
                return;
            }
            case 2: {
                switch (this.subType) {
                    case 10: {
                        this.tickFlippingNumberChallenge();
                    }
                }
                return;
            }
        }
    }

    public void paintNewGames(Graphics graphics) {
        block47: {
            block0 : switch (state) {
                case 0: 
                case 4: {
                    switch (this.subType) {
                        case 1: {
                            this.paintFruitBox(graphics);
                            this.paintTextInfo(graphics, "");
                            break;
                        }
                        case 0: {
                            this.printDigits(graphics);
                            break;
                        }
                        case 8: {
                            this.paintUFO(graphics);
                            break;
                        }
                        case 2: {
                            this.paintTextInfo(graphics, "");
                            this.animateShape(graphics);
                            this.removeGuiZone(true);
                            break;
                        }
                        case 3: {
                            this.paintTextInfo(graphics, "");
                            this.paintOrderGame(graphics);
                            this.removeGuiZone(false);
                            break;
                        }
                        case 4: {
                            int n = 24 + (this.imgSettingHeight - (this.imgNotePadPiece == null ? 0 : this.imgNotePadPiece.height) >> 1) + 0;
                            if (this.imgNotePadPiece != null) {
                                this.imgNotePadPiece.drawImage(graphics, (320 - this.imgNotePadPiece.width >> 1) - 2, n);
                            } else {
                                this.paintTelephoneWhiteBox(graphics);
                            }
                            this.paintTextInfo(graphics, "");
                            String string = "";
                            int n2 = FontMgr.charHeight[6];
                            int n3 = 320 - FontMgr.maxCharWidth[6] * this.wantedOrder.length >> 1;
                            int n4 = n + (this.imgNotePadPiece != null ? this.imgNotePadPiece.height >> 1 : 0) + this.wantedOrder.length * (n2 >> 3);
                            for (int i = 0; i < this.wantedOrder.length; ++i) {
                                string = this.wantedOrder[i] + "";
                                FontMgr.drawString(6, graphics, string, n3 + i * FontMgr.maxCharWidth[6], n4 - i * (n2 / 4), 3);
                            }
                            break block0;
                        }
                        case 5: {
                            this.paintSpotlight(graphics);
                            this.paintTextInfo(graphics, "");
                            this.removeGuiZone(true);
                            break;
                        }
                        case 6: {
                            this.paintBoxesFillingUp(graphics);
                            this.paintTextInfo(graphics, "");
                            break;
                        }
                        case 7: {
                            this.paintTestTubes(graphics);
                            break;
                        }
                        case 10: {
                            this.paintTxtOverlay(graphics);
                            this.paintFlippingMathsSum(graphics);
                            this.paintFlippingNumbers(graphics);
                            break;
                        }
                        case 11: {
                            this.paintWindows(graphics);
                            break;
                        }
                        case 12: {
                            this.paintOverlap(graphics);
                            this.paintTextInfo(graphics, "");
                            this.removeGuiZone(true);
                            break;
                        }
                        case 13: {
                            if (state == 4) {
                                this.paintScales(graphics);
                                break;
                            }
                            break block47;
                        }
                        case 9: {
                            this.paintFlippingNumbers(graphics);
                            break;
                        }
                        case 14: {
                            this.paintWindowGame(graphics);
                            break;
                        }
                        case 15: {
                            this.paintTextInfo(graphics, "");
                            this.paintTree(graphics);
                            graphics.setClip(0, 0, 320, 222);
                        }
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    switch (this.subType) {
                        case 0: {
                            this.printDigits(graphics);
                            break block0;
                        }
                        case 1: {
                            DeviceImage deviceImage = this.imgOrderLarge[this.chosenFruit];
                            graphics.setColor(0xFFFFFF);
                            int n = deviceImage.width + (deviceImage.width >> 1);
                            graphics.fillRoundRect(320 - n >> 1, 222 - n >> 1, n, n, 8, 8);
                            graphics.setColor(0x848284);
                            graphics.drawRoundRect(320 - n >> 1, 222 - n >> 1, n, n, 8, 8);
                            deviceImage.drawImage(graphics, 320 - deviceImage.width >> 1, (222 - n >> 1) + (n >> 1) - (deviceImage.height >> 1));
                            this.paintTextInfo(graphics, " " + this.userNumberString);
                            break block0;
                        }
                        case 2: 
                        case 5: {
                            if (this.finishCycle) {
                                int n = 39;
                                this.imgKeyPad.drawImage(graphics, 320 - this.imgKeyPad.width >> 1, n);
                                this.paintTextInfo(graphics, "");
                                this.paintSpotlightChallenge(graphics);
                                break block0;
                            }
                            if (state == 5 && !this.finishCycle && this.subType == 5) {
                                this.paintSpotlight(graphics);
                                this.paintTextInfo(graphics, "");
                                break block0;
                            }
                            break block47;
                        }
                        case 8: {
                            this.sgSprite.paintAnchored(graphics, 0, 0, 1);
                            this.paintTextInfo(graphics, " " + this.userNumberString);
                            break block0;
                        }
                        case 3: {
                            this.paintTextInfo(graphics, "");
                            this.paintOrderGame(graphics);
                            break block0;
                        }
                        case 4: {
                            int n = 24 + (this.imgSettingHeight >> 1);
                            FontMgr.drawString(13, graphics, this.userNumberString, 160, n, 3);
                            if (Engine.tick % 10 < 5) {
                                graphics.setColor(0);
                                graphics.fillRect(160 + (this.userNumberString.length() <= 0 ? 0 : this.userNumberString.length() * FontMgr.maxCharWidth[13] + FontMgr.maxCharWidth[13] >> 1), n - (FontMgr.lineHeight[13] >> 1), 1, FontMgr.lineHeight[13]);
                                break block0;
                            }
                            break block47;
                        }
                        case 6: {
                            this.paintRemainingBoxes(graphics);
                            this.paintTextInfo(graphics, " " + this.userNumberString);
                            break block0;
                        }
                        case 7: {
                            this.paintTestTubes(graphics);
                            this.paintTextInfo(graphics, " " + this.userNumberString);
                            break block0;
                        }
                        case 9: {
                            this.paintFlippingNumbers(graphics);
                            break block0;
                        }
                        case 10: {
                            this.paintTxtOverlay(graphics);
                            this.paintFlippingMathsSum(graphics);
                            this.paintFlippingNumbers(graphics);
                            break block0;
                        }
                        case 11: {
                            this.paintWindows(graphics);
                            this.paintTextInfo(graphics, " " + this.userNumberString);
                            break block0;
                        }
                        case 12: {
                            int n = 39;
                            this.imgKeyPad.drawImage(graphics, 320 - this.imgKeyPad.width >> 1, n);
                            this.paintTextInfo(graphics, "");
                            this.paintSpotlightChallenge(graphics);
                            break block0;
                        }
                        case 13: {
                            this.paintHeavyweight(graphics);
                            this.paintTextInfo(graphics, " " + this.userNumberString);
                            break block0;
                        }
                        case 14: {
                            this.paintWindowGame(graphics);
                            this.paintTextInfo(graphics, "");
                            break block0;
                        }
                        case 15: {
                            if (this.finishCycle) {
                                this.paintTreeChoices(graphics);
                                this.paintTextInfo(graphics, "");
                                break block0;
                            }
                            this.paintTextInfo(graphics, "");
                            this.paintTree(graphics);
                            graphics.setClip(0, 0, 320, 222);
                        }
                    }
                }
            }
        }
    }

    public void printDigits(Graphics graphics) {
        String string = "  ";
        switch (this.chosenSideToHide) {
            case 0: {
                if (this.userNumberString.length() > 0) {
                    string = this.userNumberString;
                }
                FontMgr.drawString(3, graphics, string + OPERAND_STRING[this.currentOperand] + "" + this.currentFactors[1] + "=" + this.copyOfWantedSum, 160, 57, 3);
                break;
            }
            case 1: {
                if (this.userNumberString.length() > 0) {
                    string = this.userNumberString;
                }
                FontMgr.drawString(3, graphics, this.currentFactors[0] + OPERAND_STRING[this.currentOperand] + "" + string + "=" + this.copyOfWantedSum, 160, 57, 3);
                break;
            }
            case 2: {
                if (this.userNumberString.length() > 0) {
                    string = this.userNumberString;
                }
                FontMgr.drawString(3, graphics, this.currentFactors[0] + OPERAND_STRING[this.currentOperand] + "" + this.currentFactors[1] + "=" + string, 160, 57, 3);
            }
        }
    }

    public void paintCalculatorButtons(Graphics graphics) {
        if (this.calculatorButtonPressed >= 0) {
            this.sgSpriteArray[this.calculatorButtonPressed].paintAnchored(graphics, this.calculatorButtonPressed, 0, 0, 20);
        }
    }

    public void loadShapes() {
        int n;
        Vector vector = this.getShapesFromResource("shape" + this.shapeOrder[this.orderIndex] + ".shp");
        if (this.subType != 12) {
            this.shapeUnderSpotlight = new int[vector.size() - 1];
            for (n = 0; n < this.shapeUnderSpotlight.length; ++n) {
                this.shapeUnderSpotlight[n] = Integer.parseInt((String)vector.elementAt(n)) * 4;
            }
            for (n = 0; n < this.shapeUnderSpotlight.length >> 1; ++n) {
                int n2 = n * 2;
                this.shapeUnderSpotlight[n2] = this.shapeUnderSpotlight[n2] + this.chosenShapePos[0];
                int n3 = n * 2 + 1;
                this.shapeUnderSpotlight[n3] = this.shapeUnderSpotlight[n3] + this.chosenShapePos[1];
            }
        }
        this.shapeOnKeyPad1 = new int[this.numActiveOptions][];
        this.shapeWidth = 24;
        this.shapeHeight = 24;
        for (n = 0; n < this.numActiveOptions; ++n) {
            vector.removeAllElements();
            vector = this.getShapesFromResource("shape" + this.shapesChosen[n] + ".shp");
            this.shapeOnKeyPad1[n] = new int[vector.size()];
            for (int i = 0; i < this.shapeOnKeyPad1[n].length; ++i) {
                this.shapeOnKeyPad1[n][i] = Integer.parseInt((String)vector.elementAt(i));
            }
            this.setShapeOnKeypad(this.shapeOnKeyPad1[n], keypad_pos[n]);
        }
    }

    public Vector getShapesFromResource(String string) {
        Vector<String> vector = new Vector<String>();
        byte[] byArray = ResourceMaster.getResource(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            while (true) {
                int n = dataInputStream.readInt();
                vector.addElement("" + n);
            }
        }
        catch (Exception exception) {
            return vector;
        }
    }

    public void initSkyGazingOrder() {
        int n;
        int n2;
        this.orderIndex = 0;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        for (n2 = 0; n2 < EASY_SHAPES_LIST.length; ++n2) {
            vector.addElement("" + EASY_SHAPES_LIST[n2]);
        }
        for (n2 = 0; n2 < MEDIUM_SHAPES_LIST.length; ++n2) {
            vector2.addElement("" + MEDIUM_SHAPES_LIST[n2]);
        }
        for (n2 = 0; n2 < HARD_SHAPES_LIST.length; ++n2) {
            vector3.addElement("" + HARD_SHAPES_LIST[n2]);
        }
        n2 = 0;
        switch (Engine.currentDifficulty) {
            case 0: {
                int n3;
                for (n = 0; n < 3; ++n) {
                    n2 = Engine.rndPositive(vector.size());
                    n3 = Integer.parseInt((String)vector.elementAt(n2));
                    vector4.addElement("" + n3);
                    vector.removeElementAt(n2);
                }
                for (n = 0; n < 2; ++n) {
                    n2 = Engine.rndPositive(vector2.size());
                    n3 = Integer.parseInt((String)vector2.elementAt(n2));
                    vector4.addElement("" + n3);
                    vector2.removeElementAt(n2);
                }
                for (n = 0; n < 2; ++n) {
                    n2 = Engine.rndPositive(vector3.size());
                    n3 = Integer.parseInt((String)vector3.elementAt(n2));
                    vector4.addElement("" + n3);
                    vector3.removeElementAt(n2);
                }
                break;
            }
            case 1: {
                int n3;
                for (n = 0; n < 2; ++n) {
                    n2 = Engine.rndPositive(vector.size());
                    n3 = Integer.parseInt((String)vector.elementAt(n2));
                    vector4.addElement("" + n3);
                    vector.removeElementAt(n2);
                }
                for (n = 0; n < MEDIUM_SHAPES_LIST.length; ++n) {
                    n2 = Engine.rndPositive(vector2.size());
                    n3 = Integer.parseInt((String)vector2.elementAt(n2));
                    vector4.addElement("" + n3);
                    vector2.removeElementAt(n2);
                }
                for (n = 0; n < 2; ++n) {
                    n2 = Engine.rndPositive(vector3.size());
                    n3 = Integer.parseInt((String)vector3.elementAt(n2));
                    vector4.addElement("" + n3);
                    vector3.removeElementAt(n2);
                }
                break;
            }
            case 2: {
                int n3;
                for (n = 0; n < 2; ++n) {
                    n2 = Engine.rndPositive(vector.size());
                    n3 = Integer.parseInt((String)vector.elementAt(n2));
                    vector4.addElement("" + n3);
                    vector.removeElementAt(n2);
                }
                for (n = 0; n < MEDIUM_SHAPES_LIST.length; ++n) {
                    n2 = Engine.rndPositive(vector2.size());
                    n3 = Integer.parseInt((String)vector2.elementAt(n2));
                    vector4.addElement("" + n3);
                    vector2.removeElementAt(n2);
                }
                for (n = 0; n < HARD_SHAPES_LIST.length; ++n) {
                    n2 = Engine.rndPositive(vector3.size());
                    n3 = Integer.parseInt((String)vector3.elementAt(n2));
                    vector4.addElement("" + n3);
                    vector3.removeElementAt(n2);
                }
                break;
            }
        }
        this.shapeOrder = new int[vector4.size()];
        for (n = 0; n < this.shapeOrder.length; ++n) {
            this.shapeOrder[n] = Integer.parseInt((String)vector4.elementAt(n));
        }
    }

    public void tickConstellations() {
        int n;
        int n2;
        int n3 = this.shapeUnderSpotlight[this.nextPath * 2] - this.shapeUnderSpotlight[this.currentPath * 2];
        int n4 = this.shapeUnderSpotlight[this.nextPath * 2 + 1] - this.shapeUnderSpotlight[this.currentPath * 2 + 1];
        int n5 = n3 != 0 ? Engine.div(n3 << 8, 25600) : 0;
        int n6 = n4 != 0 ? Engine.div(n4 << 8, 25600) : 0;
        int n7 = -1;
        int n8 = 0;
        switch (Engine.currentDifficulty) {
            case 0: {
                n7 = 100;
                n8 = 4;
                break;
            }
            case 1: {
                n7 = 30;
                n8 = 6;
                break;
            }
            case 2: {
                n7 = 10;
                n8 = 8;
            }
        }
        this.percent += n8;
        if (this.percent > n7 + 1) {
            n2 = 0;
            n2 = n7 == 100 ? this.percent - this.percent : this.percent - n7;
            n = Engine.multiFixed(n5, n2 << 8);
            this.prevX = this.shapeUnderSpotlight[this.currentPath << 1] + (n >> 8);
            n = Engine.multiFixed(n6, n2 << 8);
            this.prevY = this.shapeUnderSpotlight[(this.currentPath << 1) + 1] + (n >> 8);
        }
        if (this.percent >= 100) {
            ++this.nextPath;
            ++this.currentPath;
            --this.maxPathInShape;
            if (this.nextPath >= this.shapeUnderSpotlight.length >> 1) {
                this.nextPath = 0;
            }
            if (this.currentPath >= this.shapeUnderSpotlight.length >> 1) {
                this.currentPath = 0;
            }
            if (this.maxPathInShape <= 0) {
                this.finishCycle = true;
                return;
            }
            this.prevX = this.shapeUnderSpotlight[this.currentPath << 1];
            this.prevY = this.shapeUnderSpotlight[(this.currentPath << 1) + 1];
            this.percent = 0;
        }
        n = Engine.multiFixed(n5, this.percent << 8);
        n3 = this.shapeUnderSpotlight[this.currentPath << 1] + (n >> 8);
        n = Engine.multiFixed(n6, this.percent << 8);
        n4 = this.shapeUnderSpotlight[(this.currentPath << 1) + 1] + (n >> 8);
        this.shapesPos[0] = n3;
        this.shapesPos[1] = n4;
        for (n2 = (this.starTail.length >> 1) - 1; n2 > 0; --n2) {
            this.starTail[n2 << 1] = this.starTail[n2 - 1 << 1];
            this.starTail[(n2 << 1) + 1] = this.starTail[(n2 - 1 << 1) + 1];
        }
        this.starTail[0] = n3;
        this.starTail[1] = n4;
    }

    public void animateShape(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        for (int i = 0; i < this.starTail.length >> 1; ++i) {
            if (i + 1 >= this.starTail.length >> 1 || this.starTail[i << 1] == -1 || this.starTail[i + 1 << 1] == -1) continue;
            graphics.drawLine(this.starTail[i << 1], this.starTail[(i << 1) + 1] + 0, this.starTail[i + 1 << 1], this.starTail[(i + 1 << 1) + 1] + 0);
        }
        this.imgOrderSmall[0].drawImage(graphics, this.shapesPos[0] - (this.imgOrderSmall[0].width >> 1), this.shapesPos[1] - (this.imgOrderSmall[0].height >> 1) + 0);
    }

    public void setShapeOnKeypad(int[] nArray, int n) {
        int n2 = 39;
        switch (n) {
            case 2: {
                for (int i = 0; i < nArray.length >> 1; ++i) {
                    int n3 = i * 2;
                    nArray[n3] = nArray[n3] + (160 - (this.imgKeyPad.width >> 1) + (28 - this.shapeWidth >> 1) + 2);
                    int n4 = i * 2 + 1;
                    nArray[n4] = nArray[n4] + (n2 + (this.imgKeyPad.height - this.shapeHeight >> 1));
                }
                break;
            }
            case 0: {
                for (int i = 0; i < nArray.length >> 1; ++i) {
                    int n5 = i * 2;
                    nArray[n5] = nArray[n5] + (160 + (this.imgKeyPad.width >> 1) - (28 + this.shapeWidth >> 1) - 2);
                    int n6 = i * 2 + 1;
                    nArray[n6] = nArray[n6] + (n2 + (this.imgKeyPad.height - this.shapeHeight >> 1));
                }
                break;
            }
            case 3: {
                for (int i = 0; i < nArray.length >> 1; ++i) {
                    int n7 = i * 2;
                    nArray[n7] = nArray[n7] + (320 - this.shapeWidth >> 1);
                    int n8 = i * 2 + 1;
                    nArray[n8] = nArray[n8] + (n2 + (28 - this.shapeHeight >> 1) + 2);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < nArray.length >> 1; ++i) {
                    int n9 = i * 2;
                    nArray[n9] = nArray[n9] + (320 - this.shapeWidth >> 1);
                    int n10 = i * 2 + 1;
                    nArray[n10] = nArray[n10] + (n2 + this.imgKeyPad.height - (28 + this.shapeHeight >> 1) - 2);
                }
                break;
            }
        }
    }

    public void drawOutlineShape(Graphics graphics, int[] nArray, int n) {
        int n2 = 0;
        graphics.setColor(n);
        for (int i = 0; i < nArray.length >> 1; ++i) {
            n2 = i == (nArray.length >> 1) - 1 ? 0 : ++n2;
            graphics.drawLine(nArray[i * 2], nArray[i * 2 + 1], nArray[n2 * 2], nArray[n2 * 2 + 1]);
        }
    }

    public void rotateVectorShape(int[][] nArray, int n) {
    }

    public boolean addBox(int n) {
        boolean bl = false;
        int n2 = Engine.rndPositive(this.gridWidth - 1);
        int n3 = 0;
        boolean bl2 = false;
        while (!bl2) {
            n2 = Engine.rndPositive(this.gridWidth);
            n3 = Engine.rndPositive(this.gridHeight);
            if (this.gridArray[n3][n2] >= 0) continue;
            this.gridArray[n3][n2] = n;
            bl = true;
            this.gridArrayType[n3][n2] = n;
            bl2 = true;
        }
        if (!bl) {
            for (int i = this.gridHeight - 1; i > 0; --i) {
                if (this.gridArray[i][n2] < 0) {
                    this.gridArray[i][n2] = n;
                    bl = true;
                    this.gridArrayType[i][n2] = n;
                }
                if (bl) break;
            }
        }
        return bl;
    }

    public void paintUFO(Graphics graphics) {
        int n = (this.gridHeight - 1) * (this.sgSpriteArray[0].getHeight() + 3);
        int n2 = (this.gridWidth - 1) * (this.sgSpriteArray[0].getWidth() + 3);
        int n3 = 24 + (this.imgSettingHeight - n >> 1);
        int n4 = 320 - n2 >> 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        graphics.setClip(320 - this.imgSettingWidth >> 1, 25, this.imgSettingWidth, this.imgSettingHeight);
        for (int i = 0; i < this.gridHeight; ++i) {
            for (int j = 0; j < this.gridWidth; ++j) {
                if (this.gridArrayType[i][j] < 0) continue;
                n5 = Engine.divideFixed(this.velocity_array[n8] << 8, 65536);
                n5 = Engine.multiFixed(n5, this.gameTicker << 8);
                int n9 = Engine.divideFixed(this.velocity_array[n8] << 2 << 8, 65536);
                n9 = Engine.multiFixed(n9, this.gameTicker << 3 << 8);
                n6 = Engine.multiFixed(Engine.sin(n9 >> 8), 512);
                switch (Engine.currentDifficulty) {
                    case 0: 
                    case 1: {
                        if (j < this.gridWidth >> 1) {
                            n7 = -n5;
                            break;
                        }
                        n7 = n5;
                        break;
                    }
                    case 2: {
                        if (j < this.gridWidth >> 1) {
                            n7 = -n5;
                            break;
                        }
                        n7 = n5;
                        break;
                    }
                }
                this.sgSpriteArray[n8].setPosition(n4 + j * (this.sgSpriteArray[n8].getWidth() + 3) + (this.sgSpriteArray[n8].getWidth() + 3 >> 1) - (this.sgSpriteArray[n8].getWidth() >> 1) + (n7 >> 8), n3 + i * (this.sgSpriteArray[n8].getHeight() + 3) + (n6 >> 8));
                this.sgSpriteArray[n8].paint(graphics, 0, 0);
                ++n8;
            }
        }
        graphics.setClip(0, 0, 320, 222);
    }

    public void tickAllSgSpriteAnimation(int n) {
        for (int i = 0; i < this.sgSpriteArray.length; ++i) {
            this.sgSpriteArray[i].tickAnimation(50 - n);
        }
    }

    public void setSpotlightPos(int n, int n2) {
        this.shapesPos[0] = n;
        this.shapesPos[1] = n2;
    }

    public void paintSpotlight(Graphics graphics) {
        graphics.setClip(0, 0, 320, 222);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, this.PLAY_AREA_Y, 320, 222 - this.imgTimer.height - this.PLAY_AREA_Y);
        this.drawOutlineShape(graphics, this.shapeUnderSpotlight, 0);
        graphics.setColor(0);
        graphics.setClip(0, this.PLAY_AREA_Y, 320, this.PLAY_AREA_HEIGHT);
        graphics.fillRect(0, this.PLAY_AREA_Y, 320, this.shapesPos[1] - this.PLAY_AREA_Y);
        graphics.fillRect(0, this.shapesPos[1], this.shapesPos[0], this.imgOrderSmall[0].height);
        graphics.fillRect(this.shapesPos[0] + this.imgOrderSmall[0].width, this.shapesPos[1], 320 - (this.shapesPos[0] + this.imgOrderSmall[0].width), this.imgOrderSmall[0].height);
        graphics.fillRect(0, this.shapesPos[1] + this.imgOrderSmall[0].height, 320, 222 - this.imgTimer.height - (this.shapesPos[1] + this.imgOrderSmall[0].height));
        this.imgOrderSmall[0].drawImage(graphics, this.shapesPos[0], this.shapesPos[1]);
        graphics.setClip(0, 0, 320, 222);
    }

    public void lightShow() {
        int n = this.shapesPos[0];
        int n2 = this.shapesPos[1];
        n = this.star_paths[this.nextPath][0] - this.star_paths[this.currentPath][0];
        n2 = this.star_paths[this.nextPath][1] - this.star_paths[this.currentPath][1];
        int n3 = n != 0 ? Engine.div(n << 8, 25600) : 0;
        int n4 = n2 != 0 ? Engine.div(n2 << 8, 25600) : 0;
        if (this.vel < 1792) {
            this.vel += Engine.div(1536, 2560);
        }
        this.percent += this.vel >> 8;
        if (this.percent >= 100) {
            ++this.nextPath;
            ++this.currentPath;
            if (this.nextPath >= this.star_paths.length) {
                this.nextPath = 0;
            }
            if (this.currentPath >= this.star_paths.length) {
                this.currentPath = 0;
                switch (Engine.currentDifficulty) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.getSpotlightOrder(this.moveSpotlightOrder);
                        for (int i = 0; i < this.star_paths.length; ++i) {
                            int n5 = this.moveSpotlightOrder[i];
                            this.star_paths[i][0] = this.shapeUnderSpotlight[n5 << 1] - (this.imgOrderSmall[0].width >> 1);
                            this.star_paths[i][1] = this.shapeUnderSpotlight[(n5 << 1) + 1] - (this.imgOrderSmall[0].height >> 1);
                        }
                        break;
                    }
                }
            }
            this.prevX = this.star_paths[this.currentPath][0];
            this.prevY = this.star_paths[this.currentPath][1];
            this.percent = 0;
            this.vel = 0;
        }
        int n6 = Engine.multiFixed(n3, this.percent << 8);
        n = this.star_paths[this.currentPath][0] + (n6 >> 8);
        n6 = Engine.multiFixed(n4, this.percent << 8);
        n2 = this.star_paths[this.currentPath][1] + (n6 >> 8);
        this.setSpotlightPos(n, n2);
    }

    public void getSpotlightOrder(int[] nArray) {
        for (int i = 1; i < nArray.length; ++i) {
            int n = Engine.rndPositive(this.shapeUnderSpotlight.length >> 1);
            if (i > 0) {
                while (n == nArray[i - 1]) {
                    n = Engine.rndPositive(this.shapeUnderSpotlight.length >> 1);
                }
            }
            nArray[i] = n;
        }
    }

    public void paintSpotlightChallenge(Graphics graphics) {
        int n = 39;
        for (int i = 0; i < this.numActiveOptions; ++i) {
            this.drawOutlineShape(graphics, this.shapeOnKeyPad1[i], 0);
        }
        this.setKeyPadTouchZone();
    }

    public void setToysOrder(int n) {
        this.imgToys = new DeviceImage[this.boxes_order[n]];
        int[] nArray = new int[this.imgToys.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = Engine.rndPositive(this.boxes_order.length);
            if (i >= 3) {
                int n3 = 0;
                for (int j = i - 3; j < i && nArray[j] == nArray[i - 3]; ++j) {
                    ++n3;
                }
                if (n3 == 3) {
                    while (n2 == nArray[i - 3]) {
                        n2 = Engine.rndPositive(this.boxes_order.length);
                    }
                }
            }
            nArray[i] = n2;
            this.imgToys[i] = this.imgOrderSmall[nArray[i]];
        }
    }

    public void tickWatchingTheBox() {
        if (!this.all_boxes_filled) {
            this.shapesPos[0] = 320 - this.boxes_order.length * this.shapeWidth - this.boxes_order.length * 2 >> 1;
            this.shapesPos[0] = this.shapesPos[0] + (this.current_box * this.shapeWidth + this.current_box * 2 + (this.shapeWidth >> 1));
            this.shapesPos[1] = this.shapesPos[1] + (this.vel >> 8);
        }
        if (this.chosenFruitAmount >= this.imgToys.length && !this.all_boxes_filled) {
            ++this.current_box;
            if (this.current_box >= this.boxes_order.length) {
                this.all_boxes_filled = true;
                this.sgSprite.startAnimation(0, 1);
            } else {
                this.shapesPos[1] = this.PLAY_AREA_Y - this.imgOrderSmall[0].height;
                this.setToysOrder(this.current_box);
            }
        }
        if (this.all_boxes_filled) {
            this.sgSprite.tickAnimation(50);
            if (this.sgSprite.animationDone) {
                this.finishCycle = true;
            }
        }
    }

    public void paintBoxesFillingUp(Graphics graphics) {
        int n;
        int n2 = 320 - this.boxes_order.length * (this.shapeWidth + 2) >> 1;
        int n3 = (222 - this.shapeHeight >> 1) + 20;
        graphics.setClip(0, 24, 320, 222 - this.imgTimer.height);
        this.chosenFruitAmount = 0;
        for (n = 0; n < this.boxes_order.length; ++n) {
            if (!this.all_boxes_filled) {
                this.imgTopCrate[n].drawImage(graphics, n2 + n * this.shapeWidth + n * 2, n3);
                continue;
            }
            if (n != this.removedBoxIndex) {
                this.imgTopCrate[n].drawImage(graphics, n2 + n * this.shapeWidth + n * 2, n3);
                continue;
            }
            this.sgSprite.paintAnchored(graphics, n2 + n * this.shapeWidth + n * 2, n3, 20);
        }
        if (!this.all_boxes_filled) {
            for (n = 0; n < this.imgToys.length; ++n) {
                if (this.shapesPos[1] - n * (this.imgToys[n].height + 3) < n3 + this.imgTopCrate[0].height) {
                    this.imgToys[n].drawImage(graphics, this.shapesPos[0] - (this.imgToys[n].height >> 1), this.shapesPos[1] - n * (this.imgToys[n].height + 3));
                    continue;
                }
                ++this.chosenFruitAmount;
            }
        }
        for (n = 0; n < this.boxes_order.length; ++n) {
            if (!this.all_boxes_filled) {
                this.imgBottomCrate[n].drawImage(graphics, n2 + n * this.shapeWidth + n * 2, n3 + this.imgTopCrate[0].height);
                continue;
            }
            if (n == this.removedBoxIndex) continue;
            this.imgBottomCrate[n].drawImage(graphics, n2 + n * this.shapeWidth + n * 2, n3 + this.imgTopCrate[0].height);
        }
    }

    public void paintRemainingBoxes(Graphics graphics) {
        int n = 320 - this.boxes_order.length * this.shapeWidth - this.boxes_order.length * 2 >> 1;
        int n2 = (222 - this.shapeHeight >> 1) + 20;
        for (int i = 0; i < this.boxes_order.length; ++i) {
            if (i == this.removedBoxIndex) continue;
            this.imgTopCrate[i].drawImage(graphics, n + i * this.shapeWidth + i * 2, n2);
            this.imgBottomCrate[i].drawImage(graphics, n + i * this.shapeWidth + i * 2, n2 + this.imgTopCrate[0].height);
        }
    }

    public void tickFruitBox() {
        if (Engine.currentDifficulty != 2) {
            return;
        }
        int n = 48 + this.numGoodResults * 2;
        n = Math.min(n, 100);
        int n2 = 6 + (this.numGoodResults >> 1);
        switch (Engine.currentDifficulty) {
            case 2: {
                n2 = 6 + (this.numGoodResults >> 2);
            }
        }
        if (this.vel < n2 << 8) {
            this.vel += Engine.divideFixed(n << 8, 65536);
        }
        this.gridOffSetX += this.shapesPos[0] * (this.vel >> 8);
        if (this.shapesPos[0] > 0) {
            if (this.gridOffSetX - this.shapeWidth > 320) {
                this.finishCycle = true;
            }
        } else if (this.gridOffSetX < 0 - this.shapeWidth * this.gridWidth) {
            this.finishCycle = true;
        }
    }

    public void paintFruitBox(Graphics graphics) {
        graphics.setClip(320 - this.imgSettingWidth >> 1, 24, this.imgSettingWidth, this.clipHeight);
        for (int i = 0; i < this.gridHeight; ++i) {
            for (int j = 0; j < this.gridWidth; ++j) {
                this.imgBoxTop[j].drawImage(graphics, this.gridOffSetX + j * this.imgCup[0].width, this.gridOffSetY + 0 * this.imgCup[0].height - this.imgBoxTop[0].height);
                if (j == 0) {
                    this.imgCrateTopCorners[0].drawImage(graphics, this.gridOffSetX + j * this.imgCup[0].width - this.imgCrateTopCorners[0].width, this.gridOffSetY + 0 * this.imgCup[0].height - (this.imgBoxTop[0].height << 1) + (this.imgBoxTop[0].height >> 1));
                    this.imgCrateBottomCorners[0].drawImage(graphics, this.gridOffSetX + j * this.imgCup[0].width - this.imgCrateBottomCorners[0].width, this.gridOffSetY + (this.gridHeight - 1) * this.imgCup[0].height);
                }
                if (j == this.gridWidth - 1) {
                    this.imgCrateTopCorners[1].drawImage(graphics, this.gridOffSetX + this.gridWidth * this.imgCup[0].width, this.gridOffSetY + 0 * this.imgCup[0].height - (this.imgBoxTop[0].height << 1) + (this.imgBoxTop[0].height >> 1));
                    this.imgCrateBottomCorners[1].drawImage(graphics, this.gridOffSetX + this.gridWidth * this.imgCup[0].width, this.gridOffSetY + (this.gridHeight - 1) * this.imgCup[0].height);
                }
                if (i > 0 && i < this.gridHeight - 1) {
                    this.imgLeft[i].drawImage(graphics, this.gridOffSetX + 0 * this.imgCup[0].width - this.imgLeft[0].width, this.gridOffSetY + i * this.imgCup[0].height);
                    this.imgRight[i].drawImage(graphics, this.gridOffSetX + this.gridWidth * this.imgCup[0].width, this.gridOffSetY + i * this.imgCup[0].height);
                }
                this.imgCup[i * this.gridWidth + j].drawImage(graphics, this.gridOffSetX + j * this.imgCup[0].width, this.gridOffSetY + i * this.imgCup[0].height);
                this.imgBottom[j].drawImage(graphics, this.gridOffSetX + j * this.imgCup[0].width, this.gridOffSetY + this.gridHeight * this.imgCup[0].height);
                this.imgFruits[i * this.gridWidth + j].drawImage(graphics, this.gridOffSetX + j * this.shapeWidth, this.gridOffSetY + i * this.shapeHeight);
            }
        }
        graphics.setClip(0, 0, 320, 222);
    }

    public void paintTestTubes(Graphics graphics) {
        int n = 82;
        int n2 = 46;
        for (int i = 0; i < this.water_glass_state.length; ++i) {
            this.sgSpriteArray[i].setPosition(n, n2);
            this.sgSpriteArray[i].paintAnchored(graphics, 0, 0, 20);
            n += this.shapeWidth + 9;
            if (i != 5) continue;
            n2 = 102;
            n = 82;
        }
    }

    public void setCardsFormation() {
        int n = this.gridHeight * this.gridWidth;
        int n2 = 0;
        int n3 = 320 - this.gridWidth * (this.shapeWidth + 2) >> 1;
        int n4 = 24 + (this.imgSettingHeight - this.gridHeight * (this.shapeHeight + 2) >> 1) - n2;
        if ((n == 6 || n == 10) && Engine.currentDifficulty != 0 && this.subType == 9) {
            int n5;
            int n6;
            this.formationType = 1;
            int n7 = 1;
            int n8 = 0;
            int n9 = 0;
            for (n6 = 0; n6 < n; ++n6) {
                for (n5 = 0; n5 < n7; ++n5) {
                    ++n8;
                }
                ++n7;
                if (n8 != n) continue;
                n9 = n6 + 1;
                break;
            }
            this.gridEdges = new int[n9];
            n7 = 1;
            n8 = 0;
            n3 = 160;
            n4 = 24 + (this.imgSettingHeight - n9 * (this.shapeHeight + 2) >> 1);
            for (n6 = 0; n6 < n9; ++n6) {
                n3 = 320 - n7 * (this.shapeWidth + 2) >> 1;
                for (n5 = 0; n5 < n7; ++n5) {
                    this.sgSpriteArray[n8].setPosition(n3 + n5 * (this.shapeWidth + 2), n4 + n6 * (this.shapeHeight + 2));
                    ++n8;
                }
                this.gridEdges[n6] = n7++;
            }
        } else {
            this.formationType = 0;
            this.gridEdges = new int[this.gridHeight];
            for (int i = 0; i < this.gridHeight; ++i) {
                this.gridEdges[i] = this.gridWidth;
                for (int j = 0; j < this.gridWidth; ++j) {
                    this.sgSpriteArray[i * this.gridWidth + j].setPosition(n3 + j * (this.shapeWidth + 2), n4 + i * (this.shapeHeight + 2));
                }
            }
        }
    }

    public void tickFlippingNumberChallenge() {
        for (int i = 0; i < this.gridHeight * this.gridWidth; ++i) {
            switch (this.cardState1[i]) {
                case 0: {
                    break;
                }
                case 2: {
                    this.sgSpriteArray[i].tickAnimation(50);
                    if (!this.sgSpriteArray[i].animationDone) break;
                    this.sgSpriteArray[i].setFrameSequence(2);
                    this.sgSpriteArray[i].setFrame(this.gridArray1[i]);
                    if (this.gridArray1[i] == this.wantedSum) {
                        this.cardState1[i] = 1;
                        if (this.subType == 9) {
                            this.wantedSum += this.incrementValue;
                        } else {
                            this.achievedSum = this.wantedSum;
                            this.userNumberString = "" + this.currentFactors[0] + OPERAND_STRING[this.currentOperand] + this.currentFactors[1] + "=" + this.wantedSum;
                            break;
                        }
                        ++this.lastRoundChangeTick;
                        --this.maxFlipped;
                        break;
                    }
                    this.cardState1[i] = 3;
                    this.achievedSum = -1;
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    break;
                }
                case 12: {
                    this.sgSpriteArray[i].tickAnimation(50);
                    if (!this.sgSpriteArray[i].animationDone) break;
                    this.sgSpriteArray[i].setFrameSequence(0);
                    this.cardState1[i] = 0;
                    --this.maxFlipped;
                }
            }
            if (this.cardState1[i] < 3 || this.cardState1[i] >= 12) continue;
            int n = i;
            this.cardState1[n] = this.cardState1[n] + 1;
            if (this.cardState1[i] != 12) continue;
            this.sgSpriteArray[i].startAnimation(1, 1);
        }
    }

    public void updateCursorPos(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.gridEdges.length; ++i) {
            n4 = 0;
            for (int j = 0; j < this.gridEdges[i]; ++j) {
                if (++n2 != this.cardID + 1) continue;
                n4 = j + 1;
                break;
            }
            if (n2 != this.cardID + 1) continue;
            n3 = i;
            break;
        }
        switch (n) {
            case 1: {
                if (this.formationType == 1) {
                    if (n3 - 1 >= 0) {
                        if (n4 <= this.gridEdges[n3] >> 1) {
                            this.cardID -= this.gridEdges[n3 - 1];
                            break;
                        }
                        this.cardID -= this.gridEdges[n3];
                        break;
                    }
                    this.cardID = this.gridHeight * this.gridWidth - this.gridEdges[this.gridEdges.length - 1];
                    break;
                }
                if (this.cardID - this.gridEdges[n3] < 0) {
                    this.cardID = this.gridHeight * this.gridWidth - this.gridEdges[n3] + (n4 - 1);
                    break;
                }
                this.cardID -= this.gridEdges[n3];
                break;
            }
            case 3: {
                if (this.formationType == 1) {
                    if (n3 + 1 < this.gridEdges.length) {
                        if (n4 <= this.gridEdges[n3] >> 1) {
                            this.cardID += this.gridEdges[n3];
                            break;
                        }
                        this.cardID += this.gridEdges[n3 + 1];
                        break;
                    }
                    this.cardID = 0;
                    break;
                }
                if (this.cardID + this.gridEdges[n3] >= this.gridWidth * this.gridHeight) {
                    this.cardID = n4 - 1;
                    break;
                }
                this.cardID += this.gridEdges[n3];
                break;
            }
            case 2: {
                if (this.formationType == 1) {
                    if (n4 >= this.gridEdges[n3]) {
                        this.cardID -= this.gridEdges[n3] - 1;
                        break;
                    }
                    ++this.cardID;
                    break;
                }
                if (++this.cardID < n3 * this.gridWidth + this.gridWidth) break;
                this.cardID = n3 * this.gridWidth + 0;
                break;
            }
            case 0: {
                if (this.formationType == 1) {
                    if (this.gridEdges[n3] <= 1) break;
                    if (n4 - 2 < 0) {
                        this.cardID += this.gridEdges[n3] - 1;
                        break;
                    }
                    --this.cardID;
                    break;
                }
                if (--this.cardID >= n3 * this.gridWidth) break;
                this.cardID = n3 * this.gridWidth + (this.gridWidth - 1);
            }
        }
    }

    public void paintFlippingNumbers(Graphics graphics) {
        int n;
        if (state == 1) {
            // empty if block
        }
        for (n = 0; n < this.gridHeight * this.gridWidth; ++n) {
            this.sgSpriteArray[n].paintAnchored(graphics, 0, 0, 20);
        }
        if (state == 1) {
            n = this.cardID;
            int n2 = this.sgSpriteArray[n].getX() + (this.shapeWidth >> 1);
            int n3 = this.sgSpriteArray[n].getY() + (this.shapeHeight >> 1);
            this.imgHand.drawImage(graphics, n2, n3);
        }
    }

    public void paintFlippingMathsSum(Graphics graphics) {
        if (this.imgTxtOverlay != null) {
            FontMgr.drawString(13, graphics, this.userNumberString, 60, this.displayInfoTextY + 12, 6);
        } else {
            String string = "" + this.currentFactors[0] + OPERAND_STRING[this.currentOperand] + this.currentFactors[1] + "=" + this.wantedSum;
            FontMgr.drawString(13, graphics, this.userNumberString, 320 - FontMgr.stringWidth(13, string) >> 1, this.displayInfoTextY + 12, 6);
        }
    }

    public void selectedSquare() {
        if (this.maxFlipped >= 2) {
            return;
        }
        if (this.cardState1[this.cardID] == 0) {
            this.shapesPos[0] = this.cardID;
            this.shapesPos[1] = this.cardID;
            this.cardState1[this.cardID] = 2;
            this.sgSpriteArray[this.cardID].startAnimation(0, 1);
            ++this.maxFlipped;
        }
    }

    public void setCursor(int n) {
        if (state == 1) {
            this.cardID = n;
        }
    }

    public void paintTxtOverlay(Graphics graphics) {
        if (this.imgTxtOverlay != null) {
            this.imgTxtOverlay.drawImage(graphics, 0, 184);
        }
    }

    public void tickFlippingMathChallenge() {
        switch (this.flippingMath_state) {
            case 3: {
                ++this.lastRoundChangeTick;
                switch (this.lastRoundChangeTick) {
                    case 10: {
                        this.userNumberString = "" + this.currentFactors[0];
                        break;
                    }
                    case 20: {
                        this.userNumberString = "" + this.currentFactors[0] + OPERAND_STRING[this.currentOperand];
                        break;
                    }
                    case 30: {
                        this.userNumberString = "" + this.currentFactors[0] + OPERAND_STRING[this.currentOperand] + this.currentFactors[1];
                        break;
                    }
                    case 40: {
                        this.userNumberString = "" + this.currentFactors[0] + OPERAND_STRING[this.currentOperand] + this.currentFactors[1] + "=";
                        break;
                    }
                    case 45: {
                        this.flippingMath_state = 0;
                        this.lastRoundChangeTick = 0;
                    }
                }
                break;
            }
            case 0: {
                int n;
                for (n = 0; n < this.gridHeight * this.gridWidth; ++n) {
                    this.sgSpriteArray[n].tickAnimation(50);
                }
                if (!this.sgSpriteArray[this.sgSpriteArray.length - 1].animationDone) break;
                for (n = 0; n < this.gridHeight * this.gridWidth; ++n) {
                    this.sgSpriteArray[n].setFrameSequence(2);
                    this.sgSpriteArray[n].setFrame(this.gridArray1[n]);
                }
                ++this.lastRoundChangeTick;
                if (this.lastRoundChangeTick != this.orderDelay) break;
                this.flippingMath_state = 1;
                this.lastRoundChangeTick = 0;
                break;
            }
            case 1: {
                ++this.lastRoundChangeTick;
                if (this.lastRoundChangeTick < 16) break;
                for (int i = 0; i < this.gridHeight * this.gridWidth; ++i) {
                    this.sgSpriteArray[i].startAnimation(1, 1);
                }
                this.flippingMath_state = 2;
                break;
            }
            case 2: 
            case 4: {
                int n;
                for (n = 0; n < this.gridHeight * this.gridWidth; ++n) {
                    this.sgSpriteArray[n].tickAnimation(50);
                }
                if (!this.sgSpriteArray[this.sgSpriteArray.length - 1].animationDone) break;
                for (n = 0; n < this.gridHeight * this.gridWidth; ++n) {
                    this.sgSpriteArray[n].setFrameSequence(0);
                }
                this.lastRoundChangeTick = 0;
                if (this.flippingMath_state == 4) {
                    this.flippingMath_state = 0;
                    break;
                }
                this.finishCycle = true;
                break;
            }
            case 5: {
                ++this.lastRoundChangeTick;
                if (this.lastRoundChangeTick < 8) break;
                this.flippingMath_state = 4;
            }
        }
    }

    public void paintFlippingMath(Graphics graphics) {
        this.shapeWidth = this.sgSpriteArray[0].getWidth();
        this.shapeHeight = this.sgSpriteArray[0].getHeight();
        int n = 320 - this.gridWidth * (this.shapeWidth + 2) >> 1;
        int n2 = 30 + this.shapeHeight;
        for (int i = 0; i < this.gridHeight; ++i) {
            for (int j = 0; j < this.gridWidth; ++j) {
                this.sgSpriteArray[i * this.gridWidth + j].setPosition(n + j * (this.shapeWidth + 2), n2 + i * (this.shapeHeight + 2));
                this.sgSpriteArray[i * this.gridWidth + j].paintAnchored(graphics, 0, 0, 20);
            }
        }
        if (state == 1) {
            this.imgHand.drawImage(graphics, n += this.cardID * (this.shapeWidth + 2) + (this.shapeWidth >> 1), n2 += this.cardID * (this.shapeHeight + 2) + (this.shapeHeight >> 1));
        }
    }

    public void tickLightSwitches2() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.numberOfWindows; ++n) {
            if (this.gridArray[n][this.orderIndex] > 0) {
                ++n2;
            }
            if (n != this.numberOfWindows - 1 || n2 != 0 || this.orderIndex + 1 >= this.windowCapacity) continue;
            ++this.orderIndex;
        }
        if (n2 >= 0) {
            if (this.flashLight) {
                if (this.gameTicker >= this.orderDelay) {
                    if (this.amountFlashed > 0) {
                        for (n = 0; n < this.numberOfWindows; ++n) {
                            if (this.gridArray[n][this.orderIndex] == 0) continue;
                            --this.amountFlashed;
                        }
                    }
                    if (this.amountFlashed <= 0) {
                        this.lightsOffDelay = 10;
                        this.amountFlashed = 0;
                    }
                    ++this.orderIndex;
                    if (this.orderIndex >= this.windowCapacity) {
                        this.orderIndex = this.windowCapacity - 1;
                    }
                    this.gameTicker = 0;
                    this.flashLight = false;
                    return;
                }
            } else if (this.gameTicker >= this.lightsOffDelay) {
                if (this.amountFlashed == 0) {
                    for (n = 0; n < this.numberOfWindows; ++n) {
                        for (int i = 0; i < this.windowCapacity; ++i) {
                            this.gridArray[n][i] = 0;
                        }
                    }
                    this.finishCycle = true;
                    return;
                }
                this.flashLight = true;
                this.gameTicker = 0;
            }
        }
    }

    public void paintWindows(Graphics graphics) {
        this.shapeWidth = this.imgWindows[0].width;
        this.shapeHeight = this.imgWindows[0].height;
        int n = 320 - 4 * this.shapeWidth >> 1;
        int n2 = 54;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.numberOfWindows; ++i) {
            this.imgWindows[i] = this.gridArray[i][this.orderIndex] == 0 || !this.flashLight ? this.imgOrder[this.gridArrayType[i][0]] : this.imgOrder[this.gridArrayType[i][0] + 5];
            this.imgWindows[i].drawImage(graphics, n + n3 * this.shapeWidth, n2 + n4 * (this.shapeHeight + 5));
            if (++n3 < 4) continue;
            n3 = 0;
            ++n4;
        }
    }

    public boolean addLightToList2(int n) {
        boolean bl = false;
        boolean bl2 = false;
        block0: while (!bl2) {
            int n2;
            boolean bl3 = false;
            int n3 = 0;
            int n4 = -1;
            int n5 = Engine.rndPositive(this.numberOfWindows);
            int n6 = 1 + Engine.rndPositive(this.maxWindowsShownAtOnce);
            for (n2 = 0; n2 < this.windowCapacity; ++n2) {
                n3 = 0;
                for (int i = 0; i < this.numberOfWindows; ++i) {
                    if (this.gridArray[i][n2] <= 0) continue;
                    ++n3;
                }
                if (n3 >= n6) continue;
                bl3 = true;
                n4 = n2;
                break;
            }
            if (!bl3) continue;
            for (n2 = 0; n2 < this.windowCapacity; ++n2) {
                if (this.gridArray[n5][n2] != 0 || n2 != n4) continue;
                this.gridArray[n5][n2] = 1;
                bl2 = true;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    public void tickOverlap() {
        int n = 320 - this.imgSettingWidth >> 1;
        for (int i = 0; i < this.shapeOrder.length; ++i) {
            int n2 = i << 1;
            this.shapesPos[n2] = this.shapesPos[n2] + this.shapesVectors[i << 1];
            int n3 = (i << 1) + 1;
            this.shapesPos[n3] = this.shapesPos[n3] + this.shapesVectors[(i << 1) + 1];
            if ((this.shapesPos[i << 1] + this.shapesVectors[i << 1] >> 8) + this.shapeWidth >= n + this.imgSettingWidth) {
                this.shapesPos[i << 1] = n + this.imgSettingWidth - this.shapeWidth - 1 << 8;
                this.shapesVectors[i << 1] = -this.shapesVectors[i << 1];
            } else if (this.shapesPos[i << 1] - this.shapesVectors[i << 1] >> 8 <= n) {
                this.shapesPos[i << 1] = n + 1 << 8;
                this.shapesVectors[i << 1] = -this.shapesVectors[i << 1];
            }
            if (this.shapesPos[(i << 1) + 1] - this.shapesVectors[(i << 1) + 1] >> 8 <= 24) {
                this.shapesPos[(i << 1) + 1] = 6400;
                this.shapesVectors[(i << 1) + 1] = -this.shapesVectors[(i << 1) + 1];
                continue;
            }
            if ((this.shapesPos[(i << 1) + 1] + this.shapesVectors[(i << 1) + 1] >> 8) + this.shapeHeight < 24 + this.imgSettingHeight - this.speachBubbleHeight) continue;
            this.shapesPos[(i << 1) + 1] = 24 + this.imgSettingHeight - this.speachBubbleHeight - this.shapeHeight - 1 << 8;
            this.shapesVectors[(i << 1) + 1] = -this.shapesVectors[(i << 1) + 1];
        }
    }

    public void paintOverlap(Graphics graphics) {
        for (int i = 0; i < this.shapeOrder.length; ++i) {
            int n;
            int[] nArray = new int[this.shapesXYPos[i].length >> 1];
            int[] nArray2 = new int[this.shapesXYPos[i].length >> 1];
            int[] nArray3 = new int[this.shapesXYPos[i].length];
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = this.shapesXYPos[i][j << 1] + (this.shapesPos[i << 1] >> 8);
                nArray2[j] = this.shapesXYPos[i][(j << 1) + 1] + (this.shapesPos[(i << 1) + 1] >> 8);
            }
            graphics.setColor(this.shapeFillColour[i]);
            DevicePolygon.fillPolygon(graphics, nArray, 0, nArray2, 0);
            int[] nArray4 = new int[this.shapesXYPos[i].length];
            for (n = 0; n < nArray4.length >> 1; ++n) {
                nArray4[n << 1] = nArray[n] - 1;
                nArray4[(n << 1) + 1] = nArray2[n];
            }
            this.drawOutlineShape(graphics, nArray4, 0xFFFFFF);
            for (n = 0; n < nArray4.length >> 1; ++n) {
                nArray4[n << 1] = nArray[n];
                nArray4[(n << 1) + 1] = nArray2[n];
            }
            this.drawOutlineShape(graphics, nArray4, 0xFFFFFF);
            for (n = 0; n < nArray4.length >> 1; ++n) {
                nArray4[n << 1] = nArray[n] - 1;
                nArray4[(n << 1) + 1] = nArray2[n] + 1;
            }
            this.drawOutlineShape(graphics, nArray4, 0xFFFFFF);
        }
    }

    public void resizePolygon(int[] nArray, int n, int n2) {
        int n3 = Engine.divideFixed(n << 8, this.shapeWidth << 8);
        int n4 = Engine.divideFixed(n2 << 8, this.shapeHeight << 8);
        for (int i = 0; i < nArray.length >> 1; ++i) {
            int n5 = Engine.multiFixed(n3, nArray[i << 1] << 8);
            int n6 = Engine.multiFixed(n4, nArray[(i << 1) + 1] << 8);
            nArray[i << 1] = n5 >> 8;
            nArray[(i << 1) + 1] = n6 >> 8;
        }
    }

    public void tickHeavyweight() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        if (this.achievedSum > 0) {
            for (n = 0; n < this.scaleTrays[this.currentPlate].length; ++n) {
                if (this.scaleTrays[this.currentPlate][n] != -1) continue;
                n4 = n;
                this.scaleTrays[this.currentPlate][n] = this.achievedSum;
                break;
            }
        }
        for (n = 0; n < this.scaleTrays[0].length; ++n) {
            if (this.scaleTrays[0][n] <= 0) continue;
            n2 += this.scaleTrays[0][n];
        }
        for (n = 0; n < this.scaleTrays[1].length; ++n) {
            if (this.scaleTrays[1][n] <= 0) continue;
            n3 += this.scaleTrays[1][n];
        }
        if (n2 == n3) {
            this.sgSprite.setFrame(0);
        } else if (n2 > n3) {
            this.sgSprite.setFrame(1);
        } else if (n2 < n3) {
            this.sgSprite.setFrame(2);
        }
        if (this.achievedSum > 0) {
            this.scaleTrays[this.currentPlate][n4] = -1;
        }
    }

    private void testFill(int n, int n2, int[] nArray) {
        int n3 = n;
        for (int i = 0; i < nArray.length; ++i) {
            if (i == nArray.length - 1) {
                nArray[i] = n3;
                n3 -= n3;
                continue;
            }
            int n4 = 1 + Engine.rndPositive(n - 1);
            if (n3 - n4 <= 0) continue;
            n3 -= n4;
            nArray[i] = n4;
        }
    }

    public void paintScales(Graphics graphics) {
        this.sgSprite.paintAnchored(graphics, 0, 0, 17);
    }

    public void paintHeavyweight(Graphics graphics) {
        System.out.println("1");
        this.paintScales(graphics);
        System.out.println("2");
        this.weightsWidth = 3 * this.weightsBronze[0].width;
        System.out.println("3");
        this.weightsHeight = this.weightsBronze[0].height;
        System.out.println("4");
        int n = 3;
        int n2 = 1;
        System.out.println("**" + n + "***" + n2);
        System.out.println(this.sgSprite.layerImageY.length);
        System.out.println("5");
        int n3 = this.sgSprite.layerImageY[this.sgSprite.getFrame()][n] + 107 + (this.sgSprite.getHeight() >> 1) + (this.weightsHeight >> 1) - 1;
        System.out.println("6");
        this.paintTrayAndWeight(graphics, 0, n3, n);
        System.out.println("7");
        n3 = this.sgSprite.layerImageY[this.sgSprite.getFrame()][n2] + 107 + (this.sgSprite.getHeight() >> 1) + (this.weightsHeight >> 1) - 1;
        System.out.println("8");
        this.paintTrayAndWeight(graphics, 1, n3, n2);
        System.out.println("9");
    }

    public void paintTrayAndWeight(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        boolean bl = false;
        for (int i = 0; i < this.scaleTrays[n].length; ++i) {
            int n5 = this.scaleTrays[n][i];
            boolean bl2 = false;
            if (this.scaleTrays[n][i] == -1) {
                n5 = this.wantedSum;
                bl2 = true;
            }
            if (n5 <= 0) continue;
            if (i == this.scaleTrays[n].length - 1 && n4 == 0) {
                bl = true;
            } else if (i + 1 < this.scaleTrays[n].length && n4 == 0 && n5 > 0 && this.scaleTrays[n][i + 1] == 0) {
                bl = true;
            }
            if (n5 >= 10 || bl) {
                this.drawWeightBar(graphics, n5, 160 + this.sgSprite.layerImageX[this.sgSprite.getFrame()][n3] + 29, n2 + 0, bl2);
                n2 -= this.weightsHeight;
                continue;
            }
            if (n5 <= 0 || n5 >= 10) continue;
            this.drawWeightBar(graphics, n5, 160 + this.sgSprite.layerImageX[this.sgSprite.getFrame()][n3] + (59 - 2 * this.weightsWidth >> 1) + (this.weightsWidth >> 1) + n4 * this.weightsWidth, n2 + 0, bl2);
            if (++n4 < 2) continue;
            n4 = 0;
            n2 -= this.weightsHeight;
        }
    }

    public void drawWeightBar(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = 1;
        DeviceImage[] deviceImageArray = this.weightsRed;
        int n5 = this.weightsBronze[0].height;
        int n6 = 7;
        if (n >= 10 && n < 20) {
            deviceImageArray = this.weightsBronze;
            n4 = 3;
            n6 = 8;
        } else if (n >= 20 && n < 30) {
            deviceImageArray = this.weightsSilver;
            n4 = 3;
            n6 = 9;
        } else if (n >= 30 && n < 100) {
            deviceImageArray = this.weightsGold;
            n4 = 4;
            n6 = 10;
        }
        if (Device.FONT_TYPE[7] != 0) {
            n6 = 4;
        }
        int n7 = deviceImageArray[0].width * 2 + n4 * deviceImageArray[0].width;
        if (state == 1 || state == 2 || state == 5) {
            deviceImageArray[0].drawImage(graphics, (n2 -= n7 >> 1) + 0 * this.weightsBronze[0].width, n3);
            for (int i = 0; i < n4; ++i) {
                deviceImageArray[1].drawImage(graphics, n2 + (i + 1) * this.weightsBronze[0].width, n3);
            }
            deviceImageArray[2].drawImage(graphics, n2 + (n4 + 1) * this.weightsBronze[0].width, n3);
        }
        String string = "" + n;
        if (bl) {
            string = "";
        }
        if (state == 2 && bl) {
            string = "" + this.achievedSum;
        } else if (state == 1 && bl && this.achievedSum > 0) {
            string = "" + this.achievedSum;
        }
        FontMgr.drawString(n6, graphics, string, n2 + (n7 >> 1), n3 + (n5 - FontMgr.lineHeight[n6] >> 1), 17);
    }

    public void tickWindowGame() {
        int n;
        int n2;
        int n3;
        boolean[] blArray = new boolean[2];
        for (n3 = 0; n3 < blArray.length; ++n3) {
            blArray[n3] = false;
        }
        n3 = 0;
        switch (Engine.currentDifficulty) {
            case 0: {
                n3 = 38144;
                break;
            }
            case 1: {
                n3 = 43520;
                break;
            }
            case 2: {
                n3 = 43520;
            }
        }
        n3 = Math.min(n3, 51200);
        block16: for (n2 = n = this.animateWindow == 2 ? 0 : this.animateWindow; n2 < (this.animateWindow == 2 ? this.windowState.length : this.animateWindow + 1); ++n2) {
            if (this.windowShowFaceIndex[n2] >= this.windowsOrder[n2].length) continue;
            switch (this.windowState[n2]) {
                case 0: {
                    this.curtainWidth[n2] = 0;
                    this.windowState[n2] = 1;
                    this.sgBlinds[n2].startAnimation(0, 1);
                    continue block16;
                }
                case 1: {
                    int n4 = n2;
                    this.curtainWidth[n4] = this.curtainWidth[n4] + 256;
                    this.sgBlinds[n2].tickAnimation(n3 >> 8);
                    if (!this.sgBlinds[n2].animationDone) continue block16;
                    this.sgBlinds[n2].startAnimation(1, 1);
                    this.windowState[n2] = 3;
                    continue block16;
                }
                case 2: {
                    this.sgBlinds[n2].tickAnimation(n3 >> 8);
                    if (!this.sgBlinds[n2].animationDone) continue block16;
                    this.windowState[n2] = 0;
                    if (this.windowShowFaceIndex[n2] < this.windowsOrder[n2].length) {
                        int n5 = n2;
                        this.windowShowFaceIndex[n5] = this.windowShowFaceIndex[n5] + 1;
                    }
                    if (this.windowShowFaceIndex[n2] < this.windowsOrder[n2].length) continue block16;
                    blArray[n2] = true;
                    switch (this.animateWindow) {
                        case 0: {
                            this.animateWindow = 1;
                            break;
                        }
                        case 1: {
                            this.animateWindow = 0;
                        }
                    }
                    this.windowState[n2] = 0;
                    continue block16;
                }
                case 3: {
                    this.windowState[n2] = 2;
                    this.curtainWidth[n2] = 0;
                }
            }
        }
        this.finishCycle = false;
        n2 = 0;
        for (int i = 0; i < this.windowState.length; ++i) {
            if (this.windowShowFaceIndex[i] < this.windowsOrder[i].length) continue;
            ++n2;
        }
        if (n2 == this.windowsOrder.length) {
            this.finishCycle = true;
        }
    }

    public void paintWindowGame(Graphics graphics) {
        int n;
        int n2;
        int n3 = 72;
        int n4 = 84;
        int n5 = 53;
        for (n2 = 0; n2 < this.windowsOrder.length; ++n2) {
            if (this.windowShowFaceIndex[n2] < this.windowsOrder[n2].length && this.windowsOrder[n2][this.windowShowFaceIndex[n2]] != 0) {
                if (this.windowsOrder[n2][this.windowShowFaceIndex[n2]] < 0 && this.profileImage != null) {
                    n = Math.abs(this.windowsOrder[n2][this.windowShowFaceIndex[n2]]) - 1;
                    System.out.println("face = " + n);
                    this.profileImage[n].drawImageScaled(graphics, n3 + n2 * (this.windowWidth + n5), n4);
                } else {
                    this.sgSpriteArray[n2].setPosition(n3 + n2 * (this.windowWidth + n5) + (this.windowWidth >> 1), n4 + (this.windowHeight >> 1));
                    this.sgSpriteArray[n2].paintAnchored(graphics, this.windowsOrder[n2][this.windowShowFaceIndex[n2]] - 1, 0, 0, 3);
                }
            }
            this.sgBlinds[n2].setPosition(n3 + n2 * (this.windowWidth + n5) + (this.windowWidth >> 1), n4 + (this.windowHeight >> 1));
            this.sgBlinds[n2].paintAnchored(graphics, 0, 0, 3);
        }
        n2 = n3 + (this.windowWidth >> 1) - (this.orderArrows[0].width >> 1);
        n = n3 + this.windowWidth + n5 + (this.windowWidth >> 1) - (this.orderArrows[0].width >> 1);
        int n6 = n4 + this.windowHeight + this.orderArrows[0].height - 120;
        if (state != 0) {
            if (this.achievedSum == 1) {
                this.orderArrows[0].drawImage(graphics, n2, n6);
            } else if (this.achievedSum == 2) {
                this.orderArrows[1].drawImage(graphics, n, n6);
            } else {
                this.orderArrows[0].drawImage(graphics, n2, n6);
                this.orderArrows[1].drawImage(graphics, n, n6);
            }
        }
    }

    public void tickTree() {
        int n = 0;
        int n2 = 3;
        for (int i = 0; i < this.numLeaves; ++i) {
            int n3 = this.velocity_array[i << 1];
            int n4 = Engine.multiFixed(this.gameTicker << 8, 768);
            int n5 = Engine.sin(n4 >> 8);
            this.shapesVectors[i << 1] = n3 = Engine.multiFixed(n3, n5 << 8);
            int n6 = (i << 1) + 1;
            this.shapesVectors[n6] = this.shapesVectors[n6] + (this.velocity_array[(i << 1) + 1] + n);
            if (this.gameTicker % 30 == 0) {
                if (this.velocity_array[i << 1] > Engine.divideFixed(n2, 256)) {
                    int n7 = i << 1;
                    this.velocity_array[n7] = this.velocity_array[n7] - Engine.divideFixed(1, 256);
                } else if (this.velocity_array[i << 1] < -Engine.divideFixed(n2, 256)) {
                    int n8 = i << 1;
                    this.velocity_array[n8] = this.velocity_array[n8] + Engine.divideFixed(1, 256);
                }
            }
            this.sgSpriteArray[i].setPosition(this.shapesPos[i << 1] + (this.shapesVectors[i << 1] >> 8), this.shapesPos[(i << 1) + 1] + (this.shapesVectors[(i << 1) + 1] >> 8));
            this.sgSpriteArray[i].tickAnimation(50 + (n >> 8));
        }
    }

    public void paintTree(Graphics graphics) {
        boolean bl = false;
        if (bl) {
            graphics.setColor(0xFF0000);
            graphics.drawRect(320 - this.imgSettingWidth >> 1, 24, this.imgSettingWidth, this.clipHeight);
            System.out.println("GW.paintTree(): clipHeight = " + this.clipHeight);
        } else {
            graphics.setClip(320 - this.imgSettingWidth >> 1, 25, this.imgSettingWidth, this.clipHeight);
        }
        for (int i = 0; i < this.numLeaves; ++i) {
            this.sgSpriteArray[i].paintAnchored(graphics, 0, 0, 3);
        }
    }

    public void paintTreeChoices(Graphics graphics) {
        int n = 39;
        System.out.println(this.imgKeyPad.width);
        this.imgKeyPad.drawImage(graphics, 320 - this.imgKeyPad.width >> 1, n);
        this.sgSpriteArray[0].setFrameSequence(0);
        this.sgSpriteArray[0].setPosition(160 - (this.imgKeyPad.width >> 1) + 14 + 2, n + (this.imgKeyPad.height >> 1));
        this.sgSpriteArray[0].paintAnchored(graphics, 0, 0, 3);
        this.sgSpriteArray[1].setFrameSequence(0);
        this.sgSpriteArray[1].setPosition(160 + (this.imgKeyPad.width >> 1) - 14 - 2, n + (this.imgKeyPad.height >> 1));
        this.sgSpriteArray[1].paintAnchored(graphics, 0, 0, 3);
        if (this.leaves_list.length >= 3) {
            this.sgSpriteArray[2].setFrameSequence(0);
            this.sgSpriteArray[2].setPosition(160, n + 14 + 2);
            this.sgSpriteArray[2].paintAnchored(graphics, 0, 0, 3);
        }
        if (this.leaves_list.length >= 4) {
            this.sgSpriteArray[3].setFrameSequence(0);
            this.sgSpriteArray[3].setPosition(160, n + this.imgKeyPad.height - 14 - 2);
            this.sgSpriteArray[3].paintAnchored(graphics, 0, 0, 3);
        }
        this.setKeyPadTouchZone();
    }

    public void paintTelephoneWhiteBox(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        int n = 50 + this.wantedOrder.length * 5;
        graphics.fillRoundRect(320 - n >> 1, 24 + (this.imgSettingHeight - n >> 1), n, n, 8, 8);
        graphics.setColor(0x848284);
        graphics.drawRoundRect(320 - n >> 1, 24 + (this.imgSettingHeight - n >> 1), n, n, 8, 8);
    }

    public void setKeyPadTouchZone() {
    }

    public void removeGuiZone(boolean bl) {
    }

    public void initTouchNumberKeyPadBoxes() {
    }

    public void paintTouchNumberKeyPad(Graphics graphics) {
    }

    static {
        GAME_MENU = new int[][]{{15, 8, 5, 11}, {4, 3, 9, 1}, {10, 13, 6, 0}, {14, 2, 7, 12}};
        CATEGORY_BG_COLOURS = new int[]{12889432, 7512769, 13004677, 7387773};
        OPERAND_STRING = new String[]{"+", "-", "*", "/"};
        EASY_SHAPES_LIST = new int[]{1, 6, 8, 9, 11, 15, 18, 21, 22, 25};
        MEDIUM_SHAPES_LIST = new int[]{2, 3, 4, 5, 7, 13, 14, 19, 23, 24};
        HARD_SHAPES_LIST = new int[]{10, 12, 16, 17, 20};
        keypad_pos = new int[]{2, 0, 3, 1};
        HALF_PRECISION = Engine.divideFixed(256, 512);
        QUARTER_PRECISION = Engine.divideFixed(256, 1024);
        THREE_QUARTERS_PRECISION = Engine.multiFixed(Engine.divideFixed(256, 1024), 768);
        polygonFillColour = new int[]{0xFF8080, 16770688, 11075456, 0x80FF80, 8442111, 9797887, 0xFF80FF};
    }
}

