/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.RM;

import com.spl.j2me.Game.Constants;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class ResourceManager
implements Constants {
    public static String m_prefixPackageName = "";
    public static Vector resCache = new Vector();
    static Vector resCacheMap = new Vector();
    static boolean DEBUG = true;
    private static int currentCacheIdx = -1;
    private static int currentLoadingResourceID = -1;
    private static int currentLoadingPackageID = -1;
    private static int[] loadingPackageSequence;
    public static boolean isLoading;

    public static final void setResourcePackagePrefix(String string) {
        m_prefixPackageName = string + "_";
    }

    public static final byte[] getBinaryData(int n) throws Exception {
        byte[] byArray = null;
        int n2 = n >> 16;
        int n3 = n & 0xFFFF;
        DataInputStream dataInputStream = null;
        dataInputStream = new DataInputStream(m_prefixPackageName.getClass().getResourceAsStream("/" + m_prefixPackageName + n2));
        dataInputStream.readInt();
        if (dataInputStream != null) {
            int n4 = n3;
            while (n4-- > 0) {
                dataInputStream.skip(dataInputStream.readInt());
            }
            int n5 = dataInputStream.readInt();
            byArray = new byte[n5];
            dataInputStream.readFully(byArray);
        }
        if (dataInputStream != null) {
            dataInputStream.close();
            dataInputStream = null;
        }
        return byArray;
    }

    public static final Image getImageData(int n) throws Exception {
        return ResourceManager.createImage(ResourceManager.getBinaryData(n));
    }

    public static final Image getImageData(String string) throws Exception {
        return Image.createImage((String)string);
    }

    public static final Image createImage(byte[] byArray) throws Exception {
        return Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
    }

    public static final String getStringData(int n, String string) throws Exception {
        if (string.equals("UTF-8")) {
            return ResourceManager.decodeUTF8(ResourceManager.getBinaryData(n));
        }
        return new String(ResourceManager.getBinaryData(n), string);
    }

    public static final String getStringData(int n, String[][] stringArray) throws Exception {
        return stringArray[n >> 16][n & 0xFFFF];
    }

    public static final int getPackPartsCount(String string) throws Exception {
        int n = 0;
        InputStream inputStream = null;
        do {
            if (inputStream != null) {
                inputStream.close();
                inputStream = null;
            }
            if ((inputStream = m_prefixPackageName.getClass().getResourceAsStream("/" + string + "_" + n)) == null) continue;
            ++n;
        } while (inputStream != null);
        return n;
    }

    public static final String[][] loadFullStringPack(String string, String string2) throws Exception {
        String[][] stringArray = null;
        int n = ResourceManager.getPackPartsCount(string);
        stringArray = new String[n][];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ResourceManager.loadStringPack(string, i, string2);
        }
        return stringArray;
    }

    public static final String[] loadStringPack(String string, int n, String string2) throws Exception {
        String[] stringArray = null;
        DataInputStream dataInputStream = null;
        dataInputStream = new DataInputStream(m_prefixPackageName.getClass().getResourceAsStream("/" + string + "_" + n));
        if (dataInputStream != null) {
            int n2 = dataInputStream.readInt();
            stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                int n3 = dataInputStream.readInt();
                byte[] byArray = new byte[n3];
                dataInputStream.readFully(byArray);
                stringArray[i] = string2.equals("UTF-8") ? ResourceManager.decodeUTF8(byArray) : new String(byArray, string2);
                byArray = null;
            }
        }
        if (dataInputStream != null) {
            dataInputStream.close();
            dataInputStream = null;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[][] loadTileDataFromBinaryFile(byte[] byArray) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        int[][] nArray = null;
        try {
            int n = dataInputStream.readShort();
            nArray = new int[n][4];
            short[] sArray = new short[n];
            int n2 = -1;
            while (++n2 < n) {
                sArray[n2] = dataInputStream.readShort();
            }
            n2 = -1;
            while (++n2 < n) {
                nArray[sArray[n2]][0] = dataInputStream.readShort();
                nArray[sArray[n2]][1] = dataInputStream.readShort();
                nArray[sArray[n2]][2] = dataInputStream.readShort();
                nArray[sArray[n2]][3] = dataInputStream.readShort();
            }
            sArray = null;
        }
        catch (IOException iOException) {
            if (DEBUG) {
                System.out.println("Error during loading house_area tile frames data!");
            }
        }
        finally {
            try {
                dataInputStream.close();
            }
            catch (Exception exception) {}
            dataInputStream = null;
        }
        return nArray;
    }

    public static void initPackageLoading(int[] nArray) {
        currentLoadingPackageID = 0;
        loadingPackageSequence = nArray;
        currentCacheIdx = 0;
        ResourceManager.setResourcePackagePrefix(Constants.loadingPackageNames[loadingPackageSequence[currentLoadingPackageID]]);
        isLoading = true;
    }

    public static void loadingTick() {
        if (!isLoading) {
            return;
        }
        int n = loadingPackageSequence[currentLoadingPackageID];
        if (Constants.loadingPackage[n].length != 0) {
            switch (Constants.loadingPackage[n][currentCacheIdx][0]) {
                case 0: {
                    try {
                        Image image = ResourceManager.getImageData(Constants.loadingPackage[n][currentCacheIdx][1]);
                        if (image == null) break;
                        resCache.addElement(image);
                        resCacheMap.addElement(new Integer(n << 24 | Constants.loadingPackage[n][currentCacheIdx][1]));
                        ++currentCacheIdx;
                    }
                    catch (Exception exception) {
                        if (DEBUG) {
                            System.out.println("Cannot load resource: res_id " + Constants.loadingPackage[n][currentCacheIdx][1]);
                            System.out.println("res_type " + Constants.loadingPackage[n][currentCacheIdx][0]);
                        }
                        exception.printStackTrace();
                    }
                    break;
                }
                case 1: {
                    try {
                        byte[] byArray = ResourceManager.getBinaryData(Constants.loadingPackage[n][currentCacheIdx][1]);
                        if (byArray == null) break;
                        resCache.addElement(byArray);
                        resCacheMap.addElement(new Integer(n << 24 | Constants.loadingPackage[n][currentCacheIdx][1]));
                        ++currentCacheIdx;
                        break;
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break;
                        System.out.println("Cannot load resource: res_id " + Constants.loadingPackage[n][currentCacheIdx][1]);
                        System.out.println("res_type " + Constants.loadingPackage[n][currentCacheIdx][0]);
                    }
                }
            }
        }
        if (currentCacheIdx == Constants.loadingPackage[n].length && currentLoadingPackageID < loadingPackageSequence.length - 1) {
            currentCacheIdx = 0;
            ResourceManager.setResourcePackagePrefix(Constants.loadingPackageNames[loadingPackageSequence[++currentLoadingPackageID]]);
        } else if (currentCacheIdx == Constants.loadingPackage[n].length && currentLoadingPackageID == loadingPackageSequence.length - 1) {
            isLoading = false;
        }
    }

    public static int getCachedID(int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (resCacheMap.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return resCacheMap.indexOf(new Integer(n << 24 | n2));
    }

    public static void unloadResourceFromQueue(int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (resCache.isEmpty() && resCacheMap.isEmpty()) {
            System.out.println("cache is empty");
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = ResourceManager.getCachedID(n, n2);
        if (n3 != -1) {
            resCache.removeElementAt(n3);
            resCacheMap.removeElementAt(n3);
        } else if (DEBUG) {
            System.out.println("Index: " + n2 + " from package " + n + " are not int cache!!!");
        }
    }

    public static void unloadQueue() {
        resCache.removeAllElements();
        resCacheMap.removeAllElements();
    }

    public static final String decodeUTF8(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c;
            int n3 = byArray[i] & 0xFF;
            if (n3 <= 127) {
                cArray[n2++] = (char)n3;
                continue;
            }
            if (n3 >> 3 == 30) {
                c = (char)(n3 & 7);
                n3 = byArray[i + 1] & 0xFF;
                c = (char)(c << 6 | (char)(n3 & 0x3F));
                n3 = byArray[i + 2] & 0xFF;
                c = (char)(c << 6 | (char)(n3 & 0x3F));
                n3 = byArray[i + 3] & 0xFF;
                c = (char)(c << 6 | (char)(n3 & 0x3F));
                cArray[n2++] = c;
                i += 3;
                continue;
            }
            if (n3 >> 4 == 14) {
                c = (char)(n3 & 0xF);
                n3 = byArray[i + 1] & 0xFF;
                c = (char)(c << 6 | (char)(n3 & 0x3F));
                n3 = byArray[i + 2] & 0xFF;
                c = (char)(c << 6 | (char)(n3 & 0x3F));
                cArray[n2++] = c;
                i += 2;
                continue;
            }
            if (n3 >> 5 != 6) continue;
            c = (char)(n3 & 0x1F);
            n3 = byArray[i + 1] & 0xFF;
            c = (char)(c << 6 | (char)(n3 & 0x3F));
            cArray[n2++] = c;
            ++i;
        }
        return new String(cArray, 0, n2);
    }

    static {
        isLoading = false;
    }
}

