/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Game;

import com.spl.j2me.Animation.TiledAnimation;
import com.spl.j2me.GUIIC.ControlItem;
import com.spl.j2me.Game.ICallbackNotify;
import com.spl.j2me.RM.ResourceManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameProduct
extends ControlItem {
    public static final int PRODUCT_STATE_ON_MEADOW = 0;
    public static final int PRODUCT_STATE_MOVING_TO_DEPOT = 1;
    public static final int PRODUCT_STATE_IN_DEPOT = 2;
    public static final int PRODUCT_STATE_MOVING_TO_PRODUCING_BUILDING = 3;
    public static final int PRODUCT_STATE_DROPPED_OUT = 4;
    public static final int PRODUCT_STATE_PARASHUTED = 5;
    public static final int PRODUCT_LIFE_TIME = 24576;
    TiledAnimation productAnimation;
    ICallbackNotify callbackParent;
    protected byte productCurrentState;
    protected int screenX;
    protected int screenY;
    protected boolean isMovingEnabled = false;
    protected int movingDelay = 0;
    protected int movingTimer = -1;
    protected boolean isVisible = true;
    protected int movingDirectionX;
    protected int movingDirectionY;
    protected int movingSpeed = 400;
    protected byte productType;
    protected int buildingFacilityID = -1;
    protected int[] targetBox;
    protected int lifeTimer = 24576;
    protected int deathTimer = 0;
    protected boolean isCatched = false;
    protected int parashuteImageID;
    protected int shadowImageID;
    protected int parashuteOffset = 0;
    protected int oldScreenY = 0;

    public GameProduct(int n, int n2) {
        super(n);
        this.productType = (byte)n2;
    }

    public boolean isCatched() {
        return this.isCatched;
    }

    public void setCatched(boolean bl) {
        this.isCatched = bl;
    }

    public void setCallbackParent(ICallbackNotify iCallbackNotify) {
        this.callbackParent = iCallbackNotify;
    }

    public boolean isParashute() {
        return this.productCurrentState == 5;
    }

    public void setTarget(int[] nArray, int n, int n2, int n3, int n4) {
        this.targetBox = nArray;
        this.buildingFacilityID = n;
        this.movingDirectionX = n2;
        this.movingDirectionY = n3;
        this.isMovingEnabled = true;
        this.movingDelay = n4;
        int n5 = 0;
        int n6 = 0;
        if (n2 != 0) {
            n5 = (Math.abs(nArray[0] - (this.screenX + this.width / 2)) << 11) * 2048 / (Math.abs(n2) * this.movingSpeed);
        }
        if (n3 != 0) {
            n6 = (Math.abs(nArray[1] - (this.screenY + this.height / 2)) << 11) * 2048 / (Math.abs(n3) * this.movingSpeed);
        }
        this.movingTimer = n5 < n6 ? n5 : n6;
    }

    public void setControlItemRect(int[] nArray) {
        this.x = nArray[0] << 11;
        this.y = nArray[1] << 11;
        this.screenX = nArray[0];
        this.screenY = nArray[1];
        this.width = nArray[2];
        this.height = nArray[3];
    }

    public void open() {
    }

    public void close() {
    }

    public void delete() {
    }

    public void draw(Graphics graphics) {
        if (this.isVisible && this.productCurrentState != 2) {
            if (this.productCurrentState == 5) {
                Image image = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(this.parashuteImageID >> 24, this.parashuteImageID & 0xFFFFFF));
                Image image2 = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(this.shadowImageID >> 24, this.shadowImageID & 0xFFFFFF));
                graphics.drawImage(image, this.screenX + (this.width - image.getWidth()) / 2, this.screenY - image.getHeight(), 0);
                graphics.drawImage(image2, this.screenX + (this.width - image2.getWidth()) / 2, this.oldScreenY + this.height - image2.getHeight() / 2, 0);
            }
            if (this.productAnimation != null) {
                this.productAnimation.draw(graphics);
            }
        }
    }

    public void setShadowImage(int n) {
        this.shadowImageID = n;
    }

    public int[] getPosition() {
        return new int[]{this.screenX + this.width / 2, this.screenY + this.height / 2};
    }

    public int getDistance(int n, int n2) {
        return (this.screenX - n) * (this.screenX - n) + (this.screenY - n2) * (this.screenY - n2);
    }

    public void updatePosition(int n, int n2) {
        this.screenX = n;
        this.screenY = n2;
        this.x = this.screenX << 11;
        this.y = this.screenY << 11;
        if (this.productAnimation != null) {
            this.productAnimation.updateAnimationPosition(this.screenX, this.screenY);
        }
    }

    public void setTiledAnimation(TiledAnimation tiledAnimation) {
        this.productAnimation = tiledAnimation;
        this.productAnimation.updateAnimationPosition(this.screenX, this.screenY);
        this.productAnimation.setFrameToDraw(this.productType);
    }

    public int[] getBoudingBox() {
        return new int[]{this.screenX, this.screenY, this.width, this.height};
    }

    public boolean isIntersected(int n, int n2, int n3, int n4) {
        return Math.abs(this.screenX + this.width / 2 - n) < (n3 + this.width) / 2 && Math.abs(this.screenY + this.height / 2 - n2) < (n4 + this.height) / 2;
    }

    public void setState(int n) {
        this.productCurrentState = (byte)n;
        switch (this.productCurrentState) {
            case 0: {
                this.isVisible = true;
                this.isMovingEnabled = false;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.isVisible = true;
                this.isMovingEnabled = true;
                break;
            }
            case 2: {
                this.isVisible = false;
                this.isMovingEnabled = false;
                break;
            }
            case 5: {
                this.isVisible = true;
                this.parashuteOffset = -327680;
                this.oldScreenY = this.screenY;
                this.updatePosition(this.screenX, this.oldScreenY + this.parashuteOffset);
            }
        }
    }

    public void setParashuteImage(int n) {
        this.parashuteImageID = n;
    }

    public void tick(long l) {
        if (this.productCurrentState == 2) {
            return;
        }
        if (this.productCurrentState == 5) {
            this.parashuteOffset = (int)((long)this.parashuteOffset + 50L * (l << 11) / 1000L);
            this.updatePosition(this.screenX, this.oldScreenY + (this.parashuteOffset >> 11));
            if (this.parashuteOffset > 0) {
                this.productCurrentState = 0;
            }
        }
        if (this.isMovingEnabled) {
            if (this.movingDelay > 0) {
                this.movingDelay = (int)((long)this.movingDelay - (l << 11) / 1000L);
                this.isVisible = false;
                return;
            }
            if (this.movingDelay < 0) {
                this.isVisible = true;
                this.movingDelay = 0;
            }
            this.movingTimer = (int)((long)this.movingTimer - (l << 11) / 1000L);
            if (this.movingTimer <= 0) {
                if (this.productCurrentState == 4) {
                    this.callbackParent.onComplete(0, -1, this.controlID);
                } else {
                    this.callbackParent.onProductReachDestination(this.controlID, this.buildingFacilityID);
                }
            } else {
                this.x = (int)((long)this.x + (long)(this.movingDirectionX * this.movingSpeed) * l / 1000L);
                this.y = (int)((long)this.y + (long)(this.movingDirectionY * this.movingSpeed) * l / 1000L);
                this.screenX = this.x >> 11;
                this.screenY = this.y >> 11;
                if (this.productAnimation != null) {
                    this.productAnimation.updateAnimationPosition(this.screenX, this.screenY);
                }
            }
        }
        if (this.productCurrentState == 0) {
            this.lifeTimer = (int)((long)this.lifeTimer - (l << 11) / 1000L);
            if (this.lifeTimer < 4096 && this.lifeTimer > 0) {
                if (this.deathTimer < 0) {
                    this.deathTimer = this.isVisible ? 204 : 409;
                    this.isVisible = !this.isVisible;
                } else {
                    this.deathTimer = (int)((long)this.deathTimer - (l << 11) / 1000L);
                }
            }
            if (this.lifeTimer <= 0 && this.callbackParent != null) {
                this.callbackParent.onComplete(0, -1, this.controlID);
            }
        }
    }

    public boolean pointerPressed(int n, int n2) {
        if (Math.abs(this.screenX + this.width / 2 - n) < this.width && Math.abs(this.screenY + this.height / 2 - n2) < this.height) {
            if (this.callbackParent != null && (this.productCurrentState == 0 || this.productCurrentState == 5)) {
                this.callbackParent.onProductClick(this.controlID);
            }
            return true;
        }
        return false;
    }

    public boolean pointerReleased(int n, int n2) {
        return true;
    }

    public boolean pointerDragged(int n, int n2) {
        return true;
    }

    public boolean keyPressed(int n) {
        return true;
    }

    public boolean keyReleased(int n) {
        if (this.callbackParent != null && (this.productCurrentState == 0 || this.productCurrentState == 5)) {
            this.callbackParent.onProductClick(this.controlID);
        }
        return true;
    }

    public boolean keyRepeated(int n) {
        return true;
    }
}

