/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Game;

import com.spl.j2me.Animation.TiledAnimation;
import com.spl.j2me.GUIIC.ControlItem;
import com.spl.j2me.Game.ICallbackNotify;
import javax.microedition.lcdui.Graphics;

public class GameGrass
extends ControlItem {
    private TiledAnimation grassAnimation;
    private ICallbackNotify callbackParent;
    private int durability = 245760;
    private static final int lifeDrain = 1024;
    private boolean appearingAnimation = true;
    private int currentFrame = -1;
    private int animationFrameCount;
    private int screenX;
    private int screenY;

    public GameGrass(int n) {
        super(n);
    }

    public void setCallbackParent(ICallbackNotify iCallbackNotify) {
        this.callbackParent = iCallbackNotify;
    }

    public void setGrassAnimation(TiledAnimation tiledAnimation) {
        this.grassAnimation = tiledAnimation;
        this.grassAnimation.updateAnimationPosition(this.screenX, this.screenY);
        this.animationFrameCount = this.grassAnimation.getFrameCount(false);
    }

    public void setControlItemRect(int[] nArray) {
        this.x = nArray[0] << 11;
        this.y = nArray[1] << 11;
        this.screenX = nArray[0];
        this.screenY = nArray[1];
        this.width = nArray[2];
        this.height = nArray[3];
    }

    public void open() {
    }

    public void close() {
    }

    public void delete() {
    }

    public void draw(Graphics graphics) {
        if (this.appearingAnimation) {
            if (this.grassAnimation != null) {
                this.grassAnimation.draw(graphics);
            }
        } else if (this.grassAnimation != null) {
            this.grassAnimation.setFrameToDraw(this.currentFrame);
            this.grassAnimation.draw(graphics);
        }
    }

    public int getDistance(int n, int n2) {
        return (this.screenX - n) * (this.screenX - n) + (this.screenY - n2) * (this.screenY - n2);
    }

    public int[] getPosition() {
        return new int[]{this.screenX + this.width / 2, this.screenY + this.height / 2};
    }

    public boolean isIntersected(int n, int n2, int n3, int n4) {
        return this.screenX + this.width / 4 <= n && this.screenX + this.width * 3 / 4 >= n + n3 && this.screenY + this.height / 4 <= n2 && this.screenY + this.height * 3 / 4 >= n2 + n4;
    }

    public void tick(long l) {
        if (this.appearingAnimation) {
            if (this.grassAnimation != null) {
                boolean bl = this.appearingAnimation = !this.grassAnimation.updateAnimation(l);
            }
            if (!this.appearingAnimation) {
                this.currentFrame = this.animationFrameCount - 1;
            }
        } else {
            this.durability = (int)((long)this.durability - 1024L * l / 1000L);
            if (this.grassAnimation != null) {
                this.currentFrame = this.durability * this.animationFrameCount / 245760;
            }
            if (this.durability <= 0 && this.callbackParent != null) {
                this.callbackParent.onGrassDrained(this.controlID);
            }
        }
    }

    public int bite(int n) {
        return this.durability > 0 ? ((this.durability -= n) > 0 ? n : n + this.durability) : 0;
    }

    public boolean keyPressed(int n) {
        return false;
    }

    public boolean keyReleased(int n) {
        return false;
    }

    public boolean keyRepeated(int n) {
        return false;
    }
}

