/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Game;

import com.spl.j2me.Animation.TiledAnimation;
import com.spl.j2me.GUIIC.ControlContainer;
import com.spl.j2me.GUIIC.FontManager;
import com.spl.j2me.GUIIC.Handler;
import com.spl.j2me.Game.Constants;
import com.spl.j2me.Game.FarmContainer;
import com.spl.j2me.Game.TiledButtonControl;
import com.spl.j2me.Game.TiledControl;
import com.spl.j2me.RM.ResourceManager;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AwardsViewScreen
extends ControlContainer
implements Constants,
Handler {
    public static final int AWARDS_TYPE_COUNT = 15;
    public static final int AWARD_ALL_LEVEL_GOLD = 0;
    public static final int AWARD_ALL_AWARDS_COLLECTED = 1;
    public static final int AWARD_LEVEL_BEST_TIME = 2;
    public static final int AWARD_ALL_SHOP_UPGRADE = 3;
    public static final int AWARD_MORE_THAN_30_MINUTES = 4;
    public static final int AWARD_10_LEVELS_NO_KILLED_PETS = 5;
    public static final int AWARD_FULL_DEPOT = 6;
    public static final int AWARD_DONE_NO_STUFF_CLICK = 7;
    public static final int AWARD_COLLECTED_300_PRODUCTS = 8;
    public static final int AWARD_DOGS_CAUGTH_ALL_BEARS = 9;
    public static final int AWARD_NO_HINT_LEVEL = 10;
    public static final int AWARD_GET_1_MILLION_IN_BANK = 11;
    public static final int AWARD_6_BUILDING_WORK = 12;
    public static final int AWARD_ALL_LEVELS_DONE = 13;
    public static final int AWARD_7_FLYING_CAPTURED = 14;
    protected TiledAnimation awardsAnimation;
    protected static boolean[] awardsState;
    protected ControlContainer tipPopup;
    protected boolean tipPopupShow = false;
    protected Vector descText = new Vector();
    protected int tipID;
    protected int[][] awardsAreas;
    protected int buttonHeight;
    protected static Vector awardsToShow;
    protected boolean isNewAward = false;
    protected int currentAwardID;
    protected int mapObjectsID;
    protected int cursorPosX = 0;
    protected int cursorPosY = 0;
    protected int cursorXAxis = 0;
    protected int cursorYAxis = 0;
    protected int cursorState = 0;
    protected int cursorMultiplier = 4096;
    protected int arrowSize;

    public AwardsViewScreen(int n, Handler handler) {
        super(n, handler);
        awardsToShow = new Vector();
    }

    public void setAnimation(TiledAnimation tiledAnimation) {
        this.awardsAnimation = tiledAnimation;
        this.awardsAreas = new int[15][];
        int n = -1;
        while (++n < 15) {
            this.awardsAreas[n] = new int[]{Constants.awardsPositions[n][0], Constants.awardsPositions[n][1], tiledAnimation.getCurrentFrameWidth(n), tiledAnimation.getCurrentFrameHeight(n)};
        }
    }

    public void loadAwardsState(boolean[] blArray) {
        awardsState = blArray;
        awardsToShow.removeAllElements();
    }

    public void handle(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        switch (n4) {
            case 0: {
                this.tipPopupShow = false;
                this.removePopupWindow();
                if (this.isNewAward) {
                    this.isNewAward = false;
                }
                if (awardsToShow.size() <= 0) break;
                this.tipID = (Integer)awardsToShow.elementAt(0);
                this.setupTipWindow(this.tipID, true);
                awardsToShow.removeElementAt(0);
                this.isNewAward = true;
            }
        }
    }

    public static boolean isAwards() {
        return awardsToShow.size() > 0;
    }

    public void open() {
        super.open();
        if (awardsToShow.size() > 0) {
            this.tipID = (Integer)awardsToShow.elementAt(0);
            this.setupTipWindow(this.tipID, true);
            awardsToShow.removeElementAt(0);
            this.isNewAward = true;
        }
        this.currentAwardID = 0;
        this.cursorPosX = 120;
        this.cursorPosY = 160;
    }

    public static void setAward(int n) {
        if (n > awardsState.length) {
            return;
        }
        if (!awardsState[n]) {
            awardsToShow.addElement(new Integer(n));
            AwardsViewScreen.awardsState[n] = true;
            boolean bl = true;
            int n2 = -1;
            while (++n2 < awardsState.length) {
                if (n2 == 1 || awardsState[n2]) continue;
                bl = false;
            }
            if (bl) {
                awardsToShow.addElement(new Integer(1));
                AwardsViewScreen.awardsState[1] = true;
            }
        }
    }

    public void setTipPopup(ControlContainer controlContainer) {
        this.tipPopup = controlContainer;
    }

    public void draw(Graphics graphics) {
        super.draw(graphics);
        int n = -1;
        while (++n < 15) {
            this.awardsAnimation.updateAnimationPosition(Constants.awardsPositions[n][0], Constants.awardsPositions[n][1]);
            this.awardsAnimation.setFrameToDraw(awardsState[n] ? n : n + 15);
            this.awardsAnimation.draw(graphics);
        }
        if (this.popupWindow == null) {
            Image image = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(2, 393216));
            graphics.drawImage(image, this.cursorPosX, this.cursorPosY, 3);
        }
    }

    public void setupTipWindow(int n, boolean bl) {
        this.tipID = n;
        if (this.descText != null) {
            this.descText.removeAllElements();
        }
        this.descText = FontManager.getInstance(-1).wrapText(1, FarmContainer.getLocaleString(Constants.awardsTipData[this.tipID][bl ? 1 : 0]), 96);
        TiledButtonControl tiledButtonControl = (TiledButtonControl)this.tipPopup.getItem(1);
        ((TiledControl)this.tipPopup.getItem(0)).setControlItemRect(new int[]{24, 80, 192, 160});
        tiledButtonControl.setControlItemRect(new int[]{96, 240 - tiledButtonControl.buttonTileHeight * 3 / 2, 48, tiledButtonControl.buttonTileHeight});
        this.buttonHeight = tiledButtonControl.buttonTileHeight;
        this.setPopupWindow(this.tipPopup);
        this.tipPopupShow = true;
    }

    public void onEndDraw(Graphics graphics) {
        if (this.tipPopupShow) {
            this.popupWindow.draw(graphics);
            this.awardsAnimation.setFrameToDraw(this.tipID);
            this.awardsAnimation.updateAnimationPosition(24 + (76 - this.awardsAreas[this.tipID][2]) / 2, 80 + (160 - this.awardsAreas[this.tipID][3]) / 2);
            this.awardsAnimation.draw(graphics);
            int n = 100;
            int n2 = FontManager.getInstance(-1).getFontHeight(0);
            int n3 = 80 + (160 - (n2 + 2) * this.descText.size() - this.buttonHeight * 3 / 2) / 2;
            n3 += n2;
            int n4 = -1;
            while (++n4 < this.descText.size()) {
                FontManager.getInstance(-1).drawString(graphics, 3, (String)this.descText.elementAt(n4), n, n3, 1);
                n3 += n2 + 2;
            }
            this.popupWindow.onEndDraw(graphics);
        } else {
            super.onEndDraw(graphics);
        }
    }

    public void tick(long l) {
        int n = 1 + (this.cursorMultiplier >> 11);
        if (this.cursorXAxis != 0) {
            if (this.cursorXAxis > 0) {
                if (this.cursorPosX + this.arrowSize < 240) {
                    this.cursorPosX += n;
                    if (this.cursorPosX + this.arrowSize > 240) {
                        this.cursorPosX = 240 - this.arrowSize;
                    }
                }
            } else if (this.cursorPosX > 0) {
                this.cursorPosX -= n;
                if (this.cursorPosX < 0) {
                    this.cursorPosX = 0;
                }
            }
        }
        if (this.cursorYAxis != 0) {
            if (this.cursorYAxis > 0) {
                if (this.cursorPosY + this.arrowSize < 320) {
                    this.cursorPosY += n;
                    if (this.cursorPosY + this.arrowSize > 320) {
                        this.cursorPosY = 320 - this.arrowSize;
                    }
                }
            } else if (this.cursorPosY > 0) {
                this.cursorPosY -= n;
                if (this.cursorPosY < 0) {
                    this.cursorPosY = 0;
                }
            }
        }
    }

    public boolean keyPressed(int n) {
        boolean bl = false;
        if (this.popupWindow != null) {
            bl = this.popupWindow.keyPressed(n);
        }
        if (!bl) {
            if (n == 2) {
                this.cursorXAxis = -1;
            }
            if (n == 3) {
                this.cursorXAxis = 1;
            }
            if (n == 4) {
                this.cursorYAxis = -1;
            }
            if (n == 5) {
                this.cursorYAxis = 1;
            }
        }
        return bl;
    }

    public boolean keyRepeated(int n) {
        boolean bl = false;
        if (this.popupWindow != null) {
            bl = this.popupWindow.keyReleased(n);
        }
        if (!bl && this.popupWindow == null) {
            int n2 = this.cursorMultiplier = this.cursorMultiplier < 8192 ? this.cursorMultiplier + 4096 : this.cursorMultiplier;
            if (n == 2) {
                this.cursorXAxis = -1;
            }
            if (n == 3) {
                this.cursorXAxis = 1;
            }
            if (n == 4) {
                this.cursorYAxis = -1;
            }
            if (n == 5) {
                this.cursorYAxis = 1;
            }
        }
        return bl;
    }

    public boolean keyReleased(int n) {
        boolean bl = false;
        if (this.popupWindow != null) {
            bl = this.popupWindow.keyReleased(n);
        }
        if (!bl && this.popupWindow == null) {
            if (n == 1) {
                this.removePopupWindow();
                this.getItem(1).action();
            }
            if (n == 6) {
                this.pointerReleased(this.cursorPosX, this.cursorPosY);
            }
        }
        if (!bl) {
            if (n == 2 || n == 3) {
                this.cursorXAxis = 0;
                this.cursorMultiplier = 4096;
            }
            if (n == 4 || n == 5) {
                this.cursorYAxis = 0;
                this.cursorMultiplier = 4096;
            }
        }
        return bl;
    }

    public boolean pointerReleased(int n, int n2) {
        if (this.popupWindow == null && !this.tipPopupShow) {
            int n3 = -1;
            while (++n3 < 15) {
                if (this.awardsAreas[n3][0] - 8 >= n || this.awardsAreas[n3][0] + this.awardsAreas[n3][2] + 8 <= n || this.awardsAreas[n3][1] - 8 >= n2 || this.awardsAreas[n3][1] + this.awardsAreas[n3][3] + 8 <= n2) continue;
                this.setupTipWindow(n3, false);
            }
        }
        return true;
    }
}

