/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Game;

import com.spl.j2me.Animation.TiledAnimation;
import com.spl.j2me.GUIIC.ControlItem;
import com.spl.j2me.Game.Constants;
import com.spl.j2me.Game.ICallbackNotify;
import com.spl.j2me.Game.MathExt;
import com.spl.j2me.RM.ResourceManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AnimalBase
extends ControlItem
implements Constants {
    public static byte DIRECTION_NONE = (byte)10;
    public static byte DIRECTION_UP = 0;
    public static byte DIRECTION_UP_RIGHT = 1;
    public static byte DIRECTION_RIGHT = (byte)2;
    public static byte DIRECTION_DOWN_RIGHT = (byte)3;
    public static byte DIRECTION_DOWN = (byte)4;
    public static byte DIRECTION_DOWN_LEFT = (byte)5;
    public static byte DIRECTION_LEFT = (byte)6;
    public static byte DIRECTION_UP_LEFT = (byte)7;
    public static long ANIMAL_CHANGE_DIRECTION_PERIOD = 1300L;
    public static long DIRECTION_CHANGE_THRESHOLD = 0x66666660L;
    public long previousTime = -1L;
    public long changeDirectionTimer = ANIMAL_CHANGE_DIRECTION_PERIOD;
    protected int movingDirectionX = -1;
    protected int movingDirectionY = -1;
    protected int currentAngle = -1;
    protected TiledAnimation animalAnimation;
    private int[][] directionAnimationSequences;
    protected int[] meadowBB;
    private byte animalCurrentDirection = DIRECTION_NONE;
    protected byte currentMovingDirection;
    protected int currentMovingSpeed = 40;
    protected boolean isMoveEnabled = true;
    protected boolean isAppearing = true;
    private int appearingDelay = 1024;
    protected int appearingYOffset = -1;
    protected int screenX;
    protected int screenY;
    protected boolean isDroppedOut = false;
    ICallbackNotify callbackParent;
    protected int appearingShadowID;
    byte animalType;

    public AnimalBase(int n, int n2) {
        super(n);
        this.currentAngle = 1024;
        this.movingDirectionX = MathExt.cos(1024);
        this.movingDirectionY = MathExt.sin(1024);
        this.currentMovingDirection = this.getDirection((byte)0);
        this.isAppearing = true;
        this.animalType = (byte)n2;
        this.appearingYOffset = 400;
    }

    public void setMeadowBB(int[] nArray) {
        this.meadowBB = new int[nArray.length];
        int n = -1;
        while (++n < this.meadowBB.length) {
            this.meadowBB[n] = nArray[n];
        }
    }

    public void setShadowImage(int n) {
        this.appearingShadowID = n;
    }

    public void setEnableMove(boolean bl) {
        this.isMoveEnabled = bl;
    }

    public void setCallbackParent(ICallbackNotify iCallbackNotify) {
        this.callbackParent = iCallbackNotify;
    }

    public void setControlItemRect(int[] nArray) {
        this.x = nArray[0] << 11;
        this.y = nArray[1] << 11;
        this.screenX = nArray[0];
        this.screenY = nArray[1];
        this.width = nArray[2];
        this.height = nArray[3];
    }

    public void setAnimalTiledAnimation(TiledAnimation tiledAnimation) {
        this.animalAnimation = tiledAnimation;
        this.updateModel();
    }

    public void setAnimationTileSequences(int[][] nArray) {
        this.directionAnimationSequences = nArray;
    }

    public void dropAnimalOut(int n, int n2) {
        this.isDroppedOut = true;
        this.isMoveEnabled = true;
        this.movingDirectionX = n;
        this.movingDirectionY = n2;
        this.currentMovingSpeed = 400;
        this.changeDirectionTimer = ANIMAL_CHANGE_DIRECTION_PERIOD << 2;
    }

    public AnimalBase(AnimalBase animalBase, int n) {
        super(n);
        this.animalAnimation = animalBase.animalAnimation;
        this.directionAnimationSequences = animalBase.directionAnimationSequences;
        this.x = animalBase.x;
        this.y = animalBase.y;
        this.screenX = animalBase.screenX;
        this.screenY = animalBase.screenY;
        this.width = animalBase.width;
        this.height = animalBase.height;
        this.isAppearing = true;
        this.currentAngle = animalBase.currentAngle;
        this.currentMovingDirection = animalBase.currentMovingDirection;
        this.movingDirectionX = animalBase.movingDirectionX;
        this.movingDirectionY = animalBase.movingDirectionY;
        this.appearingYOffset = 400;
        this.animalType = animalBase.animalType;
    }

    public int[] getBoundingBox() {
        return new int[]{this.screenX, this.screenY, this.width, this.height};
    }

    public int[] getPosition() {
        return new int[]{this.screenX + this.width / 2, this.screenY + this.height / 2};
    }

    public boolean isIntersected(int n, int n2, int n3, int n4) {
        return Math.abs(this.screenX + this.width / 2 - n) < (n3 + this.width) / 2 && Math.abs(this.screenY + this.height / 2 - n2) < (n4 + this.height) / 2;
    }

    public void tick(long l) {
        int n;
        int n2;
        if (this.isAppearing) {
            if (this.appearingDelay > 0) {
                this.appearingDelay = (int)((long)this.appearingDelay - (l << 11) / 1000L);
                if (this.appearingDelay < 0) {
                    // empty if block
                }
                return;
            }
            this.appearingYOffset = (int)((long)this.appearingYOffset - 400L * l / 1000L);
            if (this.appearingYOffset < 0) {
                this.isAppearing = false;
                this.animalAnimation.updateAnimationPosition(this.screenX, this.screenY);
            }
            return;
        }
        if (this.animalAnimation != null) {
            this.animalAnimation.updateAnimation(l);
        }
        if (this.changeDirectionTimer <= 0L && this.isMoveEnabled && !this.isDroppedOut && (long)(n2 = MathExt.rnd()) < DIRECTION_CHANGE_THRESHOLD) {
            this.currentAngle = MathExt.rnd() % 8192;
            this.movingDirectionX = MathExt.cos(this.currentAngle);
            this.movingDirectionY = MathExt.sin(this.currentAngle);
            n = this.getDirection(this.currentMovingDirection);
            if (this.currentMovingDirection != n) {
                this.currentMovingDirection = (byte)n;
            }
            this.updateModel();
            this.changeDirectionTimer = ANIMAL_CHANGE_DIRECTION_PERIOD;
        }
        this.changeDirectionTimer -= l;
        if (this.isMoveEnabled) {
            n2 = (int)((long)(this.movingDirectionX * this.currentMovingSpeed) * l / 1000L);
            n = (int)((long)(this.movingDirectionY * this.currentMovingSpeed) * l / 1000L);
            if (!(this.isDroppedOut || this.x + (this.width / 2 << 11) + n2 > this.meadowBB[0] && this.y + (this.height - 8 << 11) + n > this.meadowBB[1] && this.x + (this.width / 2 << 11) + n2 < this.meadowBB[2] && this.y + (this.height - 8 << 11) + n < this.meadowBB[3])) {
                int n3 = 0;
                if (this.x + (this.width / 2 << 11) + n2 != this.meadowBB[0]) {
                    n3 = this.x + (this.width / 2 << 11) + n2 > this.meadowBB[0] ? -1 : 1;
                }
                int n4 = 0;
                if (this.y + (this.height - 8 << 11) + n != this.meadowBB[1]) {
                    n4 = this.y + (this.height - 8 << 11) + n > this.meadowBB[1] ? -1 : 1;
                }
                this.invertDirection(n3, n4);
            } else {
                this.x += n2;
                this.y += n;
                this.screenX = this.x >> 11;
                this.screenY = this.y >> 11;
                this.animalAnimation.updateAnimationPosition(this.screenX, this.screenY);
                if (this.isDroppedOut && (this.screenX + this.width < 0 || this.screenX - this.width > 240 || this.screenY + this.height < 0 || this.screenY - this.height > 320)) {
                    this.callbackParent.onComplete(1, this.animalType, this.controlID);
                }
            }
        }
    }

    protected void updateModel() {
        if (this.animalAnimation == null) {
            return;
        }
        this.animalAnimation.setAnimationSequence(Constants.animalBehaviorAnimeSeq[this.animalType][Constants.animalBehaviorData[this.animalType][this.currentMovingDirection][0]]);
        this.animalAnimation.setAnimationTransform(Constants.animalBehaviorData[this.animalType][this.currentMovingDirection][1] == 1 ? 2 : 0);
        this.animalAnimation.updateAnimationPosition(this.screenX, this.screenY);
    }

    protected int countAngle(int n, int n2) {
        int n3;
        int n4 = n3 = n < 0 ? 4096 - MathExt.ACOS[-n] : MathExt.ACOS[n];
        if (this.movingDirectionY < 0) {
            n3 = 8192 - n3;
        }
        return n3;
    }

    public void invertDirection(int n, int n2) {
        if (n != 0) {
            this.movingDirectionX = n * Math.abs(this.movingDirectionX);
        }
        if (n2 != 0) {
            this.movingDirectionY = n2 * Math.abs(this.movingDirectionY);
        }
        this.currentAngle = this.countAngle(this.movingDirectionX, this.movingDirectionY);
        this.movingDirectionX = MathExt.cos(this.currentAngle);
        this.movingDirectionY = MathExt.sin(this.currentAngle);
        this.changeDirectionTimer = ANIMAL_CHANGE_DIRECTION_PERIOD;
        this.currentMovingDirection = this.getDirection(this.currentMovingDirection);
        this.updateModel();
    }

    protected byte getDirection(byte by) {
        if (this.currentAngle <= 1024 || this.currentAngle > 7168) {
            return DIRECTION_RIGHT;
        }
        if (this.currentAngle <= 3072) {
            return DIRECTION_UP;
        }
        if (this.currentAngle <= 5120) {
            return DIRECTION_LEFT;
        }
        if (this.currentAngle <= 7168) {
            return DIRECTION_DOWN;
        }
        return DIRECTION_UP;
    }

    public void setAnimalPosition(int n, int n2) {
        this.screenX = n;
        this.screenY = n2;
        this.x = n << 11;
        this.y = n2 << 11;
        this.animalAnimation.updateAnimationPosition(this.screenX, this.screenY);
        this.updateModel();
    }

    public void delete() {
    }

    public void open() {
    }

    public void close() {
    }

    public void draw(Graphics graphics) {
        if (this.animalAnimation != null) {
            if (this.isMoveEnabled) {
                this.animalAnimation.updateAnimationPosition(this.screenX, this.screenY - this.appearingYOffset);
            }
            this.animalAnimation.draw(graphics);
        }
        if (this.isAppearing) {
            Image image = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(this.appearingShadowID >> 24, this.appearingShadowID & 0xFFFFFF));
            graphics.drawImage(image, this.screenX + (this.width - image.getWidth()) / 2, this.screenY + this.height - image.getHeight() / 2, 0);
        }
    }

    public boolean keyPressed(int n) {
        return true;
    }

    public boolean keyReleased(int n) {
        return true;
    }

    public boolean keyRepeated(int n) {
        return true;
    }
}

