/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.ME.Multichannel;

import com.spl.j2me.Game.fCanvas;
import com.spl.j2me.RM.ResourceManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class MediaEngine
implements PlayerListener {
    public final String[] supportedMediaFormats = new String[]{"audio/amr", "audio/midi", "audio/x-wav"};
    byte[] engine_states = null;
    byte[][] sound_cache = null;
    String[] sound_cache_type = null;
    Display engine_display = null;
    Player[] sndPlayers = null;
    int[] sndVolume = null;

    public MediaEngine(Display display, int n, int n2) {
        this.engine_display = display;
        this.engine_states = new byte[n];
        this.sndPlayers = new Player[n];
        this.sndVolume = new int[n];
        this.sound_cache = new byte[n2][];
        this.sound_cache_type = new String[n2];
    }

    public void playCachedSound(int n, int n2, boolean bl) {
        if (this.sound_cache[n] != null) {
            this.playSound(new ByteArrayInputStream(this.sound_cache[n]), this.sound_cache_type[n], n2, bl);
        }
    }

    public void playSoundFromResCache(int n, int n2, int n3, boolean bl) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            ResourceManager.setResourcePackagePrefix("sound");
            byteArrayInputStream = new ByteArrayInputStream(ResourceManager.getBinaryData(n2));
        }
        catch (Exception exception) {
            return;
        }
        this.playSound(byteArrayInputStream, this.supportedMediaFormats[1], n3, bl);
    }

    public void setChannelVolume(int n, int n2) {
        this.sndVolume[n] = n2;
    }

    public void playSound(InputStream inputStream, String string, int n, boolean bl) {
        if (n > -1 && n < this.sndPlayers.length) {
            try {
                if (this.sndPlayers[n] != null) {
                    this.stopChannel(n);
                }
                Player player = Manager.createPlayer((InputStream)inputStream, (String)string);
                player.realize();
                VolumeControl volumeControl = (VolumeControl)player.getControl("VolumeControl");
                volumeControl.setLevel(this.sndVolume[n]);
                player.addPlayerListener((PlayerListener)this);
                player.prefetch();
                if (bl) {
                    player.setLoopCount(-1);
                }
                player.start();
                this.sndPlayers[n] = player;
            }
            catch (Exception exception) {
                if (this.sndPlayers[n] != null) {
                    this.sndPlayers[n].close();
                }
                this.sndPlayers[n] = null;
                exception.printStackTrace();
            }
        }
    }

    public void pauseChannel(int n) {
        if (n > -1 && n < this.sndPlayers.length && this.sndPlayers[n] != null) {
            try {
                this.sndPlayers[n].stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void resumeChannel(int n) {
        if (n > -1 && n < this.sndPlayers.length && this.sndPlayers[n] != null) {
            VolumeControl volumeControl = (VolumeControl)this.sndPlayers[n].getControl("VolumeControl");
            volumeControl.setLevel(this.sndVolume[n]);
            try {
                this.sndPlayers[n].start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stopChannel(int n) {
        if (n > -1 && n < this.sndPlayers.length && this.sndPlayers[n] != null) {
            this.sndPlayers[n].removePlayerListener((PlayerListener)this);
            try {
                this.sndPlayers[n].stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sndPlayers[n].close();
            this.sndPlayers[n] = null;
        }
    }

    public void stopAppChannels() {
        for (int i = 0; i < this.sndPlayers.length; ++i) {
            this.stopChannel(i);
        }
    }

    public void playerUpdate(Player player, String string, Object object) {
        if (string == "deviceAvailable") {
            this.stopChannel(0);
            fCanvas.setSoundToPlay(fCanvas.currentSound[0], 0, true);
        }
    }

    public int cacheSound(byte[] byArray, int n) {
        int n2 = -1;
        if (n > -1 && n < this.supportedMediaFormats.length) {
            for (int i = 0; i < this.sound_cache.length; ++i) {
                if (this.sound_cache[i] != null) continue;
                n2 = i;
                break;
            }
            if (n2 != -1) {
                this.sound_cache[n2] = byArray;
                this.sound_cache_type[n2] = this.supportedMediaFormats[n];
            }
        }
        return n2;
    }

    public void releaseCachedSound(int n) {
        if (n > -1 && n < this.sound_cache.length) {
            this.sound_cache[n] = null;
            this.sound_cache_type[n] = null;
        }
    }

    public void vibrate(int n) {
    }
}

