/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Game;

import com.spl.j2me.GUIIC.ControlContainer;
import com.spl.j2me.GUIIC.FontManager;
import com.spl.j2me.GUIIC.Handler;
import com.spl.j2me.Game.AwardsViewScreen;
import com.spl.j2me.Game.Constants;
import com.spl.j2me.Game.FarmContainer;
import com.spl.j2me.Game.TiledButtonControl;
import com.spl.j2me.RM.ResourceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class ProfileViewScreen
extends ControlContainer
implements Constants {
    private static final String rms_name = "ff2data";
    protected int profilesCount;
    protected int currentProfileID;
    public static boolean soundEnabled;
    public static boolean musicEnabled;
    protected int arrowYOffset;
    public static int currentLocaleID;
    protected static Vector profileNames;
    protected Vector profileDataPaths;
    public static String currentUserName;
    public static int currentPlayerBankMoney;
    public static int currentPlayerBankStars;
    public static int[][] currentPlayerShopState;
    public static byte[] currentPlayerMapState;
    public static boolean[] currentPlayerAwardsState;
    public static boolean[] currentPlayerHintShown;
    public static short currentPlayerLastPlayedLevelID;
    public static int currentPlayerProductCount;
    public static boolean animalKilled;
    public static int animalKilledLevelCount;
    public static boolean hintShown;
    public static int hintShownLevelCount;
    public static boolean isNewGame;
    public static int selectedProfile;

    public static Vector getProfileNames() {
        return profileNames;
    }

    public static String getCurrentProfileName() {
        return (String)profileNames.elementAt(selectedProfile);
    }

    public ProfileViewScreen(int n, Handler handler) {
        super(n, handler);
        profileNames = new Vector();
        this.profileDataPaths = new Vector();
        currentPlayerShopState = new int[17][2];
        currentPlayerMapState = new byte[67];
        currentPlayerAwardsState = new boolean[15];
        currentPlayerHintShown = new boolean[28];
    }

    public static void checkWithout() {
        if (!animalKilled) {
            if (++animalKilledLevelCount >= 10) {
                AwardsViewScreen.setAward(5);
            }
        } else {
            animalKilledLevelCount = 0;
            animalKilled = false;
        }
        if (!hintShown) {
            if (++hintShownLevelCount >= 1) {
                AwardsViewScreen.setAward(10);
            } else {
                hintShown = false;
                hintShownLevelCount = 0;
            }
        }
    }

    public void saveState() {
        this.saveCommonData();
        this.savePlayerPersonalData(this.currentProfileID);
    }

    public void loadState(boolean bl) {
        this.loadCommonData(bl);
        if (bl) {
            this.loadPlayerPersonalData(this.currentProfileID);
        }
    }

    protected void loadDefaultCommonData() {
        String string = FarmContainer.getLocaleString(283);
        profileNames.addElement(string);
        this.profileDataPaths.addElement(string + "store");
        currentLocaleID = -1;
        selectedProfile = 0;
        musicEnabled = false;
        soundEnabled = false;
    }

    protected void loadCommonData(boolean bl) {
        boolean bl2 = false;
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)rms_name, (boolean)false);
            bl2 = true;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        if (bl2 && recordStore != null) {
            if (!bl) {
                try {
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(1)));
                    this.profilesCount = dataInputStream.readByte();
                    byte by = dataInputStream.readByte();
                    selectedProfile = by;
                    this.currentProfileID = by;
                    int n = -1;
                    while (++n < this.profilesCount) {
                        profileNames.addElement(dataInputStream.readUTF());
                        this.profileDataPaths.addElement(dataInputStream.readUTF());
                    }
                    currentLocaleID = dataInputStream.readByte();
                    musicEnabled = dataInputStream.readBoolean();
                    soundEnabled = dataInputStream.readBoolean();
                    dataInputStream.close();
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {
                    if (bl) {
                        this.loadDefaultCommonData();
                    }
                }
            }
        } else if (bl) {
            this.loadDefaultCommonData();
        } else {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveCommonData() {
        boolean bl = false;
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)rms_name, (boolean)true);
            bl = true;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        if (bl && recordStore != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeByte((byte)profileNames.size());
                dataOutputStream.writeByte((byte)this.currentProfileID);
                int n = -1;
                while (++n < profileNames.size()) {
                    dataOutputStream.writeUTF((String)profileNames.elementAt(n));
                    dataOutputStream.writeUTF((String)this.profileDataPaths.elementAt(n));
                }
                dataOutputStream.writeByte(currentLocaleID);
                dataOutputStream.writeBoolean(musicEnabled);
                dataOutputStream.writeBoolean(soundEnabled);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (recordStore.getNumRecords() == 0) {
                    recordStore.addRecord(byArray, 0, byArray.length);
                } else {
                    recordStore.setRecord(1, byArray, 0, byArray.length);
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (recordStore != null) {
                        recordStore.closeRecordStore();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void open() {
        super.open();
        this.getItem(2).setEnabled(true);
        this.getItem(3).setEnabled(true);
        ((TiledButtonControl)this.getItem(1)).updateButtonLabel((String)profileNames.elementAt(selectedProfile));
        if (profileNames.size() == 1) {
            ((TiledButtonControl)this.getItem(3)).setEnabled(false);
        }
        if (profileNames.size() == 5) {
            ((TiledButtonControl)this.getItem(2)).setEnabled(false);
        }
    }

    protected void loadPlayerDefaultData() {
        currentPlayerBankMoney = 0;
        currentPlayerBankStars = 0;
        int n = -1;
        while (++n < currentPlayerShopState.length) {
            ProfileViewScreen.currentPlayerShopState[n][0] = n < 12 ? -1 : 1;
            ProfileViewScreen.currentPlayerShopState[n][1] = n < 12 ? Constants.producingBuildingCost[n].length - 2 : Constants.supportBuildingData[0].length - 1;
        }
        n = -1;
        while (++n < currentPlayerMapState.length) {
            ProfileViewScreen.currentPlayerMapState[n] = -1;
        }
        n = -1;
        while (++n < currentPlayerAwardsState.length) {
            ProfileViewScreen.currentPlayerAwardsState[n] = false;
        }
        n = -1;
        while (++n < currentPlayerHintShown.length) {
            ProfileViewScreen.currentPlayerHintShown[n] = false;
        }
        ProfileViewScreen.currentPlayerMapState[0] = 1;
        currentPlayerLastPlayedLevelID = (short)-1;
        animalKilled = false;
        animalKilledLevelCount = 0;
        hintShown = false;
        hintShownLevelCount = 0;
        isNewGame = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPlayerPersonalData(int n) {
        if (n < 0 || n > profileNames.size()) {
            return;
        }
        boolean bl = false;
        isNewGame = true;
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)((String)this.profileDataPaths.elementAt(n)), (boolean)false);
            bl = true;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        DataInputStream dataInputStream = null;
        try {
            bl = false;
            dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(1)));
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl && recordStore != null) {
            try {
                currentPlayerBankMoney = dataInputStream.readInt();
                currentPlayerBankStars = dataInputStream.readInt();
                int n2 = -1;
                while (++n2 < 17) {
                    ProfileViewScreen.currentPlayerShopState[n2][0] = dataInputStream.readInt();
                    ProfileViewScreen.currentPlayerShopState[n2][1] = dataInputStream.readInt();
                }
                n2 = -1;
                while (++n2 < 67) {
                    ProfileViewScreen.currentPlayerMapState[n2] = dataInputStream.readByte();
                    if (currentPlayerMapState[n2] <= 1) continue;
                    isNewGame = false;
                }
                n2 = -1;
                while (++n2 < 15) {
                    ProfileViewScreen.currentPlayerAwardsState[n2] = dataInputStream.readBoolean();
                }
                currentPlayerLastPlayedLevelID = dataInputStream.readShort();
                animalKilled = dataInputStream.readBoolean();
                animalKilledLevelCount = dataInputStream.readByte();
                hintShown = dataInputStream.readBoolean();
                hintShownLevelCount = dataInputStream.readByte();
                n2 = -1;
                while (++n2 < currentPlayerHintShown.length) {
                    ProfileViewScreen.currentPlayerHintShown[n2] = dataInputStream.readBoolean();
                }
            }
            catch (Exception exception) {
            }
            finally {
                dataInputStream = null;
                try {
                    if (recordStore != null) {
                        recordStore.closeRecordStore();
                    }
                }
                catch (RecordStoreException recordStoreException) {}
            }
        } else {
            this.loadPlayerDefaultData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void savePlayerPersonalData(int n) {
        if (n < 0 || n > profileNames.size()) {
            return;
        }
        boolean bl = false;
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)((String)this.profileDataPaths.elementAt(n)), (boolean)true);
            bl = true;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        if (bl && recordStore != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeInt(currentPlayerBankMoney);
                dataOutputStream.writeInt(currentPlayerBankStars);
                int n2 = -1;
                while (++n2 < 17) {
                    dataOutputStream.writeInt(currentPlayerShopState[n2][0]);
                    dataOutputStream.writeInt(currentPlayerShopState[n2][1]);
                }
                n2 = -1;
                while (++n2 < 67) {
                    dataOutputStream.writeByte(currentPlayerMapState[n2]);
                }
                n2 = -1;
                while (++n2 < 15) {
                    dataOutputStream.writeBoolean(currentPlayerAwardsState[n2]);
                }
                dataOutputStream.writeShort(currentPlayerLastPlayedLevelID);
                dataOutputStream.writeBoolean(animalKilled);
                dataOutputStream.writeByte(animalKilledLevelCount);
                dataOutputStream.writeBoolean(hintShown);
                dataOutputStream.writeByte(hintShownLevelCount);
                n2 = -1;
                while (++n2 < currentPlayerHintShown.length) {
                    dataOutputStream.writeBoolean(currentPlayerHintShown[n2]);
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (recordStore.getNumRecords() == 0) {
                    recordStore.addRecord(byArray, 0, byArray.length);
                } else {
                    recordStore.setRecord(1, byArray, 0, byArray.length);
                }
                byArray = null;
                dataOutputStream = null;
                byteArrayOutputStream = null;
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (recordStore != null) {
                        recordStore.closeRecordStore();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void removeCurrentProfile() {
        if (selectedProfile < 0 || selectedProfile > profileNames.size()) {
            return;
        }
        try {
            this.removeCurrentProfileSave();
            profileNames.removeElementAt(selectedProfile);
            String string = (String)this.profileDataPaths.elementAt(selectedProfile);
            this.profileDataPaths.removeElementAt(selectedProfile);
            isNewGame = false;
            RecordStore recordStore = null;
            recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
            recordStore.deleteRecord(1);
            recordStore.closeRecordStore();
            recordStore = null;
            RecordStore.deleteRecordStore((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        selectedProfile = this.currentProfileID > 0 ? (this.currentProfileID = this.currentProfileID - 1) : this.currentProfileID;
        this.currentProfileID = selectedProfile;
        this.loadPlayerPersonalData(selectedProfile);
        ((TiledButtonControl)this.getItem(1)).updateButtonLabel((String)profileNames.elementAt(selectedProfile));
        if (profileNames.size() == 1) {
            ((TiledButtonControl)this.getItem(3)).setEnabled(false);
            this.selectItem(4);
        }
        if (profileNames.size() < 5) {
            ((TiledButtonControl)this.getItem(2)).setEnabled(true);
        }
    }

    public void removeCurrentProfileSave() {
        try {
            RecordStore.deleteRecordStore((String)((String)profileNames.elementAt(selectedProfile) + "save"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadCurrentGame() {
        byte[] byArray = null;
        boolean bl = false;
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)((String)profileNames.elementAt(this.currentProfileID) + "save"), (boolean)false);
            bl = true;
            if (bl && recordStore != null) {
                try {
                    byArray = recordStore.getRecord(1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (RecordStoreException recordStoreException) {
        }
        finally {
            try {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCurrentGame(byte[] byArray) {
        block15: {
            boolean bl = false;
            RecordStore recordStore = null;
            try {
                recordStore = RecordStore.openRecordStore((String)((String)profileNames.elementAt(this.currentProfileID) + "save"), (boolean)true);
                bl = true;
                if (!bl || recordStore == null) break block15;
                try {
                    if (recordStore.getNumRecords() == 0) {
                        recordStore.addRecord(byArray, 0, byArray.length);
                        break block15;
                    }
                    recordStore.setRecord(1, byArray, 0, byArray.length);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (RecordStoreException recordStoreException) {
            }
            finally {
                try {
                    if (recordStore != null) {
                        recordStore.closeRecordStore();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void draw(Graphics graphics) {
        super.draw(graphics);
        int n = FontManager.getInstance(-1).getFontHeight(0);
        FontManager.getInstance(-1).drawString(graphics, 2, FarmContainer.getLocaleString(32), 120, 80 + n * 2, 0);
        Image image = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(1, 65536));
        Image image2 = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(1, 196608));
        if (selectedProfile > 0) {
            graphics.drawImage(image, 40 + image.getWidth(), this.arrowYOffset - image.getHeight() / 2, 0);
        }
        if (selectedProfile < profileNames.size() - 1) {
            graphics.drawImage(image2, 200 - image2.getWidth() * 2, this.arrowYOffset - image2.getHeight() / 2, 0);
        }
    }

    public void tick(long l) {
    }

    public void addMoneyAndStars(int n, int n2) {
        currentPlayerBankMoney += n;
        currentPlayerBankStars += n2;
    }

    public void updateShopState(int[][] nArray) {
        int n = -1;
        while (++n < nArray.length) {
            ProfileViewScreen.currentPlayerShopState[n][0] = nArray[n][0];
            ProfileViewScreen.currentPlayerShopState[n][1] = nArray[n][1];
        }
    }

    public void updateMapState(byte[] byArray) {
        int n = -1;
        while (++n < byArray.length) {
            ProfileViewScreen.currentPlayerMapState[n] = byArray[n];
        }
    }

    public void setSelectedArrowOffset(int n) {
        this.arrowYOffset = n;
    }

    public void createNewProfile(String string) {
        profileNames.addElement(string);
        string.replace(' ', '_');
        this.profileDataPaths.addElement(string + "store");
        this.saveState();
        selectedProfile = this.currentProfileID = profileNames.indexOf(string);
        this.loadPlayerDefaultData();
        ((TiledButtonControl)this.getItem(1)).updateButtonLabel((String)profileNames.elementAt(selectedProfile));
        if (profileNames.size() > 1) {
            ((TiledButtonControl)this.getItem(3)).setEnabled(true);
        }
        if (profileNames.size() == 5) {
            ((TiledButtonControl)this.getItem(2)).setEnabled(false);
            this.selectItem(4);
        }
    }

    public void loadCurrentPlayerData() {
        if (selectedProfile != this.currentProfileID) {
            this.saveState();
        }
        this.loadPlayerPersonalData(selectedProfile);
        this.currentProfileID = selectedProfile;
    }

    public boolean keyPressed(int n) {
        boolean bl = false;
        if (this.popupWindow != null) {
            bl = this.popupWindow.keyPressed(n);
            return bl;
        }
        if (!bl) {
            if (n == 4 || n == 5) {
                bl = super.keyPressed(n);
            }
            if (this.getSelected() == 1) {
                if (n == 2) {
                    if (selectedProfile > 0) {
                        ((TiledButtonControl)this.getItem(1)).updateButtonLabel((String)profileNames.elementAt(--selectedProfile));
                    }
                    bl = true;
                }
                if (n == 3) {
                    if (selectedProfile < profileNames.size() - 1) {
                        ((TiledButtonControl)this.getItem(1)).updateButtonLabel((String)profileNames.elementAt(++selectedProfile));
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    public boolean keyReleased(int n) {
        boolean bl = false;
        if (this.popupWindow != null) {
            bl = this.popupWindow.keyReleased(n);
            return bl;
        }
        if (!bl && n == 6) {
            super.keyReleased(n);
            return true;
        }
        return bl;
    }

    static {
        currentLocaleID = -1;
        animalKilled = false;
        hintShown = false;
        isNewGame = false;
        selectedProfile = 0;
    }
}

