/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Game;

import com.spl.j2me.GUIIC.ControlContainer;
import com.spl.j2me.GUIIC.FontManager;
import com.spl.j2me.GUIIC.Handler;
import com.spl.j2me.Game.Constants;
import com.spl.j2me.RM.ResourceManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class HelpView
extends ControlContainer
implements Constants,
Handler {
    public static final int HELP_SCREEN_PAGE_MAX_COUNT = 5;
    protected ControlContainer[] helpPages = new ControlContainer[5];
    protected int currentPageCount;
    protected int currentActivePage = -1;
    protected int leftArrowOffset;
    protected int rightArrowOffset;
    protected static final int ARROW_OFFSET = 32;
    protected int arrowYOffset;
    boolean isUpdating = false;

    public void setArrowYOffset(int n) {
        this.arrowYOffset = n;
    }

    public HelpView(int n, Handler handler) {
        super(n, handler);
    }

    public void draw(Graphics graphics) {
        if (!this.isUpdating) {
            super.draw(graphics);
            this.helpPages[this.currentActivePage].draw(graphics);
            Image image = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(1, 65536));
            Image image2 = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(1, 196608));
            String string = "" + (this.currentActivePage + 1) + " / " + this.currentPageCount;
            FontManager.getInstance(0).drawString(graphics, 0, string, 120, this.arrowYOffset + FontManager.getInstance(-1).getFontHeight(0) / 2, 0);
            if (this.currentActivePage > 0) {
                graphics.drawImage(image, 88 - image.getWidth() - (this.leftArrowOffset >> 10), this.arrowYOffset - image.getHeight() / 2, 0);
            }
            if (this.currentActivePage < this.currentPageCount - 1) {
                graphics.drawImage(image2, 152 + (this.rightArrowOffset >> 10), this.arrowYOffset - image2.getHeight() / 2, 0);
            }
            this.leftArrowOffset = this.leftArrowOffset > 0 ? (this.leftArrowOffset -= 200) : 0;
            this.rightArrowOffset = this.rightArrowOffset > 0 ? (this.rightArrowOffset -= 200) : 0;
        }
    }

    public void open() {
        super.open();
        this.currentActivePage = 0;
        this.leftArrowOffset = 0;
        this.rightArrowOffset = 0;
        int n = -1;
        while (++n < this.currentPageCount) {
            this.helpPages[n].open();
        }
    }

    public void handle(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        this.isUpdating = true;
        switch (n4) {
            case 0: {
                if (this.currentActivePage <= 0) break;
                --this.currentActivePage;
                break;
            }
            case 2: {
                if (this.currentActivePage >= this.currentPageCount - 1) break;
                ++this.currentActivePage;
            }
        }
        this.isUpdating = false;
    }

    public void addHelpPage(ControlContainer controlContainer) {
        this.helpPages[this.currentPageCount++] = controlContainer;
    }

    public boolean keyPressed(int n) {
        boolean bl = false;
        if (this.popupWindow != null) {
            bl = this.popupWindow.keyPressed(n);
            return bl;
        }
        if (n == 2) {
            if (this.currentActivePage > 0) {
                --this.currentActivePage;
                this.leftArrowOffset = 8192;
            }
            bl = true;
        }
        if (n == 3) {
            if (this.currentActivePage < this.currentPageCount - 1) {
                ++this.currentActivePage;
                this.rightArrowOffset = 8192;
            }
            bl = true;
        }
        return bl;
    }

    public boolean keyReleased(int n) {
        boolean bl = false;
        if (this.popupWindow != null) {
            bl = this.popupWindow.keyReleased(n);
            return bl;
        }
        if (n == 1) {
            this.getItem(1).action();
            bl = true;
        }
        return bl;
    }
}

