/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Game;

import com.spl.j2me.Animation.TiledAnimation;
import com.spl.j2me.GUIIC.ControlItem;
import com.spl.j2me.Game.Constants;
import com.spl.j2me.Game.GameScreen;
import com.spl.j2me.Game.GameShopScreen;
import com.spl.j2me.Game.ICallbackNotify;
import com.spl.j2me.Game.TiledButtonControl;
import javax.microedition.lcdui.Graphics;

public class GameBuilding
extends ControlItem
implements Constants {
    protected TiledAnimation buildingAnimation;
    protected TiledButtonControl upgradeButton;
    ICallbackNotify callbackParent;
    protected int positionID;
    protected byte currentUpgrade;
    protected int upgradeCost;
    protected boolean upgradeButtonState;
    protected int currentBuildingType;
    protected int screenX;
    protected int screenY;
    protected boolean isUpdateEnabled = true;

    public GameBuilding(int n, int n2, byte by) {
        super(n);
        this.currentUpgrade = by;
        this.currentBuildingType = n2;
        this.tryAddUpgradeButton();
    }

    public void tryAddUpgradeButton() {
        if (this.currentUpgrade > 0 && this.currentUpgrade < GameShopScreen.currentShopState[this.currentBuildingType + 12][0]) {
            this.upgradeButtonState = true;
            if (this.upgradeButton != null) {
                if (GameScreen.currentLevelMoney >= Constants.supportBuildingData[this.currentBuildingType][this.currentUpgrade - 1][0]) {
                    this.upgradeButton.setEnabled(true);
                } else {
                    this.upgradeButton.setEnabled(false);
                }
                this.upgradeButton.setFocused(false);
            }
        }
    }

    public void setUpgradeButton(TiledButtonControl tiledButtonControl) {
        this.upgradeButton = tiledButtonControl;
        this.tryAddUpgradeButton();
    }

    public void setPosition(int n) {
        this.positionID = n;
        if (n < Constants.buildingPosition.length) {
            this.screenX = Constants.buildingPosition[this.positionID][0];
            this.screenY = Constants.buildingPosition[this.positionID][1] - this.height;
            this.x = this.screenX << 11;
            this.y = this.screenY << 11;
            this.upgradeButton.updateButtonPosition(Constants.buildingPosition[this.positionID][2], Constants.buildingPosition[this.positionID][3]);
            this.buildingAnimation.updateAnimationPosition(this.screenX, this.screenY);
        }
    }

    public void setAnimation(TiledAnimation tiledAnimation) {
        this.buildingAnimation = tiledAnimation;
        this.width = this.buildingAnimation.animationWidth;
        this.height = this.buildingAnimation.animationHeight;
        this.buildingAnimation.setFrameToDraw(this.buildingAnimation.getCurrentFrame());
    }

    public void setCallbackParent(ICallbackNotify iCallbackNotify) {
        this.callbackParent = iCallbackNotify;
    }

    public void open() {
    }

    public void close() {
    }

    public void delete() {
    }

    public void draw(Graphics graphics) {
        if (!this.isUpdateEnabled) {
            return;
        }
        if (this.buildingAnimation != null) {
            this.buildingAnimation.draw(graphics);
            if (this.upgradeButtonState && this.currentUpgrade != 0) {
                this.upgradeButton.draw(graphics);
            }
        }
    }

    public void setControlItemRect(int[] nArray) {
        this.x = nArray[0] << 11;
        this.y = nArray[1] << 11;
        this.screenX = nArray[0];
        this.screenY = nArray[1];
        this.width = nArray[2];
        this.height = nArray[3];
    }

    public void tick(long l) {
        this.tryAddUpgradeButton();
    }

    public boolean isIntersected(int n, int n2, int n3, int n4) {
        return Math.abs(this.screenX + this.width / 2 - (n + n3 / 2)) < (n3 + this.width) / 3 && Math.abs(this.screenY + this.height / 2 - (n2 + n4 / 2)) < (n4 + this.height) / 3;
    }

    public int[] getBoudingBox() {
        return new int[]{this.screenX, this.screenY, this.width, this.height};
    }

    public int[] getCenterPoint() {
        return new int[]{this.screenX + this.width / 2, this.screenY + this.height / 2};
    }

    public void upgradeBuilding(int n) {
        this.upgradeButtonState = false;
        if (n <= 0 && this.currentUpgrade <= 0) {
            return;
        }
        this.currentUpgrade = (byte)(n > 0 ? this.currentUpgrade + n : 0);
        if (this.callbackParent != null) {
            this.callbackParent.onUpdateBuildingAnimation(this.controlID, this.positionID, 0, this.currentBuildingType, this.currentUpgrade);
        }
        this.tryAddUpgradeButton();
        if (this.currentUpgrade > 0 && this.currentBuildingType != 2) {
            this.buildingAnimation.setFrameToDraw(this.currentUpgrade - 1);
        }
    }

    public boolean pointerPressed(int n, int n2) {
        if (!this.isUpdateEnabled) {
            return false;
        }
        if (this.upgradeButton != null && this.upgradeButtonState) {
            if (this.upgradeButton.pointerPressed(n, n2)) {
                this.upgradeButton.setFocused(true);
            } else {
                this.upgradeButton.setFocused(false);
            }
        }
        return this.screenX < n && this.screenX + this.width > n && this.screenY < n2 && this.screenY + this.height > n2;
    }

    public boolean pointerReleased(int n, int n2) {
        if (!this.isUpdateEnabled) {
            return false;
        }
        if (this.upgradeButton != null && this.upgradeButtonState && this.upgradeButton.pointerReleased(n, n2)) {
            this.upgradeButton.setFocused(false);
            this.upgradeBuilding(1);
            return false;
        }
        if (this.currentUpgrade == 0 && Math.abs(this.screenX + this.width / 2 - (n + 8)) < (16 + this.width) / 3 && Math.abs(this.screenY + this.height / 2 - (n2 + 6)) < (12 + this.height) / 3) {
            return true;
        }
        return this.currentUpgrade > 0 && Math.abs(this.screenX + this.width / 2 - (n + 8)) < (16 + this.width) / 3 && Math.abs(this.screenY + this.height / 2 - (n2 + 6)) < (12 + this.height) / 3;
    }

    public boolean pointerDragged(int n, int n2) {
        return true;
    }

    public boolean keyPressed(int n) {
        return true;
    }

    public boolean keyReleased(int n) {
        return true;
    }

    public boolean keyRepeated(int n) {
        return true;
    }

    public byte getCurrentUpgrade() {
        return this.currentUpgrade;
    }
}

