/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Game;

import com.spl.j2me.Game.AnimalBase;
import com.spl.j2me.Game.GameProduct;
import com.spl.j2me.Game.MathExt;
import javax.microedition.lcdui.Graphics;

public class AnimalCat
extends AnimalBase {
    GameProduct currentProduct = null;

    public AnimalCat(int n) {
        super(n, 5);
        this.currentMovingSpeed = 50;
    }

    public void draw(Graphics graphics) {
        super.draw(graphics);
    }

    public boolean hasProduct() {
        return this.currentProduct != null;
    }

    public void tick(long l) {
        super.tick(l);
        if (this.isAppearing || this.isDroppedOut) {
            return;
        }
        if (this.appearingYOffset < 0) {
            this.appearingYOffset = 0;
            if (this.callbackParent != null) {
                this.callbackParent.onShowHint(5, this.screenX + this.width / 2, this.screenY + this.height / 2, false);
            }
        }
        if (this.currentProduct != null) {
            this.changeDirectionTimer = AnimalBase.ANIMAL_CHANGE_DIRECTION_PERIOD;
            if (this.currentProduct.isIntersected(this.screenX + this.width / 2, this.screenY + this.height / 2, 4, 4)) {
                this.callbackParent.onProductClick(this.currentProduct.controlID);
            }
        }
    }

    public void setProduct(GameProduct gameProduct) {
        this.currentProduct = gameProduct;
        int[] nArray = gameProduct.getPosition();
        int n = Math.abs(this.screenX + this.width / 2 - nArray[0]);
        int n2 = Math.abs(this.screenY + this.height / 2 - nArray[1]);
        int n3 = MathExt.sqrt(n * n + n2 * n2);
        this.movingDirectionX = ((nArray[0] << 11) - (this.screenX + this.width / 2 << 11)) / n3;
        this.movingDirectionY = ((nArray[1] << 11) - (this.screenY + this.height / 2 << 11)) / n3;
        this.currentAngle = this.countAngle(this.movingDirectionX, this.movingDirectionY);
        this.currentMovingDirection = super.getDirection(this.currentMovingDirection);
        super.updateModel();
        nArray = null;
    }

    public void removeProduct(int n) {
        if (this.currentProduct != null && this.currentProduct.controlID == n) {
            this.currentProduct = null;
        }
    }
}

