/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Game;

import com.spl.j2me.GUIIC.ControlItem;
import com.spl.j2me.GUIIC.FontManager;
import com.spl.j2me.Game.FarmContainer;
import com.spl.j2me.RM.ResourceManager;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TiledButtonControl
extends ControlItem {
    static final byte BUTTON_DEFAULT = 0;
    static final byte BUTTON_FOCUSED = 1;
    static final byte BUTTON_FOCUSED_PRESSED = 2;
    static final byte BUTTON_DISABLED = 3;
    public static final byte BUTTON_TYPE_COUNT = 4;
    static final byte BUTTON_DEFAULT_MODE = 0;
    static final byte BUTTON_TILED_MODE = 1;
    static final byte BUTTON_LIST_MODE = 2;
    static final byte BUTTON_SELECTOR_MODE = 3;
    protected int buttonImageID;
    protected int buttonTileHeight;
    protected int buttonTileWidth;
    protected byte[] buttonTypes;
    protected String buttonLabel;
    protected int buttonLabelID;
    protected byte typeCount = (byte)-1;
    protected byte currentType = 0;
    protected boolean useButtonCustomTypes = false;
    protected byte currentMode = 0;
    protected boolean m_pressed;
    protected Vector listVariantText;
    protected int currentVariant;
    protected int arrowHeight;
    protected int arrowWidth;
    protected int fontID;

    public TiledButtonControl(int n, int n2, byte by, int n3) {
        super(n);
        this.buttonLabel = FarmContainer.getLocaleString(n2);
        this.buttonLabelID = n2;
        this.m_pressed = false;
        this.currentMode = by;
        this.fontID = n3;
        this.useButtonCustomTypes = false;
        this.buttonImageID = -1;
        if (by == 2 || this.currentMode == 3) {
            this.listVariantText = new Vector();
        }
    }

    public TiledButtonControl(TiledButtonControl tiledButtonControl, int n, int n2, byte by) {
        super(n);
        this.buttonImageID = tiledButtonControl.buttonImageID;
        this.currentMode = by;
        this.buttonLabel = tiledButtonControl.buttonLabel;
        this.buttonLabelID = n2;
        this.buttonTypes = tiledButtonControl.buttonTypes;
        this.buttonTileHeight = tiledButtonControl.buttonTileHeight;
        this.buttonTileWidth = tiledButtonControl.buttonTileWidth;
        this.typeCount = tiledButtonControl.typeCount;
        this.x = tiledButtonControl.x;
        this.y = tiledButtonControl.y;
        this.height = tiledButtonControl.height;
        this.width = tiledButtonControl.width;
        this.touch_x = tiledButtonControl.x;
        this.touch_y = tiledButtonControl.y;
        this.touch_height = tiledButtonControl.height;
        this.touch_width = tiledButtonControl.width;
        this.m_handler = tiledButtonControl.m_handler;
        this.fontID = tiledButtonControl.fontID;
        this.useButtonCustomTypes = false;
    }

    public void addVariant(String string) {
        if (this.currentMode == 2 || this.currentMode == 3) {
            this.listVariantText.addElement(string);
        }
    }

    public void resetVariants() {
        if (this.listVariantText.size() > 0) {
            this.listVariantText.removeAllElements();
        }
    }

    public void setCurrentVariant(int n) {
        if (n > -1 && n < this.listVariantText.size()) {
            this.currentVariant = n;
        }
    }

    public void setTileImage(int n, byte[] byArray, byte by, int n2, int n3) {
        this.buttonImageID = n;
        this.buttonTypes = byArray;
        this.typeCount = by;
        this.touch_height = this.height = (this.buttonTileHeight = n3 / (by * (this.currentMode == 1 || this.currentMode == 2 || this.currentMode == 3 ? 3 : 1)));
        this.buttonTileWidth = n2;
        if (this.currentMode == 0) {
            this.touch_width = this.width = n2;
        }
    }

    public void setUseButtonCustomTypes(boolean bl) {
        this.useButtonCustomTypes = bl;
    }

    public void setButtonCustomType(int n) {
        if (this.useButtonCustomTypes) {
            this.currentType = (byte)n;
        }
    }

    public void updateButtonLabel(String string) {
        this.buttonLabel = string;
    }

    public void updateButtonLabelID(int n) {
        this.buttonLabelID = n;
    }

    public void updateButtonPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.touch_x = n;
        this.touch_y = n2;
    }

    public void move(int n, int n2) {
        this.x += n;
        this.y += n2;
        this.touch_x += n;
        this.touch_y += n2;
    }

    public void delete() {
    }

    public void draw(Graphics graphics) {
        int n;
        Image image;
        if (this.m_hidden) {
            return;
        }
        if (!this.useButtonCustomTypes) {
            this.currentType = (byte)(this.m_enabled ? (this.m_focused ? 1 : 0) : 3);
        }
        Image image2 = image = (n = ResourceManager.getCachedID(this.buttonImageID >> 24, this.buttonImageID & 0xFFFFFF)) == -1 ? null : (Image)ResourceManager.resCache.elementAt(n);
        if (image != null) {
            graphics.drawRegion(image, 0, this.height * this.buttonTypes[this.currentType], this.buttonTileWidth, this.height, 0, this.x, this.y, 0);
            if (this.currentMode == 1 || this.currentMode == 2 || this.currentMode == 3) {
                int n2 = (this.width - (this.buttonTileWidth << 1)) / this.buttonTileWidth + 1;
                graphics.setClip(this.x + this.buttonTileWidth, this.y, this.width - (this.buttonTileWidth << 1), this.height);
                int n3 = -1;
                while (++n3 < n2) {
                    graphics.drawRegion(image, 0, this.height * (this.typeCount + this.buttonTypes[this.currentType]), this.buttonTileWidth, this.height, 0, this.x + this.buttonTileWidth * (1 + n3), this.y, 0);
                }
                graphics.setClip(0, 0, 240, 320);
                graphics.drawRegion(image, 0, this.height * ((this.typeCount << 1) + this.buttonTypes[this.currentType]), this.buttonTileWidth, this.height, 0, this.x + this.width - this.buttonTileWidth, this.y, 0);
            }
        }
        if (this.currentMode == 2) {
            this.buttonLabel = (String)this.listVariantText.elementAt(this.currentVariant);
        }
        if (this.buttonLabel != null) {
            FontManager.getInstance(0).drawString(graphics, this.fontID, this.buttonLabelID == -1 ? this.buttonLabel : FarmContainer.getLocaleString(this.buttonLabelID), this.x + this.width / 2, this.y + FontManager.getInstance(0).getFontHeight(this.fontID) + (this.height - FontManager.getInstance(0).getFontHeight(this.fontID)) / 2, 0);
        }
        if (this.currentMode == 2 || this.currentMode == 3) {
            this.arrowWidth = this.arrowHeight = this.height / 2;
            if (this.currentVariant > 0) {
                graphics.setColor(0xFFFFFF);
                graphics.fillTriangle(this.x + this.arrowWidth / 2, this.y + this.height / 2, this.x + this.arrowWidth * 3 / 2, this.y + this.height / 2 - this.arrowHeight / 2, this.x + this.arrowWidth * 3 / 2, this.y + this.height / 2 + this.arrowHeight / 2);
            }
            if (this.currentVariant < this.listVariantText.size() - 1) {
                graphics.setColor(0xFFFFFF);
                graphics.fillTriangle(this.x + this.width - this.arrowWidth / 2, this.y + this.height / 2, this.x + this.width - this.arrowWidth * 3 / 2, this.y + this.height / 2 - this.arrowHeight / 2, this.x + this.width - this.arrowWidth * 3 / 2, this.y + this.height / 2 + this.arrowHeight / 2);
            }
        }
    }

    public void open() {
    }

    public void close() {
    }

    public boolean keyPressed(int n) {
        if (this.currentMode == 2 || this.currentMode == 3) {
            if (n == 2) {
                if (this.currentVariant > 0) {
                    --this.currentVariant;
                }
                return true;
            }
            if (n == 3) {
                if (this.currentVariant < this.listVariantText.size() - 1) {
                    ++this.currentVariant;
                }
                return true;
            }
        }
        this.m_pressed = true;
        return false;
    }

    public boolean keyRepeated(int n) {
        return false;
    }

    public boolean keyReleased(int n) {
        this.m_pressed = false;
        return false;
    }

    public boolean pointerPressed(int n, int n2) {
        return this.m_enabled && !this.m_hidden && n >= this.touch_x && n < this.touch_x + this.touch_width && n2 >= this.touch_y && n2 < this.touch_y + this.touch_height;
    }

    public boolean pointerReleased(int n, int n2) {
        return this.m_enabled && !this.m_hidden && n >= this.touch_x && n < this.touch_x + this.touch_width && n2 >= this.touch_y && n2 < this.touch_y + this.touch_height;
    }

    public boolean pointerDragged(int n, int n2) {
        return false;
    }
}

