/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Game;

import com.spl.j2me.Animation.TiledAnimation;
import com.spl.j2me.GUIIC.ControlContainer;
import com.spl.j2me.GUIIC.ControlItem;
import com.spl.j2me.GUIIC.FontManager;
import com.spl.j2me.GUIIC.Handler;
import com.spl.j2me.Game.AwardsViewScreen;
import com.spl.j2me.Game.Constants;
import com.spl.j2me.Game.FarmContainer;
import com.spl.j2me.Game.GameScreen;
import com.spl.j2me.Game.GameShopScreen;
import com.spl.j2me.Game.ICallbackNotify;
import com.spl.j2me.Game.ProfileViewScreen;
import com.spl.j2me.Game.TextScrollControl;
import com.spl.j2me.Game.TiledButtonControl;
import com.spl.j2me.Game.TiledControl;
import com.spl.j2me.RM.ResourceManager;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameMap
extends ControlContainer
implements Constants,
Handler {
    public static final int MAP_EVENT_LOAD_LEVEL = 0;
    public static final int LEVEL_LOCKED = -1;
    public static final int LEVEL_AVAILABLE = 1;
    public static final int LEVEL_AVAILABLE_LOCKED = 0;
    public static final int LEVEL_PASSED = 2;
    public static final int LEVEL_PASSED_SILVER = 3;
    public static final int LEVEL_PASSED_GOLD = 4;
    protected int mapBackgroundID;
    protected int hudImageID;
    protected TiledButtonControl levelButtonControl;
    protected TiledButtonControl mapMenuButton;
    protected TiledButtonControl mapShopButton;
    protected ICallbackNotify callbackParent;
    protected int mapXOffset = 0;
    protected int mapYOffset = 0;
    protected int mapXMaxOffset = 0;
    protected int mapYMaxOffset = 0;
    protected int prevXPoint = -1;
    protected int prevYPoint = -1;
    protected Vector levelsButton = new Vector();
    protected Vector levelsButtonMap = new Vector();
    protected byte availableLevelCount = 0;
    protected int prevSelectedLevel = -1;
    protected int currSelectedLevel = -1;
    protected int mapObjectsID;
    protected int cursorPosX = 0;
    protected int cursorPosY = 0;
    protected int cursorXAxis = 0;
    protected int cursorYAxis = 0;
    protected int arrowSize;
    protected int bottomBarSize = -1;
    protected int cursorMultiplier = 8192;
    protected int[][] objectsFrames;
    protected Vector objectsFrameMap;
    protected int[][] objectsPosition;
    protected int objectPositionCount;
    protected Vector objectsPositionMap = new Vector();
    protected Vector objectsImageMap = new Vector();
    protected Vector mapObjectsToShow;
    protected int mapObjectsCount = 0;
    public int[][] levelIconPosition = null;
    protected byte[][][] levelAccessData = null;
    protected byte[][] levelMap;
    protected byte[] levelPrevLevel;
    protected byte[] levelState;
    protected int[][] levelObjectAppearance;
    protected ControlContainer popupTipScreen;
    protected boolean mapLockedPopup = false;
    protected int mapLockedPopupYOffset = -1;
    protected int levelTipID = -1;
    protected int currentRequiredUpgradeID = -1;
    protected ControlContainer hintWindow;
    protected boolean hintWindowShown = false;
    protected int currentHintID = -1;
    protected int tipHeight = -1;
    protected int tipWidth = -1;
    protected int checkImageID;
    protected boolean selectedState = true;
    protected int selectedLevelTimer;
    protected int selectedLevelPeriod = 500;
    public static final int TILED_MAP_TILES_COUNT = 17;
    public static final int TILED_MAP_HOUSES_COUNT = 13;
    TiledAnimation mapTiles;
    private byte[][] tileArray = null;
    private int[][] housesPos = null;
    private int tileW = 0;
    private int tileH = 0;
    public static long prevTime = -1L;

    public GameMap(int n, Handler handler) {
        super(n, handler);
        this.objectsFrameMap = new Vector();
        this.levelAccessData = new byte[90][][];
        this.levelPrevLevel = new byte[90];
        this.mapObjectsToShow = new Vector();
    }

    public void levelComplete(int n, int n2, boolean bl) {
        int n3;
        int n4 = this.levelsButtonMap.indexOf(new Integer(n));
        if (n == 0) {
            this.setupHintWindow(24, this.levelIconPosition[1][0] - this.mapXOffset, this.levelIconPosition[1][1] - this.mapYOffset, false);
        }
        if (n == 1) {
            this.setupHintWindow(25, 30, 290, false);
        }
        if (n4 != -1) {
            TiledButtonControl tiledButtonControl = (TiledButtonControl)this.levelsButton.elementAt(n4);
            if (this.levelState[n] == 1) {
                this.levelState[n] = (byte)n2;
                if (this.levelMap[n] != null) {
                    n3 = -1;
                    while (++n3 < this.levelMap[n].length) {
                        this.AddLevel(this.levelMap[n][n3]);
                    }
                }
                n3 = -1;
                while (++n3 < this.levelObjectAppearance[n].length) {
                    this.mapObjectsToShow.addElement(new Integer(this.levelObjectAppearance[n][n3]));
                }
            } else if (this.levelState[n] < n2) {
                this.levelState[n] = (byte)n2;
            }
            tiledButtonControl.setButtonCustomType(this.levelState[n]);
        }
        boolean bl2 = true;
        n3 = 1;
        int n5 = -1;
        while (++n5 < this.levelState.length) {
            if (this.levelState[n5] != 4) {
                bl2 = false;
            }
            if (this.levelState[n5] >= 2) continue;
            n3 = 0;
        }
        if (bl2) {
            AwardsViewScreen.setAward(0);
        }
        if (n3 != 0) {
            AwardsViewScreen.setAward(13);
        }
    }

    public void handle(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        switch (n3) {
            case 0: {
                if (this.m_handler != null) {
                    this.m_handler.handle(this.controlID, this.popupWindow.controlID);
                }
                this.removePopupWindow();
                this.mapLockedPopup = false;
                break;
            }
            case 258: {
                this.hintWindowShown = false;
                this.removePopupWindow();
                if (Constants.hintData[this.currentHintID][1] == -1) break;
                this.currentHintID = Constants.hintData[this.currentHintID][1];
                this.setupHintWindow(this.currentHintID, -1, -1, Constants.hintData[this.currentHintID][4] == 1);
            }
        }
    }

    public void setCheckImage(int n) {
        this.checkImageID = n;
    }

    public void setupPopupTipScreen(ControlContainer controlContainer) {
        this.popupTipScreen = controlContainer;
    }

    public void setLevelMapState(byte[] byArray) {
        this.levelState = byArray;
        this.updateLevelButtonsState();
    }

    protected void updateLevelButtonsState() {
        int n = -1;
        while (++n < this.levelsButton.size()) {
            int n2 = (Integer)this.levelsButtonMap.elementAt(n);
            ((TiledButtonControl)this.levelsButton.elementAt(n)).setButtonCustomType(this.levelState[n2]);
        }
    }

    public void setHintWindow(ControlContainer controlContainer) {
        this.hintWindow = controlContainer;
    }

    public void setupHintWindow(int n, int n2, int n3, boolean bl) {
        if (ProfileViewScreen.currentPlayerHintShown[n]) {
            return;
        }
        ProfileViewScreen.currentPlayerHintShown[n] = true;
        if (Constants.hintData[n][0] == -1) {
            return;
        }
        this.currentHintID = n;
        if (!bl) {
            int n4;
            if (n2 == -1) {
                n2 = Constants.hintData[this.currentHintID][2];
            }
            if (n3 == -1) {
                n3 = Constants.hintData[this.currentHintID][3];
            }
            int n5 = n4 = n2 < 120 ? 0 : 1;
            n2 = n4 == 0 ? (n2 += 4) : (n2 -= 120);
            n3 = (n4 += n3 < 160 ? 0 : 2) < 2 ? (n3 += 4) : (n3 -= 160);
            ((TiledControl)this.hintWindow.getItem(0)).setArrowPosition(n4);
            this.hintWindow.setControlItemRect(new int[]{n2, n3, 116, 156});
        }
        ((TextScrollControl)this.hintWindow.getItem(1)).setTextID(Constants.hintData[n][0]);
        this.setPopupWindow(this.hintWindow);
        this.hintWindowShown = true;
    }

    public void initMap() {
        this.levelsButton.removeAllElements();
        this.levelsButtonMap.removeAllElements();
        this.mapObjectsToShow.removeAllElements();
    }

    public void startNewGame() {
        if (ProfileViewScreen.isNewGame) {
            this.setFocusToLevel(0);
            this.AddLevel(0);
        } else {
            int n = 0;
            this.AddLevel(n);
            int n2 = 0;
            while (++n2 < this.levelState.length) {
                if (this.levelState[n2] < 0) continue;
                this.AddLevel(n2);
                int n3 = -1;
                while (++n3 < this.levelObjectAppearance[n2].length) {
                    this.mapObjectsToShow.addElement(new Integer(this.levelObjectAppearance[n2][n3]));
                }
            }
        }
        this.prevSelectedLevel = -1;
        this.updateLevelAccessData();
        this.updateLevelButtonsState();
    }

    public void updateLevelAccessData() {
        int n = -1;
        while (++n < this.levelAccessData.length) {
            if (this.levelAccessData[n] == null || this.levelState[n] != 0) continue;
            boolean bl = true;
            int n2 = -1;
            while (++n2 < this.levelAccessData[n].length) {
                if (ProfileViewScreen.currentPlayerShopState[this.levelAccessData[n][n2][0]][0] >= this.levelAccessData[n][n2][1] || this.levelState[n] != 0) continue;
                bl = false;
            }
            this.levelState[n] = (byte)(bl ? 1 : 0);
        }
        this.updateLevelButtonsState();
    }

    public void open() {
        super.open();
        if (ProfileViewScreen.isNewGame || ProfileViewScreen.currentPlayerLastPlayedLevelID == -1) {
            this.setFocusToLevel(0);
            if (ProfileViewScreen.isNewGame && this.levelsButton != null && this.levelsButton.size() == 1) {
                this.setupHintWindow(24, this.levelIconPosition[0][0] - this.mapXOffset, this.levelIconPosition[0][1] - this.mapYOffset, false);
            }
            ProfileViewScreen.isNewGame = false;
        } else {
            this.setFocusToLevel(ProfileViewScreen.currentPlayerLastPlayedLevelID);
        }
        this.arrowSize = ((Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(2, 0))).getWidth();
        this.cursorXAxis = 0;
        this.cursorYAxis = 0;
        prevTime = -1L;
    }

    private void AddLevel(int n) {
        int n2;
        byte by;
        TiledButtonControl tiledButtonControl = new TiledButtonControl(this.levelButtonControl, n, -1, 0);
        tiledButtonControl.setUseButtonCustomTypes(true);
        tiledButtonControl.setButtonCustomType(1);
        byte by2 = by = this.levelState[n] == -1 ? (byte)1 : this.levelState[n];
        if (this.levelAccessData[n] != null) {
            n2 = -1;
            while (++n2 < this.levelAccessData[n].length) {
                if (ProfileViewScreen.currentPlayerShopState[this.levelAccessData[n][n2][0]][0] >= this.levelAccessData[n][n2][1]) continue;
                GameShopScreen.initItem(this.levelAccessData[n][n2][0]);
                by = 0;
            }
        }
        if (by == 0) {
            n2 = -1;
            while (++n2 < this.levelAccessData[n].length) {
                GameScreen.loadRequiredHouseAnimation(this.levelAccessData[n][n2][0]);
            }
        }
        this.levelState[n] = by;
        tiledButtonControl.updateButtonPosition(this.levelIconPosition[n][0] - tiledButtonControl.buttonTileWidth / 2 - this.mapXOffset, this.levelIconPosition[n][1] - tiledButtonControl.buttonTileHeight / 2 - this.mapYOffset);
        tiledButtonControl.setButtonCustomType(this.levelState[n]);
        this.levelsButton.addElement(tiledButtonControl);
        this.levelsButtonMap.addElement(new Integer(n));
        this.availableLevelCount = (byte)(this.availableLevelCount + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapObjectAppearanceMap(byte[] byArray) {
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            byte by = ((DataInputStream)filterInputStream).readByte();
            this.levelObjectAppearance = new int[by][];
            byte by2 = -1;
            while (++by2 < by) {
                byte by3 = ((DataInputStream)filterInputStream).readByte();
                byte by4 = ((DataInputStream)filterInputStream).readByte();
                this.levelObjectAppearance[by3] = new int[by4];
                byte by5 = -1;
                while (++by5 < by4) {
                    this.levelObjectAppearance[by3][by5] = ((DataInputStream)filterInputStream).readInt();
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (Exception exception) {}
            filterInputStream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevelMapData(byte[] byArray) {
        int n;
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n2 = ((DataInputStream)filterInputStream).readByte();
            this.levelMap = new byte[90][];
            n = -1;
            while (++n < n2) {
                byte by = ((DataInputStream)filterInputStream).readByte();
                byte by2 = ((DataInputStream)filterInputStream).readByte();
                this.levelMap[by] = new byte[by2];
                byte by3 = -1;
                while (++by3 < by2) {
                    this.levelMap[by][by3] = ((DataInputStream)filterInputStream).readByte();
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (Exception exception) {}
            filterInputStream = null;
        }
        this.levelPrevLevel[0] = -1;
        int n3 = -1;
        while (++n3 < 90) {
            if (this.levelMap[n3] != null) {
                n = -1;
                while (++n < this.levelMap[n3].length) {
                    this.levelPrevLevel[this.levelMap[n3][n]] = (byte)n3;
                }
                continue;
            }
            this.levelPrevLevel[n3] = (byte)(n3 - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevelAccessData(byte[] byArray) {
        FilterInputStream filterInputStream = null;
        try {
            byte by;
            filterInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.levelAccessData[0] = null;
            for (int i = filterInputStream.available(); i > 0; i -= by * 2 + 2) {
                byte by2 = ((DataInputStream)filterInputStream).readByte();
                by = ((DataInputStream)filterInputStream).readByte();
                if (by <= 0) continue;
                this.levelAccessData[by2] = new byte[by][2];
                byte by3 = -1;
                while (++by3 < by) {
                    this.levelAccessData[by2][by3][0] = ((DataInputStream)filterInputStream).readByte();
                    this.levelAccessData[by2][by3][1] = ((DataInputStream)filterInputStream).readByte();
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (Exception exception) {}
            filterInputStream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevelIconPosition(byte[] byArray) {
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n = filterInputStream.available() / 6;
            this.levelIconPosition = new int[n][2];
            int n2 = -1;
            while (++n2 < n) {
                ((DataInputStream)filterInputStream).readShort();
                this.levelIconPosition[n2][0] = ((DataInputStream)filterInputStream).readShort();
                this.levelIconPosition[n2][1] = ((DataInputStream)filterInputStream).readShort();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                filterInputStream.close();
                filterInputStream = null;
            }
            catch (Exception exception) {}
        }
    }

    public void setMapObjects(int n, byte[] byArray, byte[] byArray2) {
        int n2;
        this.mapObjectsID = n;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            this.mapObjectsCount = dataInputStream.readShort();
            this.objectsFrames = new int[this.mapObjectsCount][4];
            int n3 = -1;
            while (++n3 < this.mapObjectsCount) {
                n2 = dataInputStream.readShort();
                this.objectsFrameMap.addElement(new Integer(n2));
            }
            n3 = -1;
            while (++n3 < this.mapObjectsCount) {
                this.objectsFrames[n3][0] = dataInputStream.readShort();
                this.objectsFrames[n3][1] = dataInputStream.readShort();
                this.objectsFrames[n3][2] = dataInputStream.readShort();
                this.objectsFrames[n3][3] = dataInputStream.readShort();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byArray2));
        try {
            this.objectPositionCount = dataInputStream2.readUnsignedByte() + (dataInputStream2.readUnsignedByte() << 8);
            this.objectsPosition = new int[this.objectPositionCount][2];
            n2 = -1;
            while (++n2 < this.objectPositionCount) {
                int n4 = dataInputStream2.readUnsignedByte() + (dataInputStream2.readUnsignedByte() << 8);
                int n5 = dataInputStream2.readUnsignedByte() + (dataInputStream2.readUnsignedByte() << 8);
                int n6 = dataInputStream2.readUnsignedByte() + (dataInputStream2.readUnsignedByte() << 8);
                int n7 = dataInputStream2.readUnsignedByte() + (dataInputStream2.readUnsignedByte() << 8);
                this.objectsPositionMap.addElement(new Integer(n5));
                this.objectsImageMap.addElement(new Integer(n4));
                this.objectsPosition[n2][0] = n6;
                this.objectsPosition[n2][1] = n7;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCallbackParent(ICallbackNotify iCallbackNotify) {
        this.callbackParent = iCallbackNotify;
    }

    public void setFocusToLevel(int n) {
        int n2 = this.levelIconPosition[n][0];
        int n3 = this.levelIconPosition[n][1];
        this.moveMap(-(n2 - 120) + this.mapXOffset, -(n3 - 160) + this.mapYOffset);
        this.cursorPosX = n2;
        this.cursorPosY = n3;
        this.currSelectedLevel = n;
        this.selectedState = true;
    }

    public void setBackgroundImage(int n, int n2, int n3) {
        this.mapBackgroundID = n;
        this.mapXMaxOffset = n2 - 240;
        this.mapYMaxOffset = n3 - 320;
    }

    public void setLevelButtonControl(TiledButtonControl tiledButtonControl) {
        this.levelButtonControl = tiledButtonControl;
    }

    public void setMapTileAnimation(TiledAnimation tiledAnimation) {
        this.mapTiles = tiledAnimation;
    }

    public void loadTileImageDataFromCache() {
    }

    public void setTiledMapData() {
        DataInputStream dataInputStream = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            int n4;
            ResourceManager.setResourcePackagePrefix(Constants.loadingPackageNames[6]);
            byte[] byArray = ResourceManager.getBinaryData(0x220000);
            dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            n = dataInputStream.readInt();
            n2 = dataInputStream.readInt();
            this.tileArray = new byte[n2][n];
            for (n4 = 0; n4 < n2; ++n4) {
                dataInputStream.read(this.tileArray[n4]);
            }
            n3 = dataInputStream.readInt();
            this.housesPos = new int[n3][3];
            for (n4 = 0; n4 < n3; ++n4) {
                this.housesPos[n4][0] = dataInputStream.readInt();
                this.housesPos[n4][1] = dataInputStream.readInt();
                this.housesPos[n4][2] = dataInputStream.readInt();
            }
            dataInputStream.close();
            this.loadTileImageDataFromCache();
            this.tileW = this.mapTiles.getCurrentFrameWidth(0);
            this.tileH = this.mapTiles.getCurrentFrameHeight(0);
            n4 = n;
            int n5 = n2;
            if (n * this.tileW < 240 && (n4 = 240 / this.tileW) * this.tileW < 240) {
                ++n4;
            }
            if (n2 * this.tileH < 320 && (n5 = 320 / this.tileH) * this.tileH < 320) {
                ++n5;
            }
            if (n4 != n || n5 != n2) {
                byte[][] byArray2 = new byte[n5][n4];
                for (int i = 0; i < n5; ++i) {
                    for (int j = 0; j < n4; ++j) {
                        byArray2[i][j] = i < n2 && j < n ? this.tileArray[i][j] : (byte)0;
                    }
                }
                n = n4;
                n2 = n5;
                this.tileArray = byArray2;
            }
            this.mapXMaxOffset = n * this.tileW - 240;
            this.mapYMaxOffset = n2 * this.tileH - 320;
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void draw(Graphics graphics) {
        int n;
        int n2;
        int n3 = 240 / this.tileW;
        int n4 = 320 / this.tileH;
        if (n3 * this.tileW < 240) {
            ++n3;
        }
        if (n4 * this.tileH < 320) {
            ++n4;
        }
        int n5 = this.mapXOffset / this.tileW;
        int n6 = this.mapYOffset / this.tileH;
        if (n3 * this.tileW - (this.mapXOffset - n5 * this.tileW) < 240) {
            ++n3;
        }
        if (n4 * this.tileH - (this.mapYOffset - n6 * this.tileH) < 320) {
            ++n4;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                if (this.tileArray[n6 + n2][n5 + n] == -1) continue;
                this.mapTiles.setFrameToDraw(this.tileArray[n6 + n2][n5 + n]);
                this.mapTiles.updateAnimationPosition(n * this.tileW - (this.mapXOffset - n5 * this.tileW), n2 * this.tileH - (this.mapYOffset - n6 * this.tileH));
                this.mapTiles.draw(graphics);
            }
        }
        for (n2 = 0; n2 < this.housesPos.length; ++n2) {
            n = this.mapTiles.getCurrentFrameWidth(17 + this.housesPos[n2][2]);
            int n7 = this.mapTiles.getCurrentFrameHeight(17 + this.housesPos[n2][2]);
            if (this.housesPos[n2][0] + n - this.mapXOffset <= 0 && this.housesPos[n2][0] - this.mapXOffset >= 240 || this.housesPos[n2][1] + n7 - this.mapYOffset <= 0 && this.housesPos[n2][1] - this.mapXOffset >= 320) continue;
            this.mapTiles.setFrameToDraw(17 + this.housesPos[n2][2]);
            this.mapTiles.updateAnimationPosition(this.housesPos[n2][0] - this.mapXOffset, this.housesPos[n2][1] - this.mapYOffset);
            this.mapTiles.draw(graphics);
        }
        if (this.levelButtonControl != null) {
            n2 = -1;
            while (++n2 < this.levelsButton.size()) {
                ((TiledButtonControl)this.levelsButton.elementAt(n2)).draw(graphics);
            }
        }
        if (this.selectedState) {
            Image image = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(6, 0x210000));
            graphics.drawImage(image, this.levelIconPosition[this.currSelectedLevel][0] - this.mapXOffset, this.levelIconPosition[this.currSelectedLevel][1] - this.mapYOffset, 3);
        }
        Image image = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(6, 0x230000));
        graphics.drawImage(image, 0, 320 - image.getHeight(), 0);
        if (this.bottomBarSize == -1) {
            this.bottomBarSize = image.getHeight();
        }
        super.draw(graphics);
    }

    public void onEndDraw(Graphics graphics) {
        if (this.mapLockedPopup) {
            this.popupWindow.draw(graphics);
            int n = FontManager.getInstance(-1).getFontHeight(0);
            int n2 = this.mapLockedPopupYOffset + n;
            FontManager.getInstance(-1).drawString(graphics, 0, FarmContainer.getLocaleString(Constants.levelNames[this.levelTipID]), 120, n2, 0);
            n2 += 8;
            int n3 = (240 - this.tipWidth) / 2 + 10;
            Image image = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(this.checkImageID >> 24, this.checkImageID & 0xFFFFFF));
            int n4 = -1;
            while (++n4 < this.levelAccessData[this.levelTipID].length) {
                graphics.setColor(3310562);
                graphics.fillRoundRect(n3, n2, 189, 60, 12, 12);
                graphics.setColor(15134715);
                graphics.drawRoundRect(n3, n2, 189, 60, 15, 15);
                graphics.drawRoundRect(n3 + 1, n2 + 1, 187, 58, 13, 13);
                Vector vector = FontManager.getInstance(-1).wrapText(1, FarmContainer.getLocaleString(Constants.shopTipData[this.levelAccessData[this.levelTipID][n4][0]][0]), 113);
                int n5 = -1;
                while (++n5 < vector.size()) {
                    FontManager.getInstance(-1).drawString(graphics, 3, (String)vector.elementAt(n5), n3 + 75, n2 + FontManager.getInstance(-1).getFontHeight(1) * 2 + FontManager.getInstance(-1).getFontHeight(1) * (5 * n5) / 4, 1);
                }
                FontManager.getInstance(-1).drawString(graphics, 0, FarmContainer.getLocaleString(36) + ": " + this.levelAccessData[this.levelTipID][n4][1], n3 + 75, n2 + 60 - FontManager.getInstance(-1).getFontHeight(1), 1);
                n5 = this.levelAccessData[this.levelTipID][n4][0];
                int n6 = this.levelAccessData[this.levelTipID][n4][1] - 1;
                Image image2 = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(6, Constants.shopItemResources[n5]));
                graphics.drawImage(image2, n3 + image.getWidth() + (94 - image.getWidth() - GameScreen.houseAnimations.animationWidth) / 2, n2 + (60 - image2.getHeight()) / 2, 0);
                if (image != null && this.levelAccessData[this.levelTipID][n4][1] <= ProfileViewScreen.currentPlayerShopState[this.levelAccessData[this.levelTipID][n4][0]][0]) {
                    graphics.drawImage(image, n3 + 2, n2 + (60 - image.getHeight()) / 2, 0);
                }
                n2 += 64;
            }
            this.popupWindow.onEndDraw(graphics);
        } else {
            super.onEndDraw(graphics);
        }
    }

    public void setHUDImage(int n) {
        this.hudImageID = n;
    }

    public void setButtonControl(TiledButtonControl tiledButtonControl) {
        this.mapMenuButton = new TiledButtonControl(tiledButtonControl, 256, 16, 1);
        this.mapMenuButton.setControlItemRect(new int[]{164, 320 - this.mapMenuButton.buttonTileHeight * 3 / 2, 72, this.mapMenuButton.buttonTileHeight});
        this.mapMenuButton.setEnabled(false);
        this.mapMenuButton.setUseButtonCustomTypes(true);
        this.mapMenuButton.setButtonCustomType(0);
        this.addItem(this.mapMenuButton);
        this.mapShopButton = new TiledButtonControl(tiledButtonControl, 257, 21, 1);
        this.mapShopButton.setControlItemRect(new int[]{4, 320 - this.mapShopButton.buttonTileHeight * 3 / 2, 72, this.mapShopButton.buttonTileHeight});
        this.addItem(this.mapShopButton);
        this.mapShopButton.setEnabled(false);
        this.mapShopButton.setUseButtonCustomTypes(true);
        this.mapShopButton.setButtonCustomType(0);
    }

    public void tick(long l) {
        int n;
        if (prevTime == -1L) {
            prevTime = l;
        }
        long l2 = l - prevTime;
        prevTime = l;
        if (this.currSelectedLevel != -1 && this.selectedLevelTimer > this.selectedLevelPeriod) {
            this.selectedState = !this.selectedState;
            this.selectedLevelTimer = 0;
        } else {
            this.selectedLevelTimer = (int)((long)this.selectedLevelTimer + l2);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 30;
        this.cursorPosX = this.levelIconPosition[this.currSelectedLevel][0];
        this.cursorPosY = this.levelIconPosition[this.currSelectedLevel][1];
        if (this.cursorPosX < 240 + this.mapXMaxOffset) {
            n = n4;
            if (this.cursorPosX + n > 240 + this.mapXMaxOffset) {
                n = 240 + this.mapXMaxOffset - this.cursorPosX;
            }
            this.cursorPosX += n;
            if (this.cursorPosX - this.mapXOffset > 240) {
                n2 -= n;
            }
        }
        if (this.cursorPosX > 0) {
            n = n4;
            if (this.cursorPosX - n < 0) {
                n = this.cursorPosX;
            }
            this.cursorPosX -= n;
            if (this.cursorPosX < this.mapXOffset + 30) {
                n2 += n;
            }
        }
        if (this.cursorPosY + (n = n4) > 320 + this.mapYMaxOffset - this.bottomBarSize) {
            n = 320 + this.mapYMaxOffset - this.bottomBarSize - this.cursorPosY;
        }
        this.cursorPosY += n;
        if (this.cursorPosY - this.mapYOffset + this.bottomBarSize > 320) {
            n3 -= n;
        }
        if (this.cursorPosY > 0) {
            n = n4;
            if (this.cursorPosY - n < 0) {
                n = this.cursorPosY;
            }
            this.cursorPosY -= n;
            if (this.cursorPosY < this.mapYOffset + 30) {
                n3 += n;
            }
        }
        if (n2 != 0 || n3 != 0) {
            this.moveMap(n2, n3);
        }
    }

    private void moveMap(int n, int n2) {
        if (this.mapXOffset - n > this.mapXMaxOffset) {
            n -= this.mapXMaxOffset - (this.mapXOffset - n);
        }
        if (this.mapYOffset - n2 > this.mapYMaxOffset) {
            n2 -= this.mapYMaxOffset - (this.mapYOffset - n2);
        }
        if (this.mapXOffset - n < 0) {
            n += this.mapXOffset - n;
        }
        if (this.mapYOffset - n2 < 0) {
            n2 += this.mapYOffset - n2;
        }
        this.mapXOffset -= n;
        this.mapYOffset -= n2;
        int n3 = -1;
        while (++n3 < this.levelsButton.size()) {
            ((TiledButtonControl)this.levelsButton.elementAt(n3)).move(n, n2);
        }
    }

    public boolean keyPressed(int n) {
        boolean bl = false;
        if (this.m_menu_selected_item != -1) {
            bl = ((ControlItem)this.m_items.elementAt(this.m_menu_selected_item)).keyPressed(n);
        }
        if (this.popupWindow != null) {
            bl = this.popupWindow.keyPressed(n);
        }
        if (!(bl || this.popupWindow != null || n != 2 && n != 3 && n != 4 && n != 5)) {
            this.SetNextLevelID(n);
        }
        return bl;
    }

    void SetNextLevelID(int n) {
        int[] nArray = new int[4];
        int n2 = this.currSelectedLevel;
        nArray[0] = this.levelPrevLevel[n2] > -1 ? this.levelPrevLevel[n2] : 255;
        byte[] byArray = this.levelMap[n2];
        int n3 = 0;
        while (++n3 < 4) {
            if (byArray != null && byArray.length > n3 - 1) {
                nArray[n3] = byArray[n3 - 1];
                continue;
            }
            nArray[n3] = 255;
        }
        n3 = 0;
        boolean bl = false;
        switch (n) {
            case 4: {
                n3 = 0;
                bl = true;
                break;
            }
            case 5: {
                n3 = 0;
                bl = false;
                break;
            }
            case 2: {
                n3 = 1;
                bl = true;
                break;
            }
            case 3: {
                n3 = 1;
                bl = false;
            }
        }
        int n4 = this.currSelectedLevel;
        int n5 = -1;
        while (++n5 < 4) {
            int n6;
            boolean bl2;
            if (nArray[n5] == 255 || this.levelState[nArray[n5]] <= -1) continue;
            int n7 = Math.abs(this.levelIconPosition[n2][0] - this.levelIconPosition[nArray[n5]][0]);
            boolean bl3 = bl2 = n7 > (n6 = Math.abs(this.levelIconPosition[n2][1] - this.levelIconPosition[nArray[n5]][1]));
            if (n3 != 0) {
                if (!bl2 || (!bl || this.levelIconPosition[n2][0] - this.levelIconPosition[nArray[n5]][0] <= 0) && (bl || this.levelIconPosition[n2][0] - this.levelIconPosition[nArray[n5]][0] >= 0)) continue;
                n4 = nArray[n5];
                continue;
            }
            if (bl2 || (!bl || this.levelIconPosition[n2][1] - this.levelIconPosition[nArray[n5]][1] <= 0) && (bl || this.levelIconPosition[n2][1] - this.levelIconPosition[nArray[n5]][1] >= 0)) continue;
            n4 = nArray[n5];
        }
        if (this.currSelectedLevel != n4) {
            TiledButtonControl tiledButtonControl = (TiledButtonControl)this.levelsButton.elementAt(this.levelsButtonMap.indexOf(new Integer(this.currSelectedLevel)));
            tiledButtonControl.m_hidden = false;
            this.selectedLevelTimer = 0;
            this.currSelectedLevel = n4;
            this.selectedState = true;
            ProfileViewScreen.currentPlayerLastPlayedLevelID = (short)this.currSelectedLevel;
        }
    }

    public boolean keyRepeated(int n) {
        boolean bl = false;
        if (!bl && this.popupWindow == null) {
            this.cursorMultiplier = this.cursorMultiplier < 18432 ? this.cursorMultiplier + 4096 : this.cursorMultiplier;
        }
        return bl;
    }

    public boolean keyReleased(int n) {
        boolean bl = false;
        if (this.popupWindow != null) {
            bl = this.popupWindow.keyReleased(n);
        }
        if (!bl && this.popupWindow == null) {
            if (n == 1) {
                ((ControlItem)this.m_items.elementAt(0)).action();
            }
            if (n == 0) {
                ((ControlItem)this.m_items.elementAt(1)).action();
            }
            if (n == 6) {
                if (this.levelState[this.currSelectedLevel] != -1 && this.levelState[this.currSelectedLevel] != 0) {
                    this.m_handler.handle(this.controlID, ((TiledButtonControl)this.levelsButton.elementAt((int)this.levelsButtonMap.indexOf((Object)new Integer((int)this.currSelectedLevel)))).controlID);
                } else if (this.levelState[this.currSelectedLevel] == 0) {
                    this.mapLockedPopup = true;
                    this.levelTipID = this.currSelectedLevel;
                    TiledButtonControl tiledButtonControl = (TiledButtonControl)this.popupTipScreen.getItem(1);
                    this.tipHeight = this.levelAccessData[this.levelTipID].length * 64 + 24 + tiledButtonControl.buttonTileHeight + FontManager.getInstance(-1).getFontHeight(0);
                    this.tipWidth = 210;
                    tiledButtonControl.setControlItemRect(new int[]{(240 - this.tipWidth) / 2 + (this.tipWidth - 48) / 2, (320 - this.tipHeight) / 2 + this.tipHeight - 8 - tiledButtonControl.buttonTileHeight, 48, tiledButtonControl.buttonTileHeight});
                    ((TiledControl)this.popupTipScreen.getItem(0)).setControlItemRect(new int[]{(240 - this.tipWidth) / 2, (320 - this.tipHeight) / 2, this.tipWidth, this.tipHeight});
                    this.mapLockedPopupYOffset = (320 - this.tipHeight) / 2 + 8;
                    int n2 = -1;
                    while (++n2 < this.levelAccessData[this.levelTipID].length) {
                        if (this.levelAccessData[this.levelTipID][n2][1] <= ProfileViewScreen.currentPlayerShopState[this.levelAccessData[this.levelTipID][n2][0]][0]) continue;
                        this.currentRequiredUpgradeID = this.levelAccessData[this.levelTipID][n2][0];
                        break;
                    }
                    this.setPopupWindow(this.popupTipScreen);
                }
                ProfileViewScreen.currentPlayerLastPlayedLevelID = (short)((TiledButtonControl)this.levelsButton.elementAt((int)this.levelsButtonMap.indexOf((Object)new Integer((int)this.currSelectedLevel)))).controlID;
            }
        }
        return bl;
    }
}

