/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Game;

import com.spl.j2me.Animation.TiledAnimation;
import com.spl.j2me.GUIIC.ControlContainer;
import com.spl.j2me.GUIIC.FontManager;
import com.spl.j2me.GUIIC.Handler;
import com.spl.j2me.Game.CarViewElement;
import com.spl.j2me.Game.Constants;
import com.spl.j2me.Game.FarmContainer;
import com.spl.j2me.Game.GameScreen;
import com.spl.j2me.Game.TiledButtonControl;
import com.spl.j2me.RM.ResourceManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AirplaneView
extends ControlContainer
implements Handler,
Constants {
    protected TiledAnimation productContent;
    protected TiledAnimation listBackground;
    protected CarViewElement[] products = new CarViewElement[5];
    protected int cellBackgroundID;
    protected int planeCellsCount;
    protected int[] planeCells = new int[7];
    protected int[] planeCellsCurrentSize = new int[7];
    public int[] boughtProducts = new int[5];
    protected byte airplaneType;
    protected int productItemCount;
    protected int currentVisibleItem;
    protected TiledButtonControl[] cellButtons;
    protected boolean airplaneWorking = false;
    protected int itemBackgroundID;
    protected int buttonIndex;
    protected int selectedItem;
    protected boolean refreshFocused;
    protected boolean sendFocused;
    protected int[][] cellPositions;
    protected boolean[] productsData;
    protected int coinImageID;
    protected int money = 0;

    public AirplaneView(int n, Handler handler) {
        super(n, handler);
        int n2 = -1;
        while (++n2 < 5) {
            this.products[n2] = new CarViewElement(16 + n2, this);
            this.products[n2].updateCount(-1);
            this.products[n2].setControlItemRect(new int[]{0, 0, 214, 31});
        }
        this.cellButtons = new TiledButtonControl[7];
        this.listBackground = new TiledAnimation(-1, false);
        this.cellPositions = new int[7][2];
        this.productsData = new boolean[5];
    }

    public void setCellBackground(int n) {
        this.cellBackgroundID = n;
    }

    public void setItemBackgroundImage(int n, int n2, int n3) {
        this.itemBackgroundID = n;
        int n4 = -1;
        while (++n4 < this.cellButtons.length) {
            this.cellButtons[n4].setTileImage(this.itemBackgroundID, new byte[]{0, 0, 0, 0}, (byte)1, n2, n3);
        }
    }

    public void setupListBackground() {
        int n = -1;
        while (++n < this.cellButtons.length) {
            this.cellButtons[n] = new TiledButtonControl(0x10000 | n, -1, 0, 0);
            this.cellButtons[n].setControlItemRect(new int[]{0, 0, 18, 19});
            this.cellButtons[n].setEnabled(false);
            this.cellButtons[n].setForceHide(true);
            this.addItem(this.cellButtons[n]);
            this.cellButtons[n].setHandler(this);
        }
    }

    public void setCoinImage(int n) {
        this.coinImageID = n;
    }

    public void open() {
        super.open();
        this.money = 0;
        this.currentVisibleItem = 0;
        this.buttonIndex = 0;
        this.selectedItem = 0;
        this.refreshFocused = false;
        this.getItem(10).setFocused(false);
        this.sendFocused = false;
        this.getItem(8).setFocused(false);
        this.updateProductList();
        this.updateSubitemButtonState();
        ((TiledButtonControl)this.getItem(8)).setEnabled(false);
    }

    public void close() {
        super.close();
    }

    public void setAirplaneWorkingState(boolean bl) {
        this.airplaneWorking = bl;
    }

    public void setProductAccessData(boolean[] blArray) {
        boolean bl = false;
        int n = -1;
        while (++n < 5) {
            this.productsData[n] = blArray[n];
            if (!this.productsData[n]) continue;
            bl = true;
        }
        this.currentVisibleItem = 0;
        this.productItemCount = 0;
        n = -1;
        while (++n < 5) {
            this.planeCells[n] = 0;
            this.planeCellsCurrentSize[n] = 0;
            this.boughtProducts[n] = 0;
        }
        this.updateProductList();
    }

    public void setAirplaneType(byte by) {
        this.airplaneType = (byte)(by - 1);
        this.planeCellsCount = Constants.supportBuildingData[1][this.airplaneType][1];
        int n = -1;
        while (++n < this.planeCellsCount) {
            this.planeCells[n] = 0;
            this.planeCellsCurrentSize[n] = 0;
        }
        Image image = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(this.itemBackgroundID >> 24, this.itemBackgroundID & 0xFFFFFF));
        int n2 = 12;
        int n3 = 232;
        int n4 = n2;
        int n5 = -1;
        while (++n5 < this.planeCellsCount) {
            this.cellPositions[n5][0] = n4;
            this.cellPositions[n5][1] = n3;
            n4 += 21;
        }
        n5 = -1;
        while (++n5 < this.cellButtons.length) {
            if (n5 < this.planeCellsCount) {
                this.cellButtons[n5].updateButtonPosition(this.cellPositions[n5][0], this.cellPositions[n5][1]);
                this.cellButtons[n5].setEnabled(true);
                this.cellButtons[n5].setForceHide(false);
                n4 += image.getWidth() + n2;
                continue;
            }
            this.cellButtons[n5].setEnabled(false);
            this.cellButtons[n5].setForceHide(true);
        }
    }

    public void setProductContent(TiledAnimation tiledAnimation) {
        this.productContent = tiledAnimation;
        int n = -1;
        while (++n < 5) {
            TiledAnimation tiledAnimation2 = new TiledAnimation(tiledAnimation, -1);
            tiledAnimation2.updateAnimationPosition((32 - tiledAnimation2.animationWidth) / 2, (31 - tiledAnimation2.animationHeight) / 2);
            this.products[n].setContent(tiledAnimation2, 16 + n);
            this.products[n].setContentPrice(Constants.productData[16 + n][0], this.coinImageID, 64, 42);
        }
    }

    public void setButtons(TiledButtonControl tiledButtonControl, TiledButtonControl tiledButtonControl2, TiledButtonControl tiledButtonControl3) {
        int n = -1;
        while (++n < 5) {
            this.products[n].addButton(new TiledButtonControl(tiledButtonControl, 3 * n, -1, 1));
            this.products[n].addButton(new TiledButtonControl(tiledButtonControl2, 3 * n + 1, -1, 1));
            this.products[n].addButton(new TiledButtonControl(tiledButtonControl3, 3 * n + 2, -1, 1));
        }
    }

    private int fillAirplaneCells(int n, int n2) {
        int n3 = 0;
        int n4 = n2;
        int n5 = Constants.productData[n][3];
        int n6 = -1;
        while (++n6 < this.planeCellsCount) {
            if (n3 < n2) {
                if (this.planeCellsCurrentSize[n6] == 0) {
                    this.planeCells[n6] = n;
                    if (n4 > n5) {
                        this.planeCellsCurrentSize[n6] = n5;
                        n4 -= n5;
                        n3 += n5;
                        continue;
                    }
                    this.planeCellsCurrentSize[n6] = n4;
                    n3 += n4;
                    continue;
                }
                if (this.planeCells[n6] != n) continue;
                if (n4 > n5 - this.planeCellsCurrentSize[n6]) {
                    n4 -= n5 - this.planeCellsCurrentSize[n6];
                    n3 += n5 - this.planeCellsCurrentSize[n6];
                    int n7 = n6;
                    this.planeCellsCurrentSize[n7] = this.planeCellsCurrentSize[n7] + (n5 - this.planeCellsCurrentSize[n6]);
                    continue;
                }
                int n8 = n6;
                this.planeCellsCurrentSize[n8] = this.planeCellsCurrentSize[n8] + n4;
                n3 += n4;
                continue;
            }
            return n3;
        }
        return n3;
    }

    public void handle(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n3 == -1 || this.airplaneWorking) {
            return;
        }
        if (n4 >> 16 == 0) {
            int n5 = n4 % 3 == 0 ? 1 : (n4 % 3 > 1 ? 10 : 5);
            n5 = this.fillAirplaneCells(n3, n5);
            int n6 = n3 - 16;
            this.boughtProducts[n6] = this.boughtProducts[n6] + n5;
            this.money += Constants.productData[n3][0] * n5;
            this.getItem(8).setEnabled(true);
        } else if (n4 >> 16 == 1 && this.planeCells[n4 &= 0xFFFF] > 0) {
            this.money -= Constants.productData[this.planeCells[n4]][0] * this.planeCellsCurrentSize[n4];
            this.boughtProducts[this.planeCells[n4] - 16] = 0;
            this.planeCells[n4] = 0;
            this.planeCellsCurrentSize[n4] = 0;
        }
        this.updateSubitemButtonState();
    }

    public void updateProductList() {
        int n = this.currentVisibleItem;
        this.productItemCount = 0;
        int n2 = -1;
        while (++n2 < 5) {
            if (!this.productsData[n2]) continue;
            ++this.productItemCount;
        }
        if (this.productItemCount > 5) {
            while (n + 5 > this.productItemCount) {
                --n;
            }
        } else if (this.productItemCount == 5 && n > 0) {
            n = 0;
        }
        n2 = -n;
        int n3 = 0;
        int n4 = -1;
        while (++n4 < 5) {
            if (this.productsData[n4]) {
                if (n2 >= 0 && n3 < 5 && n3 < this.productItemCount) {
                    this.products[n4].close();
                    this.products[n4].updatePosition(12, 38 + n2 * 33);
                    this.products[n4].open();
                    this.products[n4].setForceHide(false);
                    ++n3;
                } else {
                    this.products[n4].setForceHide(true);
                }
                ++n2;
                continue;
            }
            this.products[n4].setForceHide(true);
        }
        if (this.money == 0) {
            this.getItem(8).setEnabled(false);
        } else {
            this.getItem(8).setEnabled(true);
        }
        if (this.productItemCount == 0) {
            this.refreshFocused = true;
            ++this.selectedItem;
            this.getItem(10).setFocused(true);
        }
    }

    private void updateSubitemButtonState() {
        int n = GameScreen.currentLevelMoney - this.money;
        int n2 = 0;
        int n3 = -1;
        while (++n3 < this.products.length) {
            if (!this.products[n3].m_forceHide) {
                if (Constants.productData[this.products[n3].controlID][0] <= n) {
                    ((TiledButtonControl)this.products[n3].getItem(0)).setEnabled(true);
                } else {
                    ((TiledButtonControl)this.products[n3].getItem(0)).setEnabled(false);
                }
                if (Constants.productData[this.products[n3].controlID][0] * 5 <= n) {
                    ((TiledButtonControl)this.products[n3].getItem(1)).setEnabled(true);
                } else {
                    ((TiledButtonControl)this.products[n3].getItem(1)).setEnabled(false);
                }
                if (Constants.productData[this.products[n3].controlID][0] * 10 <= n) {
                    ((TiledButtonControl)this.products[n3].getItem(2)).setEnabled(true);
                } else {
                    ((TiledButtonControl)this.products[n3].getItem(2)).setEnabled(false);
                }
                if (this.products[n3].getItem((int)0).m_enabled || this.products[n3].getItem((int)1).m_enabled || this.products[n3].getItem((int)2).m_enabled) continue;
                ++n2;
                continue;
            }
            ((TiledButtonControl)this.products[n3].getItem(0)).setEnabled(false);
            ((TiledButtonControl)this.products[n3].getItem(1)).setEnabled(false);
            ((TiledButtonControl)this.products[n3].getItem(2)).setEnabled(false);
        }
        if (this.productItemCount == n2) {
            this.refreshFocused = true;
            ++this.selectedItem;
            this.getItem(10).setFocused(true);
        }
    }

    public void draw(Graphics graphics) {
        int n;
        super.draw(graphics);
        int n2 = 0;
        int n3 = FontManager.getInstance(-1).getFontHeight(1);
        int n4 = -1;
        while (++n4 < 5) {
            graphics.setColor(11099394);
            graphics.fillRoundRect(12, 38 + n4 * 33, 33, 32, 8, 8);
            graphics.setColor(11102466);
            graphics.fillRoundRect(46, 38 + n4 * 33, 181, 32, 8, 8);
            graphics.setColor(5318656);
            graphics.drawRoundRect(12, 38 + n4 * 33, 32, 31, 8, 8);
            graphics.drawRoundRect(46, 38 + n4 * 33, 180, 31, 8, 8);
        }
        FontManager.getInstance(-1).drawString(graphics, 1, "" + FarmContainer.getLocaleString(88), 65, 32 - (6 - n3) / 2, 1);
        FontManager.getInstance(-1).drawString(graphics, 1, "" + FarmContainer.getLocaleString(89), 140, 32 - (6 - n3) / 2, 1);
        n4 = this.productItemCount - 5;
        if (n4 > 0) {
            n2 = 155 - 155 * n4 / this.products.length - 2;
            int n5 = 44 + 155 * this.currentVisibleItem / this.products.length + 1;
            int n6 = 226;
            graphics.setColor(5284854);
            graphics.fillRoundRect(n6, n5, 6, n2, 4, 4);
        }
        Image image = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(this.coinImageID >> 24, this.coinImageID & 0xFFFFFF));
        Image image2 = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(this.cellBackgroundID >> 24, this.cellBackgroundID & 0xFFFFFF));
        int n7 = 48 + image.getWidth() * 2;
        int n8 = 319;
        graphics.drawImage(image, 12, 201 + image.getHeight(), 0);
        FontManager.getInstance(-1).drawString(graphics, 1, "" + this.money, 12 + image.getWidth() * 3 / 2, 201 + image.getHeight() * 2 - (image.getHeight() - FontManager.getInstance(0).getFontHeight(3)) / 2, 1);
        int n9 = 0;
        for (int i = 0; n9 < 5 && i < this.products.length; ++i) {
            if (this.products[i].m_forceHide) continue;
            this.products[i].draw(graphics);
            if (n9 == this.selectedItem - this.currentVisibleItem) {
                n = -1;
                while (++n < 3) {
                    if (n == this.buttonIndex) {
                        this.products[i].getItem(n).setFocused(true);
                        continue;
                    }
                    this.products[i].getItem(n).setFocused(false);
                }
            } else {
                this.products[i].getItem(0).setFocused(false);
                this.products[i].getItem(1).setFocused(false);
                this.products[i].getItem(2).setFocused(false);
            }
            ++n9;
        }
        if (!this.airplaneWorking) {
            n = -1;
            while (++n < this.planeCellsCount) {
                graphics.setColor(0);
                if (this.planeCellsCurrentSize[n] > 0) {
                    if (image2 != null) {
                        graphics.drawImage(image2, this.cellPositions[n][0], this.cellPositions[n][1], 0);
                    }
                    graphics.setColor(65280);
                    int n10 = 17 * this.planeCellsCurrentSize[n] / Constants.productData[this.planeCells[n]][3];
                    graphics.fillRoundRect(this.cellPositions[n][0], this.cellPositions[n][1] + 19 + 3, n10, 4, 4, 4);
                    graphics.setColor(0);
                    graphics.drawRoundRect(this.cellPositions[n][0], this.cellPositions[n][1] + 19 + 3, 17, 4, 4, 4);
                    this.productContent.setFrameToDraw(this.planeCells[n]);
                    this.productContent.updateAnimationPosition(this.cellPositions[n][0], this.cellPositions[n][1]);
                    this.productContent.draw(graphics);
                    continue;
                }
                graphics.setColor(0);
                graphics.drawRoundRect(this.cellPositions[n][0], this.cellPositions[n][1] + 19 + 3, 17, 4, 4, 4);
            }
        }
    }

    public void getNearestPosition() {
        int n = -1;
        int n2 = -1;
        int n3 = 100;
        int n4 = 0;
        int n5 = -1;
        while (++n5 < 5) {
            if (this.products[n5].m_hidden) continue;
            if (this.products[n5].getItem((int)0).m_enabled && Math.abs(this.selectedItem - n5) < n3) {
                n = n4;
                n2 = 0;
                n3 = Math.abs(this.selectedItem - n5);
                int n6 = Math.abs(this.buttonIndex - 0);
                for (int i = 1; i < 3 && this.products[n5].getItem((int)i).m_enabled; ++i) {
                    if (Math.abs(this.buttonIndex - i) >= n6) continue;
                    n6 = Math.abs(this.buttonIndex - i);
                    n2 = i;
                }
            }
            ++n4;
        }
        if (n == -1) {
            this.refreshFocused = true;
            this.selectedItem = this.productItemCount;
            this.getItem(10).setFocused(true);
        } else {
            this.products[this.selectedItem].getItem(this.buttonIndex).setFocused(false);
            this.selectedItem = n;
            this.buttonIndex = n2;
            this.products[this.selectedItem].getItem(this.buttonIndex).setFocused(true);
        }
    }

    public boolean keyPressed(int n) {
        boolean bl = false;
        if (this.popupWindow != null) {
            bl = this.popupWindow.keyPressed(n);
        }
        if (!bl) {
            int n2;
            int n3;
            int n4;
            if (n == 2 && this.buttonIndex > 0) {
                this.products[this.selectedItem].getItem(this.buttonIndex).setFocused(false);
                this.products[this.selectedItem].getItem(--this.buttonIndex).setFocused(true);
            }
            if (n == 3 && this.buttonIndex < 2 && this.products[this.selectedItem].getItem((int)(this.buttonIndex + 1)).m_enabled) {
                this.products[this.selectedItem].getItem(this.buttonIndex).setFocused(false);
                this.products[this.selectedItem].getItem(++this.buttonIndex).setFocused(true);
            }
            if (n == 4) {
                n4 = 0;
                if (this.selectedItem > 0 && !this.sendFocused) {
                    for (n3 = this.selectedItem - 1; n3 >= 0; --n3) {
                        if (!this.products[n3].getItem((int)0).m_enabled) continue;
                        if (this.buttonIndex == 0) {
                            this.selectedItem = n3;
                            n4 = 1;
                            break;
                        }
                        n2 = 0;
                        while (this.products[n3].getItem((int)(n2 + 1)).m_enabled && this.buttonIndex != ++n2) {
                        }
                        this.buttonIndex = n2;
                        this.selectedItem = n3;
                        n4 = 1;
                        break;
                    }
                }
                if (this.refreshFocused && n4 != 0) {
                    this.refreshFocused = false;
                    this.getItem(10).setFocused(false);
                }
                if (this.sendFocused) {
                    this.sendFocused = false;
                    this.getItem(8).setFocused(false);
                    this.refreshFocused = true;
                    this.getItem(10).setFocused(true);
                }
            }
            if (n == 5) {
                if (this.selectedItem < this.productItemCount - 1) {
                    n3 = 0;
                    for (n4 = this.selectedItem + 1; n4 < this.productItemCount; ++n4) {
                        if (!this.products[n4].getItem((int)0).m_enabled) continue;
                        if (this.buttonIndex == 0) {
                            this.selectedItem = n4;
                            n3 = 1;
                            break;
                        }
                        n2 = 0;
                        while (this.products[n4].getItem((int)(n2 + 1)).m_enabled && this.buttonIndex != ++n2) {
                        }
                        this.buttonIndex = n2;
                        this.selectedItem = n4;
                        n3 = 1;
                        break;
                    }
                    if (n3 == 0) {
                        this.refreshFocused = true;
                        ++this.selectedItem;
                        this.getItem(10).setFocused(true);
                    }
                } else if (!this.refreshFocused && !this.sendFocused) {
                    this.refreshFocused = true;
                    ++this.selectedItem;
                    this.getItem(10).setFocused(true);
                } else if (!this.sendFocused && this.getItem((int)8).m_enabled) {
                    this.refreshFocused = false;
                    this.getItem(10).setFocused(false);
                    this.sendFocused = true;
                    this.getItem(8).setFocused(true);
                }
            }
        }
        return bl;
    }

    public boolean keyReleased(int n) {
        boolean bl = false;
        if (this.popupWindow != null) {
            bl = this.popupWindow.keyReleased(n);
        }
        if (!bl) {
            if (n == 6) {
                if (this.refreshFocused) {
                    int n2 = -1;
                    while (++n2 < this.planeCellsCount) {
                        if (this.planeCells[n2] <= 0) continue;
                        this.money -= Constants.productData[this.planeCells[n2]][0] * this.planeCellsCurrentSize[n2];
                        this.boughtProducts[this.planeCells[n2] - 16] = 0;
                        this.planeCells[n2] = 0;
                        this.planeCellsCurrentSize[n2] = 0;
                    }
                    if (this.money == 0) {
                        this.getItem(8).setEnabled(false);
                    }
                    this.updateSubitemButtonState();
                } else if (this.sendFocused && this.getItem((int)8).m_enabled) {
                    this.getItem(8).action();
                } else if (!this.products[this.selectedItem].m_forceHide) {
                    this.products[this.selectedItem].getItem(this.buttonIndex).action();
                    this.getNearestPosition();
                }
            }
            if (n == 1) {
                this.getItem(9).action();
            }
        }
        return bl;
    }
}

