/*
 * Decompiled with CFR 0.152.
 */
package com.spl.j2me.Animation;

import com.spl.j2me.Animation.TiledAnimation;
import com.spl.j2me.GUIIC.ControlItem;
import com.spl.j2me.RM.ResourceManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AnimatedBackground
extends ControlItem {
    private TiledAnimation[] animations;
    private boolean enableAnimation;
    private int[] tiled_backgroundID;
    private int[][] tile_map;
    private int backgroundID;
    private int backgroundWidth;
    private int backgroundHeight;
    private int animationMax;
    private int animationCount;

    public AnimatedBackground(int n, int n2) {
        super(n);
        this.animationMax = n2;
        this.animations = new TiledAnimation[this.animationMax];
        this.animationCount = 0;
        this.enableAnimation = true;
    }

    public void setBackground(int n) {
        this.backgroundID = n;
        Image image = (Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(this.backgroundID >> 24, this.backgroundID & 0xFFFFFF));
        this.backgroundWidth = image.getWidth();
        this.backgroundHeight = image.getHeight();
    }

    public void setTiledBackground(int[] nArray, int[][] nArray2) {
        this.tiled_backgroundID = nArray;
        this.tile_map = nArray2;
    }

    public void delete() {
    }

    public void open() {
    }

    public void close() {
        this.tiled_backgroundID = null;
        this.tile_map = null;
    }

    public void draw(Graphics graphics) {
        int n;
        int n2 = ResourceManager.getCachedID(this.backgroundID >> 24, this.backgroundID & 0xFFFFFF);
        Image image = (Image)ResourceManager.resCache.elementAt(n2);
        if (image != null) {
            if (this.backgroundHeight != this.height || this.backgroundWidth != this.width) {
                n = this.height / this.backgroundHeight + 1;
                int n3 = this.width / this.backgroundWidth + 1;
                int n4 = -1;
                while (++n4 < n) {
                    int n5 = -1;
                    while (++n5 < n3) {
                        graphics.drawImage(image, n5 * this.backgroundWidth, n4 * this.backgroundHeight, 0);
                    }
                }
            } else {
                graphics.drawImage(image, 0, 0, 0);
            }
        }
        if (this.tiled_backgroundID != null) {
            n = -1;
            while (++n < this.tile_map.length) {
                graphics.drawImage((Image)ResourceManager.resCache.elementAt(ResourceManager.getCachedID(this.tiled_backgroundID[n] >> 24, this.tiled_backgroundID[n] & 0xFFFFFF)), this.tile_map[n][0], this.tile_map[n][1], 0);
            }
        }
        if (this.enableAnimation) {
            n = -1;
            while (++n < this.animationCount) {
                this.animations[n].draw(graphics);
            }
        }
    }

    public boolean pointerPressed(int n, int n2) {
        return false;
    }

    public boolean pointerReleased(int n, int n2) {
        return false;
    }

    public boolean pointerDragged(int n, int n2) {
        return false;
    }

    public boolean keyPressed(int n) {
        return false;
    }

    public boolean keyReleased(int n) {
        return false;
    }

    public boolean keyRepeated(int n) {
        return false;
    }

    public void animationTick(long l) {
        if (this.enableAnimation) {
            int n = -1;
            while (++n < this.animationCount) {
                this.animations[n].updateAnimation(l);
            }
        }
    }

    public void addAnimation(TiledAnimation tiledAnimation) {
        if (this.animationCount < this.animationMax) {
            this.animations[this.animationCount++] = tiledAnimation;
        }
    }

    public void enableAnimation(boolean bl) {
        this.enableAnimation = bl;
    }

    public void removeAllAnimations() {
        int n = -1;
        while (++n < this.animationCount) {
            this.animations[n] = null;
        }
        this.animations = null;
        this.animationCount = -1;
    }
}

